<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs УТ6 ns1 sig" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10"
                xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/АДВ-2/2023-01-10">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template name="inc">
        <xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:АДВ-2"/>
        <xsl:variable name="vCancel" select="/ns1:ЭДСФР/ns1:АДВ-2/ns1:ИзменившиесяДанные/ns1:Отмены"/>
        <div class="afSmallWrap12 sfrAfADV2">
            <table class="afTable100">
                <tbody>
                    <tr>
                        <td class="afTable15 afCenter">
                            <span class="afUnderline">Форма АДВ-2</span>
                        </td>
                        <td>&#160;</td>
                        <td class="afTable15 afCenter">Код по ОКУД</td>
                        <td class="afTable15 afTable">&#160;</td>
                    </tr>
                </tbody>
            </table>
            <p class="afInterval"/>
            <h1 class="afHeader">Заявление об изменении анкетных данных зарегистрированного лица,<br/>содержащихся в
                индивидуальном лицевом счете
            </h1>
            <p class="afInterval"/>
            <p class="afSubscript afItalic">Заполняется зарегистрированным лицом печатными буквами</p>
                <div class="afRow">
                    <div class="afC">Страховой номер индивидуального лицевого счёта</div>
                    <div class="afMarginLeft250 afValue ">
                        <span class="afUnderline">
                            <xsl:value-of select="substring($vForm/УТ6:СНИЛС, 1, 3)"/>
                        </span>
                        -
                        <span class="afUnderline">
                            <xsl:value-of select="substring($vForm/УТ6:СНИЛС, 5, 3)"/>
                        </span>
                        -
                        <span class="afUnderline">
                            <xsl:value-of select="substring($vForm/УТ6:СНИЛС, 9, 3)"/>
                        </span>&#160;<span class="afUnderline">
                        <xsl:value-of select="substring($vForm/УТ6:СНИЛС, 13, 2)"/>
                    </span>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Данные, указанные в документе, подтверждающем регистрацию в системе индивидуального
                        (персонифицированного) учета
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Фамилия</div>
                    <div class="afMarginLeft110 afValue afUnderline">
                        <xsl:value-of select="$vForm/УТ6:ФИО/УТ6:Фамилия"/>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Имя</div>
                    <div class="afMarginLeft110 afValue afUnderline">
                        <xsl:value-of select="$vForm/УТ6:ФИО/УТ6:Имя"/>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Отчество (при наличии)</div>
                    <div class="afMarginLeft220 afValue afUnderline">
                        <xsl:value-of select="$vForm/УТ6:ФИО/УТ6:Отчество"/>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Новые анкетные данные (указать только изменившиеся данные)</div>
                </div>
                <div class="afRow">
                    <div class="afC">Фамилия</div>
                    <div class="afMarginLeft110 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыФамилии and $vCancel/ns1:ПризнакОтменыФамилии ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:ФИО/УТ6:Фамилия"/>&#160;
                            </xsl:otherwise>
                        </xsl:choose>

                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Имя</div>
                    <div class="afMarginLeft110 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыИмени and $vCancel/ns1:ПризнакОтменыИмени ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:ФИО/УТ6:Имя"/>&#160;
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Отчество (при наличии)</div>
                    <div class="afMarginLeft220 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыОтчества and $vCancel/ns1:ПризнакОтменыОтчества ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:ФИО/УТ6:Отчество"/>&#160;
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Пол</div>
                    <div class="afCol-1-8">&#160;</div>
                    <div class="afValue afCenterBlock afUnderline afCol-1-8">
						<xsl:call-template name="УТ6:SexStr">
							<xsl:with-param name="pSex" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Пол"/>
						</xsl:call-template>&#160;
                    </div>
                    <div class="afMarginLeft150">(м / ж)</div>
                </div>
                <xsl:variable name="vFormD" select="/ns1:ЭДСФР/ns1:АДВ-2/ns1:ИзменившиесяДанные/ns1:Данные"/>
                <div class="afRow">
                    <div class="afC ">Дата рождения</div>
                    <div class="afCol-3">&#160;</div>
                    <div class="afUnderline afCol-1-5">
                        <span class="afValue">
                            <xsl:choose>
                                <xsl:when test="$vFormD/УТ6:ДатаРождения">
                                    <xsl:call-template name="Date2Text">
                                        <xsl:with-param name="pDate" select="$vFormD/УТ6:ДатаРождения"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:when test="$vFormD/УТ6:ДатаРожденияОсобая">
                                    <xsl:choose>
                                        <xsl:when test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:День">
                                            "<xsl:value-of select="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:День"/>"&#160;&#160;
                                        </xsl:when>
                                        <xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
                                    </xsl:choose>
                                    <xsl:choose>
                                        <xsl:when test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц">
                                            <xsl:choose>
                                                <xsl:when test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:День">
                                                    <xsl:choose>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '01' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '1'">
                                                            января
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '02' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '2'">
                                                            февраля
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '03' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '3'">
                                                            марта
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '04' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '4'">
                                                            апреля
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '05' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '5'">
                                                            мая
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '06' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '6'">
                                                            июня
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '07' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '7'">
                                                            июля
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '08' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '8'">
                                                            августа
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '09' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '9'">
                                                            сентября
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '10'">
                                                            октября
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '11'">
                                                            ноября
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '12'">
                                                            декабря
                                                        </xsl:when>
                                                    </xsl:choose>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:choose>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '01' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '1'">
                                                            январь
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '02' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '2'">
                                                            февраль
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '03' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '3'">
                                                            март
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '04' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '4'">
                                                            апрель
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '05' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '5'">
                                                            май
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '06' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '6'">
                                                            июнь
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '07' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '7'">
                                                            июль
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '08' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '8'">
                                                            август
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '09' or $vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '9'">
                                                            сентябрь
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '10'">
                                                            октябрь
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '11'">
                                                            ноябрь
                                                        </xsl:when>
                                                        <xsl:when
                                                                test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '12'">
                                                            декабрь
                                                        </xsl:when>
                                                    </xsl:choose>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:when>
                                        <xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
                                    </xsl:choose>
                                    <xsl:choose>
                                        <xsl:when test="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Год">
                                            &#160;&#160;<xsl:value-of select="$vFormD/УТ6:ДатаРожденияОсобая/УТ6:Год"/>
                                        </xsl:when>
                                        <xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
                            </xsl:choose>
                        </span>
                    </div>
                    <div>года</div>
                </div>
                <div class="afRow">
                    <div class="afC">Место рождения:</div>
                </div>
               
                <div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">населенный пункт </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:МестоРождения/УТ6:Город"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">район </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:МестоРождения/УТ6:Район"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
						
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">регион (область, край, республика, ...) </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:МестоРождения/УТ6:Регион"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
						
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">страна </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:МестоРождения/УТ6:Страна"/>&#160;
							</xsl:otherwise>
						</xsl:choose>

					</div>
				</div>
                
               
                <div class="afRow">
                    <div class="afC">Гражданство</div>
                    <div class="afMarginLeft110 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Гражданство/УТ6:Тип = '1'">
                                РОССИЯ
                            </xsl:when>
                            <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Гражданство/УТ6:Тип = '3'">Лицо
                                без гражданства
                            </xsl:when>
                            <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Гражданство/УТ6:Тип = '2'">
                                <xsl:choose>
                                    <xsl:when
                                            test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Гражданство/УТ6:Государство">
                                        <xsl:value-of
                                                select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Гражданство/УТ6:Государство/УТ6:Наименование"/>
                                    </xsl:when>
                                    <xsl:otherwise>Иностранный гражданин</xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>&#160;</xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Адрес постоянного <br/> места жительства</div>
                    <div class="afMarginLeft130 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыАдресаРегистрации and $vCancel/ns1:ПризнакОтменыАдресаРегистрации ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
                                    <xsl:when
                                            test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресРегистрации/УТ6:Неструктурированный">
                                        <xsl:value-of
                                                select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресРегистрации/УТ6:Неструктурированный"/>
                                    </xsl:when>
                                    <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресРегистрации/УТ6:Иностранный">
										<xsl:call-template name="УТ6:AddressForeignStr">
											<xsl:with-param name="pAddress" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресРегистрации"/>
										</xsl:call-template>
									</xsl:when>
                                    <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресРегистрации">
                                        <xsl:call-template name="УТ6:AddressStr">
                                            <xsl:with-param name="pAddress"
                                                            select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресРегистрации"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:otherwise>&#160;</xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Адрес места пребывания </div>
                    <div class="afMarginLeft180 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыАдресаФактического and $vCancel/ns1:ПризнакОтменыАдресаФактического ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
									<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресФактический/УТ6:Иностранный">
										<xsl:call-template name="УТ6:AddressForeignStr">
											<xsl:with-param name="pAddress" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресФактический"/>
										</xsl:call-template>
									</xsl:when>
                                    <xsl:when
                                            test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресФактический/УТ6:Неструктурированный">
                                        <xsl:value-of
                                                select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресФактический/УТ6:Неструктурированный"/>
                                    </xsl:when>
                                    <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресФактический">
                                        <xsl:call-template name="УТ6:AddressStr">
                                            <xsl:with-param name="pAddress"
                                                            select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:АдресФактический"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:otherwise>&#160;</xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <p class="afSubscript afCenter afItalic afMarginLeft50">(заполнять при отличии от адреса постоянного места жительства)
                </p>
                <div class="afRow">
                    <div class="afC">Телефоны</div>
                    <div class="afMarginLeft110 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Телефоны">
                                <xsl:for-each
                                        select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ6:Телефоны/УТ6:Телефон">
                                    <xsl:value-of select="."/>
                                    <xsl:choose>
                                        <xsl:when
                                                test="count(preceding-sibling::УТ6:Телефон)+1 &lt; count(//УТ6:Телефон)">
                                            ;
                                        </xsl:when>
                                        <xsl:otherwise>&#160;</xsl:otherwise>
                                    </xsl:choose>
                                </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>&#160;</xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <p class="afSubscript afCenter afItalic afMarginLeft50">(домашний и/или рабочий)</p>
                <div class="afRow">
                    <div class="afC">Документ, удостоверяющий личность</div>
                </div>
                <div class="afRow">
                    <div class="afC">Вид документа</div>
                    <div class="afMarginLeft160 afValue afUnderline">
                        &#160;
<!--                        
                        <xsl:choose>
                            <xsl:when test="$vForm/ns1:УдостоверяющийДокумент/УТ6:Тип = 'ПРОЧЕЕ'">
                                <xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ6:Наименование"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ6:Тип"/>
                            </xsl:otherwise>
                        </xsl:choose>
-->
						<xsl:call-template name="УТ6:CodDocumentStr">
							<xsl:with-param name="pCodDocument" select="$vForm/ns1:УдостоверяющийДокумент"/>	
						</xsl:call-template>	
                    </div>
                </div>
                <p class="afSubscript afCenter afItalic afMarginLeft50">(указать название документа: паспорт,
                    удостоверение личности или другие документы, удостоверяющие личность)
                </p>
                <div class="afRow">
                    <div class="afC">Серия, номер</div>
                    <div class="afMarginLeft160 afValue afUnderline">
                        <xsl:if test="$vForm/ns1:УдостоверяющийДокумент/УТ6:Серия">
                            <xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ6:Серия"/>&#160;
                        </xsl:if>&#160;
                        <xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ6:Номер"/>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Дата выдачи</div>
                    <div class="afCol-1-10-1">&#160;</div>
                    <div class="afValue afCenterBlock afUnderline afCol-1-5">
                        <xsl:call-template name="Date2Text">
                            <xsl:with-param name="pDate" select="$vForm/ns1:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
                        </xsl:call-template>
                    </div>
                    <div>года</div>
                </div>
                <div class="afRow">
                    <div class="afC">Кем выдан</div>
                    <div class="afMarginLeft160 afValue afUnderline">&#160;
                        <xsl:if test="$vForm/ns1:УдостоверяющийДокумент/УТ6:КемВыдан">
                            <xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ6:КемВыдан"/>
                        </xsl:if>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Реквизиты акта гражданского состояния о рождении</div>
                </div>
                <div class="afRow">
                    <div class="afC">Номер актовой записи о рождении</div>
                    <div class="afMarginLeft300 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыАктовойЗаписи and $vCancel/ns1:ПризнакОтменыАктовойЗаписи ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:if test="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ6:Номер">
                                    <xsl:value-of select="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ6:Номер"/>
                                </xsl:if>&#160;
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Дата составления актовой записи о рождении</div>
                    <div class="afCol-1-20">&#160;</div>

                    <xsl:choose>
                        <xsl:when
                                test="$vCancel/ns1:ПризнакОтменыАктовойЗаписи and $vCancel/ns1:ПризнакОтменыАктовойЗаписи ='ОТМЕНЕНО'">
                            <div class="afCol-1-3">
                                "____" _________________
                            </div>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ6:Дата">
                                    <div class="afValue afCenterBlock afUnderline afCol-1-5">
                                        <xsl:call-template name="Date2Text">
                                            <xsl:with-param name="pDate"
                                                            select="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ6:Дата"/>
                                        </xsl:call-template>&#160;
                                    </div>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div class="afCol-1-3">
                                        "____" _________________
                                    </div>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
                    <div>года</div>
                </div>
                <div class="afRow">
                    <div class="afC">Наименование органа, которым произведена государственная регистрация акта о
                        рождении
                    </div>
                </div>
                <div class="afRow">
                    <div class="afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыАктовойЗаписи and $vCancel/ns1:ПризнакОтменыАктовойЗаписи ='ОТМЕНЕНО'">
                                &#160;
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:if test="$vForm/ns1:АктоваяЗапись/УТ6:Наименование">
                                    <xsl:value-of select="$vForm/ns1:АктоваяЗапись/УТ6:Наименование"/>
                                </xsl:if>&#160;
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
                <div class="afRow">
                    <div class="afC">Идентификационный номер налогоплательщика (при наличии)</div>
                    <div class="afMarginLeft390 afValue afUnderline">
                        <xsl:choose>
                            <xsl:when
                                    test="$vCancel/ns1:ПризнакОтменыИНН and $vCancel/ns1:ПризнакОтменыИНН ='ОТМЕНЕНО'">
                                &#160;(Отменено)
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:if test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/ns1:ИНН">
                                    <xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/ns1:ИНН"/>
                                </xsl:if>&#160;
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
          
            <div class="afRow">
                <div class="afCol-1-2 afCenterBlock">Дата заполнения</div>
                <div class="afCol-1-2 afCenterBlock">Подпись зарегистрированного лица (представителя)</div>
            </div>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afCol-1-2 afCenterBlock">
                    <span class="afUnderline">
                        <xsl:call-template name="Date2Text">
                            <xsl:with-param name="pDate" select="$vForm/ns1:ДатаЗаполнения"/>
                        </xsl:call-template>
                    </span>
                    года&#160;
                </div>
                <div class="afCol-1-2 afCenterBlock">__________________________________</div>
            </div>
            <div class="afNoBreakInside">
                <xsl:if test="ns1:ЭДСФР/sig:SignInfo">
                    <xsl:call-template name="PrintSignInfo">
                        <xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
                    </xsl:call-template>
                </xsl:if>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
