<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ8 СЗВК8 ВС8 ns1 sig" version="1.0" xmlns:УТ8="http://пф.рф/УТ/2025-01-01" xmlns:СЗВК8="http://пф.рф/ВС/СЗВК/типы/2025-01-01" xmlns:ВС8="http://пф.рф/ВС/типы/2025-01-01" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/СЗВ-К/2025-05-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	 <xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2025-01-01.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:СЗВ-К"/>
		<div class="afWrap sfrAfSZV-K">
			<xsl:for-each select="$vForm/ns1:ЗЛ">
				<p class="afInterval"/>
				<div class="afRow afCenter">
					<div class="afRight-1-3">
						<div class="afC afSmallSize">
							Приложение № 6<br/>
	к приказу Фонда пенсионного и социального страхования Российской Федерации<br/>
						от 30 октября 2023 г. № 2153
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-1-5 afLeftAlign">
						<span class="afUnderline">Форма СЗВ-К</span>
					</div>
					<div class="afCol-4-5">
						<div class="afTable10 afFrame afTableRight">&#160;</div>
						<div class="afTable20 afCenterBlock afTableRight">Код по ОКУД</div>
					</div>
				</div>
				<p class="afInterval"/>
				<h1 class="afHeader">Сведения о трудовом стаже застрахованного лица за период
                    до регистрации в системе обязательного пенсионного страхования</h1>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afC afValue afMarginLeft20">Тип сведений:</div>
					<div class="afCol-1-4">
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ИСХД' or text() = 'ИСХОДНАЯ']">V</xsl:if>
							</div>
						</div>
						<div class="afCol-1-2 afPadding">
							<div class="afC">Исходная</div>
						</div>
					</div>
					<div class="afCol-1-4">
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="$vForm/ns1:ТипСведений[text() = 'КОРР' or text() = 'КОРРЕКТИРУЮЩАЯ']">V</xsl:if>
							</div>
						</div>
						<div class="afCol-1-2 afPadding">
							<div class="afC">Корректирующая</div>
						</div>
					</div>
					<div class="afCol-1-4">
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ОТМН' or text() = 'ОТМЕНЯЮЩАЯ']">V</xsl:if>
							</div>
						</div>
						<div class="afCol-1-2 afPadding">
							<div class="afC">Отменяющая</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC afValue">Сведения о страхователе:</div>
				</div>
				<div class="afRow">
					<div class="afC">Регистрационный номер СФР</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Страхователь/УТ8:РегНомер"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">ИНН<sup class="afFootnote">1</sup>
					</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Страхователь/УТ8:ИНН"/>
						</p>
					</div>
					<div class="afC">КПП<sup class="afFootnote">2</sup>
					</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Страхователь/УТ8:КПП"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Наименование организации (краткое)</div>
					<p class="afValue afMarginLeft250 afUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Страхователь/УТ8:Наименование"/>
					</p>
				</div>
				<div class="afRow">
					<div class="afC afValue">Сведения о застрахованном лице:</div>
				</div>
				<div class="afRow">
					<div class="afC">Страховой номер индивидуального лицевого счета</div>
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ8:СНИЛС"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Фамилия</div>
					<div class="afCol-1-2">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ8:ФИО/УТ8:Фамилия"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afCol-1-2">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ8:ФИО/УТ8:Имя"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии)</div>
					<div class="afCol-1-2">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="УТ8:ФИО/УТ8:Отчество"/>
						</p>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата рождения
						<span class="afUnderline">
							<xsl:if test="УТ8:ДатаРождения">
								<xsl:call-template name="Date2Text">
									<xsl:with-param name="pDate" select="УТ8:ДатаРождения"/>
									<xsl:with-param name="style" select="1"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="УТ8:ДатаРожденияОсобая">
								<xsl:call-template name="УТ8:DateSpecialStr">
									<xsl:with-param name="pDate" select="УТ8:ДатаРожденияОсобая"/>
								</xsl:call-template>
							</xsl:if>
						</span> года
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Территориальные условия проживания на 31.12.2001</div>
					<div class="afMarginLeft200">
						<div class="afCol-1-5 afValue afUnderlinedAlignLeftPadding">
							<xsl:value-of select="СЗВК8:ТУНа31.12.2001/СЗВК8:Основание"/>&#160;
							<xsl:value-of select="СЗВК8:ТУНа31.12.2001/СЗВК8:Коэффициент"/>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Республики Крым или на территории города федерального значения Севастополя по состоянию на 18 марта 2014 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияКрым[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Донецкой Народной Республики, Луганской Народной Республики, Запорожской области, Херсонской области по состоянию на 30 сентября 2022 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияДНРЛНРЗОХО[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Донецкой Народной Республики или Луганской Народной Республики в период с                    11 мая 2014 года по 29 сентября 2022 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияДНРЛНР[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">
						<div class="afCol-9-10">Факт постоянного проживания на территории Запорожской области или Херсонской области в период с 24 февраля по 29 сентября 2022 года</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="ns1:ФактПроживанияЗОХО[text() = '1' or text() = 'true']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afValue afC">Периоды трудовой или иной общественно полезной
                        деятельности</div>
				</div>
				<xsl:for-each select="ns1:ПериодДеятельности">
					<xsl:variable name="pos3" select="position()"/>
					<div class="afNoFloat afNoBreakInside">
						<div class="afRow">
							<div class="afCol-1-10">
								<p>
									<xsl:value-of select="$pos3"/>.</p>
							</div>
							<div class="afC">Наименование организации</div>
							<div class="afCol-2-3 afValue afUnderlinedAlignLeftPadding">
								<xsl:value-of select="ns1:Организация"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-1-10">&#160;</div>
							<div class="afC">Вид деятельности (код)</div>
							<div class="afCol-2-3 afValue afUnderlinedAlignLeftPadding">
								<xsl:value-of select="ns1:ВидДеятельности"/>
							</div>
						</div>
						<table class="afTable afNoBreakInside afSmallSize">
							<tr>
								<td rowspan="2" class="afCenter">№ п/п</td>
								<td rowspan="2" class="afCenter">Начало периода (дд.мм.гггг)</td>
								<td rowspan="2" class="afCenter">Конец периода (дд.мм.гггг)</td>
								<td rowspan="2" class="afCenter">Территориальные условия (код)</td>
								<td rowspan="2" class="afCenter">Особые условия труда (код)</td>
								<td colspan="2" class="afCenter">Исчисляемый страховой (трудовой) стаж</td>
								<td colspan="2" class="afCenter">Выслуга лет</td>
							</tr>
							<tr>
								<td class="afCenter">основание (код)</td>
								<td class="afCenter">дополнительные сведения</td>
								<td class="afCenter">основание (код)</td>
								<td class="afCenter">дополнительные сведения</td>
							</tr>
							<xsl:for-each select="ns1:ПериодыРаботы">
								<xsl:variable name="pos1" select="position()"/>
								<tr>
									<td>
										<xsl:value-of select="$pos1"/>
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="Date2GOST">
											<xsl:with-param name="pDate" select="ns1:Период/УТ8:С"/>
										</xsl:call-template>
									
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="Date2GOST">
											<xsl:with-param name="pDate" select="ns1:Период/УТ8:По"/>
										</xsl:call-template>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ТУ/СЗВК8:Основание">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ТУ/СЗВК8:Основание"/>,&#160; <xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ТУ/СЗВК8:Коэффициент"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ОУТ/СЗВК8:Код">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ОУТ/СЗВК8:Код"/>
										</xsl:if>
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ОУТ/СЗВК8:ПозицияСписка"><br/>
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ОУТ/СЗВК8:ПозицияСписка"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ИС/СЗВК8:Основание">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ИС/СЗВК8:Основание"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:call-template name="ProductionStr">
											<xsl:with-param name="pProduction" select="ns1:ЛьготныйСтаж[1]/СЗВК8:ИС"/>
										</xsl:call-template>
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ДопСведенияИС">,&#160;
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ДопСведенияИС"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ/СЗВК8:Основание">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ/СЗВК8:Основание"/>
										</xsl:if>
									</td>
									<td class="afValue afCenter">
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ/СЗВК8:КодИсчисления">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ/СЗВК8:КодИсчисления"/>&#160;
										</xsl:if>
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ">
											<xsl:call-template name="ProductionStr">
												<xsl:with-param name="pProduction" select="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ"/>
											</xsl:call-template>&#160;
										</xsl:if>
										<xsl:if test="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ/СЗВК8:ДоляСтавки">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ВЛ/СЗВК8:ДоляСтавки"/>
										</xsl:if>
									</td>
								</tr>								
								
								<tr>
									<td colspan="9">(профессия или должность) <span class="afValue">
											<xsl:value-of select="ns1:ЛьготныйСтаж[1]/СЗВК8:ПрофессияДолжность"/>
										</span>
									</td>
								</tr>
								
								<xsl:if test="count(ns1:ЛьготныйСтаж) > '1'">
									<xsl:for-each select="ns1:ЛьготныйСтаж">
										<xsl:if test="position() > 1">
										<tr>
											<td>
												<xsl:value-of select="$pos1"/>.<xsl:value-of select="position() - 1"/>
											</td>
											<td class="afValue afCenter"/>
											<td class="afValue afCenter"/>
											<td class="afValue afCenter">
												<xsl:if test="СЗВК8:ТУ/СЗВК8:Основание">
													<xsl:value-of select="СЗВК8:ТУ/СЗВК8:Основание"/>,&#160; <xsl:value-of select="СЗВК8:ТУ/СЗВК8:Коэффициент"/>
												</xsl:if>
											</td>
											<td class="afValue afCenter">
												<xsl:if test="СЗВК8:ОУТ/СЗВК8:Код">
													<xsl:value-of select="СЗВК8:ОУТ/СЗВК8:Код"/>
												</xsl:if>
												<xsl:if test="СЗВК8:ОУТ/СЗВК8:ПозицияСписка">
													<br/>
													<xsl:value-of select="СЗВК8:ОУТ/СЗВК8:ПозицияСписка"/>	
												</xsl:if>
											</td>
											<td class="afValue afCenter">
												<xsl:if test="СЗВК8:ИС/СЗВК8:Основание">
													<xsl:value-of select="СЗВК8:ИС/СЗВК8:Основание"/>
												</xsl:if>
											</td>
											<td class="afValue afCenter">
												<xsl:call-template name="ProductionStr">
													<xsl:with-param name="pProduction" select="СЗВК8:ИС"/>
												</xsl:call-template>
												
											</td>
											<td class="afValue afCenter">
												<xsl:if test="СЗВК8:ВЛ/СЗВК8:Основание">
													<xsl:value-of select="СЗВК8:ВЛ/СЗВК8:Основание"/>
												</xsl:if>
											</td>
											<td class="afValue afCenter">
												<xsl:if test="СЗВК8:ВЛ/СЗВК8:КодИсчисления"><xsl:value-of select="СЗВК8:ВЛ/СЗВК8:КодИсчисления"/>,&#160;</xsl:if>
											
												<xsl:call-template name="ProductionStr">
													<xsl:with-param name="pProduction" select="СЗВК8:ВЛ"/>
												</xsl:call-template>
												
												<xsl:if test="ns1:ЛьготныйСтаж/СЗВК8:ДопСведенияИС">,&#160;
													<xsl:value-of select="ns1:ЛьготныйСтаж/СЗВК8:ДопСведенияИС"/>
												</xsl:if>
												<xsl:if test="СЗВК8:ВЛ/СЗВК8:ДоляСтавки">,&#160;<xsl:value-of select="СЗВК8:ВЛ/СЗВК8:ДоляСтавки"/></xsl:if>
											</td>
										</tr>								
										<tr>
											<td colspan="9">(профессия или должность) <span class="afValue">
													<xsl:value-of select="СЗВК8:ПрофессияДолжность"/>
												</span>
											</td>
										</tr>
										</xsl:if>
									</xsl:for-each>
								</xsl:if>
							</xsl:for-each>
						</table>
					</div>
				</xsl:for-each>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afSign">
						<div class="afPadding afCenter">
							<p class="afCenter">Лист</p>
						</div>
						<div class="afPadding afCenter">
							<p class="afCenter">Сведения представлены на
                            &#160;&#160;&#160;&#160;&#160;&#160; листах</p>
						</div>
					</div>
				</div>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afRaw">
						<div class="afCol-4-10">
							<p class="afValue afCenter afUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:Руководитель/УТ8:Должность"/>
							</p>
							<p class="afCenter afSubscript">Наименование должности руководителя</p>
						</div>
						<div class="afCol-1-5">
							<p class="afBlankUnderlinedBlock"/>
							<p class="afCenter afSubscript">Подпись</p>
						</div>
						<div class="afCol-4-10">
							<p class="afUnderlinedBlock afCenter afValue">
								<xsl:call-template name="УТ8:NameStr">
									<xsl:with-param name="pName" select="$vForm/ns1:Руководитель/УТ8:ФИО"/>
								</xsl:call-template> 
							</p>
							<p class="afCenter afSubscript">Расшифровка подписи</p>
						</div>
					</div>
				</div>
				
				<p class="afInterval"/>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afSign">
						<div class="afPadding afCenter">
							<p class="afValue afUnderlinedBlock">
								<xsl:call-template name="Date2GOST">
									<xsl:with-param name="pDate" select="$vForm/ns1:ДатаСоставления"/>
								</xsl:call-template>
							</p>
							<p class="afCenter afSubscript">Дата</p>
						</div>
						<div class="afPadding afCenter">
							<p>М.П. (при наличии)</p>
						</div>
						<div class="afPadding afCenter"> </div>
					</div>
				</div>
				<p class="afInterval"/>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
					<p class="afInterval"/>
					<div class="afSign">
						<div class="afPadding afCenter">
							<p class="afValue">
								<p class="afCenter">Со сведениями о трудовом стаже ознакомлен</p>
							</p>
						</div>
						<div class="afPadding afCenter">
							<p class="afValue afUnderlinedBlock"/>
							<p class="afCenter afSubscript">Подпись застрахованного лица</p>
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<xsl:if test="/ns1:ЭДСФР/sig:SignInfo">
						<xsl:call-template name="PrintSignInfo">
							<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
						</xsl:call-template>
					</xsl:if>
				</div>
				<p class="afInterval"/>
				
				<p>_____________________________________________</p>
				<p class="afFootnote">
					<sup>1</sup> Идентификационный номер налогоплательщика.</p>
				<p class="afFootnote">
					<sup>2</sup> Код причины постановки на учет по месту нахождения организации.</p>
				
				<p class="afNextPageAfter"/>
			</xsl:for-each>
		</div>
	</xsl:template>
	 <xsl:template name="ProductionStr">
        <xsl:param name="pProduction"/>
        <xsl:choose>
			<xsl:when test="$pProduction//ВС8:ВыработкаВчасах">
				<xsl:if test="$pProduction//ВС8:ВыработкаВчасах/ВС8:Часы">
					<xsl:value-of select="$pProduction//ВС8:ВыработкаВчасах/ВС8:Часы"/> ч.&#160;</xsl:if>
				<xsl:if test="$pProduction/ВС8:ВыработкаВчасах/ВС8:Минуты">
					<xsl:value-of select="$pProduction/ВС8:ВыработкаВчасах/ВС8:Минуты"/> мин.&#160;</xsl:if>
			</xsl:when>
			<xsl:when test="$pProduction/ВС8:ВыработкаКалендарная">
				<xsl:if test="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеГоды">
					<xsl:value-of select="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеГоды"/>г. (лет)&#160;</xsl:if>
				<xsl:if test="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеМесяцы">
					<xsl:value-of select="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеМесяцы"/> мес.&#160;</xsl:if>
				<xsl:if test="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеДни">
					<xsl:value-of select="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеДни"/> д.&#160; </xsl:if>
			</xsl:when>
		</xsl:choose>
    </xsl:template>
</xsl:stylesheet>
