<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1 sig ВС ИС6" version="1.0"
    xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ИС6="http://пф.рф/ВС/ИС/2023-01-10"
    xmlns:ВС="http://пф.рф/ВС/типы/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10"
    xmlns:ns1="http://пф.рф/СЗВ-СТАЖ/2023-01-10">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
    <xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template name="inc">
        <div class="afWrap sfrAfSZV-STAJ">
            <p class="afRight-1-4">
                УТВЕРЖДЕНА<br/>
                постановлением Правления СФР<br/>
                от 6 декабря 2018 г. № 507п
            </p>
            <p class="afInterval"/>
            <p class="afP">Форма ОДВ-1</p>
            <p class="afInterval"/>
            <p class="afValue afP">Сведения по страхователю, передаваемые в СФР для ведения индивидуального (персонифицированного) учета</p>
            <p class="afInterval"/>
            <p class="afValue afP">1. Реквизиты страхователя, передающего документы:</p>
            <p class="afInterval"/>
             <xsl:variable name="RegNum" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:РегНомер"/>
            <div class="afRow">
				<div class="afC">Регистрационный номер в СФР</div> 
				<div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 3, 1)" /></td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 5, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 6, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 7, 1)" /></td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 9, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 10, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 11, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 12, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 13, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 14, 1)" /></td>
						</tr>
					</table>
				</div>
				
			</div>
            <xsl:variable name="NumINN" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:ИНН"/>
            <xsl:variable name="NumKPP" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:КПП"/>
            <div class="afRow">
				<div class="afCol-1-5 afCenterBlock">ИНН</div> 
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 9, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 10, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 11, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 12, 1)" /></td>
                        </tr>
                    </table>
                </div>
                <div class="afCol-1-5 afCenterBlock">КПП</div>
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 9, 1)" /></td>
                        </tr>
                    </table>
                </div>
            </div>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">Наименование (краткое)</div>
                <div class="afCol-2-3 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/ИС6:Наименование"/>
                </div>
            </div>
            <div class="afRow">
                 <div class="afCol-3-10">
                    <div class="afC afValue">2. Отчетный период (код):</div>
                    <div class="afCol-1-10">
                        <div class="afC afCheck">
                            <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Код"/>
                        </div>
                    </div>
                </div>
                 <div class="afCol-1-5">
                    <div class="afC afMarginLeft10">год</div>
                    <div class="afValue">
						<div class="afCol-1-4 afCheck">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Год"/>
						</div>
                    </div>
                </div>
                <div class="afCol-1-2">
                    <div class="afP">
                        <div class="afCol-1-4">Исходная</div>
                        <div class="afCol-1-10 ">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '0']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                    <div class="afP">
                        <div class="afCol-1-4">Корректирующая</div>
                        <div class="afCol-1-10">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '1']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                    <div class="afP">
                        <div class="afCol-1-4">Отменяющая</div>
                        <div class="afCol-1-10">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '2']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <p class="afP afValue">3. Перечень входящих документов</p>
            <table class="afTable">
                <tr class="afCenter">
                    <td>Наименование входящего документа</td>
                    <td>Количество застрахованных лиц, на которых представлены сведения, чел.</td>
                </tr>
                <tr>
                    <td>Форма "Сведения о страховом стаже застрахованного лица (СЗВ-СТАЖ)"</td>
                    <td class="afValue afCenter">
                        <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:КоличествоЗЛ"/>
                    </td>
                </tr>
                <tr>
                    <td>Форма "Сведения о заработке (вознаграждении) доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах, о периодах трудовой и иной деятельности,
                        засчитываемых в страховой стаж застрахованного лица (СЗВ-ИСХ)"</td>
                    <td/>
                </tr>
                <tr>
                    <td>Форма "Данные о корректировке сведений, учтенных на индивидуальном лицевом счету застрахованного лица (СЗВ-КОРР)"</td>
                    <td/>
                </tr>
                <tr>
                    <td>Иные входящие документы:</td>
                    <td/>
                </tr>
            </table>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<p class="afP afValue">4. Данные в целом по страхователю:</p>
				<table class="afTable">
					<tr class="afCenter">
						<td/>
						<td>Задолженность на начало отчетного периода, руб. коп.</td>
						<td>Начислено страховых взносов, руб. коп.</td>
						<td>Уплачено страховых взносов, руб. коп.</td>
						<td>Задолженность на конец отчетного периода, руб. коп.</td>
					</tr>
					<tr>
						<td>На страховую пенсию</td>
						<td/>
						<td/>
						<td/>
						<td/>
					</tr>
					<tr>
						<td>На накопительную пенсию</td>
						<td/>
						<td/>
						<td/>
						<td/>
					</tr>
					<tr>
						<td>По тарифу страховых взносов</td>
						<td/>
						<td/>
						<td/>
						<td/>
					</tr>
				</table>
			</div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
                <p class="afP">Расшифровка графы "Уплачено" по периодам, за которые была произведена уплата страховых взносов</p>
                <table class="afTable">
                    <tr class="afCenter">
                        <td>Уплачено в календарном году</td>
                        <td>На страховую пенсию</td>
                        <td>На накопительную пенсию</td>
                        <td>По тарифу страховых взносов</td>
                    </tr>
                    <tr>
                        <td>Всего, в том числе:</td>
                        <td/>
                        <td/>
                        <td/>
                    </tr>
                    <tr>
                        <td>за ________ год</td>
                        <td/>
                        <td/>
                        <td/>
                    </tr>
                    <tr>
                        <td>за ________ год</td>
                        <td/>
                        <td/>
                        <td/>
                    </tr>
                </table>
            </div>
            <p class="afInterval"/>
            <p class="afP afValue">5. Основание для отражения данных о периодах работы застрахованного лица в условиях, дающих право на досрочное назначение пенсии в соответствии со статьей 30
                Федерального закона от 28.12.2013 № 400–ФЗ «О страховых пенсиях»</p>
            <table class="afTable">
                <tr class="afCenter">
                    <td>№ п/п</td>
                    <td>Наименование структурного подразделения по штатному расписанию</td>
                    <td>Наименование профессии, должности по штатному расписанию</td>
                    <td>Кол-во раб. мест по штат. расписанию</td>
                    <td>Кол-во раб-ов факт.</td>
                    <td>Характер фактически выполняемых работ и дополнительные условия труда</td>
                    <td>Наименование первичных документов, подтверждающих занятость в особых условиях труда</td>
                    <td>Код особых условий труда/выслуги лет по Классификатору</td>
                    <td>Код позиции Списка № 1 и 2, "малого" списка</td>
                </tr>
                <tr class="afCenter afSmallSize afHeightRow">
                    <td>1</td>
                    <td>2</td>
                    <td>3</td>
                    <td>4</td>
                    <td>5</td>
                    <td>6</td>
                    <td>7</td>
                    <td>8</td>
                    <td>9</td>
                </tr>
                <xsl:choose>
                    <xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
                        <xsl:for-each select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
                            <tr>
                                <td>
                                    <xsl:value-of select="position()"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./ИС6:Подразделение"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./ИС6:ПрофессияДолжность"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./ИС6:КоличествоШтат"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./ИС6:КоличествоФакт"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./ИС6:Описание"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./ИС6:Документы"/>
                                </td>
                                <td>
                                    <xsl:for-each select="./ns1:ОУТ">
                                        <p class="afP">
                                            <xsl:value-of select="./ns1:Код"/>
                                        </p>
                                    </xsl:for-each>
                                </td>
                                <td>
                                    <xsl:for-each select="./ns1:ОУТ">
                                        <p class="afP">
                                            <xsl:value-of select="./ns1:ПозицияСписка"/>
                                        </p>
                                    </xsl:for-each>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <tr class="afHeightBlankRow">
                            <td/>
                            <td/>
                            <td/>
                            <td/>
                            <td/>
                            <td/>
                            <td/>
                            <td/>
                            <td/>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>
            </table>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<div class="afRow">
					<div class="afC afValue">Общее количество рабочих мест в особых условиях труда по штату</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<!--xsl:value-of select="sum(//ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание/ИС6:КоличествоШтат)"/-->
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС6:ВсегоШтат"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<div class="afRow">
					<div class="afC afValue">Количество фактически работающих в особых условиях труда</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
							<!--	<xsl:value-of select="sum(//ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание/ИС6:КоличествоФакт)"/>/-->
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС6:ВсегоФакт"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afInterval"/>
            
            
            
				<table class="afTable100 afTableCollapse">
					<tbody class="afOverflowWordBreak">
						<tr>
							<td class="afTable30">
								<p class="afUnderlinedBlock afValue">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
								</p>
							</td>
							<td class="afTable3">&#160;</td>
							<td class="afTable30">
								<p class="afUnderlinedBlock">&#160;</p>
							</td>
							<td class="afTable3">&#160;</td>
							<td class="afTable30 afCenter">
								<p class="afUnderlinedBlock afValue">
									<xsl:call-template name="УТ6:NameStr">
										<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
									</xsl:call-template>
								</p>
							</td>
						</tr>
						<tr>
							<td class="afTable30">
								<p class="afSubscriptNormal afCenter">Наименование должности руководителя</p>
							</td>
							<td class="afTable3">&#160;</td>
							<td class="afTable30">
								<p class="afSubscriptNormal afCenter">Подпись</p>
							</td>
							<td class="afTable3">&#160;</td>
							<td class="afTable30">
								<p class="afSubscriptNormal afCenter">Расшифровка подписи</p>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
            
			<p class="afInterval"/>
			<div class="afSign">
				<div class="afPadding">
					<p class="afUnderlinedBlock afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
					<p class="afP afCenter">Дата (дд.мм.гггг)</p>
				</div>
				<div class="afPadding">М.П. (при наличии)</div>
				<div class="afPadding"></div>
			</div>
			
            <div id="break"/>
            
            <!--СЗВ-СТАЖ-->
            
            
            
            <xsl:variable name="RegNumKORR" select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Страхователь/УТ6:РегНомер"/>
				<div class="afRow">
					<div class="afC">Регистрационный номер в СФР</div> 
					<div class="afCol-1-2">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 1, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 2, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 3, 1)" /></td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 5, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 6, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 7, 1)" /></td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 9, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 10, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 11, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 12, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 13, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 14, 1)" /></td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-10 afCenterBlock">Стр.</div>
					<div class="afCol-1-10">
						<table class="afTable100 afTableCollapse">
							<tr>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
							</tr>
						</table>
					</div>
				</div>
			
				<xsl:variable name="NumINNKORR" select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Страхователь/УТ6:ИНН"/>
				<xsl:variable name="NumKPPKORR" select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Страхователь/УТ6:КПП"/>
				<div class="afRow">
					<div class="afCol-1-5 afCenterBlock">ИНН</div> 
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 1, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 2, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 3, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 4, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 5, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 6, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 7, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 8, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 9, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 10, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 11, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 12, 1)" /></td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-5 afCenterBlock">КПП</div>
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Страхователь/УТ6:КПП">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 3, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 4, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 7, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 8, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 9, 1)" /></td>
									</tr>
								</xsl:when>
								<xsl:otherwise>
									<tr>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
									</tr>
								</xsl:otherwise>
							</xsl:choose>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-3-4">
						<p class="afP">Форма СЗВ-СТАЖ</p>
						<p class="afInterval"/>
						<p class="afP afValue">Сведения о страховом стаже застрахованных лиц</p>
					</div>
					<div class="afCol-1-4">
						УТВЕРЖДЕНА<br/>
						постановлением Правления СФР<br/>
						от 6 декабря 2018 г. № 507п
					</div>
				</div>
				<p class="afInterval"/>
           
				<p class="afP afValue">1. Сведения о страхователе</p>
				<p class="afInterval"/>
				
				
				
				
				<div class="afRow">
					<div class="afCol-1-2">
						<div class="afRow">
							<div class="afC">Регистрационный номер в СФР</div> 
							<div class="afCol-1-2">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 3, 1)" /></td>
										<td>&#160;-&#160;</td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 7, 1)" /></td>
										<td>&#160;-&#160;</td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 9, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 10, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 11, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 12, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 13, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($RegNumKORR, 14, 1)" /></td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-8 afCenterBlock">ИНН</div> 
							<div class="afCol-1-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 3, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 4, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 5, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 6, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 7, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 8, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 9, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 10, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 11, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($NumINNKORR, 12, 1)" /></td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-5 afCenterBlock">КПП</div>
							<div class="afCol-1-3">
								<table class="afTableCollapse">
									<xsl:choose>
										<xsl:when test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Страхователь/УТ6:КПП">
											<tr>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 1, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 2, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 3, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 4, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 5, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 6, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 7, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 8, 1)" /></td>
												<td class="afCheckSmall"><xsl:value-of select="substring($NumKPPKORR, 9, 1)" /></td>
											</tr>
										</xsl:when>
										<xsl:otherwise>
											<tr>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
												<td class="afCheckSmall">&#160;</td>
											</tr>
										</xsl:otherwise>
									</xsl:choose>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">
								<p class="afP">Наименование (краткое)</p>
							</div>
							<div class="afCol-6-10">
								<p class="afValue afUnderlinedBlock">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Страхователь/ИС6:Наименование"/>
								</p>
							</div>
						</div>
					</div>
					<div class="afCol-1-2">
						<div class="afFrame afCol-2-3">
							<div class="afP">Тип сведений: </div>
							<div class="afP">
								<div class="afC">Исходная -</div>
								<div class="afCol-1-10">
									<div class="afC afCheck">
										<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Тип[text() = '0']">V</xsl:if>
									</div>
								</div>
								<div class="afC afPadding">Дополняющая -</div>
								<div class="afCol-1-10">
									<div class="afC afCheck">
										<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Тип[text() = '1']">V</xsl:if>
									</div>
								</div>
							</div>
							<div class="afP">
								<div class="afC">Назначение пенсии - </div>
								<div class="afCol-1-10">
									<div class="afC afCheck">
										<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Тип[text() = '2']">V</xsl:if>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
					
				<p class="afP afValue">2. Отчетный период</p>
				<div class="afRow">
					<div class="afCol-1-5">Календарный год</div>
					<div class="afCol-1-5 afValue">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall"><xsl:value-of select="substring(/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:ОтчетныйПериод/ns1:Год, 1, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring(/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:ОтчетныйПериод/ns1:Год, 2, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring(/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:ОтчетныйПериод/ns1:Год, 3, 1)" /></td>
								<td class="afCheckSmall"><xsl:value-of select="substring(/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:ОтчетныйПериод/ns1:Год, 4, 1)" /></td>
							</tr>
						</table>
					</div>
				</div>
				<p class="afP afValue">3. Сведения о периодах работы застрахованных лиц</p>
				<p class="afInterval"/>
				
				
        	<table class="afTable afTable98 afSmallSize">
                <tr class="afCenter afOverflowWordBreak">
                    <td rowspan="2">№ п/п</td>
                    <td class="afTable8" rowspan="2">Фамилия</td>
                    <td class="afTable8" rowspan="2">Имя</td>
                    <td class="afTable8" rowspan="2">Отчество</td>
                    <td rowspan="2">СНИЛС</td>
                    <td colspan="2">Период работы</td>
                    <td rowspan="2">Террито<br/>риальные условия (код)</td>
                    <td rowspan="2">Особые условия труда (код)</td>
                    <td colspan="2">Исчисление страхового стажа </td>
                    <td colspan="2">Условия досрочного назначения страховой пенсии </td>
                    <td class="afTable8" rowspan="2">Сведения об увольнении застрахо<br/>ванного лица/сведения о периодах, засчитываемых в страховой стаж безработным</td>
                </tr>
                <tr class="afCenter afOverflowWordBreak">
                    <td>с дд.мм.гггг</td>
                    <td>по дд.мм. гггг</td>
                    <td>Основание (код)</td>
                    <td>Дополни<br/>тельные сведения</td>
                    <td>Основание (код)</td>
                    <td>Дополнительные сведения</td>
                </tr>
                <tr class="afCenter afSmallSize afHeightRow">
                    <td>1</td>
                    <td>2</td>
                    <td>3</td>
                    <td>4</td>
                    <td>5</td>
                    <td>6</td>
                    <td>7</td>
                    <td>8</td>
                    <td>9</td>
                    <td>10</td>
                    <td>11</td>
                    <td>12</td>
                    <td>13</td>
                    <td>14</td>
                </tr>
                <xsl:for-each select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:ЗЛ">
                	<xsl:variable name="vLinesSP">
                		<xsl:choose>
                			<xsl:when test="count(.//ИС6:ЛьготныйСтаж) > 1">
                				<xsl:value-of select="count(.//ИС6:ЛьготныйСтаж)"/>
                			</xsl:when>
                			<xsl:when test="count(ИС6:ЛьготныйСтаж) = 1">
                				<xsl:value-of select="1"/>
                			</xsl:when>
                			<xsl:otherwise>
                				<xsl:value-of select="0"/>
                			</xsl:otherwise>
                		</xsl:choose>
                	</xsl:variable>
                	<xsl:variable name="vLinesNoLS">
                		<xsl:value-of select="count(ns1:СтажевыйПериод[not(ИС6:ЛьготныйСтаж)])"/>
                	</xsl:variable>
                	<xsl:variable name="vPos" select="position()"/>
                	<xsl:for-each select="ns1:СтажевыйПериод">
                		<xsl:variable name="vLinesLS">
                			<xsl:choose>
                				<xsl:when test="count(ИС6:ЛьготныйСтаж) > 1">
                					<xsl:value-of select="count(ИС6:ЛьготныйСтаж)"/>
                				</xsl:when>
                				<xsl:when test="count(ИС6:ЛьготныйСтаж) > 1">
                					<xsl:value-of select="1"/>
                				</xsl:when>
                				<xsl:otherwise>
                					<xsl:value-of select="0"/>
                				</xsl:otherwise>
                			</xsl:choose>
                		</xsl:variable>
                		
                		
                		<xsl:variable name="vPosSP" select="position()"/>
                		<xsl:choose>
                			<xsl:when test="$vLinesLS > 1">
                				<xsl:for-each select="ИС6:ЛьготныйСтаж">
                					<tr class="afOverflowWordBreak afVerticalTop">
                						<xsl:if test="$vPosSP = 1 and position() = 1">
                							<td rowspan="{$vLinesSP+$vLinesNoLS}">
                								<xsl:value-of select="$vPos"/>
                							</td>
                							<td class="afOverflowWordBreak" rowspan="{$vLinesSP+$vLinesNoLS}">
                								<xsl:value-of select="../../ns1:ФИО/УТ6:Фамилия"/>
                							</td>
                							<td class="afOverflowWordBreak" rowspan="{$vLinesSP+$vLinesNoLS}">
                								<xsl:value-of select="../../ns1:ФИО/УТ6:Имя"/>
                							</td>
                							<td class="afOverflowWordBreak" rowspan="{$vLinesSP+$vLinesNoLS}">
                								<xsl:value-of select="../../ns1:ФИО/УТ6:Отчество"/>
                							</td>
                							<td rowspan="{$vLinesSP+$vLinesNoLS}">
                								<xsl:value-of select="../../ns1:СНИЛС"/>
                							</td>
                						</xsl:if>
                						<xsl:if test="position() = 1">
                							<td rowspan="{$vLinesLS}">
                								<p class="afP">
                									<xsl:call-template name="DateShortStr">
                										<xsl:with-param name="pDate">
                											<xsl:value-of select="../ИС6:Период/УТ6:С"/>
                										</xsl:with-param>
                									</xsl:call-template>
                								</p>
                							</td>
                							<td rowspan="{$vLinesLS}">
                								<p class="afP">
                									<xsl:call-template name="DateShortStr">
                										<xsl:with-param name="pDate">
                											<xsl:value-of select="../ИС6:Период/УТ6:По"/>
                										</xsl:with-param>
                									</xsl:call-template>
                								</p>
                							</td>
                						</xsl:if>
                						<td>
                							<p class="afP">
                								<xsl:value-of select="concat(./ИС6:ТУ/ИС6:Основание, ' ', ./ИС6:ТУ/ИС6:Коэффициент)"/>
                							</p>
                						</td>
                						<td>
                							<p class="afP">
                								<xsl:value-of select="concat(./ИС6:ОУТ/ИС6:Код, ' ', ./ИС6:ОУТ/ИС6:ПозицияСписка)"/>
                							</p>
                						</td>
                						<td>
                							<p class="afP">
                								<xsl:value-of select="./ИС6:ИС/ИС6:Основание"/>
                							</p>
                						</td>
                						<td>
                							<p class="afP">
                								<xsl:call-template name="УТ6:ProductionStr">
                									<xsl:with-param name="pProduction" select="./ИС6:ИС"/>
                								</xsl:call-template>
                								<xsl:value-of select="./ИС6:ДопСведенияИС"/>
                							</p>
                						</td>
                						<td>
                							<p class="afP">
                								<xsl:value-of select="./ИС6:ВЛ/ИС6:Основание"/>
                							</p>
                						</td>
                						<td>
                							<p class="afP">
                								<xsl:call-template name="УТ6:ProductionStr">
                									<xsl:with-param name="pProduction" select="./ИС6:ВЛ"/>
                								</xsl:call-template>
                								<xsl:value-of select="./ИС6:ВЛ/ИС6:ДоляСтавки"/>
                							</p>
                						</td>
                						<xsl:if test="position() = 1">
                							<td rowspan="{$vLinesLS}">
                								<xsl:call-template name="DateShortStr">
                									<xsl:with-param name="pDate" select="../../ns1:ДатаУвольнения"/>
                								</xsl:call-template>
                								<p class="afP">
                									<xsl:value-of select="../ns1:КатегорияЗЛ"/>
                								</p>
                							</td>
                						</xsl:if>
                					</tr>
                				</xsl:for-each>
                			</xsl:when>
                			<xsl:otherwise>
                				<tr class="afOverflowWordBreak afVerticalTop">
                					<xsl:if test="$vPosSP = 1">
                						<td rowspan="{$vLinesSP+$vLinesNoLS}">
                							<xsl:value-of select="$vPos"/>
                						</td>
                						<td class="afOverflowWordBreak" rowspan="{$vLinesSP+$vLinesNoLS}">
                							<xsl:value-of select="../ns1:ФИО/УТ6:Фамилия"/>
                						</td>
                						<td class="afOverflowWordBreak" rowspan="{$vLinesSP+$vLinesNoLS}">
                							<xsl:value-of select="../ns1:ФИО/УТ6:Имя"/>
                						</td>
                						<td class="afOverflowWordBreak" rowspan="{$vLinesSP+$vLinesNoLS}">
                							<xsl:value-of select="../ns1:ФИО/УТ6:Отчество"/>
                						</td>
                						<td rowspan="{$vLinesSP+$vLinesNoLS}">
                							<xsl:value-of select="../ns1:СНИЛС"/>
                						</td>
                					</xsl:if>
                					
                					<td>
                						<p class="afP">
                							<xsl:call-template name="DateShortStr">
                								<xsl:with-param name="pDate">
                									<xsl:value-of select="ИС6:Период/УТ6:С"/>
                								</xsl:with-param>
                							</xsl:call-template>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:call-template name="DateShortStr">
                								<xsl:with-param name="pDate">
                									<xsl:value-of select="ИС6:Период/УТ6:По"/>
                								</xsl:with-param>
                							</xsl:call-template>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:value-of select="concat(ИС6:ЛьготныйСтаж/ИС6:ТУ/ИС6:Основание, ' ', ИС6:ЛьготныйСтаж/ИС6:ТУ/ИС6:Коэффициент)"/>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:value-of select="concat(ИС6:ЛьготныйСтаж/ИС6:ОУТ/ИС6:Код, ' ', ИС6:ЛьготныйСтаж/ИС6:ОУТ/ИС6:ПозицияСписка)"/>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ИС/ИС6:Основание"/>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:call-template name="УТ6:ProductionStr">
                								<xsl:with-param name="pProduction" select="ИС6:ЛьготныйСтаж/ИС6:ИС"/>
                							</xsl:call-template>
                							<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ДопСведенияИС"/>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ВЛ/ИС6:Основание"/>
                						</p>
                					</td>
                					<td>
                						<p class="afP">
                							<xsl:call-template name="УТ6:ProductionStr">
                								<xsl:with-param name="pProduction" select="ИС6:ЛьготныйСтаж/ИС6:ВЛ"/>
                							</xsl:call-template>
                							<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ВЛ/ИС6:ДоляСтавки"/>
                						</p>
                					</td>
                					
                					<td>
                						<xsl:call-template name="DateShortStr">
                							<xsl:with-param name="pDate" select="../ns1:ДатаУвольнения"/>
                						</xsl:call-template>
                						<p class="afP">
                							<xsl:value-of select="ns1:КатегорияЗЛ"/>
                						</p>
                					</td>
                				</tr>
                			</xsl:otherwise>
                		</xsl:choose>
                	</xsl:for-each>
                </xsl:for-each>
            </table>
	
			<div class="afNoBreakInside">	
				<p class="afP afValue">4. Сведения о начисленных (уплаченных) страховых взносах на обязательное пенсионное страхование</p>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afC afCol-3-4">Страховые взносы на обязательное пенсионное страхование за период, указанный в графе "Период работы", начислены (уплачены):</div>
					<div class="afCol-1-4">
						<div class="afP">
							<div class="afC">да -</div>
							<div class="afCol-1-10 afPadding">
								<div class="afC afCheck">
									<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыНаОПС[text() = '1'] or /ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыНаОПС[text() = 'true']">V</xsl:if>
								</div>
							</div>
							<div class="afC">нет-</div>
							<div class="afCol-1-10">
								<div class="afC afCheck">
									<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыНаОПС[text() = '0'] or /ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыНаОПС[text() = 'false']">V</xsl:if>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="afRow">
					<div class="afC afCol-3-4">Страховые взносы по дополнительному тарифу за период, указанный в графе "Период работы", начислены (уплачены):</div>
					<div class="afCol-1-4">
						<div class="afP">
							<div class="afC ">да -</div>
							<div class="afCol-1-10 afPadding">
								<div class="afC afCheck">
									<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыПоДТ[text() = '1'] or /ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыПоДТ[text() = 'true']">V</xsl:if>
								</div>
							</div>
							<div class="afC">нет-</div>
							<div class="afCol-1-10">
								<div class="afC afCheck">
									<xsl:if test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыПоДТ[text() = '0'] or /ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:СВ/ns1:НачисленыПоДТ[text() = 'false']">V</xsl:if>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <p class="afInterval"/>	
				
			<div class="afNoBreakInside">	
				<div class="afRow">
				<div class="afValue afP">5. Сведения об уплаченных пенсионных взносах с соответствии с пенсионными договорами досрочного негосударственного пенсионного обеспечения:</div>
				</div>
				 <xsl:choose>
					<xsl:when test="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Уплата">
					<!--	
						<div class="afRow">
							<div class="afCol-1-2">
								<div class="afC"><p>пенсионные взносы за период</p></div>
								<div class="afC">
									<xsl:for-each select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Уплата">
										<p class="afP">с <span class="afValue"><xsl:call-template name="DateShortStr">
													<xsl:with-param name="pDate">
														<xsl:value-of select="./ns1:Период/УТ6:С"/>
													</xsl:with-param>
												</xsl:call-template></span> по <span class="afValue"><xsl:call-template name="DateShortStr">
													<xsl:with-param name="pDate">
														<xsl:value-of select="./ns1:Период/УТ6:По"/>
													</xsl:with-param>
												</xsl:call-template></span>,</p>
									</xsl:for-each>
								</div>
								<div class="afC"><p>уплачены:</p></div>
							</div>
						
							<div class="afCol-1-2">
								<xsl:for-each select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Уплата">
									<div class="afP">
										<div class="afC">да -</div>
										<div class="afCol-1-10 afPadding">
											<div class="afC afCheckSmall">
												<xsl:if test="./ns1:Уплачено[text() = '1'] or ./ns1:Уплачено[text() = 'true']">V</xsl:if>
											</div>
										</div>
										<div class="afC">нет-</div>
										<div class="afCol-1-10">
											<div class="afC afCheckSmall">
												<xsl:if test="./ns1:Уплачено[text() = '0'] or ./ns1:Уплачено[text() = 'false']">V</xsl:if>
											</div>
										</div>
									</div>
								</xsl:for-each>
							</div>
						</div>
					-->
					<xsl:for-each select="/ns1:ЭДСФР/ns1:СЗВ-СТАЖ/ns1:Уплата">
						<div class="afRow">
							<div class="afCol-1-4">
								<xsl:choose>
									<xsl:when test="position() = 1">
										<p>пенсионные взносы за период</p>
									</xsl:when>
									<xsl:otherwise>
										<p>&#160;</p>
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div class="afCol-1-5">
								<p>
								с	<span class="afValue">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="./ns1:Период/УТ6:С"/>
											</xsl:with-param>
										</xsl:call-template>
									</span> по 
									<span class="afValue">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="./ns1:Период/УТ6:По"/>
											</xsl:with-param>
										</xsl:call-template>
									</span>,
								</p>
							</div>
							<div class="afCol-10"><p>уплачены:</p></div>
							
								
							<div class="afCol-1-4">
								<div class="afC">да -</div>
									<div class="afCol-1-10 afPadding">
										<div class="afCheckSmall">
											<xsl:if test="./ns1:Уплачено[text() = '1'] or ./ns1:Уплачено[text() = 'true']">V</xsl:if>
										</div>
										</div>
										<div class="afC">нет-</div>
										<div class="afCol-1-10">
											<div class="afCheckSmall">
												<xsl:if test="./ns1:Уплачено[text() = '0'] or ./ns1:Уплачено[text() = 'false']">V</xsl:if>
											</div>
										</div>
									</div>
							
						</div>
					
</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<div class="afRow">
							<div class="afCol-6-10">
								<div class="afC">пенсионные взносы за период</div>
								<div class="afC">с</div>
								<div class="afCol-1-5 afBlankUnderlinedBlock"/>
								<div class="afC">по</div>
								<div class="afCol-1-5 afBlankUnderlinedBlock"/>
								<div class="afC">,</div>
								<div class="afC">уплачены:</div>
							</div>
							<div class="afCol-1-3">
								
									<div class="afC">да -</div>
									<div class="afCol-1-10 afPadding">
										<div class="afC afCheckSmall">
											<xsl:if test="./ns1:Уплачено[text() = '1']">V</xsl:if>
										</div>
									</div>
									<div class="afC">нет-</div>
									<div class="afCol-1-10">
										<div class="afC afCheckSmall">
											<xsl:if test="./ns1:Уплачено[text() = '0']">V</xsl:if>
										</div>
									</div>
							</div>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			
				<p class="afInterval"/><p class="afInterval"/>
				<div class="afRow">
					 <table class="afTable100 afTableCollapse">
						<tbody>
							<tr>
								<td class="afTable27"><p class="afP"> Наименование должности руководителя</p></td>
								<td class="afTable2">&#160;</td>
								<td class="afTable30">
									<p class="afUnderlinedBlock afValue">
										<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
									</p>
								</td>
								<td class="afTable2">&#160;</td>
								<td class="afTable7">Подпись</td>
								<td class="afTable15"><p class="afUnderlinedBlock">&#160;</p></td>
								<td class="afTable17">&#160;</td>
							</tr>
							<tr>
								<td class="afTable27">&#160;</td>
								<td class="afTable2">&#160;</td>
								<td class="afTable30">&#160;</td>
								<td class="afTable2">&#160;</td>
								<td class="afTable34" colspan="3">&#160;</td>
							</tr>
							<tr>
								<td class="afTable27">&#160;</td>
								<td class="afTable2">&#160;</td>
								<td class="afTable30">&#160;</td>
								<td class="afTable2">&#160;</td>
								<td class="afTable34" colspan="3">Расшифровка подписи
									<p class="afUnderlinedBlock afValue">
										<xsl:call-template name="УТ6:NameStr">
											<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
										</xsl:call-template>
									</p>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol2-1-2">
						<div class="afCol-6-10">
						 <div class="afCol-1-2">
							 <p class="afP afUnderlinedBlock afValue">
								 <xsl:call-template name="DateShortStr">
									 <xsl:with-param name="pDate">
										 <xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
									 </xsl:with-param>
								 </xsl:call-template>
							 </p>
							 <p class="afP afCenter">Дата (дд.мм.гггг)</p>
							</div>
						</div>
						<div class="afC afAlignBotom afPadding">
							<br/>М.П. (при наличии)
						</div>
					</div>
				</div>
			
			</div>
			<p class="afInterval"/>
            <div class="afNoBreakInside">
                <xsl:if test="ns1:ЭДСФР/sig:SignInfo">
                    <xsl:call-template name="PrintSignInfo">
                        <xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
                    </xsl:call-template>
                </xsl:if>
            </div>
        </div>
    </xsl:template>

    <!-- Выработка -->
    <xsl:template name="УТ6:ProductionStr">
        <xsl:param name="pProduction"/>
        <xsl:if test="$pProduction">
            <xsl:if test="$pProduction//ВС:ВыработкаВчасах/ВС:Часы">
                <xsl:value-of select="$pProduction//ВС:ВыработкаВчасах/ВС:Часы"/> ч.&#160;</xsl:if>
            <xsl:if test="$pProduction/ВС:ВыработкаВчасах/ВС:Минуты">
                <xsl:value-of select="$pProduction/ВС:ВыработкаВчасах/ВС:Минуты"/> мин.&#160;</xsl:if>
            <xsl:if test="$pProduction/ВС:ВыработкаКалендарная/ВС:ВсеМесяцы">
                <xsl:value-of select="$pProduction/ВС:ВыработкаКалендарная/ВС:ВсеМесяцы"/> мес.&#160;</xsl:if>
            <xsl:if test="$pProduction/ВС:ВыработкаКалендарная/ВС:ВсеДни">
                <xsl:value-of select="$pProduction/ВС:ВыработкаКалендарная/ВС:ВсеДни"/> д.&#160; </xsl:if>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
