<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 sig ns1" version="1.0"
    xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УОД/2024-01-01">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
    <xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template match="/" name="inc">
        <xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УОД"/>
        <div class="afWrap">
            
            <h1 class="afHeader afCenter">Уведомление о доставке</h1>
            <p class="afInterval"/>
            
            <xsl:choose>
                <xsl:when test="$vForm/ns1:Оператор/УТ7:РегНомер">
                    <div class="afRow afHeaderLeft">Сведения об операторе:</div>
                    <div class="afRow">
                        <div class="afCol-1-4">Регистрационный номер оператора в СФР</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="$vForm/ns1:Оператор/УТ7:РегНомер"/>
                        </div>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">Наименование оператора</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="$vForm/ns1:Оператор/УТ7:НаименованиеКраткое"/>
                        </div>
                    </div>
                </xsl:when>
                <xsl:when test="$vForm/ns1:Страхователь/УТ7:РегНомер">
                    <div class="afRow afHeaderLeft">Сведения о страхователе:</div>
                    <div class="afRow">
                        <div class="afCol-1-4">Регистрационный номер страхователя в СФР</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="$vForm/ns1:Страхователь/УТ7:РегНомер"/>
                        </div>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">Наименование страхователя</div>
                        <xsl:choose>
                            <xsl:when test="$vForm/ns1:Страхователь/УТ7:НаименованиеКраткое">
                                <div class="afCol-2-3 afOverFlowAuto afTableRight afUnderlinedAlignLeftPadding afWordBreak afValue">
                                    <xsl:value-of select="$vForm/ns1:Страхователь/УТ7:НаименованиеКраткое"/>
                                </div>
                            </xsl:when>
                            <xsl:when test="$vForm/ns1:Страхователь/УТ7:ФИО">
                                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                                    <xsl:value-of select="$vForm/ns1:Страхователь/УТ7:ФИО"/>
                                </div>
                            </xsl:when>
                            <xsl:otherwise>&#160;</xsl:otherwise>
                        </xsl:choose>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">ИНН страхователя</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="$vForm/ns1:Страхователь/УТ7:ИНН"/>
                        </div>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">КПП страхователя</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="$vForm/ns1:Страхователь/УТ7:КПП"/>
                        </div>
                    </div>
                </xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
            
            <p class="afInterval"/>
            
            <div class="afRow afHeaderLeft">Сведения о доставленном пакете:</div>
            
            <div class="afRow">
                <div class="afCol-1-4">Идентификатор пакета</div>
                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                    <xsl:value-of select="$vForm/ns1:ДоставленныйПакет/ns1:Идентификатор"/>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-4">Дата и время доставки пакета</div>
                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                    <xsl:variable name="dateTimeText" select="$vForm/ns1:ДоставленныйПакет/ns1:ДатаВремя"/>
                    <xsl:value-of select="concat(substring($dateTimeText, 1, 10), '/', substring($dateTimeText, 12, 8))"/>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-4">Канал передачи</div>
                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                    <xsl:if test="$vForm/ns1:ДоставленныйПакет/ns1:Канал[text() = 'EDOK']">ЭДОК</xsl:if>
                    <xsl:if test="$vForm/ns1:ДоставленныйПакет/ns1:Канал[text() = 'ES.KS']">Кабинет страхователя</xsl:if>
                    <xsl:if test="$vForm/ns1:ДоставленныйПакет/ns1:Канал[text() = 'POST']">По почте</xsl:if>
                    <xsl:if test="$vForm/ns1:ДоставленныйПакет/ns1:Канал[text() = 'PERS']">Лично</xsl:if>
                    <xsl:if test="$vForm/ns1:ДоставленныйПакет/ns1:Канал[text() = 'ECP']">ЕЦП</xsl:if>
                </div>
            </div>
            <p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
        </div>
    </xsl:template>
</xsl:stylesheet>
