<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:УТ8="http://пф.рф/УТ/2025-01-01" xmlns:ПР9="http://пф.рф/Представитель/2025-01-01"  exclude-result-prefixes="xs УТ8 ПР9" version="1.0">
	<!-- Дата (кратко)-->
	<xsl:template name="DateShortStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate and $pDate!=''">
			<xsl:variable name="dateText" select="string($pDate)"/>
			<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
		</xsl:if>
	</xsl:template>
	<!-- Дата (особая) УТ8 -->
	<xsl:template name="УТ8:DateSpecialStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:if test="$pDate/УТ8:День">
				<xsl:value-of select="$pDate/УТ8:День"/>.</xsl:if>
			<xsl:choose>
				<xsl:when test="$pDate/УТ8:Месяц">
					<xsl:value-of select="$pDate/УТ8:Месяц"/>.</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pDate/УТ8:День">&#160;.</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$pDate/УТ8:Год">
				<xsl:value-of select="$pDate/УТ8:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Дата (особая) (развернуто) УТ8 -->
	<xsl:template name="УТ8:DateSpecialLongStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:choose>
				<xsl:when test="$pDate/УТ8:День">
					<xsl:value-of select="concat('&quot;', format-number($pDate/УТ8:День, '00'), '&quot;')"/>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$pDate/УТ8:Месяц">
					<xsl:choose>
						<xsl:when test="$pDate/УТ8:День">
							<xsl:choose>
								<xsl:when test="$pDate/УТ8:Месяц = 1"> января </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 2"> февраля </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 3"> марта </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 4"> апреля </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 5"> мая </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 6"> июня </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 7"> июля </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 8"> августа </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 9"> сентября </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 10"> октября </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 11"> ноября </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 12"> декабря </xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$pDate/УТ8:Месяц = 1">январь </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 2">февраль </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 3">март </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 4">апрель </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 5">май </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 6">июнь </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 7">июль </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 8">август </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 9">сентябрь </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 10">октябрь </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 11">ноябрь </xsl:when>
								<xsl:when test="$pDate/УТ8:Месяц = 12">декабрь </xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$pDate/УТ8:Год">
				<xsl:value-of select="$pDate/УТ8:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Фамилия И.О. -->
	<xsl:template name="УТ8:NameStrShort">
		<xsl:param name="pName"/>
		<xsl:param name="pIOFirst"/>
		<xsl:if test="$pName">
			<xsl:choose>
				<xsl:when test="$pIOFirst">
					<xsl:if test="$pName/УТ8:Имя">
						<xsl:value-of select="substring($pName/УТ8:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ8:Отчество">
						<xsl:value-of select="substring($pName/УТ8:Отчество, 1, 1)"/>. </xsl:if>
					<xsl:if test="$pName/УТ8:Фамилия">
						<xsl:value-of select="$pName/УТ8:Фамилия"/>&#160;</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pName/УТ8:Фамилия">
						<xsl:value-of select="$pName/УТ8:Фамилия"/>&#160;</xsl:if>
					<xsl:if test="$pName/УТ8:Имя">
						<xsl:value-of select="substring($pName/УТ8:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ8:Отчество">
						<xsl:value-of select="substring($pName/УТ8:Отчество, 1, 1)"/>. </xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- ФИО -->
	<xsl:template name="УТ8:NameStr">
		<xsl:param name="pName"/>
		<!--pNoBreakWhitespace - устанавливает, следует ли использовать неразрывные пробелы или разрывные
				1 - неразрывные
				0 - разрывные (3-per-em space)-->
		<xsl:param name="pNoBreakWhitespace" select="1"/>
		<xsl:if test="$pName">
			<xsl:if test="$pName/УТ8:Фамилия">
				<xsl:value-of select="$pName/УТ8:Фамилия"/>
				<xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$pName/УТ8:Имя">
				<xsl:value-of select="$pName/УТ8:Имя"/>
				<xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$pName/УТ8:Отчество">
				<xsl:value-of select="$pName/УТ8:Отчество"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- ФИО прописными-->
	<xsl:template name="УТ8:NameStrUp">
		<xsl:param name="pName"/>
		<!--pNoBreakWhitespace - устанавливает, следует ли использовать неразрывные пробелы или разрывные
				1 - неразрывные
				0 - разрывные (3-per-em space)-->
		<xsl:param name="pNoBreakWhitespace" select="1"/>
		<xsl:variable name="uppercase" select="concat('АБВГ', 'ДЕЁЖЗ', 'ИЙКЛ', 'МНОП', 'РСТУ', 'ФХЦЧ', 'ШЩЪЫ', 'ЬЭЮЯ')"/>
		<xsl:variable name="lowercase" select="concat('абвг', 'деёжз', 'ийкл', 'мноп', 'рсту', 'фхцч', 'шщъы', 'ьэюя')"/>
		
			
		
			
		<xsl:if test="$pName">
			<xsl:if test="$pName/УТ8:Фамилия">
				<xsl:value-of select="translate($pName/УТ8:Фамилия, $lowercase, $uppercase)"/>
				<xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$pName/УТ8:Имя">
				<xsl:value-of select="translate($pName/УТ8:Имя, $lowercase, $uppercase)"/>
				<xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$pName/УТ8:Отчество">
				<xsl:value-of select="translate($pName/УТ8:Отчество, $lowercase, $uppercase)"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Пол -->
	<xsl:template name="УТ8:SexStr">
		<xsl:param name="pSex"/>
		<td colspan="3" class="afValue">
			<xsl:choose>
				<xsl:when test="$pSex = 1 ">М</xsl:when>
				<xsl:when test="$pSex = 2 ">Ж</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!-- Документ, удостоверяющий личность -->
	<xsl:template name="УТ8:DocumentStr">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable100">
				<tr>
					<td class="afTable40">Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ8:Наименование"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ8:Серия, ' ', $pDocument/УТ8:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue afTable10">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ8:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ8:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>Место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ8:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if>
						</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ8:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>

	<!-- Документ, удостоверяющий личность -->
	<xsl:template name="УТ8:DocumentStr98">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable98">
				<tr>
					<td class="afTable40">Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ8:Наименование"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ8:Серия, ' ', $pDocument/УТ8:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue afTable10">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ8:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ8:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>Место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ8:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if>
						</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ8:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	
<!-- Гражданство-->
	<xsl:template name="NationalityStr">
		<xsl:param name="pNationalityType"/>
		<xsl:choose>
			<xsl:when test="$pNationalityType = '1'"> гражданин(-ка) РФ </xsl:when>
			<xsl:when test="$pNationalityType = '2'"> иностранный гражданин </xsl:when>
			<xsl:when test="$pNationalityType = '3'"> лицо без гражданства </xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Пункт нормативного документа-->
	<xsl:template name="УТ8:NormativeDocumentStr">
		<xsl:param name="pNormativeDocument"/>
		<xsl:choose>
			<xsl:when test="$pNormativeDocument">
				<xsl:if test="$pNormativeDocument/УТ8:Подпункт"> подпункт <xsl:value-of select="$pNormativeDocument/УТ8:Подпункт"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ8:Пункт">
					<xsl:value-of select="concat(' п.',' ', $pNormativeDocument/УТ8:Пункт)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ8:Часть">
					<xsl:value-of select="concat(' ч.',' ', $pNormativeDocument/УТ8:Часть)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ8:Статья">
					<xsl:value-of select="concat(' ст.',' ', $pNormativeDocument/УТ8:Статья)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ8:НормативныйДокумент">
					<xsl:value-of select="concat(' ',' ', $pNormativeDocument/УТ8:НормативныйДокумент)"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Адрес в строку -->
	<xsl:template name="УТ8:AddressStr">
		<xsl:param name="pAddress"/>
		<xsl:param name="needIndex" select="1"/>
		<xsl:param name="needRegion" select="1"/>
		<xsl:if test="$needIndex and $pAddress/УТ8:Индекс">
			<xsl:value-of select="$pAddress/УТ8:Индекс"/>, </xsl:if>
		<xsl:if test="$needRegion and $pAddress/УТ8:Регион">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ8:Регион/УТ8:Сокращение">
					<xsl:choose>
						<xsl:when test="$pAddress/УТ8:Регион/УТ8:Сокращение='край' or $pAddress/УТ8:Регион/УТ8:Сокращение='Республика'">
							<xsl:value-of select="concat($pAddress/УТ8:Регион/УТ8:Название, ' ', $pAddress/УТ8:Регион/УТ8:Сокращение)"/>,
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($pAddress/УТ8:Регион/УТ8:Название, ' ', $pAddress/УТ8:Регион/УТ8:Сокращение, '.')"/>,</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ8:Регион/УТ8:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ8:Округ">
			<xsl:value-of select="$pAddress/УТ8:Округ"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ8:Район">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ8:Район/УТ8:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ8:Район/УТ8:Название, ' ', $pAddress/УТ8:Район/УТ8:Сокращение)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($pAddress/УТ8:Район/УТ8:Название, ' р-н')"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ8:Город">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ8:Город/УТ8:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ8:Город/УТ8:Сокращение, '. ', $pAddress/УТ8:Город/УТ8:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('г. ', $pAddress/УТ8:Город/УТ8:Название)"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ8:ВнутригородскойРайон">
			<xsl:value-of select="$pAddress/УТ8:ВнутригородскойРайон"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ8:НаселенныйПункт">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ8:НаселенныйПункт/УТ8:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ8:НаселенныйПункт/УТ8:Сокращение, '. ', $pAddress/УТ8:НаселенныйПункт/УТ8:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ8:НаселенныйПункт/УТ8:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ8:Улица">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ8:Улица/УТ8:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ8:Улица/УТ8:Сокращение, '. ', $pAddress/УТ8:Улица/УТ8:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ8:Улица/УТ8:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ8:Дом">
			<xsl:value-of select="concat(' д. ', $pAddress/УТ8:Дом)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ8:Строение or $pAddress/УТ8:Владение or $pAddress/УТ8:Корпус or $pAddress/УТ8:Квартира">, </xsl:if>
		<xsl:if test="$pAddress/УТ8:Строение">
			<xsl:value-of select="concat(' стр. ', $pAddress/УТ8:Строение)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ8:Владение">
			<xsl:value-of select="$pAddress/УТ8:Владение"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ8:Корпус">
			<xsl:value-of select="concat(' корпус ', $pAddress/УТ8:Корпус)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ8:Квартира">
			<xsl:value-of select="concat(' кв. ', $pAddress/УТ8:Квартира)"/>
		</xsl:if>
	</xsl:template>
	<!-- Адрес иностранный в строку -->
	<xsl:template name="УТ8:AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress/УТ8:Иностранный">
			<xsl:if test="$pAddress/УТ8:Иностранный/УТ8:КодСтраны">
				<xsl:value-of select="$pAddress/УТ8:Иностранный/УТ8:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ8:Иностранный/УТ8:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ8:Иностранный/УТ8:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ8:Иностранный/УТ8:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ8:Иностранный/УТ8:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ8:Иностранный/УТ8:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ8:Иностранный/УТ8:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Адрес иностранный в строку -->
	<xsl:template name="AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress">
			<xsl:if test="$pAddress/УТ8:КодСтраны">
				<xsl:value-of select="$pAddress/УТ8:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ8:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ8:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ8:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ8:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ8:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ8:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<!-- Место рождения -->
	<xsl:template name="УТ8:BirthplaceStr">
		<xsl:param name="pBirthplace"/>
		<xsl:if test="$pBirthplace/УТ8:Город">
			<xsl:value-of select="$pBirthplace/УТ8:Город"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ8:Район">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ8:Район)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ8:Регион">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ8:Регион)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ8:Страна">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ8:Страна)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="УТ8:NumberedDocName">
		<xsl:param name="pDoc"/>
		<xsl:value-of select="$pDoc/УТ8:Наименование"/>
		<xsl:for-each select="$pDoc/УТ8:Реквизиты/УТ8:Реквизит">
			<xsl:if test="position() > 1">,</xsl:if> &#160;<xsl:value-of select="./УТ8:Наименование"/>&#160;<xsl:value-of select="./УТ8:Значение"/>
		</xsl:for-each>
		<xsl:if test="$pDoc/УТ8:ПредставленностьДокумента"> &#160;<xsl:value-of select="$pDoc/УТ8:ПредставленностьДокумента"/> экз. </xsl:if>
	</xsl:template>
	
	<!-- Документ, удостоверяющий личность  -->
	<xsl:template name="ZNDocumentStr">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:param name="pDocName"/>
		<xsl:param name="pDocNameMargin" select="'330'"/>
		<xsl:if test="$pDocument">
			<div class="afRow">
				<div class="afC">
					<xsl:value-of select="$pDocName"/>
				</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft{$pDocNameMargin}">
					<xsl:value-of select="$pDocument/УТ8:Наименование"/>
				</p>
			</div>
			<p class="afClear"/>
			
			<div class="afRow">
				<div class="afCol-1-6 afMarginLeft5">серия <span class="afSubscriptNormal">(при наличии)</span>
				</div>
				<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ8:Серия"/>
				</div>
				<div class="afCol-2-25">,&#160;&#160;&#160;номер</div>
				<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ8:Номер"/>
				</div>
				<div class="afCol-1-7">,&#160;&#160;&#160;дата выдачи</div>
				<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pDocument/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</div>,
				<!--				<div class="afC">,</div> -->
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC">орган, выдавший документ</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft170">
					<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
				</p>
			</div>
			<xsl:if test="$pData or $pDataSpecial">
				<p class="afClear"/>
				<div class="afRow">
					<div class="afC">дата рождения </div>
					<div class="afCol-1-4">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:if test="$pData">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate" select="$pData"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="$pDataSpecial">
								<xsl:call-template name="УТ8:DateSpecialStr">
									<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</p>
					</div>
					<!--					<div class="afC">,</div> -->
				</div>
			</xsl:if>
			<xsl:if test="$pBirthplace">
				<p class="afClear"/>
				<div class="afRow">
					<div class="afC">место рождения</div>
					<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft110">
						<xsl:call-template name="УТ8:BirthplaceStr">
							<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
						</xsl:call-template>
						<xsl:choose>
							<xsl:when test="$pPeriod = '1' and $pDocument/УТ8:СрокДействия">,</xsl:when>
							<xsl:otherwise/>
						</xsl:choose>
					</p>
				</div>
			</xsl:if>
			<!--			<xsl:if test="$pPeriod = '1' and $pDocument/УТ8:СрокДействия">
				<p class="afClear"/>
-->
			<div class="afRow">
				<div class="afC">срок действия документа <span class="afSubscriptNormal"> (при наличии в документе)</span>
				</div>
				<p class="afCol-1-4 afValue afUnderlinedAlignLeftPadding afMarginLeft200">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$pDocument/УТ8:СрокДействия"/>
					</xsl:call-template>
				</p>
			</div>
			<!--			</xsl:if> -->
		</xsl:if>
	</xsl:template>
	<!-- Документ, удостоверяющий личность с запятыми -->
	<xsl:template name="ZNDocumentStr98">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:param name="pDocName"/>
		<xsl:param name="pIssuerName"/>
		<xsl:param name="pBirthDate"/>
		<xsl:if test="$pDocument">
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">
						<xsl:value-of select="$pDocName"/>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">наименование:</div>
					<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft110">
						<xsl:value-of select="$pDocument/УТ8:Наименование"/>
					</p>
				</div>
				<p>,</p>
			</div>
			
			<div class="afRow">
				<div class="afCol-1-6 afMarginLeft5">серия <span class="afSubscriptNormal">(при наличии)</span>
				</div>
				<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ8:Серия"/>
				</div>
				<div class="afCol-2-25">,&#160;&#160;&#160;номер</div>
				<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ8:Номер"/>
				</div>
				<div class="afCol-1-7">,&#160;&#160;&#160;дата выдачи</div>
				<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$pDocument/УТ8:ДатаВыдачи"/>
					</xsl:call-template>
				</div>,
			</div>
			<div class="afRow">
				<div class="afCol-98">
					<xsl:choose>
						<xsl:when test="$pIssuerName">
							<div class="afC">
								<xsl:value-of select="$pIssuerName"/>
							</div>
							<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft80">
								<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<div class="afC">
								орган, выдавший документ
							</div>
							<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft170">
								<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
							</p>
						</xsl:otherwise>
					</xsl:choose>
				</div><p>,</p>	
			</div>
			<xsl:if test="($pData or $pDataSpecial) or $pBirthDate = '1'">
				<div class="afRow">
					<div class="afC">дата рождения </div>
					<div class="afCol-1-4">
						<p class="afValue afUnderlinedAlignLeftPadding">
							<xsl:if test="$pData">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate" select="$pData"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="$pDataSpecial">
								<xsl:call-template name="УТ8:DateSpecialStr">
									<xsl:with-param name="pDate" select="$pDataSpecial"/> 
								</xsl:call-template>
							</xsl:if>
						</p>
					</div>
					<p>,</p>
				</div>
			</xsl:if>
			<xsl:if test="$pBirthplace">
				<div class="afRow">
					<div class="afCol-98">
						<div class="afC">место рождения</div>
						<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft110">
							<xsl:call-template name="УТ8:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"/> 
							</xsl:call-template>	
						</p>
					</div>
					<xsl:choose>
						<xsl:when test="$pPeriod = '1'"><p>,</p></xsl:when>
						<xsl:otherwise><p>.</p></xsl:otherwise>
					</xsl:choose>
				</div>
			</xsl:if>
			<xsl:if test="$pPeriod = '1'">
				<div class="afRow">
					<div class="afC">срок действия документа <span class="afSubscriptNormal"> (при наличии в документе)</span></div>
					<p class="afCol-1-4 afValue afUnderlinedAlignLeftPadding afMarginLeft200">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
					<p>.</p>
				</div>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="ZNDUPStr98">
		<xsl:param name="pDocument"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:param name="pDocName"/>
		<xsl:param name="pIssuerName"/>
		<div class="afRow">
			<div class="afC">
				<xsl:value-of select="$pDocName"/>
			</div>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">наименование:</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft110">
					<xsl:value-of select="$pDocument/УТ8:Наименование"/>
				</p>
			</div>
			<p>,</p>
		</div>
		<div class="afRow">
			<div class="afCol-1-6 afMarginLeft5">серия <span class="afSubscriptNormal">(при наличии)</span>
			</div>
			<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
				<xsl:value-of select="$pDocument/УТ8:Серия"/>
			</div>
			<div class="afCol-2-25">,&#160;&#160;&#160;номер</div>
			<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
				<xsl:value-of select="$pDocument/УТ8:Номер"/>
			</div>
			<div class="afCol-1-7">,&#160;&#160;&#160;дата выдачи</div>
			<div class="afCol-3-20 afValue afUnderlinedAlignLeftPadding">
				<xsl:call-template name="DateShortStr">
					<xsl:with-param name="pDate" select="$pDocument/УТ8:ДатаВыдачи"/>
				</xsl:call-template>
			</div>,
			</div>
		<div class="afRow">
			<div class="afCol-98">
				<xsl:choose>
					<xsl:when test="$pIssuerName">
						<div class="afC">
							<xsl:value-of select="$pIssuerName"/>
						</div>
						<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft80">
							<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
						</p>
					</xsl:when>
					<xsl:otherwise>
						<div class="afC">
							орган, выдавший документ
						</div>
						<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft170">
							<xsl:value-of select="$pDocument/УТ8:КемВыдан"/>
						</p>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:choose>
				<xsl:when test="$pPeriod = '1'"><p>,</p></xsl:when>
				<xsl:otherwise><p>.</p></xsl:otherwise>
			</xsl:choose>
			
		</div>
		<xsl:if test="$pPeriod = '1'">
			<div class="afRow">
				<xsl:choose>
					<xsl:when test="$pPeriodNote = '1'">
						<div class="afC">срок действия полномочий <span class="afSubscriptNormal">(при наличии)</span></div>
					</xsl:when>
					<xsl:otherwise>
						<div class="afC">срок действия полномочий</div>
					</xsl:otherwise>
				</xsl:choose>
				<p class="afCol-1-4 afValue afUnderlinedAlignLeftPadding afMarginLeft200">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pDocument/УТ8:СрокДействия"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
				<p>.</p>
			</div>
		</xsl:if>
	</xsl:template>
	
	<!-- Тип представителя ПР9 -->
	<xsl:template name="ПР9:RepresentativeType">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pType1Text" select="'законный представитель несовершеннолетнего или недееспособного лица'"/>
		<xsl:param name="pNoteStyle" select="'afItalic'"/>
		<xsl:choose>
			<xsl:when test="$pRepresent">
				<span> (<xsl:choose>
						<xsl:when test="$pRepresent/ПР9:Тип/УТ8:ЗаконныйПР and count($pRepresent/ПР9:ЮридическоеЛицо) = 0">
							<span class="afUnderline">
								<xsl:value-of select="$pType1Text"/>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$pType1Text"/>
						</xsl:otherwise>
					</xsl:choose>,&#160;<xsl:choose>
						<xsl:when test="count($pRepresent/ПР9:ЮридическоеЛицо) > 0">
							<span class="afUnderline">организация, на которую возложено исполнение обязанностей опекуна или попечителя</span>
						</xsl:when>
						<xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise>
					</xsl:choose>,&#160;<xsl:choose>
						<xsl:when test="$pRepresent/ПР9:Тип/УТ8:ДоверенноеЛицо and count($pRepresent/ПР9:ЮридическоеЛицо) = 0">
							<span class="afUnderline">доверенное лицо</span>
						</xsl:when>
						<xsl:otherwise>доверенное лицо</xsl:otherwise>
					</xsl:choose>) <span class="{$pNoteStyle}">(нужное подчеркнуть):</span>
				</span>
			</xsl:when>
			<xsl:otherwise>(законный представитель недееспособного лица, организация, на которую возложено исполнение обязанностей опекуна или попечителя, доверенное лицо) <span class="{$pNoteStyle}">(нужное подчеркнуть)</span>:</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Представитель ПР9 -->
	<xsl:template name="ПР9:RepresentativeStr">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNewPhoneNoMail"/>
		<xsl:param name="pNoTab"/>
		<div class="afCol-98">
			<xsl:choose>
				<xsl:when test="$pNoTab = '1'">
					<p class="afC">2. Представитель 
						<xsl:call-template name="ПР9:RepresentativeType">
							<xsl:with-param name="pRepresent" select="$pRepresent"/>
						</xsl:call-template>
					</p>
				</xsl:when>
				<xsl:otherwise>
					<p class="afParagraph">2. Представитель 
						<xsl:call-template name="ПР9:RepresentativeType">
							<xsl:with-param name="pRepresent" select="$pRepresent"/>
						</xsl:call-template>
					</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР9:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ8:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
								<span class="afUnderline afValue">
									<xsl:call-template name="АдресРФ">
										<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
										<xsl:with-param name="pType" select="1"/>
									</xsl:call-template>
						</span>,
							</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес">
					<div class="afC">юридический адрес организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес/УТ8:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес/УТ8:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">юридический адрес организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft210"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес">
					<div class="afC">место нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес/УТ8:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес/УТ8:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">место нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft200"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<xsl:choose>
			<xsl:when test="$pNewPhoneNoMail = '1'">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:Телефон"/>
					</div>
					<p>,</p>
				</div>
			</xsl:when>
			<xsl:when test="$pNewPhoneNoMail = '2'">
				<div class="afRow">
					<div class="afCol-98">
						<div class="afC">номер телефона</div>
						<div class="afCol-1-5 afValue afUnderlinedBlock">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:Телефон"/>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<div class="afC">,&#160;адрес электронной почты</div>
						<div class="afCol-3-8 afValue afUnderlinedBlock">
							<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресЭлПочты"/>
						</div>
					</div>
					<p>.</p>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:Телефон"/>
					</div>
					<p>,</p>
				</div>
				<div class="afRow">
					<div class="afC">Адрес электронной почты</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресЭлПочты"/>
					</div>
					<p>.</p>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<p class="afInterval"/>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Наименование"/>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Серия, ' ', $pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Наименование"/>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Серия, ' ', $pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>	
	<!-- Представитель КСП9 -->
	<xsl:template name="ПР9:RepresentativeKSP">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNoEmail"/>
		<p class="afC">2. Представитель <xsl:call-template name="ПР9:RepresentativeType">
				<xsl:with-param name="pRepresent" select="$pRepresent"/>
				<xsl:with-param name="pType1Text" select="'законный представитель недееспособного лица'"/>
			</xsl:call-template>
		</p>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР9:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ8:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '1'">
					<div class="afCol-98">
						<div class="afC">адрес места жительства
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
									<xsl:with-param name="pType" select="1"/>
								</xsl:call-template>
							</span>,
						</div>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес">
					<div class="afC">адрес места нахождения организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес/УТ8:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес/УТ8:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес">
					<div class="afC">адрес места нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес/УТ8:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес/УТ8:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft270"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<xsl:choose>
					<xsl:when test="$pNoEmail = '1'">
						<div class="afC">номер телефона</div>
						<p class="afValue afUnderlinedBlock afMarginLeft110">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:Телефон"/>
								</xsl:otherwise>
							</xsl:choose>
						</p><p>.</p>
					</xsl:when>
					<xsl:otherwise>	
						<div class="afC">номер телефона</div>
						<div class="afCol-1-5 afValue afUnderlinedBlock">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:Телефон"/>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<div class="afC">,&#160;адрес электронной почты</div>
						<div class="afCol-3-8 afValue afUnderlinedBlock">
							<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресЭлПочты"/>
						</div><p>.</p>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</div>
		<p class="afInterval"/>
		<p class="afInterval"/>
		<table class="afTable afTable98 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Наименование"/>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Серия, ' ', $pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable98 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Наименование"/>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Серия, ' ', $pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<!-- Представитель ПР9 ЕДВ-->
	<xsl:template name="ПР9:RepresentativeEDV">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNewPhoneNoMail"/>
		<div class="afRow">
			<p class="afC">2. Представитель:</p>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<p class="afValue afCenter afUnderlinedBlock">
					<xsl:if test="$pRepresent/ПР9:ЮридическоеЛицо">
						<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Наименование"/>,&#160; 
					</xsl:if>
					<xsl:call-template name="УТ8:NameStr">
						<xsl:with-param name="pName" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:ФИО"/>
					</xsl:call-template>
				</p>
				<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
					имя, отчество (при наличии) ее представителя)</p>
			</div>
			<p>,</p>
		</div>
		
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
						<span class="afUnderline afValue">
							<xsl:call-template name="АдресРФ">
								<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
								<xsl:with-param name="pType" select="1"/>
							</xsl:call-template>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
						<span class="afUnderline afValue">
							<xsl:call-template name="АдресРФ">
								<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
								<xsl:with-param name="pType" select="2"/>
							</xsl:call-template>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ/УТ8:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
						<span class="afUnderline afValue">
							<xsl:call-template name="АдресРФ">
								<xsl:with-param name="pAddressRF" select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресРФ"/>
								<xsl:with-param name="pType" select="3"/>
							</xsl:call-template>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес">
					<div class="afC">юридический адрес организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес/УТ8:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес/УТ8:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:ЮрАдрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">юридический адрес организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft210"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес">
					<div class="afC">место нахождения организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес/УТ8:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес/УТ8:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР9:ЮридическоеЛицо/ПР9:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">место нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft200"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>

		
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">Контактный телефон</div>
				<p class=" afValue afUnderlinedBlock afMarginLeft140">
					<xsl:choose>
						<xsl:when test="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон">
							<xsl:value-of select="$pRepresent/ПР9:ЮридическоеЛицо/УТ8:Телефон"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:Телефон"/>
						</xsl:otherwise>
					</xsl:choose>
				</p>
			</div>
			<p>,</p>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">Адрес электронной почты:</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:АдресЭлПочты"/>
				</p>
			</div>
			<p>,</p>
		</div>
	
		<table class="afTable afTable98 afNoBreakInside">
			<colgroup>
				<col class="afTable40"/>
				<col class="afTable20"/>
				<col class="afTable20"/>
				<col class="afTable20"/>
			</colgroup>
			<tr>
				<td>Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Наименование"/>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Серия, ' ', $pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
						<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР9:АнкетныеДанные/УТ8:УдостоверяющийДокумент/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable98 afNoBreakInside">
			<colgroup>
				<col class="afTable40"/>
				<col class="afTable20"/>
				<col class="afTable20"/>
				<col class="afTable20"/>
			</colgroup>
			<tr>
				<td>Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Наименование"/>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Серия, ' ', $pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ8:ДокументПодтверждающийПолномочия/УТ8:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>	
	
	<xsl:template name="АдресРФ">
		<xsl:param name="pAddressRF"/>
		<xsl:param name="pType"/>
		<xsl:choose>
			<xsl:when test="$pAddressRF[УТ8:ТипАдреса = $pType]/УТ8:Неструктурированный">
				<xsl:value-of select="$pAddressRF[УТ8:ТипАдреса = $pType]/УТ8:Неструктурированный"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="УТ8:AddressStr">
					<xsl:with-param name="pAddress" select="$pAddressRF[УТ8:ТипАдреса =  $pType]"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
