<!DOCTYPE html [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://пф.рф/УПП/2023-01-10" xmlns:УПП="http://пф.рф/УПП/типы/2023-01-10" xmlns:АФ6="http://пф.рф/АФ/2023-01-10" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10">
	<xsl:include href="../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Протокол проверки отчетности</title>
				<style type="text/css">
                    .afHeader{
                        font-size: 1.1666666em;
                        font-weight: bold;
                        text-align: center;
                    }
                    .afSmallSize{
                        font-size: 0.8333333em;
                    }
                    .afTable{
                        border-collapse: collapse;
                        border: 1px solid black;
                    }
                    .afTable td, th{
                        border: 1px solid black;
                        padding: 2px;
                    }
                    .afTable100{
                        width: 100%;
                    }
                    .afBold{
                        font-weight: bold;
                    }
                    .afCenter{
                        text-align: center;
                    }                    
                    .afRed {
                        color: red;
                    }
                    .afGreen {
                        color:green;
                    }
                    
                    .afPageBreakAfter {
						page-break-after: always
					}
					
					.afSignature {
						font-size: 0.8em;
						line-height: 1em;
						
						width: 320px;
						border: solid 1px #1D6FB6;
						color: #1D6FB6;
						font-weight: bold;
						padding: 0 0 5px 5px;
					}
					
					.afSignature p {
						width: 100%;
						text-align: center;
						font-size: 1em;
						padding: 0;
					}
					
					.afNoBreakInside {
						page-break-inside: avoid;
						-webkit-column-break-inside: avoid;
						break-inside: avoid;
						position: relative;
					}
					
					.afInterval {
						padding: 5px;
						clear: both;
						margin: 0;
					}

                </style>
			</head>
			<body>
		
				<xsl:variable name="warning" select="count(descendant::УПП:Проверка[УПП:КодРезультата = '10'] | descendant::УПП:Проверка[УПП:КодРезультата = '20'])"/>
				<xsl:variable name="error" select="count(descendant::УПП:Проверка[УПП:КодРезультата = '30'] | descendant::УПП:Проверка[УПП:КодРезультата = '40'])"/>
				<xsl:variable name="criticalError" select="count(descendant::УПП:Проверка[УПП:КодРезультата = '50'])"/>
	<!--			
				

				
				<xsl:variable name="warning" select="//ns1:ЭДСФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат//УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                    //ns1:ЭДСФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат//УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']"/>
				
				<xsl:variable name="error" select="/ns1:ЭДСФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] |
                    /ns1:ЭДСФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']"/>                    
				<xsl:variable name="criticalError" select="//ns1:ЭДСФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат//УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']"/>
	-->				
				<xsl:variable name="not_szvm_is" select="not(/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М' or @КодФормы = 'ОДВ-1' or @КодФормы = 'СЗВ-ИСХ' or @КодФормы = 'СЗВ-КОРР' or @КодФормы = 'СЗВ-СТАЖ'])"/>
				<xsl:variable name="is_szvm" select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М']"/>
				<xsl:variable name="is_szvstg" select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-СТАЖ']"/>
				<xsl:variable name="is_szvish" select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-ИСХ']"/>
				<xsl:variable name="is_szvcorr" select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-КОРР']"/>
				<xsl:variable name="is_odv1" select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'ОДВ-1']"/>
				<xsl:variable name="not_adv" select="not(/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'АДВ-1' or @КодФормы = 'АДВ-2' or @КодФормы = 'АДВ-3'])"/>
				<xsl:variable name="not_dsv" select="not(/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент[@КодФормы = 'ДСВ-1' or @КодФормы = 'ДСВ-3'])"/>
				<link rel="stylesheet" type="text/css" href="AFStyles/A4Portrait.css"/>
				<h1 class="afHeader">Протокол проверки отчетности</h1>
				<div class="afSmallSize">
					<div>Дата и время формирования УПП:&nbsp;<xsl:value-of select="translate(child::*[local-name(.) = 'ЭДСФР']//АФ6:ДатаВремя, 'T', ' ')"/>
					</div>
					<div>ID#&nbsp;<xsl:value-of select="child::*[local-name(.) = 'ЭДСФР']//АФ6:GUID"/>
					</div>
					<div>Проверочный модуль:
                        <xsl:for-each select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверочныйМодуль">
							<xsl:if test="position() > 1">,&nbsp;</xsl:if>&quot;<xsl:value-of select="@Наименование"/>&quot;</xsl:for-each>
					</div>
				</div>
				<xsl:if test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент">
					<div style="padding-top: 5px">
                        Информация о страхователе:
                        <table class="afTable">
							<tr>
								<td>Регистрационный номер в СФР</td>
								<td class="afBold">
									<xsl:if test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:РегНомер !=''">
										<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:РегНомер"/>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td>ИНН</td>
								<td class="afBold">
									<xsl:if test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:ИНН">
										<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:ИНН"/>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td>КПП</td>
								<td class="afBold">
									<xsl:if test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:КПП">
										<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:КПП"/>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<td>Наименование организации</td>
								<td class="afBold">
									<xsl:choose>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:Наименование">
											<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:Наименование"/>
										</xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:НаименованиеКраткое">
											<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:Контрагент/УТ6:НаименованиеКраткое"/>
										</xsl:when>
										<xsl:otherwise>Отсутствует</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</table>
					</div>
				</xsl:if>
				<div style="padding-top: 5px">
                    Проверяемые документы:
                    <table class="afTable">
						<tr>
							<td>Код формы</td>
							<td class="afBold">
								<xsl:value-of select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверяемыйДокумент/@КодФормы"/>
							</td>
						</tr>
						<xsl:if test="($is_szvstg or $is_szvcorr or $is_szvm or $is_odv1) and /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки">
							<tr>
								<td>Тип сведений</td>
								<td class="afBold">
									<xsl:choose>
										<xsl:when test="$is_szvstg">
											<xsl:choose>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 0">ИСХОДНАЯ</xsl:when>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1">ДОПОЛНЯЮЩАЯ</xsl:when>
												<xsl:otherwise>НАЗНАЧЕНИЕ ПЕНСИИ</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:when test="$is_szvcorr">
											<xsl:choose>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 0">КОРРЕКТИРУЮЩАЯ</xsl:when>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1">ОТМЕНЯЮЩАЯ</xsl:when>
												<xsl:otherwise>ОСОБАЯ</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:when test="$is_szvm">
											<xsl:choose>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1">ИСХОДНАЯ</xsl:when>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 2">ДОПОЛНЯЮЩАЯ</xsl:when>
												<xsl:otherwise>ОТМЕНЯЮЩАЯ</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1">КОРРЕКТИРУЮЩАЯ</xsl:when>
												<xsl:otherwise>ОТМЕНЯЮЩАЯ</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:КоличествоЗЛ">
							<tr>
								<td>Количество застрахованных лиц</td>
								<td class="afBold">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:КоличествоЗЛ"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод">
							<tr>
								<td>Отчетный период</td>
								<td class="afBold">
									<xsl:choose>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 3 or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '03' or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '3'">
                                            I квартал <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                       </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 6 or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '06' or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '6'">
                                            полугодие <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 9 or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '09' or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '9'">
                                            9 месяцев <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 0 or /ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '12'">
                                            за <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> год
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 1">
                                            январь <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 2">
                                            февраль <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 3">
                                            март <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 4">
                                            апрель <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 5">
                                            май <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 6">
                                            июнь <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 7">
                                            июль <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 8">
                                            август <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 9">
                                            сентябрь <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 10">
                                            октябрь <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 11">
                                            ноябрь <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
                                        </xsl:when>
										<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 12">
											декабрь <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года
										</xsl:when>
										<xsl:otherwise>
                                             за <xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> год
                                        </xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td>Наименование файла</td>
							<td class="afBold">
								<xsl:value-of select="/child::*[local-name(.) = 'ЭДСФР']/descendant::УПП:ПроверяемыйДокумент/УПП:Файл/@ИмяФайла"/>
							</td>
						</tr>
					</table>
				</div>
				
				<div style="padding-top: 5px">
                    Результат проверки:
                    <table class="afTable afTable100 afCenter">
						<tr class="afBold">
							<td>Предупреждений</td>
							<td>Ошибок</td>
							<td>Грубых ошибок</td>
						</tr>
                   	
						<tr>
	 <!--					
							 <td>
                              <xsl:value-of select="count($warning)"/>
                          </td>
                          <td>
                              <xsl:value-of select="count($error)"/>
                          </td>
                          <td>
                              <xsl:value-of select="count($criticalError)"/>
                          </td>
						
	-->						
                    	<td>
								<xsl:value-of select="$warning"/>
							</td>
							<td>
								<xsl:value-of select="$error"/>
							</td>
							<td>
								<xsl:value-of select="$criticalError"/>
							</td>

						</tr>
					</table>
				</div>
				
				
				
				
				<xsl:choose>
					<xsl:when test="$criticalError or $error">
						<p class="afPageBreakAfter"/>
						<p class="afInterval"/>
						<link rel="stylesheet" type="text/css" href="AFStyles/A4PL.css"/>
						<h2 class="afRed afCenter">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:РезультатПроверки != ''">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:РезультатПроверки"/>
								</xsl:when>
								<xsl:otherwise>Документ не прошел форматно-логический контроль (необходимо исправить ошибки)!</xsl:otherwise>
							</xsl:choose>
						</h2>
						<xsl:for-each select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверочныйМодуль">
                            Перечень выявленных предупреждений и ошибок
                            <xsl:call-template name="printValidateModule"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="not (/ns1:ЭДСФР) or not(/ns1:ЭДСФР/ns1:УПП/УПП:ПроверяемыйДокумент)">
						<h1 class="afHeader afP afRed">Ошибка визуализации протокола проверки!</h1>
					</xsl:when>
					<xsl:otherwise>
						<h2 class="afGreen afCenter">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:РезультатПроверки != ''">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:СлужебнаяИнформация/ns1:РезультатПроверки"/>
								</xsl:when>
								<xsl:otherwise>Документ успешно прошел форматно-логический контроль!</xsl:otherwise>
							</xsl:choose>
						</h2>
						<xsl:if test="$warning &gt; 0">
							<p class="afPageBreakAfter"/>
							<p class="afInterval"/>
							<link rel="stylesheet" type="text/css" href="AFStyles/A4PL.css"/>
							<xsl:for-each select="/child::*[local-name(.) = 'ЭДСФР']//УПП:ПроверочныйМодуль">
								Перечень выявленных предупреждений и ошибок
								<xsl:call-template name="printValidateModule"/>
							</xsl:for-each>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				<div class="afNoBreakInside">
					<xsl:if test="/ns1:ЭДСФР/sig:SignInfo">
						<xsl:call-template name="PrintSignInfo">
							<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
						</xsl:call-template>
					</xsl:if>
				</div>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="printValidateModule">
		<xsl:for-each select="УПП:ПроверкаФайлов/УПП:Файл">
			<xsl:variable name="needYellow" select="not(/child::*[local-name(.) = 'ЭДСФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М' or @КодФормы = 'ОДВ-1' or @КодФормы = 'СЗВ-ИСХ' or @КодФормы = 'СЗВ-КОРР' or @КодФормы = 'СЗВ-СТАЖ' or @КодФормы = 'АДВ-1' or @КодФормы = 'АДВ-2' or @КодФормы = 'АДВ-3' or @КодФормы = 'ДСВ-1' or @КодФормы = 'ДСВ-3'])"/>
			<xsl:variable name="hardErr" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']"/>
			<xsl:if test="count($hardErr) &gt; 0">
				<h3>Грубые ошибки</h3>
				<table class="afTable afTable100">
					<xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '50']//УПП:ОжидаемоеЗначение) &gt; 0"/>
					<xsl:call-template name="printTableHeader">
						<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
					</xsl:call-template>
					<xsl:for-each select="$hardErr">
						<xsl:call-template name="printCheckBlock">
							<xsl:with-param name="numPP" select="position()"/>
							<xsl:with-param name="codeFrom" select="'50'"/>
							<xsl:with-param name="codeTo" select="'50'"/>
							<xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
							<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
						</xsl:call-template>
					</xsl:for-each>
				</table>
			</xsl:if>
			<xsl:variable name="err" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']"/>
			<xsl:if test="count($err) &gt; 0">
				<h3>Ошибки</h3>
				<table class="afTable afTable100">
					<xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '30']//УПП:ОжидаемоеЗначение | УПП:Результат//УПП:Проверка[УПП:КодРезультата = '40']//УПП:ОжидаемоеЗначение ) &gt; 0"/>
					<xsl:call-template name="printTableHeader">
						<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
					</xsl:call-template>
					<xsl:for-each select="$err">
						<xsl:choose>
							<xsl:when test="$needYellow">
								<xsl:call-template name="printCheckBlock">
									<xsl:with-param name="numPP" select="position()"/>
									<xsl:with-param name="codeFrom" select="'30'"/>
									<xsl:with-param name="codeTo" select="'40'"/>
									<xsl:with-param name="recultCodeCss" select="string('background-color: yellow')"/>
									<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="printCheckBlock">
									<xsl:with-param name="numPP" select="position()"/>
									<xsl:with-param name="codeFrom" select="'30'"/>
									<xsl:with-param name="codeTo" select="'40'"/>
									<xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
									<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</table>
			</xsl:if>
			<xsl:variable name="lightErr" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']"/>
			<xsl:if test="count($lightErr) &gt; 0">
				<h3>Предупреждения</h3>
				<table class="afTable afTable100">
					<xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '10']//УПП:ОжидаемоеЗначение | УПП:Результат//УПП:Проверка[УПП:КодРезультата = '20']//УПП:ОжидаемоеЗначение) &gt; 0"/>
					<xsl:call-template name="printTableHeader">
						<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
					</xsl:call-template>
					<xsl:for-each select="$lightErr">
						<xsl:call-template name="printCheckBlock">
							<xsl:with-param name="numPP" select="position()"/>
							<xsl:with-param name="codeFrom" select="'10'"/>
							<xsl:with-param name="codeTo" select="'20'"/>
							<xsl:with-param name="recultCodeCss" select="string('')"/>
							<xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
						</xsl:call-template>
					</xsl:for-each>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="printTableHeader">
		<xsl:param name="hasExpectedValue"/>
		<tr class="afBold">
			<td style="width: 5%">№ п/п</td>
			<td style="width: 15%">Код проверки</td>
			<td style="width: 10%">Код результата</td>
			<td style="width:25%">Описание проверки</td>
			<td>Место ошибки</td>
			<xsl:if test="$hasExpectedValue">
				<td>Ожидаемое значение</td>
			</xsl:if>
		</tr>
	</xsl:template>
	<xsl:template name="printCheckBlock">
		<xsl:param name="numPP"/>
		<xsl:param name="codeFrom"/>
		<xsl:param name="codeTo"/>
		<xsl:param name="recultCodeCss"/>
		<xsl:param name="hasExpectedValue"/>
		<xsl:for-each select="УПП:БлокПроверок">
			<xsl:call-template name="printCheckBlock">
				<xsl:with-param name="numPP" select="position()"/>
				<xsl:with-param name="recultCodeCss" select="$recultCodeCss"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:variable name="cntError" select="count(child::*[./УПП:КодРезультата = $codeFrom] | child::*[./УПП:КодРезультата = $codeTo])"/>
		<xsl:variable name="colSpan" select="5+number($hasExpectedValue)"/>
		<xsl:if test="$cntError &gt; 0">
			<tr>
				<td colspan="{$colSpan}">
					<xsl:value-of select="concat($numPP,'. ',@Название)"/>
				</td>
			</tr>
			<xsl:for-each select="УПП:Проверка[./УПП:КодРезультата = $codeFrom] | УПП:Проверка[./УПП:КодРезультата = $codeTo]">
				<xsl:variable name="cntErrorObj" select="count(.//УПП:Ошибка)"/>
				<xsl:variable name="position" select="position()"/>
				<!--если в протоколе нет сведений об ошибках для этой проверки, но правило сработало
				например, для АФ.СХ.1.1 текст ошибки выводится в элемент ОписаниеПроверки, а элементы Ошибка отсутствуют 
				-->
								
				<xsl:choose>
					<xsl:when test="$cntErrorObj=0">
						<tr>                        
							<td style="vertical-align: top">
								<xsl:value-of select="concat($numPP,'.',$position)"/>
							</td>                                            
							<td style="vertical-align: top">
								<xsl:value-of select="@ID"/>
							</td>
							<td align="center" style="vertical-align: top; {$recultCodeCss}">
								<xsl:value-of select="УПП:КодРезультата"/>
							</td>
							<td style="vertical-align: top">
								<xsl:value-of select="УПП:ОписаниеПроверки"/>
							</td>                        
							<td/>
						</tr>
					</xsl:when>
					<!--
					<xsl:otherwise>
						<tr>                        
							<td rowspan="{$cntErrorObj}" style="vertical-align: top">
								<xsl:value-of select="concat($numPP,'.',$position)"/>
							</td>                                            
							<td rowspan="{$cntErrorObj}" style="vertical-align: top">
								<xsl:value-of select="@ID"/>
							</td>
							<td rowspan="{$cntErrorObj}" align="center" style="vertical-align: top; {$recultCodeCss}">
								<xsl:value-of select="УПП:КодРезультата"/>
							</td>
							<td rowspan="{$cntErrorObj}" style="vertical-align: top">
								<xsl:value-of select="УПП:ОписаниеПроверки"/>
							</td>                        
							<td/>
						</tr>
					</xsl:otherwise>
-->
				</xsl:choose>

				<xsl:for-each select="УПП:Ошибки/УПП:Ошибка">
					<tr>
						<xsl:if test="position()=1">
							<td rowspan="{$cntErrorObj}" style="vertical-align: top">
								<xsl:value-of select="concat($numPP,'.',$position)"/>
							</td>
							<td rowspan="{$cntErrorObj}" style="vertical-align: top">
								<xsl:value-of select="../../@ID"/>
							</td>
							<td rowspan="{$cntErrorObj}" align="center" style="vertical-align: top; {$recultCodeCss}">
								<xsl:value-of select="../../УПП:КодРезультата"/>
							</td>
							<td rowspan="{$cntErrorObj}" style="vertical-align: top">
								<xsl:value-of select="../../УПП:ОписаниеПроверки"/>
							</td>
						</xsl:if>
						<td>
							<xsl:if test="УПП:Объект and (УПП:Объект/УПП:Наименование/text() or УПП:Объект/УПП:Значение/text())">
								<xsl:if test="УПП:Объект/УПП:Наименование">
									<xsl:value-of select="concat(УПП:Объект/УПП:Наименование, '=')"/>
								</xsl:if>
								<span class="afValue">
									<xsl:value-of select="УПП:Объект/УПП:Значение"/>
								</span>
								<br/>
							</xsl:if>
							<xsl:value-of select="concat('Путь до элемента: ', УПП:ПутьДоЭлемента)"/>
						</td>
						<xsl:if test="$hasExpectedValue">
							<td>
								<xsl:choose>
									<xsl:when test="УПП:ОжидаемоеЗначение">
										<xsl:value-of select="УПП:ОжидаемоеЗначение"/>
									</xsl:when>
								</xsl:choose>
							</td>
						</xsl:if>
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template name="printValidateModuleOld">
		<xsl:for-each select="УПП:ПроверкаФайлов/УПП:Файл">
			<xsl:variable name="needYellow" select="not(/child::*[local-name(.) = 'ЭДСФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М' or @КодФормы = 'ОДВ-1' or @КодФормы = 'СЗВ-ИСХ' or @КодФормы = 'СЗВ-КОРР' or @КодФормы = 'СЗВ-СТАЖ' or @КодФормы = 'АДВ-1' or @КодФормы = 'АДВ-2' or @КодФормы = 'АДВ-3' or @КодФормы = 'ДСВ-1' or @КодФормы = 'ДСВ-3'])"/>
			<xsl:if test="count(УПП:Результат//УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']) &gt; 0">
				<h3>Грубые ошибки</h3>
				<table class="tableBorder width100">
					<tr class="tableHeader">
						<td>№ п/п</td>
						<td>Блок проверок</td>
						<td>Код проверки</td>
						<td>Код результата</td>
						<td>Описание проверки</td>
						<td>Место ошибки</td>
						<td>Ожидаемое значение</td>
					</tr>
					<xsl:for-each select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']">
						<xsl:call-template name="printCheckBlock">
							<xsl:with-param name="numPP" select="position()"/>
							<xsl:with-param name="codeFrom" select="'50'"/>
							<xsl:with-param name="codeTo" select="'50'"/>
							<xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
						</xsl:call-template>
					</xsl:for-each>
				</table>
			</xsl:if>
			<xsl:if test="count(УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']) &gt; 0">
				<h3>Ошибки</h3>
				<table class="tableBorder width100">
					<tr class="tableHeader">
						<td>№ п/п</td>
						<td>Блок проверок</td>
						<td>Код проверки</td>
						<td>Код результата</td>
						<td>Описание проверки</td>
						<td>Место ошибки</td>
						<td>Ожидаемое значение</td>
					</tr>
					<xsl:for-each select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']">
						<xsl:choose>
							<xsl:when test="$needYellow">
								<xsl:call-template name="printCheckBlock">
									<xsl:with-param name="numPP" select="position()"/>
									<xsl:with-param name="codeFrom" select="'30'"/>
									<xsl:with-param name="codeTo" select="'40'"/>
									<xsl:with-param name="recultCodeCss" select="string('background-color: yellow')"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="printCheckBlock">
									<xsl:with-param name="numPP" select="position()"/>
									<xsl:with-param name="codeFrom" select="'30'"/>
									<xsl:with-param name="codeTo" select="'40'"/>
									<xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</table>
			</xsl:if>
			<xsl:if test="count(УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']) &gt; 0">
				<h3>Предупреждения</h3>
				<table class="tableBorder width100">
					<tr class="tableHeader">
						<td>№ п/п</td>
						<td>Блок проверок</td>
						<td>Код проверки</td>
						<td>Код результата</td>
						<td>Описание проверки</td>
						<td>Место ошибки</td>
						<td>Ожидаемое значение</td>
					</tr>
					<xsl:for-each select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']">
						<xsl:call-template name="printCheckBlock">
							<xsl:with-param name="numPP" select="position()"/>
							<xsl:with-param name="codeFrom" select="'10'"/>
							<xsl:with-param name="codeTo" select="'20'"/>
							<xsl:with-param name="recultCodeCss" select="string('')"/>
						</xsl:call-template>
					</xsl:for-each>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="printCheckBlockOld">
		<xsl:param name="numPP"/>
		<xsl:param name="codeFrom"/>
		<xsl:param name="codeTo"/>
		<xsl:param name="recultCodeCss"/>
		<xsl:for-each select="УПП:БлокПроверок">
			<xsl:call-template name="printCheckBlock">
				<xsl:with-param name="numPP" select="position()"/>
				<xsl:with-param name="recultCodeCss" select="$recultCodeCss"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:variable name="cntError" select="count(child::*[./УПП:КодРезультата = $codeFrom] | child::*[./УПП:КодРезультата = $codeTo])"/>
		<xsl:variable name="title" select="@Название"/>
		<xsl:if test="$cntError &gt; 0">
			<xsl:for-each select="УПП:Проверка[./УПП:КодРезультата = $codeFrom] | УПП:Проверка[./УПП:КодРезультата = $codeTo]">
				<xsl:variable name="position" select="position()"/>
				<tr>
					<xsl:if test="$position = 1">
						<td rowspan="{$cntError}" style="vertical-align: top">
							<xsl:value-of select="$numPP"/>
						</td>
						<td rowspan="{$cntError}" style="vertical-align: top">
							<xsl:value-of select="$title"/>
						</td>
					</xsl:if>
					<td style="vertical-align: top">
						<xsl:value-of select="@ID"/>
					</td>
					<td align="center" style="vertical-align: top; {$recultCodeCss}">
						<xsl:value-of select="УПП:КодРезультата"/>
					</td>
					<td style="vertical-align: top">
						<xsl:value-of select="УПП:ОписаниеПроверки"/>
					</td>
					<td>
						<ul>
							<xsl:for-each select="УПП:Ошибки/УПП:Ошибка">
								<li>
									<xsl:if test="УПП:Объект/УПП:Наименование/node() and УПП:Объект/УПП:Значение/node()">
										<xsl:value-of select="concat(УПП:Объект/УПП:Наименование, ' = ', УПП:Объект/УПП:Значение, '. ')"/>
									</xsl:if>
									<xsl:value-of select="concat('Путь до элемента: ', УПП:ПутьДоЭлемента)"/>
								</li>
							</xsl:for-each>
						</ul>
					</td>
					<td>
						<ul>
							<xsl:for-each select="УПП:Ошибки/УПП:Ошибка">
								<xsl:choose>
									<xsl:when test="УПП:ОжидаемоеЗначение/node()">
										<li>
											<xsl:value-of select="УПП:ОжидаемоеЗначение"/>
										</li>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="УПП:ПутьДоЭлемента != 0">
											<li>не&nbsp;указано</li>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
