<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1 ВС2 ЕФС" version="1.0" xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ЕФС="http://пф.рф/ВС/ЕФС/2024-01-01" xmlns:ВС2="http://пф.рф/ВС/типы/2017-10-23" xmlns:ns1="http://пф.рф/ЕФС-1/2024-01-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:template match="/" name="inc">
		<div class="afSmallWrap12 pfrAfEFS-1">
			<p class="afRight-1-4">
                Приложение № 1<br/>
                к приказу СФР<br/>
                от 17 ноября 2023 г. <br/>№ 2281
            </p>
			<p class="afInterval"/>
			<p class="afP">Форма ЕФС-1</p>
			<p class="afValue afP afCenter">Единая форма «Сведения для ведения индивидуального (персонифицированного) учета и сведения о начисленных страховых взносах на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний (ЕФС-1)»</p>
			<p class="afInterval"/>
			<p class="afValue afP">Сведения о страхователе</p>
			<xsl:call-template name="Policyholder">
				<xsl:with-param name="Policyholder1" select="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:Страхователь"/>
				<xsl:with-param name="pTel" select="1"/>
			</xsl:call-template>
			<xsl:if test="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:СтраховательЗаКоторого">
				<p class="afInterval"/>
				<p class="afValue afP">Сведения о страхователе, за которого предоставляются сведения</p>
				<xsl:call-template name="Policyholder">
					<xsl:with-param name="Policyholder1" select="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:СтраховательЗаКоторого"/>
				</xsl:call-template>
			</xsl:if>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<table class="afTable100 afTableCollapse">
				<tbody class="afOverflowWordBreak">
					<tr>
						<td class="afTable35">
							<p class="afUnderlinedBlock afValue">
								<xsl:value-of select="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:Руководитель/УТ2:Должность"/>
							</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable20">
							<p class="afUnderlinedBlock">&#160;</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable30">
							<p class="afUnderlinedBlock afValue">
								<xsl:call-template name="УТ2:NameStr">
									<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:Руководитель/УТ2:ФИО"/>
								</xsl:call-template>
							</p>
						</td>
					</tr>
					<tr>
						<td class="afTable35">
							<p class="afSubscriptNormal afCenter">Наименование должности руководителя (уполномоченного представителя страхователя)</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable20">
							<p class="afSubscriptNormal afCenter">подпись</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable30">
							<p class="afSubscriptNormal afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
					</tr>
				</tbody>
			</table>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol2-1-2">
					<div class="afCol-6-10">
						<div class="afCol-1-2">
							<p class="afP afUnderlinedBlock afValue">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:ДатаЗаполнения"/>
								</xsl:call-template>
							</p>
							<p class="afP afCenter">(дата)</p>
						</div>
					</div>
					<div class="afC afAlignBotom afPadding">
						<br/>М.П. (при наличии)
					</div>
				</div>
			</div>
			<div id="break"/>
			<!-- Раздел 1-->
			<xsl:if test="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ">
				<p class="afHeaderLeft afP">Раздел 1. Сведения о трудовой (иной) деятельности, страховом стаже, заработной плате и дополнительных страховых взносах на накопительную пенсию</p>
				<xsl:for-each select="/ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ЗЛ">
					<xsl:if test="position() &gt; 1"><div id="break"/></xsl:if>
					<p class="afValue afP ">Подраздел 1. Сведения о трудовой (иной) деятельности, страховом стаже, заработной плате зарегистрированного лица (ЗЛ)</p>
					<div class="afRow">
						<div class="afCol-3-20">СНИЛС</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ2:СНИЛС"/>
							</div>
						</div>
						<div class="afCol-1-5 afCenterBlock">ИНН (при наличии)</div>
						<div class="afCol-1-4">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 1, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 2, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 3, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 4, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 5, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 6, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 7, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 8, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 9, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 10, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 11, 1)"/></td>
									<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ИНН, 12, 1)"/></td>
								</tr>
							</table>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Фамилия</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ2:ФИО/УТ2:Фамилия"/>
							</div>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Имя</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ2:ФИО/УТ2:Имя"/>
							</div>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Отчество (при наличии)</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ2:ФИО/УТ2:Отчество"/>
							</div>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Дата рождения</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:call-template name="DateComplex">
									<xsl:with-param name="pComplex" select="."/>
								</xsl:call-template>
							</div>
						</div>
						<div class="afCol-1-5 afCenterBlock">Статус ЗЛ</div>
						<div class="afCol-10">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 1, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 2, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 3, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 4, 1)"/>
									</td>
								</tr>
							</table>
						</div>
						<div class="afCol-1-5 afCenterBlock">Гражданство (код страны)</div>
						<div class="afCol-10">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:Гражданство, 1, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:Гражданство, 2, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:Гражданство, 3, 1)"/>
									</td>
								</tr>
							</table>
						</div>
					</div>
					
					<!--Подраздел 1.1 -->
					<p class="afInterval"/>
					<xsl:if test="ns1:СЗВ-ТД">
						<p class="afValue afP afMarginLeft15">Подраздел 1.1. Сведения о трудовой (иной) деятельности</p>
						<div class="afRow">
							<div class="afCol-1-2">Подано заявление о продолжении ведения трудовой книжки</div>
							<div class="afCol-3-20 afCenterBlock">Дата подачи</div>
							<div class="afCol-10">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="Date2GOST">
										<xsl:with-param name="pDate" select="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:Дата"/>
									</xsl:call-template>
								</div>
							</div>
							<div class="afCol-3-20 afCenterBlock">Признак отмены</div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:СтатусЗаявления = 'false' or ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:СтатусЗаявления = '0'">
												<span class="afValue">V</span>
											</xsl:if>
										</td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-1-2">Подано заявление о предоставлении сведений о трудовой деятельности</div>
							<div class="afCol-3-20 afCenterBlock">Дата подачи</div>
							<div class="afCol-10">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="Date2GOST">
										<xsl:with-param name="pDate" select="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:Дата"/>
									</xsl:call-template>
								</div>
							</div>
							<div class="afCol-3-20 afCenterBlock">Признак отмены</div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:СтатусЗаявления = 'false' or ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:СтатусЗаявления = '0'">
												<span class="afValue">V</span>
											</xsl:if>
										</td>
									</tr>
								</table>
							</div>
						</div>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afOverflowWordBreak afSmallSize">
						<tr class="afCenter">
							<td rowspan="2" class="afTable3">№ п/п</td>
							<td rowspan="2">Дата (число, месяц, год) приема, перевода, увольнения, начала договора ГПХ, окончания договора ГПХ</td>
							<td rowspan="2">Сведения о приеме, переводе, увольнении, начале договора ГПХ, окончании договора ГПХ</td>
							<td rowspan="2">Работа в районах Крайнего Севера/Работа в местностях, приравненных к районам Крайнего Севера</td>
							<td rowspan="2">Трудовая функция (должность, профессия, специальность, квалификация, конкретный вид поручаемой работы), структурное подразделение</td>
							<td rowspan="2" class="afTable7">Код выполняемой функции</td>
							<td rowspan="2">Причины увольнения, пункт, часть статьи, статья Трудового кодекса Российской Федерации, федерального закона</td>
							<td colspan="3">Основание</td>
							<td rowspan="2">Признак отмены записи</td>
						</tr>
						<tr class="afCenter">
							<td>Наименование документа</td>
							<td>Дата</td>
							<td>Номер документа</td>
						</tr>
						<tr class="afCenter afSmallSize afHeightRow">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
							<td>6</td>
							<td>7</td>
							<td>8</td>
							<td>9</td>
							<td>10</td>
							<td>11</td>
						</tr>
						<tbody class="afWordBreak afCenter">
							<xsl:if test="not(ns1:СЗВ-ТД/ns1:ТД/ns1:Мероприятие) and not(ns1:СЗВ-ТД/ns1:ТД/ns1:МероприятиеОтменяемое)">
								<tr>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
									<td>&#160;</td>
								</tr>
							</xsl:if>
							<xsl:for-each select="ns1:СЗВ-ТД/ns1:ТД/*">
								<xsl:variable name="eventS" select="local-name() = 'Мероприятие'"/>
								<xsl:variable name="eventC" select="local-name() = 'МероприятиеОтменяемое'"/>
								<tr>
									<td>
										<xsl:value-of select="position()"/>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:call-template name="Date2GOST">
													<xsl:with-param name="pDate" select="ЕФС:Дата"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:when test="$eventC">
												<xsl:call-template name="Date2GOST">
													<xsl:with-param name="pDate" select="ЕФС:ДатаМероприятия"/>
												</xsl:call-template>
											</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:call-template name="Event">
													<xsl:with-param name="pEvent" select="ЕФС:Вид"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:when test="$eventC">
												<xsl:call-template name="Event">
													<xsl:with-param name="pEvent" select="ЕФС:Вид"/>
												</xsl:call-template>
											</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:value-of select="ЕФС:РаботаКС"/>
											</xsl:when>
											<xsl:when test="$eventC">
												<xsl:value-of select="ЕФС:РаботаКС"/>
											</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:if test="ЕФС:Сведения">
													<xsl:value-of select="ЕФС:Сведения"/>
												</xsl:if>
												<xsl:if test="ЕФС:Должность">
													<xsl:choose>
														<xsl:when test="ЕФС:Сведения">,&#160;<xsl:value-of select="ЕФС:Должность"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="ЕФС:Должность"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
												<xsl:if test="ЕФС:ВидПР">
													<xsl:choose>
														<xsl:when test="ЕФС:Сведения or ЕФС:Должность">,&#160;<xsl:value-of select="ЕФС:ВидПР"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="ЕФС:ВидПР"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
												<xsl:if test="ЕФС:СтруктурноеПодразделение">
													<xsl:choose>
														<xsl:when test="ЕФС:Сведения or ЕФС:Должность or ЕФС:ВидПР">, <xsl:value-of select="ЕФС:СтруктурноеПодразделение"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="ЕФС:СтруктурноеПодразделение"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
												<xsl:if test="ЕФС:ЯвляетсяСовместителем">&#160;<xsl:value-of select="ЕФС:ЯвляетсяСовместителем"/></xsl:if>
												<xsl:if test="ЕФС:ДатаС"> с 
														<xsl:call-template name="Date2GOST">
														<xsl:with-param name="pDate" select="ЕФС:ДатаС"/>
													</xsl:call-template>
												</xsl:if>
												<xsl:if test="ЕФС:ДатаПо"> по 
														<xsl:call-template name="Date2GOST">
														<xsl:with-param name="pDate" select="ЕФС:ДатаПо"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:when>
											<xsl:when test="$eventC">
												<xsl:if test="ns1:МероприятиеОтменяемое/ЕФС:ЯвляетсяСовместителем">&#160;<xsl:value-of select="ns1:МероприятиеОтменяемое/ЕФС:ЯвляетсяСовместителем"/></xsl:if>
											</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:if test="ЕФС:КодВФ">
													<xsl:value-of select="ЕФС:КодВФ"/>
												</xsl:if>
												<xsl:if test="ЕФС:КодВФпоОКЗ">
													<xsl:choose>
														<xsl:when test="ЕФС:КодВФ">
															<br/>
															<xsl:value-of select="ЕФС:КодВФпоОКЗ"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="ЕФС:КодВФпоОКЗ"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
											</xsl:when>
											<xsl:when test="$eventC">&#160;</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:КодПричиныУвольнения">
													<xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:КодПричиныУвольнения"/>
												</xsl:if>
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:НормативныйДокумент">, <xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:НормативныйДокумент"/>
												</xsl:if>
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:Статья">, ст.<xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:Статья"/>
												</xsl:if>
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:Часть">, ч.<xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:Часть"/>
												</xsl:if>
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:Пункт">, п.<xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:Пункт"/>
												</xsl:if>
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:Подпункт">, пп.<xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:Подпункт"/>
												</xsl:if>
												<xsl:if test="ЕФС:ОснованиеУвольнения/ЕФС:Абзац">, абз.<xsl:value-of select="ЕФС:ОснованиеУвольнения/ЕФС:Абзац"/>
												</xsl:if>
												<xsl:if test="ЕФС:Причина">. <xsl:value-of select="ЕФС:Причина"/>
												</xsl:if>
											</xsl:when>
											<xsl:when test="$eventC">&#160;</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:choose>
											<xsl:when test="$eventS">
												<xsl:for-each select="ЕФС:Основание">
													<xsl:value-of select="ЕФС:Наименование"/>
													<xsl:choose>
														<xsl:when test="count(preceding-sibling::ЕФС:Основание)+1 &lt; count(//ЕФС:Основание)">
															<br/>
														</xsl:when>
														<xsl:otherwise>&#160;</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:when>
											<xsl:when test="$eventC">&#160;</xsl:when>
										</xsl:choose>
									</td>
									<td>
										<xsl:for-each select="ЕФС:Основание">
											<xsl:call-template name="Date2GOST">
												<xsl:with-param name="pDate" select="ЕФС:Дата"/>
											</xsl:call-template>
											<xsl:choose>
												<xsl:when test="count(preceding-sibling::ЕФС:Основание)+1 &lt; count(//ЕФС:Основание)">
													<br/>
												</xsl:when>
												<xsl:otherwise>&#160;</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="ЕФС:Основание">
											<xsl:if test="ЕФС:Серия">
												<xsl:value-of select="ЕФС:Серия"/>&#160;</xsl:if>
											<xsl:value-of select="ЕФС:Номер"/>
											<xsl:choose>
												<xsl:when test="count(preceding-sibling::ЕФС:Основание)+1 &lt; count(//ЕФС:Основание)">
													<br/>
												</xsl:when>
												<xsl:otherwise>&#160;</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</td>
									<td class="afCenter">
										<xsl:choose>
											<xsl:when test="$eventS">
												<div class="afCheckSmall"/>
											</xsl:when>
											<xsl:when test="$eventC">
												<div class="afCheckSmall afValue">V</div>
											</xsl:when>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
					</xsl:if>
					
					<!--Подраздел 1.2 -->
					
					<p class="afInterval"/>
					<xsl:if test="ns1:СЗВ-СТАЖ">
						<p class="afValue afP afMarginLeft15">Подраздел 1.2. Сведения о страховом стаже</p>
						<xsl:for-each select="ns1:СЗВ-СТАЖ">
							<div class="afRow">
								<div class="afCol-3-20">Отчетный период: </div>
								<div class="afCol-10">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 4, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-5">год</div>
							</div>
							<div class="afRow">
								<div class="afCol-8">Тип сведений: </div>
								<div class="afCol-6">Исходная </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='1'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-9">Назначение пенсии </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='2'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-6" style="width: 15.5%;">Назначение выплат по ОСС</div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='5'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-10-1">Корректирующая </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='3'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-8">Отменяющая </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='4'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-22">Корректируемый (отменяемый) период </div>
								<div class="afCol-7">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 4, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1">год</div>
							</div>
							<p class="afInterval"/>
							<table class="afWordBreak afTable afTable100 afTableLayoutFixed afOverflowWordBreak afSmallSize">
								<tr class="afCenter">
									<td rowspan="2" class="afTable3">№ п/п</td>
									<td colspan="2">Период работы</td>
									<td colspan="2">Территориальные условия</td>
									<td colspan="2">Особенности исчисления страхового стажа</td>
									<td colspan="3">Условия досрочного назначения страховой пенсии</td>
									<td colspan="2">Результат специальной оценкии условий труда</td>
								</tr>
								<tr class="afCenter">
									<td>с дд.мм.гггг</td>
									<td>по дд.мм.гггг</td>
									<td>Код</td>
									<td>Районный коэффициент</td>
									<td>Основание (код)</td>
									<td>Дополнительные сведения</td>
									<td>Особые условия труда (код)</td>
									<td>Основание (код)</td>
									<td>Занятость</td>
									<td>Индивидуальный номер рабочего места</td>
									<td>Класс (подкласс) условий труда</td>
								</tr>
								<tr class="afCenter afSmallSize afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
									<td>12</td>
								</tr>
								<xsl:for-each select="ns1:СтажевыйПериод">
									<xsl:variable name="vCount" select="count(./ns1:ЛьготныйСтаж)"/>
									<tr>
										<td rowspan="{$vCount+1}">
											<xsl:value-of select="position()"/>
										</td>
										<td rowspan="{$vCount+1}">
											<xsl:call-template name="Date2GOST">
												<xsl:with-param name="pDate" select="./ns1:Период/УТ2:С"/>
											</xsl:call-template>
										</td>
										<td rowspan="{$vCount+1}">
											<xsl:call-template name="Date2GOST">
												<xsl:with-param name="pDate" select="./ns1:Период/УТ2:По"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:for-each select="./ns1:ЛьготныйСтаж">
										<tr>
											<td>
												<xsl:value-of select="./ЕФС:ТУ/ЕФС:Основание"/>&#160;<xsl:value-of select="./ЕФС:ТУ/ЕФС:ДоляСтавки"/>
											</td>
											<td>
												<xsl:value-of select="./ЕФС:ТУ/ЕФС:Коэффициент"/>
											</td>
											<td>
												<xsl:value-of select="./ЕФС:ИС/ЕФС:Основание"/>
											</td>
											<td>
												<xsl:call-template name="УТ2:ProductionStr">
													<xsl:with-param name="pProduction" select="./ЕФС:ИС"/>
												</xsl:call-template>
												<xsl:if test="./ЕФС:ДопСведенияИС"><br/><xsl:value-of select="./ЕФС:ДопСведенияИС"/>
												</xsl:if>
											</td>
											<td>
												<xsl:if test="./ЕФС:ОУТ/ЕФС:Код">
													<xsl:value-of select="./ЕФС:ОУТ/ЕФС:Код"/>
												</xsl:if>
												<xsl:if test="./ЕФС:ОУТ/ЕФС:ПозицияСписка">, <xsl:value-of select="./ЕФС:ОУТ/ЕФС:ПозицияСписка"/>
												</xsl:if>
											</td>
											<td>
												<xsl:value-of select="./ЕФС:ВЛ/ЕФС:Основание"/>
											</td>
											<td>
												<xsl:call-template name="УТ2:ProductionStr">
													<xsl:with-param name="pProduction" select="./ЕФС:ВЛ"/>
												</xsl:call-template>
												<xsl:if test="./ЕФС:ВЛ/ЕФС:ДоляСтавки">&#160;<xsl:value-of select="./ЕФС:ВЛ/ЕФС:ДоляСтавки"/>
												</xsl:if>
											</td>
											<td>
												<xsl:value-of select="./ЕФС:СОУТ/ЕФС:Номер"/>
											</td>
											<td>
												<xsl:value-of select="./ЕФС:СОУТ/ЕФС:Код"/>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:for-each>
							</table>
						</xsl:for-each>
					</xsl:if>
					
					<!--Подраздел 1.3 -->
					<xsl:if test="ns1:СЗПГос">
						<p class="afInterval"/>
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 1.3.  Сведения о заработной плате и условиях осуществления деятельности работников государственных (муниципальных) учреждений</p>
					<xsl:for-each select="ns1:СЗПГос">
						<p class="afInterval"/>
						<div class="afRow">
							<div class="afCol-1-9">Отчетный период: </div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Месяц, 1, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Месяц, 2, 1)"/></td>	
									</tr>
								</table>
							</div>
							<div class="afCol-7 afCenterBlock">месяц</div>
							<div class="afCol-7 afUnderlinedBlock">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 1, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 2, 1)"/></td>	
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 3, 1)"/></td>	
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 4, 1)"/></td>	
									</tr>
								</table>
							</div>
							<div class="afCol-4 afCenterBlock">год</div>
						</div>
						<p class="afSubscript">(01 – январь, 02 – февраль, 03 – март, 04 – апрель, 05 – май, 06 – июнь, 07 – июль, 08 – август, 09 – сентябрь, 10 – октябрь, 11 – ноябрь, 12 – декабрь)</p>
						<p class="afInterval"/>
						<div class="afRow">
							<div class="afCol-10">Тип сведений: </div>
							<div class="afCol-7">Исходная </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:Тип ='1'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-9">Корректирующая </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:Тип ='2'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-9">Отменяющая </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:Тип ='3'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-4">Корректируемый (отменяемый) период </div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Месяц, 1, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Месяц, 2, 1)"/></td>	
									</tr>
								</table>
							</div>
							<div class="afCol-7 afCenterBlock">месяц</div>
							<div class="afCol-7"> 
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 1, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 2, 1)"/></td>	
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 3, 1)"/></td>	
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 4, 1)"/></td>	
									</tr>
								</table>
							</div>
							<div class="afCol-4 afCenterBlock">год</div>
						</div>
						<div class="afRow">
							<div class="afCol-1-9">КТО организации</div>
							<div class="afCol-10">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ЕФС:КодКТО, 1, 1)"/>
										</td>
										<td>.</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ЕФС:КодКТО, 3, 1)"/>
										</td>
										<td>.</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ЕФС:КодКТО, 5, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ЕФС:КодКТО, 6, 1)"/>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-4">Идентификационный номер ТОСП (если ТОСП):</div>
							<div class="afCol-1-4">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 1, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 2, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 3, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 4, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 5, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 6, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 7, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 8, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 9, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 10, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 11, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 12, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 13, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 14, 1)"/>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-10-1">OID организации</div> 
							<div class="afCol-1-6"> 
								<div class="afValue afUnderlinedBlock afWordBreak">
									<xsl:value-of select="ns1:Организация/ns1:OID"/>
								</div>
							</div>
						</div>
						<p class="afInterval"/>
						<table class="afTable afTable100 afTableLayoutFixed afTableSmallSize">
							<colgroup>
								<col class="afTable2"/>
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable7"/>
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable5"/>
								<col class="afTable3"/>
								<col class="afTable4"/>
								<col class="afTable3"/>
								<col class="afTable3"/>
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable5"/>
								<col class="afTable4"/>
								<col class="afTable5"/>
								<col class="afTable4"/>
								<col class="afTable6"/>
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable3"/>
								<col class="afTable3"/>
								<col class="afTable3"/>
							</colgroup>
							<thead>
								<tr class="afCenter afWordBreak">
									<td rowspan="2">№ п/п</td>
									<td colspan="2">Период работы в отчетном месяце</td>
									<td rowspan="2">Наименование структурного подразделения; OID</td>
									<td rowspan="2">Работники, не включаемые в расчет средне-списочной численности</td>
									<td rowspan="2">Код наименования должности (профессии)</td>
									<td rowspan="2">Код категории персонала</td>
									<td rowspan="2">Звание (степень)</td>
									<td colspan="2">Специальные (отраслевые) условия занятости</td>
									<td colspan="2">Информация о договоре</td>
									<td rowspan="2">Профессиональная квалификационная группа</td>
									<td rowspan="2">Квалификационный уровень</td>
									<td rowspan="2">Класс (подкласс) условий труда по степени вредности и (или) опасности</td>
									<td rowspan="2">Квалификационная категория, присвоенная по итогам аттестации </td>
									<td rowspan="2">Число занятых штатных единиц по должности (профессии)</td>
									<td rowspan="2">Система оплаты труда</td>
									<td rowspan="2">Размер фиксированной части в соответствии с трудовым договором (оклад, сдельная расценка за единицу выработки, часовая тарифная ставка, размер разовой концертной ставки) </td>
									<td colspan="2">Количество рабочих часов (выступлений, постановок) в отчетном месяце</td>
									<td colspan="2">Количество специальных часов работы</td>
									<td colspan="3">Сведения о заработной плате</td>
								</tr>
								<tr class="afCenter">
									<td class="afWordBreak">Дата начала</td>
									<td class="afWordBreak">Дата окончания</td>
									<td>Код</td>
									<td class="afWordBreak">Значение</td>
									<td>Вид</td>
									<td>Срок</td>
									<td>Норма</td>
									<td>Факт</td>
									<td class="afWordBreak">Код специальных часов работы</td>
									<td class="afWordBreak">Количество часов</td>
									<td><p class="vertical">Код выплаты</p></td>
									<td><p class="vertical">Сумма (руб.)</p></td>
									<td><p class="vertical">Итого</p></td>
								</tr>
								<tr class="afCenter afSmallSize afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
									<td>12</td>
									<td>13</td>
									<td>14</td>
									<td>15</td>
									<td>16</td>
									<td>17</td>
									<td>18</td>
									<td>19</td>
									<td>20</td>
									<td>21</td>
									<td>22</td>
									<td>23</td>
									<td>24</td>
									<td>25</td>
								</tr>
							</thead>
							<tbody class="afCenter afWordBreak">
								<xsl:choose>
									<xsl:when test="ns1:УЗиЗП">
										<xsl:for-each select="ns1:УЗиЗП">
											<tr>
												<td>
													<xsl:value-of select="position()"/>
												</td>
												<td>
													<xsl:call-template name="Date2GOST">
														<xsl:with-param name="pDate" select="ns1:Период/УТ2:С"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:call-template name="Date2GOST">
														<xsl:with-param name="pDate" select="ns1:Период/УТ2:По"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:value-of select="ns1:СтруктурноеПодразделение/ns1:Наименование"/>
													<xsl:if test="ns1:СтруктурноеПодразделение/ns1:OID">
														,&#160;<xsl:value-of select="ns1:СтруктурноеПодразделение/ns1:OID"/>
													</xsl:if>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="ns1:РабНеВклРасчЧисл = 'true' or ns1:РабНеВклРасчЧисл ='1'">да</xsl:when>
														<xsl:when test="ns1:РабНеВклРасчЧисл = 'false' or ns1:РабНеВклРасчЧисл ='0'">нет</xsl:when>
													</xsl:choose>
												</td>
												<td>
													<xsl:value-of select="ЕФС:КодДолжности"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:КодККП"/>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="ns1:Звание/ns1:НетЗваний">0</xsl:when>
														<xsl:otherwise>
															<xsl:if test="ns1:Звание/ns1:УченаяСтепень">
																<xsl:choose>
																	<xsl:when test="ns1:Звание/ns1:УченаяСтепень = 'КН'">Кандидат наук.</xsl:when>
																	<xsl:when test="ns1:Звание/ns1:УченаяСтепень = 'ДН'">Доктор наук.</xsl:when>
																</xsl:choose>
															</xsl:if>
															<xsl:if test="ns1:Звание/ЕФС:КодУчЗвание">
																<xsl:call-template name="AcademicTitle">
																	<xsl:with-param name="pAcademicTitle" select="ns1:Звание/ЕФС:КодУчЗвание"/>
																</xsl:call-template>.
															</xsl:if>
															<xsl:if test="ns1:Звание/ЕФС:ПчЗвание">
																<xsl:call-template name="HonoraryTitle">
																	<xsl:with-param name="pHonoraryTitle" select="ns1:Звание/ЕФС:ПчЗвание"/>
																</xsl:call-template>
															</xsl:if>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:value-of select="ns1:СоУЗ/ns1:Код"/>
												</td>
												<td>
													<xsl:value-of select="ns1:СоУЗ/ns1:Значение"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Договор/ns1:Вид"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Договор/ns1:Срок"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ЕФС:КодКУ"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:Уровень"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:Вредность"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:Аттестация"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:ШтатЕд"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:СистемаОплаты"/>
												</td>
												<td>
													<xsl:for-each select="ns1:Квалификация/ns1:РазмерФЧ">
														<xsl:value-of select="."/>
														<xsl:if test="position() &gt; 1"><br/></xsl:if>
													</xsl:for-each>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:РабВремяНорма"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:РабВремяФакт"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:КолСпецЧасовРаб/ns1:КодСпецЧ"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:КолСпецЧасовРаб/ns1:КоличСпецЧ"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:СведОЗаработПлате/ЕФС:КодВыплаты"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:СведОЗаработПлате/ns1:Сумма"/>
												</td>
												<td>
													<xsl:value-of select="ns1:Квалификация/ns1:Итого"/>
												</td>
											</tr>
											<!-- Для отрисовки вложенных кодов выплат и СоУТ -->
												<xsl:for-each select="ns1:Квалификация/ns1:СведОЗаработПлате[position()>1]">
													<xsl:variable name="coutn" select="position()+1"/>
													<tr>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td><xsl:value-of select="../../ns1:СоУЗ[$coutn]/ns1:Код"/></td>
														<td><xsl:value-of select="../../ns1:СоУЗ[$coutn]/ns1:Значение"/></td>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td>0</td>
														<td><xsl:value-of select="./ЕФС:КодВыплаты"/></td>
														<td><xsl:value-of select="./ns1:Сумма"/></td>
														<td/>
													</tr>
												</xsl:for-each>
											
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<tr>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
										</tr>
									</xsl:otherwise>
								</xsl:choose>
							</tbody>
						</table>
					</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
				
				<!-- Подраздел 2 -->
				<p class="afInterval"/>
				<xsl:if test="ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДНП">
					<div class="afNoBreakInside">
						<p class="afValue afP ">Подраздел 2. Основание для отражения данных о периодах работы застрахованного лица в условиях, дающих право на досрочное назначение пенсии в соответствии с частью 1 статьи 30 и статьей 31 Федерального закона от 28.12.2013 № 400-ФЗ «О страховых пенсиях»<span class="afSup">1</span> </p>
						<xsl:variable name="DNP" select="ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДНП"/>
						
						<div class="afRow">
							<div class="afCol-1-9">Отчетный период: </div>
							<div class="afCol-7">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 1, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 2, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 3, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 4, 1)"/></td>
									</tr>
								</table>
							</div>
							<div class="afCol-4 afCenterBlock">год</div>
						</div>
						<div class="afRow">
							<div class="afCol-10">Тип сведений: </div>
							<div class="afCol-7">Исходная </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$DNP/ns1:Тип ='1'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-9">Корректирующая </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$DNP/ns1:Тип ='2'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-9">Отменяющая </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$DNP/ns1:Тип ='3'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-22">Корректируемый (отменяемый) период </div>
							<div class="afCol-7">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 1, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 2, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 3, 1)"/></td>
										<td class="afCheckSmall"><xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 4, 1)"/></td>
									</tr>
								</table>
							</div>
							<div class="afCol-4 afCenterBlock">год</div>
						</div>
						<p class="afInterval"/>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
							<thead>
								<tr class="afCenter">
									<td class="afTable4">№ п/п</td>
									<td>Наименование структурного подразделения по штатному расписанию</td>
									<td>Наименование профессии (должности) по штатному расписанию</td>
									<td>Количество рабочих мест по штатному расписанию</td>
									<td>Численность фактически работающих</td>
									<td>Характер фактически выполняемых работ и дополнительные условия труда</td>
									<td>Наименование первичных документов, подтверждающих занятость в особых условиях труда</td>
									<td>Код особых условий труда / выслуги лет по Классификатору</td>
									<td>Код позиции Списков № 1 и 2, «малого» списка</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<xsl:choose>
									<xsl:when test="$DNP">
										<xsl:for-each select="$DNP/ns1:ОснованиеДНП">
											<tr class="afHeight14">
												<td>
													<xsl:value-of select="position()"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:Подразделение"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:Профессия"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:КоличествоШтат"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:КоличествоФакт"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:Описание"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС:Документы"/>
												</td>
												<td>
													<xsl:for-each select="ЕФС:ОУТ">
														<xsl:value-of select="ЕФС:КодОУТ"/>
														<xsl:if test="ЕФС:КодОУТ and ЕФС:КодОснованиеВЛ"> 
															/
														</xsl:if>
														<xsl:value-of select="ЕФС:КодОснованиеВЛ"/>
														<xsl:choose>
															<xsl:when test="count(preceding-sibling::ЕФС:ОУТ)+1 &lt; count(//ЕФС:ОУТ)">
																<br/>
															</xsl:when>
															<xsl:otherwise>&#160;</xsl:otherwise>
														</xsl:choose>
														
														
													</xsl:for-each>
												</td>
												<td>
													<xsl:for-each select="ЕФС:ОУТ">
														<xsl:if test="ЕФС:ПозицияСписка">
															<xsl:value-of select="ЕФС:ПозицияСписка"/>
															<xsl:choose>
																<xsl:when test="count(preceding-sibling::ЕФС:ОУТ)+1 &lt; count(//ЕФС:ОУТ)">
																	<br/>
																</xsl:when>
																<xsl:otherwise></xsl:otherwise>
															</xsl:choose>
														</xsl:if>
													</xsl:for-each>
												</td>
											</tr>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<tr class="afHeight14">
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
										</tr>
									</xsl:otherwise>
								</xsl:choose>
							</tbody>
						</table>
						<div class="afRow">
							<div class="afCol-4-10">
							Общее количество рабочих мест в особых условиях труда по штату
						</div>
							<div class="afCol-10 afUnderline afValue afCenterBlock">
							&#160;<xsl:value-of select="$DNP/ЕФС:ВсегоШтат"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-4-10">
							Численность фактически работающих в особых условиях труда
						</div>
							<div class="afCol-10 afUnderline afValue afCenterBlock">
							&#160;<xsl:value-of select="$DNP/ЕФС:ВсегоФакт"/>
							</div>
						</div>
					</div>
				</xsl:if>
				<p class="afInterval"/>
				
				<!--Подраздел 3-->
				
				<xsl:if test="ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДСВ">
					<div class="afNoBreakInside">
						<p class="afValue afP ">Подраздел 3. Сведения о застрахованных лицах, за которых перечислены дополнительные страховые взносы на накопительную пенсию и уплачены взносы работодателя</p>
						<xsl:for-each select="ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДСВ">
							<div class="afRow">
								<div class="afCol-1-6">Платежное поручение № </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:value-of select="ns1:ПлатежноеПоручение/ns1:Реквизиты/ns1:Номер"/>
								</div>
								<div class="afCol-4 afCenterBlock">от</div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="ns1:ПлатежноеПоручение/ns1:Реквизиты/ns1:Дата"/>
									</xsl:call-template>
								</div>
							</div>
							<div class="afRow">
								<div class="afCol-1-4">Дата исполнения платежного поручения </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="ns1:ПлатежноеПоручение/ns1:ДатаИсполнения"/>
									</xsl:call-template>
								</div>
							</div>
							<div class="afRow">
								<div class="afCol-10">Период уплаты </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:value-of select="ns1:Период"/>
								</div>
							</div>
							<p class="afInterval"/>
							<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
								<thead>
									<tr class="afCenter">
										<td class="afTable4">№ п/п</td>
										<td>ФИО застрахованного лица</td>
										<td>Страховой номер индивидуального лицевого счета застрахованного лица (СНИЛС)</td>
										<td>Сумма перечисленных дополнительных страховых взносов на накопительную пенсию (руб.)</td>
										<td>Сумма уплаченных взносов работодателя (в случае уплаты) (руб.)</td>
									</tr>
									<tr class="afCenter afHeightRow">
										<td>1</td>
										<td>2</td>
										<td>3</td>
										<td>4</td>
										<td>5</td>
									</tr>
								</thead>
								<tbody class="afCenter">
									<xsl:for-each select="ns1:РеестрДСВ/ns1:ЗЛ">
										<tr class="afHeight14">
											<td>
												<xsl:value-of select="position()"/>
											</td>
											<td>
												<xsl:call-template name="УТ2:NameStr">
													<xsl:with-param name="pName" select="УТ2:ФИО"/>
												</xsl:call-template>
											</td>
											<td>
												<xsl:value-of select="УТ2:СНИЛС"/>
											</td>
											<td>
												<xsl:value-of select="ns1:СуммаДСВРаботника"/>
											</td>
											<td>
												<xsl:value-of select="ns1:СуммаВзносовРаботодателя"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr class="afHeight14">
										<td>ВСЕГО</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>
											<xsl:value-of select="ns1:СуммаВсегоДСВРаботника"/>
										</td>
										<td>
											<xsl:value-of select="ns1:СуммаВсегоВзносовРаботодателя"/>
										</td>
									</tr>
								</tbody>
							</table>
							<p class="afInterval"/>
							<div class="afRow">
								<div class="afCol-3-10">Общая сумма перечисленных средств составляет </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:value-of select="ns1:ПлатежноеПоручение/ns1:СуммаИтогоПП"/>
								</div>
								<div class="afCol-10"> рублей </div>
							</div>
						</xsl:for-each>
					</div>
				</xsl:if>
			</xsl:if>
			
			<xsl:if test="ns1:ЭДПФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДНП">
				<p>___________________________________________</p>
				<p class="afP afFootnote"><span class="afSup">1</span> Собрание законодательства Российской Федерации, 2013, № 52, ст. 6965; 2021, № 18, ст. 3061.</p>
				<xsl:if test="ns1:ЭДПФР/ns1:ЕФС-1/ns1:ОСС">
					<div id="break"/>
				</xsl:if>
            </xsl:if>
			<!-- Раздел 2-->
			<xsl:if test="ns1:ЭДПФР/ns1:ЕФС-1/ns1:ОСС">
				<xsl:variable name="OSS" select="ns1:ЭДПФР/ns1:ЕФС-1/ns1:ОСС"/>
				
				<p class="afHeaderLeft afP">Раздел 2. Сведения о начисленных страховых взносах на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний</p>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-3-20">Номер корректировки</div>
					<div class="afCol-3-20">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:НомерКорректировки, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:НомерКорректировки, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:НомерКорректировки, 3, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-22 afCenterBlock">Расчетный (отчетный) период (код)</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Код, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Код, 2, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-3-20 afCenterBlock">Календарный год</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 4, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow afSubscript">
					<div class="afCol-1-3">(000 - исходная, 001 - номер корректировки)</div>
					<div class="afCol-1-3 ">(03 - 1 квартал; 06 - полугодие; 09 - 9 месяцев; 12 - год)</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10" style="width: 66%;">&#160;</div>
					<div class="afCol-1-5 afCenterBlock">Прекращение деятельности</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:if test="$OSS/ns1:ОтметкаОПрекращении = 'true' or $OSS/ns1:ОтметкаОПрекращении ='1'">Л</xsl:if>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Среднесписочная численность работников</div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
									<div class="afRow">
					<div class="afCol-6-10" style="width: 66%;">&#160;</div>
					<div class="afCol-1-5 afCenterBlock">Льгота</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:if test="$OSS/ns1:РССВ//ns1:Льгота = 'true' or $OSS/ns1:РССВ//ns1:Льгота ='1'">V</xsl:if>
								</td>
							</tr>
						</table>
					</div>
				</div>
	<!-- 				<div class="afCol-2">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:choose>
										<xsl:when test="xs:boolean($OSS/ns1:РССВ//ns1:Льгота)">V</xsl:when>
									</xsl:choose>
								</td>
							</tr>
						</table>
					</div> -->
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Численность работающих застрахованных лиц по  обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Численность работающих инвалидов</div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Численность работников, занятых на работах с вредными и (или) опасными производственными факторами </div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				
				<p class="afInterval"/>
				<p class="afValue afP afMarginLeft15">Подраздел 2.1. Расчет сумм страховых взносов</p>
				<p class="afInterval"/>
				<div class="afRight-1-3 afSubscriptNormal afCenterBlock">(руб. коп.)</div>
				<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
					<thead>
						<tr class="afCenter">
							<td rowspan="2" class="afTable40">Наименование показателя</td>
							<td rowspan="2">Код строки</td>
							<td rowspan="2">Всего с начала расчетного периода</td>
							<td rowspan="2">На конец предыдущего отчетного периода</td>
							<td colspan="3">В том числе за последние три месяца отчетного периода</td>
						</tr>
						<tr class="afCenter">
							<td>1 месяц</td>
							<td>2 месяц</td>
							<td>3 месяц</td>
						</tr>
						<tr class="afCenter afHeightRow">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
							<td>6</td>
							<td>7</td>
						</tr>
					</thead>
					<tbody class="afCenter">
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Сумма выплат и иных вознаграждений, начисленных в пользу физических лиц в соответствии со статьей 201 Федерального закона от 24 июля 1998 г. № 125-ФЗ  "Об обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний"<span class="afSup">2</span>
						</td>
							<td>1</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Сумма, не подлежащая обложению страховыми взносами в соответствии со статьей 202 Федерального закона от 24 июля 1998 г. № 125-ФЗ "Об обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний"<span class="afSup">3</span>
						</td>
							<td>2</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							База для исчисления страховых взносов &#160;&#160;&#160;&#160;&#160;&#160;&#160;(стр. 1 - стр. 2 )
						</td>
							<td>3</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							из них: сумма выплат в пользу работающих инвалидов
						</td>
							<td>4</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Размер страхового тарифа в соответствии с классом профессионального риска (%)
						</td>
							<td>5</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СтраховойТариф"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Скидка к страховому тарифу (%)
						</td>
							<td>6</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СкидкаТариф"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Надбавка к страховому тарифу (%)
						</td>
							<td>7</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:НадбавкаТариф"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Размер страхового тарифа с учетом скидки (надбавки) (%) (заполняется с тремя десятичными знаками после запятой)
						</td>
							<td>8</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ТарифУчСкидНадб"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">Исчислено страховых взносов</td>
							<td>9</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС:ТретийМесяц"/>
							</td>
						</tr>
					</tbody>
				</table>
				
			<p>___________________________________________</p>
            <p class="afP afFootnote"><span class="afSup">2</span> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2016, № 1, ст. 14.</p>
            <p class="afP afFootnote"><span class="afSup">3</span> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2014, № 30, ст. 4217.</p>
				
				<!-- раздел 2.1.1 -->
				<xsl:if test="ns1:ЭДПФР/ns1:ЕФС-1/ns1:ОСС/ns1:РССВ/ns1:ОблБаза">
					<div class="afNoBreakInside">
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 2.1.1. Сведения об облагаемой базе для исчисления страховых взносов и исчисленных страховых взносах для организаций с выделенными самостоятельными классификационными единицами (СКЕ) или для организаций - государственных (муниципальных) учреждений, часть деятельности которых финансируется из бюджетов всех уровней и приравненных к ним источников (частичное финансирование), а также страхователей, исчисляющих страховые вносы по нескольким основаниям</p>
						<p class="afInterval"/>
						<div class="afRow">
							<div class="afCol-5">СКЕ </div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Тип ='1'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-22 afCenterBlock">Частичное финансирование</div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Тип ='2'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-2 afCenterBlock">Страхователь, исчисляющий страховые взносы по нескольким основаниям</div>
							<div class="afCol-10">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Тип ='3'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRight-1-4 afSubscriptNormal afCenterBlock">(руб. коп.)</div>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afTableSmallSize">
							<colgroup>
								<col class="afTable3"/><!--1-->
								<col class="afTable7"/>
								<col class="afTable4"/>
								<col class="afTable6"/>
								<col class="afTable5"/><!--5-->
								<col class="afTable4"/>
								<col class="afTable4"/>
								<col class="afTable5"/>
								<col class="afTable3"/>
								<col class="afTable5"/><!--10-->
								<col class="afTable3"/>
								<col class="afTable5"/>
								<col class="afTable3"/>
								<col class="afTable5"/>
								<col class="afTable4"/><!--15-->
								<col class="afTable5"/>
								<col class="afTable3"/>
								<col class="afTable5"/>
								<col class="afTable4"/>
								<col class="afTable4"/><!--20-->
								<col class="afTable4"/>
								<col class="afTable3"/>
								<col class="afTable3"/>
								<col class="afTable3"/>
								<!--24-->
							</colgroup>
							<thead>
								<tr class="afCenter">
									<td rowspan="4">№ п/п</td>
									<td rowspan="4">Наименование ВЭД</td>
									<td rowspan="4">Код ОКВЭД</td>
									<td rowspan="4">Наименование подразделения</td>
									<td rowspan="4">Размер страхового тарифа в соответствии с классом профессиональ-ного риска (%)</td>
									<td rowspan="4">Скидка к страховому тарифу (%)</td>
									<td rowspan="4">Надбавка к страхово-му тарифу (%)</td>
									<td rowspan="4">Размер страхового тарифа с учетом скидки (надбавки) (%) (заполняется с тремя десятичными знаками после запятой)</td>
									<td colspan="10">База для исчисления страховых взносов</td>
									<td colspan="6">Исчислено страховых взносов</td>
								</tr>
								<tr class="afCenter">
									<td rowspan="2" colspan="2">С начала расчетного периода</td>
									<td rowspan="2" colspan="2">На начало отчетного периода</td>
									<td colspan="6">в том числе за последние три месяца отчетного периода</td>
									<td rowspan="3">Всего с начала расчетного периода</td>
									<td rowspan="3">На начало отчетного периода</td>
									<td rowspan="3">Всего за последние три месяца отчетного периода</td>
									<td rowspan="2" colspan="3">в том числе за последние три месяца отчетного периода</td>
								</tr>
								<tr class="afCenter">
									<td colspan="2">1 месяц</td>
									<td colspan="2">2 месяц</td>
									<td colspan="2">3 месяц</td>
								</tr>
								<tr class="afCenter">
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>1 месяц</td>
									<td>2 месяц</td>
									<td>3 месяц</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
									<td>12</td>
									<td>13</td>
									<td>14</td>
									<td>15</td>
									<td>16</td>
									<td>17</td>
									<td>18</td>
									<td>19</td>
									<td>20</td>
									<td>21</td>
									<td>22</td>
									<td>23</td>
									<td>24</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<tr class="afHeight14">
									<td>Всего, в том числе:</td>
									<td>X</td>
									<td>X</td>
									<td>X</td>
									<td>X</td>
									<td>X</td>
									<td>X</td>
									<td>X</td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:СНачала/ЕФС:Всего"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:СНачала/ЕФС:СуммаИнв"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:НаКонец/ЕФС:Всего"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:НаКонец/ЕФС:СуммаИнв"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:ПервыйМесяц/ЕФС:Всего"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:ПервыйМесяц/ЕФС:СуммаИнв"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:ВторойМесяц/ЕФС:Всего"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:ВторойМесяц/ЕФС:СуммаИнв"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:ТретийМесяц/ЕФС:Всего"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:База/ЕФС:ТретийМесяц/ЕФС:СуммаИнв"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:Исчислено/ЕФС:ВсегоСНачала"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:Исчислено/ЕФС:НаКонец"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:Исчислено/ЕФС:ВсегоЗаТриМес"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:Исчислено/ЕФС:ПервыйМесяц"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:Исчислено/ЕФС:ВторойМесяц"/></td>
									<td><xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС:Исчислено/ЕФС:ТретийМесяц"/></td>
								</tr>
								<xsl:for-each select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:ОсновнойВЭД">
									<tr class="afHeight14">
										<td>основной ВЭД</td>
										<td><xsl:value-of select="ЕФС:НаименованиеВЭД"/></td>
										<td><xsl:value-of select="УТ2:КодПоОКВЭД"/></td>
										<td><xsl:value-of select="ЕФС:Подразделение"/></td>
										<td><xsl:value-of select="ЕФС:СтраховойТариф"/></td>
										<td><xsl:value-of select="ns1:СкидкаТариф"/></td>
										<td><xsl:value-of select="ns1:НадбавкаТариф"/></td>
										<td><xsl:value-of select="ns1:ТарифУчСкидНадб"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:СНачала/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:СНачала/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:НаКонец/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:НаКонец/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ПервыйМесяц/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ПервыйМесяц/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ВторойМесяц/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ВторойМесяц/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ТретийМесяц/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ТретийМесяц/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ВсегоСНачала"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:НаКонец"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ВсегоЗаТриМес"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ПервыйМесяц"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ВторойМесяц"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ТретийМесяц"/></td>
									</tr>
								</xsl:for-each>
								<xsl:for-each select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:СКЕ">
									<tr class="afHeight14">
										<td><xsl:value-of select="position()"/></td>
										<td><xsl:value-of select="ЕФС:НаименованиеВЭД"/></td>
										<td><xsl:value-of select="УТ2:КодПоОКВЭД"/></td>
										<td><xsl:value-of select="ЕФС:Подразделение"/></td>
										<td><xsl:value-of select="ЕФС:СтраховойТариф"/></td>
										<td>X</td>
										<td>X</td>
										<td>X</td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:СНачала/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:СНачала/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:НаКонец/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:НаКонец/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ПервыйМесяц/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ПервыйМесяц/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ВторойМесяц/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ВторойМесяц/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ТретийМесяц/ЕФС:Всего"/></td>
										<td><xsl:value-of select="ЕФС:База/ЕФС:ТретийМесяц/ЕФС:СуммаИнв"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ВсегоСНачала"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:НаКонец"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ВсегоЗаТриМес"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ПервыйМесяц"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ВторойМесяц"/></td>
										<td><xsl:value-of select="ЕФС:Исчислено/ЕФС:ТретийМесяц"/></td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</xsl:if>
				
				
				
				<!-- раздел 2.2 -->
				<xsl:if test="$OSS/ns1:ИсчСтрахВзнос">
					<div class="afNoBreakInside">
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 2.2. Сведения,  необходимые  для  исчисления  страховых  взносов  страхователями,  указанными  в пункте 2.1  статьи 22  Федерального закона от 24 июля 1998 г. № 125-ФЗ "Об обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний"<span class="afSup">4</span></p>
						<p class="afInterval"/>
						<div class="afRight-1-4 afSubscriptNormal afCenterBlock">(руб. коп.)</div>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afTableSmallSize">
							<colgroup>
								<col class="afTable3"/><!--1-->
								<col class="afTable7"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/><!--5-->
								<col class="afTable6"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/><!--10-->
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/><!--15-->
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
							</colgroup>
							<thead>
								<tr class="afCenter">
									<td rowspan="4">№ п/п</td>
									<td colspan="4">Принимающая организация</td>
									<td rowspan="4">Численность временно направленных работников</td>
									<td rowspan="4">из них: численность  инвалидов</td>
									<td colspan="8">База для исчисления страховых взносов</td>
									<td rowspan="4">Размер страхового тарифа в соответствии с классом профессионального риска (%)</td>
									<td rowspan="4">Скидка к страховому тарифу (%)</td>
									<td rowspan="4">Надбавка к страховому тарифу (%)</td>
									<td rowspan="4">Размер страхового тарифа с учетом скидки (надбавки) (%) (заполняется с тремя десятичными знаками после запятой)</td>	
								</tr>
								<tr class="afCenter">
									<td rowspan="3">Регистрацион-ный номер в территориальном органе Фонда пенсионного и социального страхования Российской Федерации</td>
									<td rowspan="3">ИНН </td>
									<td rowspan="3">КПП</td>
									<td rowspan="3">ОКВЭД</td>
									<td rowspan="3">Всего с начала расчетного периода</td>
									<td rowspan="3">в том числе инвалиды</td>
									<td colspan="6">в том числе за последние три месяца отчетного периода</td>
								</tr>
								<tr class="afCenter">
									<td colspan="2">1 месяц</td>
									<td colspan="2">2 месяц</td>
									<td colspan="2">3 месяц</td>
								</tr>
								<tr class="afCenter">
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
									<td>12</td>
									<td>13</td>
									<td>14</td>
									<td>15</td>
									<td>16</td>
									<td>17</td>
									<td>18</td>
									<td>19</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<xsl:for-each select="$OSS/ns1:ИсчСтрахВзнос/ns1:Запись">
									<tr class="afHeight14">
										<td><xsl:value-of select="position()"/></td>
										<td><xsl:value-of select="ns1:Организация/ns1:РегНомер"/></td>
										<td><xsl:value-of select="ns1:Организация/УТ2:ИНН"/></td>
										<td><xsl:value-of select="ns1:Организация/УТ2:КПП"/></td>
										<td><xsl:value-of select="ns1:Организация/УТ2:КодПоОКВЭД"/></td>
										<td><xsl:value-of select="ns1:РабОбщ"/></td>
										<td><xsl:value-of select="ns1:РабИнв"/></td>
										<td><xsl:value-of select="ns1:СНачала/ЕФС:ВыплРаб"/></td>
										<td><xsl:value-of select="ns1:СНачала/ЕФС:ВыплИнв"/></td>
										<td><xsl:value-of select="ns1:ПервыйМесяц/ЕФС:ВыплРаб"/></td>
										<td><xsl:value-of select="ns1:ПервыйМесяц/ЕФС:ВыплИнв"/></td>
										<td><xsl:value-of select="ns1:ВторойМесяц/ЕФС:ВыплРаб"/></td>
										<td><xsl:value-of select="ns1:ВторойМесяц/ЕФС:ВыплИнв"/></td>
										<td><xsl:value-of select="ns1:ТретийМесяц/ЕФС:ВыплРаб"/></td>
										<td><xsl:value-of select="ns1:ТретийМесяц/ЕФС:ВыплИнв"/></td>
										<td><xsl:value-of select="ns1:СтраховойТариф"/></td>
										<td><xsl:value-of select="ns1:СкидкаТариф"/></td>
										<td><xsl:value-of select="ns1:НадбавкаТариф"/></td>
										<td><xsl:value-of select="ns1:ТарифУчСкидНадб"/></td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</xsl:if>
				
				 <p>___________________________________________</p>
				<p class="afP afFootnote"><span class="afSup">4</span> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2014, № 19, ст. 2321.</p>
				<!-- раздел 2.3 -->
				<xsl:if test="$OSS/ns1:РПО">
					<div class="afNoBreakInside">
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 2.3. Сведения о результатах проведенных обязательных предварительных и периодических медицинских осмотров работников и проведенной специальной оценке условий труда на начало года</p>
						<p class="afP">Проведение обязательных предварительных и периодических медицинских осмотров работников:</p>
						<div class="afRow">
							<div class="afC">Общая численность работников, подлежащих обязательным предварительным и периодическим медицинским осмотрам (чел.)</div>
							<div class="afCol-10 afValue afUnderlinedBlock">
								<xsl:value-of select="$OSS/ns1:РПО/ns1:ОбщЧисл"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">Численность работников,  прошедших обязательные предварительные и периодические медицинские осмотры  (чел.)</div>
							<div class="afCol-10 afValue afUnderlinedBlock">
								<xsl:value-of select="$OSS/ns1:РПО/ns1:ПрошЧисл"/>
							</div>
						</div>
						
						<p class="afInterval"/>
						
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
							<colgroup>
								<col class="afTable14"/><!--1-->
								<col class="afTable5"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/><!--5-->
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/><!--10-->
								<col class="afTable9"/>
							</colgroup>
							<thead>
								<tr class="afCenter">
									<td rowspan="4">Наименование показателя</td>
									<td rowspan="4">Код строки</td>
									<td rowspan="4">Общее количество рабочих мест страхователя</td>
									<td colspan="8">Количество рабочих мест, в отношении  которых проведена специальная оценка условий труда </td>
									
								</tr>
								<tr class="afCenter">
									<td rowspan="3">всего</td>
									<td colspan="7">в том числе отнесенных к классам (подклассам) условий труда</td>
								</tr>
								<tr class="afCenter">
									<td rowspan="2">1 класс</td>
									<td rowspan="2">2 класс</td>
									<td colspan="4">3 класс</td>
									<td rowspan="2">4 класс</td>
								</tr>
								<tr class="afCenter">
									<td>3.1</td>
									<td>3.2</td>
									<td>3.3</td>
									<td>3.4</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<xsl:for-each select="$OSS/ns1:РПО/ns1:Результат">
									<tr class="afHeight14">
										<td>Проведение специальной оценки условий труда</td>
										<td><xsl:value-of select="position()"/></td>
										<td><xsl:value-of select="ns1:КоличРабМест"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Всего"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс1"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс2"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.1"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.2"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.3"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.4"/></td>
										<td><xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс4"/></td>	
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</xsl:if>
				
		
	
				
				
				
			</xsl:if>
		</div>
	</xsl:template>
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	<!-- Ученое звание -->
	<xsl:template name="AcademicTitle">
		<xsl:param name="pAcademicTitle"/>
		<xsl:choose>
			<xsl:when test="$pAcademicTitle = 'АРАН'">Академик Российской академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'АМАН'">Академик международной академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'АДРА'">Академик других академий: Российской академии образования, Российской академии художеств, Российской академии архитектуры и строительных наук, отраслевой академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧРАН'">Член-корреспондент Российской академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧМАН'">Член-корреспондент международной академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧДРА'">Член-корреспондент других академий: Российской академии образования, Российской академии художеств, Российской академии архитектуры и строительных наук, отраслевой академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ПРФ'">Профессор</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ДЦ'">Доцент</xsl:when>
			<xsl:when test="$pAcademicTitle = 'СНС'">Старший научный сотрудник</xsl:when>
			<xsl:when test="$pAcademicTitle = 'МНС'">Младший научный сотрудник</xsl:when>
			<xsl:when test="$pAcademicTitle = 'АСС'">Ассистент</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧЗАН'">Член зарубежной академии наук</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Почетное звание -->
	<xsl:template name="HonoraryTitle">
		<xsl:param name="pHonoraryTitle"/>
		<xsl:choose>
			<xsl:when test="$pHonoraryTitle = 'ЛЕТКОС'">Летчик-космонавт Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРАРТ'">Народный артист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРАРХ'">Народный архитектор Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРУЧ'">Народный учитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРХУД'">Народный художник Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗАРТ'">Заслуженный артист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗАРХ'">Заслуженный архитектор Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВЕТВР'">Заслуженный ветеринарный врач Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВЛЕТ'">Заслуженный военный летчик Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВСПЕЦ'">Заслуженный военный специалист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВШТУР'">Заслуженный военный штурман Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВРАЧ'">Заслуженный врач Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗГЕОГР'">Заслуженный географ Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗГЕОЛ'">Заслуженный геолог Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗДИСК'">Заслуженный деятель искусств Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗДНАУК'">Заслуженный деятель науки Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЖУРН'">Заслуженный журналист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЗЕМЛ'">Заслуженный землеустроитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗИЗОБР'">Заслуженный изобретатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗКОНСТР'">Заслуженный конструктор Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЛЕС'">Заслуженный лесовод Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЛЕТИСП'">Заслуженный летчик-испытатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМПРОБ'">Заслуженный мастер производственного обучения Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМАШ'">Заслуженный машиностроитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМЕТАЛ'">Заслуженный металлург Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМЕТЕО'">Заслуженный метеоролог Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗПИЛОТ'">Заслуженный пилот Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРАТПРОМ'">Заслуженный работник атомной промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРВШКОЛ'">Заслуженный работник высшей школы Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРГЕОД'">Заслуженный работник геодезии и картографии Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРДИПСЛ'">Заслуженный работник дипломатической службы Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРЖКХ'">Заслуженный работник жилищно-коммунального хозяйства Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРЗДРАВ'">Заслуженный работник здравоохранения Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРКУЛЬТ'">Заслуженный работник культуры Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРЛЕСПРОМ'">Заслуженный работник лесной промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРНГПРОМ'">Заслуженный работник нефтяной и газовой промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРПИЩПРОМ'">Заслуженный работник пищевой индустрии Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРПОЖОХР'">Заслуженный работник пожарной охраны Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРПРОК'">Заслуженный работник прокуратуры Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРРКПРОМ'">Заслуженный работник ракетно-космической промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРРЫБХОЗ'">Заслуженный работник рыбного хозяйства Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРСВЯЗИ'">Заслуженный работник связи и информации Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРСЕЛЬХОЗ'">Заслуженный работник сельского хозяйства Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРСОЦЗАЩ'">Заслуженный работник социальной защиты населения Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРТЛПРОМ'">Заслуженный работник текстильной и легкой промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРТРАНС'">Заслуженный работник транспорта Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРФИЗКУЛ'">Заслуженный работник физической культуры Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОБЕЗ'">Заслуженный сотрудник органов безопасности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОГОСОХР'">Заслуженный сотрудник органов государственной охраны Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОВНРАЗ'">Заслуженный сотрудник органов внешней разведки Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОВНДЕЛ'">Заслуженный сотрудник органов внутренних дел Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗССЛЕДОРГ'">Заслуженный сотрудник следственных органов Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСПАС'">Заслуженный спасатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСТРОЙ'">Заслуженный строитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСУДПРИС'">Заслуженный судебный пристав Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗТАМОЖ'">Заслуженный таможенник Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗУЧИТ'">Заслуженный учитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗХИМ'">Заслуженный химик Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗХУД'">Заслуженный художник Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗШАХТ'">Заслуженный шахтер Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗШТУРМ'">Заслуженный штурман Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗШТИСП'">Заслуженный штурман-испытатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЭКОЛ'">Заслуженный эколог Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЭКОНОМ'">Заслуженный экономист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЭНЕРГ'">Заслуженный энергетик Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЮРИСТ'">Заслуженный юрист Российской Федерации</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Выработка -->
	<xsl:template name="УТ2:ProductionStr">
		<xsl:param name="pProduction"/>
		<xsl:if test="$pProduction">
			<xsl:if test="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы">
				<xsl:value-of select="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы"/> ч.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты">
				<xsl:value-of select="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты"/> мин.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы">
				<xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы"/> мес.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни">
				<xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни"/> д.&#160;</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="DateComplex">
		<xsl:param name="pComplex"/>
		<xsl:choose>
			<xsl:when test="$pComplex/УТ2:ДатаРождения">
				<xsl:call-template name="Date2Text">
					<xsl:with-param name="pDate" select="$pComplex/УТ2:ДатаРождения"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая">
				<xsl:choose>
					<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:День">
					"<xsl:value-of select="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:День"/>"&#160;&#160;</xsl:when>
					<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц">
						<xsl:choose>
							<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:День">
								<xsl:choose>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '01' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '1'">января</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '02' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '2'">февраля</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '03' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '3'">марта</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '04' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '4'">апреля</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '05' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '5'">мая</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '06' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '6'">июня</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '07' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '7'">июля</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '08' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '8'">августа</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '09' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '9'">сентября</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '10'">октября</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '11'">ноября</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '12'">декабря</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '01' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '1'">январь</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '02' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '2'">февраль</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '03' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '3'">март</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '04' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '4'">апрель</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '05' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '5'">май</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '06' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '6'">июнь</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '07' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '7'">июль</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '08' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '8'">август</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '09' or $pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '9'">сентябрь</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '10'">октябрь</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '11'">ноябрь</xsl:when>
									<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '12'">декабрь</xsl:when>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Год">
					&#160;&#160;<xsl:value-of select="$pComplex/УТ2:ДатаРожденияОсобая/УТ2:Год"/>
					</xsl:when>
					<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<!-- страхователь -->
	<xsl:template name="Policyholder">
		<xsl:param name="Policyholder1"/>
		<xsl:param name="pTel"/>
		<div class="afRow">
			<div class="afC">Регистрационный номер </div>
			<div class="afCol-2-3 afValue afUnderlinedBlock">
				<xsl:value-of select="$Policyholder1/ЕФС:РегНомер"/>
			</div>
		</div>
		<div class="afRow">
			<div class="afValue afUnderlinedBlock">
				<xsl:value-of select="$Policyholder1/ЕФС:Наименование"/>
			</div>
			<p class="afSubscriptSmall afCenter">(полное или сокращенное (при наличии) наименование организации, обособленного подразделения/фамилия, имя, отчество (при наличии) индивидуального предпринимателя, физического лица)</p>
		</div>
		<div class="afRow">
			<div class="afCol-1-5 afCenterBlock">ИНН</div>
			<div class="afCol-3-10">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 1, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 2, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 3, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 4, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 5, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 6, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 7, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 8, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 9, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 10, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 11, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:ИНН, 12, 1)"/></td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">КПП</div>
			<div class="afCol-3-10">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 1, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 2, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 3, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 4, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 5, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 6, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 7, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 8, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:КПП, 9, 1)"/></td>
					</tr>
				</table>
			</div>
		</div>
		<p class="afInterval"/>
		<div class="afRow">
			<div class="afCol-10 afCenterBlock">ОКФС</div>
			<div class="afCol-10">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС:ОКФС, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС:ОКФС, 2, 1)"/>
						</td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">ОКОГУ</div>
			<div class="afCol-1-5">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 1, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 2, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 3, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 4, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 5, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 6, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКОГУ, 7, 1)"/></td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">ОКПО</div>
			<div class="afCol-1-5">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 1, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 2, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 3, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 4, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 5, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 6, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 7, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:ОКПО, 8, 1)"/></td>
					</tr>
				</table>
			</div>
		</div>
		<p class="afInterval"/>
		<div class="afRow">
			<div class="afCol-1-5 afCenterBlock">Код по ОКВЭД</div>
			<div class="afCol-1-4">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ2:КодПоОКВЭД, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ2:КодПоОКВЭД, 2, 1)"/>
						</td>
						<td>.</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ2:КодПоОКВЭД, 4, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ2:КодПоОКВЭД, 5, 1)"/>
						</td>
						<td>.</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ2:КодПоОКВЭД, 7, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ2:КодПоОКВЭД, 8, 1)"/>
						</td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">ОГРН (ОГРНИП)</div>
			<div class="afCol-3-10">
				<table class="afTableCollapse">
					<tr>
						<xsl:choose>
							<xsl:when test="string-length($Policyholder1/ЕФС:ОГРН)= 13">
								<td class="afCheckSmall">0</td>
								<td class="afCheckSmall">0</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 13, 1)"/>
								</td>
							</xsl:when>
							<xsl:when test="string-length($Policyholder1/ЕФС:ОГРН)= 15">
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 13, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 14, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС:ОГРН, 15, 1)"/>
								</td>
							</xsl:when>
						</xsl:choose>
					</tr>
				</table>
			</div>
			<p class="afInterval"/>
			<div class="afRow afMarginLeft500">
			<div class="afCol-1-3 afCenterBlock">Код категории страхователя - физического лица</div>
			<div class="afCol-1-5">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:КодКатСтрахФЛ, 1, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:КодКатСтрахФЛ, 2, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:КодКатСтрахФЛ, 3, 1)"/></td>
						<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/ЕФС:КодКатСтрахФЛ, 4, 1)"/></td>
					</tr>
				</table>
			</div>
			</div>
		</div>
		<p class="afInterval"/>
		<xsl:if test="$pTel = '1'">
			<div class="afRow">
				<div class="afCol-1-5 afCenterBlock">Номер контактного телефона</div>
				<div class="afCol-1-4">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 1, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 2, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 3, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 4, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 5, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 6, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 7, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 8, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 9, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 10, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 11, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 12, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 13, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 14, 1)"/></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($Policyholder1/УТ2:Телефон, 15, 1)"/></td>
						</tr>
					</table>
				</div>
				<div class="afCol-1-2">
					<div class="afC">Адрес электронной почты </div>
					<div class="afMarginLeft170 afUnderlinedBlock">
						<xsl:value-of select="$Policyholder1/УТ2:АдресЭлПочты"/>
					</div>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Event">
		<xsl:param name="pEvent"/>
		<xsl:choose>
			<xsl:when test="$pEvent = '1'">ПРИЕМ</xsl:when>
			<xsl:when test="$pEvent = '2'">ПЕРЕВОД</xsl:when>
			<xsl:when test="$pEvent = '3'">ПЕРЕИМЕНОВАНИЕ</xsl:when>
			<xsl:when test="$pEvent = '4'">УСТАНОВЛЕНИЕ (ПРИСВОЕНИЕ)</xsl:when>
			<xsl:when test="$pEvent = '5'">УВОЛЬНЕНИЕ</xsl:when>
			<xsl:when test="$pEvent = '6'">ЗАПРЕТ ЗАНИМАТЬ ДОЛЖНОСТЬ (ВИД ДЕЯТЕЛЬНОСТИ)</xsl:when>
			<xsl:when test="$pEvent = '7'">ПРИОСТАНОВЛЕНИЕ</xsl:when>
			<xsl:when test="$pEvent = '8'">ВОЗОБНОВЛЕНИЕ</xsl:when>
			<xsl:when test="$pEvent = '9'">НАЧАЛО ДОГОВОРА ГПХ</xsl:when>
			<xsl:when test="$pEvent = '10'">ОКОНЧАНИЕ ДОГОВОРА ГПХ</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>