<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ8 ns1 ВС8 ЕФС8 sig" version="1.0" xmlns:УТ8="http://пф.рф/УТ/2025-01-01" xmlns:ЕФС8="http://пф.рф/ВС/ЕФС/2026-01-01" xmlns:ВС8="http://пф.рф/ВС/типы/2025-01-01" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ЕФС-1/2026-01-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2025-01-01.xsl"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template name="inc">
		<div class="afSmallWrap12 pfrAfEFS-1">
			<p class="afRight-1-4">
                Приложение № 1<br/>
                к приказу СФР<br/>
                от ____________________ <br/>№ ________________
            </p>
			<p class="afInterval"/>
			<p class="afP">Форма ЕФС-1</p>
			<p class="afValue afP afCenter">Единая форма «Сведения для ведения индивидуального (персонифицированного) учета и сведения о начисленных страховых взносах на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний (ЕФС-1)»</p>
			<p class="afInterval"/>
			<p class="afValue afP">Сведения о страхователе</p>
			<xsl:call-template name="Policyholder">
				<xsl:with-param name="Policyholder1" select="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:Страхователь"/>
				<xsl:with-param name="pTel" select="1"/>
			</xsl:call-template>
			<xsl:if test="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:СтраховательЗаКоторого">
				<p class="afInterval"/>
				<p class="afValue afP">Сведения о страхователе, за которого предоставляются сведения</p>
				<xsl:call-template name="Policyholder">
					<xsl:with-param name="Policyholder1" select="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:СтраховательЗаКоторого"/>
				</xsl:call-template>
			</xsl:if>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<table class="afTable100 afTableCollapse">
				<tbody class="afOverflowWordBreak">
					<tr>
						<td class="afTable35">
							<p class="afUnderlinedBlock afValue">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:Руководитель/УТ8:Должность"/>
							</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable20">
							<p class="afUnderlinedBlock">&#160;</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable30">
							<p class="afUnderlinedBlock afValue">
								<xsl:call-template name="УТ8:NameStr">
									<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:Руководитель/УТ8:ФИО"/>
								</xsl:call-template>
							</p>
						</td>
					</tr>
					<tr>
						<td class="afTable35">
							<p class="afSubscriptNormal afCenter">Наименование должности руководителя (уполномоченного представителя страхователя)</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable20">
							<p class="afSubscriptNormal afCenter">(подпись)</p>
						</td>
						<td class="afTable5">&#160;</td>
						<td class="afTable30">
							<p class="afSubscriptNormal afCenter">(фамилия, имя, отчество (при наличии)</p>
						</td>
					</tr>
				</tbody>
			</table>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol2-1-2">
					<div class="afCol-6-10">
						<div class="afCol-1-2">
							<p class="afP afUnderlinedBlock afValue">
								<xsl:call-template name="Date2Text">
									<xsl:with-param name="pDate" select="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:ДатаЗаполнения"/>
								</xsl:call-template> г.
							</p>
							<p class="afP afCenter">(дата)</p>
						</div>
					</div>
					<div class="afC afAlignBotom afPadding">
						<br/>М.П. (при наличии)
					</div>
				</div>
			</div>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
			<div id="break"/>
			<!-- Раздел 1-->
			<xsl:if test="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ">
				<p class="afHeaderLeft afP">Раздел 1. Сведения о трудовой (иной) деятельности, страховом стаже, заработной плате и дополнительных страховых взносах на накопительную пенсию</p>
				<p class="afInterval"/>
				<xsl:for-each select="/ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ЗЛ">
					<xsl:if test="position() &gt; 1">
						<div id="break"/>
					</xsl:if>
					<p class="afValue afP ">Подраздел 1. Сведения о трудовой (иной) деятельности, страховом стаже, заработной плате зарегистрированного лица (ЗЛ)</p>
					<div class="afRow">
						<div class="afCol-3-20">СНИЛС</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ8:СНИЛС"/>
							</div>
						</div>
						<div class="afCol-1-5 afCenterBlock">ИНН (при наличии)</div>
						<div class="afCol-1-4">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 1, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 2, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 3, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 4, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 5, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 6, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 7, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 8, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 9, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 10, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 11, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:ИНН, 12, 1)"/>
									</td>
								</tr>
							</table>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Фамилия</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ8:ФИО/УТ8:Фамилия"/>
							</div>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Имя</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ8:ФИО/УТ8:Имя"/>
							</div>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Отчество (при наличии)</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="УТ8:ФИО/УТ8:Отчество"/>
							</div>
						</div>
					</div>
					<div class="afRow">
						<div class="afCol-3-20">Дата рождения</div>
						<div class="afCol-1-4">
							<div class="afValue afUnderlinedBlock">
								<xsl:call-template name="DateComplex">
									<xsl:with-param name="pComplex" select="."/>
								</xsl:call-template>
							</div>
						</div>
						<div class="afCol-1-5 afCenterBlock">Статус ЗЛ</div>
						<div class="afCol-10">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 1, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 2, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 3, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:СтатусЗЛ, 4, 1)"/>
									</td>
								</tr>
							</table>
						</div>
						<div class="afCol-1-5 afCenterBlock">Гражданство (код страны)</div>
						<div class="afCol-10">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:Гражданство, 1, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:Гражданство, 2, 1)"/>
									</td>
									<td class="afCheckSmall">
										<xsl:value-of select="substring(ns1:Гражданство, 3, 1)"/>
									</td>
								</tr>
							</table>
						</div>
					</div>
					<!--Подраздел 1.1 -->
					<p class="afInterval"/>
					<xsl:if test="ns1:СЗВ-ТД">
						<p class="afValue afP afMarginLeft15">Подраздел 1.1. Сведения о трудовой (иной) деятельности</p>
						<div class="afRow">
							<div class="afCol-1-2">Подано заявление о продолжении ведения трудовой книжки</div>
							<div class="afCol-3-20 afCenterBlock">Дата подачи</div>
							<div class="afCol-10">
								<div class="afValue afUnderlinedBlock">
									<xsl:if test="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:Дата">
										<xsl:call-template name="Date2GOST">
											<xsl:with-param name="pDate" select="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:Дата"/>
										</xsl:call-template> г.
									</xsl:if>&#160;
								</div>
							</div>
							<div class="afCol-3-20 afCenterBlock">Признак отмены</div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:СтатусЗаявления = 'false' or ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПродолжении/ns1:СтатусЗаявления = '0'">
												<span class="afValue">V</span>
											</xsl:if>
										</td>
									</tr>
								</table>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-1-2">Подано заявление о предоставлении сведений о трудовой деятельности</div>
							<div class="afCol-3-20 afCenterBlock">Дата подачи</div>
							<div class="afCol-10">
								<div class="afValue afUnderlinedBlock">
									<xsl:if test="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:Дата">
										<xsl:call-template name="Date2GOST">
											<xsl:with-param name="pDate" select="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:Дата"/>
										</xsl:call-template> г.
									</xsl:if>
								</div>
							</div>
							<div class="afCol-3-20 afCenterBlock">Признак отмены</div>
							<div class="afCol-5">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:СтатусЗаявления = 'false' or ns1:СЗВ-ТД/ns1:Заявления/ns1:ЗаявлениеОПредоставлении/ns1:СтатусЗаявления = '0'">
												<span class="afValue">V</span>
											</xsl:if>&#160;
										</td>
									</tr>
								</table>
							</div>
						</div>
						<p class="afInterval"/>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afOverflowWordBreak afSmallSize">
							<tr class="afCenter">
								<td rowspan="2" class="afTable3">№ п/п</td>
								<td rowspan="2">Дата (число, месяц, год) приема, перевода, увольнения, начала договора ГПХ, окончания договора ГПХ</td>
								<td rowspan="2">Сведения о приеме, переводе, увольнении, начале договора ГПХ, окончании договора ГПХ</td>
								<td rowspan="2">Работа в районах Крайнего Севера/Работа в местностях, приравненных к районам Крайнего Севера</td>
								<td rowspan="2">Трудовая функция (должность, профессия, специальность, квалификация, конкретный вид поручаемой работы), структурное подразделение</td>
								<td rowspan="2" class="afTable7">Код выполняемой функции</td>
								<td rowspan="2">Причины увольнения, пункт, часть статьи, статья Трудового кодекса Российской Федерации, федерального закона</td>
								<td colspan="3">Основание</td>
								<td rowspan="2">Признак отмены записи</td>
							</tr>
							<tr class="afCenter">
								<td>Наименование документа</td>
								<td>Дата</td>
								<td>Номер документа</td>
							</tr>
							<tr class="afCenter afHeightRow">
								<td>1</td>
								<td>2</td>
								<td>3</td>
								<td>4</td>
								<td>5</td>
								<td>6</td>
								<td>7</td>
								<td>8</td>
								<td>9</td>
								<td>10</td>
								<td>11</td>
							</tr>
							<tbody class="afWordBreak afCenter">
								<xsl:if test="not(ns1:СЗВ-ТД/ns1:ТД/ns1:Мероприятие) and not(ns1:СЗВ-ТД/ns1:ТД/ns1:МероприятиеОтменяемое)">
									<tr>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>&#160;</td>
									</tr>
								</xsl:if>
								<xsl:for-each select="ns1:СЗВ-ТД/ns1:ТД/*">
									<xsl:variable name="eventS" select="local-name() = 'Мероприятие'"/>
									<xsl:variable name="eventC" select="local-name() = 'МероприятиеОтменяемое'"/>
									<tr>
										<td>
											<xsl:value-of select="position()"/>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:call-template name="Date2GOST">
														<xsl:with-param name="pDate" select="ЕФС8:Дата"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="$eventC">
													<xsl:call-template name="Date2GOST">
														<xsl:with-param name="pDate" select="ЕФС8:ДатаМероприятия"/>
													</xsl:call-template>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:call-template name="Event">
														<xsl:with-param name="pEvent" select="ЕФС8:Вид"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="$eventC">
													<xsl:call-template name="Event">
														<xsl:with-param name="pEvent" select="ЕФС8:Вид"/>
													</xsl:call-template>
												</xsl:when>
											</xsl:choose>
											<xsl:if test="ЕФС8:Вид = '3'"><br/>
												Прежний регистрационный номер: <xsl:value-of select="ЕФС8:РегНомер1"/><br/>
												Новый регистрационный номер: <xsl:value-of select="ЕФС8:РегНомер2"/>
											</xsl:if>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:value-of select="ЕФС8:РаботаКС"/>
												</xsl:when>
												<xsl:when test="$eventC">
													<xsl:value-of select="ЕФС8:РаботаКС"/>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:if test="ЕФС8:Сведения">
														<xsl:value-of select="ЕФС8:Сведения"/>
													</xsl:if>
													<xsl:if test="ЕФС8:Должность">
														<xsl:choose>
															<xsl:when test="ЕФС8:Сведения">,&#160;<xsl:value-of select="ЕФС8:Должность"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="ЕФС8:Должность"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
													<xsl:if test="ЕФС8:ВидПР">
														<xsl:choose>
															<xsl:when test="ЕФС8:Сведения or ЕФС8:Должность">,&#160;<xsl:value-of select="ЕФС8:ВидПР"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="ЕФС8:ВидПР"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
													<xsl:if test="ЕФС8:СтруктурноеПодразделение">
														<xsl:choose>
															<xsl:when test="ЕФС8:Сведения or ЕФС8:Должность or ЕФС8:ВидПР">, <xsl:value-of select="ЕФС8:СтруктурноеПодразделение"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="ЕФС8:СтруктурноеПодразделение"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
													<xsl:if test="ЕФС8:ЯвляетсяСовместителем"><br/><xsl:value-of select="ЕФС8:ЯвляетсяСовместителем"/><br/></xsl:if>
													<xsl:if test="ЕФС8:ДатаС"> с 
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ЕФС8:ДатаС"/>
														</xsl:call-template>
													</xsl:if>
													<xsl:if test="ЕФС8:ДатаПо"> по 
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ЕФС8:ДатаПо"/>
														</xsl:call-template>
													</xsl:if>
												</xsl:when>
												<xsl:when test="$eventC">
													<xsl:if test="ЕФС8:ЯвляетсяСовместителем"><xsl:value-of select="ЕФС8:ЯвляетсяСовместителем"/></xsl:if>
												</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:if test="ЕФС8:КодВФ">
														<xsl:value-of select="ЕФС8:КодВФ[1]"/> <xsl:value-of select="ЕФС8:КодВФ[2]"/> 
													</xsl:if>
													<xsl:if test="ЕФС8:КодВФпоОКЗ">
														<xsl:choose>
															<xsl:when test="ЕФС8:КодВФ">
																<br/>
																<xsl:value-of select="ЕФС8:КодВФпоОКЗ"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="ЕФС8:КодВФпоОКЗ"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
												</xsl:when>
												<xsl:when test="$eventC">&#160;</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:КодПричиныУвольнения">
														<xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:КодПричиныУвольнения"/>
													</xsl:if>
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:НормативныйДокумент">, <xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:НормативныйДокумент"/>
													</xsl:if>
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:Статья">, ст.<xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:Статья"/>
													</xsl:if>
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:Часть">, ч.<xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:Часть"/>
													</xsl:if>
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:Пункт">, п.<xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:Пункт"/>
													</xsl:if>
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:Подпункт">, пп.<xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:Подпункт"/>
													</xsl:if>
													<xsl:if test="ЕФС8:ОснованиеУвольнения/ЕФС8:Абзац">, абз.<xsl:value-of select="ЕФС8:ОснованиеУвольнения/ЕФС8:Абзац"/>
													</xsl:if>
													<xsl:if test="ЕФС8:Причина">. <xsl:value-of select="ЕФС8:Причина"/>
													</xsl:if>
												</xsl:when>
												<xsl:when test="$eventC">&#160;</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="$eventS">
													<xsl:for-each select="ЕФС8:Основание">
														<xsl:value-of select="ЕФС8:Наименование"/>
														<xsl:choose>
															<xsl:when test="count(preceding-sibling::ЕФС8:Основание)+1 &lt; count(//ЕФС8:Основание)">
																<br/>
															</xsl:when>
															<xsl:otherwise>&#160;</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</xsl:when>
												<xsl:when test="$eventC">&#160;</xsl:when>
											</xsl:choose>
										</td>
										<td>
											<xsl:for-each select="ЕФС8:Основание">
												<xsl:call-template name="Date2GOST">
													<xsl:with-param name="pDate" select="ЕФС8:Дата"/>
												</xsl:call-template>
												<xsl:choose>
													<xsl:when test="count(preceding-sibling::ЕФС8:Основание)+1 &lt; count(//ЕФС8:Основание)">
														<br/>
													</xsl:when>
													<xsl:otherwise>&#160;</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</td>
										<td>
											<xsl:for-each select="ЕФС8:Основание">
												<xsl:if test="ЕФС8:Серия">
													<xsl:value-of select="ЕФС8:Серия"/>&#160;</xsl:if>
												<xsl:value-of select="ЕФС8:Номер"/>
												<xsl:choose>
													<xsl:when test="count(preceding-sibling::ЕФС8:Основание)+1 &lt; count(//ЕФС8:Основание)">
														<br/>
													</xsl:when>
													<xsl:otherwise>&#160;</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</td>
										<td class="afCenter">
											<xsl:choose>
												<xsl:when test="$eventS">
													<div class="afCheckSmall afMarginLeft40"/>
												</xsl:when>
												<xsl:when test="$eventC">
													<div class="afCheckSmall afValue afMarginLeft40">V</div>
												</xsl:when>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<!--Подраздел 1.2 -->
					<p class="afInterval"/>
					<xsl:if test="ns1:СЗВ-СТАЖ">
						<div id="break"/>
						<p class="afValue afP afMarginLeft15">Подраздел 1.2. Сведения о страховом стаже</p>
						<xsl:for-each select="ns1:СЗВ-СТАЖ">
							<div class="afRow">
								<div class="afCol-3-20 afValue">Отчетный период: </div>
								<div class="afCol-10">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод, 4, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-5">год</div>
							</div>
							<div class="afRow">
								<div class="afCol-10 afValue">Тип сведений:</div>
							</div>
							<div class="afRow">
								<div class="afCol-7 afAlignRight">Исходная &#160;</div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='1'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-9">Назначение пенсии </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='2'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-6" style="width: 15.5%;">Назначение выплат по ОСС</div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='5'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-10-1">Корректирующая </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='3'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-8">Отменяющая </div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='4'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-4 afValue">Корректируемый (отменяемый) период </div>
								<div class="afCol-7">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод, 4, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1">год</div>
							</div>
							<p class="afInterval"/>
							<table class="afWordBreak afTable afTable100 afTableLayoutFixed afOverflowWordBreak afSmallSize">
								<tr class="afCenter">
									<td rowspan="2" class="afTable3">№ п/п</td>
									<td colspan="2">Период работы</td>
									<td colspan="2">Территориальные условия</td>
									<td colspan="2">Особенности исчисления страхового стажа</td>
									<td colspan="3">Условия досрочного назначения страховой пенсии</td>
									<td colspan="2">Результат специальной оценки условий труда</td>
								</tr>
								<tr class="afCenter">
									<td>с дд.мм.гггг</td>
									<td>по дд.мм.гггг</td>
									<td>Код</td>
									<td>Районный коэффициент</td>
									<td>Основание (код)</td>
									<td class="afNoWordBreak">Дополнительные<br/>сведения</td>
									<td>Особые условия труда (код)</td>
									<td>Основание (код)</td>
									<td>Занятость</td>
									<td class="afNoWordBreak">Индивидуальный<br/>номер рабочего<br/> места</td>
									<td>Класс (подкласс) условий труда</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
									<td>12</td>
								</tr>
								<xsl:for-each select="ns1:СтажевыйПериод">
									<xsl:variable name="vCount" select="count(./ns1:ЛьготныйСтаж)"/>
									<tr class="afCenter">
										<td rowspan="{$vCount+1}">
											<xsl:value-of select="position()"/>
										</td>
										<td rowspan="{$vCount+1}">
											<xsl:call-template name="Date2GOST">
												<xsl:with-param name="pDate" select="./ns1:Период/УТ8:С"/>
											</xsl:call-template>
										</td>
										<td rowspan="{$vCount+1}">
											<xsl:call-template name="Date2GOST">
												<xsl:with-param name="pDate" select="./ns1:Период/УТ8:По"/>
											</xsl:call-template>
										</td>
									</tr>
									<xsl:for-each select="./ns1:ЛьготныйСтаж">
										<tr class="afCenter">
											<td>
												<xsl:value-of select="./ЕФС8:ТУ/ЕФС8:Основание"/>&#160;<xsl:value-of select="./ЕФС8:ТУ/ЕФС8:ДоляСтавки"/>
											</td>
											<td>
												<xsl:value-of select="./ЕФС8:ТУ/ЕФС8:Коэффициент"/>
											</td>
											<td>
												<xsl:value-of select="./ЕФС8:ИС/ЕФС8:Основание"/>
											</td>
											<td>
												<xsl:call-template name="УТ8:ProductionStr">
													<xsl:with-param name="pProduction" select="./ЕФС8:ИС"/>
												</xsl:call-template>
												<xsl:if test="./ЕФС8:ДопСведенияИС">
													<br/>
													<xsl:value-of select="./ЕФС8:ДопСведенияИС"/>
												</xsl:if>
											</td>
											<td>
												<xsl:if test="./ЕФС8:ОУТ/ЕФС8:Код">
													<xsl:value-of select="./ЕФС8:ОУТ/ЕФС8:Код"/>
												</xsl:if>
												<xsl:if test="./ЕФС8:ОУТ/ЕФС8:ПозицияСписка">, <xsl:value-of select="./ЕФС8:ОУТ/ЕФС8:ПозицияСписка"/>
												</xsl:if>
											</td>
											<td>
												<xsl:value-of select="./ЕФС8:ВЛ/ЕФС8:Основание"/>
											</td>
											<td>
												<xsl:call-template name="УТ8:ProductionStr">
													<xsl:with-param name="pProduction" select="./ЕФС8:ВЛ"/>
												</xsl:call-template>
												<xsl:if test="./ЕФС8:ВЛ/ЕФС8:ДоляСтавки">&#160;<xsl:value-of select="./ЕФС8:ВЛ/ЕФС8:ДоляСтавки"/>
												</xsl:if>
											</td>
											<td>
												<xsl:value-of select="./ЕФС8:СОУТ/ЕФС8:Номер"/>
											</td>
											<td>
												<xsl:value-of select="./ЕФС8:СОУТ/ЕФС8:Код"/>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:for-each>
							</table>
							<p class="afInterval"/>
						</xsl:for-each>
					</xsl:if>
					<!--Подраздел 1.3 -->
					<xsl:if test="ns1:СЗПГос">
						<p class="afInterval"/>
						<div id="break"/>
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 1.3.  Сведения о заработной плате и условиях осуществления деятельности работников государственных (муниципальных) учреждений</p>
						<xsl:for-each select="ns1:СЗПГос">
							<p class="afInterval"/>
							<div class="afRow">
								<div class="afCol-1-9 afValue">Отчетный период: </div>
								<xsl:variable name="vMonth" select="ns1:ОтчетныйПериод/ns1:Месяц"/>

								<div class="afCol-5">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:choose>
													<xsl:when test="$vMonth[text() ='1' or text() = '2' or text() = '3' or text() = '4' or text() = '5' or text() = '6' or text() = '7' or text() = '8' or text() = '9']">
														<xsl:value-of select="substring('0', 1, 1)"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="substring($vMonth, 1, 1)"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="afCheckSmall">
												<xsl:choose>
													<xsl:when test="$vMonth[text() ='1' or text() = '2' or text() = '3' or text() = '4' or text() = '5' or text() = '6' or text() = '7' or text() = '8' or text() = '9']">
														<xsl:value-of select="substring($vMonth, 1, 1)"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="substring($vMonth, 2, 1)"/>
													</xsl:otherwise>
												</xsl:choose>
									
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-7 afCenterBlock">месяц</div>
								<div class="afCol-7">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:ОтчетныйПериод/ns1:Год, 4, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-4 afCenterBlock">год</div>
							</div>
							<p class="afSubscript">(01 – январь, 02 – февраль, 03 – март, 04 – апрель, 05 – май, 06 – июнь, 07 – июль, 08 – август, 09 – сентябрь, 10 – октябрь, 11 – ноябрь, 12 – декабрь)</p>
							<p class="afInterval"/>
							<div class="afRow">
								<div class="afCol-10 afValue">Тип сведений:</div>
								<div class="afCol-7 afAlignRight">Исходная &#160;</div>
								<div class="afCol-2">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='1'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-9">Корректирующая</div>
								<div class="afCol-3">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='2'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-9">Отменяющая </div>
								<div class="afCol-3">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:if test="ns1:Тип ='3'">V</xsl:if>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-4 afValue">Корректируемый (отменяемый) период </div>
								<div class="afCol-5">
									<xsl:variable name="vMonth" select="ns1:КоррОтмПериод/ns1:Месяц"/>
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:choose>
													<xsl:when test="$vMonth[text() ='1' or text() = '2' or text() = '3' or text() = '4' or text() = '5' or text() = '6' or text() = '7' or text() = '8' or text() = '9']">
														<xsl:value-of select="substring('0', 1, 1)"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="substring($vMonth, 1, 1)"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="afCheckSmall">
												<xsl:choose>
													<xsl:when test="$vMonth[text() ='1' or text() = '2' or text() = '3' or text() = '4' or text() = '5' or text() = '6' or text() = '7' or text() = '8' or text() = '9']">
														<xsl:value-of select="substring($vMonth, 1, 1)"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="substring($vMonth, 2, 1)"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-7 afCenterBlock">месяц</div>
								<div class="afCol-7">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:КоррОтмПериод/ns1:Год, 4, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-4 afCenterBlock">год</div>
							</div>
							<p class="afInterval"/>
							<div class="afRow">
								<div class="afCol-1-9">КТО организации</div>
								<div class="afCol-10">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ЕФС8:КодКТО, 1, 1)"/>
											</td>
											<td>.</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ЕФС8:КодКТО, 3, 1)"/>
											</td>
											<xsl:if test="substring(ns1:Организация/ЕФС8:КодКТО, 1, 1) = '1'">
												<td class="afCheckSmall">
													<xsl:value-of select="substring(ns1:Организация/ЕФС8:КодКТО, 4, 1)"/>
												</td>
											</xsl:if>
											<td>.</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ЕФС8:КодКТО, 5, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ЕФС8:КодКТО, 6, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-4">Идентификационный номер ТОСП (если ТОСП):</div>
								<div class="afCol-1-4">
									<table class="afTableCollapse">
										<tr>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 1, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 2, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 3, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 4, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 5, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 6, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 7, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 8, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 9, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 10, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 11, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 12, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 13, 1)"/>
											</td>
											<td class="afCheckSmall">
												<xsl:value-of select="substring(ns1:Организация/ns1:ТОСП, 14, 1)"/>
											</td>
										</tr>
									</table>
								</div>
								<div class="afCol-1-10-1">OID организации</div>
								<div class="afCol-1-6">
									<div class="afValue afUnderlinedBlock afWordBreak">
										<xsl:value-of select="ns1:Организация/ns1:OID"/>
									</div>
								</div>
							</div>
							
							<div class="afRow">
								<div class="afC afValue">Сведения об условиях заянятости и заработной плате:</div>
							</div>
							<p class="afInterval"/>
							<table class="afTable afTable100 afTableLayoutFixed afTableSmallSize">
								<colgroup>
									<col class="afTable2"/>
									<col class="afTable4"/>
									<col class="afTable4"/>
									<col class="afTable7"/>
									<col class="afTable4"/>
									<col class="afTable4"/>
									<col class="afTable5"/>
									<col class="afTable3"/>
									<col class="afTable4"/>
									<col class="afTable3"/>
									<col class="afTable3"/>
									<col class="afTable4"/>
									<col class="afTable4"/>
									<col class="afTable5"/>
									<col class="afTable4"/>
									<col class="afTable5"/>
									<col class="afTable4"/>
									<col class="afTable4"/>
									<col class="afTable6"/>
									<col class="afTable4"/>
									<col class="afTable4"/>
									<col class="afTable4"/>
									<col class="afTable3"/>
									<col class="afTable3"/>
									<col class="afTable3"/>
									<col class="afTable3"/>
								</colgroup>
								<thead>
									<tr class="afCenter afWordBreak">
										<td rowspan="2">№ п/п</td>
										<td colspan="2">Период работы в отчетном месяце</td>
										<td rowspan="2">Наименование структурного подразделения; OID</td>
										<td rowspan="2">Работники, не включаемые в расчет средне-списочной численности</td>
										<td rowspan="2">Код наименования должности (профессии)</td>
										<td rowspan="2">Код категории персонала</td>
										<td rowspan="2">Звание (степень)</td>
										<td colspan="2">Специальные (отраслевые) условия занятости</td>
										<td colspan="2">Информация о договоре</td>
										<td rowspan="2">Профессиональная квалификационная группа</td>
										<td rowspan="2">Квалификационный уровень</td>
										<td rowspan="2">Класс (подкласс) условий труда по степени вредности и (или) опасности</td>
										<td rowspan="2">Квалификационная категория, присвоенная по итогам аттестации </td>
										<td rowspan="2">Число занятых штатных единиц по должности (профессии)</td>
										<td rowspan="2">Система оплаты труда</td>
										<td rowspan="2">
											Размер фиксированной части в соответствии с трудовым договором<br/>(оклад, сдельная расценка за единицу выработки, <br/>часовая тарифная ставка, размер разовой концертной ставки)
										</td>
										<td colspan="2">Количество рабочих часов (выступлений, постановок) в отчетном месяце</td>
										<td colspan="2">Количество специальных часов работы</td>
										<td colspan="3">Сведения о заработной плате</td>
									</tr>
									<tr class="afCenter">
										<td class="afWordBreak">Дата начала</td>
										<td class="afWordBreak">Дата окончания</td>
										<td>Код</td>
										<td class="afWordBreak">Значение</td>
										<td>Вид</td>
										<td>Срок</td>
										<td>Норма</td>
										<td>Факт</td>
										<td>
											<p class="vertical afNoWordBreak">Код специальных<br/>часов работы</p>
										</td>
										<td>
											<p class="vertical">Количество часов</p>
										</td>
										<td>
											<p class="vertical">Код выплаты</p>
										</td>
										<td>
											<p class="vertical">Сумма (руб.)</p>
										</td>
										<td>
											<p class="vertical">Итого</p>
										</td>
									</tr>
									<tr class="afCenter afSmallSize afHeightRow">
										<td>1</td>
										<td>2</td>
										<td>3</td>
										<td>4</td>
										<td>5</td>
										<td>6</td>
										<td>7</td>
										<td>8</td>
										<td>9</td>
										<td>10</td>
										<td>11</td>
										<td>12</td>
										<td>13</td>
										<td>14</td>
										<td>15</td>
										<td>16</td>
										<td>17</td>
										<td>18</td>
										<td>19</td>
										<td>20</td>
										<td>21</td>
										<td>22</td>
										<td>23</td>
										<td>24</td>
										<td>25</td>
										<td>26</td>
									</tr>
								</thead>
								<tbody class="afCenter afWordBreak">
									<xsl:choose>
										<xsl:when test="ns1:УЗиЗП">
											<xsl:for-each select="ns1:УЗиЗП">
												<tr>
													<td>
														<xsl:value-of select="position()"/>
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:Период/УТ8:С"/>
														</xsl:call-template>
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:Период/УТ8:По"/>
														</xsl:call-template>
													</td>
													<td>
														<xsl:value-of select="ns1:СтруктурноеПодразделение/ns1:Наименование"/>
														<xsl:if test="ns1:СтруктурноеПодразделение/ns1:OID">
															,<br/>
															<xsl:value-of select="ns1:СтруктурноеПодразделение/ns1:OID"/>
														</xsl:if>
													</td>
													<td>
														<xsl:choose>
															<xsl:when test="ns1:РабНеВклРасчЧисл[text() = 'true' or text() = '1']">да</xsl:when>
															<xsl:otherwise>нет</xsl:otherwise>
														</xsl:choose>
													</td>
													<td>
														<xsl:value-of select="ЕФС8:КодДолжности"/>
													</td>
													<td>
														<xsl:value-of select="ЕФС8:КодККП"/>
													</td>
													<td>
														<xsl:choose>
															<xsl:when test="ns1:Звание/ns1:НетЗваний">0</xsl:when>
															<xsl:otherwise>
																<xsl:if test="ns1:Звание/ns1:УченаяСтепень">
																	<!-- 
																	<xsl:choose>
																		<xsl:when test="ns1:Звание/ns1:УченаяСтепень = 'КН'">Кандидат наук.</xsl:when>
																		<xsl:when test="ns1:Звание/ns1:УченаяСтепень = 'ДН'">Доктор наук.</xsl:when>
																	</xsl:choose>
																	-->
																	<xsl:value-of select="ns1:Звание/ns1:УченаяСтепень"/>
																</xsl:if>
																<xsl:if test="ns1:Звание/ЕФС8:КодУчЗвание">
																	<!--
																	<xsl:call-template name="AcademicTitle">
																		<xsl:with-param name="pAcademicTitle" select="ns1:Звание/ЕФС8:КодУчЗвание"/>
																	</xsl:call-template>
																		-->
																	<xsl:value-of select="ns1:Звание/ЕФС8:КодУчЗвание"/>
															</xsl:if>
																<xsl:if test="ns1:Звание/ЕФС8:ПчЗвание">
																	<!-- 
																	<xsl:call-template name="HonoraryTitle">
																		<xsl:with-param name="pHonoraryTitle" select="ns1:Звание/ЕФС8:ПчЗвание"/>
																	</xsl:call-template>
																	-->
																	<xsl:value-of select="ns1:Звание/ЕФС8:ПчЗвание"/>
																</xsl:if>
															</xsl:otherwise>
														</xsl:choose>
													</td>
													<td>
														<xsl:value-of select="ns1:СоУЗ/ns1:Код"/>
													</td>
													<td>
														<xsl:value-of select="ns1:СоУЗ/ns1:Значение"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Договор/ns1:Вид"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Договор/ns1:Срок"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ЕФС8:КодКУ"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:Уровень"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:Вредность"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:Аттестация"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:ШтатЕд"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:СистемаОплаты"/>
													</td>
													<td>
														<xsl:for-each select="ns1:Квалификация/ns1:РазмерФЧ">
															<xsl:value-of select="."/>
															<xsl:if test="position() &gt; 1">
																<br/>
															</xsl:if>
														</xsl:for-each>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:РабВремяНорма"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:РабВремяФакт"/>
													</td>
													<td class="afVerticalTop">
														<xsl:for-each select="ns1:Квалификация/ns1:КолСпецЧасовРаб">
															<xsl:if test="position() > 1"><br/></xsl:if>
															<xsl:value-of select="ns1:КодСпецЧ"/>
														</xsl:for-each>
													</td>
													<td class="afVerticalTop afNoWordBreak">
														<xsl:for-each select="ns1:Квалификация/ns1:КолСпецЧасовРаб">
															<xsl:if test="position() > 1"><br/></xsl:if>
															<xsl:value-of select="ns1:КоличСпецЧ"/>
														</xsl:for-each>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:СведОЗаработПлате/ЕФС8:КодВыплаты"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:СведОЗаработПлате/ns1:Сумма"/>
													</td>
													<td>
														<xsl:value-of select="ns1:Квалификация/ns1:Итого"/>
													</td>
												</tr>
												<!-- Для отрисовки вложенных кодов выплат и СоУТ -->
												<xsl:for-each select="ns1:Квалификация/ns1:СведОЗаработПлате[position()>1]">
													<xsl:variable name="coutn" select="position()+1"/>
													<tr>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td>
															<xsl:value-of select="../../ns1:СоУЗ[$coutn]/ns1:Код"/>
														</td>
														<td>
															<xsl:value-of select="../../ns1:СоУЗ[$coutn]/ns1:Значение"/>
														</td>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td/>
														<td>0</td>
														<td>
															<xsl:value-of select="./ЕФС8:КодВыплаты"/>
														</td>
														<td>
															<xsl:value-of select="./ns1:Сумма"/>
														</td>
														<td/>
													</tr>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<tr>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
												<td/>
											</tr>
										</xsl:otherwise>
									</xsl:choose>
								</tbody>
							</table>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
				<!-- Подраздел 2 -->
				<p class="afInterval"/>
				<xsl:if test="ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДНП">
					<div class="afNoBreakInside">
						<p class="afValue afP ">Подраздел 2. Основание для отражения данных о периодах работы застрахованного лица в условиях, дающих право на досрочное назначение пенсии в соответствии с частью 1 статьи 30 и статьей 31 Федерального закона от 28.12.2013 № 400-ФЗ «О страховых пенсиях»<span class="afSup">1</span>
						</p>
						<xsl:variable name="DNP" select="ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДНП"/>
						<div class="afRow">
							<div class="afCol-1-9 afValue">Отчетный период: </div>
							<div class="afCol-7">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 1, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 2, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 3, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:ОтчетныйПериод, 4, 1)"/>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-4 afCenterBlock">год</div>
						</div>
						<div class="afRow">
							<div class="afCol-10 afValue">Тип сведений: </div>
							<div class="afCol-7 afAlignRight">Исходная &#160;</div>
							<div class="afCol-2">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$DNP/ns1:Тип ='1'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-1-9">Корректирующая </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$DNP/ns1:Тип ='2'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-9">Отменяющая </div>
							<div class="afCol-3">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:if test="$DNP/ns1:Тип ='3'">V</xsl:if>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-22 afValue">Корректируемый (отменяемый) период </div>
							<div class="afCol-7">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 1, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 2, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 3, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($DNP/ns1:КоррОтмПериод, 4, 1)"/>
										</td>
									</tr>
								</table>
							</div>
							<div class="afCol-4 afCenterBlock">год</div>
						</div>
						<p class="afInterval"/>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
							<thead>
								<tr class="afCenter">
									<td class="afTable4">№ п/п</td>
									<td>Наименование структурного подразделения по штатному расписанию</td>
									<td>Наименование профессии (должности) по штатному расписанию</td>
									<td>Количество рабочих мест по штатному расписанию</td>
									<td>Численность фактически работающих</td>
									<td>Характер фактически выполняемых работ и дополнительные условия труда</td>
									<td>Наименование первичных документов, подтверждающих занятость в особых условиях труда</td>
									<td>Код особых условий труда / код выслуги лет</td>
									<td>Код позиции списков</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<xsl:choose>
									<xsl:when test="$DNP">
										<xsl:for-each select="$DNP/ns1:ОснованиеДНП">
											<tr class="afHeight14">
												<td>
													<xsl:value-of select="position()"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС8:Подразделение"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС8:Профессия"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС8:КоличествоШтат"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС8:КоличествоФакт"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС8:Описание"/>
												</td>
												<td>
													<xsl:value-of select="ЕФС8:Документы"/>
												</td>
												<td>
													<xsl:for-each select="ЕФС8:ОУТ">
														<xsl:value-of select="ЕФС8:КодОУТ"/>
														<xsl:if test="ЕФС8:КодОУТ and ЕФС8:КодОснованиеВЛ"> 
															/
														</xsl:if>
														<xsl:value-of select="ЕФС8:КодОснованиеВЛ"/>
														<xsl:choose>
															<xsl:when test="count(preceding-sibling::ЕФС8:ОУТ)+1 &lt; count(//ЕФС8:ОУТ)">
																<br/>
															</xsl:when>
															<xsl:otherwise>&#160;</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</td>
												<td>
													<xsl:for-each select="ЕФС8:ОУТ">
														<xsl:choose>
															<xsl:when test="ЕФС8:ПозицияСписка">
																<xsl:value-of select="ЕФС8:ПозицияСписка"/>
																<xsl:choose>
																	<xsl:when test="count(preceding-sibling::ЕФС8:ОУТ)+1 &lt; count(//ЕФС8:ОУТ)">
																		<br/>
																	</xsl:when>
																	<xsl:otherwise>&#160;</xsl:otherwise>
																</xsl:choose>
															</xsl:when>
															<xsl:otherwise><br/></xsl:otherwise>
														</xsl:choose>
														<!--
														<xsl:if test="ЕФС8:ПозицияСписка">
															<xsl:value-of select="ЕФС8:ПозицияСписка"/>
															<xsl:choose>
																<xsl:when test="count(preceding-sibling::ЕФС8:ОУТ)+1 &lt; count(//ЕФС8:ОУТ)">
																	<br/>
																</xsl:when>
																<xsl:otherwise>&#160;</xsl:otherwise>
															</xsl:choose>
														</xsl:if>
														-->
													</xsl:for-each>
												</td>
											</tr>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<tr class="afHeight14">
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
											<td/>
										</tr>
									</xsl:otherwise>
								</xsl:choose>
							</tbody>
						</table>
						<div class="afRow">
							<div class="afCol-4-10">
							Общее количество рабочих мест в особых условиях труда по штату
						</div>
							<div class="afCol-10 afUnderline afValue afCenterBlock">
							&#160;<xsl:value-of select="$DNP/ЕФС8:ВсегоШтат"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-4-10">
							Численность фактически работающих в особых условиях труда
						</div>
							<div class="afCol-10 afUnderline afValue afCenterBlock">
							&#160;<xsl:value-of select="$DNP/ЕФС8:ВсегоФакт"/>
							</div>
						</div>
					</div>
				</xsl:if>
				<p class="afInterval"/>
				<!--Подраздел 3-->
				<xsl:if test="ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДСВ">
					<div class="afNoBreakInside">
						<p class="afValue afP ">Подраздел 3. Сведения о застрахованных лицах, за которых перечислены дополнительные страховые взносы на накопительную пенсию и уплачены взносы работодателя</p>
						<xsl:for-each select="ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДСВ">
							<div class="afRow">
								<div class="afCol-1-6">Платежное поручение № </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:value-of select="ns1:ПлатежноеПоручение/ns1:Реквизиты/ns1:Номер"/>
								</div>
								<div class="afCol-4 afCenterBlock">от</div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="ns1:ПлатежноеПоручение/ns1:Реквизиты/ns1:Дата"/>
									</xsl:call-template>
								</div>
							</div>
							<div class="afRow">
								<div class="afCol-1-4">Дата исполнения платежного поручения </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="ns1:ПлатежноеПоручение/ns1:ДатаИсполнения"/>
									</xsl:call-template>
								</div>
							</div>
							<div class="afRow">
								<div class="afCol-10">Период уплаты </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:value-of select="ns1:Период"/>
								</div>
							</div>
							<p class="afInterval"/>
							<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
								<thead>
									<tr class="afCenter">
										<td class="afTable4">№ п/п</td>
										<td>Фамилия, имя отчество (при наличии) застрахованного лица</td>
										<td>СНИЛС</td>
										<td>Сумма перечисленных дополнительных страховых взносов на накопительную пенсию (руб.)</td>
										<td>Сумма уплаченных взносов работодателя (в случае уплаты) (руб.)</td>
									</tr>
									<tr class="afCenter afHeightRow">
										<td>1</td>
										<td>2</td>
										<td>3</td>
										<td>4</td>
										<td>5</td>
									</tr>
								</thead>
								<tbody class="afCenter">
									<xsl:for-each select="ns1:РеестрДСВ/ns1:ЗЛ">
										<tr class="afHeight14">
											<td>
												<xsl:value-of select="position()"/>
											</td>
											<td>
												<xsl:call-template name="УТ8:NameStr">
													<xsl:with-param name="pName" select="УТ8:ФИО"/>
												</xsl:call-template>
											</td>
											<td>
												<xsl:value-of select="УТ8:СНИЛС"/>
											</td>
											<td>
												<xsl:value-of select="ns1:СуммаДСВРаботника"/>
											</td>
											<td>
												<xsl:value-of select="ns1:СуммаВзносовРаботодателя"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr class="afHeight14">
										<td>ВСЕГО</td>
										<td>&#160;</td>
										<td>&#160;</td>
										<td>
											<xsl:value-of select="ns1:СуммаВсегоДСВРаботника"/>
										</td>
										<td>
											<xsl:value-of select="ns1:СуммаВсегоВзносовРаботодателя"/>
										</td>
									</tr>
								</tbody>
							</table>
							<p class="afInterval"/>
							<div class="afRow">
								<div class="afCol-3-10">Общая сумма перечисленных средств составляет </div>
								<div class="afCol-10 afUnderlinedBlock">
									<xsl:value-of select="ns1:ПлатежноеПоручение/ns1:СуммаИтогоПП"/>
								</div>
								<div class="afCol-10"> рублей </div>
							</div>
						</xsl:for-each>
					</div>
				</xsl:if>
			</xsl:if>
			<xsl:if test="ns1:ЭДСФР/ns1:ЕФС-1/ns1:СЗВ/ns1:ДНП">
				<p>___________________________________________</p>
				<p class="afP afFootnote">
					<span class="afSup">1</span> Собрание законодательства Российской Федерации, 2013, № 52, ст. 6965; 2021, № 18, ст. 3061.</p>
				<xsl:if test="ns1:ЭДСФР/ns1:ЕФС-1/ns1:ОСС">
					<div id="break"/>
				</xsl:if>
			</xsl:if>
			<!-- Раздел 2-->
			<xsl:if test="ns1:ЭДСФР/ns1:ЕФС-1/ns1:ОСС">
				<xsl:variable name="OSS" select="ns1:ЭДСФР/ns1:ЕФС-1/ns1:ОСС"/>
				<p class="afHeaderLeft afP">Раздел 2. Сведения о начисленных страховых взносах на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний</p>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-3-20">Номер корректировки</div>
					<div class="afCol-3-20">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:НомерКорректировки, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:НомерКорректировки, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:НомерКорректировки, 3, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-22 afCenterBlock">Расчетный (отчетный) период (код)</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Код, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Код, 2, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-3-20 afCenterBlock">Календарный год</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Период/ns1:Год, 4, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow afSubscript">
					<div class="afCol-1-3">(000 - исходная, 001 - номер корректировки)</div>
					<div class="afCol-1-3 ">(03 - 1 квартал; 06 - полугодие; 09 - 9 месяцев; 12 - год)</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10" style="width: 66%;">&#160;</div>
					<div class="afCol-1-5 afCenterBlock">Прекращение деятельности</div>
					<div class="afCol-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:if test="$OSS/ns1:ОтметкаОПрекращении = 'true' or $OSS/ns1:ОтметкаОПрекращении ='1'">V</xsl:if>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Среднесписочная численность работников</div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:Среднесписочная, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-6">Льгота</div>
					<div class="afCol-2">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:if test="$OSS/ns1:РССВ/ns1:Льгота[text()] = '1' or $OSS/ns1:РССВ/ns1:Льгота[text()] = 'true'">V</xsl:if>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Численность работающих застрахованных лиц по  обязательному социальному страхованию от несчастных случаев на производстве и профессиональных заболеваний</div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабПоОбСоцСтрах, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Численность работающих инвалидов</div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабИнв, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-6-10">Численность работников, занятых на работах с вредными и (или) опасными производственными факторами </div>
					<div class="afCol-1-5">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OSS/ns1:Численность/ns1:РабОпас, 6, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<p class="afInterval"/>
				<p class="afValue afP afMarginLeft15">Подраздел 2.1. Расчет сумм страховых взносов</p>
				<p class="afInterval"/>
				<div class="afRight-1-3 afSubscriptNormal afCenterBlock">(руб. коп.)</div>
				<p class="afInterval"/>
				<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
					<thead>
						<tr class="afCenter">
							<td rowspan="2" class="afTable40">Наименование показателя</td>
							<td rowspan="2">Код строки</td>
							<td rowspan="2">Всего с начала расчетного периода</td>
							<td rowspan="2">На конец предыдущего отчетного периода</td>
							<td colspan="3">В том числе за последние три месяца отчетного периода</td>
						</tr>
						<tr class="afCenter">
							<td>1 месяц</td>
							<td>2 месяц</td>
							<td>3 месяц</td>
						</tr>
						<tr class="afCenter afHeightRow">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
							<td>6</td>
							<td>7</td>
						</tr>
					</thead>
					<tbody class="afCenter">
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Сумма выплат и иных вознаграждений, начисленных в пользу физических лиц в соответствии со статьей 20<sup>1</sup> Федерального закона от 24 июля 1998 г. № 125-ФЗ  "Об обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний"<span class="afSup">2</span>
							</td>
							<td>1</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС8:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС8:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС8:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС8:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаВыплИн/ЕФС8:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Сумма, не подлежащая обложению страховыми взносами в соответствии со статьей 20<sup>2</sup> Федерального закона от 24 июля 1998 г. № 125-ФЗ "Об обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний"<span class="afSup">3</span>
							</td>
							<td>2</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС8:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС8:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС8:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС8:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаНеПодлОбл/ЕФС8:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							База для исчисления страховых взносов &#160;(стр. 1 - стр. 2 )
						</td>
							<td>3</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС8:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС8:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС8:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС8:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:БазаИсч/ЕФС8:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							из них: сумма выплат в пользу работающих инвалидов
						</td>
							<td>4</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС8:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС8:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС8:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС8:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СуммаИнв/ЕФС8:ТретийМесяц"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Размер страхового тарифа в соответствии с классом профессионального риска (%)
						</td>
							<td>5</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СтраховойТариф"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Скидка к страховому тарифу (%)
						</td>
							<td>6</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:СкидкаТариф"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Надбавка к страховому тарифу (%)
						</td>
							<td>7</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:НадбавкаТариф"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">
							Размер страхового тарифа с учетом скидки (надбавки) (%) (заполняется с тремя десятичными знаками после запятой)
						</td>
							<td>8</td>
							<td colspan="5">
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ТарифУчСкидНадб"/>
							</td>
						</tr>
						<tr class="afHeight14">
							<td class="afAlignLeft">Исчислено страховых взносов</td>
							<td>9</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС8:ВсегоСНачала"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС8:НаКонец"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС8:ПервыйМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС8:ВторойМесяц"/>
							</td>
							<td>
								<xsl:value-of select="$OSS/ns1:РССВ/ns1:ИсчислСтрахВзн/ЕФС8:ТретийМесяц"/>
							</td>
						</tr>
					</tbody>
				</table>
				<p>___________________________________________</p>
				<p class="afP afFootnote">
					<span class="afSup">2</span> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2016, № 1, ст. 14.</p>
				<p class="afP afFootnote">
					<span class="afSup">3</span> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2014, № 30, ст. 4217.</p>
				<!-- раздел 2.1.1 -->
				<xsl:if test="ns1:ЭДСФР/ns1:ЕФС-1/ns1:ОСС/ns1:РССВ/ns1:ОблБаза">
					<p class="afPageBreakAfter"/>
					<p class="afInterval"/>
					<div class="afRow">
						<div class="afValue afP afMarginLeft15">Подраздел 2.1.1. Сведения об облагаемой базе для исчисления страховых взносов и исчисленных страховых взносах для организаций с выделенными самостоятельными классификационными единицами (СКЕ) или для организаций - государственных (муниципальных) учреждений, часть деятельности которых финансируется из бюджетов всех уровней и приравненных к ним источников (частичное финансирование), а также страхователей, исчисляющих страховые вносы по нескольким основаниям</div>
					</div>
					<p class="afInterval"/>
					<div class="afRow">
						<div class="afCol-5">СКЕ</div>
						<div class="afCol-5">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:if test="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Тип ='1'">V</xsl:if>
									</td>
								</tr>
							</table>
						</div>
						<div class="afCol-1-5 afCenterBlock">Частичное финансирование</div>
						<div class="afCol-5">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:if test="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Тип ='2'">V</xsl:if>
									</td>
								</tr>
							</table>
						</div>
						<div class="afCol2-1-2 afCenterBlock">Страхователь, исчисляющий страховые взносы по нескольким основаниям</div>
						<div class="afCol-5">
							<table class="afTableCollapse">
								<tr>
									<td class="afCheckSmall">
										<xsl:if test="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Тип ='3'">V</xsl:if>
									</td>
								</tr>
							</table>
						</div>
						
					</div>
					<div class="afRight-1-5 afSubscriptNormal afAlignRight">(руб. коп.)</div>
					<p class="afInterval"/>
					<table class="afWordBreak afTable afTable100 afTableLayoutFixed afTableSmallSize">
						<colgroup>
							<col class="afTable3"/>
							<!--1-->
							<col class="afTable7"/>
							<col class="afTable4"/>
							<col class="afTable6"/>
							<col class="afTable5"/>
							<!--5-->
							<col class="afTable4"/>
							<col class="afTable4"/>
							<col class="afTable5"/>
							<col class="afTable3"/>
							<col class="afTable5"/>
							<!--10-->
							<col class="afTable3"/>
							<col class="afTable5"/>
							<col class="afTable3"/>
							<col class="afTable5"/>
							<col class="afTable4"/>
							<!--15-->
							<col class="afTable5"/>
							<col class="afTable3"/>
							<col class="afTable5"/>
							<col class="afTable4"/>
							<col class="afTable4"/>
							<!--20-->
							<col class="afTable4"/>
							<col class="afTable3"/>
							<col class="afTable3"/>
							<col class="afTable3"/>
							<!--24-->
						</colgroup>
						<thead>
							<tr class="afCenter">
								<td rowspan="4">№ п/п</td>
								<td rowspan="4">Наименование ВЭД</td>
								<td rowspan="4">Код ОКВЭД</td>
								<td rowspan="4">Наименование подразделения</td>
								<td rowspan="4">Размер страхового тарифа в соответствии с классом профессиональ-ного риска (%)</td>
								<td rowspan="4">Скидка к страховому тарифу (%)</td>
								<td rowspan="4">Надбавка к страхово-му тарифу (%)</td>
								<td rowspan="4">Размер страхового тарифа с учетом скидки (надбавки) (%) (заполняется с тремя десятичными знаками после запятой)</td>
								<td colspan="10">База для исчисления страховых взносов</td>
								<td colspan="6">Исчислено страховых взносов</td>
							</tr>
							<tr class="afCenter">
								<td rowspan="2" colspan="2">С начала расчетного периода</td>
								<td rowspan="2" colspan="2">На конец предыдущего отчетного периода</td>
								<td colspan="6">в том числе за последние три месяца отчетного периода</td>
								<td rowspan="3">Всего с начала расчетного периода</td>
								<td rowspan="3">На конец предыдущего отчетного периода</td>
								<td rowspan="3">Всего за последние три месяца отчетного периода</td>
								<td rowspan="2" colspan="3">в том числе за последние три месяца отчетного периода</td>
							</tr>
							<tr class="afCenter">
								<td colspan="2">1 месяц</td>
								<td colspan="2">2 месяц</td>
								<td colspan="2">3 месяц</td>
							</tr>
							<tr class="afCenter">
								<td>Всего</td>
								<td>из них: сумма выплат в пользу работающих инвалидов</td>
								<td>Всего</td>
								<td>из них: сумма выплат в пользу работающих инвалидов</td>
								<td>Всего</td>
								<td>из них: сумма выплат в пользу работающих инвалидов</td>
								<td>Всего</td>
								<td>из них: сумма выплат в пользу работающих инвалидов</td>
								<td>Всего</td>
								<td>из них: сумма выплат в пользу работающих инвалидов</td>
								<td>1 месяц</td>
								<td>2 месяц</td>
								<td>3 месяц</td>
							</tr>
							<tr class="afCenter afHeightRow">
								<td>1</td>
								<td>2</td>
								<td>3</td>
								<td>4</td>
								<td>5</td>
								<td>6</td>
								<td>7</td>
								<td>8</td>
								<td>9</td>
								<td>10</td>
								<td>11</td>
								<td>12</td>
								<td>13</td>
								<td>14</td>
								<td>15</td>
								<td>16</td>
								<td>17</td>
								<td>18</td>
								<td>19</td>
								<td>20</td>
								<td>21</td>
								<td>22</td>
								<td>23</td>
								<td>24</td>
							</tr>
						</thead>
						<tbody class="afCenter">
							<tr class="afHeight14">
								<td class="afNoWordBreak">Всего,<br/>в том<br/>числе:</td>
								<td>X</td>
								<td>X</td>
								<td>X</td>
								<td>X</td>
								<td>X</td>
								<td>X</td>
								<td>X</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:СНачала/ЕФС8:Всего"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:СНачала/ЕФС8:СуммаИнв"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:НаКонец/ЕФС8:Всего"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:НаКонец/ЕФС8:СуммаИнв"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:ПервыйМесяц/ЕФС8:Всего"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:ПервыйМесяц/ЕФС8:СуммаИнв"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:ВторойМесяц/ЕФС8:Всего"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:ВторойМесяц/ЕФС8:СуммаИнв"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:ТретийМесяц/ЕФС8:Всего"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:База/ЕФС8:ТретийМесяц/ЕФС8:СуммаИнв"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:Исчислено/ЕФС8:ВсегоСНачала"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:Исчислено/ЕФС8:НаКонец"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:Исчислено/ЕФС8:ВсегоЗаТриМес"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:Исчислено/ЕФС8:ПервыйМесяц"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:Исчислено/ЕФС8:ВторойМесяц"/>
								</td>
								<td>
									<xsl:value-of select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:Всего/ЕФС8:Исчислено/ЕФС8:ТретийМесяц"/>
								</td>
							</tr>
							<xsl:for-each select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:ОсновнойВЭД">
								<tr class="afHeight14">
									<td>основной ВЭД</td>
									<td>
										<xsl:value-of select="ЕФС8:НаименованиеВЭД"/>
									</td>
									<td>
										<xsl:value-of select="УТ8:КодПоОКВЭД"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Подразделение"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:СтраховойТариф"/>
									</td>
									<td>
										<xsl:value-of select="ns1:СкидкаТариф"/>
									</td>
									<td>
										<xsl:value-of select="ns1:НадбавкаТариф"/>
									</td>
									<td>
										<xsl:value-of select="ns1:ТарифУчСкидНадб"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:СНачала/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:СНачала/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:НаКонец/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:НаКонец/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ПервыйМесяц/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ПервыйМесяц/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ВторойМесяц/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ВторойМесяц/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ТретийМесяц/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ТретийМесяц/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ВсегоСНачала"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:НаКонец"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ВсегоЗаТриМес"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ПервыйМесяц"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ВторойМесяц"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ТретийМесяц"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:for-each select="$OSS/ns1:РССВ/ns1:ОблБаза/ns1:СКЕ">
								<tr class="afHeight14">
									<td>
										<xsl:value-of select="position()"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:НаименованиеВЭД"/>
									</td>
									<td>
										<xsl:value-of select="УТ8:КодПоОКВЭД"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Подразделение"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:СтраховойТариф"/>
									</td>
									<td>X</td>
									<td>X</td>
									<td>X</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:СНачала/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:СНачала/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:НаКонец/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:НаКонец/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ПервыйМесяц/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ПервыйМесяц/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ВторойМесяц/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ВторойМесяц/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ТретийМесяц/ЕФС8:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:База/ЕФС8:ТретийМесяц/ЕФС8:СуммаИнв"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ВсегоСНачала"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:НаКонец"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ВсегоЗаТриМес"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ПервыйМесяц"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ВторойМесяц"/>
									</td>
									<td>
										<xsl:value-of select="ЕФС8:Исчислено/ЕФС8:ТретийМесяц"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<!-- раздел 2.2 -->
				<xsl:if test="$OSS/ns1:ИсчСтрахВзнос">
						<p class="afPageBreakAfter"/>
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 2.2. Сведения,  необходимые  для  исчисления  страховых  взносов  страхователями,  указанными  в пункте 2.1  статьи 22  Федерального закона от 24 июля 1998 г. № 125-ФЗ "Об обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний"<span class="afSup">4</span>
						</p>
						<p class="afInterval"/>
						<div class="afRight-1-4 afSubscriptNormal afCenterBlock">(руб. коп.)</div>
						<p class="afInterval"/>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afTableSmallSize">
							<colgroup>
								<col class="afTable3"/>
								<!--1-->
								<col class="afTable7"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<!--5-->
								<col class="afTable6"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<!--10-->
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<!--15-->
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
								<col class="afTable5"/>
							</colgroup>
							<thead>
								<tr class="afCenter">
									<td rowspan="4">№ п/п</td>
									<td colspan="4">Принимающая организация</td>
									<td rowspan="4">Численность временно направленных работников</td>
									<td rowspan="4">из них: численность  инвалидов</td>
									<td colspan="8">База для исчисления страховых взносов</td>
									<td rowspan="4">Размер страхового тарифа в соответствии с классом профессионального риска (%)</td>
									<td rowspan="4">Скидка к страховому тарифу (%)</td>
									<td rowspan="4">Надбавка к страховому тарифу (%)</td>
									<td rowspan="4">Размер страхового тарифа с учетом скидки (надбавки) (%) (заполняется с тремя десятичными знаками после запятой)</td>
								</tr>
								<tr class="afCenter">
									<td rowspan="3">Регистрационный номер в территориальном органе Фонда пенсионного и социального страхования Российской Федерации</td>
									<td rowspan="3">ИНН </td>
									<td rowspan="3">КПП</td>
									<td rowspan="3">ОКВЭД</td>
									<td rowspan="3">Всего с начала расчетного периода</td>
									<td rowspan="3">в том числе инвалиды</td>
									<td colspan="6">в том числе за последние три месяца отчетного периода</td>
								</tr>
								<tr class="afCenter">
									<td colspan="2">1 месяц</td>
									<td colspan="2">2 месяц</td>
									<td colspan="2">3 месяц</td>
								</tr>
								<tr class="afCenter">
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
									<td>Всего</td>
									<td>из них: сумма выплат в пользу работающих инвалидов</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
									<td>12</td>
									<td>13</td>
									<td>14</td>
									<td>15</td>
									<td>16</td>
									<td>17</td>
									<td>18</td>
									<td>19</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<xsl:for-each select="$OSS/ns1:ИсчСтрахВзнос/ns1:Запись">
									<tr class="afHeight14">
										<td>
											<xsl:value-of select="position()"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Организация/ns1:РегНомер"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Организация/УТ8:ИНН"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Организация/УТ8:КПП"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Организация/УТ8:КодПоОКВЭД"/>
										</td>
										<td>
											<xsl:value-of select="ns1:РабОбщ"/>
										</td>
										<td>
											<xsl:value-of select="ns1:РабИнв"/>
										</td>
										<td>
											<xsl:value-of select="ns1:СНачала/ЕФС8:ВыплРаб"/>
										</td>
										<td>
											<xsl:value-of select="ns1:СНачала/ЕФС8:ВыплИнв"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ПервыйМесяц/ЕФС8:ВыплРаб"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ПервыйМесяц/ЕФС8:ВыплИнв"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ВторойМесяц/ЕФС8:ВыплРаб"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ВторойМесяц/ЕФС8:ВыплИнв"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ТретийМесяц/ЕФС8:ВыплРаб"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ТретийМесяц/ЕФС8:ВыплИнв"/>
										</td>
										<td>
											<xsl:value-of select="ns1:СтраховойТариф"/>
										</td>
										<td>
											<xsl:value-of select="ns1:СкидкаТариф"/>
										</td>
										<td>
											<xsl:value-of select="ns1:НадбавкаТариф"/>
										</td>
										<td>
											<xsl:value-of select="ns1:ТарифУчСкидНадб"/>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					
					
					<p>___________________________________________</p>
					<p class="afP afFootnote">
						<span class="afSup">4</span> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2014, № 19, ст. 2321.</p>
				</xsl:if>
				<!-- раздел 2.3 -->
				<xsl:if test="$OSS/ns1:РПО">
						<p class="afPageBreakAfter"/>
						<p class="afInterval"/>
						<p class="afValue afP afMarginLeft15">Подраздел 2.3. Сведения о результатах проведенных обязательных предварительных и периодических медицинских осмотров работников и проведенной специальной оценке условий труда на начало года</p>
						<p align="afInterval"/>
						<p class="afP">Проведение обязательных предварительных и периодических медицинских осмотров работников:</p>
						<p align="afInterval"/>
						<div class="afRow">
							<div class="afCol-3-4">Общая численность работников, подлежащих обязательным предварительным и периодическим медицинским осмотрам (чел.)</div>
							<div class="afCol-10 afValue afUnderlinedBlock">
								<xsl:value-of select="$OSS/ns1:РПО/ns1:ОбщЧисл"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afCol-3-4">Численность работников,  прошедших обязательные предварительные и периодические медицинские осмотры  (чел.)</div>
							<div class="afCol-10 afValue afUnderlinedBlock">
								<xsl:value-of select="$OSS/ns1:РПО/ns1:ПрошЧисл"/>
							</div>
						</div>
						<p class="afInterval"/>
						<table class="afWordBreak afTable afTable100 afTableLayoutFixed afSmallSize">
							<colgroup>
								<col class="afTable14"/>
								<!--1-->
								<col class="afTable5"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<!--5-->
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<col class="afTable9"/>
								<!--10-->
								<col class="afTable9"/>
							</colgroup>
							<thead>
								<tr class="afCenter">
									<td rowspan="4">Наименование показателя</td>
									<td rowspan="4">Код строки</td>
									<td rowspan="4">Общее количество рабочих мест страхователя</td>
									<td colspan="8">Количество рабочих мест, в отношении  которых проведена специальная оценка условий труда </td>
								</tr>
								<tr class="afCenter">
									<td rowspan="3">всего</td>
									<td colspan="7">в том числе отнесенных к классам (подклассам) условий труда</td>
								</tr>
								<tr class="afCenter">
									<td rowspan="2">1 класс</td>
									<td rowspan="2">2 класс</td>
									<td colspan="4">3 класс</td>
									<td rowspan="2">4 класс</td>
								</tr>
								<tr class="afCenter">
									<td>3.1</td>
									<td>3.2</td>
									<td>3.3</td>
									<td>3.4</td>
								</tr>
								<tr class="afCenter afHeightRow">
									<td>1</td>
									<td>2</td>
									<td>3</td>
									<td>4</td>
									<td>5</td>
									<td>6</td>
									<td>7</td>
									<td>8</td>
									<td>9</td>
									<td>10</td>
									<td>11</td>
								</tr>
							</thead>
							<tbody class="afCenter">
								<xsl:for-each select="$OSS/ns1:РПО/ns1:Результат">
									<tr class="afHeight14">
										<td>Проведение специальной оценки условий труда</td>
										<td>
											<xsl:value-of select="position()"/>
										</td>
										<td>
											<xsl:value-of select="ns1:КоличРабМест"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Всего"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс1"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс2"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.1"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.2"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.3"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс3/ns1:Подкласс3.4"/>
										</td>
										<td>
											<xsl:value-of select="ns1:Оценки/ns1:Классы/ns1:Класс4"/>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					
				</xsl:if>
			</xsl:if>
		</div>
	</xsl:template>
	<!-- Ученое звание -->
	<xsl:template name="AcademicTitle">
		<xsl:param name="pAcademicTitle"/>
		<xsl:choose>
			<xsl:when test="$pAcademicTitle = 'АРАН'">Академик Российской академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'АМАН'">Академик международной академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'АДРА'">Академик других академий: Российской академии образования, Российской академии художеств, Российской академии архитектуры и строительных наук, отраслевой академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧРАН'">Член-корреспондент Российской академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧМАН'">Член-корреспондент международной академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧДРА'">Член-корреспондент других академий: Российской академии образования, Российской академии художеств, Российской академии архитектуры и строительных наук, отраслевой академии наук</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ПРФ'">Профессор</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ДЦ'">Доцент</xsl:when>
			<xsl:when test="$pAcademicTitle = 'СНС'">Старший научный сотрудник</xsl:when>
			<xsl:when test="$pAcademicTitle = 'МНС'">Младший научный сотрудник</xsl:when>
			<xsl:when test="$pAcademicTitle = 'АСС'">Ассистент</xsl:when>
			<xsl:when test="$pAcademicTitle = 'ЧЗАН'">Член зарубежной академии наук</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Почетное звание -->
	<xsl:template name="HonoraryTitle">
		<xsl:param name="pHonoraryTitle"/>
		<xsl:choose>
			<xsl:when test="$pHonoraryTitle = 'ЛЕТКОС'">Летчик-космонавт Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРАРТ'">Народный артист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРАРХ'">Народный архитектор Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРУЧ'">Народный учитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'НАРХУД'">Народный художник Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗАРТ'">Заслуженный артист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗАРХ'">Заслуженный архитектор Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВЕТВР'">Заслуженный ветеринарный врач Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВЛЕТ'">Заслуженный военный летчик Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВСПЕЦ'">Заслуженный военный специалист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВШТУР'">Заслуженный военный штурман Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗВРАЧ'">Заслуженный врач Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗГЕОГР'">Заслуженный географ Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗГЕОЛ'">Заслуженный геолог Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗДИСК'">Заслуженный деятель искусств Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗДНАУК'">Заслуженный деятель науки Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЖУРН'">Заслуженный журналист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЗЕМЛ'">Заслуженный землеустроитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗИЗОБР'">Заслуженный изобретатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗКОНСТР'">Заслуженный конструктор Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЛЕС'">Заслуженный лесовод Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЛЕТИСП'">Заслуженный летчик-испытатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМПРОБ'">Заслуженный мастер производственного обучения Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМАШ'">Заслуженный машиностроитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМЕТАЛ'">Заслуженный металлург Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗМЕТЕО'">Заслуженный метеоролог Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗПИЛОТ'">Заслуженный пилот Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРАТПРОМ'">Заслуженный работник атомной промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРВШКОЛ'">Заслуженный работник высшей школы Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРГЕОД'">Заслуженный работник геодезии и картографии Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРДИПСЛ'">Заслуженный работник дипломатической службы Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРЖКХ'">Заслуженный работник жилищно-коммунального хозяйства Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРЗДРАВ'">Заслуженный работник здравоохранения Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРКУЛЬТ'">Заслуженный работник культуры Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРЛЕСПРОМ'">Заслуженный работник лесной промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРНГПРОМ'">Заслуженный работник нефтяной и газовой промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРПИЩПРОМ'">Заслуженный работник пищевой индустрии Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРПОЖОХР'">Заслуженный работник пожарной охраны Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРПРОК'">Заслуженный работник прокуратуры Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРРКПРОМ'">Заслуженный работник ракетно-космической промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРРЫБХОЗ'">Заслуженный работник рыбного хозяйства Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРСВЯЗИ'">Заслуженный работник связи и информации Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРСЕЛЬХОЗ'">Заслуженный работник сельского хозяйства Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРСОЦЗАЩ'">Заслуженный работник социальной защиты населения Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРТЛПРОМ'">Заслуженный работник текстильной и легкой промышленности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРТРАНС'">Заслуженный работник транспорта Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗРФИЗКУЛ'">Заслуженный работник физической культуры Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОБЕЗ'">Заслуженный сотрудник органов безопасности Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОГОСОХР'">Заслуженный сотрудник органов государственной охраны Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОВНРАЗ'">Заслуженный сотрудник органов внешней разведки Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСОВНДЕЛ'">Заслуженный сотрудник органов внутренних дел Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗССЛЕДОРГ'">Заслуженный сотрудник следственных органов Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСПАС'">Заслуженный спасатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСТРОЙ'">Заслуженный строитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗСУДПРИС'">Заслуженный судебный пристав Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗТАМОЖ'">Заслуженный таможенник Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗУЧИТ'">Заслуженный учитель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗХИМ'">Заслуженный химик Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗХУД'">Заслуженный художник Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗШАХТ'">Заслуженный шахтер Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗШТУРМ'">Заслуженный штурман Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗШТИСП'">Заслуженный штурман-испытатель Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЭКОЛ'">Заслуженный эколог Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЭКОНОМ'">Заслуженный экономист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЭНЕРГ'">Заслуженный энергетик Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗЮРИСТ'">Заслуженный юрист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗАРТРФ'">Заслуженный артист Российской Федерации</xsl:when>
			<xsl:when test="$pHonoraryTitle = 'ЗАРХРФ'">Заслуженный архитектор Российской Федерации</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Выработка -->
	<xsl:template name="УТ8:ProductionStr">
		<xsl:param name="pProduction"/>
		<xsl:if test="$pProduction">
			<xsl:if test="$pProduction//ВС8:ВыработкаВчасах/ВС8:Часы">
				<xsl:value-of select="$pProduction//ВС8:ВыработкаВчасах/ВС8:Часы"/> ч.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС8:ВыработкаВчасах/ВС8:Минуты">
				<xsl:value-of select="$pProduction/ВС8:ВыработкаВчасах/ВС8:Минуты"/> мин.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеМесяцы">
				<xsl:value-of select="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеМесяцы"/> мес.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеДни">
				<xsl:value-of select="$pProduction/ВС8:ВыработкаКалендарная/ВС8:ВсеДни"/> д.&#160;</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="DateComplex">
		<xsl:param name="pComplex"/>
		<xsl:choose>
			<xsl:when test="$pComplex/УТ8:ДатаРождения">
				<xsl:call-template name="Date2Text">
					<xsl:with-param name="pDate" select="$pComplex/УТ8:ДатаРождения"/>
				</xsl:call-template> г.
			</xsl:when>
			<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая">
				<xsl:choose>
					<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:День">
					"<xsl:value-of select="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:День"/>"&#160;&#160;</xsl:when>
					<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц">
						<xsl:choose>
							<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:День">
								<xsl:choose>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '01' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '1'">января</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '02' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '2'">февраля</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '03' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '3'">марта</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '04' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '4'">апреля</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '05' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '5'">мая</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '06' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '6'">июня</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '07' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '7'">июля</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '08' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '8'">августа</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '09' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '9'">сентября</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '10'">октября</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '11'">ноября</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '12'">декабря</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '01' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '1'">январь</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '02' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '2'">февраль</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '03' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '3'">март</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '04' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '4'">апрель</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '05' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '5'">май</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '06' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '6'">июнь</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '07' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '7'">июль</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '08' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '8'">август</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '09' or $pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '9'">сентябрь</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '10'">октябрь</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '11'">ноябрь</xsl:when>
									<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Месяц = '12'">декабрь</xsl:when>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Год">
					&#160;&#160;<xsl:value-of select="$pComplex/УТ8:ДатаРожденияОсобая/УТ8:Год"/>
					</xsl:when>
					<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
				</xsl:choose> г.
			</xsl:when>
			<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- страхователь -->
	<xsl:template name="Policyholder">
		<xsl:param name="Policyholder1"/>
		<xsl:param name="pTel"/>
		<div class="afRow">
			<div class="afC">Регистрационный номер </div>
			<div class="afCol-2-3 afValue afUnderlinedBlock">
				<xsl:value-of select="$Policyholder1/ЕФС8:РегНомер"/>
			</div>
		</div>
		<div class="afRow">
			<div class="afValue afUnderlinedBlock">
				<xsl:value-of select="$Policyholder1/ЕФС8:Наименование"/>
			</div>
			<p class="afSubscriptSmall afCenter">(полное или сокращенное (при наличии) наименование организации, обособленного подразделения/фамилия, имя, отчество (при наличии) индивидуального предпринимателя, физического лица)</p>
		</div>
		<div class="afRow">
			<div class="afCol-1-5 afCenterBlock">ИНН</div>
			<div class="afCol-3-10">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 2, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 3, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 4, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 5, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 6, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 7, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 8, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 9, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 10, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 11, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:ИНН, 12, 1)"/>
						</td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">КПП</div>
			<div class="afCol-3-10">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 2, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 3, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 4, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 5, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 6, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 7, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 8, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КПП, 9, 1)"/>
						</td>
					</tr>
				</table>
			</div>
		</div>
		<p class="afInterval"/>
		<div class="afRow">
			<div class="afCol-10 afCenterBlock">ОКФС</div>
			<div class="afCol-10">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКФС, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКФС, 2, 1)"/>
						</td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">ОКОГУ</div>
			<div class="afCol-1-5">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 2, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 3, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 4, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 5, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 6, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКОГУ, 7, 1)"/>
						</td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">ОКПО</div>
			<div class="afCol-1-5">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 2, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 3, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 4, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 5, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 6, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 7, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/ЕФС8:ОКПО, 8, 1)"/>
						</td>
					</tr>
				</table>
			</div>
		</div>
		<p class="afInterval"/>
		<div class="afRow">
			<div class="afCol-1-5 afCenterBlock">Код по ОКВЭД</div>
			<div class="afCol-1-4">
				<table class="afTableCollapse">
					<tr>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КодПоОКВЭД, 1, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КодПоОКВЭД, 2, 1)"/>
						</td>
						<td>.</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КодПоОКВЭД, 4, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КодПоОКВЭД, 5, 1)"/>
						</td>
						<td>.</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КодПоОКВЭД, 7, 1)"/>
						</td>
						<td class="afCheckSmall">
							<xsl:value-of select="substring($Policyholder1/УТ8:КодПоОКВЭД, 8, 1)"/>
						</td>
					</tr>
				</table>
			</div>
			<div class="afCol-1-5 afCenterBlock">ОГРН (ОГРНИП)</div>
			<div class="afCol-3-10">
				<table class="afTableCollapse">
					<tr>
						<xsl:choose>
							<xsl:when test="string-length($Policyholder1/ЕФС8:ОГРН)= 13">
								<td class="afCheckSmall">0</td>
								<td class="afCheckSmall">0</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРН, 13, 1)"/>
								</td>
							</xsl:when>
							<xsl:when test="string-length($Policyholder1/ЕФС8:ОГРНИП)= 15">
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 13, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 14, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($Policyholder1/ЕФС8:ОГРНИП, 15, 1)"/>
								</td>
							</xsl:when>
								<xsl:otherwise>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								<td class="afCheckSmall">&#160;</td>
								</xsl:otherwise>
						</xsl:choose>
					</tr>
				</table>
			</div>
			<p class="afInterval"/>
			<div class="afRow afMarginLeft500">
				<div class="afCol-1-3 afCenterBlock">Код категории страхователя - физического лица</div>
				<div class="afCol-1-5">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/ЕФС8:КодКатСтрахФЛ, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/ЕФС8:КодКатСтрахФЛ, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/ЕФС8:КодКатСтрахФЛ, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/ЕФС8:КодКатСтрахФЛ, 4, 1)"/>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
		<p class="afInterval"/>
		<xsl:if test="$pTel = '1'">
			<div class="afRow">
				<div class="afCol-1-5 afCenterBlock">Номер контактного телефона</div>
				<div class="afCol-1-4">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 9, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 10, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 11, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 12, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 13, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 14, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($Policyholder1/УТ8:Телефон, 15, 1)"/>
							</td>
						</tr>
					</table>
				</div>
				<div class="afCol-1-2">
					<div class="afC">Адрес электронной почты </div>
					<div class="afMarginLeft170 afUnderlinedBlock">
						<xsl:value-of select="$Policyholder1/УТ8:АдресЭлПочты"/>
					</div>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Event">
		<xsl:param name="pEvent"/>
		<xsl:choose>
			<xsl:when test="$pEvent = '1'">ПРИЕМ</xsl:when>
			<xsl:when test="$pEvent = '2'">ПЕРЕВОД</xsl:when>
			<xsl:when test="$pEvent = '3'">ПЕРЕИМЕНОВАНИЕ</xsl:when>
			<xsl:when test="$pEvent = '4'">УСТАНОВЛЕНИЕ (ПРИСВОЕНИЕ)</xsl:when>
			<xsl:when test="$pEvent = '5'">УВОЛЬНЕНИЕ</xsl:when>
			<xsl:when test="$pEvent = '6'">ЗАПРЕТ ЗАНИМАТЬ ДОЛЖНОСТЬ (ВИД ДЕЯТЕЛЬНОСТИ)</xsl:when>
			<xsl:when test="$pEvent = '7'">ПРИОСТАНОВЛЕНИЕ</xsl:when>
			<xsl:when test="$pEvent = '8'">ВОЗОБНОВЛЕНИЕ</xsl:when>
			<xsl:when test="$pEvent = '9'">НАЧАЛО ДОГОВОРА ГПХ</xsl:when>
			<xsl:when test="$pEvent = '10'">ОКОНЧАНИЕ ДОГОВОРА ГПХ</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
