<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:ПР="http://пф.рф/Представитель/2023-04-03" xmlns:ПР8="http://пф.рф/Представитель/2024-01-01" xmlns:ЗАГР8="http://пф.рф/ВВ/ЗАГР/типы/2024-01-01" exclude-result-prefixes="xs УТ7 ПР ПР8 ЗАГР8" version="1.0">
	<!-- Дата (кратко)-->
	<xsl:template name="DateShortStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate and $pDate!=''">
			<xsl:variable name="dateText" select="string($pDate)"/>
			<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
		</xsl:if>
	</xsl:template>
	<!-- Дата (особая) УТ7 -->
	<xsl:template name="УТ7:DateSpecialStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:if test="$pDate/УТ7:День">
				<xsl:value-of select="$pDate/УТ7:День"/>.</xsl:if>
			<xsl:choose>
				<xsl:when test="$pDate/УТ7:Месяц">
					<xsl:value-of select="$pDate/УТ7:Месяц"/>.</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pDate/УТ7:День">&#160;.</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$pDate/УТ7:Год">
				<xsl:value-of select="$pDate/УТ7:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Дата (особая) (развернуто) УТ7 -->
	<xsl:template name="УТ7:DateSpecialLongStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:choose>
				<xsl:when test="$pDate/УТ7:День">
					<xsl:value-of select="concat('&quot;', format-number($pDate/УТ7:День, '00'), '&quot;')"/>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$pDate/УТ7:Месяц">
					<xsl:choose>
						<xsl:when test="$pDate/УТ7:День">
							<xsl:choose>
								<xsl:when test="$pDate/УТ7:Месяц = 1"> января </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 2"> февраля </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 3"> марта </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 4"> апреля </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 5"> мая </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 6"> июня </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 7"> июля </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 8"> августа </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 9"> сентября </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 10"> октября </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 11"> ноября </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 12"> декабря </xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$pDate/УТ7:Месяц = 1">январь </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 2">февраль </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 3">март </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 4">апрель </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 5">май </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 6">июнь </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 7">июль </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 8">август </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 9">сентябрь </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 10">октябрь </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 11">ноябрь </xsl:when>
								<xsl:when test="$pDate/УТ7:Месяц = 12">декабрь </xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$pDate/УТ7:Год">
				<xsl:value-of select="$pDate/УТ7:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Фамилия И.О. -->
	<xsl:template name="УТ7:NameStrShort">
		<xsl:param name="pName"/>
		<xsl:param name="pIOFirst"/>
		<xsl:if test="$pName">
			<xsl:choose>
				<xsl:when test="$pIOFirst">
					<xsl:if test="$pName/УТ7:Имя">
						<xsl:value-of select="substring($pName/УТ7:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ7:Отчество">
						<xsl:value-of select="substring($pName/УТ7:Отчество, 1, 1)"/>. </xsl:if>
					<xsl:if test="$pName/УТ7:Фамилия">
						<xsl:value-of select="$pName/УТ7:Фамилия"/>&#160;</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pName/УТ7:Фамилия">
						<xsl:value-of select="$pName/УТ7:Фамилия"/>&#160;</xsl:if>
					<xsl:if test="$pName/УТ7:Имя">
						<xsl:value-of select="substring($pName/УТ7:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ7:Отчество">
						<xsl:value-of select="substring($pName/УТ7:Отчество, 1, 1)"/>. </xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- ФИО -->
	<xsl:template name="УТ7:NameStr">
		<xsl:param name="pName"/>
		<!--pNoBreakWhitespace - устанавливает, следует ли использовать неразрывные пробелы или разрывные
				1 - неразрывные
				0 - разрывные (3-per-em space)-->
		<xsl:param name="pNoBreakWhitespace" select="1"/>
		<xsl:if test="$pName">
			<xsl:if test="$pName/УТ7:Фамилия">
				<xsl:value-of select="$pName/УТ7:Фамилия"/>
				<xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$pName/УТ7:Имя">
				<xsl:value-of select="$pName/УТ7:Имя"/>
				<xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$pName/УТ7:Отчество">
				<xsl:value-of select="$pName/УТ7:Отчество"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Пол -->
	<xsl:template name="УТ7:SexStr">
		<xsl:param name="pSex"/>
		<td colspan="3" class="afValue">
			<xsl:choose>
				<xsl:when test="$pSex = 1 ">М</xsl:when>
				<xsl:when test="$pSex = 2 ">Ж</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!-- Документ, удостоверяющий личность -->
	<xsl:template name="УТ7:DocumentStr">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable100">
				<tr>
					<td class="afTable40">Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:choose>
							<xsl:when test="$pDocument/УТ7:Код = 6 "> Свидетельство о рождении</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 9 "> Удостоверение беженца</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 12"> Вид на жительство в Российской Федерации</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 16"> Военный билет</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 26"> Загранпаспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 27"> Паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 28"> Паспорт иностранного гражданина</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 31"> Разрешение на временное проживание</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 36"> Служебный паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 37"> Справка об освобождении из места лишения свободы</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 93"> Свидетельство о смерти</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 511"> Иной документ, удостоверяющий личность</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 688"> Паспорт гражданина СССР</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 689"> Загранпаспорт гражданина СССР</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 690"> Удостоверение личности офицера</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 693"> Военный билет офицера запаса</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 30"> Паспорт моряка</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ7:Серия, ' ', $pDocument/УТ7:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue afTable10">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ7:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>Место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ7:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if>
						</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- ДУЛ новая форма -->
	<xsl:template name="УТ7:DocumentStrNF">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable100">
				<tr>
					<td>Документ, удостоверяющий личность: наименование</td>
					<td colspan="3" class="afValue">
						<xsl:choose>
							<xsl:when test="$pDocument/УТ7:Код">
								<xsl:call-template name="УТ7:CodDocumentStr">
									<xsl:with-param name="pCodDocument" select="$pDocument"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td>серия (при наличии)</td>
					<td class="afValue">
						<xsl:value-of select="$pDocument/УТ7:Серия"/>
					</td>
					<td>номер</td>
					<td class="afValue">
						<xsl:value-of select="$pDocument/УТ7:Номер"/>
					</td>
					<td>дата</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>орган, выдавший документ</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="$pData"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ7:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ7:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>срок действия документа (при наличии в документе)
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if>
						</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- ДУЛ форма ДМО-->
	<xsl:template name="DocStrNF">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">Документ, удостоверяющий личность: наименование</div>
				<p class="afValue afMarginLeft340 afUnderlinedAlignLeftPadding">
					<xsl:choose>
						<xsl:when test="$pDocument/УТ7:Код">
							<xsl:call-template name="УТ7:CodDocumentStr">
								<xsl:with-param name="pCodDocument" select="$pDocument"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</p>
			</div><p>,</p>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afCol-3-10">
					<div class="afC">серия <em class="afSubscriptNormal">(при наличии)</em></div>
					<p class="afValue afMarginLeft120 afUnderlinedAlignLeftPadding">
						<xsl:if test="$pDocument/УТ7:Серия">
							<xsl:value-of select="$pDocument/УТ7:Серия"/>
						</xsl:if>
					</p>
				</div>
				<div class="afCol-4"><p>,</p></div>
				
				<div class="afCol-3-10">
					<div class="afC">номер</div>
					<p class="afValue afMarginLeft50 afUnderlinedAlignLeftPadding">
						<xsl:value-of select="$pDocument/УТ7:Номер"/>
					</p>
				</div>
				<div class="afCol-2"><p>,</p></div>
				<div class="afRight-3-10">
					<div class="afC">дата выдачи</div>
					<p class="afValue afMarginLeft90 afUnderlinedAlignLeftPadding">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
					
				</div>
			</div>
			<p>,</p>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">орган, выдавший документ </div>
				<p class="afValue afMarginLeft170 afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
				</p>
			</div>
			<p>,</p>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">дата рождения</div>
				<p class="afValue afMarginLeft100 afUnderlinedAlignLeftPadding">
					<xsl:if test="$pData">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="$pData"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$pDataSpecial">
						<xsl:call-template name="УТ7:DateSpecialStr">
							<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</p>
			</div><p>,</p>
		</div>
		<xsl:if test="$pBirthplace">
			<div class="afRow">
				<div class="afCol-98">
				<div class="afC">место рождения</div>
				<p class="afValue afMarginLeft110 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="УТ7:BirthplaceStr">
						<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
					</xsl:call-template>
				</p>
				</div><p>,</p>
			</div>
		</xsl:if>
		<xsl:if test="$pPeriod = '1'">
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">срок действия документа <em class="afSubscriptNormal">(при наличии в документе)</em></div>
					<p class="afValue afMarginLeft300 afUnderlinedAlignLeftPadding">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
				</div>
				<p>,</p>
			</div>
		</xsl:if>
	</xsl:template>
	<!-- ДУЛ форма Уход-->
	<xsl:template name="DocumentStrNF">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<div class="afRow">
			<div class="afC">Документ, удостоверяющий личность:</div>
		</div>
		<div class="afRow">
			<div class="afC">наименование</div>
			<p class="afValue afMarginLeft100 afUnderlinedAlignLeftPadding">
				<xsl:choose>
					<xsl:when test="$pDocument/УТ7:Код">
						<xsl:call-template name="УТ7:CodDocumentStr">
							<xsl:with-param name="pCodDocument" select="$pDocument"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</p>
		</div>
		<div class="afRow">
			<div class="afCol-1-2">
				<div class="afC">серия (при наличии)</div>
				<p class="afValue afMarginLeft140 afUnderlinedAlignLeftPadding">
					<xsl:if test="$pDocument/УТ7:Серия">
						<xsl:value-of select="$pDocument/УТ7:Серия"/>
					</xsl:if>
				</p>
			</div>
			
			<div class="afCol-1-2">
				<div class="afC">номер</div>
				<p class="afValue afMarginLeft50 afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ7:Номер"/>
				</p>
			</div>
		</div>
		<div class="afRow">
			<div class="afCol-4-10">
				<div class="afC">дата выдачи</div>
				<p class="afValue afMarginLeft90 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
		</div>
		<div class="afRow">
			<div class="afC">кем выдан</div>
			<p class="afValue afMarginLeft80 afUnderlinedAlignLeftPadding">
				<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
			</p>
		</div>
		<div class="afRow">
			<div class="afCol-4-10">
				<div class="afC">дата рождения</div>
				<p class="afValue afMarginLeft100 afUnderlinedAlignLeftPadding">
					<xsl:if test="$pData">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="$pData"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$pDataSpecial">
						<xsl:call-template name="УТ7:DateSpecialStr">
							<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</p>
			</div>
		</div>
		<xsl:if test="$pBirthplace">
			<div class="afRow">
				<div class="afC">место рождения</div>
				<p class="afValue afMarginLeft110 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="УТ7:BirthplaceStr">
						<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
		</xsl:if>
		<xsl:if test="$pPeriod = '1'">
			<div class="afRow">
				<div class="afC">срок действия документа (при наличии)</div>
				<p class="afValue afMarginLeft270 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
		</xsl:if>
	</xsl:template>
	<!-- ДУЛ/ДУП представителя - форма ДМО-->
	<xsl:template name="DocReprStrNF">
		<xsl:param name="pDocument"/>
		<xsl:param name="pDocType"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:choose>
			<xsl:when test="$pDocType = '1'">
				<div class="afRow">
					<div class="afC">Документ, удостоверяющий личность представителя:</div>
				</div>
				<div class="afRow">
					<div class="afCol-98">
						<div class="afC">наименование</div>
						<p class="afValue afMarginLeft110 afUnderlinedAlignLeftPadding">
							<xsl:call-template name="УТ7:CodDocumentStr">
								<xsl:with-param name="pCodDocument" select="$pDocument"/>
							</xsl:call-template>
						</p>
					</div><p>,</p>
				</div>
			</xsl:when>
			<xsl:when test="$pDocType = '2'">
				<div class="afRow">
					<div class="afC">Документ, удостоверяющий полномочия представителя гражданина:</div>
				</div>
				<div class="afRow">
					<div class="afCol-98">
						<div class="afC">наименование</div>
						<p class="afValue afMarginLeft110 afUnderlinedAlignLeftPadding">
							<xsl:call-template name="УТ7:CodDUP">
								<xsl:with-param name="pCod" select="$pDocument/УТ7:Код"/>
							</xsl:call-template>
						</p>
					</div><p>,</p>
				</div>
			</xsl:when>
		</xsl:choose>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afCol-3-10">
					<div class="afC">серия <em class="afSubscriptNormal">(при наличии)</em></div>
					<p class="afValue afMarginLeft120 afUnderlinedAlignLeftPadding">
						<xsl:if test="$pDocument/УТ7:Серия">
							<xsl:value-of select="$pDocument/УТ7:Серия"/>
						</xsl:if>
					</p>
				</div>
				<div class="afCol-4"><p>,</p></div>
				
				<div class="afCol-3-10">
					<div class="afC">номер</div>
					<p class="afValue afMarginLeft50 afUnderlinedAlignLeftPadding">
						<xsl:value-of select="$pDocument/УТ7:Номер"/>
					</p>
				</div>
				<div class="afCol-2"><p>,</p></div>
				<div class="afRight-3-10">
					<div class="afC">дата выдачи</div>
					<p class="afValue afMarginLeft90 afUnderlinedAlignLeftPadding">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
					
				</div>
			</div>
			<p>,</p>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<div class="afC">орган, выдавший документ </div>
				<p class="afValue afMarginLeft180 afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
				</p>
			</div>
			<p>,</p>
		</div>
		<xsl:if test="$pData or $pDataSpecial">
			<div class="afRow">
				<div class="afCol-98">
					<div class="afC">дата рождения</div>
					<p class="afValue afMarginLeft100 afUnderlinedAlignLeftPadding">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="$pData"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ7:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</p>
				</div><p>,</p>
			</div>
		</xsl:if>
		<xsl:if test="$pBirthplace">
			<div class="afRow">
				<div class="afCol-98">
				<div class="afC">место рождения</div>
				<p class="afValue afMarginLeft110 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="УТ7:BirthplaceStr">
						<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
					</xsl:call-template>
				</p>
				</div><p>,</p>
			</div>
		</xsl:if>
		<xsl:if test="$pPeriod = '1'">
			<xsl:choose>
				<xsl:when test="$pDocType = '1' and $pPeriod = '1'">
					<div class="afRow">
						<div class="afCol-98">
							<div class="afC">срок действия документа <em class="afSubscriptNormal">(при наличии в документе)</em></div>
							<p class="afValue afMarginLeft300 afUnderlinedAlignLeftPadding">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
									</xsl:with-param>
								</xsl:call-template>
							</p>
						</div>
						<p>,</p>
					</div>
				</xsl:when>
				<xsl:when test="$pDocType = '2' and $pPeriod = '1'">
					<div class="afRow">
						<div class="afCol-98">
							<div class="afC">срок действия полномочий</div>
							<p class="afValue afMarginLeft180 afUnderlinedAlignLeftPadding">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
									</xsl:with-param>
								</xsl:call-template>
							</p>
						</div>
						<p>,</p>
					</div>
				</xsl:when>
			</xsl:choose>	
		</xsl:if>
	</xsl:template>
	<!-- Код Документа, удостоверяющий личность -->
	<xsl:template name="УТ7:CodDocumentStr">
		<xsl:param name="pCodDocument"/>
		<xsl:choose>
			<xsl:when test="$pCodDocument/УТ7:Код = 6 "> Свидетельство о рождении</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 9 "> Удостоверение беженца</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 12"> Вид на жительство в Российской Федерации</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 16"> Военный билет</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 26"> Загранпаспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 27"> Паспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 28"> Паспорт иностранного гражданина</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 31"> Разрешение на временное проживание</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 36"> Служебный паспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 37"> Справка об освобождении из места лишения свободы</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 93"> Свидетельство о смерти</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 511"> Иной документ, удостоверяющий личность</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 688"> Паспорт гражданина СССР</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 689"> Загранпаспорт гражданина СССР</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 690"> Удостоверение личности офицера</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 693"> Военный билет офицера запаса</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 30"> Паспорт моряка</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
			<xsl:when test="$pCodDocument/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CodDULStr">
		<xsl:param name="pCodDocument"/>
		<xsl:choose>
			<xsl:when test="$pCodDocument = 6 "> Свидетельство о рождении</xsl:when>
			<xsl:when test="$pCodDocument = 9 "> Удостоверение беженца</xsl:when>
			<xsl:when test="$pCodDocument = 12"> Вид на жительство в Российской Федерации</xsl:when>
			<xsl:when test="$pCodDocument = 16"> Военный билет</xsl:when>
			<xsl:when test="$pCodDocument = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
			<xsl:when test="$pCodDocument = 26"> Загранпаспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument = 27"> Паспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument = 28"> Паспорт иностранного гражданина</xsl:when>
			<xsl:when test="$pCodDocument = 31"> Разрешение на временное проживание</xsl:when>
			<xsl:when test="$pCodDocument = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
			<xsl:when test="$pCodDocument = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
			<xsl:when test="$pCodDocument = 36"> Служебный паспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument = 37"> Справка об освобождении из места лишения свободы</xsl:when>
			<xsl:when test="$pCodDocument = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
			<xsl:when test="$pCodDocument = 93"> Свидетельство о смерти</xsl:when>
			<xsl:when test="$pCodDocument = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
			<xsl:when test="$pCodDocument = 511"> Иной документ, удостоверяющий личность</xsl:when>
			<xsl:when test="$pCodDocument = 688"> Паспорт гражданина СССР</xsl:when>
			<xsl:when test="$pCodDocument = 689"> Загранпаспорт гражданина СССР</xsl:when>
			<xsl:when test="$pCodDocument = 690"> Удостоверение личности офицера</xsl:when>
			<xsl:when test="$pCodDocument = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
			<xsl:when test="$pCodDocument = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
			<xsl:when test="$pCodDocument = 693"> Военный билет офицера запаса</xsl:when>
			<xsl:when test="$pCodDocument = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
			<xsl:when test="$pCodDocument = 13"> Вид на жительство иностранного гражданина</xsl:when>
			<xsl:when test="$pCodDocument = 29"> Паспорт Минморфлота</xsl:when>
			<xsl:when test="$pCodDocument = 30"> Паспорт моряка</xsl:when>
			<xsl:when test="$pCodDocument = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
			<xsl:when test="$pCodDocument = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ДУП форма Уход-->
	<xsl:template name="DUPStrNF">
		<xsl:param name="pDocument"/>
		<div class="afRow">
			<div class="afC">Документ, подтверждающий полномочия представителя:</div>
		</div>
		<div class="afRow">
			<div class="afC">наименование</div>
			<p class="afValue afMarginLeft100 afUnderlinedAlignLeftPadding">
				<xsl:choose>
					<xsl:when test="$pDocument">
						<xsl:call-template name="УТ7:CodDUP">
							<xsl:with-param name="pCod" select="$pDocument/УТ7:Код"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</p>
		</div>
		<div class="afRow">
			<div class="afCol-1-2">
				<div class="afC">серия (при наличии)</div>
				<p class="afValue afMarginLeft140 afUnderlinedAlignLeftPadding">
					<xsl:if test="$pDocument/УТ7:Серия">
						<xsl:value-of select="$pDocument/УТ7:Серия"/>
					</xsl:if>
				</p>
			</div>
			
			<div class="afCol-1-2">
				<div class="afC">номер</div>
				<p class="afValue afMarginLeft50 afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$pDocument/УТ7:Номер"/>
				</p>
			</div>
		</div>
		<div class="afRow">
			<div class="afCol-4-10">
				<div class="afC">дата выдачи</div>
				<p class="afValue afMarginLeft90 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
		</div>
		<div class="afRow">
			<div class="afC">кем выдан</div>
			<p class="afValue afMarginLeft80 afUnderlinedAlignLeftPadding">
				<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
			</p>
		</div>
		<div class="afRow">
			<div class="afCol-1-2">
				<div class="afC">срок действия полномочий <em class="afSubscript">(при наличии)</em></div>
				<p class="afValue afMarginLeft250 afUnderlinedAlignLeftPadding">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
		</div>
	</xsl:template>

<!-- Гражданство-->
	<xsl:template name="NationalityStr">
		<xsl:param name="pNationalityType"/>
		<xsl:choose>
			<xsl:when test="$pNationalityType = '1'"> гражданин(-ка) РФ </xsl:when>
			<xsl:when test="$pNationalityType = '2'"> иностранный гражданин </xsl:when>
			<xsl:when test="$pNationalityType = '3'"> лицо без гражданства </xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Пункт нормативного документа-->
	<xsl:template name="УТ7:NormativeDocumentStr">
		<xsl:param name="pNormativeDocument"/>
		<xsl:choose>
			<xsl:when test="$pNormativeDocument">
				<xsl:if test="$pNormativeDocument/УТ7:Подпункт"> подпункт <xsl:value-of select="$pNormativeDocument/УТ7:Подпункт"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ7:Пункт">
					<xsl:value-of select="concat(' п.',' ', $pNormativeDocument/УТ7:Пункт)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ7:Часть">
					<xsl:value-of select="concat(' ч.',' ', $pNormativeDocument/УТ7:Часть)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ7:Статья">
					<xsl:value-of select="concat(' ст.',' ', $pNormativeDocument/УТ7:Статья)"/>&#160;
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ7:НормативныйДокумент">
					<xsl:value-of select="concat(' ',' ', $pNormativeDocument/УТ7:НормативныйДокумент)"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Адрес в строку -->
	<xsl:template name="УТ7:AddressStr">
		<xsl:param name="pAddress"/>
		<xsl:param name="needIndex" select="1"/>
		<xsl:param name="needRegion" select="1"/>
		<xsl:if test="$needIndex and $pAddress/УТ7:Индекс">
			<xsl:value-of select="$pAddress/УТ7:Индекс"/>, </xsl:if>
		<xsl:if test="$needRegion and $pAddress/УТ7:Регион">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ7:Регион/УТ7:Сокращение">
					<xsl:choose>
						<xsl:when test="$pAddress/УТ7:Регион/УТ7:Сокращение='край' or $pAddress/УТ7:Регион/УТ7:Сокращение='Республика'">
							<xsl:value-of select="concat($pAddress/УТ7:Регион/УТ7:Название, ' ', $pAddress/УТ7:Регион/УТ7:Сокращение)"/>,
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($pAddress/УТ7:Регион/УТ7:Название, ' ', $pAddress/УТ7:Регион/УТ7:Сокращение, '.')"/>,</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ7:Регион/УТ7:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ7:Округ">
			<xsl:value-of select="$pAddress/УТ7:Округ"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ7:Район">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ7:Район/УТ7:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ7:Район/УТ7:Название, ' ', $pAddress/УТ7:Район/УТ7:Сокращение)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($pAddress/УТ7:Район/УТ7:Название, ' р-н')"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ7:Город">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ7:Город/УТ7:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ7:Город/УТ7:Сокращение, '. ', $pAddress/УТ7:Город/УТ7:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('г. ', $pAddress/УТ7:Город/УТ7:Название)"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ7:ВнутригородскойРайон">
			<xsl:value-of select="$pAddress/УТ7:ВнутригородскойРайон"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ7:НаселенныйПункт">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ7:НаселенныйПункт/УТ7:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ7:НаселенныйПункт/УТ7:Сокращение, '. ', $pAddress/УТ7:НаселенныйПункт/УТ7:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ7:НаселенныйПункт/УТ7:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ7:Улица">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ7:Улица/УТ7:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ7:Улица/УТ7:Сокращение, '. ', $pAddress/УТ7:Улица/УТ7:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ7:Улица/УТ7:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ7:Дом">
			<xsl:value-of select="concat(' д. ', $pAddress/УТ7:Дом)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ7:Строение or $pAddress/УТ7:Владение or $pAddress/УТ7:Корпус or $pAddress/УТ7:Квартира">, </xsl:if>
		<xsl:if test="$pAddress/УТ7:Строение">
			<xsl:value-of select="concat(' стр. ', $pAddress/УТ7:Строение)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ7:Владение">
			<xsl:value-of select="$pAddress/УТ7:Владение"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ7:Корпус">
			<xsl:value-of select="concat(' корпус ', $pAddress/УТ7:Корпус)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ7:Квартира">
			<xsl:value-of select="concat(' кв. ', $pAddress/УТ7:Квартира)"/>
		</xsl:if>
	</xsl:template>
	<!-- Адрес иностранный в строку -->
	<xsl:template name="УТ7:AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress/УТ7:Иностранный">
			<xsl:if test="$pAddress/УТ7:Иностранный/УТ7:КодСтраны">
				<xsl:value-of select="$pAddress/УТ7:Иностранный/УТ7:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ7:Иностранный/УТ7:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ7:Иностранный/УТ7:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ7:Иностранный/УТ7:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ7:Иностранный/УТ7:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ7:Иностранный/УТ7:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ7:Иностранный/УТ7:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Адрес иностранный в строку -->
	<xsl:template name="AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress">
			<xsl:if test="$pAddress/УТ7:КодСтраны">
				<xsl:value-of select="$pAddress/УТ7:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ7:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ7:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ7:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ7:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ7:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ7:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- ЗАГР8: Адрес иностранный в строку -->
	<xsl:template name="ЗАГР8:AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress">
			<xsl:if test="$pAddress/УТ7:КодСтраны">
				<xsl:value-of select="$pAddress/УТ7:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/ЗАГР8:НазваниеСтраны">
				<xsl:value-of select="$pAddress/ЗАГР8:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/ЗАГР8:АдресКириллицей">
				<xsl:value-of select="$pAddress/ЗАГР8:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/ЗАГР8:АдресЛатиницей">
				<xsl:value-of select="$pAddress/ЗАГР8:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Место рождения -->
	<xsl:template name="УТ7:BirthplaceStr">
		<xsl:param name="pBirthplace"/>
		<xsl:if test="$pBirthplace/УТ7:Город">
			<xsl:value-of select="$pBirthplace/УТ7:Город"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ7:Район">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ7:Район)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ7:Регион">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ7:Регион)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ7:Страна">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ7:Страна)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="УТ7:NumberedDocName">
		<xsl:param name="pDoc"/>
		<xsl:value-of select="$pDoc/УТ7:Наименование"/>
		<xsl:for-each select="$pDoc/УТ7:Реквизиты/УТ7:Реквизит">
			<xsl:if test="position() > 1">,</xsl:if> &#160;<xsl:value-of select="./УТ7:Наименование"/>&#160;<xsl:value-of select="./УТ7:Значение"/>
		</xsl:for-each>
		<xsl:if test="$pDoc/УТ7:ПредставленностьДокумента"> &#160;<xsl:value-of select="$pDoc/УТ7:ПредставленностьДокумента"/> экз. </xsl:if>
	</xsl:template>
	<!-- Представитель УТ7 -->
	<xsl:template name="УТ7:RepresentativeStr">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<p class="afParagraph">2. Представитель <xsl:call-template name="УТ7:RepresentativeType">
				<xsl:with-param name="pRepresent" select="$pRepresent"/>
			</xsl:call-template>
		</p>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР:ЮридическоеЛицо/УТ7:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ7:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР:АнкетныеДанные/УТ7:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
								<span class="afUnderline afValue">
									<xsl:call-template name="АдресРФ">
										<xsl:with-param name="pAddressRF" select="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресРФ"/>
										<xsl:with-param name="pType" select="1"/>
									</xsl:call-template>
						</span>,
							</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР:ЮридическоеЛицо/УТ7:ЮрАдрес">
					<div class="afC">юридический адрес организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР:ЮридическоеЛицо/УТ7:ЮрАдрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР:ЮридическоеЛицо/УТ7:ЮрАдрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР:ЮридическоеЛицо/УТ7:ЮрАдрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">юридический адрес организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft210"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР:ЮридическоеЛицо/ПР:Адрес">
					<div class="afC">место нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР:ЮридическоеЛицо/ПР:Адрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР:ЮридическоеЛицо/ПР:Адрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР:ЮридическоеЛицо/ПР:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">место нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft200"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<div class="afC">Контактный телефон</div>
			<div class="afCol-1-3 afValue afUnderlinedBlock">
				<xsl:value-of select="$pRepresent/ПР:АнкетныеДанные/УТ7:Телефоны"/>
			</div>
			<p>,</p>
		</div>
		<div class="afRow">
			<div class="afC">Адрес электронной почты:</div>
			<div class="afCol-1-3 afValue afUnderlinedBlock">
				<xsl:value-of select="$pRepresent/ПР:АнкетныеДанные/УТ7:АдресЭлПочты"/>
			</div>
			<p>,</p>
		</div>
		<p class="afInterval"/>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 12">Вид на жительство в Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 16">Военный билет</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 18">Временное удостоверение личности гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 26">Загранпаспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 27">Паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 28">Паспорт иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 31">Разрешение на временное проживание</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 32">Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 33">Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 36">Служебный паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 37">Справка об освобождении из места лишения свободы</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 39">Удостоверение личности военнослужащего РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 93">Свидетельство о смерти</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 210">Дипломатический паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 511">Иной документ, удостоверяющий личность</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 688">Паспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 689">Загранпаспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 690">Удостоверение личности офицера</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 691">Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 692">Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 693">Военный билет офицера запаса</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 706">Временное удостоверение, выданное взамен военного билета</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 30"> Паспорт моряка</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
						<xsl:when test="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Серия, ' ', $pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1">Документ, выданный органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 2">Положение (устав) организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 3">Постановление администрации об установлении опекунства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 4">Решение органа опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 5">Решение суда</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 7">Свидетельство об установлении отцовства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 11">Учредительные документы организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 286">Нотариальная доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 632">Документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 710">Доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1133">Акт об отобрании ребенка</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1138">Выписка из судебного решения</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Серия, ' ', $pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<!-- Тип представителя УТ7 -->
	<xsl:template name="УТ7:RepresentativeType">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pType1Text" select="'законный представитель недееспособного лица'"/>
		<xsl:param name="pNoteStyle" select="'afItalic'"/>
		<xsl:if test="$pRepresent">
			<span> (<xsl:choose>
					<xsl:when test="$pRepresent/ПР:Тип[text() = '1'] and count($pRepresent/ПР:ЮридическоеЛицо) = 0">
						<span class="afUnderline">
							<xsl:value-of select="$pType1Text"/>
						</span>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$pType1Text"/>
					</xsl:otherwise>
				</xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="count($pRepresent/ПР:ЮридическоеЛицо) > 0">
						<span class="afUnderline">организация, на которую возложено исполнение обязанностей опекуна или попечителя</span>
					</xsl:when>
					<xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise>
				</xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="$pRepresent/ПР:Тип[text() = '2'] and count($pRepresent/ПР:ЮридическоеЛицо) = 0">
						<span class="afUnderline">доверенное лицо</span>
					</xsl:when>
					<xsl:otherwise>доверенное лицо</xsl:otherwise>
				</xsl:choose>) <span class="{$pNoteStyle}">(нужное подчеркнуть):</span>
			</span>
		</xsl:if>
	</xsl:template>
	<xsl:template name="УТ7:CodDUP">
		<xsl:param name="pCod"/>
		<xsl:choose>
			<xsl:when test="$pCod = 1">Документ, выданный органом опеки и попечительства</xsl:when>
			<xsl:when test="$pCod = 2">Положение (устав) организации</xsl:when>
			<xsl:when test="$pCod = 3">Постановление администрации об установлении опекунства</xsl:when>
			<xsl:when test="$pCod = 4">Решение органа опеки и попечительства</xsl:when>
			<xsl:when test="$pCod = 5">Решение суда</xsl:when>
			<xsl:when test="$pCod = 6">Свидетельство о рождении</xsl:when>
			<xsl:when test="$pCod = 7">Свидетельство об установлении отцовства</xsl:when>
			<xsl:when test="$pCod = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
			<xsl:when test="$pCod = 9">Удостоверение беженца</xsl:when>
			<xsl:when test="$pCod = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
			<xsl:when test="$pCod = 11">Учредительные документы организации</xsl:when>
			<xsl:when test="$pCod = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
			<xsl:when test="$pCod = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
			<xsl:when test="$pCod = 286">Нотариальная доверенность</xsl:when>
			<xsl:when test="$pCod = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
			<xsl:when test="$pCod = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
			<xsl:when test="$pCod = 632">Документ, подтверждающий полномочия представителя</xsl:when>
			<xsl:when test="$pCod = 710">Доверенность</xsl:when>
			<xsl:when test="$pCod = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
			<xsl:when test="$pCod = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
			<xsl:when test="$pCod = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
			<xsl:when test="$pCod = 1133">Акт об отобрании ребенка</xsl:when>
			<xsl:when test="$pCod = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
			<xsl:when test="$pCod = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
			<xsl:when test="$pCod = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
			<xsl:when test="$pCod = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
			<xsl:when test="$pCod = 1138">Выписка из судебного решения</xsl:when>
			<xsl:when test="$pCod = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
			<xsl:when test="$pCod = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Тип представителя ПР8 -->
	<xsl:template name="ПР8:RepresentativeType">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pType1Text" select="'законный представитель несовершеннолетнего или недееспособного лица'"/>
		<xsl:param name="pNoteStyle" select="'afItalic'"/>
		<xsl:param name="pSup"/>
		<xsl:choose>
			<xsl:when test="$pRepresent">
				<span> (<xsl:choose>
						<xsl:when test="$pRepresent/ПР8:Тип/ПР8:ЗаконныйПР and count($pRepresent/ПР8:ЮридическоеЛицо) = 0">
							<span class="afUnderline">
								<xsl:value-of select="$pType1Text"/>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$pType1Text"/>
						</xsl:otherwise>
					</xsl:choose>,&#160;<xsl:choose>
						<xsl:when test="count($pRepresent/ПР8:ЮридическоеЛицо) > 0">
							<span class="afUnderline">организация, на которую возложено исполнение обязанностей опекуна или попечителя</span>
						</xsl:when>
						<xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise>
					</xsl:choose>,&#160;<xsl:choose>
						<xsl:when test="$pRepresent/ПР8:Тип/ПР8:ДоверенноеЛицо and count($pRepresent/ПР:ЮридическоеЛицо) = 0">
							<span class="afUnderline">доверенное лицо</span>
						</xsl:when>
						<xsl:otherwise>доверенное лицо</xsl:otherwise>
					</xsl:choose>) <span class="{$pNoteStyle}">(нужное подчеркнуть)<xsl:if test="$pSup = '1'"><sup class="afFootnote">1</sup></xsl:if>:</span>
				</span>
			</xsl:when>
			<xsl:otherwise>(законный представитель недееспособного лица, организация, на которую возложено исполнение обязанностей опекуна или попечителя, доверенное лицо) <span class="{$pNoteStyle}">(нужное подчеркнуть)<xsl:if test="$pSup = '1'"><sup class="afFootnote">1</sup></xsl:if></span>:</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Представитель ПР8 -->
	<xsl:template name="ПР8:RepresentativeStr">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNewPhoneNoMail"/>
		<xsl:param name="pNoTab"/>
		<xsl:choose>
			<xsl:when test="$pNoTab = '1'">
				<p class="afC">2. Представитель 
					<xsl:call-template name="ПР8:RepresentativeType">
						<xsl:with-param name="pRepresent" select="$pRepresent"/>
					</xsl:call-template>
				</p>
			</xsl:when>
			<xsl:otherwise>
				<p class="afParagraph">2. Представитель 
					<xsl:call-template name="ПР8:RepresentativeType">
						<xsl:with-param name="pRepresent" select="$pRepresent"/>
					</xsl:call-template>
				</p>
			</xsl:otherwise>
		</xsl:choose>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР8:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ7:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
								<span class="afUnderline afValue">
									<xsl:call-template name="АдресРФ">
										<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
										<xsl:with-param name="pType" select="1"/>
									</xsl:call-template>
						</span>,
							</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес">
					<div class="afC">юридический адрес организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">юридический адрес организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft210"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес">
					<div class="afC">место нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">место нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft200"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<xsl:choose>
			<xsl:when test="$pNewPhoneNoMail = '1'">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
					</div>
					<p>,</p>
				</div>
			</xsl:when>
			<xsl:when test="$pNewPhoneNoMail = '2'">
				<div class="afRow">
					<div class="afCol-98">
						<div class="afC">номер телефона</div>
						<div class="afCol-1-5 afValue afUnderlinedBlock">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Телефон">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Телефон"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<div class="afC">,&#160;адрес электронной почты</div>
						<div class="afCol-3-8 afValue afUnderlinedBlock">
							<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресЭлПочты"/>
						</div>
					</div>
					<p>.</p>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
					</div>
					<p>,</p>
				</div>
				<div class="afRow">
					<div class="afC">Адрес электронной почты</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресЭлПочты"/>
					</div>
					<p>.</p>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<p class="afInterval"/>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 12">Вид на жительство в Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 16">Военный билет</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 18">Временное удостоверение личности гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 26">Загранпаспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 27">Паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 28">Паспорт иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 31">Разрешение на временное проживание</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 32">Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 33">Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 36">Служебный паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 37">Справка об освобождении из места лишения свободы</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 39">Удостоверение личности военнослужащего РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 93">Свидетельство о смерти</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 210">Дипломатический паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 511">Иной документ, удостоверяющий личность</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 688">Паспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 689">Загранпаспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 690">Удостоверение личности офицера</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 691">Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 692">Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 693">Военный билет офицера запаса</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 706">Временное удостоверение, выданное взамен военного билета</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 30"> Паспорт моряка</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Серия, ' ', $pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1">Документ, выданный органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 2">Положение (устав) организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 3">Постановление администрации об установлении опекунства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 4">Решение органа опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 5">Решение суда</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 7">Свидетельство об установлении отцовства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 11">Учредительные документы организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 286">Нотариальная доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 632">Документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 710">Доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1133">Акт об отобрании ребенка</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1138">Выписка из судебного решения</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Серия, ' ', $pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<!-- Представитель КСП8 -->
	<xsl:template name="ПР8:RepresentativeKSP">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNoEmail"/>
		<xsl:param name="pSupp"/>
		<p class="afC">2. Представитель <xsl:call-template name="ПР8:RepresentativeType">
				<xsl:with-param name="pRepresent" select="$pRepresent"/>
				<xsl:with-param name="pType1Text" select="'законный представитель недееспособного лица'"/>
				<xsl:with-param name="pSup" select="$pSupp"/>
			</xsl:call-template>
		</p>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР8:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ7:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
								<span class="afUnderline afValue">
									<xsl:call-template name="АдресРФ">
										<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
										<xsl:with-param name="pType" select="1"/>
									</xsl:call-template>
						</span>,
							</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес">
					<div class="afC">адрес места нахождения организации
						<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:ЮрАдрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
					</div>
				</xsl:when>
				<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес">
					<div class="afC">адрес места нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft270"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<div class="afCol-98">
				<xsl:choose>
					<xsl:when test="$pNoEmail = '1'">
						<div class="afC">номер телефона</div>
						<p class="afValue afUnderlinedBlock afMarginLeft110">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Телефон">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Телефон"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
								</xsl:otherwise>
							</xsl:choose>
						</p>
					</xsl:when>
					<xsl:otherwise>	
						<div class="afC">номер телефона</div>
						<div class="afCol-1-5 afValue afUnderlinedBlock">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Телефон">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Телефон"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<div class="afC">,&#160;адрес электронной почты</div>
						<div class="afCol-3-8 afValue afUnderlinedBlock">
							<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресЭлПочты"/>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<p>,</p>
		</div>
		<p class="afInterval"/>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 12">Вид на жительство в Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 16">Военный билет</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 18">Временное удостоверение личности гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 26">Загранпаспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 27">Паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 28">Паспорт иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 31">Разрешение на временное проживание</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 32">Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 33">Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 36">Служебный паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 37">Справка об освобождении из места лишения свободы</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 39">Удостоверение личности военнослужащего РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 93">Свидетельство о смерти</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 210">Дипломатический паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 511">Иной документ, удостоверяющий личность</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 688">Паспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 689">Загранпаспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 690">Удостоверение личности офицера</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 691">Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 692">Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 693">Военный билет офицера запаса</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 706">Временное удостоверение, выданное взамен военного билета</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 30"> Паспорт моряка</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Серия, ' ', $pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1">Документ, выданный органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 2">Положение (устав) организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 3">Постановление администрации об установлении опекунства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 4">Решение органа опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 5">Решение суда</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 7">Свидетельство об установлении отцовства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 11">Учредительные документы организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 286">Нотариальная доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 632">Документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 710">Доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1133">Акт об отобрании ребенка</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1138">Выписка из судебного решения</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Серия, ' ', $pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<!-- Представитель ПР8 -->
	<xsl:template name="ПР8:RepresentativeDMO">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNewPhoneNoMail"/>
		<xsl:param name="pNoTab"/>
		<xsl:choose>
			<xsl:when test="$pNoTab = '1'">
				<p class="afC">2. Представитель 
					<xsl:call-template name="ПР8:RepresentativeType">
						<xsl:with-param name="pRepresent" select="$pRepresent"/>
						<xsl:with-param name="pType1Text" select="'законный представитель несовершеннолетнего или недееспособного лица'"/>
					</xsl:call-template>
				</p>
			</xsl:when>
			<xsl:otherwise>
				<p class="afParagraph">2. Представитель 
					<xsl:call-template name="ПР8:RepresentativeType">
						<xsl:with-param name="pRepresent" select="$pRepresent"/>
						<xsl:with-param name="pType1Text" select="'законный представитель несовершеннолетнего или недееспособного лица'"/>
					</xsl:call-template>
				</p>
			</xsl:otherwise>
		</xsl:choose>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР8:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ7:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
								<span class="afUnderline afValue">
									<xsl:call-template name="АдресРФ">
										<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
										<xsl:with-param name="pType" select="1"/>
									</xsl:call-template>
						</span>,
							</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft250"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес">
					<div class="afC">адрес места нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft250"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<xsl:choose>
			<xsl:when test="$pNewPhoneNoMail = '1'">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
					</div>
					<p>,</p>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="afRow">
					<div class="afC">Контактный телефон</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
					</div>
					<p>,</p>
				</div>
				<div class="afRow">
					<div class="afC">Адрес электронной почты:</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресЭлПочты"/>
					</div>
					<p>,</p>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="DocReprStrNF">
			<xsl:with-param name="pDocument" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент"/>
			<xsl:with-param name="pDocType" select="1"/>
			<xsl:with-param name="pPeriod">1</xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="DocReprStrNF">
			<xsl:with-param name="pDocument" select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия"/>
			<xsl:with-param name="pDocType" select="2"/>
			<xsl:with-param name="pPeriod">1</xsl:with-param>
		</xsl:call-template>
		
	</xsl:template>
	<!-- Представитель ПР8 -->
	<xsl:template name="ПР8:RepresentativeDMOTab">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:param name="pNewPhoneNoMail"/>
		<xsl:param name="pNoTab"/>
		<xsl:choose>
			<xsl:when test="$pNoTab = '1'">
				<p class="afC">2. Представитель 
					<xsl:call-template name="ПР8:RepresentativeType">
						<xsl:with-param name="pRepresent" select="$pRepresent"/>
					</xsl:call-template>
				</p>
			</xsl:when>
			<xsl:otherwise>
				<p class="afParagraph">2. Представитель 
					<xsl:call-template name="ПР8:RepresentativeType">
						<xsl:with-param name="pRepresent" select="$pRepresent"/>
					</xsl:call-template>
				</p>
			</xsl:otherwise>
		</xsl:choose>
		<div class="afCol-98">
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:if test="$pRepresent/ПР8:ЮридическоеЛицо">
					<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/УТ7:Наименование"/>,&#160; 
					</xsl:if>
				<xsl:call-template name="УТ7:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:ФИО"/>
				</xsl:call-template>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
		</div>
		<p>,</p>
		<p class="afInterval"/>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '1'">
					<div class="afC">адрес места жительства
								<span class="afUnderline afValue">
									<xsl:call-template name="АдресРФ">
										<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
										<xsl:with-param name="pType" select="1"/>
									</xsl:call-template>
						</span>,
							</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места жительства</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '2'">
					<div class="afC">адрес места пребывания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="2"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места пребывания</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft170"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ/УТ7:ТипАдреса = '3'">
					<div class="afC">адрес фактического проживания
							<span class="afUnderline afValue">
								<xsl:call-template name="АдресРФ">
									<xsl:with-param name="pAddressRF" select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресРФ"/>
									<xsl:with-param name="pType" select="3"/>
								</xsl:call-template>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес фактического проживания</div>
						<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft210"/>
					</div>
					<p>,</p>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		
		<div class="afRow">
			<xsl:choose>
				<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес">
					<div class="afC">адрес места нахождения организации
							<span class="afUnderline afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный">
									<xsl:value-of select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес/УТ7:Неструктурированный"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ7:AddressStr">
										<xsl:with-param name="pAddress" select="$pRepresent/ПР8:ЮридическоеЛицо/ПР8:Адрес"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</span>,
						</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afCol-98">
						<div class="afC">адрес места нахождения организации</div>
						<div class="afValue afBlankUnderlinedBlock afMarginLeft250"/>
					</div>,
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<xsl:choose>
			<xsl:when test="$pNewPhoneNoMail = '1'">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
					</div>
					<p>,</p>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="afRow">
					<div class="afC">Контактный телефон</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:Телефон"/>
					</div>
					<p>,</p>
				</div>
				<div class="afRow">
					<div class="afC">Адрес электронной почты:</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:АдресЭлПочты"/>
					</div>
					<p>,</p>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<p class="afInterval"/>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, удостоверяющего личность представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 12">Вид на жительство в Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 16">Военный билет</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 18">Временное удостоверение личности гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 26">Загранпаспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 27">Паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 28">Паспорт иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 31">Разрешение на временное проживание</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 32">Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 33">Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 36">Служебный паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 37">Справка об освобождении из места лишения свободы</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 39">Удостоверение личности военнослужащего РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 93">Свидетельство о смерти</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 210">Дипломатический паспорт гражданина РФ</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 511">Иной документ, удостоверяющий личность</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 688">Паспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 689">Загранпаспорт гражданина СССР</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 690">Удостоверение личности офицера</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 691">Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 692">Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 693">Военный билет офицера запаса</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 706">Временное удостоверение, выданное взамен военного билета</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 30"> Паспорт моряка</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
						<xsl:when test="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Серия, ' ', $pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pIDPeriod = '1'">
				<tr>
					<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
							<span class="afSubscript"> (при наличии)</span>
						</xsl:if>
					</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/ПР8:АнкетныеДанные/УТ7:УдостоверяющийДокумент/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
		<p class="afInterval"/>
		<table class="afTable afTable100 afNoBreakInside">
			<tr>
				<td class="afTable40">Наименование документа, подтверждающего полномочия представителя</td>
				<td colspan="3" class="afValue">
					<xsl:choose>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1">Документ, выданный органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 2">Положение (устав) организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 3">Постановление администрации об установлении опекунства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 4">Решение органа опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 5">Решение суда</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 6">Свидетельство о рождении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 7">Свидетельство об установлении отцовства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 8">Свидетельство об усыновлении (удочерении)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 9">Удостоверение беженца</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 10">Удостоверение, выданное органом опеки и попечительства</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 11">Учредительные документы организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 19">Документ исправительного учреждения о нахождении (пребывании) осужденного к лишению свободы или принудительным работам в исправительном учреждении</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 20">Документ стационарной организации социального обслуживания о нахождении (пребывании) гражданина в этой организации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 286">Нотариальная доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 513">Доверенность, выданная в порядке, установленном Гражданским кодексом Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 630">Документ, удостоверяющий личность представителя гражданина Российской Федерации</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 632">Документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 710">Доверенность</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 887">Иной документ, подтверждающий полномочия представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 964">Документ, подтверждающий полномочия уполномоченного представителя застрахованного лица</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 968">Документ, подтверждающий полномочия представителя страхователя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1133">Акт об отобрании ребенка</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1134">Акт органа опеки и попечительства о временном назначении опекуна или попечителя (акт о предварительных опеке или попечительстве)</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1135">Акт органа опеки и попечительства о назначении опекуна или попечителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1136">Акт органа опеки и попечительства об объявлении дееспособным</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1137">Акт органа опеки и попечительства об освобождении опекуна или попечителя от исполнения возложенных на них обязанностей либо об их отстранении от исполнения возложенных на них обязанностей</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1138">Выписка из судебного решения</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1139">Иной документ подтверждающий полномочия (прекращения полномочий) законного представителя</xsl:when>
						<xsl:when test="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Код = 1140">Акт гражданского состояния ЕГР ЗАГС</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td>Серия, номер</td>
				<td class="afValue">
					<xsl:value-of select="concat($pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Серия, ' ', $pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:Номер)"/>
				</td>
				<td>Дата выдачи</td>
				<td class="afValue afTable10">
					<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td>Кем выдан</td>
				<td colspan="3" class="afValue">
					<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:КемВыдан"/>
				</td>
			</tr>
			<xsl:if test="$pPeriod = '1'">
				<tr>
					<td>Срок действия полномочий</td>
					<td colspan="3" class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ7:ДокументПодтверждающийПолномочия/УТ7:СрокДействия"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
<!-- ДУЛ таблица ДМО -->
	<xsl:template name="УТ7:DocumentTab">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable afTable100">
				<tr>
					<td class="afTable40">Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:choose>
							<xsl:when test="$pDocument/УТ7:Код = 6 "> Свидетельство о рождении</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 9 "> Удостоверение беженца</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 12"> Вид на жительство в Российской Федерации</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 16"> Военный билет</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 18"> Временное удостоверение личности гражданина Российской Федерации</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 26"> Загранпаспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 27"> Паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 28"> Паспорт иностранного гражданина</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 31"> Разрешение на временное проживание</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 32"> Свидетельство о предоставлении временного убежища на территории РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 33"> Свидетельство о рассмотрении ходатайства о признании беженцем на территории РФ по существу</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 36"> Служебный паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 37"> Справка об освобождении из места лишения свободы</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 39"> Удостоверение личности военнослужащего РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 93"> Свидетельство о смерти</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 210"> Дипломатический паспорт гражданина РФ</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 511"> Иной документ, удостоверяющий личность</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 688"> Паспорт гражданина СССР</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 689"> Загранпаспорт гражданина СССР</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 690"> Удостоверение личности офицера</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 691"> Свидетельство о предоставлении временного убежища на территории Российской Федерации (до 01.01.2013)</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 692"> Свидетельство о рождении, выданное уполномоченным органом иностранного государства</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 693"> Военный билет офицера запаса</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 706"> Временное удостоверение, выданное взамен военного билета</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 13"> Вид на жительство иностранного гражданина</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 29"> Паспорт Минморфлота</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 30"> Паспорт моряка</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 34"> Свидетельство о регистрации по месту жительства</xsl:when>
							<xsl:when test="$pDocument/УТ7:Код = 35"> Свидетельство о регистрации по месту пребывания на территории РФ</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ7:Серия, ' ', $pDocument/УТ7:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ7:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ7:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ7:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
					<td>Место рождения</td>
						<td class="afValue">
							<xsl:call-template name="УТ7:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
				</tr>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if>
						</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ7:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template name="АдресРФ">
		<xsl:param name="pAddressRF"/>
		<xsl:param name="pType"/>
		<xsl:choose>
			<xsl:when test="$pAddressRF[УТ7:ТипАдреса = $pType]/УТ7:НеструктурированныйАдрес">
				<xsl:value-of select="$pAddressRF[УТ7:ТипАдреса = $pType]/УТ7:НеструктурированныйАдрес"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="УТ7:AddressStr">
					<xsl:with-param name="pAddress" select="$pAddressRF[УТ7:ТипАдреса =  $pType]/УТ7:Адрес"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- адрес для шапки ФГГС -->
	<xsl:template name="УТ7:АдресФО">
		<xsl:param name="pAddress"/>
		<div class="afRow">
			<div class="afAlignLeft afWrap14">
				ул.&#160;<xsl:value-of select="$pAddress/УТ7:Улица/УТ7:Название"/>,&#160;д.&#160;<xsl:value-of select="$pAddress/УТ7:Дом"/>,
			</div>
		</div>
		<xsl:if test="not($pAddress/УТ7:Регион/УТ7:Название[text() = 'Москва' or text() = 'Санкт-Петербург' or text() = 'Севастополь'])">
			<div class="afRow">
				<div class="afAlignLeft afWrap14">
					<xsl:choose>
						<xsl:when test="$pAddress/УТ7:Город">
							г. &#160;<xsl:value-of select="$pAddress/УТ7:Город/УТ7:Название"/>,&#160;<xsl:value-of select="$pAddress/УТ7:Район/УТ7:Название"/>&#160;<xsl:value-of select="$pAddress/УТ7:Район/УТ7:Сокращение"/>,
						</xsl:when>
						<xsl:when test="$pAddress/УТ7:НаселенныйПункт">
							<xsl:value-of select="$pAddress/УТ7:НаселенныйПункт/УТ7:Сокращение"/>.&#160;<xsl:value-of select="$pAddress/УТ7:НаселенныйПункт/УТ7:Название"/>,&#160;<xsl:value-of select="$pAddress/УТ7:Район/УТ7:Название"/>&#160;р-н
						</xsl:when>
					</xsl:choose>
				</div>
			</div>
		</xsl:if>
		<div class="afRow">
			<div class="afAlignLeft afWrap14">
				<xsl:value-of select="$pAddress/УТ7:Регион/УТ7:Название"/><xsl:if test="not($pAddress/УТ7:Регион/УТ7:Название[text() = 'Москва' or text() = 'Санкт-Петербург' or text() = 'Севастополь'])">&#160;<xsl:value-of select="$pAddress/УТ7:Регион/УТ7:Сокращение"/></xsl:if>,&#160;<xsl:value-of select="$pAddress/УТ7:Индекс"/>
			</div>
		</div>
	</xsl:template>

</xsl:stylesheet>
