<!-- 
    XSLT-преобразование для визуализации в формате HTML электронных документов:
    - Общий протокол проверок (УППО) по формату от 2016-10-01;
    - Уведомление об устранении ошибок и (или) несоответствий между представленными страхователем сведениями и сведениями, имеющимися у СФР, в том числе полученными от налоговых органов  (УУОН-ПУ) по формату от 2018-04-23, 2018-09-18        
-->
<!DOCTYPE html [
   <!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="УППО УПП УТ УТ2 АФ АФ4 ФС2" xmlns:УПП="http://пф.рф/АФ/УПП/типы"
    xmlns:АФ="http://пф.рф/АФ" xmlns:АФ4="http://пф.рф/АФ/2017-08-21" xmlns:УТ="http://пф.рф/унифицированныеТипы/2014-01-01" xmlns:УТ2="http://пф.рф/УТ/2017-08-21"
    xmlns:ФС2="http://пф.рф/ВС/ФС/типы/2018-04-23" xmlns:УППО="http://пф.рф/АФ/УПП/Общий/2016-03-15/2016-03-15">
    <xsl:include href="../../Общие/ШтампЭП.xsl"/>
    <xsl:output method="html" indent="yes" encoding="windows-1251"/>
    <xsl:template match="/">
        <html>
            <head>
                <title>Протокол проверки отчетности</title>
                <style type="text/css">
                   
                    .tableHeader{
                        background-color: #C0C0C0;
                        font-weight: bold;
                    }
                    
                    .tableHeaderCell{
                        background-color: #C0C0C0;
                        font-weight: bold;
                    }
                    
                    .tableHeader td,
                    tableHeaderCell{
                        text-align: center;
                        border: 1px solid black;                        
                    }
                    
                    .tableBorder{
                        border-collapse: collapse;
                        margin-bottom: 10px;
                    }
                    
                    .tableBorder tr td{
                        border: 1px solid black;
                    }
                    
                    .width100{
                        width: 100%;
                    }
                    
                    .bold{
                        font-weight: bold;
                    }
                    
                    .notifyTitle{
                        text-align: center;
                        font-weight: bold;
                    }
                    
                    .borderBottom{
                        border-bottom: 1px solid black;
                    }
                    
                    .width40{
                        width: 40%;
                    }
                    
                    .justify{
                        text-align: justify;
                        text-indent: 1.5em;
                    }
                    
                    .red {
                        color: red;
                    }
                    
                    .green {
                        color: green;
                    }
                    
                    .afWrap, .afWrap table {
                        font-size: 0.9em;
                    }
                    
                    .afErrTable td {
                        padding: 5px;   
                    }
                    
                    .afPlainText,
                    .afHeader,
                    .afValue,
                    .afSubscript,
                    .afInterval,
                    .afP,
                    .afRow,
                    .afRow30,
                    .afCol-1-2,
                    .afCol-1-3,
                    .afCol-1-4,
                    .afCol-3-4,
                    .afUnderlinedBlock,
                    .afBlankUnderlinedBlock,
                    .afParagraph,
                    .afFootnote,
                    .afSignature{
                        font-family: "Times New Roman";
                        padding: 0px;
                        margin: 3px;
                    }
                    .afHeader{
                        font-size: 1.1666666em;
                        font-weight: bold;
                        text-align: center;
                    }
                    .afSubscript{
                        font-style: italic;
                        font-size: 0.8333333em;
                        padding: 0;
                        margin: 0;
                        line-height: 1em;
                    }
                    .afValue{
                        font-weight: bold;
                    }
                    .afP{
                        clear: both;
                    }
                    .afInterval{
                        padding: 5px;
                        clear: both;
                        margin: 0;
                    }
                    .afRow{
                        width: 100%;
                        float: left;
                    }
                    .afRow30{
                        float: left;
                        margin-left: 30px;
                        width: 100%;
                    }
                    .afCol-1-2{
                        float: left;
                        width: 50%;
                        margin: 0;
                    }
                    .afCol-1-3{
                        float: left;
                        width: 33.3333333333%;
                        margin: 0;
                    }
                    .afCol-1-4{
                        float: left;
                        width: 25%;
                        margin: 0;
                    }
                    .afCol-3-4{
                        float: left;
                        width: 75%;
                        margin: 0;
                    }
                    .afUnderlinedBlock,
                    .afBlankUnderlinedBlock{
                        border-bottom: 1px black solid;
                        width: auto;
                        text-align: center;
                        overflow: hidden;
                        vertical-align: bottom;
                    }
                    
                    .afBlankUnderlinedBlock{
                        height: 16px;
                    }
                    .afParagraph{
                        text-align: justify;
                        text-indent: 30px;
                        clear: both;
                    }
                    .afFootnote{
                        font-size: 0.8333333em;
                        text-indent: 30px;
                    }
                    .afSignature{	
                    font-size: 0.8em;
                    line-height: 1em;
                    float: right;
                    width: 290px;
                    border: solid 1px #1D6FB6;
                    color: #1D6FB6;
                    font-weight: bold;
                    padding: 0 0 5px 5px;
                    }
                    .afSignature p{
                    width: 100%;
                    text-align: center;	
                    font-size: 1em;
                    padding: 0;
                    }
                    div#break{
                    page-break-before: always;
                    }
                    .afNoBreakBefore{
                    page-break-before: avoid;
                    }
                    .afRight-1-3{
                    float: right;
                    margin: 0;
                    width: 33.3333333333%;
                    }
                </style>
            </head>
            <body>
                <div class="afWrap">                    
                    <xsl:apply-templates select="/*[local-name() = 'ЭДПФР' and namespace-uri() != 'http://пф.рф/АФ/УПП/Общий/2016-03-15/2016-03-15']"/>
                <a name="top"/>

                <xsl:variable name="warning" select="count(descendant::УПП:Проверка[УПП:КодРезультата = '10'] | descendant::УПП:Проверка[УПП:КодРезультата = '20'])"/>
                <xsl:variable name="error" select="count(descendant::УПП:Проверка[УПП:КодРезультата = '30'] | descendant::УПП:Проверка[УПП:КодРезультата = '40'])"/>
                <xsl:variable name="criticalError" select="count(descendant::УПП:Проверка[УПП:КодРезультата = '50'])"/>

                <xsl:variable name="not_szvm_is"
                    select="not(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М' or @КодФормы = 'ОДВ-1' or @КодФормы = 'СЗВ-ИСХ' or @КодФормы = 'СЗВ-КОРР' or @КодФормы = 'СЗВ-СТАЖ'])"/>
                <xsl:variable name="is_szvm" select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М']"/>
                <xsl:variable name="is_szvstg" select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-СТАЖ']"/>
                <xsl:variable name="is_szvish" select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-ИСХ']"/>
                <xsl:variable name="is_szvcorr" select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-КОРР']"/>
                <xsl:variable name="is_odv1" select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'ОДВ-1']"/>
                <xsl:variable name="not_adv" select="not(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'АДВ-1' or @КодФормы = 'АДВ-2' or @КодФормы = 'АДВ-3'])"/>
                <xsl:variable name="not_dsv" select="not(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'ДСВ-1' or @КодФормы = 'ДСВ-3'])"/>


                <div id="break" />
                <h1 class="afHeader afP">Протокол проверки отчетности</h1>
                <div>Дата и время формирования УПП:&nbsp;<xsl:value-of select="translate(child::*[local-name(.) = 'ЭДПФР']/descendant::АФ:ДатаВремя, 'T', ' ')"/></div>
                <div>ID#&nbsp;<xsl:value-of select="child::*[local-name(.) = 'ЭДПФР']/descendant::АФ:GUID"/></div>
                <div>Проверочный модуль: <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                        <xsl:if test="position() > 1">,&nbsp;</xsl:if>&quot;<xsl:value-of select="@Наименование"/>&quot;</xsl:for-each>
                </div>
                
                <xsl:apply-templates select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:Контрагент"/>
                
                <div style="padding-top: 5px"> Проверяемые документы: <table class="tableBorder">
                        <tr class="bold">
                            <td>Код формы</td>
                            <td><xsl:value-of select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент/@КодФормы"/></td>
                        </tr>
                        <xsl:if test="($is_szvstg or $is_szvcorr or $is_szvm or $is_odv1) and //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки">
                            <tr class="bold">
                                <td>Тип Сведений</td>
                                <xsl:choose>
                                    <xsl:when test="$is_szvstg">
                                        <xsl:choose>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 0"><td>ИСХОДНАЯ</td></xsl:when>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 1"><td>ДОПОЛНЯЮЩАЯ</td></xsl:when>
                                            <xsl:otherwise><td>НАЗНАЧЕНИЕ ПЕНСИИ</td></xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="$is_szvcorr">
                                        <xsl:choose>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 0"><td>КОРРЕКТИРУЮЩАЯ</td></xsl:when>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 1"><td>ОТМЕНЯЮЩАЯ</td></xsl:when>
                                            <xsl:otherwise><td>ОСОБАЯ</td></xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="$is_szvm">
                                        <xsl:choose>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 1"><td>ИСХОДНАЯ</td></xsl:when>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 2"><td>ДОПОЛНЯЮЩАЯ</td></xsl:when>
                                            <xsl:otherwise><td>ОТМЕНЯЮЩАЯ</td></xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:НомерКорректировки = 1"><td>КОРРЕКТИРУЮЩАЯ</td></xsl:when>
                                            <xsl:otherwise><td>ОТМЕНЯЮЩАЯ</td></xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>
                        <xsl:if test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:КоличествоЗЛ">
                            <tr class="bold">
                                <td>Количество застрахованных лиц</td>
                                <td><xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:КоличествоЗЛ"/></td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод">
                            <tr class="bold">
                                <td>Отчетный период</td>
                                <td>
                                    <xsl:choose>
                                        <xsl:when
                                            test="not(//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод) and not(//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц)"><xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> год </xsl:when>
                                        <xsl:when
                                            test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = 3 or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '03' or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '3'"
                                            > I квартал <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when
                                            test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = 6 or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '06' or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '6'"
                                            > полугодие <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when
                                            test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = 9 or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '09' or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '9'"
                                            > 9 месяцев <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = 0 or //УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйПериод = '12'"> 
                                                <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> год </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 1"> январь <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 2"> февраль <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 3"> март <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"
                                            /> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 4"> апрель <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 5"> май <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/>
                                            года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 6"> июнь <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"
                                            /> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 7"> июль <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"
                                            /> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 8"> август <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 9"> сентябрь <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 10"> октябрь <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйМесяц = 11"> ноябрь <xsl:value-of
                                                select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:when>
                                        <xsl:otherwise> декабрь <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:ОтчетныйГод"/> года </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                            </tr>
                        </xsl:if>
                        <tr class="bold">
                            <td>Наименование файла</td>
                            <td>
                                <xsl:value-of select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент/УПП:Файл/@ИмяФайла"/>
                            </td>
                        </tr>
                    </table>
                </div>

                <h1 class="afHeader afP" style="text-align: left;">Результат проверки:</h1>
                <table class="tableBorder width100">
                    <tr class="tableHeader">
                        <td>Предупреждений</td>
                        <td>Ошибок</td>
                        <td>Грубых ошибок</td>
                    </tr>
                    <tr style="text-align: center;">
                        <td>
                            <xsl:value-of select="$warning"/>
                        </td>
                        <td>
                            <xsl:value-of select="$error"/>
                        </td>
                        <td>
                            <xsl:value-of select="$criticalError"/>
                        </td>
                    </tr>
                </table>

                <xsl:if test="(not(//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки)) or (//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки = '')">
                    <xsl:choose>
                        <xsl:when test="$is_szvm or $is_szvstg">
                            <xsl:choose>
                                <xsl:when test="$criticalError">
                                    <h1 class="afHeader afP red">Документ не принят!</h1>
                                    <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                        <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                        <xsl:call-template name="printValidateModule"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="$error">
                                    <h1 class="afHeader afP red">Документ принят частично!</h1>
                                    <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                        <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                        <xsl:call-template name="printValidateModule"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:otherwise>
                                    <h1 class="afHeader afP green">Документ принят!</h1>
                                    <xsl:if
                                        test="
                                            count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                                            /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                                        <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                            <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                            <xsl:call-template name="printValidateModule"/>
                                        </xsl:for-each>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="$criticalError or $error">
                                    <h1 class="afHeader afP red">Документ не принят!</h1>
                                    <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                        <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                        <xsl:call-template name="printValidateModule"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:otherwise>
                                    <h1 class="afHeader afP green">Документ принят!</h1>
                                    <xsl:if
                                        test="
                                            count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                                            /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                                        <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                            <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                            <xsl:call-template name="printValidateModule"/>
                                        </xsl:for-each>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>

                <xsl:if test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки != ''">
                    <xsl:choose>
                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки = 'Документ не принят'">
                            <h1 class="afHeader afP red">Документ не принят!</h1>
                            <xsl:for-each select="//УППО:ЭДПФР/УППО:УПП/УПП:ПроверочныйМодуль">
                                <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                <xsl:call-template name="printValidateModule"/>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки = 'Документ принят частично'">
                            <h1 class="afHeader afP red">Документ принят частично!</h1>
                            <xsl:for-each select="//УППО:ЭДПФР/УППО:УПП/УПП:ПроверочныйМодуль">
                                <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                <xsl:call-template name="printValidateModule"/>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:when test="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки = 'Документ принят'">
                            <h1 class="afHeader afP green">Документ принят!</h1>
                            <xsl:if
                                test="
                                    count(//УППО:ЭДПФР/УППО:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                                    //УППО:ЭДПФР/УППО:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                                <xsl:for-each select="//УППО:ЭДПФР/УППО:УПП/УПП:ПроверочныйМодуль">
                                    <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                    <xsl:call-template name="printValidateModule"/>
                                </xsl:for-each>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                            <h1 class="afHeader afP green">
                                <xsl:value-of select="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:РезультатПроверки"/>
                            </h1>
                            <xsl:for-each select="//УППО:ЭДПФР/УППО:УПП/УПП:ПроверочныйМодуль">
                                <h1 class="afHeader afP" style="text-align: left;">Перечень выявленных предупреждений и ошибок</h1>
                                <xsl:call-template name="printValidateModule"/>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>

                <xsl:if
                    test="
                        count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50'] | /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40'] | /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] |
                        /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                        /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                    <h1 class="afHeader afP" style="text-align: left;">Описание кодов результата проверки:</h1>
                    <table class="tableBorder width100">
                        <tr class="tableHeader">
                            <td style="width: 15%">Код результата</td>
                            <td style="width: 15%">Значение</td>
                            <td>Требуемое действие</td>
                        </tr>

                        <xsl:if
                            test="count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                            <tr>
                                <td>10</td>
                                <xsl:choose>
                                    <xsl:when test="$not_szvm_is and $not_adv and $not_dsv">
                                        <td style="width: 10%">Предупреждение. Документ принят.</td>
                                        <td/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td style="width: 10%">Предупреждение. Сведения приняты.</td>
                                        <td>Ситуация возможная, но требующая разъяснений (проверки)</td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']) &gt; 0">
                            <tr>
                                <td>20</td>
                                <xsl:choose>
                                    <xsl:when test="$not_szvm_is and $not_adv and $not_dsv">
                                        <td style="width: 10%">Предупреждение. Документ принят.</td>
                                        <td/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td style="width: 10%">Предупреждение. Сведения приняты.</td>
                                        <td>Ситуация возможная, но требующая разъяснений (проверки)</td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30']) &gt; 0">
                            <tr>
                                <td>30</td>
                                <xsl:choose>
                                    <xsl:when test="$not_szvm_is and $not_adv and $not_dsv">
                                        <td style="width: 10%">Грубая ошибка. Документ не принят.</td>
                                        <td>Требуется повторное предоставление документа. Страхователю необходимо устранить ошибки и повторно представить документ.</td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="$is_szvm | $is_szvstg">
                                                <td style="width: 10%">Ошибка. Сведения приняты не в полном объеме (не по всем застрахованным лицам).</td>
                                                <td>Сведения по застрахованным лицам, указанным в протоколе ошибок, не приняты и не подлежат учету на индивидуальных лицевых счетах. Необходимо
                                                    представить корректные сведения по указанным застрахованным лицам в срок, установленный ст. 17 №27-ФЗ от 01.04.1996г.</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td style="width: 10%">Ошибка. Сведения не приняты.</td>
                                                <td>Необходимо устранить перечисленные ошибки и представить корректные сведения в срок, установленный ст.17 №27-ФЗ от 01.04.1996г.</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']) &gt; 0">
                            <tr>
                                <td>40</td>
                                <xsl:choose>
                                    <xsl:when test="$not_szvm_is and $not_adv and $not_dsv">
                                        <td style="width: 10%">Грубая ошибка. Документ не принят.</td>
                                        <td>Требуется повторное предоставление документа. Страхователю необходимо устранить ошибки и повторно представить документ.</td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="$is_szvm | $is_szvstg">
                                                <td style="width: 10%">Ошибка. Сведения приняты не в полном объеме (не по всем застрахованным лицам).</td>
                                                <td>Сведения по застрахованным лицам, указанным в протоколе ошибок, не приняты и не подлежат учету на индивидуальных лицевых счетах. Необходимо
                                                    представить корректные сведения по указанным застрахованным лицам в срок, установленный ст. 17 №27-ФЗ от 01.04.1996г.</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td style="width: 10%">Ошибка. Сведения не приняты.</td>
                                                <td>Необходимо устранить перечисленные ошибки и представить корректные сведения в срок, установленный ст.17 №27-ФЗ от 01.04.1996г.</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']) &gt; 0">
                            <tr>
                                <td>50</td>
                                <xsl:choose>
                                    <xsl:when test="$not_szvm_is and $not_adv and $not_dsv">
                                        <td style="width: 10%">Грубая ошибка. Документ не принят.</td>
                                        <td>Требуется повторное предоставление документа. Страхователю необходимо устранить ошибки и повторно представить документ.</td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td style="width: 10%">Грубая ошибка. Сведения не приняты.</td>
                                        <td>Необходимо устранить перечисленные ошибки и представить корректные сведения в срок, установленный ст.17 №27-ФЗ от 01.04.1996г.</td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>
                    </table>
                </xsl:if>
                    <div class="afNoBreakBefore"><xsl:call-template name="PrintSignature"/></div>
                </div>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="//УППО:ЭДПФР/УППО:СлужебнаяИнформация/УППО:Контрагент">
        <div style="padding-top: 5px"> Информация о страхователе: 
            <table class="tableBorder">
                <tr class="bold">
                    <td>Регистрационный номер в СФР</td>
                    <td>
                        <xsl:value-of select="./УТ:РегистрационныйНомер"/>
                    </td>
                </tr>
                <tr class="bold">
                    <td>ИНН</td>
                    <td>
                        <xsl:if test="./УТ:НалоговыйНомер">
                            <xsl:value-of select="./УТ:НалоговыйНомер/УТ:ИНН"/>
                        </xsl:if>
                    </td>
                </tr>
                <tr class="bold">
                    <td>КПП</td>
                    <td>
                        <xsl:if test="./УТ:НалоговыйНомер">
                            <xsl:value-of select="./УТ:НалоговыйНомер/УТ:КПП"/>
                        </xsl:if>
                    </td>
                </tr>
                <tr class="bold">
                    <td>Наименование организации</td>
                    <td>
                        <xsl:if test="./УТ:НаименованиеКраткое != ''"> "<xsl:value-of select="./УТ:НаименованиеКраткое"/>" </xsl:if>
                    </td>
                </tr>
            </table>
        </div>
    </xsl:template>

    <xsl:template name="printValidateModule">
        <xsl:for-each select="УПП:ПроверкаФайлов/УПП:Файл">
            <xsl:variable name="is_szvmstg" select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М' or @КодФормы = 'СЗВ-СТАЖ']"/>

            <xsl:variable name="hardErr" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']"/>
            <xsl:if test="count($hardErr) &gt; 0">
                <h3>Грубые ошибки</h3>
                <table class="tableBorder width100 afErrTable">
                    <xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '50']//УПП:ОжидаемоеЗначение)&gt;0"/>
                    <xsl:call-template name="printTableHeader">
                        <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                    </xsl:call-template>                    
                    <xsl:for-each select="$hardErr">
                        <xsl:call-template name="printCheckBlock">
                            <xsl:with-param name="numPP" select="position()"/>
                            <xsl:with-param name="codeFrom" select="'50'"/>
                            <xsl:with-param name="codeTo" select="'50'"/>
                            <xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
                            <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </table>
            </xsl:if>
            
            <xsl:variable name="err" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']"/>
            <xsl:if
                test="count($err) &gt; 0">
                <h3>Ошибки</h3>
                <table class="tableBorder width100 afErrTable">
                    <xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '30']//УПП:ОжидаемоеЗначение | УПП:Результат//УПП:Проверка[УПП:КодРезультата = '40']//УПП:ОжидаемоеЗначение )&gt;0"/>
                    <xsl:call-template name="printTableHeader">
                        <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                    </xsl:call-template> 
                    <xsl:for-each
                        select="$err">
                        <xsl:choose>
                            <xsl:when test="$is_szvmstg">
                                <xsl:call-template name="printCheckBlock">
                                    <xsl:with-param name="numPP" select="position()"/>
                                    <xsl:with-param name="codeFrom" select="'30'"/>
                                    <xsl:with-param name="codeTo" select="'40'"/>
                                    <xsl:with-param name="recultCodeCss" select="string('background-color: yellow')"/>
                                    <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="printCheckBlock">
                                    <xsl:with-param name="numPP" select="position()"/>
                                    <xsl:with-param name="codeFrom" select="'30'"/>
                                    <xsl:with-param name="codeTo" select="'40'"/>
                                    <xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
                                    <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </table>
            </xsl:if>

            <xsl:variable name="lightErr" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']"/>
            <xsl:if
                test="count($lightErr) &gt; 0">
                <h3>Предупреждения</h3>
                <table class="tableBorder width100 afErrTable">
                    <xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '10']//УПП:ОжидаемоеЗначение | УПП:Результат//УПП:Проверка[УПП:КодРезультата = '20']//УПП:ОжидаемоеЗначение) &gt; 0"/>
                    <xsl:call-template name="printTableHeader">
                        <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                    </xsl:call-template> 
                    <xsl:for-each
                        select="$lightErr">
                        <xsl:call-template name="printCheckBlock">
                            <xsl:with-param name="numPP" select="position()"/>
                            <xsl:with-param name="codeFrom" select="'10'"/>
                            <xsl:with-param name="codeTo" select="'20'"/>
                            <xsl:with-param name="recultCodeCss" select="string('')"/>
                            <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </table>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="printTableHeader">
        <xsl:param name="hasExpectedValue"/>
        <tr class="tableHeader">
            <td style="max-width: 25px">№ п/п</td>                        
            <td style="width: 10%">Код проверки</td>
            <td style="width: 5%">Код результата</td>
            <td style="width:25%">Описание проверки</td>
            <td>Место ошибки</td>
            <xsl:if test="$hasExpectedValue">
                <td>Ожидаемое значение</td>
            </xsl:if>
        </tr>
    </xsl:template>

    <xsl:template name="printCheckBlock">
        <xsl:param name="numPP"/>
        <xsl:param name="codeFrom"/>
        <xsl:param name="codeTo"/>
        <xsl:param name="recultCodeCss"/>
        <xsl:param name="hasExpectedValue"/>        
        <xsl:for-each select="УПП:БлокПроверок">           
            <xsl:call-template name="printCheckBlock">
                <xsl:with-param name="numPP" select="position()"/>
                <xsl:with-param name="recultCodeCss" select="$recultCodeCss"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:variable name="cntError" select="count(child::*[./УПП:КодРезультата = $codeFrom] | child::*[./УПП:КодРезультата = $codeTo])"/>
        <xsl:variable name="colSpan" select="5+number($hasExpectedValue)"/>
        
        <xsl:if test="$cntError &gt; 0">
            <tr>
                <td colspan="{$colSpan}"><xsl:value-of select="concat($numPP,'. ',@Название)"/></td>
            </tr>
            <xsl:for-each select="УПП:Проверка[./УПП:КодРезультата = $codeFrom] | УПП:Проверка[./УПП:КодРезультата = $codeTo]">
                <xsl:variable name="cntErrorObj" select="count(.//УПП:Ошибка)"/>
                <xsl:variable name="position" select="position()"/>
				<!--если в протоколе нет сведений об ошибках для этой проверки, но правило сработало
				например, для АФ.СХ.1.1 текст ошибки выводится в элемент ОписаниеПроверки, а элементы Ошибка отсутствуют 
				-->
				<xsl:if test="$cntErrorObj=0">
					 <tr>                        
	                    <td rowspan="{$cntErrorObj}" style="vertical-align: top">
	                        <xsl:value-of select="concat($numPP,'.',$position)"/>
	                    </td>                                            
	                    <td rowspan="{$cntErrorObj}" style="vertical-align: top">
	                        <xsl:value-of select="@ID"/>
	                    </td>
	                    <td rowspan="{$cntErrorObj}" align="center" style="vertical-align: top; {$recultCodeCss}">
	                        <xsl:value-of select="УПП:КодРезультата"/>
	                    </td>
	                    <td rowspan="{$cntErrorObj}" style="vertical-align: top">
	                        <xsl:value-of select="УПП:ОписаниеПроверки"/>
	                    </td>                        
					     <td/>
                    </tr>
				</xsl:if>                
                <xsl:for-each select="УПП:Ошибки/УПП:Ошибка">
                    <tr>
                        <xsl:if test="position()=1">
                            <td rowspan="{$cntErrorObj}" style="vertical-align: top">
                                <xsl:value-of select="concat($numPP,'.',$position)"/>
                            </td>                                            
                            <td rowspan="{$cntErrorObj}" style="vertical-align: top">
                                <xsl:value-of select="../../@ID"/>
                            </td>
                            <td rowspan="{$cntErrorObj}" align="center" style="vertical-align: top; {$recultCodeCss}">
                                <xsl:value-of select="../../УПП:КодРезультата"/>
                            </td>
                            <td rowspan="{$cntErrorObj}" style="vertical-align: top">
                                <xsl:value-of select="../../УПП:ОписаниеПроверки"/>
                            </td>  
                        </xsl:if>
                        <td>                               
                            <xsl:if test="УПП:Объект and (УПП:Объект/УПП:Наименование/text() or УПП:Объект/УПП:Значение/text())">                                
                                <xsl:if test="УПП:Объект/УПП:Наименование">
                                    <xsl:value-of select="concat(УПП:Объект/УПП:Наименование, '=')"/>
                                </xsl:if>
                                <span class="afValue"><xsl:value-of select="УПП:Объект/УПП:Значение"/></span>
                                <br/>
                            </xsl:if>
                            <xsl:value-of select="concat('Путь до элемента: ', УПП:ПутьДоЭлемента)"/>                                                        
                        </td>
                        <xsl:if test="$hasExpectedValue">
                            <td>
                                <xsl:choose>
                                    <xsl:when test="УПП:ОжидаемоеЗначение">                                    
                                            <xsl:value-of select="УПП:ОжидаемоеЗначение"/>                                    
                                    </xsl:when>                                
                                </xsl:choose>
                            </td>
                        </xsl:if>
                    </tr>
                </xsl:for-each>                
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template match="/*[local-name() = 'ЭДПФР' and namespace-uri() != 'http://пф.рф/АФ/УПП/Общий/2016-03-15/2016-03-15']">        
        <div style="width: 100%">
            <div class="afRow">
                <div class="afCol-1-3">
                    <p class="afP">
                        <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ТерриториальныйОрганПФР']/ФС2:Наименование"/>
                    </p>
                    <p class="afP">
                        <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ТерриториальныйОрганПФР']/ФС2:Адрес"/>
                    </p>
                    <p class="afP">Тел. <xsl:for-each select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ТерриториальныйОрганПФР']/ФС2:Телефоны/УТ2:Телефон">
                            <xsl:if test="position() &gt; 1">, </xsl:if>
                            <xsl:value-of select="."/>
                        </xsl:for-each>
                    </p>
                </div>
                <div class="afRight-1-3">
                    <p class="afSubscript">Приложение № 5</p>
                    <p class="afSubscript"><br/></p>
                    <p class="afSubscript">к приказу Фонда пенсионного и</p>
                    <p class="afSubscript">социального страхования</p>
                    <p class="afSubscript">Российской Федерации</p>
                    <p class="afSubscript"><br/></p>
                    <p class="afSubscript">от 2 марта 2023 г</p>
                    <p class="afSubscript"><br/></p>
                    <p class="afSubscript">№ 302</p>
                </div>
            </div>
            <p class="afInterval"/>
            <h1 class="afHeader afP">Уведомление</h1>
            <h1 class="afHeader afP">об устранении ошибок и (или) несоответствий между представленными</h1>
            <h1 class="afHeader afP">страхователем сведениями и сведениями, имеющимися у Фонда пенсионного</h1>
            <h1 class="afHeader afP">и социального страхованияРоссийской Федерации, в том числе</h1>
            <h1 class="afHeader afP">полученными от налоговых органов</h1>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afCol-1-4">Страхователю</div>
                <div class="afCol-1-2 afValue afUnderlinedBlock" style="width: 50%">
                    <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/ФС2:Наименование"/>
                    <xsl:call-template name="УТ2:NameStr">
                        <xsl:with-param name="pName" select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/УТ2:ФИО"/>
                    </xsl:call-template>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-1-4">регистрационный номер в СФР</div>
                <div class="afCol-1-2 afValue afUnderlinedBlock" style="width: 50%">
                    <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/УТ2:РегНомер"/>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-1-4">ИНН</div>
                <div class="afCol-1-2 afValue afUnderlinedBlock" style="width: 50%">
                    <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/УТ2:ИНН"/>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-1-4">КПП</div>
                <div class="afCol-1-2 afValue afUnderlinedBlock" style="width: 50%">
                    <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/УТ2:КПП"/>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-1-4">адрес в пределах места нахождения юридического лица (обособленного подразделения)/ <br/>
                    адрес регистрации индивидуального предпринимателя, физического лица
                </div>
                <div class="afCol-1-2 afValue afUnderlinedBlock" style="width: 50%">
                    <p>
                        <xsl:choose>
                            <xsl:when test="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/ФС2:Адрес/УТ2:Иностранный">
                                <xsl:call-template name="УТ2:AddressForeignStr">
                                    <xsl:with-param name="pAddress" select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/ФС2:Адрес"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/ФС2:Адрес/УТ2:Неструктурированный">
                                <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/ФС2:Адрес/УТ2:Неструктурированный"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="УТ2:AddressStr">
                                    <xsl:with-param name="pAddress" select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Страхователь']/ФС2:Адрес"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </p>
                </div>
            </div>
            <p class="afInterval"/>
            <p class="afParagraph afP">В представленных сведениях выявлены ошибки и (или) несоответствия между представленными сведениями и сведениями, имеющимися у Фонда пенсионного и социального страхования Российской Федерации, в том числе полученными от налоговых органов.</p>
            <p class="afParagraph afP">Протокол проверки прилагается.</p>
            <p class="afParagraph afP">В случае представления страхователем уточненных (исправленных) сведений, в отношении которых территориальным органом Фонда страхователю вручено уведомление об устранении имеющихся ошибок и несоответствий, в течение пяти рабочих дней со дня получения данного уведомления<sup>1</sup> к такому страхователю финансовые санкции не применяются<sup>2</sup>.</p>
            <p class="afInterval"/>
            <div class="afRow30">
                <div class="afCol-1-4">Уведомление получил<sup>3</sup></div>
                <div class="afCol-1-2 afValue afBlankUnderlinedBlock" style="width: 50%"/>
            </div>
            <div class="afRow30">
                <xsl:choose>
                    <xsl:when
                        test="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ДатаПолучения'] or /*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Руководитель'] or /*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Представитель'] or /*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ДокументПодтверждающийПолномочия']">
                        <div class="afCol-3-4 afValue afUnderlinedBlock" style="width: 75%">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ДатаПолучения']"/>
                                </xsl:with-param>
                            </xsl:call-template>,&#160; <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Руководитель']"/>,&#160; <xsl:value-of
                                select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'Представитель']"/>,&#160; <xsl:call-template name="DocStr">
                                    <xsl:with-param name="pDoc" select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ДокументПодтверждающийПолномочия']"/>
                            </xsl:call-template>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <div class="afCol-3-4 afBlankUnderlinedBlock" style="width: 75%"/>
                    </xsl:otherwise>
                </xsl:choose>
                <p class="afP">
                    <div class="afCol-3-4 afSubscript" style="width: 75%; text-align: center"> (дата, подпись, Ф.И.О. лица, получившего документ, для представителя указывается основание
                        представительства (наименование и иные реквизиты документа, подтверждающего полномочия) </div>
                </p>
            </div>
            <p class="afInterval"/>
            <p class="afP">Дата формирования уведомления: <span class="afValue">
                    <xsl:call-template name="DateShortStr">
                        <xsl:with-param name="pDate">
                            <xsl:value-of select="/*[local-name() = 'ЭДПФР']/*[local-name() = 'УУОН-ПУ']/*[local-name() = 'ДатаФормирования']"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </span></p>
            <p class="afInterval"/>
            <p>___________________________________________</p>
            <p class="afP afFootnote"><sup>1</sup> В  случае направления уведомления по почте заказным письмом датой вручения этого уведомления считается шестой день считая с даты отправления заказного письма.</p>
            <p class="afP afFootnote"><sup>2</sup> Часть 25 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (Собрание законодательства Российской Федерации, 1996, 
                № 14, ст. 1401; 2016, № 27, ст. 4183).</p>
            <p class="afP afFootnote"><sup>3</sup>Заполняется в случае вручения документа на бумажном носителе лично.</p>
        </div>
    </xsl:template>

    <xsl:template name="УТ2:AddressStr">
        <xsl:param name="pAddress"/>
        <xsl:if test="$pAddress/УТ2:Индекс">
            <xsl:value-of select="$pAddress/УТ2:Индекс"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Регион">
            <xsl:choose>
                <xsl:when test="$pAddress/УТ2:Регион/УТ2:Сокращение">
                    <xsl:value-of select="concat($pAddress/УТ2:Регион/УТ2:Сокращение, '. ', $pAddress/УТ2:Регион/УТ2:Название)"/>, </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$pAddress/УТ2:Регион/УТ2:Название"/>, </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="$pAddress/УТ2:Округ">
            <xsl:value-of select="$pAddress/УТ2:Округ"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Район">
            <xsl:choose>
                <xsl:when test="$pAddress/УТ2:Район/УТ2:Сокращение">
                    <xsl:value-of select="concat($pAddress/УТ2:Район/УТ2:Название, ' ', $pAddress/УТ2:Район/УТ2:Сокращение)"/>, </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($pAddress/УТ2:Район/УТ2:Название, ' р-н')"/>, </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="$pAddress/УТ2:Город">
            <xsl:choose>
                <xsl:when test="$pAddress/УТ2:Город/УТ2:Сокращение">
                    <xsl:value-of select="concat($pAddress/УТ2:Город/УТ2:Сокращение, '. ', $pAddress/УТ2:Город/УТ2:Название)"/>, </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('г. ', $pAddress/УТ2:Город/УТ2:Название)"/>, </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="$pAddress/УТ2:ВнутригородскойРайон">
            <xsl:value-of select="$pAddress/УТ2:ВнутригородскойРайон"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:НаселенныйПункт">
            <xsl:value-of select="$pAddress/УТ2:НаселенныйПункт"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Улица">
            <xsl:choose>
                <xsl:when test="$pAddress/УТ2:Улица/УТ2:Сокращение">
                    <xsl:value-of select="concat($pAddress/УТ2:Улица/УТ2:Сокращение, '. ', $pAddress/УТ2:Улица/УТ2:Название)"/>, </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$pAddress/УТ2:Улица/УТ2:Название"/>, </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="$pAddress/УТ2:Дом">
            <xsl:value-of select="concat(' д. ', $pAddress/УТ2:Дом)"/>
        </xsl:if>
        <xsl:if test="$pAddress/УТ2:Строение or $pAddress/УТ2:Владение or $pAddress/УТ2:Корпус or $pAddress/УТ2:Квартира">, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Строение">
            <xsl:value-of select="concat(' стр. ', $pAddress/УТ2:Строение)"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Владение">
            <xsl:value-of select="$pAddress/УТ2:Владение"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Корпус">
            <xsl:value-of select="concat(' корпус ', $pAddress/УТ2:Корпус)"/>, </xsl:if>
        <xsl:if test="$pAddress/УТ2:Квартира">
            <xsl:value-of select="concat(' кв. ', $pAddress/УТ2:Квартира)"/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="УТ2:AddressForeignStr">
        <xsl:param name="pAddress"/>
        <xsl:if test="$pAddress/УТ2:Иностранный">
            <xsl:if test="$pAddress/УТ2:Иностранный/УТ2:КодСтраны">
                <xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:КодСтраны"/>, </xsl:if>
            <xsl:if test="$pAddress/УТ2:Иностранный/УТ2:НазваниеСтраны">
                <xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:НазваниеСтраны"/>, </xsl:if>
            <xsl:if test="$pAddress/УТ2:Иностранный/УТ2:АдресКириллицей">
                <xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:АдресКириллицей"/>, </xsl:if>
            <xsl:if test="$pAddress/УТ2:Иностранный/УТ2:АдресЛатиницей">
                <xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:АдресЛатиницей"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="DateShortStr">
        <xsl:param name="pDate"/>
        <xsl:choose>
            <xsl:when test="$pDate = ''"/>
            <xsl:otherwise>
                <xsl:variable name="dateText" select="string($pDate)"/>
                <xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="DocStr">
        <xsl:param name="pDoc"/>
        <xsl:if test="$pDoc">
            <xsl:value-of select="$pDoc/УТ2:Наименование"/> ,&#160; <xsl:if test="$pDoc/УТ2:Серия">
                <xsl:value-of select="$pDoc/УТ2:Серия"/>&#160; </xsl:if>№&#160; <xsl:value-of select="$pDoc/УТ2:Номер"/>,&#160;выдан&#160; <xsl:value-of select="$pDoc/УТ2:КемВыдан"/>&#160;
                <xsl:call-template name="DateShortStr">
                <xsl:with-param name="pDate">
                    <xsl:value-of select="$pDoc/УТ2:ДатаВыдачи"/>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:if test="$pDoc/УТ2:СрокДействия">&#160;по <xsl:value-of select="$pDoc/УТ2:СрокДействия"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <!-- ФИО -->
    <xsl:template name="УТ2:NameStr">
        <xsl:param name="pName"/>
        <xsl:if test="$pName">
            <xsl:if test="$pName/УТ2:Фамилия">
                <xsl:value-of select="$pName/УТ2:Фамилия"/>&#160;</xsl:if>
            <xsl:if test="$pName/УТ2:Имя">
                <xsl:value-of select="$pName/УТ2:Имя"/>&#160;</xsl:if>
            <xsl:if test="$pName/УТ2:Отчество">
                <xsl:value-of select="$pName/УТ2:Отчество"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>