<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="ns1 УТ УПП АФ xs" xmlns:УПП="http://пф.рф/АФ/УПП/типы"
    xmlns:АФ="http://пф.рф/АФ" xmlns:ns1="http://пф.рф/АФ/УПП/Общий/2016-03-15/2016-03-15" xmlns:УТ="http://пф.рф/унифицированныеТипы/2014-01-01">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>

    <xsl:template match="/" name="inc">
        <div class="afWrap">
        <a name="top"/>

        <xsl:variable name="warning" select="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']
            | /ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат//УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'])"/>
        <xsl:variable name="error" select="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30']
            | /ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40'])"/>
        <xsl:variable name="criticalError" select="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50'])"/>

        <xsl:variable name="not_szvm_is"
            select="not(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М' or @КодФормы = 'ОДВ-1' or @КодФормы = 'СЗВ-ИСХ' or @КодФормы = 'СЗВ-КОРР' or @КодФормы = 'СЗВ-СТАЖ'])"/>
        <xsl:variable name="is_szvm" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М']"/>
        <xsl:variable name="is_szvtd" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-ТД']"/>
        <xsl:variable name="is_szvstg" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-СТАЖ']"/>
        <xsl:variable name="isFirstGroup" select="$is_szvm or $is_szvtd or $is_szvstg"/>

        <xsl:variable name="is_szvish" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-ИСХ']"/>
        <xsl:variable name="is_szvcorr" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-КОРР']"/>
        <xsl:variable name="is_odv1" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'ОДВ-1']"/>
        <xsl:variable name="is_adv" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'АДВ-1' or @КодФормы = 'АДВ-2' or @КодФормы = 'АДВ-3']"/>
        <xsl:variable name="isSecondGroup" select="$is_szvish or $is_szvcorr or $is_odv1 or $is_adv"/>

        <xsl:variable name="not_adv" select="not(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'АДВ-1' or @КодФормы = 'АДВ-2' or @КодФормы = 'АДВ-3'])"/>
        <xsl:variable name="not_dsv" select="not(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'ДСВ-1' or @КодФормы = 'ДСВ-3'])"/>

        <h1 class="afHeader afP">Протокол проверки отчетности</h1>
        <div>Дата и время формирования УПП:&#160;<xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ:ДатаВремя"/></div>
        <div>ID#&#160;<xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ:GUID"/></div>
        <div>Проверочный модуль: <xsl:for-each select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль">
            <xsl:if test="position() > 1">,&#160;</xsl:if>&quot;<xsl:value-of select="@Наименование"/>&quot;</xsl:for-each>
        </div>

        <xsl:apply-templates select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:Контрагент"/>
        <p class="afInterval" />
        <p> Проверяемые документы:</p>
        <table class="afTable afTable100">
            <tr class="afBold">
                <td>Код формы</td>
                <td><xsl:value-of select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент/@КодФормы"/></td>
            </tr>
            <xsl:if test="($is_szvstg or $is_szvcorr or $is_szvm or $is_odv1) and /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки">
                <tr class="afBold">
                    <td>Тип Сведений</td>
                    <xsl:choose>
                        <xsl:when test="$is_szvstg">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 0"><td>ИСХОДНАЯ</td></xsl:when>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1"><td>ДОПОЛНЯЮЩАЯ</td></xsl:when>
                                <xsl:otherwise><td>НАЗНАЧЕНИЕ ПЕНСИИ</td></xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="$is_szvcorr">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 0"><td>КОРРЕКТИРУЮЩАЯ</td></xsl:when>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1"><td>ОТМЕНЯЮЩАЯ</td></xsl:when>
                                <xsl:otherwise><td>ОСОБАЯ</td></xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="$is_szvm">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1"><td>ИСХОДНАЯ</td></xsl:when>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 2"><td>ДОПОЛНЯЮЩАЯ</td></xsl:when>
                                <xsl:otherwise><td>ОТМЕНЯЮЩАЯ</td></xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:НомерКорректировки = 1"><td>КОРРЕКТИРУЮЩАЯ</td></xsl:when>
                                <xsl:otherwise><td>ОТМЕНЯЮЩАЯ</td></xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
                </tr>
            </xsl:if>
            <xsl:if test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:КоличествоЗЛ">
                <tr class="afBold">
                    <td>Количество застрахованных лиц</td>
                    <td><xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:КоличествоЗЛ"/></td>
                </tr>
            </xsl:if>
            <xsl:if test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод">
                <tr class="afBold">
                    <td>Отчетный период</td>
                    <td>
                        <xsl:choose>
                            <xsl:when
                                test="not(/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод) and not(/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц)"><xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> год </xsl:when>
                            <xsl:when
                                test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 3 or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '03' or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '3'"
                                > I квартал <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when
                                test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 6 or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '06' or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '6'"
                                > полугодие <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when
                                test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 9 or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '09' or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '9'"
                                > 9 месяцев <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = 0 or /ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйПериод = '12'"> 
                                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> год </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 1"> январь <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 2"> февраль <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 3"> март <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"
                                /> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 4"> апрель <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 5"> май <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/>
                                года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 6"> июнь <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"
                                /> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 7"> июль <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"
                                /> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 8"> август <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 9"> сентябрь <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 10"> октябрь <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйМесяц = 11"> ноябрь <xsl:value-of
                                    select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:when>
                            <xsl:otherwise> декабрь <xsl:value-of select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:ОтчетныйГод"/> года </xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>
            </xsl:if>
            <tr class="afBold">
                <td>Наименование файла</td>
                <td>
                    <xsl:value-of select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверяемыйДокумент/УПП:Файл/@ИмяФайла"/>
                </td>
            </tr>
        </table>

        <p class="afInterval" />
        <p class="afParagraph afP">Уважаемые страхователи!</p>
        <p class="afParagraph afP">Обращаем ваше внимание, что запланирован перевод ЕФС-1 с ЭДОК на СЭДО Единой централизованной цифровой платформы в социальной сфере (ЕЦП). Необходимо обеспечить оформление МЧД (или перевыпуск МЧД с актуальными полномочиями) для взаимодействия посредством СЭДО ЕЦП.</p> 
        <p class="afParagraph afP">Для подачи отчетности посредством СЭДО ЕЦП необходимо полномочие SFR_000001 «Сведения для ведения индивидуального (персонифицированного) учета и сведения о начисленных страховых взносах на ОСС от НСиПЗ» либо вышестоящее полномочие.</p>
        <p class="afParagraph afP">Классификатор полномочий размещен на официальном сайте по адресу
            <a href="https://lk.sfr.gov.ru/mchd.html">https://lk.sfr.gov.ru/mchd.html.</a>
        </p>
 
        <p class="afInterval" />
        <h1 class="afHeaderLeft afP">Результат проверки:</h1>
        <table class="afTable afCol-1-2">
            <tr class="afCenter">
                <td>Предупреждений</td>
                <td>Ошибок</td>
                <td>Грубых ошибок</td>
            </tr>
            <tr class="afCenter">
                <td>
                    <xsl:value-of select="$warning"/>
                </td>
                <td>
                    <xsl:value-of select="$error"/>
                </td>
                <td>
                    <xsl:value-of select="$criticalError"/>
                </td>
            </tr>
        </table>
        <p class="afInterval" />
            
        <div>
        <xsl:choose>
            <xsl:when test="$isFirstGroup">
                <xsl:choose>
                    <xsl:when test="$criticalError">
                        <h1 class="afHeader afP afRed">Документ не принят!</h1>
                        <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                            <h1 class="afHeaderLeft afP">Перечень выявленных предупреждений и ошибок</h1>
                            <xsl:call-template name="printValidateModule"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$error and not($isSecondGroup)">
                        <h1 class="afHeader afP afRed">Документ принят частично!</h1>
                        <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                            <h1 class="afHeaderLeft afP">Перечень выявленных предупреждений и ошибок</h1>
                            <xsl:call-template name="printValidateModule"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <h1 class="afHeader afP afGreen">Документ принят!</h1>
                        <xsl:if
                            test="
                            count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                                /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                            <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                <h1 class="afHeaderLeft afP">Перечень выявленных предупреждений и ошибок</h1>
                                <xsl:call-template name="printValidateModule"/>
                            </xsl:for-each>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$criticalError or $error">
                        <h1 class="afHeader afP afRed">Документ не принят!</h1>
                        <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                            <h1 class="afHeaderLeft afP">Перечень выявленных предупреждений и ошибок</h1>
                            <xsl:call-template name="printValidateModule"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <h1 class="afHeader afP afGreen">Документ принят!</h1>
                        <xsl:if
                            test="
                            count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20'] |
                                /child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                            <xsl:for-each select="/child::*[local-name(.) = 'ЭДПФР']/descendant::УПП:ПроверочныйМодуль">
                                <h1 class="afHeaderLeft afP">Перечень выявленных предупреждений и ошибок</h1>
                                <xsl:call-template name="printValidateModule"/>
                            </xsl:for-each>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
        </div>  
            
            <div class="afNoBreakInside">
                <xsl:if
                    test="
                        count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']
                        | /ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']
                        | /ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30']
                        | /ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']
                        | /ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                    <p class="afInterval" />

                    <h1 class="afHeaderLeft afP">
                        Описание кодов результата проверки для
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент/@КодФормы"/>:
                    </h1>
                    <table class="afTable afTable100">
                         <tr class="afCenter">
                            <td style="width: 15%">Код результата</td>
                            <td style="width: 15%">Значение</td>
                            <td>Требуемое действие</td>
                        </tr>

                        <xsl:if
                            test="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10']) &gt; 0">
                            <tr>
                                <td>10</td>
                                <td class="aftable10">Предупреждение. Сведения приняты.</td>
                                <td>Ситуация возможная, но требующая разъяснений (проверки)</td>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']) &gt; 0">
                            <tr>
                                <td>20</td>
                                <td class="afTable10">Предупреждение. Сведения приняты.</td>
                                <td>Ситуация возможная, но требующая разъяснений (проверки)</td>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30']) &gt; 0">
                            <tr>
                                <td>30</td>
                                <xsl:choose>
                                    <xsl:when test="$isFirstGroup">
                                        <td class="afTable10">Ошибка. Сведения приняты не в полном объеме (не по всем застрахованным лицам).</td>
                                        <td>
                                            Сведения по застрахованным лицам, указанным в протоколе ошибок, не приняты и не подлежат учету на индивидуальных лицевых счетах.
                                            Необходимо представить корректные сведения по указанным застрахованным лицам в срок, установленный ст. 17 №27-ФЗ от 01.04.1996г.
                                        </td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td class="afTable10">Ошибка. Сведения не приняты.</td>
                                        <td>Необходимо устранить перечисленные ошибки и представить корректные сведения в срок, установленный ст.17 №27-ФЗ от 01.04.1996г.</td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']) &gt; 0">
                            <tr>
                                <td>40</td>
                                <xsl:choose>
                                    <xsl:when test="$isFirstGroup">
                                        <td class="afTable10">Ошибка. Сведения приняты не в полном объеме (не по всем застрахованным лицам).</td>
                                        <td>
                                            Сведения по застрахованным лицам, указанным в протоколе ошибок, не приняты и не подлежат учету на индивидуальных лицевых счетах.
                                            Необходимо представить корректные сведения по указанным застрахованным лицам в срок, установленный ст. 17 №27-ФЗ от 01.04.1996г.
                                        </td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td class="afTable10">Ошибка. Сведения не приняты.</td>
                                        <td>Необходимо устранить перечисленные ошибки и представить корректные сведения в срок, установленный ст.17 №27-ФЗ от 01.04.1996г.</td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:if>

                        <xsl:if
                            test="count(/ns1:ЭДПФР/ns1:УПП/УПП:ПроверочныйМодуль/УПП:ПроверкаФайлов/УПП:Файл/УПП:Результат/УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']) &gt; 0">
                            <tr>
                                <td>50</td>
                                <td class="afTable10">Грубая ошибка. Документ не принят.</td>
                                <td>
                                    Сведения по застрахованным лицам, указанным в протоколе ошибок, не приняты и не подлежат учету на индивидуальных лицевых счетах.
                                    Необходимо представить корректные сведения по указанным застрахованным лицам в срок, установленный ст. 17 №27-ФЗ от 01.04.1996г.
                                </td>
                            </tr>
                        </xsl:if>
                    </table>
                </xsl:if>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/ns1:Контрагент">
        <p class="afInterval" />
        <p>Информация о страхователе:</p>
        <table class="afTable afTable100">
            <tr class="afBold">
                <td>Регистрационный номер в СФР</td>
                <td>
                    <xsl:value-of select="./УТ:РегистрационныйНомер"/>
                </td>
            </tr>
            <tr class="afBold">
                <td>ИНН</td>
                <td>
                    <xsl:if test="./УТ:НалоговыйНомер">
                        <xsl:value-of select="./УТ:НалоговыйНомер/УТ:ИНН"/>
                    </xsl:if>
                </td>
            </tr>
            <tr class="afBold">
                <td>КПП</td>
                <td>
                    <xsl:if test="./УТ:НалоговыйНомер">
                        <xsl:value-of select="./УТ:НалоговыйНомер/УТ:КПП"/>
                    </xsl:if>
                </td>
            </tr>
            <tr class="afBold">
                <td>Наименование организации</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="./УТ:НаименованиеОрганизации">
                            <xsl:value-of select="./УТ:НаименованиеОрганизации"/>
                        </xsl:when>
                        <xsl:when test="./УТ:НаименованиеКраткое">
                            <xsl:value-of select="./УТ:НаименованиеКраткое"/>
                        </xsl:when>
                        <xsl:otherwise>Отсутствует</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template name="printValidateModule">
        <xsl:for-each select="УПП:ПроверкаФайлов/УПП:Файл">
            <xsl:variable name="is_szvm" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-М']"/>
            <xsl:variable name="is_szvtd" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-ТД']"/>
            <xsl:variable name="is_szvstg" select="/ns1:ЭДПФР/ns1:УПП/УПП:ПроверяемыйДокумент[@КодФормы = 'СЗВ-СТАЖ']"/>
            <xsl:variable name="isFirstGroup" select="$is_szvm or $is_szvtd or $is_szvstg"/>

            <xsl:variable name="hardErr" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '50']"/>
            <xsl:if test="count($hardErr) &gt; 0">
                <h3>Грубые ошибки</h3>
                <table class="afTable afRow afErrTable">
                    <xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '50']//УПП:ОжидаемоеЗначение)&gt;0"/>
                    <xsl:call-template name="printTableHeader">
                        <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                    </xsl:call-template>                    
                    <xsl:for-each select="$hardErr">
                        <xsl:call-template name="printCheckBlock">
                            <xsl:with-param name="numPP" select="position()"/>
                            <xsl:with-param name="codeFrom" select="'50'"/>
                            <xsl:with-param name="codeTo" select="'50'"/>
                            <xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
                            <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </table>
            </xsl:if>
            
            <xsl:variable name="err" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '30'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '40']"/>
            <xsl:if
                test="count($err) &gt; 0">
                <h3>Ошибки</h3>
                <table class="afTable afTable100 afErrTable">
                    <xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '30']//УПП:ОжидаемоеЗначение | УПП:Результат//УПП:Проверка[УПП:КодРезультата = '40']//УПП:ОжидаемоеЗначение )&gt;0"/>
                    <xsl:call-template name="printTableHeader">
                        <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                    </xsl:call-template> 
                    <xsl:for-each
                        select="$err">
                        <xsl:choose>
                            <xsl:when test="$isFirstGroup">
                                <xsl:call-template name="printCheckBlock">
                                    <xsl:with-param name="numPP" select="position()"/>
                                    <xsl:with-param name="codeFrom" select="'30'"/>
                                    <xsl:with-param name="codeTo" select="'40'"/>
                                    <xsl:with-param name="recultCodeCss" select="string('background-color: yellow')"/>
                                    <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="printCheckBlock">
                                    <xsl:with-param name="numPP" select="position()"/>
                                    <xsl:with-param name="codeFrom" select="'30'"/>
                                    <xsl:with-param name="codeTo" select="'40'"/>
                                    <xsl:with-param name="recultCodeCss" select="string('background-color: red')"/>
                                    <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </table>
            </xsl:if>

            <xsl:variable name="lightErr" select="УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '10'] | УПП:Результат/descendant::УПП:БлокПроверок[УПП:Проверка/УПП:КодРезультата = '20']"/>
            <xsl:if
                test="count($lightErr) &gt; 0">
                <h3>Предупреждения</h3>
                <table class="afTable afRow afErrTable">
                    <xsl:variable name="hasExpectedValue" select="count(УПП:Результат//УПП:Проверка[УПП:КодРезультата = '10']//УПП:ОжидаемоеЗначение | УПП:Результат//УПП:Проверка[УПП:КодРезультата = '20']//УПП:ОжидаемоеЗначение) &gt; 0"/>
                    <xsl:call-template name="printTableHeader">
                        <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                    </xsl:call-template> 
                    <xsl:for-each
                        select="$lightErr">
                        <xsl:call-template name="printCheckBlock">
                            <xsl:with-param name="numPP" select="position()"/>
                            <xsl:with-param name="codeFrom" select="'10'"/>
                            <xsl:with-param name="codeTo" select="'20'"/>
                            <xsl:with-param name="recultCodeCss" select="string('')"/>
                            <xsl:with-param name="hasExpectedValue" select="$hasExpectedValue"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </table>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="printTableHeader">
        <xsl:param name="hasExpectedValue"/>
        <tr class="afCenter">
            <td style="max-width: 25px">№ п/п</td>                        
            <td class="afTable10">Код проверки</td>
            <td style="width: 15%">Код результата</td>
            <td class="afTable25">Описание проверки</td>
            <td>Место ошибки</td>
            <xsl:if test="$hasExpectedValue">
                <td>Ожидаемое значение</td>
            </xsl:if>
        </tr>
    </xsl:template>

    <xsl:template name="printCheckBlock">
        <xsl:param name="numPP"/>
        <xsl:param name="codeFrom"/>
        <xsl:param name="codeTo"/>
        <xsl:param name="recultCodeCss"/>
        <xsl:param name="hasExpectedValue"/>        
        <xsl:for-each select="УПП:БлокПроверок">           
            <xsl:call-template name="printCheckBlock">
                <xsl:with-param name="numPP" select="position()"/>
                <xsl:with-param name="recultCodeCss" select="$recultCodeCss"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:variable name="cntError" select="count(child::*[./УПП:КодРезультата = $codeFrom] | child::*[./УПП:КодРезультата = $codeTo])"/>
        <xsl:variable name="colSpan" select="5+number($hasExpectedValue)"/>
        
        <xsl:if test="$cntError &gt; 0">
            <tr>
                <td colspan="{$colSpan}"><xsl:value-of select="concat($numPP,'. ',@Название)"/></td>
            </tr>
            <xsl:for-each select="УПП:Проверка[./УПП:КодРезультата = $codeFrom] | УПП:Проверка[./УПП:КодРезультата = $codeTo]">
                <xsl:variable name="cntErrorObj" select="count(.//УПП:Ошибка)"/>
                <xsl:variable name="position" select="position()"/>
				<!--если в протоколе нет сведений об ошибках для этой проверки, но правило сработало
				например, для АФ.СХ.1.1 текст ошибки выводится в элемент ОписаниеПроверки, а элементы Ошибка отсутствуют 
				-->
				<xsl:if test="$cntErrorObj=0">
					 <tr>                        
	                    <td rowspan="{$cntErrorObj}" class="afVerticalTop">
	                        <xsl:value-of select="concat($numPP,'.',$position)"/>
	                    </td>                                            
	                    <td rowspan="{$cntErrorObj}" class="afVerticalTop">
	                        <xsl:value-of select="@ID"/>
	                    </td>
	                    <td rowspan="{$cntErrorObj}" align="center" style="vertical-align: top; {$recultCodeCss}">
	                        <xsl:value-of select="УПП:КодРезультата"/>
	                    </td>
	                    <td rowspan="{$cntErrorObj}" class="afVerticalTop">
	                        <xsl:value-of select="УПП:ОписаниеПроверки"/>
	                    </td>                        
					     <td/>
                    </tr>
				</xsl:if>                
                <xsl:for-each select="УПП:Ошибки/УПП:Ошибка">
                    <tr>
                        <xsl:if test="position()=1">
                            <td rowspan="{$cntErrorObj}" class="afVerticalTop">
                                <xsl:value-of select="concat($numPP,'.',$position)"/>
                            </td>                                            
                            <td rowspan="{$cntErrorObj}" class="afVerticalTop">
                                <xsl:value-of select="../../@ID"/>
                            </td>
                            <td rowspan="{$cntErrorObj}" align="center" style="vertical-align: top; {$recultCodeCss}">
                                <xsl:value-of select="../../УПП:КодРезультата"/>
                            </td>
                            <td rowspan="{$cntErrorObj}" class="afVerticalTop">
                                <xsl:value-of select="../../УПП:ОписаниеПроверки"/>
                            </td>  
                        </xsl:if>
                        <td>                               
                            <xsl:if test="УПП:Объект and (УПП:Объект/УПП:Наименование/text() or УПП:Объект/УПП:Значение/text())">                                
                                <xsl:if test="УПП:Объект/УПП:Наименование">
                                    <xsl:value-of select="concat(УПП:Объект/УПП:Наименование, '=')"/>
                                </xsl:if>
                                <span class="afValue"><xsl:value-of select="УПП:Объект/УПП:Значение"/></span>
                                <br/>
                            </xsl:if>
                            <xsl:value-of select="concat('Путь до элемента: ', УПП:ПутьДоЭлемента)"/>                                                        
                        </td>
                        <xsl:if test="$hasExpectedValue">
                            <td>
                                <xsl:choose>
                                    <xsl:when test="УПП:ОжидаемоеЗначение">                                    
                                            <xsl:value-of select="УПП:ОжидаемоеЗначение"/>                                    
                                    </xsl:when>                                
                                </xsl:choose>
                            </td>
                        </xsl:if>
                    </tr>
                </xsl:for-each>                
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
