<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ3 ns1" version="1.0" xmlns:УТ3="http://пф.рф/УТ/2022-07-14" xmlns:ns1="http://пф.рф/АДВ-2/2022-02-23">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2022-07-14.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:АДВ-2"/>
		<xsl:variable name="vCancel" select="/ns1:ЭДПФР/ns1:АДВ-2/ns1:ИзменившиесяДанные/ns1:Отмены"/>
		
        <div class="afSmallWrap13 pfrAfADV2">
			<table class="afTable100">
				<tbody>
					<tr>
						<td class="afTable15 afCenter"><span class="afUnderline">Форма АДВ-2</span></td>
						<td>&#160;</td>
						<td class="afTable15 afCenter">Код по ОКУД </td>
						<td class="afTable15 afTable">&#160;</td>
					</tr>
				</tbody>
			</table>
			<p class="afInterval"/>
			<h1 class="afHeader">Заявление об изменении анкетных данных зарегистрированного лица,<br/>содержащихся в индивидуальном лицевом счете</h1>
            <p class="afInterval"/>
            <p class="afSubscript afItalic">Заполняется зарегистрированным лицом печатными буквами</p>
            <div class="afRow afBordered">
				<div class="afRow">
					<div class="afC">Страховой номер<br/>индивидуального<br/>лицевого счета</div>
					<div class="afMarginLeft110 afValue ">
						<span class="afUnderline"><xsl:value-of select="substring($vForm/УТ3:СНИЛС, 1, 3)"/></span>-<span class="afUnderline"><xsl:value-of select="substring($vForm/УТ3:СНИЛС, 5, 3)"/></span>-<span class="afUnderline"><xsl:value-of select="substring($vForm/УТ3:СНИЛС, 9, 3)"/></span>&#160;<span class="afUnderline"><xsl:value-of select="substring($vForm/УТ3:СНИЛС, 13, 2)"/></span>
					</div>
				</div>
				<div class="afRow"><div class="afC">Данные, указанные в документе, подтверждающем регистрацию в системе индивидуального (персонифицированного) учета</div></div>
				<div class="afRow">
					<div class="afC">Фамилия </div>
					<div class="afMarginLeft110 afValue afUnderline">
						<xsl:value-of select="$vForm/УТ3:ФИО/УТ3:Фамилия"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afMarginLeft110 afValue afUnderline">
						<xsl:value-of select="$vForm/УТ3:ФИО/УТ3:Имя"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии) </div>
					<div class="afMarginLeft160 afValue afUnderline">
						<xsl:value-of select="$vForm/УТ3:ФИО/УТ3:Отчество"/>
					</div>
				</div>
				<div class="afRow"><div class="afC">Новые анкетные данные (указать только изменившиеся данные) </div></div>
				<div class="afRow">
					<div class="afC">Фамилия </div>
					<div class="afMarginLeft110 afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыФамилии and $vCancel/ns1:ПризнакОтменыФамилии ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:ФИО/УТ3:Фамилия"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
						
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afMarginLeft110 afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыИмени and $vCancel/ns1:ПризнакОтменыИмени ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:ФИО/УТ3:Имя"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии) </div>
					<div class="afMarginLeft160 afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыОтчества and $vCancel/ns1:ПризнакОтменыОтчества ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:ФИО/УТ3:Отчество"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
						
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Пол </div>
					<div class="afCol-1-8">&#160;</div>
					<div class="afValue afCenterBlock afUnderline afCol-1-8">
						<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Пол"/>&#160;
					</div>
					<div class="afMarginLeft150">(м / ж)</div>
				</div>
				<xsl:variable name="vFormD" select="/ns1:ЭДПФР/ns1:АДВ-2/ns1:ИзменившиесяДанные/ns1:Данные"/>
				<div class="afRow">
					<div class="afC ">Дата рождения </div>
					<div class="afCol-3">&#160;</div>
					<div class="afUnderline afCol-1-5">
						<span class="afValue">
							<xsl:choose>
								<xsl:when test="$vFormD/УТ3:ДатаРождения">
									<xsl:call-template name="Date2Text">
										<xsl:with-param name="pDate" select="$vFormD/УТ3:ДатаРождения"/>
									</xsl:call-template> 
								</xsl:when>
								<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая">
									<xsl:choose>
										<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:День">
											"<xsl:value-of select="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:День"/>"&#160;&#160;</xsl:when>
										<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц">
											<xsl:choose>
												<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:День">
													<xsl:choose>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '01' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '1'">января</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '02' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '2'">февраля</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '03' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '3'">марта</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '04' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '4'">апреля</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '05' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '5'">мая</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '06' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '6'">июня</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '07' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '7'">июля</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '08' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '8'">августа</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '09' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '9'">сентября</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '10'">октября</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '11'">ноября</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '12'">декабря</xsl:when>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '01' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '1'">январь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '02' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '2'">февраль</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '03' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '3'">март</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '04' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '4'">апрель</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '05' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '5'">май</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '06' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '6'">июнь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '07' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '7'">июль</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '08' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '8'">август</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '09' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '9'">сентябрь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '10'">октябрь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '11'">ноябрь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '12'">декабрь</xsl:when>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>	
										<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Год">
											&#160;&#160;<xsl:value-of select="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Год"/>
										</xsl:when>
										<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
								<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
							</xsl:choose> 
						</span>
					</div>
					<div> года</div>
				</div>
				<div class="afRow"><div class="afC">Место рождения: </div></div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">населенный пункт </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:МестоРождения/УТ3:Город"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">район </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:МестоРождения/УТ3:Район"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
						
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">регион (область, край, республика, ...) </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:МестоРождения/УТ3:Регион"/>&#160;
							</xsl:otherwise>
						</xsl:choose>
						
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afCol-3-10">страна </div>
					<div class="afValue afUnderline afCol-59">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыМестаРождения and $vCancel/ns1:ПризнакОтменыМестаРождения ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:МестоРождения/УТ3:Страна"/>&#160;
							</xsl:otherwise>
						</xsl:choose>

					</div>
				</div>
				<div class="afRow">
					<div class="afC">Гражданство </div>
					<div class="afMarginLeft110 afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Гражданство/УТ3:Тип = '1'">Российская Федерация</xsl:when>
							<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Гражданство/УТ3:Тип = '3'">Лицо без гражданства</xsl:when>
							<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Гражданство/УТ3:Тип = '2'">
								<xsl:choose>
									<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Гражданство/УТ3:Государство">
										<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Гражданство/УТ3:Государство/УТ3:Наименование"/>
									</xsl:when>
									<xsl:otherwise>Иностранный гражданин</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>

				<div class="afRow">
					<div class="afC">Адрес постоянного <br/> места жительства </div>
					<div class="afMarginLeft130 afValue afUnderlinedBlock">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыАдресаРегистрации and $vCancel/ns1:ПризнакОтменыАдресаРегистрации ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресРегистрации/УТ3:Иностранный">
										<xsl:call-template name="УТ3:AddressForeignStr">
											<xsl:with-param name="pAddress" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресРегистрации"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресРегистрации/УТ3:Неструктурированный">
										<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресРегистрации/УТ3:Неструктурированный"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="УТ3:AddressStr">
											<xsl:with-param name="pAddress" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресРегистрации"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Адрес места пребывания </div>
					<div class="afMarginLeft180 afValue afUnderlinedBlock">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыАдресаФактического and $vCancel/ns1:ПризнакОтменыАдресаФактического ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресФактический/УТ3:Иностранный">
										<xsl:call-template name="УТ3:AddressForeignStr">
											<xsl:with-param name="pAddress" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресФактический"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресФактический/УТ3:Неструктурированный">
										<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресФактический/УТ3:Неструктурированный"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="УТ3:AddressStr">
											<xsl:with-param name="pAddress" select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:АдресФактический"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
            	<p class="afSubscript afCenter afItalic afMarginLeft50">(заполнять при отличии от адреса постоянного места жительства)</p>
				<div class="afRow">
					<div class="afC">Телефоны </div>
					<div class="afMarginLeft110 afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Телефоны">
								<xsl:for-each select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/УТ3:Телефоны/УТ3:Телефон">
									<xsl:value-of select="."/>
									  <xsl:choose>
										<xsl:when test="count(preceding-sibling::УТ3:Телефон)+1 &lt; count(//УТ3:Телефон)">; </xsl:when>
										<xsl:otherwise>&#160;</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<p class="afSubscript afCenter afItalic afMarginLeft50">(домашний и/или рабочий)</p>
				<div class="afRow"><div class="afC">Документ, удостоверяющий личность </div></div>
				<div class="afRow">
					<div class="afC">Вид документа </div>
					<div class="afMarginLeft160 afValue afUnderline">
						&#160;
						<xsl:choose>
							<xsl:when test="$vForm/ns1:УдостоверяющийДокумент/УТ3:Тип = 'ПРОЧЕЕ'">
								<xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ3:Наименование"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ3:Тип"/>
							</xsl:otherwise>
						</xsl:choose>
					</div>
					
				</div>
				<p class="afSubscript afCenter afItalic afMarginLeft50">(указать название документа: паспорт, удостоверение личности или другие документы, удостоверяющие личность)</p>
				<div class="afRow">
					<div class="afC">Серия, номер </div>
					<div class="afMarginLeft160 afValue afUnderline">
						<xsl:if test="$vForm/ns1:УдостоверяющийДокумент/УТ3:Серия">
							<xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ3:Серия"/>&#160;
						</xsl:if>&#160;
						<xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ3:Номер"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата выдачи </div>
					<div class="afCol-1-10-1">&#160;</div>
					<div class="afValue afCenterBlock afUnderline afCol-1-5">
						<xsl:call-template name="Date2Text">
							<xsl:with-param name="pDate" select="$vForm/ns1:УдостоверяющийДокумент/УТ3:ДатаВыдачи"/>
						</xsl:call-template>
					</div>
					<div > года</div>
				</div>
				<div class="afRow">
					<div class="afC">Кем выдан </div>
					<div class="afMarginLeft160 afValue afUnderline">&#160;
					<xsl:if test="$vForm/ns1:УдостоверяющийДокумент/УТ3:КемВыдан">
						<xsl:value-of select="$vForm/ns1:УдостоверяющийДокумент/УТ3:КемВыдан"/>
					</xsl:if>
					</div>
				</div>
				<div class="afRow"><div class="afC">Реквизиты акта гражданского состояния о рождении </div></div>
				<div class="afRow">
					<div class="afC">Номер актовой записи о рождении </div>
					<div class="afMarginLeft250 afValue afUnderline">
					<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыАктовойЗаписи and $vCancel/ns1:ПризнакОтменыАктовойЗаписи ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:if test="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ3:Номер">
									<xsl:value-of select="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ3:Номер"/>
								</xsl:if>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата составления актовой записи о рождении </div>
					<div class="afCol-1-10-1">&#160;</div>
					
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыАктовойЗаписи and $vCancel/ns1:ПризнакОтменыАктовойЗаписи ='ОТМЕНЕНО'">
								<div class="afCol-1-4">
									"____" _________________
								</div>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ3:Дата">
										<div class="afValue afCenterBlock afUnderline afCol-1-5">
											<xsl:call-template name="Date2Text">
												<xsl:with-param name="pDate" select="$vForm/ns1:АктоваяЗапись/ns1:РеквизитыДокумента/УТ3:Дата"/>
											</xsl:call-template>&#160;
										</div>
									</xsl:when>
									<xsl:otherwise>
										<div class="afCol-1-4">
											"____" _________________
										</div>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					<div > года</div>
				</div>
				<div class="afRow">
					<div class="afC">Наименование органа, которым произведена государственная регистрация акта о рождении </div>
				</div>
				<div class="afRow">
					<div class="afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыАктовойЗаписи and $vCancel/ns1:ПризнакОтменыАктовойЗаписи ='ОТМЕНЕНО'">&#160;</xsl:when>
							<xsl:otherwise>
								<xsl:if test="$vForm/ns1:АктоваяЗапись/УТ3:Наименование">
									<xsl:value-of select="$vForm/ns1:АктоваяЗапись/УТ3:Наименование"/>
								</xsl:if>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Идентификационный номер налогоплательщика (при наличии) </div>
					<div class="afMarginLeft390 afValue afUnderline">
						<xsl:choose>
							<xsl:when test="$vCancel/ns1:ПризнакОтменыИНН and $vCancel/ns1:ПризнакОтменыИНН ='ОТМЕНЕНО'">&#160;(Отменено)</xsl:when>
							<xsl:otherwise>
								<xsl:if test="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/ns1:ИНН">
									<xsl:value-of select="$vForm/ns1:ИзменившиесяДанные/ns1:Данные/ns1:ИНН"/>
								</xsl:if>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
            </div>  
            <div class="afRow">
				<div class="afCol-1-2 afCenterBlock">Дата заполнения </div>
				<div class="afCol-1-2 afCenterBlock">Подпись зарегистрированного лица (представителя) </div>
			</div>
			<p class="afInterval"/>
			 <div class="afRow">
				<div class="afCol-1-2 afCenterBlock"><span class="afUnderline">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate" select="$vForm/ns1:ДатаЗаполнения"/>
					</xsl:call-template></span>года&#160; 
				</div>
				<div class="afCol-1-2 afCenterBlock">__________________________________ </div>
			</div>
        </div>
    </xsl:template>
</xsl:stylesheet>
