<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ3 ns1" version="1.0" xmlns:УТ3="http://пф.рф/УТ/2022-07-14" xmlns:ns1="http://пф.рф/ВЗЛ/АДИ-8/2022-03-23">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2022-07-14.xsl"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:АДИ-8"/>
		<xsl:variable name="vFormD" select="$vForm/ns1:АнкетныеДанные"/>
        <div class="afWrap pfrAfADI8">
			<table class="afTable100">
				<tbody>
					<tr>
						<td class="afTable15 afCenter"><span class="afUnderline">Форма АДИ-8</span></td>
						<td>&#160;</td>
						<td class="afTable15 afCenter">Код по ОКУД </td>
						<td class="afTable15 afTable">&#160;</td>
					</tr>
				</tbody>
			</table>

        	<h1 class="afHeader">Решение об отказе в регистрации зарегистрированного лица</h1>
            <p class="afInterval"/><p class="afInterval"/>
            
			<div class="afRow afCol-4-5">
				<div class="afRow">
					<div class="afC">Страховой номер<br/>индивидуального<br/>лицевого счета </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ3:СНИЛС"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Фамилия </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ3:ФИО/УТ3:Фамилия"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ3:ФИО/УТ3:Имя"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии) </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ3:ФИО/УТ3:Отчество"/>
					</div>
				</div>
				
				<div class="afRow">
					<div class="afC ">Дата рождения </div>
					<div class="afMarginLeft200 afUnderline">
						<span class="afValue">
							<xsl:choose>
								<xsl:when test="$vFormD/УТ3:ДатаРождения">
									<xsl:call-template name="Date2Text">
										<xsl:with-param name="pDate" select="$vFormD/УТ3:ДатаРождения"/>
									</xsl:call-template> 
								</xsl:when>
								<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая">
									<xsl:choose>
										<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:День">
											"<xsl:value-of select="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:День"/>"&#160;&#160;</xsl:when>
										<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц">
											<xsl:choose>
												<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:День">
													<xsl:choose>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '01' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '1'">января</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '02' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '2'">февраля</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '03' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '3'">марта</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '04' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '4'">апреля</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '05' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '5'">мая</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '06' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '6'">июня</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '07' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '7'">июля</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '08' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '8'">августа</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '09' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '9'">сентября</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '10'">октября</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '11'">ноября</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '12'">декабря</xsl:when>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '01' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '1'">январь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '02' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '2'">февраль</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '03' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '3'">март</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '04' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '4'">апрель</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '05' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '5'">май</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '06' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '6'">июнь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '07' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '7'">июль</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '08' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '8'">август</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '09' or $vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '9'">сентябрь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '10'">октябрь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '11'">ноябрь</xsl:when>
														<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Месяц = '12'">декабрь</xsl:when>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>	
										<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Год">
											&#160;&#160;<xsl:value-of select="$vFormD/УТ3:ДатаРожденияОсобая/УТ3:Год"/>
										</xsl:when>
										<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
								<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
							</xsl:choose> 
						</span>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Место рождения </div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:call-template name="УТ3:BirthplaceStr">
							<xsl:with-param name="pBirthplace" select="$vFormD/УТ3:МестоРождения"/>
						</xsl:call-template>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Пол </div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:value-of select="$vFormD/УТ3:Пол"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Причина отказа</div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:value-of select="$vForm/ns1:ПричинаОтказа"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата заполнения</div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:call-template name="Date2Text">
							<xsl:with-param name="pDate" select="$vForm/ns1:ДатаФормирования"/>
						</xsl:call-template>
					</div>
				</div>
			</div>
            <p class="afInterval"/><p class="afInterval"/>
			<p class="afInterval"/><p class="afInterval"/>
			
			<div class="afRow afCol-95">
				<div class="afCol-4-10">Специалист</div>
			</div>
			<div class="afRow afCol-95">
				<div class="afCol-4-10">территориального органа СФР</div>
				<div class="afCol-1-5 afUnderline">&#160;</div>
				<div class="afCol-2">&#160;</div>
				<div class="afCol-1-3 afUnderline">&#160;</div>
			</div>
			<div class="afRow afCol-95">
				<div class="afCol-4-10">&#160;</div>
				<div class="afCol-1-5 afSubscript afItalic afCenterBlock">(подпись)</div>
				<div class="afCol-2">&#160;</div>
				<div class="afCol-1-3 afSubscript afItalic afCenterBlock">(расшифровка подписи)</div>
			</div>
        </div>
    </xsl:template>
</xsl:stylesheet>
