<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1 АФ5" version="1.0" xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/АДИ-РЕГ/2019-04-19" xmlns:АФ5="http://пф.рф/АФ/2018-12-07">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:include href="../../Общие/ШтампЭП.xsl"/>
    <xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:АДИ-РЕГ"/>
        <div class="afWrap pfrAfADI-REG">
			<p class="afInterval"/>
        	<p class="afInterval"/>

			<h1 class="afHeader">Документ, <br/>подтверждающий регистрацию в системе индивидуального  <br/>
			(персонифицированного) учета «Уведомление о регистрации в системе   <br/>индивидуального (персонифицированного) учета (АДИ-РЕГ)»</h1>
            <p class="afInterval"/>
        	<p class="afInterval"/>
            
			<div class="afRow afCol-4-5">
				<div class="afRow">
					<div class="afC">Страховой номер индивидуального лицевого счета (СНИЛС) </div>
					<div class="afMarginLeft400 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ2:СНИЛС"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Фамилия </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ2:ФИО/УТ2:Фамилия"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ2:ФИО/УТ2:Имя"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии) </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ2:ФИО/УТ2:Отчество"/>
					</div>
				</div>
				
				<div class="afRow">
					<div class="afC ">Дата рождения </div>
					<div class="afMarginLeft200 afUnderline">
						<span class="afValue">
							<xsl:choose>
								<xsl:when test="$vForm/УТ2:ДатаРождения">
									<xsl:call-template name="DateStr">
										<xsl:with-param name="pDate" select="$vForm/УТ2:ДатаРождения"/>
									</xsl:call-template> 
								</xsl:when>
								<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая">
									<xsl:choose>
										<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:День">
											"<xsl:value-of select="$vForm/УТ2:ДатаРожденияОсобая/УТ2:День"/>"&#160;&#160;</xsl:when>
										<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц">
											<xsl:choose>
												<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:День">
													<xsl:choose>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '01' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '1'">января</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '02' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '2'">февраля</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '03' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '3'">марта</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '04' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '4'">апреля</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '05' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '5'">мая</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '06' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '6'">июня</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '07' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '7'">июля</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '08' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '8'">августа</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '09' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '9'">сентября</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '10'">октября</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '11'">ноября</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '12'">декабря</xsl:when>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '01' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '1'">январь</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '02' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '2'">февраль</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '03' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '3'">март</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '04' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '4'">апрель</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '05' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '5'">май</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '06' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '6'">июнь</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '07' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '7'">июль</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '08' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '8'">август</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '09' or $vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '9'">сентябрь</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '10'">октябрь</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '11'">ноябрь</xsl:when>
														<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Месяц = '12'">декабрь</xsl:when>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>	
										<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Год">
											&#160;&#160;<xsl:value-of select="$vForm/УТ2:ДатаРожденияОсобая/УТ2:Год"/>
										</xsl:when>
										<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
								<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
							</xsl:choose> 
						</span>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Место рождения </div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:call-template name="УТ2:BirthplaceStr">
							<xsl:with-param name="pBirthplace" select="$vForm/УТ2:МестоРождения"/>
						</xsl:call-template>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Пол </div>
					<div class="afMarginLeft200 afUnderline afValue">
					<xsl:choose>
					<xsl:when test="$vForm/УТ2:Пол[text() = 'М']"> МУЖСКОЙ
					</xsl:when>
					<xsl:otherwise>ЖЕНСКИЙ</xsl:otherwise>
					</xsl:choose>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата регистрации в системе <br/>индивидуального <br/>(персонифицированного) учета</div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:call-template name="DateStr">
							<xsl:with-param name="pDate" select="$vForm/ns1:ДатаРегистрации"/>
						</xsl:call-template>
					</div>
				</div>
			</div>
            <p class="afInterval"/><p class="afInterval"/>
        	<div class="afRow afCol-95">
        		Работник территориального органа СФР*
        	</div>
			<p class="afInterval"/><p class="afInterval"/>
			<xsl:choose>
				<xsl:when test="$vForm/ns1:ДолжностноеЛицо">
					<div class="afRow afCol-95">
						<div class="afCol-2-5 afValue afUnderline afCenterBlock"><xsl:value-of select="$vForm/ns1:ДолжностноеЛицо/УТ2:Должность"/></div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-5 afUnderline">&#160;</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afUnderline afValue afCenterBlock">
							<xsl:call-template name="УТ2:NameStr">
                                <xsl:with-param name="pName" select="$vForm/ns1:ДолжностноеЛицо/УТ2:ФИО"/>
                            </xsl:call-template>
                        </div>
					</div>
					<div class="afRow afCol-95">
						<div class="afCol-2-5 afSubscript afItalic afCenterBlock">(должность)</div>
						<div class="afCol-1-5 afSubscript afItalic afCenterBlock">(подпись)</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afSubscript afItalic afCenterBlock">(расшифровка подписи)</div>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afRow afCol-95">
						<div class="afCol-4-10">Работник</div>
					</div>
					<div class="afRow afCol-95">
						<div class="afCol-4-10">территориального органа СФР</div>
						<div class="afCol-1-5 afUnderline">&#160;</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afUnderline">&#160;</div>
					</div>
					<div class="afRow afCol-95">
						<div class="afCol-4-10 afSubscript afItalic">(должность)</div>
						<div class="afCol-1-5 afSubscript afItalic afCenterBlock">(подпись)</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afSubscript afItalic afCenterBlock">(расшифровка подписи)</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
			<p class="afInterval"/><p class="afInterval"/>
			<div class="afRow afCol-95">
				М.П.
			</div>
        	<div class="afRow afCol-95">
        		(при наличии)
        	</div>
			<p class="afInterval"/>
        	<div class="afRow afCol-95">
        		--------------------------------
        	</div>
        	<div class="afRow afCol-95">
        		* Заполняется при обращении в территориальный орган СФР 
        	</div>
        	
			 <xsl:choose>
				<xsl:when test="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ5:РеквизитыЭП">
					<xsl:call-template name="PrintSignature">
						<xsl:with-param name="pSignature" select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ5:РеквизитыЭП" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="PrintSignature"/>
				</xsl:otherwise>
			</xsl:choose>
			
        </div>
    </xsl:template>
</xsl:stylesheet>
