<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1 ИС2" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ИС2="http://пф.рф/ВС/ИС/типы/2017-09-11" xmlns:ns1="http://пф.рф/ВС/ОДВ-1/2017-12-25">

 <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
        <div class="afWrap pfrAfODV-1">

            <p class="afRight-3-10">
                УТВЕРЖДЕНА<br/>
                постановлением Правления ПФР<br/>
                от 6 декабря 2018 г. № 507п
            </p>
            <p class="afInterval"/>
            <p class="afP">Форма ОДВ-1</p>
            <p class="afInterval"/>
            <p class="afValue afP">Форма ОДВ-1</p>
            <p class="afInterval"/>
            <p class="afValue afP">1. Реквизиты страхователя, передающего документы:</p>
            <p class="afInterval"/><xsl:variable name="RegNum" select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страхователь/УТ2:РегНомер"/>
            <div class="afRow">
				<div class="afC">Регистрационный номер в СФР</div> 
				<div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 3, 1)" /></td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 5, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 6, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 7, 1)" /></td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 9, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 10, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 11, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 12, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 13, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($RegNum, 14, 1)" /></td>
						</tr>
					</table>
				</div>
			</div>
            <xsl:variable name="NumINN" select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страхователь/УТ2:ИНН"/>
            <xsl:variable name="NumKPP" select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страхователь/УТ2:КПП"/>
            <div class="afRow">
				<div class="afCol-1-5 afCenterBlock">ИНН</div> 
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 9, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 10, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 11, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN, 12, 1)" /></td>
                        </tr>
                    </table>
                </div>
                <div class="afCol-1-5 afCenterBlock">КПП</div>
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP, 9, 1)" /></td>
                        </tr>
                    </table>
                </div>
            </div>
           
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">Наименование (краткое)</div>
                <div class="afCol-2-3 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страхователь/ИС2:Наименование"/>
                </div>
            </div>
           <div class="afRow">
                 <div class="afCol-3-10">
                    <div class="afC afValue">2. Отчетный период (код):</div>
                    <div class="afCol-1-10">
                        <div class="afC afCheck">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Код"/>
                        </div>
                    </div>
                </div>
                 <div class="afCol-1-5">
                    <div class="afC afMarginLeft10">год</div>
                    <div class="afValue">
						<div class="afCol-1-4 afCheck">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Год"/>
						</div>
                    </div>
                </div>
                <div class="afCol-1-2">
                    <div class="afP">
                        <div class="afCol-1-2">Исходная</div>
                        <div class="afCol-1-10 ">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Тип[text() = '0']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                    <div class="afP">
                        <div class="afCol-1-2">Корректирующая</div>
                        <div class="afCol-1-10">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Тип[text() = '1']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                    <div class="afP">
                        <div class="afCol-1-2">Отменяющая</div>
                        <div class="afCol-1-10">
                            <div class="afC afCheck">
                                <xsl:if test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Тип[text() = '2']">V</xsl:if>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <p class="afP afValue">3. Перечень входящих документов</p>
            <table class="afTable afSmallSize">
                <tr class="afCenter">
                    <td>Наименование входящего документа</td>
                    <td>Количество застрахованных лиц, на которых представлены сведения, чел.</td>
                </tr>
                <tr>
                    <td>Форма "Сведения о страховом стаже застрахованного лица (СЗВ-СТАЖ)"</td>
                    <td> </td>
                </tr>
                <tr>
                    <td>Форма "Сведения о заработке (вознаграждении) доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах, о периодах трудовой и иной деятельности,
                        засчитываемых в страховой стаж застрахованного лица (СЗВ-ИСХ)"</td>
                    <td class="afValue afCenter">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:КоличествоЗЛ"/>
                    </td>
                </tr>
                <tr>
                    <td>Форма "Данные о корректировке сведений, учтенных на индивидуальном лицевом счету застрахованного лица (СЗВ-КОРР)"</td>
                    <td> </td>
                </tr>
                <tr>
                    <td>Иные входящие документы:</td>
                    <td/>
                </tr>
            </table>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<p class="afP afValue">4. Данные в целом по страхователю:</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td/>
						<td>Задолженность на начало отчетного периода, руб. коп.</td>
						<td>Начислено страховых взносов, руб. коп.</td>
						<td>Уплачено страховых взносов, руб. коп.</td>
						<td>Задолженность на конец отчетного периода, руб. коп.</td>
					</tr>
					<tr>
						<td>На страховую пенсию</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страховая/ИС2:ЗадолженностьНаНачало"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страховая/ИС2:Начислено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страховая/ИС2:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страховая/ИС2:ЗадолженностьНаКонец"/>
						</td>
					</tr>
					<tr>
						<td>На накопительную пенсию</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Накопительная/ИС2:ЗадолженностьНаНачало"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Накопительная/ИС2:Начислено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Накопительная/ИС2:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Накопительная/ИС2:ЗадолженностьНаКонец"/>
						</td>
					</tr>
					<tr>
						<td>По тарифу страховых взносов</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС2:ЗадолженностьНаНачало"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС2:Начислено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС2:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС2:ЗадолженностьНаКонец"/>
						</td>
					</tr>
				</table>
			</div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
                <p class="afP">Расшифровка графы "Уплачено" по периодам, за которые была произведена уплата страховых взносов</p>
                <table class="afTable afSmallSize">
                    <tr class="afCenter">
                        <td>Уплачено в календарном году</td>
                        <td>На страховую пенсию</td>
                        <td>На накопительную пенсию</td>
                        <td>По тарифу страховых взносов</td>
                    </tr>
                    <tr>
                        <td>Всего, в том числе:</td>
                        <td>
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Страховая/ИС2:Уплачено"/>
                        </td>
                        <td>
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Накопительная/ИС2:Уплачено"/>
                        </td>
                        <td>
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС2:Уплачено"/>
                        </td>
                    </tr>
                    <xsl:choose>
                        <xsl:when test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Уплата/ИС2:Год">
                            <xsl:for-each select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Уплата">
                                <tr>
                                    <td>за <span class="afValue"><xsl:value-of select="./ИС2:Год"/></span> год</td>
                                    <td>
                                        <xsl:value-of select="./ИС2:Страховая"/>
                                    </td>
                                    <td>
                                        <xsl:value-of select="./ИС2:Накопительная"/>
                                    </td>
                                    <td>
                                        <xsl:value-of select="./ИС2:ТарифСВ"/>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <td>за ________ год</td>
                                <td/>
                                <td/>
                                <td/>
                            </tr>
                            <tr>
                                <td>за ________ год</td>
                                <td/>
                                <td/>
                                <td/>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>
                </table>
            </div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<p class="afP afValue">5. Основание для отражения данных о периодах работы застрахованного лица в условиях, дающих право на досрочное назначение пенсии в соответствии со статьей 30
                Федерального закона от 28.12.2013 № 400–ФЗ «О страховых пенсиях»</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td>№ п/п</td>
						<td>Наименование структурного подразделения по штатному расписанию</td>
						<td>Наименование профессии, должности по штатному расписанию</td>
						<td>Кол-во раб. мест по штат. распи-санию</td>
						<td>Кол-во раб-ов факт.</td>
						<td>Характер фактически выполняемых работ и дополнительные условия труда</td>
						<td>Наименование первичных документов, подтверждающих занятость в особых условиях труда</td>
						<td>Код особых условий труда/выслуги лет по Классификатору</td>
						<td>Код позиции Списка № 1 и 2, "малого" списка</td>
					</tr>
					<tr class="afHeightRow afCenter afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
						<td>5</td>
						<td>6</td>
						<td>7</td>
						<td>8</td>
						<td>9</td>
					</tr>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
							<xsl:for-each select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
								<tr class="afCenter">
									<td>
										<xsl:value-of select="position()"/>
									</td>
									<td>
										<xsl:value-of select="./ИС2:Подразделение"/>
									</td>
									<td>
										<xsl:value-of select="./ИС2:ПрофессияДолжность"/>
									</td>
									<td>
										<xsl:value-of select="./ИС2:КоличествоШтат"/>
									</td>
									<td>
										<xsl:value-of select="./ИС2:КоличествоФакт"/>
									</td>
									<td>
										<xsl:value-of select="./ИС2:Описание"/>
									</td>
									<td>
										<xsl:value-of select="./ИС2:Документы"/>
									</td>
									<td>
										<xsl:for-each select="./ns1:ОУТ">
											<p class="afP">
												<xsl:value-of select="./ns1:Код"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ns1:ОУТ">
											<p class="afP">
												<xsl:value-of select="./ns1:ПозицияСписка"/>
											</p>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
			</div>
            <p class="afInterval"/>
            <div class="afNoBreakInside">
				<div class="afRow">
					<div class="afC afValue">Общее количество рабочих мест в особых условиях труда по штату</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<xsl:value-of select="sum(//ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание/ИС2:КоличествоШтат)"/>
								<!--xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС2:ВсегоШтат"/-->
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<div class="afRow">
					<div class="afC afValue">Количество фактически работающих в особых условиях труда</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<xsl:value-of select="sum(//ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание/ИС2:КоличествоФакт)"/>
								<!--xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС2:ВсегоФакт"/-->
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afInterval"/>
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afSubscriptNormal afCenter">Наименование должности руководителя</p>
					</div>
					<div class="afPadding">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afSubscriptNormal afCenter">Подпись</p>
					</div>
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ2:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afSubscriptNormal afCenter">Расшифровка подписи</p>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="/ns1:ЭДПФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
								</xsl:with-param>
							</xsl:call-template>
						</p>
						<p class="afP afCenter">Дата (дд.мм.гггг)</p>
					</div>
					<div class="afPadding">М.П. (при наличии)</div>
					<div class="afPadding"></div>
				</div>
			</div>	
        </div>
    </xsl:template>
</xsl:stylesheet>
