<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1 ВС2 ИС6" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ВС2="http://пф.рф/ВС/типы/2017-10-23"
    xmlns:ns1="http://пф.рф/СЗВ-КОРР-ПФР/2022-09-10" xmlns:ИС6="http://пф.рф/ВС/ИС/2022-09-10"> 
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
    <xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:СЗВ-КОРР-ПФР"/>
    
        <div class="afWrap pfrAfSZV-KORR-PFR">
            <p class="afInterval"/>
            <p class="afP afValue">Форма СЗВ-КОРР-ПФР</p>
            <p class="afInterval"/>
            <p class="afValue afP">Данные СФР о корректировке сведений, учтенных на индивидуальном лицевом счете застрахованного лица</p>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afCol-6-10">
                    <div class="afC">Отчетный период, за который корректируются данные &#160;</div>
                    <div class="afCol-1-6 afFrame">
						&#160;<xsl:value-of select="$vForm/ns1:КорректируемыйПериод/ns1:ОтчетныйПериод/ns1:Код"/>
						&#160;-&#160;
						<xsl:value-of select="$vForm/ns1:КорректируемыйПериод/ns1:ОтчетныйПериод/ns1:Год"/>&#160;
                    </div>
                </div> 
                 <div class="afCol-4-10">
                    <div class="afC afCol-5-10">Тип сведений &#160;&#160;</div>
                    <div class="afC afCol-4-10 afFrame afCenterBlock">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:Тип[text() = '0']">корректирующая</xsl:when>
							<xsl:when test="$vForm/ns1:Тип[text() = '1']">отменяющая</xsl:when>
							<xsl:when test="$vForm/ns1:Тип[text() = '2']">особая</xsl:when>
						</xsl:choose>
                    </div>
                </div>
            </div>
            <p class="afInterval"/>
            <p class="afValue afP">1. Сведения о территориальном органе СФР, документе основании, страхователе</p>
            <p class="afValue afP">Сведения о ТО СФР</p>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">Наименование</div>
                <div class="afMarginLeft130 afValue afUnderlinedBlock">
                    <xsl:value-of select="$vForm/ns1:ТОПФР/УТ2:Наименование"/>
                </div>
            </div>
            <xsl:variable name="vCode" select="$vForm/ns1:ТОПФР/УТ2:Код"/>
            <div class="afRow">
				<div class="afCol-10">
					<div class="afC">Код</div>
				</div> 
				<div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:ТОПФР/УТ2:Код, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:ТОПФР/УТ2:Код, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:ТОПФР/УТ2:Код, 3, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:ТОПФР/УТ2:Код, 4, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:ТОПФР/УТ2:Код, 5, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:ТОПФР/УТ2:Код, 6, 1)" /></td>
						</tr>
					</table>
				</div>
			</div>
			<p class="afValue afP">Документ основание</p>
			<div class="afRow">
				<div class="afCol-10">
					<div class="afC">Тип</div>
				</div> 
				<div class="afCol-1-2 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:ДокументОснование/ns1:Тип"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-10">
					<div class="afC">Дата</div>
				</div> 
				<div class="afCol-1-2 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:ДокументОснование/ns1:Реквизиты/УТ2:Дата"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-10">
					<div class="afC">Номер</div>
				</div> 
				<div class="afCol-1-2 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:ДокументОснование/ns1:Реквизиты/УТ2:Номер"/>
				</div>
			</div>
			
           <p class="afP afValue">1. Сведения о страхователе</p>
			<div class="afRow">
				<div class="afCol-3-10">
					<div class="afC">Регистрационный номер в СФР</div>
				</div>
				<div class="afC">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 3, 1)" /></td>
							<td>&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 5, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 6, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 7, 1)" /></td>
							<td>&#160;</td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 9, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 10, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 11, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 12, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 13, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:РегНомер, 14, 1)" /></td>
						</tr>
					</table>
				</div>
			</div>	
			<div class="afRow">
				<div class="afCol-3-10">
					<div class="afC">ИНН</div>
				</div>
				<div class="afC">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 3, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 4, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 5, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 6, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 7, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 8, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 9, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 10, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 11, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:ИНН, 12, 1)" /></td>
						</tr>
					</table>
				</div>
			</div>					
			<div class="afRow">
				<div class="afCol-3-10">
					<div class="afC">КПП</div>
				</div>
				<div class="afC">
					<table class="afTableCollapse">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП">
								<tr>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 1, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 2, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 3, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 4, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 5, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 6, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 7, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 8, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КорректируемыйПериод/ns1:Страхователь/УТ2:КПП, 9, 1)" /></td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
									<td class="afCheckSmall">&#160;</td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
			</div>
			<div class="afRow">
                <div class="afC">Наименование </div>
                <div class="afMarginLeft130 afValue afUnderlinedBlock">
                    <xsl:value-of select="$vForm/ns1:КорректируемыйПериод/ns1:Страхователь/ns1:Наименование"/>
                </div>
            </div>
			
			
			<p class="afP afValue">2. Сведения о застрахованном лице</p>
				<table class="afTable afTable100 afSmallSize">
					<tr class="afCenter">
						<td>Фамилия</td>
						<td>Имя</td>
						<td>Отчество</td>
						<td>СНИЛС</td>
					</tr>
					<tr class="afCenter afHeightRow afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
					</tr>
					
					<tr>
						<td>
							<xsl:value-of select="$vForm/ns1:ЗЛ/ns1:ФИО/УТ2:Фамилия"/>
						</td>
						<td>
							<xsl:value-of select="$vForm/ns1:ЗЛ/ns1:ФИО/УТ2:Имя"/>
						</td>
						<td>
							<xsl:value-of select="$vForm/ns1:ЗЛ/ns1:ФИО/УТ2:Отчество"/>
						</td>
						<td>
							<xsl:value-of select="$vForm/ns1:ЗЛ/ns1:СНИЛС"/>
						</td>
					</tr>
				</table>
				<p class="afInterval"/>
				<xsl:if test="$vForm/ns1:ДанныеЗЛ">
					<p class="afP afValue">3. Сведения о корректировке данных</p>
					<table class="afTable afTable100 afSmallSize">
						<tr class="afCenter">
							<td>Код категории застрахованного лица</td>
							<td>Тип договора</td>
							<td>Номер договора</td>
							<td>Дата заключения договора</td>
							<td>Код дополнительного тарифа</td>
						</tr>
						<tr class="afCenter afHeightRow afSmallSize">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
						</tr>
						<tr>
							<td>
								<xsl:value-of select="$vForm/ns1:ДанныеЗЛ/ns1:Категория"/>
							</td>
							<td>
								<xsl:call-template name="TypeContract">
									<xsl:with-param name="pTypeContract" select="$vForm/ns1:ДанныеЗЛ/ns1:Договор/ns1:Тип"/>
								</xsl:call-template>
							</td>
							<td>
								<xsl:value-of select="$vForm/ns1:ДанныеЗЛ/ns1:Договор/ns1:Реквизиты/УТ2:Номер"/>
							</td>
							<td>
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$vForm/ns1:ДанныеЗЛ/ns1:Договор/ns1:Реквизиты/УТ2:Дата"/>
									</xsl:with-param>
								</xsl:call-template>
							</td>
							<td>
								<xsl:value-of select="$vForm/ns1:ДанныеЗЛ/ns1:КодДТ"/>
							</td>
						</tr>	
					</table>
					<p class="afInterval"/>	
				</xsl:if>	
				
				
				<xsl:if test="$vForm/ns1:Суммы">
					<div class="afNoBreakInside afLineHeight-80">
						<p class="afP afValue">4. Сведения о корректировке данных о заработке (вознаграждении), доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах</p>
						<table class="afTable afTable100 afTableSmallSize">
							<tr class="afCenter">
								<td colspan="6">Сведения о корректировке данных о заработке (вознаграждении), доходе, сумме выплат и иных вознаграждений, начисленных в пользу застрахованного лица</td>
								<td colspan="5">Сведения о доначисленных страховых взносах</td>
								<td colspan="2" rowspan="2">Сведения о доначисленных страховых взносах</td>
							</tr>
							<tr class="afCenter">
								<td rowspan="3" class="afOverflowWordBreak">Код месяца, сумма выплат за который корректируется</td>
								<td rowspan="3">Сумма выплат, всего, руб. коп.</td>
								<td colspan="4">в том числе</td>
								<td colspan="2">За периоды по 2001 г. включительно</td>
								<td colspan="2">За периоды с 2002 г.</td>
								<td rowspan="3">По тарифу страховых взносов на сумму выплат и иных вознаграждений, входящих в базу, не превышающую предельную</td>
							</tr>
							<tr class="afCenter">
								<td colspan="2">на которую начислены страховые взносы, входящая в базу для начисления страховых взносов, не превышающую предельную</td>
								<td colspan="2">Входящая в базу для начисления страховых взносов, превышающую предельную</td>
								<td rowspan="2">Уплачиваемые страхователем</td>
								<td rowspan="2">Уплачиваемые из заработка ЗЛ</td>
								<td rowspan="2" class="afOverflowWordBreak">На страховую пенсию</td>
								<td rowspan="2" class="afOverflowWordBreak">На накопительную пенсию</td>
								<td rowspan="2" class="afOverflowWordBreak">На страховую пенсию</td>
								<td rowspan="2" class="afOverflowWordBreak">На накопительную пенсию</td>
							</tr>
							<tr class="afCenter">
								<td>всего:</td>
								<td>В том числе по гражданско-правовым договорам</td>
								<td>всего:</td>
								<td>В том числе по гражданско-правовым договорам</td>
							</tr>
							<tr class="afCenter afHeightRow afSmallSize">
								<td>1</td>
								<td>2</td>
								<td>3</td>
								<td>4</td>
								<td>5</td>
								<td>6</td>
								<td>7</td>
								<td>8</td>
								<td>9</td>
								<td>10</td>
								<td>11</td>
								<td>12</td>
								<td>13</td>
							</tr>
							<xsl:for-each select="$vForm/ns1:Суммы">
								<tr>
									<td>
										<xsl:value-of select="./ns1:Месяц"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:СуммаВыплат"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:НеПревышающие/ns1:Всего"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:НеПревышающие/ns1:ПоГПД"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:Превышающие/ns1:Всего"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:Выплаты/ns1:Превышающие/ns1:ПоГПД"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:СВстрахователя"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:СВизЗаработка"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:Накопительная"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоначисленоСВ/ns1:СВпоТарифу"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоУплачено/ns1:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="./ns1:ДоУплачено/ns1:Накопительная"/>
									</td>
								</tr>
							</xsl:for-each>	
						</table>
					</div>
				</xsl:if>
			
			
			
				<xsl:if test="$vForm/ns1:СтажевыйПериод">
					<div class="afNoBreakInside afLineHeight-80">
						<p class="afInterval"/>
						<p class="afP afValue">5. Сведения о корректировке периодов работы застрахованного лица</p>
						<table class="afTable afTable100 afTableSmallSize">
							<tr class="afCenter">
								<td rowspan="2">Начало периода с (дд.мм.гггг)</td>
								<td rowspan="2">Конец периода по (дд.мм.гггг)</td>
								<td colspan="2">Территориальные условия</td>
								<td rowspan="2">Особые условия труда (код)</td>
								<td colspan="2">Исчисление страхового стажа</td>
								<td colspan="2">Условия досрочного назначения страховой пенсии</td>
								<td rowspan="2" class="afOverflowWordBreak">Сведения об увольнении застрахованного лица/сведения о периодах, засчитываемых в страховой стаж безработным</td>
								<td colspan="2">Результат специальной оценки условий труда</td>
							</tr>
							<tr class="afCenter">
								<td>Код</td>
								<td class="afOverflowWordBreak">Районный коэффициент</td>
								<td>Основание (код)</td>
								<td>Дополнительные сведения</td>
								<td>Основание (код)</td>
								<td>Дополнительные сведения</td>
								<td class="afOverflowWordBreak">Индивидуальный номер рабочего места</td>
								<td class="afOverflowWordBreak">Класс (подкласс) условий труда</td>
							</tr>
							<tr class="afCenter afHeightRow afSmallSize">
								<td>1</td>
								<td>2</td>
								<td>3</td>
								<td>4</td>
								<td>5</td>
								<td>6</td>
								<td>7</td>
								<td>8</td>
								<td>9</td>
								<td>10</td>
								<td>11</td>
								<td>12</td>
							</tr>
							
							<xsl:for-each select="$vForm/ns1:СтажевыйПериод">
								<tr>
									<td>
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="./ИС6:Период/УТ2:С"/>
											</xsl:with-param>
										</xsl:call-template>
									</td>
									<td>
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate">
												<xsl:value-of select="./ИС6:Период/УТ2:По"/>
											</xsl:with-param>
										</xsl:call-template>
									</td>
									
									
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="concat(./ИС6:ТУ/ИС6:Основание, ' ', ./ИС6:ТУ/ИС6:ДоляСтавки)"/>
											</p>
										</xsl:for-each>
									</td><td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="./ИС6:ТУ/ИС6:Коэффициент"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="concat(./ИС6:ОУТ/ИС6:Код, ' ', ./ИС6:ОУТ/ИС6:ПозицияСписка)"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="./ИС6:ИС/ИС6:Основание"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:call-template name="УТ2:ProductionStr">
													<xsl:with-param name="pProduction" select="./ИС6:ИС"/>
												</xsl:call-template>
												<xsl:value-of select="./ИС6:ДопСведенияИС"/>
											</p>
										</xsl:for-each>	
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="./ИС6:ВЛ/ИС6:Основание"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:call-template name="УТ2:ProductionStr">
													<xsl:with-param name="pProduction" select="./ИС6:ВЛ"/>
												</xsl:call-template>
												<xsl:value-of select="./ИС6:ВЛ/ИС6:ДоляСтавки"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<p class="afP">
											<xsl:value-of select="./ns1:КатегорияЗЛ"/>
										</p>
										<p class="afP">
											<xsl:call-template name="DateShortStr">
												<xsl:with-param name="pDate">
													<xsl:value-of select="ns1:ДатаУвольнения"/>
												</xsl:with-param>
											</xsl:call-template>
										</p>
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="./ИС6:СОУТ/ИС6:Номер"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="./ИС6:ЛьготныйСтаж">
											<p class="afP">
												<xsl:value-of select="./ИС6:СОУТ/ИС6:Код"/>
											</p>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						
						</table>
					</div>
				</xsl:if>
            

                <p class="afInterval"/>
              
                <div class="afSign">
                    <div class="afPadding">
                        <p class="afUnderlinedBlock afValue afCenterBlock">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ДатаЗаполненияДокумента"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </p>
                        <p class="afP afCenterBlock">Дата (дд.мм.гггг)</p>
                    </div>
                    <div class="afPadding"></div>
                    <div class="afPadding"></div>
                </div>
            
        </div>
        
    </xsl:template>

    <xsl:template name="TypeContract">
        <xsl:param name="pTypeContract"/>
        <xsl:choose>
            <xsl:when test="$pTypeContract = '1'">трудовой</xsl:when>
            <xsl:when test="$pTypeContract = '2'">гражданско-правовой</xsl:when>
        </xsl:choose>
    </xsl:template>

   

    <!-- Выработка -->
    
    <xsl:template name="УТ2:ProductionStr">
		<xsl:param name="pProduction"/>
		<xsl:if test="$pProduction">
			<xsl:choose>
				<xsl:when test="$pProduction/ВС2:ВыработкаВчасах">
					<xsl:if test="$pProduction/ВС2:ВыработкаВчасах/ВС2:Часы"><xsl:value-of select="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы"/> ч.&#160;</xsl:if>
					<xsl:if test="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты"><xsl:value-of select="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты"/> мин.&#160;</xsl:if>	
				</xsl:when>
				<xsl:when test="$pProduction/ВС2:ВыработкаКалендарная">
					<xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы"><xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы"/> мес.&#160;</xsl:if>
					<xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни"><xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни"/> д.&#160; </xsl:if>
				</xsl:when>
			</xsl:choose>	
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
