<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/ДСВ-3/2022-10-28">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
        <div class="afWrap pfrAfDsv-3">

            <p class="afC afUnderline">Форма ДСВ-3</p>
            <p class="afInterval"/>
            <p class="afCenter afHeader">Реестр застрахованных лиц,</p>
            <p class="afCenter afHeader">за которых перечислены дополнительные страховые взносы</p>
            <p class="afCenter afHeader">на накопительную пенсию и уплачены взносы работодателя</p>
            
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afCol-3-4">Реквизиты работодателя, передающего реестр застрахованных лиц:</div>
            </div>
            <div class="afRow">
                <div class="afCol-3-4">
                    <div class="afCol-4-10">Регистрационный номер СФР</div>
                    <div class="afCol-6-10 afValue afUnderlinedBlock">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:Страхователь/УТ2:РегНомер"/>
                    </div>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-3-4">
                    <div class="afCol-6">ИНН</div>
                    <div class="afCol-3-8 afValue afUnderlinedBlock">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:Страхователь/УТ2:ИНН"/>
                    </div>
                    <div class="afCol-6">КПП</div>
                    <div class="afCol-1-2 afValue afUnderlinedBlock">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:Страхователь/УТ2:КПП"/>
                    </div>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-3-4">
                    <div class="afCol-1-2">Наименование организации (краткое)</div>
                    <div class="afCol-1-2 afValue afUnderlinedBlock">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:Страхователь/УТ2:НаименованиеКраткое"/>
                    </div>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-3-4">
                    <div class="afCol-1-3">Платежное поручение №</div>
                    <div class="afCol-1-8 afValue afUnderlinedBlock">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:ПП/ns1:Номер"/>
                    </div>
                    <div class="afCol-6 afCenterBlock">от</div>
                    <div class="afCol-45 afValue afUnderlinedBlock">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:ПП/ns1:Дата"/>
                        </xsl:call-template>
                    </div>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-3-4">
                    <div class="afCol-1-2">Дата исполнения платежного поручения</div>
                    <div class="afCol-1-2 afValue afUnderlinedBlock">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate">
                                <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:ПП/ns1:ДатаИсполнения"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </div>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-3-4">
                    <div class="afCol-1-5">Период уплаты</div>
                    <div class="afCol-1-5 afValue afUnderlinedBlock">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:Год"/>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            <table class="afTable afNoBreakInside">
                <tr>
                    <td class="afCenter">№ п/п</td>
                    <td class="afCenter">Ф.И.О. застрахованного лица</td>
                    <td class="afCenter">Страховой номер индивидуального лицевого счета застрахованного лица (СНИЛС)</td>
                    <td class="afCenter">Сумма перечисленных дополнительных страховых взносов на накопительную пенсию (руб.)</td>
                    <td class="afCenter">Сумма уплаченных взносов работодателя (в случае уплаты) (руб.)</td>
                </tr>
                <tr>
                    <td class="afCenter">1</td>
                    <td class="afCenter">2</td>
                    <td class="afCenter">3</td>
                    <td class="afCenter">4</td>
                    <td class="afCenter">5</td>
                </tr>
                <xsl:for-each select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:РеестрДСВ/ns1:ДСВ_ЗЛ">
                    <tr>
                        <td class="afCenterBlock">
                            <xsl:value-of select="position()"/>
                        </td>
                        <td>
                            <xsl:call-template name="УТ2:NameStr">
                                <xsl:with-param name="pName" select="./УТ2:ФИО" />
                            </xsl:call-template>
                        </td>
                        <td>
                            <xsl:value-of select="./УТ2:СНИЛС"/>
                        </td>
                        <td class="afAlignRight">
                            <xsl:choose>
                                <xsl:when test="./ns1:СуммаДСВРаботника">
                                    <xsl:value-of select="./ns1:СуммаДСВРаботника"/>
                                </xsl:when>
                                <xsl:otherwise>&#160;</xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td class="afAlignRight">
                            <xsl:choose>
                                <xsl:when test="./ns1:СуммаВзносовРаботодателя">
                                    <xsl:value-of select="./ns1:СуммаВзносовРаботодателя"/>
                                </xsl:when>
                                <xsl:otherwise>&#160;</xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </xsl:for-each>
                <tr>
                    <td>Всего:</td>
                    <td>-</td>
                    <td>-</td>
                    <td>&#160;</td>
                    <td>&#160;</td>
                </tr>
            </table>
            
            <p class="afInterval" />
            <div class="afRow">
                <div class="afCol-3-4">
                    Общая сумма перечисленных средств составляет <span class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:ПП/ns1:Сумма"/></span> рублей
                </div>
            </div>
            
            <p class="afInterval" />
            <p class="afInterval" />
            <div class="afRow">
                <div class="afCol-2-5">Главный бухгалтер</div>
                <div class="afCol-1-5">
                    <p class="afUnderlinedBlock">&#160;</p>
                    <p class="afCenter afSubscript">(подпись)</p>
                </div>
                <div class="afCol-10">&#160;</div>
                <div class="afCol-3-10">
                    <p class="afUnderlinedBlock">&#160;</p>
                    <p class="afCenter afSubscript">(расшифровка подписи)</p>
                </div>
            </div>
            
            <p class="afInterval" />
            <div class="afRow">
                <div class="afCol-2-5">
                    <p class="afUnderlinedBlock">&#160;</p>
                    <p class="afCenter afSubscript">(наименование должности руководителя)</p>
                </div>
                <div class="afCol-1-5">
                    <p class="afUnderlinedBlock">&#160;</p>
                    <p class="afCenter afSubscript">(подпись)</p>
                </div>
                <div class="afCol-10">&#160;</div>
                <div class="afCol-3-10">
                    <p class="afUnderlinedBlock">&#160;</p>
                    <p class="afCenter afSubscript">(расшифровка подписи)</p>
                </div>
            </div>
            
            <p class="afInterval" />
            <div class="afRow">
                <div class="afCol-10 afAlignRight">Дата</div>
                <div class="afCol-1-5 afValue afCenterBlock">
                    <xsl:call-template name="DateShortStr">
                        <xsl:with-param name="pDate">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ДСВ-3/ns1:ДатаЗаполнения"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </div>
                <div class="afCol-2-5">&#160;</div>
                <div class="afCol-3-10 afAlignLeft">М.П.</div>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
