<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/СЗВ-ДСО/2022-07-08"> 
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:template match="/" name="inc">
        <div class="afWrap pfrAfSZV-DSO">
			<xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:СЗВ-ДСО"/>
        	<p class="afRight-1-5 afSubscriptNormal afLineHeight1-2">Утверждена приказом СФР<br/>от _________________ <br/>№ _______
            </p>
            <p class="afInterval"/>
        	<p class="afP afSubscriptNormal">Форма СЗВ-ДСО</p>
            <p class="afInterval"/>
        	<p class="afValue afP afCenterBlock">Сведения о периодах работы, дающей право на ежемесячную доплату к пенсии, и сумме заработка,<br/>из которого исчисляется размер ежемесячной доплаты к пенсии застрахованного лица (СЗВ-ДСО)</p>
            <p class="afInterval"/>
            <p class="afValue afP">Сведения о страхователе:</p>
            <div class="afRow">
            	<div class="afC afNoSideMargin">Страхователь (наименование)</div>
                <div class="afMarginLeft200 afValue afUnderlinedBlock">
                    <xsl:value-of select="$vForm/ns1:Работодатель/ns1:НаименованиеОрганизации"/>
                </div>
            </div>
            <p class="afInterval"/>
            <!--xsl:variable name="RegNum1" select="$vForm/ns1:Работодатель/ns1:РегНомер"/-->
            <div class="afRow">
				<div class="afC afCol-7-20">Регистрационный номер</div>
            	<div class="afMarginLeft180 afValue afUnderlinedBlock">
            		<xsl:value-of select="$vForm/ns1:Работодатель/ns1:РегНомер"/>
            	</div>
				<!--div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<xsl:choose>
								<xsl:when test="string-length($RegNum1) = 10">
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 1, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 2, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 3, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 4, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 5, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 6, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 7, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 8, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 9, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 10, 1)" /></td>
								</xsl:when>
								<xsl:otherwise>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 1, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 2, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 3, 1)" /></td>
									<td>&#160;-&#160;</td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 5, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 6, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 7, 1)" /></td>
									<td>&#160;-&#160;</td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 9, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 10, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 11, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 12, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 13, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum1, 14, 1)" /></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</table>
				</div-->
			</div>
            <xsl:variable name="NumINN1" select="$vForm/ns1:Работодатель/УТ2:ИНН"/>
            <xsl:variable name="NumKPP1" select="$vForm/ns1:Работодатель/УТ2:КПП"/>
            <div class="afRow">
            	<div class="afCol-1-20">ИНН</div> 
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 9, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 10, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 11, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN1, 12, 1)" /></td>
                        </tr>
                    </table>
                </div>
            	<div class="afCol-1-20">КПП</div>
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP1, 9, 1)" /></td>
                        </tr>
                    </table>
                </div>
            </div>
            <p class="afInterval"/>
           
           
           
            <p class="afValue afP">Сведения о страхователе, за которого представляются сведения:</p>
            <div class="afRow">
            	<div class="afC afCol-7-20">Страхователь (наименование)</div>
                <div class="afMarginLeft200 afValue afUnderlinedBlock">
                    <xsl:value-of select="$vForm/ns1:РаботодательЗаКоторого/ns1:НаименованиеОрганизации"/>
                </div>
            </div>

            <p class="afInterval"/>
            <!--sl:variable name="RegNum2" select="$vForm/ns1:РаботодательЗаКоторого/ns1:РегНомер"/-->
            <div class="afRow">
				<div class="afC afCol-7-20">Регистрационный номер</div>
            	<div class="afMarginLeft180 afValue afUnderlinedBlock">
            		<xsl:value-of select="$vForm/ns1:РаботодательЗаКоторого/ns1:РегНомер"/>
            	</div>
				<!--div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<xsl:choose>
								<xsl:when test="string-length($RegNum2) = 10">
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 1, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 2, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 3, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 4, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 5, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 6, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 7, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 8, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 9, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 10, 1)" /></td>
								</xsl:when>
								<xsl:otherwise>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 1, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 2, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 3, 1)" /></td>
									<td>&#160;-&#160;</td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 5, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 6, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 7, 1)" /></td>
									<td>&#160;-&#160;</td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 9, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 10, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 11, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 12, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 13, 1)" /></td>
									<td class="afCheckSmall"><xsl:value-of select="substring($RegNum2, 14, 1)" /></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</table>
				</div-->
			</div>
            <xsl:variable name="NumINN2" select="$vForm/ns1:РаботодательЗаКоторого/УТ2:ИНН"/>
            <xsl:variable name="NumKPP2" select="$vForm/ns1:РаботодательЗаКоторого/УТ2:КПП"/>
            <div class="afRow">
            	<div class="afCol-1-20">ИНН</div> 
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 9, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 10, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 11, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumINN2, 12, 1)" /></td>
                        </tr>
                    </table>
                </div>
            	<div class="afCol-1-20">КПП</div>
                <div class="afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 1, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 2, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 3, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 4, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 5, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 6, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 7, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 8, 1)" /></td>
                            <td class="afCheckSmall"><xsl:value-of select="substring($NumKPP2, 9, 1)" /></td>
                        </tr>
                    </table>
                </div>
            </div>
            <p class="afInterval"/>
           
           
            <div class="afRow">
            	<div class="afCol-1-5">
                    <div class="afC afValue">Отчетный период:</div>  
                </div>
            	<div class="afCol-1-6">
                    <div class="afC">Календарный год</div>
                </div>
				<div class="afCol-1-10-1">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:Год, 1, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:Год, 2, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:Год, 3, 1)" /></td>
							<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:Год, 4, 1)" /></td>
						</tr>
					</table>
				</div>
            	<div class="afCol-7-20">
            		<div class="afC">Корректируемый (отменяемый) период:</div>
            	</div>
            	<div class="afCol-1-10-1">
            		<table class="afTableCollapse afMarginLeft5">
            			<tr>
            				<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КоррОтмПериод, 1, 1)" /></td>
            				<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КоррОтмПериод, 2, 1)" /></td>
            				<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КоррОтмПериод, 3, 1)" /></td>
            				<td class="afCheckSmall"><xsl:value-of select="substring($vForm/ns1:КоррОтмПериод, 4, 1)" /></td>
            			</tr>
            		</table>
            	</div>
            	<div class="afC">год</div>
            </div>
            
            <div class="afRow">
                <div class="afCol-3-20">
                    <div class="afC afValue">Тип сведений:</div>  
                </div>
                <div class="afCol-3-20">
                    <div class="afC">Исходная</div>
                    <div class="afCol-1-8 afCheck afValue">
						<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ИСХД']">V</xsl:if>
					</div>
                </div>
                <div class="afCol-1-5">
                    <div class="afC">Корректирующая</div>
                    <div class="afCol-1-10-1 afCheck afValue">
						<xsl:if test="$vForm/ns1:ТипСведений[text() = 'КОРР']">V</xsl:if>
					</div>
                </div>
                <div class="afCol-1-6">
                    <div class="afC">Отменяющая</div>
                    <div class="afCol-1-9 afCheck afValue">
						<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ОТМН']">V</xsl:if>
					</div>
                </div>
                <div class="afCol-1-3">
                    <div class="afC">Назначение доплаты к пенсии</div>
                    <div class="afCol-6 afCheck afValue">
						<xsl:if test="$vForm/ns1:ТипСведений[text() = 'ПЕНС']">V</xsl:if>
					</div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <xsl:for-each select="$vForm/ns1:ЗЛ">
				<div class="afNoBreakInside">
					<p class="afValue afP">Сведения о застрахованном лице:</p>
					<div class="afRow">
						<div class="afCol2-1-2">
							<div class="afC afNoSideMargin">СНИЛС</div>
							<div class="afUnderlinedBlock afValue afMarginLeft50">
								<xsl:value-of select="УТ2:СНИЛС"/>
							</div>
						</div>
						<div class="afCol-4">&#160;</div>
						<div class="afCol2-1-2">
							<div class="afC">Имя</div>
							<div class="afUnderlinedBlock afValue afMarginLeft40">
								<xsl:value-of select="УТ2:ФИО/УТ2:Имя"/>
							</div>
						</div>
					</div>
            
					<div class="afRow">
						<div class="afCol2-1-2">
							<div class="afC afNoSideMargin">Фамилия</div>
							<div class="afUnderlinedBlock afValue afMarginLeft70">
								<xsl:value-of select="УТ2:ФИО/УТ2:Фамилия"/>
							</div>
						</div>
						<div class="afCol-4">&#160;</div>
						<div class="afCol2-1-2">
							<div class="afC">Отчество (при наличии)</div>
							<div class="afUnderlinedBlock afValue afMarginLeft150">
								<xsl:value-of select="УТ2:ФИО/УТ2:Отчество"/>
							</div>
						</div>
					</div>
				
					<div class="afRow">
						<div class="afCol-1-7">
							<div class="afC afValue afNoSideMargin">Код ДСО:</div>  
						</div>
						<div class="afValue">
							<div class="afCol-1-10-1">
								<table class="afTableCollapse">
									<tr>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КодДСО, 1, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КодДСО, 2, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КодДСО, 3, 1)" /></td>
										<td class="afCheckSmall"><xsl:value-of select="substring(ns1:КодДСО, 4, 1)" /></td>
									</tr>
								</table>
							</div>
						</div>
					</div>
					<p class="afInterval"/>
					<p class="afInterval"/>
				
				
					<xsl:choose>
						<xsl:when test="ns1:ПериодыДСО/ns1:ДСОЛ">
							<p class="afValue afCenter afP">Сведения о периодах работы, засчитываемых в выслугу лет для установления ежемесячной доплаты к пенсии в соответствии с Федеральным законом от 27 ноября 2001 г. № 155-ФЗ «О дополнительном социальном обеспечении членов летных экипажей воздушных судов гражданской авиации»:</p>
							<table class="afTable afTable100 afSmallSize">
								<thead>
									<tr class="afCenter">
										<td rowspan="3" class="afTable4">№ п/п</td>
										<td colspan="6">Период работы</td>
									</tr>
									<tr class="afCenter">
										<td colspan="3" class="afTable48">по пп. «а» пункта 5 Правил исчисления выслуги лет, дающей право на ежемесячную доплату к пенсии, утвержденных постановлением Правительства Российской Федерации<br/>от 14 марта 2003 г. № 155<sup class="afSup">1</sup></td>
										<td colspan="3" class="afTable48">по пп. «б» пункта 5 Правил исчисления выслуги лет, дающей право на ежемесячную доплату к пенсии, утвержденных постановлением Правительства Российской Федерациии<br/>от 14 марта 2003 г. № 155<sup class="afSup">1</sup></td>
									</tr>
									<tr class="afCenter">
										<td>с дд.мм.гггг</td>
										<td>по дд.мм.гггг</td>
										<td>налет часов, час. мин.</td>
										<td>по дд.мм.гггг</td>
										<td>с дд.мм.гггг</td>
										<td>налет часов, час. мин.</td>	
									</tr>
									<tr class="afCenter">
										<td>1</td>
										<td>2</td>
										<td>3</td>
										<td>4</td>
										<td>5</td>
										<td>6</td>
										<td>7</td>	
									</tr>
								</thead>
								<tbody class="afCenter">
									<xsl:for-each select="ns1:ПериодыДСО/ns1:ДСОЛ">
										<xsl:choose>
											<xsl:when test="ns1:ПодпунктА">
												<tr>
													<td><xsl:value-of select="position()"/></td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:ПодпунктА/ns1:Период/УТ2:С"/>
														</xsl:call-template>	
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:ПодпунктА/ns1:Период/УТ2:По"/>
														</xsl:call-template>
													</td>
													<td>
														<xsl:value-of select="ns1:ПодпунктА/ns1:Налет/ns1:Часы"/> ч. 
														<xsl:value-of select="ns1:ПодпунктА/ns1:Налет/ns1:Минуты"/> мин.
													</td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>&#160;</td>
												</tr>
											</xsl:when>
											
											<xsl:when test="ns1:ПодпунктБ">
												<tr>
													<td><xsl:value-of select="position()"/></td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:ПодпунктБ/ns1:Период/УТ2:С"/>
														</xsl:call-template>	
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:ПодпунктБ/ns1:Период/УТ2:По"/>
														</xsl:call-template>
													</td>
													<td>
														<xsl:value-of select="ns1:ПодпунктБ/ns1:Налет/ns1:Часы"/> ч. 
														<xsl:value-of select="ns1:ПодпунктБ/ns1:Налет/ns1:Минуты"/> мин.
													</td>
												</tr>
											</xsl:when>
										</xsl:choose>	
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:when>
						<xsl:when test="ns1:ПериодыДСО/ns1:ДСОУ">
							<p class="afValue afCenter afP">Сведения о периодах работы, включаемой в стаж, дающей право на ежемесячную доплату к пенсии в соответствии с Федеральным законом от 10 мая 2010 г. № 84-ФЗ «О дополнительном социальном обеспечении отдельных категорий работников организаций угольной промышленности»<sup class="afSup">2</sup>:</p>
							<table class="afTable afTable100 afSmallSize">
								<thead>
									<tr class="afCenter">
										<td rowspan="3" class="afTable4">№ п/п</td>
										<td colspan="6">Период работы</td>
									</tr>
									<tr class="afCenter">
										<td colspan="2">в ведущих профессиях, указанных в статье 1 Федерального закона от 10 мая 2010 г. № 84-ФЗ</td>
										<td colspan="2">в неведущих профессиях, предусмотренных списком работ и профессий, утвержденным постановлением Совета Министров РСФСР от 13 сентября 1991 г. № 481<sup class="afSup">3</sup></td>
										<td colspan="2">по Списку № 1 (раздел I «Горные работы», подраздел 1, пункты «а», «б», «г» «д», «е»), утвержденному постановлением Кабинета Министров СССР от 26 января 1991 г. № 10<sup class="afSup">4</sup></td>
									</tr>
									<tr class="afCenter">
										<td>с дд.мм.гггг</td>
										<td>по дд.мм.гггг</td>
										<td>с дд.мм.гггг</td>
										<td>по дд.мм.гггг</td>
										<td>с дд.мм.гггг</td>
										<td>по дд.мм.гггг</td>	
									</tr>
									<tr class="afCenter">
										<td>1</td>
										<td>2</td>
										<td>3</td>
										<td>4</td>
										<td>5</td>
										<td>6</td>
										<td>7</td>	
									</tr>
								</thead>
								<tbody class="afCenter">
									<xsl:for-each select="ns1:ПериодыДСО/ns1:ДСОУ">
										<xsl:choose>
											<xsl:when test="ns1:Ведущая">
												<tr>
													<td><xsl:value-of select="position()"/></td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:Ведущая/УТ2:С"/>
														</xsl:call-template>	
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:Ведущая/УТ2:По"/>
														</xsl:call-template>
													</td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>&#160;</td>
												</tr>
											</xsl:when>
											<xsl:when test="ns1:Неведущая">
												<tr>
													<td><xsl:value-of select="position()"/></td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:Неведущая/УТ2:С"/>
														</xsl:call-template>	
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:Неведущая/УТ2:По"/>
														</xsl:call-template>
													</td>
													<td>&#160;</td>
													<td>&#160;</td>
												</tr>
											</xsl:when>
											<xsl:when test="ns1:ПоСписку">
												<tr>
													<td><xsl:value-of select="position()"/></td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>&#160;</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:ПоСписку/УТ2:С"/>
														</xsl:call-template>	
													</td>
													<td>
														<xsl:call-template name="Date2GOST">
															<xsl:with-param name="pDate" select="ns1:ПоСписку/УТ2:По"/>
														</xsl:call-template>
													</td>
												</tr>
											</xsl:when>
										</xsl:choose>	
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:when>
						
					</xsl:choose>
					
					<p class="afInterval"/><p class="afInterval"/>
					<p class="afValue afCenter afP">Сведения о сумме заработка, из которого исчисляется размер ежемесячной доплаты к пенсии:</p>
					<p class="afInterval"/>
					<table class="afTable afTable100 afSmallSize">
						<tr class="afCenter">
							<td>Месяц</td>
							<td>Сумма заработка, из которого исчисляется размер ежемесячной доплаты к пенсии, руб. коп.</td>
						</tr>
						<xsl:for-each select="ns1:СведенияОЗаработке/ns1:ЗаМесяц">
							<tr>
								<td>
									<xsl:call-template name="Month2TextNumbers">
										<xsl:with-param name="pMonth" select="ns1:Месяц"/>
									</xsl:call-template>
								</td>
								<td class="afCenter">
									<xsl:value-of select="floor(ns1:Сумма)"/> руб.
									<xsl:value-of select="format-number((ns1:Сумма - floor(ns1:Сумма))*100, '00')"/> коп.
								</td>
							</tr>
						</xsl:for-each>	
						<tr>
							<td class="afValue">Итого</td>
							<td class="afCenter">
								<xsl:value-of select="floor(ns1:СведенияОЗаработке/ns1:Итого)"/> руб.
								<xsl:value-of select="format-number((ns1:СведенияОЗаработке/ns1:Итого - floor(ns1:СведенияОЗаработке/ns1:Итого))*100, '00')"/> коп.
							</td>
						</tr>
					</table>
				</div>	
            </xsl:for-each>
            
        	
        	<div class="afNoBreakBefore afNoBreakInside ">
        		<p class="afInterval"/>
        		<p class="afInterval"/>
        		<div class="afRow">
        			<div class="afCol-45 afNoBreakInside">
						<span class="afC">&#160;</span>
						<div class="afUnderlinedBlock afValue">
							<xsl:value-of select="$vForm/ns1:Руководитель/УТ2:Должность"/>
						</div>
        				<span class="afSmallSize">Наименование должности руководителя<br/>(уполномоченного представителя страхователя)</span>
        				
					</div>
					<div class="afCol-4">&#160;</div>
        			<div class="afCol-51 afNoBreakInside">
        				<span class="afFloatLeft">Подпись</span>
						<div class="afUnderlinedBlock afValue afMarginLeft70">&#160;</div>
						<br/>
						<span>Расшифровка подписи<span class="afUnderline afValue">
						<xsl:call-template name="УТ2:NameStr">
                                <xsl:with-param name="pName" select="$vForm/ns1:Руководитель/УТ2:ФИО"/>
                            </xsl:call-template>
                            </span>
						</span>
					</div>
				</div>
        		<div class="afSign afP">
                    <div class="afPadding">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="$vForm/ns1:ДатаЗаполнения"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </div>
                    	<span class="afMarginLeft50">Дата (дд.мм.гггг)</span>
                    </div>
                    <div class="afPadding"></div>
                    <div class="afPadding">М.П. (при наличии)</div>
                </div>	
        		<div class="afTableSmallSize afLineHeight1">
        			<hr style="margin: 10px 0;
        				padding: 0;
        				height: 0;
        				border: none;
        				border-top: 1px solid #333;
        				width:40%;"/>
        			<p><span class="afSup">1</span>Постановление Правительства Российской Федерации от 14 марта 2003 г. № 155 «Об утверждении списка должностей членов летных экипажей воздушных судов гражданской авиации, работа в которых дает право на ежемесячную доплату к пенсии в соответствии с Федеральным законом «О дополнительном социальном обеспечении членов летных экипажей воздушных судов гражданской авиации», и правил исчисления выслуги лет, дающей право на ежемесячную доплату к пенсии» (далее - постановление Правительства Российской Федерации от 14 марта 2003 г. № 155).</p>
        			<p><span class="afSup">2</span>Далее - Федеральный закон от 10 мая 2010 г. № 84-ФЗ.</p>
        			<p><span class="afSup">3</span>Постановление Совета министров РСФСР от 13 сентября 1991 г. № 481 «Об утверждении списка работ и профессий, дающих право на пенсию за выслугу лет независимо от возраста при занятости на указанных работах не менее 25 лет».</p>
        			<p><span class="afSup">4</span>Постановление Кабинета Министров СССР от 26 января 1991 г. № 10 «Об утверждении списков производств, работ, профессий, должностей и показателей, дающих право на льготное пенсионное обеспечение».</p>
        		</div>
        	</div>
        	
        		
        	
        </div>

    </xsl:template>
</xsl:stylesheet>
