<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ ns1" version="1.0"
    xmlns:УТ="http://пф.рф/унифицированныеТипы/2014-01-01" xmlns:ns1="http://пф.рф/ВС/СЗВ-М/2017-01-01">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2014-01-01.xsl"/>
    <xsl:template match="/" name="inc">
        <div class="afWrap pfrAfSZV-M">
            <div class="afRow afRight-1-4 afAlignRight">УТВЕРЖДЕНА <br/> постановлением Правления ПФР <br/> от 15 апреля 2021г. № 103п</div>

            <h1 class="afCenter afHeader">Сведения о застрахованных лицах</h1>
            <p class="afInterval"/>
            <p class="afP">1. Реквизиты страхователя:</p>
            <div class="afRow">
                <div class="afC">Регистрационный номер в СФР</div>
                <div class="afCol-1-3 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:Страхователь/ns1:РегНомер"/>
                </div>
            </div>
            <div class="afRow">
                <div class="afC">Полное или сокращенное наименование</div>
                <div class="afCol-6-10 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:Страхователь/ns1:НаименованиеКраткое"/>
                </div>
            </div>
            <div class="afRow">
                <div class="afC afPadding">ИНН</div>
                <div class="afCol-1-3 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:Страхователь/ns1:ИНН"/>
                </div>
                <div class="afC afPadding">КПП</div>
                <xsl:choose>
                    <xsl:when test="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:Страхователь/ns1:КПП">
                        <div class="afCol-1-3 afValue afUnderlinedBlock">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:Страхователь/ns1:КПП"/>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <div class="afCol-1-3 afBlankUnderlinedBlock"/>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">2. Отчетный период</div>
                <div class="afCol-1-10 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:ОтчетныйПериод/ns1:Месяц"/>
                </div>
                <div class="afC">календарного года</div>
                <div class="afCol-1-10 afValue afUnderlinedBlock">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:ОтчетныйПериод/ns1:КалендарныйГод"/>
                </div>
            </div>
           
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">3. Тип формы (код)</div>
                <div class="afCol-1-4 afValue afUnderlinedBlock">
                    <xsl:call-template name="TypeForm">
                        <xsl:with-param name="pTypeForm" select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:ТипФормы"/>
                    </xsl:call-template>
                </div>
            </div>
             <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">4. Сведения о застрахованных лицах:</div>
            </div>
            <xsl:choose>
                <xsl:when test="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:СписокЗЛ/ns1:ЗЛ">
                    <p class="afInterval"/>
                    <xsl:if test="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:СписокЗЛ/ns1:ЗЛ">
                        <table class="afTable">
                            <thead class="afCenter">
                                <th>№ п/п</th>
                                <th>Фамилия, имя, отчество (при наличии) застрахованного лица </th>
                                <th>Страховой номер индивидуального лицевого счета</th>
                                <th>ИНН</th>
                            </thead>
                            <tbody>
                                <xsl:for-each select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:СписокЗЛ/ns1:ЗЛ">
                                    <tr>
                                        <td>
                                            <xsl:value-of select="position()"/>
                                        </td>
                                        <td>
                                            <xsl:call-template name="УТ:NameStr">
                                                <xsl:with-param name="pName" select="./ns1:ФИО"/>
                                            </xsl:call-template>
                                        </td>
                                        <td>
                                            <xsl:value-of select="./ns1:СНИЛС"/>
                                        </td>
                                        <td>
                                            <xsl:value-of select="./ns1:ИНН"/>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                        <p class="afInterval"/>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <p class="afParagraph">Отсутствуют.</p>
                    <p class="afInterval"/>
                </xsl:otherwise>
            </xsl:choose>
            <div class="afSign">
                <div class="afPadding">
                    <p class="afBlankUnderlinedBlock"/>
                    <p class="afSubscript afCenter">(Наименование должности руководителя)</p>
                </div>
                <div class="afPadding">
                    <p class="afBlankUnderlinedBlock"/>
                    <p class="afSubscript afCenter">(Подпись)</p>
                </div>
                <div class="afPadding">
                    <p class="afBlankUnderlinedBlock"/>
                    <p class="afSubscript afCenter">(Ф.И.О.)</p>
                </div>
            </div>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afCol-1-3">
                    <p class="afP afPadding">Дата <span class="afValue afPadding"><xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="/ns1:ЭДПФР/ns1:СЗВ-М/ns1:ДатаЗаполнения"/>
                                </xsl:with-param>
                            </xsl:call-template></span></p>
                    <p class="afP">(ДД.ММ.ГГГГ.)</p>
                </div>
                <div class="afCol-1-4">
                    <p class="afP afCenter">М.П.</p>
                    <p class="afP afCenter">(при ее наличии)</p>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template name="TypeForm">
        <xsl:param name="pTypeForm"/>
        <xsl:choose>
            <xsl:when test="$pTypeForm = '1'">исхд</xsl:when>
            <xsl:when test="$pTypeForm = '2'">доп</xsl:when>
            <xsl:when test="$pTypeForm = '3'">отмн</xsl:when>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
