<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ДС ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ДС="http://пф.рф/ВС/ДоСВ/типы/2019-05-24" xmlns:ns1="http://пф.рф/ЗОДСВ/2019-05-24">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            
            <div class="afRow">
                <div class="afRight-1-3">
                    <div class="afMarginLeft50 afValue">
                        <xsl:choose>
                            <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ТОПФР/УТ2:КодТОПФР">
                                <xsl:variable name="code" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ТОПФР/УТ2:КодТОПФР"/>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($code, 1, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($code, 2, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($code, 3, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($code, 4, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($code, 5, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($code, 6, 1)"/>&#160;
                                </div>
                            </xsl:when>
                            <xsl:otherwise>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                    <p class="afSubscript afCenter">(код территориального органа СФР)</p>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC">В</div>
                <div class="afMarginLeft50 afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ТОПФР/УТ2:Наименование"/>
                </div>
                <p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации и его код)</p>
            </div>
            
            <p class="afInterval"/>
            
            <h1 class="afHeader afCenter">Заявление</h1>
            <h1 class="afHeader afCenter">о добровольном вступлении в правоотношения</h1>
            <h1 class="afHeader afCenter">по обязательному пенсионному страхованию</h1>
            <p class="afInterval"/>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afParagraph afJustify">Добровольно вступаю в  правоотношения  по  обязательному  пенсионному страхованию   в соответствии подпунктом _<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Подпункт"/>_ &lt;1&gt; пункта 1 статьи 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации» и прошу зарегистрировать меня в качестве страхователя.</div>
            </div>
            
            <div class="afRow">
                <div class="afCenter">I. Сведения о заявителе</div>
            </div>
            
            <div class="afRow">
                <div class="afC">Фамилия, имя, отчество (при наличии)</div>
                <div class="afMarginLeft250 afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:NameStr">
                        <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:ФИО"/>
                    </xsl:call-template>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock"/>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-2">
                    <div class="afC">Дата рождения</div>
                    <div class="afCol-2-3">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:ДатаРождения"/>
                            </xsl:call-template>
                        </div>
                        <p class="afSubscript afCenter">(число, месяц, год)</p>
                    </div>
                </div>

             <div class="afCol-1-2">
                    <div class="afC">Место рождения</div>
                    <div class="afMarginLeft100">
                        <div class="afUnderlinedBlock afValue">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Город">
									<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Город"/>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район)"/>
									</xsl:if>
									 <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион or /ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">,</xsl:if>		
								</xsl:when>
								
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район">
									<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район"/>
									 <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион or /ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">,</xsl:if>		
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
                        </div>
                    </div>
                </div>
            </div>          
            <div class="afRow">
                <div class="afUnderlinedLeftBlock afValue">				
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион"/>
							<xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">
								<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна)"/>
							</xsl:if>		
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">
								<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
                </div>
            </div>
            <div class="afRow">
                <div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
                <div class="afCol-1-2">
                    <div class="afValue afMarginLeft100">
                        <xsl:choose>
                            <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:СНИЛС">
                                <xsl:variable name="snils" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:СНИЛС"/>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;&#160;&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                                </div>
                            </xsl:when>
                            <xsl:otherwise>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-2-3">
                    <div class="afCol-1-3">ИНН (при наличии)</div>
                    <div class="afCol-2-3">
                        <div class="afValue">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:ИНН">
                                    <xsl:variable name="inn" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:ИНН"/>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 1, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 2, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 3, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 4, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 5, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 6, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 7, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 8, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 9, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 10, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 11, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($inn, 12, 1)"/>&#160;
                                    </div>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </div>
                </div>
                <div class="afCol-1-3">
                    <div class="afCol-1-3">Код ИФНС&lt;2&gt;</div>
                    <div class="afCol-2-3">
                        <div class="afValue">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/ДС:КодНО">
                                    <xsl:variable name="ifns" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/ДС:КодНО"/>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 1, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 2, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 3, 1)"/>&#160;
                                    </div>
                                    <div class="afFrame">
                                        &#160;<xsl:value-of select="substring($ifns, 4, 1)"/>&#160;
                                    </div>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                    <div class="afFrame">&#160;&#160;&#160;</div>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC">Гражданство</div>
                <div class="afMarginLeft100 afUnderlinedBlock afValue">
                    <xsl:choose>
                        <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:Гражданства/УТ2:Гражданство/УТ2:Тип = 1">
                            гражданин(-ка) РФ
                        </xsl:when>
                        <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:Гражданства/УТ2:Гражданство/УТ2:Тип = 2">
                            иностранный гражданин
                        </xsl:when>
                        <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:Гражданства/УТ2:Гражданство/УТ2:Тип = 3">
                            лицо без гражданства
                        </xsl:when>
                        <xsl:otherwise>гражданин(-ка) РФ</xsl:otherwise>
                    </xsl:choose>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">Адрес места жительства в Российской Федерации</div>
                <div class="afMarginLeft350 afUnderlinedBlock"/>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:Адрес"/>
                    </xsl:call-template>
                </div>
                <p class="afSubscript afCenter">(почтовый адрес)</p>
            </div>
            
            <div class="afRow">
                <div class="afC">Страна   постоянного   проживания   до прибытия в Российскую Федерацию (для иностранных граждан)</div>
                <div class="afCol-1-9 afUnderlinedBlock"/>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:ПроживаниеЗаПределамиРФ/ns1:Страна"/>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">Дата предполагаемого выезда за пределы территории Российской Федерации (для иностранных граждан)</div>
                <div class="afCol-1-10 afUnderlinedBlock"/>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:call-template name="DateShortStr">
                        <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:ПроживаниеЗаПределамиРФ/ns1:ДатаВыезда"/>
                    </xsl:call-template>
                </div>
                <p class="afSubscript afCenter">(число, месяц, год)</p>
            </div>
            
            <div class="afRow">
                <div class="afJustify">Почтовый адрес для направления уведомления о регистрации страхователя, добровольно вступившего в правоотношения по обязательному пенсионному страхованию:</div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/ns1:АдресУведомления"/>
                    </xsl:call-template>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">Номер контактного телефона:</div>
                <div class="afMarginLeft200 afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:PhoneNumberStr">
                        <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Заявитель/УТ2:Телефоны/УТ2:Телефон"/>
                    </xsl:call-template>
                </div>
            </div>
            
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCenter">II. Основания для постановки на учет</div>
                <div class="afCenter">в качестве страхователя</div>
            </div>
            
            <p class="afInterval"/>
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0051'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Гражданин Российской Федерации, работающий за пределами территории Российской Федерации, в целях уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за себя</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0052'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Физическое лицо, в целях уплаты страховых взносов за другое физическое лицо, за которое не осуществляется уплата страховых взносов страхователем в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ "Об обязательном пенсионном страховании в Российской Федерации" и частью второй Налогового кодекса Российской Федерации</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0091'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Индивидуальный предприниматель, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0092'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Нотариус, занимающийся частной практикой и осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0094'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Адвокат, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0054'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Арбитражный управляющий, осуществляющий уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0055'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Иные лица, занимающиеся частной практикой и осуществляющие уплату страховых взносов в фиксированном размере, в части, превышающей этот размер</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0053'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Физическое лицо в целях уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за себя, постоянно или временно проживающее на территории Российской Федерации, на которое не распространяется обязательное пенсионное страхование в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ "Об обязательном пенсионном страховании в Российской Федерации", за исключением лиц, указанных в подпункте 6 пункта 1 статьи 29 данного закона</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Категория = '0056'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Физическое лицо в целях уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за себя, применяющее специальный налоговый режим "Налог на профессиональный доход", постоянно или временно проживающее на территории Российской Федерации</div>
            </div>
            
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCenter">III. Сведения о правоустанавливающем документе</div>
            </div>
            
            <div class="afRow">Вид документа:</div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ВидДокумента">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">документ, подтверждающий факт работы за пределами территории Российской Федерации, либо документ, подтверждающий факт приглашения на работу за пределы территории Российской Федерации:</div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ВидДокумента = '1'">трудовой договор</xsl:if>
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ВидДокумента = '2'">трудовое соглашение</xsl:if>
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ВидДокумента = '3'">приглашение на работу</xsl:if>
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ВидДокумента = '4'">контракт</xsl:if>
                </div>
                <p class="afSubscript afCenter">(наименование документа)</p>
            </div>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ИнойДокумент">V</xsl:if>
                </div>
                <div class="afFloatLeft">&#160;&#160;&#160;&#160;&#160;иной документ</div>
                <div class="afMarginLeft150 afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:ИнойДокумент"/>
                </div>
                <p class="afSubscript afCenter">(наименование документа)</p>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/УТ2:КемВыдан"/>
                </div>
                <p class="afSubscript afCenter">(наименование  органа, выдавшего правоустанавливающий документ)</p>
            </div>
            
            <div class="afRow">
                <div class="afC">регистрационный номер документа</div>
                <div class="afMarginLeft250 afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:Реквизиты/УТ2:Номер"/>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">дата регистрации документа</div>
                <div class="afMarginLeft200">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:Реквизиты/УТ2:Дата"/>
                        </xsl:call-template>
                    </div>
                    <p class="afSubscript afCenter">(число, месяц, год)</p>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">дата окончания срока действия документа</div>
                <div class="afMarginLeft300">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/УТ2:СрокДействия"/>
                        </xsl:call-template>
                    </div>
                    <p class="afSubscript afCenter">(число, месяц, год или «бессрочно»)</p>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC afJustify">дата  заключения  трудового договора (контракта) на работу за пределами территории</div>
            </div>
            
            <div class="afRow">
                <div class="afC">Российской Федерации</div>
                <div class="afMarginLeft150">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:СрокДоговора/УТ2:С"/>
                        </xsl:call-template>
                    </div>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC afJustify">дата окончания срока действия трудового договора (контракта) на работу  за  пределами территории</div>
            </div>
            
            <div class="afRow">
                <div class="afC">Российской Федерации</div>
                <div class="afMarginLeft150">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:РаботаВнеРФ/ns1:СрокДоговора/УТ2:По"/>
                        </xsl:call-template>
                    </div>
                    <p class="afSubscript afCenter">(число, месяц, год)</p>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:НалогНаПрофессиональныйДоход/ns1:Сведения">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">сведения (информация), подтверждающие факт постановки на учет в налоговом органе в качестве налогоплательщика, применяющего специальный налоговый режим «Налог на профессиональный доход» &lt;3&gt;:</div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:НалогНаПрофессиональныйДоход/ns1:Сведения"/>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-2">Дата постановки на учет в налоговом органе в качестве налогоплательщика, применяющего специальный налоговый режим «Налог на профессиональный доход»</div>
                <div class="afCol-1-2">
                    <div class="afValue afMarginLeft50 afUnderlinedBlock">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:НалогНаПрофессиональныйДоход/ns1:Дата"/>
                        </xsl:call-template>
                    </div>
                    <p class="afSubscript afCenter">(число, месяц, год)</p>
                </div>
            </div>
            
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCenter">IV. Сведения о физическом лице, за которое осуществляется</div>
                <div class="afCenter">уплата страховых взносов</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:NameStr">
                        <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:ФИО"/>
                    </xsl:call-template>
                </div>
                <p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии))</p>
            </div>
            
            <div class="afRow">
                <div class="afC">Адрес места жительства</div>
                <div class="afMarginLeft200">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:call-template name="УТ2:AddressStr">
                            <xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:Адрес"/>
                        </xsl:call-template>
                    </div>
                    <p class="afSubscript afCenter">(почтовый адрес)</p>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock"/>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock"/>
                <p class="afSubscript afCenter">(улица (проспект, переулок и т.д.), дом, корпус, квартира)</p>
            </div>
            
            <div class="afRow">
                <div class="afC">Документ, удостоверяющий личность</div>
                <div class="afMarginLeft250">
                    <div class="afUnderlinedBlock afValue">
						<xsl:if test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент">
							<xsl:choose>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ПАСПОРТ РОССИИ'">
									Паспорт гражданина Российской Федерации
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ПАСПОРТ'">
									Паспорт гражданина СССР
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ЗГПАСПОРТ РФ'">
									Загранпаспорт гражданина Российской Федерации
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'СВИД О РОЖД'">
									Свидетельство о рождении
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'УДОСТ ОФИЦЕРА'">
									Удостоверение личности офицера (военнослужащего)
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'СПРАВКА ОБ ОСВ'">
									Справка об освобождении из места лишения свободы
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ВОЕННЫЙ БИЛЕТ'">
									Военный билет солдата (матроса, сержанта, старшины)
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ДИППАСПОРТ РФ'">
									Дипломатический паспорт гражданина Российской Федерации
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'СЛУЖ ПАСПОРТ'">
									Служебный паспорт
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ИНПАСПОРТ'">
									Паспорт иностранного гражданина (ранее иностранный паспорт)
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'СВИД БЕЖЕНЦА'">
									Свидетельство о регистрации ходатайства о признании иммигранта беженцем по существу
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ВИД НА ЖИТЕЛЬ'">
									Вид на жительство
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'УДОСТ БЕЖЕНЦА'">
									Удостоверение беженца в Российской Федерации
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ВРЕМ УДОСТ'">
									Временное удостоверение личности гражданина Российской Федерации (форма № 2П)
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ПАСПОРТ МОРЯКА'">
									Удостоверение личности моряка, паспорт моряка
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Тип = 'ВОЕН БИЛЕТ ОЗ'">
									Военный билет офицера запаса
								</xsl:when>
								<xsl:otherwise>Иные документы, выдаваемые органами МВД России</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
                    </div>
                    <p class="afSubscript afCenter">(вид документа)</p>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-3">
                    <div class="afC">серия</div>
                    <div class="afCol-2-3">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Серия"/>
                        </div>
                    </div>
                </div>
                <div class="afCol-1-3">
                    <div class="afC">номер</div>
                    <div class="afCol-2-3">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:Номер"/>
                        </div>
                    </div>
                </div>
                <div class="afCol-1-3">
                    <div class="afC">дата выдачи</div>
                    <div class="afMarginLeft100">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:ДатаВыдачи"/>
                            </xsl:call-template>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">кем и когда выдан</div>
                <div class="afMarginLeft150">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:УдостоверяющийДокумент/УТ2:КемВыдан"/>
                    </div>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
                <div class="afCol-1-2">
                    <div class="afValue afMarginLeft100">
                        <xsl:choose>
                            <xsl:when test="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:СНИЛС">
                                <xsl:variable name="snils" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:ЛицоУплатаСВ/УТ2:СНИЛС"/>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                                </div>
                                <div class="afFloatLeft">&#160;&#160;&#160;</div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                                </div>
                                <div class="afFrame">
                                    &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                                </div>
                            </xsl:when>
                            <xsl:otherwise>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;-&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFloatLeft">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                                <div class="afFrame">&#160;&#160;&#160;</div>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCenter">V. Сведения об уплате страховых взносов</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afParagraph afJustify">Размер страховых взносов и порядок их уплаты определяются в соответствии со статьей 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации».</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div>Достоверность и полноту сведений, указанных в настоящем заявлении, подтверждаю.</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-2">
                    <div class="afC">Подпись заявителя</div>
                    <div class="afMarginLeft150 afUnderlinedBlock afValue"/>
                </div>
                <div class="afCol-1-2">
                    <div class="afC">Дата</div>
                    <div class="afMarginLeft50">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗОДСВ/ns1:Дата"/>
                            </xsl:call-template>
                        </div>
                        <p class="afSubscript afCenter">(число, месяц, год)</p>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            
            <div class="afRow">
                <div>---------------------------------------------</div>
            </div>
            
            <div class="afRow">
                <div class="afParagraph afJustify">&lt;1&gt; Указывается один из подпунктов 1, 2, 3, 5 или 6 пункта 1 статьи 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ "Об обязательном пенсионном страховании в Российской Федерации".</div>
            </div>
            
            <div class="afRow">
                <div class="afParagraph afJustify">&lt;2&gt; Код налогового органа по месту жительства физического лица, добровольно вступающего в правоотношения.</div>
            </div>
            
            <div class="afRow">
                <div class="afParagraph afJustify">&lt;3&gt; Сведения (информация), полученные посредством мобильного приложения "Мой налог", используемого в соответствии с Федеральным законом от 27 ноября 2018 г. № 422-ФЗ "О проведении эксперимента по установлению специального налогового режима "Налог на профессиональный доход" в городе федерального значения Москве, в Московской и Калужской областях, а также в Республике Татарстан (Татарстан)" (Собрание законодательства Российской Федерации, 2018, № 49, ст. 7494).</div>
            </div>
            
        </div>
    </xsl:template>
</xsl:stylesheet>
