<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ДС ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ДС="http://пф.рф/ВС/ДоСВ/типы/2019-05-24" xmlns:ns1="http://пф.рф/ЗПДСВ/2019-05-24">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            
            <div class="afRow">
                <div class="afCol-1-3">Код категории страхователя</div>
                <div class="afCol-2-3">
                    <div class="afValue afMarginLeft100">
                        <xsl:variable name="pCode" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Категория"/>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 1, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 2, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 3, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 4, 1)"/>&#160;
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-3">Регистрационный номер в СФР</div>
                <div class="afCol-2-3">
                    <div class="afValue afMarginLeft100">
                        <xsl:variable name="pCode" select="/ns1:ЭДПФР/ns1:ЗПДСВ/УТ2:РегНомер"/>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 1, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 2, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 3, 1)"/>&#160;
                        </div>
                        <div class="afFloatLeft">&#160;-&#160;</div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 5, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 6, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 7, 1)"/>&#160;
                        </div>
                        <div class="afFloatLeft">&#160;-&#160;</div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 9, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 10, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 11, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 12, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 13, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($pCode, 14, 1)"/>&#160;
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afRight-1-3">
                    <div class="afMarginLeft50 afValue">
                        <xsl:variable name="code" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:ТОПФР/УТ2:Код"/>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($code, 1, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($code, 2, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($code, 3, 1)"/>&#160;
                        </div>
                        <div class="afFloatLeft">&#160;-&#160;</div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($code, 4, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($code, 5, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($code, 6, 1)"/>&#160;
                        </div>
                    </div>
                    <p class="afSubscript afCenter">(код территориального органа СФР)</p>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC">В</div>
                <div class="afMarginLeft50 afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:ТОПФР/УТ2:Наименование"/>
                </div>
                <p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации и его код)</p>
            </div>
            
            <p class="afInterval"/>
            
            <h1 class="afHeader afCenter">Заявление</h1>
            <h1 class="afHeader afCenter">о прекращении правоотношений</h1>
            <h1 class="afHeader afCenter">по обязательному пенсионному страхованию</h1>
            <p class="afInterval"/>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afParagraph afJustify">Прекращаю правоотношения по обязательному пенсионному страхованию в соответствии с пунктом 3 статьи 29 Федерального закона от 15 декабря 2001 г. № 167-ФЗ «Об обязательном пенсионном страховании в Российской Федерации» и прошу снять меня с регистрационного учета в качестве страхователя.</div>
            </div>
            
            <div class="afRow">
                <div class="afCenter">I. Сведения о заявителе</div>
            </div>
            
            <div class="afRow">
                <div class="afC">Фамилия, имя, отчество (при наличии)</div>
                <div class="afCol-6-10 afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:NameStr">
                        <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:ФИО"/>
                    </xsl:call-template>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock"/>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-2">
                    <div class="afC">Дата рождения</div>
                    <div class="afCol-2-3">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:ДатаРождения"/>
                            </xsl:call-template>
                        </div>
                        <p class="afSubscript afCenter">(число, месяц, год)</p>
                    </div>
                </div>
                <div class="afCol-1-2">
                    <div class="afC">Место рождения</div>
                    <div class="afCol-2-3">
                        <div class="afUnderlinedBlock afValue">
                          <xsl:choose>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Город">
									<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Город"/>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна)"/>
									</xsl:if>	
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район">
									<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Район"/>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион)"/>
									</xsl:if>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна)"/>
									</xsl:if>	
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион">
										<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Регион"/>
									<xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">
										<xsl:value-of select="concat(', ', /ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна)"/>
									</xsl:if>	
								</xsl:when>
								<xsl:when test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна">
										<xsl:value-of select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:МестоРождения/УТ2:Страна"/>
								</xsl:when>	
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
                        </div>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-2">Страховой номер индивидуального лицевого счета застрахованного лица</div>
                <div class="afCol-1-2">
                    <div class="afValue afMarginLeft100">
                        <xsl:variable name="snils" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:СНИЛС"/>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
                        </div>
                        <div class="afFloatLeft">&#160;-&#160;</div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
                        </div>
                        <div class="afFloatLeft">&#160;-&#160;</div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
                        </div>
                        <div class="afFloatLeft">&#160;-&#160;</div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
                        </div>
                        <div class="afFrame">
                            &#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
                        </div>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-2-3">
                    <div class="afCol-1-3">ИНН (при наличии)</div>
                    <div class="afCol-2-3">
                        <div class="afValue">
                            <xsl:variable name="inn" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:ИНН"/>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 1, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 2, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 3, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 4, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 5, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 6, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 7, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 8, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 9, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 10, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 11, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($inn, 12, 1)"/>&#160;
                            </div>
                        </div>
                    </div>
                </div>
                <div class="afCol-1-3">
                    <div class="afCol-1-3">Код ИФНС&lt;1&gt;</div>
                    <div class="afCol-2-3">
                        <div class="afValue">
                            <xsl:variable name="ifns" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/ДС:КодНО"/>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 1, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 2, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 3, 1)"/>&#160;
                            </div>
                            <div class="afFrame">
                                &#160;<xsl:value-of select="substring($ifns, 4, 1)"/>&#160;
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afJustify">Почтовый адрес для направления уведомления о снятии с регистрационного учета страхователя, прекратившего правоотношения по обязательному пенсионному страхованию</div>
            </div>
            
            <div class="afRow">
                <div class="afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:АдресРегистрации"/>
                    </xsl:call-template>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afC">Номер контактного телефона:</div>
                <div class="afMarginLeft200 afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:PhoneNumberStr">
                        <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:Заявитель/УТ2:Телефоны/УТ2:Телефон"/>
                    </xsl:call-template>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCenter">II. Основания для снятия с учета в качестве страхователя</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '1'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации гражданином Российской Федерации, работающим за пределами территории Российской Федерации</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '2'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов в Фонд пенсионного и социального страхования Российской Федерации за другое физическое лицо, за которое не осуществляется уплата в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ "Об обязательном пенсионном страховании в Российской Федерации" и частью второй Налогового кодекса Российской Федерации</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '3'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов в фиксированном размере в части, превышающей этот размер</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '4'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">В связи с прекращением уплаты страховых взносов за себя физическим лицом, постоянно или временно проживающим на территории Российской Федерации, на которого не распространяется обязательное пенсионное страхование в соответствии с Федеральным законом от 15 декабря 2001 г. № 167-ФЗ "Об обязательном пенсионном страховании в Российской Федерации", за исключением лиц, указанных в подпункте 6 пункта 1 статьи 29 данного закона</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '5'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">В связи с прекращением физическим лицом уплаты страховых взносов за себя, применяющим специальный налоговый режим "Налог на профессиональный доход", постоянно или временно проживающим на территории Российской Федерации</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '6'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">В связи с изменением регистрации по месту жительства</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC afCheck">
                    <xsl:if test="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:КодСнятия = '7'">V</xsl:if>
                </div>
                <div class="afMarginLeft50 afJustify">Прочее</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div>Достоверность и полноту сведений, указанных в настоящем заявлении, подтверждаю.</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afCol-1-2">
                    <div class="afC">Подпись заявителя</div>
                    <div class="afMarginLeft150 afUnderlinedBlock afValue"/>
                </div>
                <div class="afCol-1-2">
                    <div class="afC">Дата</div>
                    <div class="afMarginLeft50">
                        <div class="afUnderlinedBlock afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:ЗПДСВ/ns1:ДатаЗаполнения"/>
                            </xsl:call-template>
                        </div>
                        <p class="afSubscript afCenter">(число, месяц, год)</p>
                    </div>
                </div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div>-------------------------------</div>
            </div>
            
            <div class="afRow">
                <div class="afParagraph afJustify">&lt;1&gt; Код налогового органа по месту жительства физического лица, добровольно вступающего в правоотношения.</div>
            </div>
            
        </div>
    </xsl:template>
</xsl:stylesheet>
