<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/УСДСВ/2019-05-24">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            
            <h1 class="afHeader afCenter">Уведомление</h1>
            <h1 class="afHeader afCenter">о снятии с учета в территориальном органе</h1>
            <h1 class="afHeader afCenter">Фонда пенсионного и социального страхования Российской Федерации страхователя,</h1>
            <h1 class="afHeader afCenter">прекратившего правоотношения по обязательному пенсионному страхованию</h1>
            <p class="afInterval"/>
            
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC">Уважаемый(ая)</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:NameStr">
                        <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:Заявитель/УТ2:ФИО"/>
                    </xsl:call-template>
                </div>
                <p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
            </div>
            
            <div class="afRow">
                <div class="afC">проживающий(ая) по адресу</div>
                <div class="afCol-2-3 afUnderlinedBlock afValue">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:Заявитель/УТ2:АдресРегистрации"/>
                    </xsl:call-template>
                </div>
                <p class="afSubscript afCenter">(почтовый адрес)</p>
            </div>
            
            <div class="afRow afUnderlinedBlock"/>
            
            <div class="afRow">
                <div class="afC afJustify">сообщаем, что на основании Вашего заявления в соответствии с законодательством Российской Федерации об обязательном пенсионном страховании Вы сняты с регистрационного учета</div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-4">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:ДатаСнятия"/>
                        </xsl:call-template>
                    </div>
                    <p class="afSubscript afCenter">(число, месяц, год)</p>
                </div>
                <div class="afC">в</div>
                <div class="afCol-2-3">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:ТОПФР/УТ2:Наименование"/>,&#160;
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:ТОПФР/УТ2:Код"/>
                    </div>
                    <p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации, его код)</p>
                </div>
                
            </div>
            
            <div class="afRow">
                <div class="afCol-1-3">
                    <div class="afUnderlinedBlock afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УСДСВ/УТ2:РегНомер"/>
                    </div>
                    <p class="afSubscript afCenter">(регистрационный номер в СФР)</p>
                </div>
                <div class="afC">по месту Вашего жительства.</div>
            </div>
            
            <p class="afInterval"/>
            
            <div class="afNoBreakInside afNoBreakBefore">
                <p class="afInterval"/>                
                <div class="afSign">
                    <div class="afPadding">
                        <p class="afValue afUnderlinedBlock">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:УСДСВ/ns1:УполномоченноеЛицо">
                                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:УполномоченноеЛицо/УТ2:Должность"/>
                                </xsl:when>
                                <xsl:otherwise>&#160;</xsl:otherwise>
                            </xsl:choose>
                        </p>
                        <p class="afCenter afSubscript">(должность)</p>
                    </div>
                    <div class="afPadding">
                        <p class="afBlankUnderlinedBlock"/>
                        <p class="afCenter afSubscript">(подпись)</p>
                    </div>
                    <div class="afCPadding">
                        <p class="afValue afUnderlinedBlock">
                            <xsl:choose>
                                <xsl:when test="/ns1:ЭДПФР/ns1:УСДСВ/ns1:УполномоченноеЛицо">
                                    <xsl:call-template name="УТ2:NameStr">
                                        <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УСДСВ/ns1:УполномоченноеЛицо/УТ2:ФИО"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>&#160;</xsl:otherwise>
                            </xsl:choose>
                        </p>
                        <p class="afCenter afSubscript">(фамилия, имя, отчество (при наличии)</p>
                    </div>
                </div>
            </div> 
            
            
        </div>
    </xsl:template>
</xsl:stylesheet>
