<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:x="http://пф.рф/ВС/ФС/АВП-ПУ/2018-07-19" xmlns:ФС="http://пф.рф/ВС/ФС/типы/2018-04-23" xmlns:УТ="http://пф.рф/УТ/2017-08-21" xmlns:АФ="http://пф.рф/АФ/2017-08-21">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:attribute-set name="block">
        <xsl:attribute name="font-family">Arial</xsl:attribute>
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="text-align">justify</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="solidBorder">
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
        <xsl:attribute name="padding">2pt</xsl:attribute>
    </xsl:attribute-set>

    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simple" page-height="29.7cm" page-width="21cm"
                    margin-top="1cm" margin-bottom="2cm" margin-left="2.5cm" margin-right="2.5cm">
                    <fo:region-body margin-top="0.5cm" margin-bottom="0cm"/>
                    <fo:region-before extent="2cm"/>
                    <fo:region-after extent="1.5cm"/>
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simple">
                <fo:flow flow-name="xsl-region-body">
                    <!-- ****ДОКУМЕНТ АВП-ПУ**** -->
                    <fo:block xsl:use-attribute-sets="block">
                        
                        <!-- ШАПКА ДОКУМЕНТА -->
                        <fo:table>
                            <fo:table-column column-width="60%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block><xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Адрес" />                                            
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>ТЕЛ. ФАКС <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Телефоны/УТ:Телефон" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- НАИМЕНОВАНИЕ ДОКУМЕНТА -->
                        <fo:block margin-top="10pt" margin-bottom="10pt" text-align="center" font-weight="bold">
                            <fo:block>Акт</fo:block>
                            <fo:block>о выявлении правонарушения в сфере законодательства Российской Федерации об</fo:block>
                            <fo:block>индивидуальном (персонифицированном) учете в системах обязательного</fo:block>
                            <fo:block>пенсионного страхования и обязательного социального страхования</fo:block>
                        </fo:block>
                        
                        <!-- РЕКВИЗИТЫ ДОКУМЕНТА -->
                        <fo:table>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>от</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:call-template name="ДатаСтрока">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:АВП-ПУ/x:Реквизиты/УТ:Дата" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>№</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Реквизиты/УТ:Номер"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- ПРОВЕРЯЮЩИЙ -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="7%"/>
                            <fo:table-column column-width="88%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>Мной, </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="concat(/x:ЭДПФР/x:АВП-ПУ/x:Проверяющий/УТ:Должность, ' ')"/>
                                            <xsl:call-template name="ФИО">
                                                <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Проверяющий/УТ:ФИО" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О., должность лица, проводившего проверку)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" />
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block text-align="center" font-size="8pt">(наименование территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt" text-align="justify">проведена проверка достоверности, правильности заполнения, полноты и своевременности представления сведений индивидуального (персонифицированного) учета, предусмотренных пунктами 2 и 2.1 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (за исключением сведений, предусмотренных подпунктом 4 указанного пункта)&lt;1&gt;
                            далее – Федеральный закон от 1 апреля 1996 г. № 27-ФЗ), пунктами 2 – 2.2 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования»&lt;2&gt;,
                            а также порядка представления сведений, предусмотренных пунктом 2 статьи 8&lt;3&gt;, пунктами 2, 2.1 и 9 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ, пунктами 2 – 2.2 и 2.4 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования»&lt;4&gt;, в форме электронного документа 
                        </fo:block>
                        
                        <!-- СТРАХОВАТЕЛЬ -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="97%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/ФС:Наименование">
                                                    <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/ФС:Наименование" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИО">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(полное наименование юридического лица (обособленного подразделения), Ф.И.О., физического лица, в том числе индивидуального предпринимателя)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                                
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-column column-width="54%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-body>        
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>регистрационный номер в CФР</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:РегНомер" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>ИНН</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:ИНН" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>КПП</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:КПП" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>адрес в пределах места нахождения</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>юридического лица (обособленного</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>подразделения) / адрес регистрации физического</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>ица, в том числе индивидуального предпринимателя</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:call-template name="АдресОбщий">
                                                <xsl:with-param name="pAddress" select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/ФС:Адрес" />
                                            </xsl:call-template>,
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- ПЕРЕЧЕНЬ ДОКУМЕНТОВ -->
                        <fo:block margin-top="10pt">Перечень документов, на основании которых выявлено правонарушение:</fo:block>
                        
                        <fo:table font-size="8pt">
                            <fo:table-column column-width="6%"/>
                            <fo:table-column column-width="47%"/>
                            <fo:table-column column-width="47%"/>
                            <fo:table-header>        
                                <fo:table-row text-align="center">
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>№ п/п</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>Тип документа</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>Дата представления документа</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-header>
                            <fo:table-body>
                                <xsl:for-each select="/x:ЭДПФР/x:АВП-ПУ/x:Основания/x:Документ">
                                    <fo:table-row>
                                        <fo:table-cell text-align="center" xsl:use-attribute-sets="solidBorder">
                                            <fo:block><xsl:value-of select="position()"/></fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                            <fo:block><xsl:value-of select="./x:Тип"/></fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell text-align="center" xsl:use-attribute-sets="solidBorder">
                                            <fo:block>
                                                <xsl:call-template name="Дата">
                                                    <xsl:with-param name="pDate" select="./x:ДатаПредставления" />
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="40px"/>
                            <fo:table-column column-width="210px"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>за</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell font-weight="bold" border-after-style="solid" border-after-width="thin">
                                        <fo:block>
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ПериодПроверки"/>                                      
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(период)&lt;5&gt;</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- РАЗДЕЛ 1 -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="95%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>1. Проверка проведена на основе следующих документов:</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:for-each select="/x:ЭДПФР/x:АВП-ПУ/x:Документы/x:Документ">
                                                <xsl:if test="position() != 1">, </xsl:if>
                                                <xsl:value-of select="./text()"/>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block text-align="center" font-size="8pt">(указываются виды проверенных документов и при необходимости перечень конкретных документов)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- РАЗДЕЛ 2 -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="95%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>2. Настоящей проверкой выявлено нарушение законодательства Российской Федерации об</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>
                                            <fo:inline>индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования в отношении</fo:inline>
                                            <fo:inline font-weight="bold" text-decoration="underline">
                                                <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:КоличествоЗЛ"/>
                                            </fo:inline>
                                            <fo:inline>застрахованных лиц:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <xsl:for-each select="/x:ЭДПФР/x:АВП-ПУ/x:Нарушения/x:Нарушение">
                                            <fo:block font-weight="bold"><xsl:value-of select="./text()"/></fo:block>
                                        </xsl:for-each>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(приводятся документально подтвержденные факты нарушения законодательства Российской Федерации об индивидуальном (персонифицированном)
                                            учете в системах обязательного пенсионного страхования и обязательного социального страхования)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- РАЗДЕЛ 3 -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="95%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>3. По результатам настоящей проверки предлагается:</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>3.1. Страхователю внести необходимые исправления в документы кадрового учета;</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>3.2. Привлечь</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/ФС:Наименование">
                                                    <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/ФС:Наименование" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИО">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block text-align="center" font-size="8pt">(наименование организации, Ф.И.О. физического лица в том числе индивидуального предпринимателя)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>к ответственности, предусмотренной:</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <xsl:for-each select="/x:ЭДПФР/x:АВП-ПУ/x:Правонарушения/x:Правонарушение">
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="2">
                                            <fo:block>
                                                <fo:inline>частью</fo:inline>
                                                <fo:inline font-weight="bold" text-decoration="underline">
                                                    <xsl:value-of select="./x:Часть"/>
                                                </fo:inline>
                                                <fo:inline>статьи</fo:inline>
                                                <fo:inline font-weight="bold" text-decoration="underline">17</fo:inline>
                                                <fo:inline>Федерального закона от 1 апреля 1996 г. № 27-ФЗ за</fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                            <fo:block font-weight="bold"><xsl:value-of select="./x:Состав"/></fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="2">
                                            <fo:block text-align="center" font-size="8pt">(указывается наименование выявленного нарушения)</fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- ПРИЛОЖЕНИЕ -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="95%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            Приложение: на
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:ЛистовПриложения">
                                                    <fo:inline font-weight="bold" text-decoration="underline">
                                                        <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ЛистовПриложения"/>
                                                    </fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    ___
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            листах.
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>                               
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="95%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>В случае несогласия с фактами, изложенными в настоящем акте, а также с выводами и</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>предложениями проверяющего страхователь вправе представить в течение 15 дней со дня получения настоящего акта в</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold"><xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block text-align="center" font-size="8pt">(наименование территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>письменные возражения по указанному акту в целом или по его отдельным положениям. При этом страхователь вправе приложить к письменным возражениям или в согласованный срок
                                        передать документы (их заверенные копии), подтверждающие обоснованность своих возражений.</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="95%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>Рассмотрение акта с учетом предоставленных страхователем документов состоится в</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>
                                            <fo:inline font-weight="bold" text-decoration="underline">
                                                <xsl:call-template name="Время">
                                                    <xsl:with-param name="pTime" select="/x:ЭДПФР/x:АВП-ПУ/x:РассмотрениеАкта/x:Время" />
                                                </xsl:call-template>
                                            </fo:inline>
                                            <fo:inline>часов</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="80%"/>
                            <fo:table-body>
                                <fo:table-row vertical-align="bottom">
                                    <fo:table-cell text-align="center" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:call-template name="Дата">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:АВП-ПУ/x:РассмотрениеАкта/x:Дата" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell text-align="center">
                                        <fo:block> в </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold"><xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(наименование территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:ТерриториальныйОрганПФР/ФС:Адрес" />
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block text-align="center" font-size="8pt">(адрес территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt" text-indent="2.2em">По результатам рассмотрения будет принято Решение о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства
                            Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования или Решение об отказе в привлечении 
                            страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования 
                            и обязательного социального страхования(далее - Решение о привлечении (об отказе в привлечении) страхователя к ответственности) &lt;6&gt;.</fo:block>
                        <fo:block text-indent="2.2em">В случае неявки страхователя Решение о привлечении (отказе в привлечении) страхователя к ответственности будет принято в его отсутствие.</fo:block>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="21%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="4%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>Подпись должностного лица</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>территориального органа СФР</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>проводившего проверку</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block> </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:call-template name="ФИОКороткое">
                                                <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Проверяющий/УТ:ФИО" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О.)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="4%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>Подпись руководителя юридического</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>лица (обособленного подразделения)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>с указанием должности,</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>физического лица, в том числе</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>индивидуального предпринимателя</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>(уполномоченного представителя)&lt;7&gt;</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:if test="/x:ЭДПФР/x:АВП-ПУ/x:Руководитель">
                                                <xsl:value-of select="/x:ЭДПФР/x:АВП-ПУ/x:Руководитель/УТ:Должность"/>
                                            </xsl:if>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block> </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Руководитель">
                                                    <xsl:call-template name="ФИОКороткое">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Руководитель/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:when>
                                                <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Представитель">
                                                    <xsl:call-template name="ФИОКороткое">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Представитель" />
                                                    </xsl:call-template>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИОКороткое">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(должность)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О.)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- ПОЛУЧИЛ ЛИЧНО -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="35%"/>
                            <fo:table-column column-width="10%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="30%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>Экземпляр настоящего акта с&#160;</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <fo:inline>&#160;приложениями на&#160;</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <fo:inline>&#160;листах получил лично:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>                                    
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(количество приложений)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block><fo:inline>&#160;</fo:inline></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block><fo:inline>&#160;</fo:inline></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">или Ф.И.О. физического лица, в том числе индивидуального предпринимателя (уполномоченного представителя)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="10%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block><fo:inline>&#160;</fo:inline></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block><fo:inline>&#160;</fo:inline></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- УКЛОНЕНИЕ -->
                        <!--  
                        <fo:block margin-top="10pt">Лицо, совершившее правонарушение, от подписи и получении настоящего акта уклоняется &lt;4&gt;</fo:block>
                        
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:if test="/x:ЭДПФР/x:АВП-ПУ/x:Уклонение">
                                                <xsl:choose>
                                                    <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Руководитель">
                                                        <xsl:value-of select="concat(/x:ЭДПФР/x:АВП-ПУ/x:Руководитель/УТ:Должность, ', ')"/>
                                                        <xsl:call-template name="ФИО">
                                                            <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Руководитель/УТ:ФИО" />
                                                        </xsl:call-template>
                                                    </xsl:when>
                                                    <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Представитель">
                                                        <xsl:call-template name="ФИО">
                                                            <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Представитель" />
                                                        </xsl:call-template>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:call-template name="ФИО">
                                                            <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:АВП-ПУ/x:Страхователь/УТ:ФИО" />
                                                        </xsl:call-template>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:if>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения), Ф.И.О. индивидуального предпринимателя, физического
                                            лица (уполномоченного представителя))</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        -->
                        
                        <fo:block text-indent="2.2em">Направить настоящий акт:</fo:block>
                        <fo:block text-indent="1.5em">
                            <fo:inline>
                                <xsl:choose>
                                    <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Уклонение[x:СпособНаправления = 1]">&#x25A0;</xsl:when>
                                    <xsl:otherwise>&#x25A1;</xsl:otherwise>
                                </xsl:choose>
                            </fo:inline>
                            <fo:inline>по почте;</fo:inline>
                            <fo:inline>(в случае направления акта по почте заказным письмом датой вручения этого акта считается шестой день считая с даты отправления заказного письма &lt;8&gt;);</fo:inline>
                        </fo:block>
                        <fo:block text-indent="1.5em">
                            <fo:inline>
                                <xsl:choose>
                                    <xsl:when test="/x:ЭДПФР/x:АВП-ПУ/x:Уклонение[x:СпособНаправления = 2]">&#x25A0;</xsl:when>
                                    <xsl:otherwise>&#x25A1;</xsl:otherwise>
                                </xsl:choose>
                            </fo:inline>
                            <fo:inline>по телекоммуникационным каналам связи</fo:inline>
                        </fo:block>
                        
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="10%"/>
                            <fo:table-column column-width="30%"/>
                            <fo:table-column column-width="30%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:if test="/x:ЭДПФР/x:АВП-ПУ/x:Уклонение">
                                                <xsl:call-template name="Дата">
                                                    <xsl:with-param name="pDate" select="/x:ЭДПФР/x:АВП-ПУ/x:Уклонение/x:Дата" />
                                                </xsl:call-template>
                                            </xsl:if>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись лица, проводившего проверку)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!--
                        <fo:block font-size="8pt" margin-top="10pt" text-indent="2.2em">Примечание.</fo:block>
                        <fo:block font-size="8pt" text-indent="2.2em">Акт в течение пяти дней с даты подписания этого акта должен быть вручен лицу, в отношении которого проводилась проверка (его уполномоченному представителю),
                        лично под расписку, направлен по почте заказным письмом или передан в электронном виде по телекоммуникационным каналам связи. В случае направления указанного акта по почте заказным письмом
                        оно считается полученным по истечении шести дней с даты отправления заказного письма.</fo:block>
                        -->
                        
                        <!-- СНОСКИ -->
                        <fo:block>
                            <fo:block margin-top="5pt" margin-bottom="10pt">_________________________________</fo:block>
                            <fo:block font-size="8pt">&lt;1&gt; Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</fo:block>
                            <fo:block font-size="8pt">&lt;2&gt; Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 29, ст. 5204.</fo:block>
                            <fo:block font-size="8pt">&lt;3&gt; Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 29, ст. 5204.</fo:block>
                            <fo:block font-size="8pt">&lt;4&gt; Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 41, ст. 6941.</fo:block>
                            <fo:block font-size="8pt">&lt;5&gt; Не заполняется в случае представления страхователем сведений, предусмотренных подпунктом 5 пункта 2 статьи 11 Федерального закона 
                                от 1 апреля 1996 г. № 27-ФЗ.</fo:block>
                            <fo:block font-size="8pt">&lt;6&gt; Часть 11 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах 
                                обязательного пенсионного страхования и обязательного социального страхования» (Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2016, № 27, ст. 4183; 2022, № 29, ст. 5204).</fo:block>
                            <fo:block font-size="8pt">&lt;7&gt; В случае если проверка проводилась в присутствии страхователя.</fo:block>
                            <fo:block font-size="8pt">&lt;8&gt; Часть 7 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, 
                                ст. 1401; 2016; № 27, 4183).</fo:block>
                        </fo:block>
                        
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="АдресРФ">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="АдресОбщий">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress/УТ:РоссийскийАдрес" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ГруппаАдрес">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Регион">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Регион" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Район">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Район" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Город">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Город" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:НаселенныйПункт">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:НаселенныйПункт" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Улица">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Улица" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Дом">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Дом" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Строение">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Строение" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Корпус">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Корпус" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Квартира">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Квартира" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="География">
        <xsl:param name="pGEO" />
        <xsl:value-of select="$pGEO/УТ:Название"/>
        <xsl:if test="$pGEO/УТ:Сокращение"><xsl:value-of select="concat(' ', $pGEO/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="Нумерация">
        <xsl:param name="pNum" />
        <xsl:value-of select="$pNum/УТ:Номер"/>
        <xsl:if test="$pNum/УТ:Сокращение"> <xsl:value-of select="concat(' ', $pNum/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="ФИО">
        <xsl:param name="pFIO" />
        <xsl:if test="$pFIO/УТ:Фамилия"><xsl:value-of select="concat($pFIO/УТ:Фамилия, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Имя"><xsl:value-of select="concat($pFIO/УТ:Имя, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Отчество"><xsl:value-of select="concat($pFIO/УТ:Отчество, ' ')"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="ФИОКороткое">
        <xsl:param name="pFIO" />
        <xsl:if test="$pFIO/УТ:Фамилия"><xsl:value-of select="concat($pFIO/УТ:Фамилия, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Имя"><xsl:value-of select="substring($pFIO/УТ:Имя, 1, 1)"/>.</xsl:if>
        <xsl:if test="$pFIO/УТ:Отчество"><xsl:value-of select="substring($pFIO/УТ:Отчество, 1, 1)"/>.</xsl:if>
    </xsl:template>
    
    <xsl:template name="Дата">
        <xsl:param name="pDate" />
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
    </xsl:template>
    
    <xsl:template name="Время">
        <xsl:param name="pTime" />
        <xsl:variable name="timeText" select="string($pTime)"/>
        <xsl:value-of select="concat(substring($timeText, 1, 2), '.', substring($timeText, 4, 2))"/>
    </xsl:template>
    
    <xsl:template name="ДатаСтрока">
        <xsl:param name="pDate"/>
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:variable name="month" select="substring($dateText, 6, 2)"/>
        <xsl:value-of select="concat('&quot;',substring($dateText, 9, 2),'&quot;')"/>
        <xsl:choose>
            <xsl:when test="$month = '01'"> января </xsl:when>
            <xsl:when test="$month = '02'"> февраля </xsl:when>
            <xsl:when test="$month = '03'"> марта </xsl:when>
            <xsl:when test="$month = '04'"> апреля </xsl:when>
            <xsl:when test="$month = '05'"> мая </xsl:when>
            <xsl:when test="$month = '06'"> июня </xsl:when>
            <xsl:when test="$month = '07'"> июля </xsl:when>
            <xsl:when test="$month = '08'"> августа </xsl:when>
            <xsl:when test="$month = '09'"> сентября </xsl:when>
            <xsl:when test="$month = '10'"> октября </xsl:when>
            <xsl:when test="$month = '11'"> ноября </xsl:when>
            <xsl:when test="$month = '12'"> декабря </xsl:when>
        </xsl:choose>
        <xsl:value-of select="concat(substring($dateText, 1, 4),' года')"/>
    </xsl:template>
    
</xsl:stylesheet>
