<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1 ФС2" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/ВС/ФС/АВП-ПУ/2018-07-19" xmlns:ФС2="http://пф.рф/ВС/ФС/типы/2018-04-23">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../../Общие/УнифТипы_2017-08-21.xsl"/>
    
    <xsl:template match="/" name="inc">
        <div class="afWrap pfrAfAVP-PU">
			<div class="afRight-1-3">
				<p class="afSubscript">Приложение № 1</p>
				<p class="afSubscript"><br/></p>
				<p class="afSubscript">к приказу Фонда пенсионного и</p>
				<p class="afSubscript">социального страхования</p>
				<p class="afSubscript">Российской Федерации</p>
				<p class="afSubscript"><br/></p>
				<p class="afSubscript">от 2 марта 2023 г</p>
				<p class="afSubscript"><br/></p>
				<p class="afSubscript">№ 302</p>
			</div>
			
			<table class="afTable40">
				<tr>
					<td><xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Наименование"/></td>
				</tr>
				<tr>
					<td><xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Адрес"/></td>
				</tr>
				<tr>
					<td>ТЕЛ. ФАКС <xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Телефоны/УТ2:Телефон" /></td>
				</tr>
			</table>
        	
        	
        	
        	<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
            <p class="afCenter afHeader">Акт</p>
            <p class="afCenter afHeader">о выявлении правонарушения в сфере законодательства Российской Федерации</p>
            <p class="afCenter afHeader">об индивидуальном (персонифицированном) учете в системах обязательного</p>
        	<p class="afCenter afHeader">пенсионного страхования и обязательного социального страхования</p>
            <p class="afInterval"/>
        	<p class="afInterval"/>
            
            <div class="afRow">
				<div class="afCol-2-25">от</div>
				<div class="afCol-1-5">
					<p class="afValue afCenterBlock afUnderlinedBlock">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Реквизиты/УТ2:Дата"/>
						</xsl:call-template>
					</p>
					<p class="afSubscript afCenter">(дата)</p>
				</div>
				<div class="afCol-4-10">&#160;</div>
				<div class="afCol-2-25 afCenterBlock">№</div>
				<div class="afCol-1-5 afValue afCenterBlock afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Реквизиты/УТ2:Номер"/>
				</div>
			</div>
            <p class="afInterval"/>
            <div class="afRow">
				<div class="afC">Мной, </div>
				<div class="afValue afUnderlinedBlock afMarginLeft50">
					<xsl:call-template name="УТ2:NameStr">
						<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Проверяющий/УТ2:ФИО"/>
					</xsl:call-template>, 
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Проверяющий/УТ2:Должность"/>
				</div>
				<p class="afSubscript afCenter">(Ф.И.О., должность лица, проводившего проверку)</p>
            </div>
            <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Наименование"/>
				</div>
				<p class="afSubscript afCenter">(наименование территориального органа СФР)</p>
            </div>
            <p class="afInterval"/>
        	<p class="afP" style="text-align: justify;">проведена проверка достоверности, правильности заполнения, полноты и своевременности представления сведений индивидуального (персонифицированного) учета, предусмотренных пунктами 2 и 2.1 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (за исключением сведений, предусмотренных подпунктом 4 указанного пункта)<span class="afSup">1</span> (далее – Федеральный закон от 1 апреля 1996 г. № 27-ФЗ), пунктами 2 – 2.2 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системе обязательного пенсионного страхования»<span class="afSup">2</span>, а также порядка представления сведений, предусмотренных пунктом 2 статьи 8<span class="afSup">3</span>, пунктами 2, 2.1 и 9 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ, пунктами 2 – 2.2 и 2.4 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системе обязательного пенсионного страхования»<span class="afSup">4</span>, в форме электронного документа </p>
            <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Наименование">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Наименование"/>
						</xsl:when>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ФИО">
							<xsl:call-template name="УТ2:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ФИО"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</div>
				<p class="afSubscript afCenter">(полное наименование юридического лица (обособленного подразделения),<br/> Ф.И.О. индивидуального предпринимателя, физического лица)</p>
            </div>
            
            <div class="afRow">
				<div class="afCol-4-10">регистрационный номер в CФР</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:РегНомер"/>
				</div>
			</div>
            <div class="afRow">
				<div class="afCol-4-10">ИНН</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ИНН"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-4-10">КПП</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:КПП"/>
				</div>
            </div>
            <div class="afRow">
            	<div class="afCol-4-10">адрес в пределах места нахождения юридического лица (обособленного подразделения)/адрес регистрации физического лица, в том числе индивидуального предпринимателя</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<br/><br/>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Адрес/УТ2:Иностранный">
							<xsl:call-template name="УТ2:AddressForeignStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Адрес" />
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Адрес/УТ2:Неструктурированный">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Адрес/УТ2:Неструктурированный"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ2:AddressStr">
								<xsl:with-param name="pAddress" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Адрес"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
            </div>
            
             <p class="afInterval"/>
            <p class="afP">Перечень документов, на основании которых выявлено правонарушение:</p>
            
            <table class="afTable100 afTable">
				<thead class="afCenter">
					<tr>
						<td class="afTable10">№ п/п</td>
						<td class="afTable60">Тип документа</td>
						<td class="afTable40">Дата представления документа</td>
					</tr>
				</thead>
				<tbody class="afValue">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Основания/ns1:Документ">
							<xsl:for-each select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Основания/ns1:Документ">
								<tr>
									<td class="afCenter"><xsl:value-of select="position()"/></td>
									<td><xsl:value-of select="ns1:Тип"/></td>
									<td class="afCenter">
										<xsl:call-template name="DateShortStr">
											<xsl:with-param name="pDate" select="ns1:ДатаПредставления"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
							<tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
							<tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
						</xsl:otherwise>
					</xsl:choose>
				</tbody>
			</table>
            <div class="afRow">
				<div class="afC afCol-1-20">за </div>
				<div class="afCol-1-4 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ПериодПроверки"/>
				</div> 
            </div>
        	<p class="afSubscript afMarginLeft90">(период)<span class="afSup">5</span></p>
            <p class="afParagraph">1. Проверка проведена на основе следующих документов:</p>
            <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:if test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Документы">
						<xsl:for-each select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Документы/ns1:Документ">
							<xsl:if test="position() != 1">, </xsl:if>
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:if>	
				</div>
				<p class="afSubscript afCenter">(указываются виды проверенных документов и при необходимости перечень конкретных документов)</p>
            </div>
        	<p class="afParagraph">2. Настоящей проверкой выявлено нарушение законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системе обязательного пенсионного страхования и обязательного социального страхования в отношении	<span class="afValue afUnderline">&#160;&#160; <xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:КоличествоЗЛ "/>  &#160;</span> застрахованных лиц:</p>
             <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:if test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Нарушения">
						<xsl:for-each select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Нарушения/ns1:Нарушение">
							<p class="afParagraph"><xsl:value-of select="."/></p>
						</xsl:for-each>
					</xsl:if>	
				</div>
             	<p class="afSubscript afCenter">(приводятся документально подтвержденные факты нарушения законодательства Российской Федерации об индивидуальном <br/> (персонифицированном) учете в системе обязательного пенсионного страхования и обязательного социального страхования)</p>
            </div>
            <p class="afInterval"/>
            <p class="afParagraph">3. По результатам настоящей проверки предлагается:</p>
            <p class="afParagraph">3.1. Страхователю внести необходимые исправления в документы кадрового учета;</p>
            <p class="afParagraph">3.2. Привлечь </p>
            
             <div class="afRow ">
				<div class="afValue afUnderlinedBlock">
					<xsl:choose>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Наименование">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/ФС2:Наименование"/>
						</xsl:when>
						<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ФИО">
							<xsl:call-template name="УТ2:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ФИО"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</div>
             	<p class="afSubscript afCenter">(наименование организации, Ф.И.О. физического лица, в том числе индивидуального предпринимателя)</p>
            </div>
            
            <p class="afP">к ответственности, предусмотренной:</p>
            
            <xsl:for-each select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Правонарушения/ns1:Правонарушение">
				<p class="afP">частью <span class="afValue afUnderline">&#160;<xsl:value-of select="ns1:Часть"/> &#160;</span> статьи <span class="afValue afUnderline">&#160;17&#160;</span> Федерального закона от 1 апреля 1996 г. № 27-ФЗ за</p>
				<div class="afRow ">
					<div class="afValue afUnderlinedBlock">
						<xsl:value-of select="ns1:Состав"/>
					</div>
					<p class="afSubscript afCenter">(указывается наименование выявленного нарушения)</p>
				</div>
            </xsl:for-each>
            
            <div class="afRow">
				<div class="afC afCol-1-5">Приложение: </div>
				<div class="afCol-1-4 afValue afUnderlinedBlock"> на
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ЛистовПриложения"/> листах.
				</div> 
            </div>
            
            <p class="afParagraph">В случае несогласия с фактами, изложенными в настоящем акте, а также с выводами и предложениями проверяющего страхователь вправе представить в течение 15 дней со дня получения настоящего акта в </p>
            
            <div class="afRow ">
				<div class="afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Наименование"/>
				</div>
				<p class="afSubscript afCenter">(наименование территориального органа CФР)</p>
            </div>
            <p class="afP">письменные возражения по указанному акту в целом или по его отдельным положениям. При этом страхователь вправе приложить к письменным возражениям или в согласованный срок передать документы (их заверенные копии), подтверждающие обоснованность своих возражений.</p>
             <p class="afInterval"/>
            <p class="afParagraph">Рассмотрение акта с учетом предоставленных страхователем документов состоится в	
            <span class="afValue afUnderline">&#160; 
            <xsl:call-template name="Время">
				<xsl:with-param name="pTime" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:РассмотрениеАкта/ns1:Время"/>
			</xsl:call-template>&#160;</span>	часов </p>
			
			<table class="afTable100">
				<tr>
					<td class="afTable20 afValue afAlignBotom"><p class="afP afUnderlinedBlock">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:РассмотрениеАкта/ns1:Дата"/>
						</xsl:call-template></p>
					</td>
					<td class="afTable3 afAlignBotom"><p class="afP"> в </p></td>
					<td class="afValue afAlignBotom"><p class="afP afUnderlinedBlock"><xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Наименование"/></p></td>
				</tr>
				<tr>
					<td class="afTable20 afAlignBotom afSubscript afCenter">(дата)</td>
					<td class="afTable3 afAlignBotom afSubscript afCenter">&#160;</td>
					<td class="afAlignBotom afSubscript afCenter">(наименование территориального органа CФР)</td>
				</tr>
			</table>
			<div class="afRow ">
				<div class="afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:ТерриториальныйОрганПФР/ФС2:Адрес"/>
				</div>
				<p class="afSubscript afCenter">(адрес территориального органа CФР)</p>
            </div>
            <p class="afInterval"/>
        	<p class="afParagraph">По результатам рассмотрения будет принято Решение о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования или Решение об отказе в привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования (далее – Решение о привлечении (об отказе в привлечении) страхователя к ответственности)<span class="afSup">6</span>. </p>
            <p class="afParagraph">В случае неявки страхователя Решение о привлечении (отказе в привлечении) страхователя к ответственности будет принято в его отсутствие. </p>
			<p class="afInterval"/>
        	<table class="afTable100 afNoBreakInside">
			<tbody class="afAlignBotom">
				<tr>
					<td class="afTable40" style="vertical-align: text-top;"><p class="afP">Подпись должностного лица территориального органа CФР, проводившего проверку</p></td>
					<td class="afTable20">&#160;</td>
					<td class="afTable20"><p class="afP afUnderlinedBlock">&#160;</p><p class="afCenter afSubscript">(подпись)</p></td>
					<td class="afTable20">
						<p class="afP afUnderlinedBlock afValue">
							<xsl:call-template name="УТ2:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Проверяющий/УТ2:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afCenter afSubscript">(Ф.И.О.)</p>
					</td>
				</tr>
				<tr><br/></tr>
				<p class="afInterval"/>
				<tr>
					<td class="afTable40" style="vertical-align: text-top;"><p class="afP">Подпись руководителя юридического лица (обособленного подразделения) с указанием должности физического лица, в том числе индивидуального предпринимателя (уполномоченного представителя)<span class="afSup">7</span></p></td>
					<td class="afTable20"><p class="afP afUnderlinedBlock afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Руководитель/УТ2:Должность"/></p><p class="afCenter afSubscript">(должность)</p></td>
					<td class="afTable20"><p class="afP afUnderlinedBlock">&#160;</p><p class="afCenter afSubscript">(подпись)</p></td>
					<td class="afTable20">
						<p class="afP afUnderlinedBlock afValue">
							<xsl:call-template name="УТ2:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Руководитель/УТ2:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afCenter afSubscript">(Ф.И.О.)</p>
					</td>
				</tr>				
			</tbody>
		</table>
		<p class="afInterval"/><p class="afInterval"/>
		
		<div class="afRow">
			<div class="afCol-3-10">Экземпляр настоящего акта с</div>
			<div class="afCol-1-5 afUnderlinedBlock">&#160;</div>	
			<div class="afCol-1-6">&#160; приложениями на</div>
			<div class="afCol-1-10 afUnderlinedBlock">&#160;</div>
			<div class="afCol-1-4">&#160; листах получил лично:</div>
		</div>
		<p class="afSubscript afMarginLeft220">(количество приложений)</p>
		

		
		<div class="afRow">
			<div class="afValue afUnderlinedBlock">&#160;</div>
			<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
		</div>
		<div class="afRow">
			<div class="afValue afUnderlinedBlock">&#160;</div>
			<p class="afSubscript afCenter">или Ф.И.О. физического лица, в том числе индивидуального предпринимателя (уполномоченного представителя)</p>
		</div>
		<p class="afInterval"/>
		<div class="afRow">
			<div class="afCol-1-10">&#160;</div>
			<div class="afCol-1-4">
				<div class="afUnderlinedBlock">&#160;</div>
				<p class="afSubscript afCenter">(подпись)</p>
			</div>
			<div class="afCol-1-10">&#160;</div>
			<div class="afCol-1-4">
				<div class="afUnderlinedBlock">&#160;</div>
				<p class="afSubscript afCenter">(дата)</p>
			</div>
		</div>
		<!--
		<div class="afRow">
			<div class="afCol-8-10">Лицо, совершившее правонарушение, от подписи и получения настоящего акта уклоняется<span class="afSup">4</span></div>
			<div class="afCol-1-5 afUnderlinedBlock">&#160;</div>	
		</div>
		
		<div class="afRow">
			<div class="afValue afUnderlinedBlock">
				<xsl:choose>
					<xsl:when test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ФИО">
						<xsl:call-template name="УТ2:NameStr">
							<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Страхователь/УТ2:ФИО"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Руководитель/УТ2:Должность"/>,&#160; 
							<xsl:call-template name="УТ2:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Руководитель/УТ2:ФИО"/>
							</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения), Ф.И.О. индивидуального предпринимателя, физического лица (уполномоченного представителя)</p>
		</div>
		-->
        	<p class="afInterval"/><p class="afInterval"/>
		<p class="afParagraph">Направить настоящий акт: </p>
		<div class="afRow">
			<div class="afC afCheck">
				<xsl:if test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Уклонение/ns1:СпособНаправления [text() = '1']">V</xsl:if>
			</div>
			<div class="afCol-1-7">по почте</div>
			<div class="afCol-4-5">
				(в случае направления акта по почте заказным письмом датой вручения этого акта считается шестой день считая с даты отправления заказного письма<span class="afSup">8</span>);
			</div>
		</div>
  
		<div class="afRow">
			<div class="afC afCheck">
				<xsl:if test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Уклонение/ns1:СпособНаправления [text() = '2']">V</xsl:if>
			</div>
			<div class="afCol-1-2">по телекоммуникационным каналам связи</div>
		</div>
		
		
		<p class="afInterval"/>
		<div class="afRow">
			<div class="afCol-1-10">&#160;</div>
			<div class="afCol-1-4">
				<div class="afUnderlinedBlock">&#160;</div>
				<p class="afSubscript afCenter">(подпись лица, проводившего проверку)</p>
			</div>
			<div class="afCol-1-10">&#160;</div>
			<div class="afCol-1-4">
				<div class="afUnderlinedBlock">&#160;</div>
				<p class="afSubscript afCenter">(дата)</p>
			</div>
		</div>
		<p class="afInterval"/>
        	<!--
		<p class="afParagraph afSubscriptNormal">Примечание. </p>
		
		<p class="afParagraph afSubscriptNormal">Акт в течение пяти дней с даты подписания этого акта должен быть вручен лицу, в отношении которого проводилась проверка (его уполномоченному представителю), лично под расписку, направлен по почте заказным письмом или передан в электронном виде по телекоммуникационным каналам связи. В случае направления указанного акта по почте заказным письмом оно считается полученным по истечении шести дней с даты отправления заказного письма. </p>
		-->
        	<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
		
		_________________________________
        <p class="afFootnote afParagraph"><span class="afSup">1</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</p>
        <p class="afFootnote afParagraph"><span class="afSup">2</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 29, ст. 5204.</p>
        <p class="afFootnote afParagraph"><span class="afSup">3</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 29, ст. 5204.</p>
        <p class="afFootnote afParagraph"><span class="afSup">4</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 41, ст. 6941.</p>
        <p class="afFootnote afParagraph"><span class="afSup">5</span> Не заполняется в случае представления страхователем сведений, предусмотренных подпунктом 5 пункта 2 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ.</p>
        <p class="afFootnote afParagraph"><span class="afSup">6</span> Часть 11 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2016, № 27, ст. 4183; 2022, № 29, ст. 5204).</p>
        <p class="afFootnote afParagraph"><span class="afSup">7</span> В случае если проверка проводилась в присутствии страхователя.</p>
        <p class="afFootnote afParagraph"><span class="afSup">8</span> Часть 7 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2016; № 27, 4183).</p>
        	

		

        </div>
    </xsl:template>
    <xsl:template name="Время">
        <xsl:param name="pTime" />
        <xsl:variable name="timeText" select="string($pTime)"/>
        <xsl:value-of select="concat(substring($timeText, 1, 2), '.', substring($timeText, 4, 2))"/>
    </xsl:template>

</xsl:stylesheet>
