<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ ns1 ФС" version="1.0"
    xmlns:УТ="http://пф.рф/унифицированныеТипы/2014-01-01" xmlns:ns1="http://пф.рф/ВС/ФС/РОПОП-ПУ/2017-05-21" xmlns:ФС="http://пф.рф/ВС/ФС/типы/2017-05-21">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../../Общие/УнифТипы_2014-01-01.xsl"/>
    
    <xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:РОПОП-ПУ"/>
        <div class="afWrap pfrAfROPOP-PU">

        	<div class="afRight-1-3">
        		<p class="afSubscript">Приложение № 3</p>
        		<p class="afSubscript"><br/></p>
        		<p class="afSubscript">к приказу Фонда пенсионного и</p>
        		<p class="afSubscript">социального страхования</p>
        		<p class="afSubscript">Российской Федерации</p>
        		<p class="afSubscript"><br/></p>
        		<p class="afSubscript">от 2 марта 2023 г</p>
        		<p class="afSubscript"><br/></p>
        		<p class="afSubscript">№ 302</p>
        	</div>
        	
			<table class="afTable40">
				<tr>
					<td><xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Наименование"/></td>
				</tr>
				<tr>
					<td><xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Адрес"/></td>
				</tr>
				<tr>
					<td>ТЕЛ. ФАКС <xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Телефоны/УТ:Телефон" /></td>
				</tr>
			</table>
  
        	
        	<p class="afInterval"/>
        	<p class="afInterval"/>
        	<p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afCenter afHeader">Решение</p>
            <p class="afCenter afHeader">об отказе в привлечении страхователя к ответственности за совершение правонарушения </p>
            <p class="afCenter afHeader">в сфере законодательства Российской Федерации об индивидуальном</p>
        	<p class="afCenter afHeader">(персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования</p>
            <p class="afInterval"/>
            
            <div class="afRow">
				<div class="afCol-2-25">от</div>
				<div class="afCol-1-5">
					<p class="afValue afCenterBlock afUnderlinedBlock">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="$vForm/ns1:Реквизиты/УТ:Дата"/>
						</xsl:call-template>
					</p>
					<p class="afSubscript afCenter">(дата)</p>
				</div>
				<div class="afCol-4-10">&#160;</div>
				<div class="afCol-2-25 afCenterBlock">№</div>
				<div class="afCol-1-5 afValue afCenterBlock afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Реквизиты/УТ:Номер"/>
				</div>
			</div>
            <p class="afInterval"/>
            <div class="afRow afValue afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:РуководительТОПФР/УТ:Должность"/>	
            </div>
            <p class="afSubscript afCenter">(должность руководителя (заместителя руководителя) территориального органа СФР)</p>
            <div class="afRow afValue afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Наименование"/>	
            </div>
			<p class="afSubscript afCenter">(наименование территориального органа СФР)</p>
              <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:call-template name="УТ:NameStr">
						<xsl:with-param name="pName" select="$vForm/ns1:РуководительТОПФР/УТ:ФИО"/>
					</xsl:call-template> 
				</div>
				<p class="afSubscript afCenter">(Ф.И.О. руководителя (заместителя руководителя) территориального органа СФР)</p>
            </div>
            <p class="afInterval"/>
        	<p class="afP afJustify">рассмотрев акт о выявлении   правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:РеквизитыАкта/УТ:Дата"/></xsl:call-template>  &#160;</span> № <span class="afValue afUnderline">&#160;&#160;  <xsl:value-of select="$vForm/ns1:РеквизитыАкта/УТ:Номер"/> &#160;</span>, который    составлен в ходе проверки, проведенной  с целью контроля правильности заполнения, полноты, порядка и своевременности представления сведений индивидуального (персонифицированного) учета</p>
            <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Наименование">
							<xsl:value-of select="$vForm/ns1:Страхователь/ФС:Наименование"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/УТ:ФИО">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</div>
            	<p class="afSubscript afCenter">(полное наименование юридического лица (обособленного подразделения),<br/> Ф.И.О. физического лица в том числе индивидуального предпринимателя)</p>
            </div>
        	<p class="afInterval"/> 
      
             <div class="afRow">
				<div class="afCol-4-10">регистрационный номер в СФР</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ:РегНомер"/>
				</div>
			</div>
            <div class="afRow">
				<div class="afCol-4-10">ИНН</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ:ИНН"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-4-10">КПП</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ:КПП"/>
				</div>
            </div>
            <div class="afRow">
            	<div class="afCol-4-10">Адрес в пределах места нахождения юридического лица (обособленного подразделения)/адрес регистрации физического лица, в том числе индивидуального предпринимателя</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<br/><br/>
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Адрес/УТ:Иностранный">
							<xsl:call-template name="УТ:AddressForeignStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Страхователь/ФС:Адрес" />
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Адрес/УТ:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:Страхователь/ФС:Адрес/УТ:Неструктурированный"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Страхователь/ФС:Адрес"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
            </div>
            <p class="afP afJustify">другие материалы проверки и иные документы, имеющиеся у территориального органа СФР:  </p>
            <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:if test="$vForm/ns1:МатериалыПроверки">
						<xsl:for-each select="$vForm/ns1:МатериалыПроверки/ns1:Документ">
							<xsl:if test="position() != 1">, </xsl:if>
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:if>	
				</div>
				<p class="afSubscript afCenter">(указываются конкретные документы и иные материалы)</p>
            </div>
            <div class="afRow">
				<div class="afUnderlinedBlockLeft">
					а также&#160;
					<p class="afP afValue">
						<xsl:if test="$vForm/ns1:Возражения">
							<xsl:for-each select="$vForm/ns1:Возражения/ns1:Возражение">
								<xsl:if test="position() != 1">;&#160;</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:if>
					</p>	
				</div>
				<p class="afSubscript afCenter">(указываются письменные возражения страхователя, в отношении которого проводилась проверка (его уполномоченного представителя)</p>
            </div>
            <p class="afP afJustify">при участии лица, в отношении которого проводилась проверка (его уполномоченного представителя)<span class="afFootnoteRef">1</span></p>
            <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Руководитель">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Руководитель/УТ:ФИО"/>
							</xsl:call-template>, 
							<xsl:value-of select="$vForm/ns1:Руководитель/УТ:Должность"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Представитель">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Представитель"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afSubscript afCenter">(Ф.И.О., должность - при необходимости)</p>
            </div>
            
        	<p class="afP afJustify">при отсутствии лица, в отношении которого проводилась проверка (его уполномоченного представителя), извещенного надлежащим образом о времени и месте рассмотрения материалов проверки, что подтверждается записью в акте о выявлении правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:РеквизитыАкта/УТ:Дата"/></xsl:call-template>  &#160;</span> № <span class="afValue afUnderline">&#160;&#160;  <xsl:value-of select="$vForm/ns1:РеквизитыАкта/УТ:Номер"/> &#160;</span><span class="afFootnoteRef">2</span>, в связи с чем принято   решение о рассмотрении материалов проверки в отсутствие лица, в отношении которого проводилась проверка (его уполномоченного представителя),<span class="afFootnoteRef">3</span> </p>
           

			
        	<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
            <p class="afCenter afHeader">УСТАНОВИЛ:</p>
            <p class="afInterval"/>
        	<div class="afRow afNoBreakInside">
				<div class="afUnderlinedBlockLeft">
					<p class="afP afValue afJustify">
						<xsl:if test="$vForm/ns1:Нарушения">
							<xsl:for-each select="$vForm/ns1:Нарушения/ns1:Нарушение">
								<xsl:if test="position() != 1">;&#160;</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:if>
					</p>	
				</div>
             	<p class="afSubscript afCenter">(документально подтвержденные факты нарушения законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования, со ссылкой на документы и иные сведения, подтверждающие обстоятельства, служащие основанием для отказа в привлечении страхователя к ответственности за совершение нарушения законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования)</p>
            </div>
        	<p class="afInterval"/>
        	<p class="afParagraph">Руководствуясь статьей 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования»<span class="afFootnoteRef">4</span> (далее – Федеральный закон от 1 апреля 1996 г. № 27-ФЗ), на основании</p>
             
            <div class="afRow">
				<div class="afUnderlinedBlockLeft">
					<p class="afP afValue afJustify">
						<xsl:if test="$vForm/ns1:ОбстоятельстваОтказа">
							<xsl:for-each select="$vForm/ns1:ОбстоятельстваОтказа/ns1:Обстоятельство">
								<xsl:if test="position() != 1">;&#160;</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:if>
					</p>	
				</div>
            	<p class="afSubscript afCenter">(указываются обстоятельства отказа в привлечении страхователя к ответственности за совершение нарушения законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования)</p>
            </div>
             
             
        	<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
            <p class="afCenter afHeader">ПРИНЯТО РЕШЕНИЕ:</p>
        	<p class="afInterval"/><p class="afInterval"/>
            
            <div class="afRow">
				<div class="afC afMarginLeft30">1. Об отказе в привлечении к ответственности </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft320">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Наименование">
							<xsl:value-of select="$vForm/ns1:Страхователь/ФС:Наименование"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/УТ:ФИО">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</div>
        	<p class="afSubscript afCenter afMarginLeft320">(полное наименование юридического лица, Ф.И.О. физического лица, в том числе индивидуального предпринимателя)</p>
			<p class="afInterval"/>
        	<p class="afP afJustify">за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования.</p>
			
			
			<div class="afRow">
				<div class="afC afMarginLeft30">2. О необходимости внесения необходимых исправлений в документы кадрового учета и представления уточненных (исправленных) сведений в территориальный орган СФР<span class="afFootnoteRef">5</span>. 
				</div>
			</div>
			
			<div class="afRow">
				<div class="afC afMarginLeft30">3. </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft50">
					<xsl:if test="$vForm/ns1:ИныеПредложения/ns1:Предложение">
						<xsl:for-each select="$vForm/ns1:ИныеПредложения/ns1:Предложение">
							<xsl:if test="position() != 1">;&#160;</xsl:if>
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:if>
				</p>
			</div>
			
			<p class="afParagraph">Настоящее решение вступает в силу по истечении 10 рабочих дней со дня его вручения лицу (его уполномоченному представителю), в отношении которого оно вынесено.</p>
			<p class="afParagraph">Настоящее решение может быть обжаловано в течение трех месяцев со дня, когда лицо, в отношении которого оно принято, узнало или должно было узнать о нарушении его прав<span class="afFootnoteRef">6</span>, в</p>

			<div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:ВышестоящийТОПФР">
							<xsl:value-of select="$vForm/ns1:ВышестоящийТОПФР/ns1:Наименование"/>, 
							<xsl:call-template name="АдресРФ">
								<xsl:with-param name="pAddress" select="$vForm/ns1:ВышестоящийТОПФР/ns1:Адрес"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afSubscript afCenter">(указывается наименование вышестоящего органа СФР и его местонахождение)</p>
            </div>
        	<p class="afInterval"/>
            <p class="afP">путем подачи жалобы в письменной форме.</p>
            
            <p class="afInterval"/>
        	<div class="afRow afNoBreakInside">
				<div class="afCol-1-10">&#160;</div>
				<div class="afCol-1-4">
					<div class="afUnderlinedBlock">&#160;</div>
					<p class="afSubscript afCenter">(подпись)</p>
				</div>
				<div class="afCol-1-10">&#160;</div>
				<div class="afCol-1-4">
					<div class="afUnderlinedBlock">
						<xsl:call-template name="УТ:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:РуководительТОПФР/УТ:ФИО"/>
						</xsl:call-template>
					</div>
					<p class="afSubscript afCenter">(Ф.И.О.)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afParagraph">Место печати территориального органа СФР</p>
			<p class="afInterval"/><p class="afInterval"/>
			
		
        	<p class="afParagraph">Решение об отказе в привлечении к ответственности страхователя за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования получил. <span class="afFootnoteRef">7</span></p>
		<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
		
		
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Руководитель">
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:value-of select="$vForm/ns1:Руководитель/УТ:Должность"/>, 
									<xsl:call-template name="УТ:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:Руководитель/УТ:ФИО"/>
									</xsl:call-template>
								</div>
								<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">&#160;</div>
								<p class="afSubscript afCenter">или Ф.И.О. физического лица, в том числе индивидуального предпринимателя, (уполномоченного представителя))</p>
							</div>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Представитель">
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">&#160;</div>
								<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:Представитель"/>
									</xsl:call-template>
								</div>
								<p class="afSubscript afCenter">или Ф.И.О. физического лица, в том числе индивидуального предпринимателя, (уполномоченного представителя))</p>
							</div>	
						</xsl:when>
						<xsl:otherwise>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">&#160;</div>
								<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
							</div>
							<div class="afRow">
								<div class="afValue afUnderlinedBlock">
									<xsl:call-template name="УТ:NameStr">
										<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
									</xsl:call-template>
								</div>
								<p class="afSubscript afCenter">или Ф.И.О. физического лица, в том числе индивидуального предпринимателя, (уполномоченного представителя))</p>
							</div>	
						</xsl:otherwise>
					</xsl:choose>
					
					<p class="afInterval"/>
						<div class="afRow">
							<div class="afCol-1-10">&#160;</div>
							<div class="afCol-1-4">
								<div class="afUnderlinedBlock">&#160;</div>
								<p class="afSubscript afCenter">(подпись)</p>
							</div>
							<div class="afCol-1-10">&#160;</div>
							<div class="afCol-1-4">
								<div class="afUnderlinedBlock">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="$vForm/ns1:ДатаВручения"/>
									</xsl:call-template>
								</div>
								<p class="afSubscript afCenter">(дата)</p>
							</div>
						</div>
        	<!--
						<p class="afInterval"/><p class="afInterval"/>
						<p class="afParagraph afSubscriptNormal">Примечание. </p>
						<p class="afParagraph afSubscriptNormal">Решение об отказе в привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системе обязательного пенсионного страхования в течение пяти дней после дня его вынесения может быть вручено страхователю, в отношении которого вынесено соответствующее решение (его уполномоченному представителю), лично под расписку, направлено по почте заказным письмом или передано в электронном виде по телекоммуникационным каналам связи. В случае направления указанного решения по почте заказным письмом оно считается полученным по истечении шести дней с даты отправления заказного письма. </p>
						<p class="afInterval"/><p class="afInterval"/>
			-->
        	<p class="afInterval"/>
        	<p class="afParagraph">Направить настоящее решение: </p>
        	<div class="afRow">
        		<div class="afC afCheck">
        			<xsl:if test="/ns1:ЭДПФР/ns1:РОПОП-ПУ/ns1:Уклонение/ns1:СпособНаправления [text() = '1']">V</xsl:if>
        		</div>
        		<div class="afCol-1-7">по почте</div>
        		<div class="afCol-4-5">
        			(в случае направления решения по почте заказным письмом датой вручения этого решения считается шестой день считая с даты отправления заказного письма
        			<span class="afSup">8</span>);
        		</div>
        	</div>
        	
        	<div class="afRow">
        		<div class="afC afCheck">
        			<xsl:if test="/ns1:ЭДПФР/ns1:РОПОП-ПУ/ns1:Уклонение/ns1:СпособНаправления [text() = '2']">V</xsl:if>
        		</div>
        		<div class="afCol-1-2">по телекоммуникационным каналам связи</div>
        	</div>
        	<p class="afInterval"/><p class="afInterval"/>

		_________________________________
		<p class="afFootnote afParagraph"><span class="afFootnoteRef">1</span> Заполняется в случае явки лица, в отношении которого проводилась проверка.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">2</span> Часть 10 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2016, № 27, ст. 4183; 2022, № 29, ст. 5204).</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">3</span> Заполняется в случае отсутствия лица, в отношении которого проведена проверка (его уполномоченного представителя).</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">4</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">5</span> Сведения представляются при обнаружении ошибок (несоответствий).</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">6</span> Часть 14 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, 
        		ст. 1401; 2016, № 27, ст. 4183; 2022, № 29, ст. 5204).</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">7</span> Заполняется в случае вручения решения об отказе в привлечении к ответственности страхователя за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования непосредственно соответствующему лицу.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">8</span> Часть 12 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, 
        		ст. 1401; 2016; № 27, 4183).</p>
        	
        	
		

        </div>
    </xsl:template>
    <xsl:template name="Время">
        <xsl:param name="pTime" />
        <xsl:variable name="timeText" select="string($pTime)"/>
        <xsl:value-of select="concat(substring($timeText, 1, 2), '.', substring($timeText, 4, 2))"/>
    </xsl:template>
    
     <xsl:template name="АдресРФ">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ГруппаАдрес">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Регион">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Регион" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Район">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Район" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Город">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Город" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:НаселенныйПункт">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:НаселенныйПункт" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Улица">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Улица" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Дом">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Дом" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Строение">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Строение" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Корпус">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Корпус" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Квартира">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Квартира" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="География">
        <xsl:param name="pGEO" />
        <xsl:value-of select="$pGEO/УТ:Название"/>
        <xsl:if test="$pGEO/УТ:Сокращение"><xsl:value-of select="concat(' ', $pGEO/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="Нумерация">
        <xsl:param name="pNum" />
        <xsl:value-of select="$pNum/УТ:Номер"/>
        <xsl:if test="$pNum/УТ:Сокращение"> <xsl:value-of select="concat(' ', $pNum/УТ:Сокращение)"/></xsl:if>
    </xsl:template>

</xsl:stylesheet>
