<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:x="http://пф.рф/ВС/ФС/РПОП-ПУ/2017-05-21" xmlns:ФС="http://пф.рф/ВС/ФС/типы/2017-05-21" xmlns:УТ="http://пф.рф/унифицированныеТипы/2014-01-01" xmlns:АФ="http://пф.рф/АФ">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:attribute-set name="block">
        <xsl:attribute name="font-family">Arial</xsl:attribute>
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="text-align">justify</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="solidBorder">
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
        <xsl:attribute name="padding">2pt</xsl:attribute>
    </xsl:attribute-set>

    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simple" page-height="29.7cm" page-width="21cm"
                    margin-top="1cm" margin-bottom="2cm" margin-left="2.5cm" margin-right="2.5cm">
                    <fo:region-body margin-top="0.5cm" margin-bottom="0cm"/>
                    <fo:region-before extent="2cm"/>
                    <fo:region-after extent="1.5cm"/>
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simple">
                <fo:flow flow-name="xsl-region-body">
                    <!-- ****ДОКУМЕНТ РПОП-ПУ**** -->
                    <fo:block xsl:use-attribute-sets="block">
                        
                        <!-- ШАПКА ДОКУМЕНТА -->
                        <fo:table>
                            <fo:table-column column-width="60%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block><xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:ТерриториальныйОрганПФР/ФС:Адрес" />                                            
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>ТЕЛ. ФАКС <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:ТерриториальныйОрганПФР/ФС:Телефоны/УТ:Телефон" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        
                        <!-- НАИМЕНОВАНИЕ ДОКУМЕНТА -->
                        <fo:block margin-top="10pt" margin-bottom="10pt" text-align="center" font-weight="bold">
                            <fo:block>Решение</fo:block>
                            <fo:block>о привлечении страхователя к ответственности за совершение правонарушения в</fo:block>
                            <fo:block>сфере законодательства Российской Федерации об индивидуальном</fo:block>
                            <fo:block>(персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования</fo:block>
                        </fo:block>
                        
                        <!-- РЕКВИЗИТЫ ДОКУМЕНТА -->
                        <fo:table>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>от</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:call-template name="ДатаСтрока">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:РПОП-ПУ/x:Реквизиты/УТ:Дата" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>№</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Реквизиты/УТ:Номер"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- РУКОВОДИТЕЛЬ ТО СФР -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="concat(/x:ЭДПФР/x:РПОП-ПУ/x:РуководительТОПФР/УТ:Должность, ' ')"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(должность руководителя (заместителя руководителя) территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" />
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(наименование территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:call-template name="ФИО">
                                                <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:РуководительТОПФР/УТ:ФИО" />
                                            </xsl:call-template>,
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О. руководителя (заместителя руководителя) территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="17%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="68%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block>рассмотрев акт о выявлении правонарушения в сфере законодательства Российской Федерации</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block>об индивидуальном (персонифицированном) учете в системах обязательного пенсионного</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>страхования и обязательного социального страхования от</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin" text-align="center">
                                            <xsl:call-template name="Дата">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:РПОП-ПУ/x:РеквизитыАкта/УТ:Дата" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <fo:inline>№</fo:inline>
                                            <fo:inline font-weight="bold" text-decoration="underline"><xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:РеквизитыАкта/УТ:Номер"/></fo:inline>
                                            <fo:inline>, который составлен в ходе проверки,</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block>проведенной с целью контроля правильности заполнения, полноты, порядка и своевременности</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block>представления сведений индивидуального (персонифицированного) учета</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- СТРАХОВАТЕЛЬ -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="97%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Наименование">
                                                    <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Наименование" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИО">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(полное наименование юридического лица (обособленного подразделения), Ф.И.О. физического лица, в том числе индивидуального предпринимателя)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                                
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-column column-width="54%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-body>        
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>регистрационный номер в СФР</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:РегНомер" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>ИНН</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:ИНН" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>КПП</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:КПП" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>Адрес в пределах места нахождения</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>юридического лица (обособленного</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>подразделения) / адрес регистрации физического</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>лица, в том числе индивидуального предпринимателя</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:call-template name="АдресОбщий">
                                                <xsl:with-param name="pAddress" select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Адрес" />
                                            </xsl:call-template>,
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- ПЕРЕЧЕНЬ ДОКУМЕНТОВ И ИНЫХ МАТЕРИАЛОВ -->
                        <fo:block margin-top="10pt">другие материалы и иные документы, имеющиеся у  территориального органа СФР:</fo:block>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:for-each select="/x:ЭДПФР/x:РПОП-ПУ/x:МатериалыПроверки/x:Документ">
                                                <xsl:if test="position() != 1">, </xsl:if>
                                                <xsl:value-of select="./text()"/>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(указываются конкретные документы и иные материалы)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- ВОЗРАЖЕНИЯ -->
                        <fo:block margin-top="10pt">а также</fo:block>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:for-each select="/x:ЭДПФР/x:РПОП-ПУ/x:Возражения/x:Возражение">
                                                <xsl:if test="position() != 1">, </xsl:if>
                                                <xsl:value-of select="./text()"/>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(указываются письменные возражения страхователя, в отношении которого проводилась проверка (его уполномоченного представителя))</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:if test="not(/x:ЭДПФР/x:РПОП-ПУ/x:Возражения)">возражения не представлены</xsl:if>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block>при участии лица, в отношении которого проводилась проверка (его уполномоченного представителя) &lt;1&gt;</fo:block>
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:РПОП-ПУ/x:Руководитель">
                                                    <xsl:value-of select="concat(/x:ЭДПФР/x:РПОП-ПУ/x:Руководитель/УТ:Должность, ', ')"/>
                                                    <xsl:call-template name="ФИОКороткое">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:Руководитель/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:when>
                                                <xsl:when test="/x:ЭДПФР/x:РПОП-ПУ/x:Представитель">
                                                    <xsl:call-template name="ФИОКороткое">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:Представитель" />
                                                    </xsl:call-template>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИОКороткое">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О., должность - при необходимости)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="53%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="32%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block>при отсутствии лица, в отношении которого проводилась проверка (его уполномоченного представителя), извещенного надлежащим образом о времени и месте рассмотрения
                                        материалов проверки, что подтверждается записью в акте о выявлении правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>системах обязательного пенсионного страхования и обязательного социального страхования от</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin" text-align="center">
                                            <xsl:call-template name="Дата">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:РПОП-ПУ/x:РеквизитыАкта/УТ:Дата" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <fo:inline>№</fo:inline>
                                            <fo:inline font-weight="bold" text-decoration="underline"><xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:РеквизитыАкта/УТ:Номер"/></fo:inline>
                                            <fo:inline>&lt;2&gt;, в </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block>связи с чем принято решение о рассмотрении материалов проверки в отсутствии лица, в отношении которого проводилась проверка (его уполномоченного представителя), &lt;3&gt;</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- УСТАНОВИЛ -->
                        <fo:block margin-top="20pt" margin-bottom="10pt" text-align="center" font-weight="bold">УСТАНОВИЛ:</fo:block>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:for-each select="/x:ЭДПФР/x:РПОП-ПУ/x:Нарушения/x:Нарушение">
                                                <xsl:if test="position() != 1">, </xsl:if>
                                                <xsl:value-of select="./text()"/>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(документально подтвержденные факты нарушения законодательства Российской Федерации об индивидуальном (персонифицированном)
                                            учете в в системах обязательного пенсионного страхования и обязательного социального страхования, со ссылкой на документы и иные сведения, подтверждающие обстоятельства)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt" text-indent="2.2em">Руководствуясь статьей 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования 
                            и обязательного социального страхования»&lt;4&gt; (далее - Федеральный закон от 1 апреля 1996 г. № 27-ФЗ),</fo:block>
                        
                        <!-- ПРИНЯТО РЕШЕНИЕ -->
                        <fo:block margin-top="20pt" margin-bottom="10pt" text-align="center" font-weight="bold">ПРИНЯТО РЕШЕНИЕ:</fo:block>
                        <fo:block margin-top="5pt" text-indent="2.2em">1. О привлечении</fo:block>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Наименование">
                                                    <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Наименование" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИО">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(полное наименование юридического лица, Ф.И.О. физического лица, в том числе индивидуального предпринимателя)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:block margin-top="5pt">к ответственности, предусмотренной:</fo:block>
                        <fo:table margin-top="5pt" font-size="8pt">
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="30%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="35%"/>
                            <fo:table-header>        
                                <fo:table-row text-align="center">
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>№ п/п</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>Часть и статья Федерального закона от 1 апреля 1996 г. № 27-ФЗ</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>Наименование выявленного нарушения</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>Финансовая санкция (в рублях, копейках)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>Код бюджетной классификации</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-header>
                            <fo:table-body>
                                <xsl:for-each select="/x:ЭДПФР/x:РПОП-ПУ/x:Основания/x:Основание">
                                    <fo:table-row>
                                        <fo:table-cell text-align="center" xsl:use-attribute-sets="solidBorder">
                                            <fo:block><xsl:value-of select="position()"/></fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                            <fo:block> 
                                                Ч. <xsl:value-of select="./x:Часть"/>
                                                СТ. <xsl:value-of select="./x:Статья"/>
                                                № 27-ФЗ
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                            <fo:block><xsl:value-of select="./x:Состав"/></fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                            <fo:block>
                                                <xsl:call-template name="Сумма">
                                                    <xsl:with-param name="pSumm" select="./x:Сумма" />
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                            <fo:block><xsl:value-of select="./x:КБК"/></fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="right">Итого:</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>
                                            <xsl:call-template name="Сумма">
                                                <xsl:with-param name="pSumm" select="/x:ЭДПФР/x:РПОП-ПУ/x:СуммаИтого" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt" text-indent="2.2em">2. В отношении</fo:block>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Наименование">
                                                    <xsl:value-of select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/ФС:Наименование" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИО">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(полное наименование юридического лица, Ф.И.О. индивидуального предпринимателя, физического лица)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:block margin-top="5pt" text-indent="2.2em">2.1. Об уплате финансовых санкций, указанных в пункте 1 настоящего решения;</fo:block>
                        <fo:block margin-top="5pt" text-indent="2.2em">2.2. О внесении необходимых исправлений в документы кадрового учета и представлении уточненных (исправленных) сведений в территориальный орган СФР&lt;5&gt;.</fo:block>
                        <fo:block margin-top="5pt" text-indent="2.2em">2.3. Иные предложения</fo:block>
                        <fo:block margin-top="5pt" text-indent="2.2em">Настоящее решение вступает в силу по истечении 10 рабочих дней со дня его вручения лицу (его уполномоченному представителю), в отношении которого
                            оно вынесено</fo:block>
                        <fo:block margin-top="5pt" text-indent="2.2em">Настоящее решение может быть обжаловано в течение трех месяцев со дня, когда лицо, в отношении которого оно принято, узнало или должно было узнать о
                            нарушении его прав &lt;6&gt;, в</fo:block>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="concat(/x:ЭДПФР/x:РПОП-ПУ/x:ВышестоящийТОПФР/x:Наименование, ', ')" />
                                            <xsl:call-template name="АдресРФ">
                                                <xsl:with-param name="pAddress" select="/x:ЭДПФР/x:РПОП-ПУ/x:ВышестоящийТОПФР/x:Адрес" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(указывается наименование вышестоящего органа СФР и его местонахождение)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:block margin-top="5pt">путем подачи жалобы в письменной форме.</fo:block>
                        
                        <fo:table margin-top="20pt">
                            <fo:table-column column-width="10%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin" text-align="center">
                                            <xsl:call-template name="ФИОКороткое">
                                                <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:РПОП-ПУ/x:РуководительТОПФР/УТ:ФИО" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О.)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:block margin-top="5pt">Место печати территориального органа CФР.</fo:block>
                        <!--
                        <fo:block font-size="8pt" margin-top="10pt" text-indent="2.2em">Примечание.</fo:block>
                        <fo:block font-size="8pt" text-indent="2.2em">Решение о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном
                            (персонифицированном) учете в системе обязательного пенсионного страхования в течение пяти дней после дня его вынесения может быть вручено страхователю, в отношении которого вынесено
                            соответствующее решение (его уполномоченному представителю), лично под расписку, направлено по почте заказным письмом или передано в электронном виде по телекоммуникационным каналам связи.
                            В случае направления указанного решения по почте заказным письмом оно считается полученным по истечении шести дней с даты отправления заказного письма.</fo:block>
                        -->
                        <!-- СНОСКИ -->
                        <fo:block>
                            <fo:block margin-top="5pt" margin-bottom="10pt">_________________________________</fo:block>
                            <fo:block font-size="8pt">&lt;1&gt; Заполняется в случае явки лица, в отношении которого проводилась проверка.</fo:block>
                            <fo:block font-size="8pt">&lt;2&gt; Часть 10 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2016, № 27, ст. 4183; 2022, № 29, ст. 5204).</fo:block>
                            <fo:block font-size="8pt">&lt;3&gt;  Заполняется в случае отсутствия лица, в отношении которого проведена проверка (его уполномоченного представителя).</fo:block>
                            <fo:block font-size="8pt">&lt;4&gt; Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</fo:block>
                            <fo:block font-size="8pt">&lt;5&gt; Сведения представляются при обнаружении ошибок (несоответствий).</fo:block>
                            <fo:block font-size="8pt">&lt;6&gt; Часть 14 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, 
                                ст. 1401; 2016, № 27, ст. 4183; 2022, № 29, ст. 5204).</fo:block>
                            <fo:block font-size="8pt">&lt;7&gt; Заполняется в случае вручения решения о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования непосредственно соответствующему лицу.</fo:block>
                            <fo:block font-size="8pt">&lt;8&gt; Часть 12 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, 
                                ст. 1401; 2016; № 27, 4183).</fo:block>
                        </fo:block>
                        
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="Сумма">
        <xsl:param name="pSumm"/>
        <xsl:choose>
            <xsl:when test="string-length(substring-after(string($pSumm), '.') = 0)">
                <fo:inline font-weight="bold" text-decoration="underline">
                    <xsl:value-of select="concat($pSumm, '.00')" />
                </fo:inline>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$pSumm" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="АдресРФ">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="АдресОбщий">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress/УТ:РоссийскийАдрес" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ГруппаАдрес">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Регион">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Регион" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Район">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Район" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Город">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Город" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:НаселенныйПункт">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:НаселенныйПункт" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Улица">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Улица" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Дом">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Дом" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Строение">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Строение" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Корпус">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Корпус" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Квартира">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Квартира" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="География">
        <xsl:param name="pGEO" />
        <xsl:value-of select="$pGEO/УТ:Название"/>
        <xsl:if test="$pGEO/УТ:Сокращение"><xsl:value-of select="concat(' ', $pGEO/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="Нумерация">
        <xsl:param name="pNum" />
        <xsl:value-of select="$pNum/УТ:Номер"/>
        <xsl:if test="$pNum/УТ:Сокращение"> <xsl:value-of select="concat(' ', $pNum/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="ФИО">
        <xsl:param name="pFIO" />
        <xsl:if test="$pFIO/УТ:Фамилия"><xsl:value-of select="concat($pFIO/УТ:Фамилия, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Имя"><xsl:value-of select="concat($pFIO/УТ:Имя, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Отчество"><xsl:value-of select="concat($pFIO/УТ:Отчество, ' ')"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="ФИОКороткое">
        <xsl:param name="pFIO" />
        <xsl:if test="$pFIO/УТ:Фамилия"><xsl:value-of select="concat($pFIO/УТ:Фамилия, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Имя"><xsl:value-of select="substring($pFIO/УТ:Имя, 1, 1)"/>.</xsl:if>
        <xsl:if test="$pFIO/УТ:Отчество"><xsl:value-of select="substring($pFIO/УТ:Отчество, 1, 1)"/>.</xsl:if>
    </xsl:template>
    
    <xsl:template name="Дата">
        <xsl:param name="pDate" />
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
    </xsl:template>
    
    <xsl:template name="Время">
        <xsl:param name="pTime" />
        <xsl:variable name="timeText" select="string($pTime)"/>
        <xsl:value-of select="concat(substring($timeText, 1, 2), '.', substring($timeText, 4, 2))"/>
    </xsl:template>
    
    <xsl:template name="ДатаСтрока">
        <xsl:param name="pDate"/>
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:variable name="month" select="substring($dateText, 6, 2)"/>
        <xsl:value-of select="concat('&quot;',substring($dateText, 9, 2),'&quot;')"/>
        <xsl:choose>
            <xsl:when test="$month = '01'"> января </xsl:when>
            <xsl:when test="$month = '02'"> февраля </xsl:when>
            <xsl:when test="$month = '03'"> марта </xsl:when>
            <xsl:when test="$month = '04'"> апреля </xsl:when>
            <xsl:when test="$month = '05'"> мая </xsl:when>
            <xsl:when test="$month = '06'"> июня </xsl:when>
            <xsl:when test="$month = '07'"> июля </xsl:when>
            <xsl:when test="$month = '08'"> августа </xsl:when>
            <xsl:when test="$month = '09'"> сентября </xsl:when>
            <xsl:when test="$month = '10'"> октября </xsl:when>
            <xsl:when test="$month = '11'"> ноября </xsl:when>
            <xsl:when test="$month = '12'"> декабря </xsl:when>
        </xsl:choose>
        <xsl:value-of select="concat(substring($dateText, 1, 4),' года')"/>
    </xsl:template>
    
</xsl:stylesheet>
