<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:x="http://пф.рф/ВС/ФС/ТУФС-ПУ/2018-07-19" xmlns:ФС="http://пф.рф/ВС/ФС/типы/2018-04-23" xmlns:УТ="http://пф.рф/УТ/2017-08-21" xmlns:АФ="http://пф.рф/АФ/2017-08-21">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:attribute-set name="block">
        <xsl:attribute name="font-family">Arial</xsl:attribute>
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="text-align">justify</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="solidBorder">
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
        <xsl:attribute name="padding">2pt</xsl:attribute>
    </xsl:attribute-set>

    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simple" page-height="29.7cm" page-width="21cm"
                    margin-top="1cm" margin-bottom="2cm" margin-left="2.5cm" margin-right="2.5cm">
                    <fo:region-body margin-top="0.5cm" margin-bottom="0cm"/>
                    <fo:region-before extent="2cm"/>
                    <fo:region-after extent="1.5cm"/>
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simple">
                <fo:flow flow-name="xsl-region-body">
                    <!-- ****ДОКУМЕНТ ТУФС-ПУ **** -->
                    <fo:block xsl:use-attribute-sets="block">
                        
                        <!-- ШАПКА ДОКУМЕНТА -->
                        <fo:table>
                            <fo:table-column column-width="60%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block><xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:ТерриториальныйОрганПФР/ФС:Адрес" />                                            
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>ТЕЛ. ФАКС <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:ТерриториальныйОрганПФР/ФС:Телефоны/УТ:Телефон" /></fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        
                        <!-- НАИМЕНОВАНИЕ ДОКУМЕНТА -->
                        <fo:block margin-top="10pt" margin-bottom="10pt" text-align="center" font-weight="bold">
                            <fo:block>Требование</fo:block>
                            <fo:block>об уплате финансовых санкций &lt;1&gt; за совершение правонарушения в сфере</fo:block>
                            <fo:block>законодательства Российской Федерации об индивидуальном</fo:block>
                            <fo:block>(персонифицированном) учете в системе обязательного пенсионного страхования и обязательного социального страхования</fo:block>
                        </fo:block>
                        
                        <!-- РЕКВИЗИТЫ ДОКУМЕНТА -->
                        <fo:table>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>от</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:call-template name="ДатаСтрока">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Реквизиты/УТ:Дата" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>№</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Реквизиты/УТ:Номер"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="3">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <!-- РУКОВОДИТЕЛЬ ТО СФР -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="concat(/x:ЭДПФР/x:ТУФС-ПУ/x:РуководительТОПФР/УТ:Должность, ' ')"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(должность руководителя (заместителя руководителя) территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:ТерриториальныйОрганПФР/ФС:Наименование" />
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(наименование территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:call-template name="ФИО">
                                                <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:ТУФС-ПУ/x:РуководительТОПФР/УТ:ФИО" />
                                            </xsl:call-template>,
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О. руководителя (заместителя руководителя) территориального органа СФР)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt">ставит в известность страхователя</fo:block>
                        
                        <!-- СТРАХОВАТЕЛЬ -->
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="97%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:choose>
                                                <xsl:when test="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/ФС:Наименование">
                                                    <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/ФС:Наименование" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ФИО">
                                                        <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/УТ:ФИО" />
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(полное наименование юридического лица (обособленного подразделения), Ф.И.О. индивидуального предпринимателя, физического лица</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                                
                        <fo:table margin-top="10pt">
                            <fo:table-column column-width="40%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-column column-width="54%"/>
                            <fo:table-column column-width="3%"/>
                            <fo:table-body>        
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>регистрационный номер в ПФР</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/УТ:РегНомер" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>ИНН</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/УТ:ИНН" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="2">
                                        <fo:block>КПП</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/УТ:КПП" />
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block border-after-style="solid" border-after-width="thin">, </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>адрес места нахождения</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>юридического лица (обособленного</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>подразделения) / адрес регистрации</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>индивидуального предпринимателя, физического лица</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">
                                            <xsl:call-template name="АдресОбщий">
                                                <xsl:with-param name="pAddress" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/ФС:Адрес" />
                                            </xsl:call-template>,
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="10pt">
                            <fo:inline>о том, что за названным страхователем по данным территориального органа СФР по состоянию на</fo:inline>
                            <fo:inline font-weight="bold" text-decoration="underline">
                                <xsl:call-template name="Дата">
                                    <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:ДатаФормирования"></xsl:with-param>
                                </xsl:call-template>
                            </fo:inline>
                            <fo:inline>выявлено неисполнение обязанности по уплате финансовых санкций по решению о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства
                            Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от</fo:inline>
                        </fo:block>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-column column-width="60%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold" text-align="center">
                                            <xsl:call-template name="Дата">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:РеквизитыРешения/УТ:Дата"></xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>№</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold" text-align="center">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:РеквизитыРешения/УТ:Номер"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt" text-indent="2.2em">В соответствии с Федеральным законом от 1 апреля 1996 г. №27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного
                            страхования и обязательного социального страхования» (далее - Федеральный закон от 1 апреля 1996 г. № 27-ФЗ) &lt;2&gt; страхователь обязан уплатить:</fo:block>
                        
                        <fo:table>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="30%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="30%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-header>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">№ п/п</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">Наименование выявленного нарушения</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">Финансовая санкция (в рублях, копейках)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">Код бюджетной классификации</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">Уникальный идентификатор начисления (УИН)</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-header>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">1</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>За непредставление страхователем в установленный срок сведений, предусмотренных п. 2-2.2 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:call-template name="Сумма">
                                                <xsl:with-param name="pSumm" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 1]/x:Сумма"></xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 1]/x:КБК"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 1]/x:УИН"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">2</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>За представление страхователем неполных и (или) недостоверных сведений, предусмотренных п. 2-2.2 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:call-template name="Сумма">
                                                <xsl:with-param name="pSumm" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 2]/x:Сумма"></xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 2]/x:КБК"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 2]/x:УИН"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">3</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block>За несоблюдение порядка представления сведений, предусмотренных п. 2 – 2.2 и п. 2.4 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ, в форме электронных документов</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:call-template name="Сумма">
                                                <xsl:with-param name="pSumm" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 3]/x:Сумма"></xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 3]/x:КБК"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Нарушения/x:Нарушение[x:Тип = 3]/x:УИН"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center">Итого</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block text-align="center" font-weight="bold">
                                            <xsl:call-template name="Сумма">
                                                <xsl:with-param name="pSumm" select="/x:ЭДПФР/x:ТУФС-ПУ/x:СуммаИтого"></xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="20pt" text-indent="2.2em">Основанием внимания финансовых санкций является решение о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской
                            Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от</fo:block>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-column column-width="60%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold" text-align="center">
                                            <xsl:call-template name="Дата">
                                                <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:РеквизитыРешения/УТ:Дата"></xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>№</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold" text-align="center">
                                            <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:РеквизитыРешения/УТ:Номер"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="20pt" text-indent="2.2em">В соответствии со статьей 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ требование об уплате финансовых санкций за совершение правонарушения в
                            сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования должно быть исполнено в течение 10 календарных дней со
                            дня получения указанного требования.</fo:block>
                        
                        <fo:block text-indent="2.2em">Указанную в настоящем требовании сумму финансовых санкций страхователю необходимо</fo:block>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="15%"/>
                            <fo:table-column column-width="60%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>уплатить в срок до &lt;3&gt;</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold" text-align="center">
                                            <xsl:if test="/x:ЭДПФР/x:ТУФС-ПУ/x:УплатитьДо">
                                                <xsl:call-template name="Дата">
                                                    <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:УплатитьДо"></xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="5pt" text-indent="2.2em">В случае неуплаты или неполной уплаты страхователем финансовых санкций по требованию взыскание суммы финансовых санкций, предусмотренных
                            настоящим требованием, производится территориальными органами СФР в судебном порядке.</fo:block>
                        
                        <!-- ОТОЗВАННОЕ ТРЕБОВАНИЕ -->
                        <xsl:if test="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ">
                          <fo:block margin-top="20pt" text-indent="2.2em">В связи с тем, что обязанность</fo:block>
                          
                          <fo:table margin-top="5pt">
                              <fo:table-column column-width="100%"/>
                              <fo:table-body>
                                  <fo:table-row>
                                      <fo:table-cell>
                                          <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin">
                                              <xsl:if test="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ">
                                                  <xsl:choose>
                                                      <xsl:when test="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/ФС:Наименование">
                                                          <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/ФС:Наименование" />
                                                      </xsl:when>
                                                      <xsl:otherwise>
                                                          <xsl:call-template name="ФИО">
                                                              <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Страхователь/УТ:ФИО" />
                                                          </xsl:call-template>
                                                      </xsl:otherwise>
                                                  </xsl:choose>
                                              </xsl:if>
                                          </fo:block>
                                      </fo:table-cell>
                                  </fo:table-row>
                                  <fo:table-row>
                                      <fo:table-cell>
                                          <fo:block text-align="center" font-size="8pt">(полное наименование юридического лица, Ф.И.О. индивидуального предпринимателя, физического лица)</fo:block>
                                      </fo:table-cell>
                                  </fo:table-row>
                              </fo:table-body>
                          </fo:table>
                          
                          <fo:block margin-top="5pt">
                              <fo:inline>по уплате финансовых санкций изменилась после направления требования об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об
                                  индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от</fo:inline>
                              <xsl:choose>
                                  <xsl:when test="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ">
                                      <fo:inline text-decoration="underline">
                                          <xsl:call-template name="ДатаСтрока">
                                              <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:Реквизиты/УТ:Дата" />
                                          </xsl:call-template>
                                      </fo:inline>
                                  </xsl:when>
                                  <xsl:otherwise><fo:inline>«__» ______ 20____</fo:inline></xsl:otherwise>
                              </xsl:choose>
                              <fo:inline>г. №</fo:inline>
                              <xsl:choose>
                                  <xsl:when test="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ">
                                      <fo:inline text-decoration="underline">
                                          <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:Реквизиты/УТ:Номер"/>
                                      </fo:inline>
                                  </xsl:when>
                                  <xsl:otherwise><fo:inline>________</fo:inline></xsl:otherwise>
                              </xsl:choose>
                              <fo:inline>, требование от </fo:inline>
                              <xsl:choose>
                                  <xsl:when test="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ">
                                      <fo:inline text-decoration="underline">
                                          <xsl:call-template name="ДатаСтрока">
                                              <xsl:with-param name="pDate" select="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ/УТ:Дата" />
                                          </xsl:call-template>
                                      </fo:inline>
                                  </xsl:when>
                                  <xsl:otherwise><fo:inline>«__» ______ 20____</fo:inline></xsl:otherwise>
                              </xsl:choose>
                              <fo:inline>г. №</fo:inline>
                              <xsl:choose>
                                  <xsl:when test="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ">
                                      <fo:inline text-decoration="underline">
                                          <xsl:value-of select="/x:ЭДПФР/x:ТУФС-ПУ/x:ОтозванноеТУФС-ПУ/УТ:Номер"/>
                                      </fo:inline>
                                  </xsl:when>
                                  <xsl:otherwise><fo:inline>________</fo:inline></xsl:otherwise>
                              </xsl:choose>
                              <fo:inline>отзывается.</fo:inline>
                          </fo:block>
                        </xsl:if>
                                            
                        <fo:table margin-top="20pt">
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="60%"/>
                            <fo:table-column column-width="10%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin" text-align="center">
                                            <xsl:call-template name="ФИО">
                                                <xsl:with-param name="pFIO" select="/x:ЭДПФР/x:ТУФС-ПУ/x:РуководительТОПФР/УТ:ФИО" />
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(Ф.И.О.)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:block margin-top="5pt" font-size="8pt">Место печати территориального органа СФР.</fo:block>
                        
                        <fo:block margin-top="20pt" text-indent="2.2em">Требование об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном
                            (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования получил &lt;4&gt;:</fo:block>
                        
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">&#160;</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения))</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        <fo:table margin-top="5pt">
                            <fo:table-column column-width="100%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block font-weight="bold">&#160;</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(или Ф.И.О. индивидуального предпринимателя, физического лица (уполномоченного представителя))</fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:table margin-top="20pt">
                            <fo:table-column column-width="10%"/>
                            <fo:table-column column-width="25%"/>
                            <fo:table-column column-width="5%"/>
                            <fo:table-column column-width="20%"/>
                            <fo:table-column column-width="40%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell border-after-style="solid" border-after-width="thin">
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-weight="bold" border-after-style="solid" border-after-width="thin" text-align="center">&#160;</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(подпись)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block text-align="center" font-size="8pt">(дата)</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block />
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                        
                        <fo:block margin-top="10pt" text-indent="2.2em">Примечание.</fo:block>
                        <fo:block text-indent="2.2em">Требование об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в
                            системах обязательного пенсионного страхования и обязательного социального страхования может быть &lt;5&gt; передано страхователю (его законному или уполномоченному представителю) лично под расписку, направлено по почте заказным письмом
                            или передано в электронном виде по телекоммуникационным каналам связи. В случае направления указанного требования по почте заказным письмом оно считается полученным по истечении шести дней с
                            даты отправления заказного письма.</fo:block>
                        
                        <!-- СНОСКИ -->
                        <fo:block>
                            <fo:block margin-top="5pt" margin-bottom="10pt">_________________________________</fo:block>
                            <fo:block font-size="8pt">&lt;1&gt; Часть 15 статьи 17 Федерального закона от 1 апреля 1996 г. N 27-ФЗ "Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования 
                                и обязательного социального страхования" (Собрание законодательства Российской Федерации, 1996, N 14, ст. 1401; 2001, N 44, ст. 4149; 2003, N 1, ст. 13; 2009, N 30, ст. 3739; 2011, N 29, ст. 4291; N 49, ст. 7057;
                                2013, N 52, ст. 6986; 2014, N 30, ст. 4217; 2016, N 1, ст. 5; N 27, ст. 4183).</fo:block>
                            <fo:block font-size="8pt">&lt;2&gt; Собрание законодательства Российской Федерации, 1996, N 14, ст. 1401; 2017, N 1, ст. 12.</fo:block>
                            <fo:block font-size="8pt">&lt;3&gt; Заполняется в случае установления территориальным органом СФР срока уплаты финансовых санкций свыше 10 календарных дней.</fo:block>
                            <fo:block font-size="8pt">&lt;4&gt; Заполняется в случае вручения страхователю требования об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации
                                об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования под расписку.</fo:block>
                            <fo:block font-size="8pt">&lt;5&gt; Часть 15 статьи 17 Федерального закона от 01.04.1996 N 27-ФЗ.</fo:block>
                        </fo:block>
                        
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="Сумма">
        <xsl:param name="pSumm"/>
        <xsl:if test="$pSumm">
            <xsl:choose>
                <xsl:when test="string-length(substring-after(string($pSumm), '.') = 0)">
                    <fo:inline font-weight="bold">
                        <xsl:value-of select="concat($pSumm, '.00')" />
                    </fo:inline>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$pSumm" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="АдресРФ">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="АдресОбщий">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress/УТ:РоссийскийАдрес" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ГруппаАдрес">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Регион">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Регион" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Район">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Район" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Город">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Город" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:НаселенныйПункт">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:НаселенныйПункт" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Улица">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Улица" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Дом">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Дом" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Строение">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Строение" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Корпус">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Корпус" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Квартира">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Квартира" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="География">
        <xsl:param name="pGEO" />
        <xsl:value-of select="$pGEO/УТ:Название"/>
        <xsl:if test="$pGEO/УТ:Сокращение"><xsl:value-of select="concat(' ', $pGEO/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="Нумерация">
        <xsl:param name="pNum" />
        <xsl:value-of select="$pNum/УТ:Номер"/>
        <xsl:if test="$pNum/УТ:Сокращение"> <xsl:value-of select="concat(' ', $pNum/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="ФИО">
        <xsl:param name="pFIO" />
        <xsl:if test="$pFIO/УТ:Фамилия"><xsl:value-of select="concat($pFIO/УТ:Фамилия, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Имя"><xsl:value-of select="concat($pFIO/УТ:Имя, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Отчество"><xsl:value-of select="concat($pFIO/УТ:Отчество, ' ')"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="ФИОКороткое">
        <xsl:param name="pFIO" />
        <xsl:if test="$pFIO/УТ:Фамилия"><xsl:value-of select="concat($pFIO/УТ:Фамилия, ' ')"/></xsl:if>
        <xsl:if test="$pFIO/УТ:Имя"><xsl:value-of select="substring($pFIO/УТ:Имя, 1, 1)"/>.</xsl:if>
        <xsl:if test="$pFIO/УТ:Отчество"><xsl:value-of select="substring($pFIO/УТ:Отчество, 1, 1)"/>.</xsl:if>
    </xsl:template>
    
    <xsl:template name="Дата">
        <xsl:param name="pDate" />
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
    </xsl:template>
    
    <xsl:template name="Время">
        <xsl:param name="pTime" />
        <xsl:variable name="timeText" select="string($pTime)"/>
        <xsl:value-of select="concat(substring($timeText, 1, 2), '.', substring($timeText, 4, 2))"/>
    </xsl:template>
    
    <xsl:template name="ДатаСтрока">
        <xsl:param name="pDate"/>
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:variable name="month" select="substring($dateText, 6, 2)"/>
        <xsl:value-of select="concat('&quot;',substring($dateText, 9, 2),'&quot;')"/>
        <xsl:choose>
            <xsl:when test="$month = '01'"> января </xsl:when>
            <xsl:when test="$month = '02'"> февраля </xsl:when>
            <xsl:when test="$month = '03'"> марта </xsl:when>
            <xsl:when test="$month = '04'"> апреля </xsl:when>
            <xsl:when test="$month = '05'"> мая </xsl:when>
            <xsl:when test="$month = '06'"> июня </xsl:when>
            <xsl:when test="$month = '07'"> июля </xsl:when>
            <xsl:when test="$month = '08'"> августа </xsl:when>
            <xsl:when test="$month = '09'"> сентября </xsl:when>
            <xsl:when test="$month = '10'"> октября </xsl:when>
            <xsl:when test="$month = '11'"> ноября </xsl:when>
            <xsl:when test="$month = '12'"> декабря </xsl:when>
        </xsl:choose>
        <xsl:value-of select="concat(substring($dateText, 1, 4),' года')"/>
    </xsl:template>
    
</xsl:stylesheet>
