<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ ns1 ФС" version="1.0"
    xmlns:УТ="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/ВС/ФС/ТУФС-ПУ/2018-07-19" xmlns:ФС="http://пф.рф/ВС/ФС/типы/2018-04-23">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../../Общие/УнифТипы_2017-08-21.xsl"/>
    
    <xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДПФР/ns1:ТУФС-ПУ"/>
        <div class="afWrap pfrAfROPOP-PU">
        	
        		<div class="afRight-1-3">
        			<p class="afSubscript">Приложение № 4</p>
        			<p class="afSubscript"><br/></p>
        			<p class="afSubscript">к приказу Фонда пенсионного и</p>
        			<p class="afSubscript">социального страхования</p>
        			<p class="afSubscript">Российской Федерации</p>
        			<p class="afSubscript"><br/></p>
        			<p class="afSubscript">от 2 марта 2023 г</p>
        			<p class="afSubscript"><br/></p>
        			<p class="afSubscript">№ 302</p>
        		</div>
        		
			<table class="afTable40">
				<tr>
					<td><xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Наименование"/></td>
				</tr>
				<tr>
					<td><xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Адрес"/></td>
				</tr>
				<tr>
					<td>ТЕЛ. ФАКС <xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Телефоны/УТ:Телефон" /></td>
				</tr>
			</table>
    
        	<p class="afInterval"/>
        	<p class="afInterval"/>
        	<p class="afInterval"/>
        	<p class="afInterval"/>
        	<p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afCenter afHeader">Требование</p>
            <p class="afCenter afHeader">об уплате финансовых санкций за совершение правонарушения в сфере законодательства</p>
        	<p class="afCenter afHeader">Российской Федерации об индивидуальном (персонифицированном) учете в системах</p>
        	<p class="afCenter afHeader">обязательного пенсионного страхования и обязательного социального страхования<span class="afFootnoteRef">1</span></p>
            <p class="afInterval"/>
        	<p class="afInterval"/>
            <div class="afRow">
				<div class="afCol-2-25">от</div>
				<div class="afCol-1-5">
					<p class="afValue afCenterBlock afUnderlinedBlock">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate" select="$vForm/ns1:Реквизиты/УТ:Дата"/>
						</xsl:call-template>
					</p>
					<p class="afSubscript afCenter">(дата)</p>
				</div>
				<div class="afCol-4-10">&#160;</div>
				<div class="afCol-2-25 afCenterBlock">№</div>
				<div class="afCol-1-5 afValue afCenterBlock afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Реквизиты/УТ:Номер"/>
				</div>
			</div>
        	<p class="afInterval"/>
            <div class="afRow afValue afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:РуководительТОПФР/УТ:Должность"/>	
            </div>
            <p class="afSubscript afCenter">(должность руководителя (заместителя руководителя) территориального органа СФР)</p>
            <p class="afInterval"/>
            <div class="afRow afValue afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:ТерриториальныйОрганПФР/ФС:Наименование"/>	
            </div>
			<p class="afSubscript afCenter">(наименование территориального органа СФР)</p>
              <div class="afRow">
				<div class="afValue afUnderlinedBlock">
					<xsl:call-template name="УТ:NameStr">
						<xsl:with-param name="pName" select="$vForm/ns1:РуководительТОПФР/УТ:ФИО"/>
					</xsl:call-template> 
				</div>
				<p class="afSubscript afCenter">(Ф.И.О. руководителя (заместителя руководителя) территориального органа СФР)</p>
            </div>
            <p class="afInterval"/>
			<div class="afRow">
				<div class="afC">ставит в известность страхователя </div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft300">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Наименование">
							<xsl:value-of select="$vForm/ns1:Страхователь/ФС:Наименование"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/УТ:ФИО">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
				<p class="afSubscript afMarginLeft300">(полное наименование юридического лица (обособленного подразделения),
					Ф.И.О. физического лица, в том числе индивидуального предпринимателя,)</p>
			</div>
        	<p class="afInterval"/>
             <div class="afRow">
				<div class="afCol-4-10">регистрационный номер в СФР</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ:РегНомер"/>
				</div>
			</div>
            <div class="afRow">
				<div class="afCol-4-10">ИНН</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ:ИНН"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-4-10">КПП</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<xsl:value-of select="$vForm/ns1:Страхователь/УТ:КПП"/>
				</div>
            </div>
            <div class="afRow">
            	<div class="afCol-4-10">адрес в пределах места нахождения юридического лица (обособленного подразделения)/адрес регистрации индивидуального предпринимателя, физического лица</div>
				<div class="afCol-6-10 afValue afUnderlinedBlock">
					<br/><br/>
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Адрес/УТ:Иностранный">
							<xsl:call-template name="УТ:AddressForeignStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Страхователь/ФС:Адрес" />
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Страхователь/ФС:Адрес/УТ:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:Страхователь/ФС:Адрес/УТ:Неструктурированный"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="УТ:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Страхователь/ФС:Адрес"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
            </div>
            <p class="afInterval"/><p class="afInterval"/>
        	<p class="afP afJustify">о том, что за названным страхователем по данным территориального органа СФР по состоянию на <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:ДатаФормирования"/></xsl:call-template></span> выявлено неисполнение обязанности по уплате финансовых санкций по решению о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в истемах обязательного пенсионного страхования и обязательного социального страхования от  <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:РеквизитыРешения/УТ:Дата"/></xsl:call-template>  &#160;</span> № <span class="afValue afUnderline">&#160;&#160;  <xsl:value-of select="$vForm/ns1:РеквизитыРешения/УТ:Номер"/> &#160;</span>.</p>
            <p class="afInterval"/>
            
        	<p class="afParagraph">В соответствии с Федеральным законом от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования»<span class="afFootnoteRef">2</span> (далее – Федеральный закон от 1 апреля 1996 г. № 27-ФЗ)  страхователь обязан уплатить:</p>
            
             <table class="afTable100 afTable">
				<thead class="afCenter">
					<tr>
						<td class="afTable5">№<br/>п/п</td>
						<td class="afTable30">Наименование выявленного нарушения</td>
						<td class="afTable20">Финансовая санкция (в рублях, копейках)</td>
						<td class="afTable20">Код бюджетной классификации</td>
						<td class="afTable20">Уникальный идентификатор начисления (УИН)</td>
					</tr>
				</thead>
             	<tbody>
             		<tr style="page-break-inside: avoid;">
             			<td class="afCenter">1</td>
             			<td>За непредставление страхователем в установленный срок сведений, предусмотренных пунктами 2 и 2.1 статьи 11 (за исключением сведений, предусмотренных подпунктом 4 указанного пункта) Федерального закона от 1 апреля 1996 г. № 27-ФЗ<span class="afFootnoteRef">3</span></td>
						<td class="afCenter">
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 1]/ns1:Сумма">
									<xsl:value-of select="floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 1]/ns1:Сумма)"/>&#160;руб.
									<xsl:value-of select="format-number(($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 1]/ns1:Сумма - floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 1]/ns1:Сумма))*100, '00')"/>&#160;коп. 
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 1]/ns1:КБК"/></td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 1]/ns1:УИН"/></td>
					</tr>
					<tr>
						<td class="afCenter">2</td>
						<td>За представление страхователем неполных и (или) недостоверных сведений, предусмотренных пунктами 2 и 2.1 статьи 11 (за исключением сведений, предусмотренных подпунктом 4 указанного пункта) Федерального закона от 1 апреля 1996 г. № 27-ФЗ</td>
						<td class="afCenter">
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 2]/ns1:Сумма">
									<xsl:value-of select="floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 2]/ns1:Сумма)"/>&#160;руб.
									<xsl:value-of select="format-number(($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 2]/ns1:Сумма - floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 2]/ns1:Сумма))*100, '00')"/>&#160;коп. 
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 2]/ns1:КБК"/></td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 2]/ns1:УИН"/></td>
					</tr>
					<tr>
						<td class="afCenter">3</td>
						<td>За несоблюдение страхователем порядка представления сведений, предусмотренных пунктом 2 статьи 8, пунктами 2, 2.1 и 9 статьи 11 Федерального закона от 1 апреля 1996 г. № 27-ФЗ<span class="afFootnoteRef">4</span>, в форме электронных документов</td>
						<td class="afCenter">	
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 3]/ns1:Сумма">
									<xsl:value-of select="floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 3]/ns1:Сумма)"/>&#160;руб.
									<xsl:value-of select="format-number(($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 3]/ns1:Сумма - floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 3]/ns1:Сумма))*100, '00')"/>&#160;коп. 
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 3]/ns1:КБК"/></td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 3]/ns1:УИН"/></td>
					</tr>
					<tr>
						<td class="afCenter">4</td>
						<td>За непредставление страхователем в установленный срок сведений, предусмотренных пунктами 2–2.2 статьи 11 Федерального закона от 1 апреля 1996 г. 
							№ 27-ФЗ<span class="afFootnoteRef">5</span></td>
						<td class="afCenter">	
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 4]/ns1:Сумма">
									<xsl:value-of select="floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 4]/ns1:Сумма)"/>&#160;руб.
									<xsl:value-of select="format-number(($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 4]/ns1:Сумма - floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 4]/ns1:Сумма))*100, '00')"/>&#160;коп. 
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 4]/ns1:КБК"/></td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 4]/ns1:УИН"/></td>
					</tr>
					<tr>
						<td class="afCenter">5</td>
						<td>За представление страхователем неполных и (или) недостоверных сведений, предусмотренных пунктами 2–2.2 статьи 11 Федерального закона от 1 апреля 
							1996 г. № 27-ФЗ</td>
						<td class="afCenter">	
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 5]/ns1:Сумма">
									<xsl:value-of select="floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 5]/ns1:Сумма)"/>&#160;руб.
									<xsl:value-of select="format-number(($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 5]/ns1:Сумма - floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 5]/ns1:Сумма))*100, '00')"/>&#160;коп. 
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 5]/ns1:КБК"/></td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 5]/ns1:УИН"/></td>
					</tr>
					<tr>
						<td class="afCenter">6</td>
						<td>За несоблюдение страхователем порядка представления сведений, предусмотренных 
							пунктами 2–2.2 и пунктом 2.4 статьи 11 Федерального закона от 1 апреля 1996 г. 
							№ 27-ФЗ1, в форме электронных документов</td>
						<td class="afCenter">	
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 6]/ns1:Сумма">
									<xsl:value-of select="floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 6]/ns1:Сумма)"/>&#160;руб.
									<xsl:value-of select="format-number(($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 6]/ns1:Сумма - floor($vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 6]/ns1:Сумма))*100, '00')"/>&#160;коп. 
								</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 6]/ns1:КБК"/></td>
						<td class="afCenter"><xsl:value-of select="$vForm/ns1:Нарушения/ns1:Нарушение[ns1:Тип = 6]/ns1:УИН"/></td>
					</tr>
					<tr>
						<td>&#160;</td>
						<td class="afRight">ИТОГО:&#160;&#160;</td>
						<td class="afCenter">
							<xsl:value-of select="floor($vForm/ns1:СуммаИтого)"/>&#160;руб.
							<xsl:value-of select="format-number(($vForm/ns1:СуммаИтого - floor($vForm/ns1:СуммаИтого))*100, '00')"/>&#160;коп. 
						</td>
						<td>&#160;</td>
						<td>&#160;</td>
					</tr>		
				</tbody>
			</table>
			<p class="afInterval"/> 
        	<p class="afParagraph">Основанием взимания финансовых санкций является решение о привлечении страхователя к ответственности за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от  <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:РеквизитыРешения/УТ:Дата"/></xsl:call-template>  &#160;</span> № <span class="afValue afUnderline">&#160;&#160;  <xsl:value-of select="$vForm/ns1:РеквизитыРешения/УТ:Номер"/> &#160;</span>.</p> 
             
            <p class="afInterval"/> 
        	<p class="afParagraph">В соответствии со статьей 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ<span class="afFootnoteRef">7</span>
        		ребование об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования должно быть исполнено в течение 20 календарных дней со дня получения требования. В случае уплаты финансовых санкций в течение первых 10 календарных дней со дня получения требования финансовые санкции могут быть уплачены в размере половины суммы, указанной в требовании об уплате финансовых санкций.</p>
        	<p class="afInterval"/> 
            <p class="afParagraph">Указанную в настоящем требовании сумму финансовых санкций страхователю необходимо уплатить в срок до<span class="afFootnoteRef">8</span> <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:УплатитьДо"/></xsl:call-template>  &#160;</span></p>
        	
        	<p class="afSubscript afMarginLeft50">(дата)</p> 
            
            <p class="afInterval"/> 
        	<p class="afParagraph">В случае неуплаты или неполной уплаты страхователем финансовых санкций по требованию взыскание суммы финансовых санкций, предусмотренных настоящим требованием, производится территориальными органами СФР в судебном порядке.</p>
            <xsl:if test="$vForm/ns1:ОтозванноеТУФС-ПУ">
				<p class="afParagraph">В связи с тем, что обязанность</p>
				<xsl:choose>
					<xsl:when test="$vForm/ns1:Страхователь/ФС:Наименование">
						<div class="afRow">
							<div class="afValue afUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:Страхователь/ФС:Наименование"/>
							</div>
							<p class="afSubscript afCenter">(полное наименование юридического лица (обособленного подразделения),</p>
						</div>
						<div class="afRow">
							<div class="afValue afUnderlinedBlock">&#160;</div>
							<p class="afSubscript afCenter">Ф.И.О. физического лица, в том числе индивидуального предпринимателя)</p>
						</div>
					</xsl:when>
					<xsl:when test="$vForm/ns1:Страхователь/УТ:ФИО">
						<div class="afRow">
							<div class="afValue afUnderlinedBlock">&#160;</div>
							<p class="afSubscript afCenter">(полное наименование юридического лица (обособленного подразделения),</p>
						</div>
						<div class="afRow">
							<div class="afValue afUnderlinedBlock">
								<xsl:call-template name="УТ:NameStr">
									<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
								</xsl:call-template>
							</div>
							<p class="afSubscript afCenter">Ф.И.О. физического лица, в том числе индивидуального предпринимателя)</p>
						</div>	
					</xsl:when>
					<xsl:otherwise>
						<div class="afRow">
							<div class="afValue afUnderlinedBlock">&#160;</div>
							<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
						</div>
						<div class="afRow">
							<div class="afValue afUnderlinedBlock">
								<xsl:call-template name="УТ:NameStr">
									<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
								</xsl:call-template>
							</div>
							<p class="afSubscript afCenter">или Ф.И.О. физического лица (уполномоченного представителя), в том числе индивидуального предпринимателя)</p>
						</div>	
					</xsl:otherwise>
				</xsl:choose>
				<p class="afInterval"/>
            	<p class="afP afJustify">по уплате финансовых санкций изменилась после направления требования об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования от <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:Реквизиты/УТ:Дата"/> </xsl:call-template>&#160;&#160;</span>  № <span class="afValue afUnderline">&#160;&#160;  <xsl:value-of select="$vForm/ns1:Реквизиты/УТ:Номер"/> &#160;</span>, требование от <span class="afValue afUnderline">&#160;&#160;<xsl:call-template name="DateShortStr"><xsl:with-param name="pDate" select="$vForm/ns1:ОтозванноеТУФС-ПУ/УТ:Дата"/></xsl:call-template>&#160;&#160;&#160;&#160;</span>  № <span class="afValue afUnderline">&#160;&#160;  <xsl:value-of select="$vForm/ns1:ОтозванноеТУФС-ПУ/УТ:Номер"/> &#160;&#160;&#160;</span> отзывается.</p>
			</xsl:if>
			
			  <p class="afInterval"/><p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-10">&#160;</div>
				<div class="afCol-1-4">
					<div class="afUnderlinedBlock">&#160;</div>
					<p class="afSubscript afCenter">(подпись)</p>
				</div>
				<div class="afCol-1-10">&#160;</div>
				<div class="afCol-1-4">
					<div class="afUnderlinedBlock">
						<xsl:call-template name="УТ:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:РуководительТОПФР/УТ:ФИО"/>
						</xsl:call-template>
					</div>
					<p class="afSubscript afCenter">(Ф.И.О.)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afParagraph">Место печати территориального органа СФР</p>
			<p class="afInterval"/><p class="afInterval"/>
			<p class="afParagraph">Требование об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования получил<span class="afFootnoteRef">9</span>:</p>

			<xsl:choose>
				<xsl:when test="$vForm/ns1:Руководитель">
					<div class="afRow">
						<div class="afValue afUnderlinedBlock">
							<xsl:value-of select="$vForm/ns1:Руководитель/УТ:Должность"/>, 
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Руководитель/УТ:ФИО"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
					</div>
					<div class="afRow">
						<div class="afValue afUnderlinedBlock">&#160;</div>
						<p class="afSubscript afCenter">или Ф.И.О. индивидуального предпринимателя, физического лица (уполномоченного представителя))</p>
					</div>
				</xsl:when>
				<xsl:when test="$vForm/ns1:Представитель">
					<div class="afRow">
						<div class="afValue afUnderlinedBlock">&#160;</div>
						<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
					</div>
					<div class="afRow">
						<div class="afValue afUnderlinedBlock">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Представитель"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">или Ф.И.О. индивидуального предпринимателя, физического лица (уполномоченного представителя))</p>
					</div>	
				</xsl:when>
				<xsl:otherwise>
					<div class="afRow">
						<div class="afValue afUnderlinedBlock">&#160;</div>
						<p class="afSubscript afCenter">(должность, Ф.И.О. руководителя юридического лица (обособленного подразделения)</p>
					</div>
					<div class="afRow">
						<div class="afValue afUnderlinedBlock">
							<xsl:call-template name="УТ:NameStr">
								<xsl:with-param name="pName" select="$vForm/ns1:Страхователь/УТ:ФИО"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">или Ф.И.О. индивидуального предпринимателя, физического лица (уполномоченного представителя))</p>
					</div>	
				</xsl:otherwise>
			</xsl:choose>
			
			<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-1-10">&#160;</div>
					<div class="afCol-1-4">
						<div class="afUnderlinedBlock">&#160;</div>
						<p class="afSubscript afCenter">(подпись)</p>
					</div>
					<div class="afCol-1-10">&#160;</div>
					<div class="afCol-1-4">
						<div class="afUnderlinedBlock">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="$vForm/ns1:ДатаВручения"/>
							</xsl:call-template>
						</div>
						<p class="afSubscript afCenter">(дата)</p>
					</div>
				</div>
			

				<p class="afInterval"/><p class="afInterval"/>
        	<!--
				<p class="afParagraph afSubscriptNormal">Примечание. </p>
				<p class="afParagraph afSubscriptNormal">Требование об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системе обязательного пенсионного страхования может быть<span class="afFootnoteRef">5</span>  передано страхователю (его законному или уполномоченному представителю) лично под расписку, направлено по почте заказным письмом или передано в электронном виде по телекоммуникационным каналам связи. В случае направления указанного требования по почте заказным письмом оно считается полученным по истечении шести дней с даты отправления заказного письма.</p>
			-->	
				<p class="afInterval"/>
				
				
        	<p class="afParagraph">Направить настоящее требование: </p>
        	<div class="afRow">
        		<div class="afC afCheck">
        			<xsl:if test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Уклонение/ns1:СпособНаправления [text() = '1']">V</xsl:if>
        		</div>
        		<div class="afCol-1-7">по почте</div>
        		<div class="afCol-4-5">
        			(в случае направления указанного требования по почте заказным письмом оно считается полученным по истечении шести дней с даты отправления заказного письма<span class="afSup">10</span>);
        		</div>
        	</div>
        	
        	<div class="afRow">
        		<div class="afC afCheck">
        			<xsl:if test="/ns1:ЭДПФР/ns1:АВП-ПУ/ns1:Уклонение/ns1:СпособНаправления [text() = '2']">V</xsl:if>
        		</div>
        		<div class="afCol-1-2">по телекоммуникационным каналам связи</div>
        	</div>
        	
        	
        	<p class="afInterval"/>
		_________________________________
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">1</span> Часть 15 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ «Об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования» (Собрание законодательства Российской Федерации, 1996, 
        		№ 14, ст. 1401; 2016, № 27, ст. 4183).</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">2</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">3</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">4</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">5</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 41, ст. 6941</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">6</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2022, № 41, ст. 6941</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">7</span> Собрание законодательства Российской Федерации, 1996, № 14, ст. 1401; 2023, № 1, ст. 16.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">8</span> Заполняется в случае установления территориальным органом СФР срока уплаты финансовых санкций свыше 20 календарных дней.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">9</span> Заполняется в случае вручения страхователю требования об уплате финансовых санкций за совершение правонарушения в сфере законодательства Российской Федерации об индивидуальном (персонифицированном) учете в системах обязательного пенсионного страхования и обязательного социального страхования под расписку.</p>
        	<p class="afFootnote afParagraph"><span class="afFootnoteRef">10</span> Часть 15 статьи 17 Федерального закона от 1 апреля 1996 г. № 27-ФЗ (Собрание законодательства Российской Федерации, 1996, № 14, 
        		ст. 1401; 2016, № 27, ст. 4183).</p>
		

        </div>
    </xsl:template>
    <xsl:template name="Время">
        <xsl:param name="pTime" />
        <xsl:variable name="timeText" select="string($pTime)"/>
        <xsl:value-of select="concat(substring($timeText, 1, 2), '.', substring($timeText, 4, 2))"/>
    </xsl:template>
    
     <xsl:template name="АдресРФ">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Индекс"><xsl:value-of select="$pAddress/УТ:Индекс"/></xsl:if>
        <xsl:call-template name="ГруппаАдрес">
            <xsl:with-param name="pAddress" select="$pAddress" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ГруппаАдрес">
        <xsl:param name="pAddress" />
        <xsl:if test="$pAddress/УТ:Регион">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Регион" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Район">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Район" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Город">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Город" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:НаселенныйПункт">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:НаселенныйПункт" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Улица">,
            <xsl:call-template name="География">
                <xsl:with-param name="pGEO" select="$pAddress/УТ:Улица" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Дом">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Дом" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Строение">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Строение" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Корпус">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Корпус" />
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$pAddress/УТ:Квартира">,
            <xsl:call-template name="Нумерация">
                <xsl:with-param name="pNum" select="$pAddress/УТ:Квартира" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="География">
        <xsl:param name="pGEO" />
        <xsl:value-of select="$pGEO/УТ:Название"/>
        <xsl:if test="$pGEO/УТ:Сокращение"><xsl:value-of select="concat(' ', $pGEO/УТ:Сокращение)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="Нумерация">
        <xsl:param name="pNum" />
        <xsl:value-of select="$pNum/УТ:Номер"/>
        <xsl:if test="$pNum/УТ:Сокращение"> <xsl:value-of select="concat(' ', $pNum/УТ:Сокращение)"/></xsl:if>
    </xsl:template>

</xsl:stylesheet>
