<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 АФ5 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:АФ5="http://пф.рф/АФ/2018-12-07" xmlns:ns1="http://пф.рф/ЗОЭД/2020-02-04">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2014-01-01.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            
            <h1 class="afHeader afCenter">Заявление на отключение страхователя от электронного документооборота СФР</h1>
            <p class="afInterval"/>
            
            <div class="afRow afParagraph">Прошу отключить от электронного документооборота Фонда пенсионного и социального страхования Российской Федерации по телекоммуникационным каналам связи через Оператора.</div>
            <p class="afInterval"/>
            
            <div class="afRow afParagraph">
                <div class="afBold">Сведения о страхователе<span class="afSup">1</span>:</div>
            </div>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Юридическое лицо</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>Полное наименование</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:Наименование"/></td>
                </tr>
                <tr>
                    <td>Краткое наименование</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:НаименованиеКраткое"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:ИНН"/></td>
                </tr>
                <tr>
                    <td>КПП</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:КПП"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:Телефон"/></td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ЮЛ/УТ2:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Индивидуальный предприниматель</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ИП/УТ2:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>ФИО</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ИП/УТ2:ФИО"/></td>
                </tr>
                <tr>
                    <td>СНИЛС</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ИП/УТ2:СНИЛС"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ИП/УТ2:ИНН"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ИП/УТ2:Телефон"/></td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Страхователь/ns1:ИП/УТ2:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <div class="afNoBreakInside">
                <div class="afRow afParagraph">
                    <div class="afBold">Сведения об операторе ЭДО СФР:</div>
                </div>
                <p class="afInterval"/>

                <table class="afTable afTable100">
                    <tr>
                        <td class="afTable40">Регистрационный номер в СФР</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Оператор/УТ2:РегНомер"/></td>
                    </tr>
                    <tr>
                        <td>Краткое наименование</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Оператор/УТ2:НаименованиеКраткое"/></td>
                    </tr>
                    <tr>
                        <td>ИНН</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Оператор/УТ2:ИНН"/></td>
                    </tr>
                    <tr>
                        <td>КПП</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:Оператор/УТ2:КПП"/></td>
                    </tr>
                </table>
                <p class="afInterval"/>
                <p class="afInterval"/>

                <div class="afRow">
                    <div class="afCol-1-2">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:ПредставительСотрудник/УТ2:Должность"/>
                        </div>
                        <p class="afCenter afP afSubscript">(Должность)</p>
                    </div>
                    <div class="afCol-1-4">
                        <div class="afValue afUnderlinedBlock"></div>
                        <p class="afCenter afP afSubscript">(Подпись)</p>
                    </div>
                    <div class="afCol-1-4">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:ЗОЭД/ns1:ПредставительСотрудник/УТ2:ФИО"/>
                        </div>
                        <p class="afCenter afP afSubscript">(Ф.И.О)</p>
                    </div>
                </div>
                <p class="afInterval"/>
                <p class="afInterval"/>

                <div class="afRow">
                    <div class="afCol-1-3">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:variable name="dateTimeText" select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ5:ДатаВремя"/>
                            <xsl:call-template name="Date2Text">
                                <xsl:with-param name="pDate" select="substring($dateTimeText, 1, 10)"/>                                     
                            </xsl:call-template>&#160;г.
                        </div>
                    </div>
                    <div class="afCol-1-3">
                        <div class="afCenter">М.П. (при наличии)</div>
                    </div>
                </div>
                <p class="afInterval"/>
                <p class="afInterval"/>
                
                <div class="afStickToBottom">
                    <div class="afRow">
                        <div class="afCol-1-3 afUnderlinedBlock"/>
                    </div>

                    <div class="afRow">
                        <p class="afSmallSize afJustify"><span class="afSup">1</span>&#160;Заполняется только один из блоков «Юридическое лицо» или «Индивидуальный предприниматель».</p>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
