<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:ns1="http://пф.рф/УОД/2019-09-27">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2014-01-01.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            
            <h1 class="afHeader afCenter">Уведомление о доставке</h1>
            <p class="afInterval"/>
            
            <xsl:choose>
                <xsl:when test="/ns1:ЭДПФР/ns1:УОД/ns1:Оператор/УТ2:РегНомер">
                    <div class="afRow afHeaderLeft">Сведения об операторе:</div>
                    <div class="afRow">
                        <div class="afCol-1-4">Регистрационный номер оператора в СФР</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Оператор/УТ2:РегНомер"/>
                        </div>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">Наименование оператора</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Оператор/УТ2:НаименованиеКраткое"/>
                        </div>
                    </div>
                </xsl:when>
                <xsl:when test="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:РегНомер">
                    <div class="afRow afHeaderLeft">Сведения о страхователе:</div>
                    <div class="afRow">
                        <div class="afCol-1-4">Регистрационный номер страхователя в СФР</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:РегНомер"/>
                        </div>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">Наименование страхователя</div>
                        <xsl:choose>
                            <xsl:when test="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:НаименованиеКраткое">
                                <div class="afCol-2-3 afOverFlowAuto afTableRight afUnderlinedAlignLeftPadding afWordBreak afValue">
                                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:НаименованиеКраткое"/>
                                </div>
                            </xsl:when>
                            <xsl:when test="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:ФИО">
                                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:ФИО"/>
                                </div>
                            </xsl:when>
                            <xsl:otherwise>&#160;</xsl:otherwise>
                        </xsl:choose>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">ИНН страхователя</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:ИНН"/>
                        </div>
                    </div>
                    <div class="afRow">
                        <div class="afCol-1-4">КПП страхователя</div>
                        <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:Страхователь/УТ2:КПП"/>
                        </div>
                    </div>
                </xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
            
            <p class="afInterval"/>
            
            <div class="afRow afHeaderLeft">Сведения о доставленном пакете:</div>
            
            <div class="afRow">
                <div class="afCol-1-4">Идентификатор пакета</div>
                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УОД/ns1:ДоставленныйПакет/ns1:Идентификатор"/>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-4">Дата и время доставки пакета</div>
                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                    <xsl:variable name="dateTimeText" select="/ns1:ЭДПФР/ns1:УОД/ns1:ДоставленныйПакет/ns1:ДатаВремя"/>
                    <xsl:value-of select="concat(substring($dateTimeText, 1, 10), '/', substring($dateTimeText, 12, 8))"/>
                </div>
            </div>
            
            <div class="afRow">
                <div class="afCol-1-4">Канал передачи</div>
                <div class="afCol-2-3 afTableRight afUnderlinedAlignLeftPadding afValue">
                    <xsl:if test="/ns1:ЭДПФР/ns1:УОД/ns1:ДоставленныйПакет/ns1:Канал[text() = 'EDOK']">ЭДОК</xsl:if>
                    <xsl:if test="/ns1:ЭДПФР/ns1:УОД/ns1:ДоставленныйПакет/ns1:Канал[text() = 'ES.KS']">Кабинет страхователя</xsl:if>
                    <xsl:if test="/ns1:ЭДПФР/ns1:УОД/ns1:ДоставленныйПакет/ns1:Канал[text() = 'POST']">По почте</xsl:if>
                    <xsl:if test="/ns1:ЭДПФР/ns1:УОД/ns1:ДоставленныйПакет/ns1:Канал[text() = 'PERS']">Лично</xsl:if>
                </div>
            </div>
            
        </div>
    </xsl:template>
</xsl:stylesheet>
