<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 АФ4 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:АФ4="http://пф.рф/АФ/2017-08-21" xmlns:ns1="http://пф.рф/УОНД/2022-01-21">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>

    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap pfrAfUOND">
            
            <h1 class="afHeader afCenter">Уведомление о невозможности доставки документа через систему ЭДО с СФР</h1>
            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC">Настоящим уведомляем</div>
                <div class="afMarginLeft200 afUnderlinedBlock"/>
                <p class="afInterval"/>
                <div class="afUnderlinedBlock afWordBreak afValue">
                    <xsl:choose>
                        <xsl:when test="/ns1:ЭДПФР/ns1:УОНД/ns1:Страхователь/УТ2:НаименованиеКраткое">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Страхователь/УТ2:НаименованиеКраткое"/>
                        </xsl:when>
                        <xsl:when test="/ns1:ЭДПФР/ns1:УОНД/ns1:Страхователь/УТ2:ФИО">
							<xsl:call-template name="УТ2:NameStr">
                                <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УОНД/ns1:Страхователь/УТ2:ФИО" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>&#160;</xsl:otherwise>
                    </xsl:choose>
                </div>
            </div>

            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afC">регистрационный номер страхователя</div>
                <div class="afCol-1-4 afUnderlinedBlock afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Страхователь/УТ2:РегНомер"/>
                </div>
                <div>, о наличии исходящего документа со стороны</div>
            </div>
            
            <div class="afRow"> СФРв адрес страхователя, который невозможно доставить через систему ЭДО с СФР.</div>
            <div class="afRow"> Причина невозможности доставки через ЭДО с СФР: </div>

            <div class="afRow">
                <div class="afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Причина"/>
                </div>
            </div>

            <p class="afInterval"/>
            
            <div class="afRow">
                <div class="afValue">
                    <xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Комментарий"/>
                </div>
            </div>
            <p class="afInterval"/>
            <div class="afRow">Реквизиты документа:</div>

            <div class="afRow">
				<div class="afCol-5">&#160;</div>
                <div class="afCol-1-4">Наименование:</div>
				<div class="afCol-2-3 afValue">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Документ/ns1:Наименование"/>
                </div>
            </div>
             <div class="afRow">
				<div class="afCol-5">&#160;</div>
                <div class="afCol-1-4 afC">Код документа по АФ: </div>
				<div class="afCol-2-3 afValue">
					<xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Документ/ns1:Код"/>
				</div>
            </div>
            <xsl:if test="/ns1:ЭДПФР/ns1:УОНД/ns1:Документ/ns1:ВОтветНа">
				<div class="afRow">
					<div class="afCol-5">&#160;</div>
					<div class="afCol-1-4 afC">В ответ на: </div>
					<div class="afCol-2-3 afValue">
							<xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Документ/ns1:ВОтветНа"/>
					</div>
				</div>
            </xsl:if>
            <p class="afInterval"/>
            <div class="afRow">
				<div class="afCol-5">&#160;</div>
                <div class="afCol-4-10 afC">Регистрационный номер обращения СФР: </div>
				<div class="afCol-1-2 afValue">
						<xsl:value-of select="/ns1:ЭДПФР/ns1:УОНД/ns1:Документ/ns1:РегНомерОбращ"/>
                </div>
            </div>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC">Дата и время уведомления:&#160;</div>
                <div class="afCol-1-4 afUnderlinedBlock afValue">
                    <xsl:variable name="dateTimeText" select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ4:ДатаВремя"/>
                    <xsl:value-of select="concat(substring($dateTimeText, 1, 10), ' ', substring($dateTimeText, 12, 5))"/>
                </div>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
