<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 АФ5 ns1" version="1.0"
    xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:АФ5="http://пф.рф/АФ/2018-12-07" xmlns:ns1="http://пф.рф/УПРУП/2020-02-03">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:include href="../../Общие/УнифТипы_2017-08-21.xsl"/>
    <xsl:template match="/" name="inc">
        
        <div class="afWrap">
            
            <h1 class="afHeader afCenter">Уведомление о прекращении полномочий представителя</h1>
            <p class="afInterval"/>
            
            <div class="afRow afParagraph afJustify">Настоящим уведомляю о прекращении полномочий уполномоченного представителя на право подавать отчетность и иные документы в электронном виде в территориальные органы Фонда пенсионного и социального страхования РФ, подписывать документы электронной подписью от имени страхователя, осуществлять ознакомление с актами, решениями, требованиями СФР и их обжаловать.</div>
            <p class="afInterval"/>
            
            <div class="afRow afParagraph">
                <div class="afBold">Сведения о страхователе<span class="afSup">1</span>:</div>
            </div>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Юридическое лицо</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>Полное наименование</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:Наименование"/></td>
                </tr>
                <tr>
                    <td>Краткое наименование</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:НаименованиеКраткое"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:ИНН"/></td>
                </tr>
                <tr>
                    <td>КПП</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:КПП"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue">
                        <xsl:call-template name="УТ2:PhoneNumberStr">
                            <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:Телефон"/>                                        
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ЮЛ/УТ2:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Индивидуальный предприниматель</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ИП/УТ2:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>ФИО</td>
                    <td>
                        <xsl:call-template name="УТ2:NameStr">
                            <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ИП/УТ2:ФИО"/>                                        
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>СНИЛС</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ИП/УТ2:СНИЛС"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ИП/УТ2:ИНН"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue">
                        <xsl:call-template name="УТ2:PhoneNumberStr">
                            <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ИП/УТ2:Телефон"/>                                        
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:Страхователь/ns1:ИП/УТ2:АдресЭлПочты"/></td>
                </tr>
            </table>
            
            <div class="afStickToBottom">
                <div class="afRow">
                    <div class="afCol-1-3 afUnderlinedBlock"/>
                </div>

                <span>
                    <div class="afSup afFloatLeft">1</div><div class="afFloatLeft afSmallSize">Заполняется только один раздел: «Юридическое лицо» или «Индивидуальный предприниматель».</div>
                </span>
            </div>
            
            <div id="break"/>
            
            <div class="afRow afParagraph">
                <div class="afBold">Сведения об уполномоченном представителе<span class="afSup">2</span>:</div>
            </div>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Физическое лицо</th>
                </tr>
                <tr>
                    <td class="afTable40">ФИО</td>
                    <td class="afValue">
                        <xsl:call-template name="УТ2:NameStr">
                            <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительФизЛицо/УТ2:ФИО"/>                                        
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>СНИЛС</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительФизЛицо/УТ2:СНИЛС"/></td>
                </tr>
                <tr>
                    <td>Должность</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительФизЛицо/ns1:Должность"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue">
                        <xsl:call-template name="УТ2:PhoneNumberStr">
                            <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительФизЛицо/УТ2:Телефон"/>                                        
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительФизЛицо/УТ2:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <table class="afTable afTable100">
                <tr>
                    <th colspan="2" class="afBold afCenter">Юридическое лицо</th>
                </tr>
                <tr>
                    <td class="afTable40">Регистрационный номер в СФР</td>
                    <td class="afValue">
                        <xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:РегНомер"/>
                    </td>
                </tr>
                <tr>
                    <td>Полное наименование</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:Наименование"/></td>
                </tr>
                <tr>
                    <td>Краткое наименование</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:НаименованиеКраткое"/></td>
                </tr>
                <tr>
                    <td>ИНН</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:ИНН"/></td>
                </tr>
                <tr>
                    <td>КПП</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:КПП"/></td>
                </tr>
                <tr>
                    <td>Телефон</td>
                    <td class="afValue">
                        <xsl:call-template name="УТ2:PhoneNumberStr">
                            <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:Телефон"/>                                        
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>Адрес электронной почты</td>
                    <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительЮЛ/УТ2:АдресЭлПочты"/></td>
                </tr>
            </table>
            <p class="afInterval"/>
            
            <div class="afNoBreakInside">
                 <table class="afTable afTable100">
                    <tr>
                        <th colspan="2" class="afBold afCenter">Индивидуальный предприниматель</th>
                    </tr>
                    <tr>
                        <td class="afTable40">Регистрационный номер в СФР</td>
                        <td class="afValue">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительИП/УТ2:РегНомер"/>
                        </td>
                    </tr>
                    <tr>
                        <td>ФИО</td>
                        <td class="afValue">
                            <xsl:call-template name="УТ2:NameStr">
                                <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительИП/УТ2:ФИО"/>                                        
                            </xsl:call-template>
                        </td>
                    </tr>
                    <tr>
                        <td>СНИЛС</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительИП/УТ2:СНИЛС"/></td>
                    </tr>
                    <tr>
                        <td>ИНН</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительИП/УТ2:ИНН"/></td>
                    </tr>
                    <tr>
                        <td>Телефон</td>
                        <td class="afValue">
                            <xsl:call-template name="УТ2:PhoneNumberStr">
                                <xsl:with-param name="pNumber" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительИП/УТ2:Телефон"/>                                        
                            </xsl:call-template>
                        </td>
                    </tr>
                    <tr>
                        <td>Адрес электронной почты</td>
                        <td class="afValue"><xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:УполномоченныйПредставитель/ns1:ПредставительИП/УТ2:АдресЭлПочты"/></td>
                    </tr>
                </table>
                <p class="afInterval"/>

                <div class="afRow">
                    <div class="afCol-1-2">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:value-of select="/ns1:ЭДПФР/ns1:УПРУП/ns1:ПредставительСотрудник/УТ2:Должность"/>
                        </div>
                        <p class="afCenter afP afSubscript">(Должность)</p>
                    </div>
                    <div class="afCol-1-4">
                        <div class="afValue afUnderlinedBlock"></div>
                        <p class="afCenter afP afSubscript">(Подпись)</p>
                    </div>
                    <div class="afCol-1-4">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:call-template name="УТ2:NameStr">
                                <xsl:with-param name="pName" select="/ns1:ЭДПФР/ns1:УПРУП/ns1:ПредставительСотрудник/УТ2:ФИО"/>                                        
                            </xsl:call-template>
                        </div>
                        <p class="afCenter afP afSubscript">(Ф.И.О)</p>
                    </div>
                </div>
                <p class="afInterval"/>

                <div class="afRow">
                    <div class="afCol-1-3">
                        <div class="afValue afUnderlinedBlock">
                            <xsl:call-template name="Date2Text">
                                <xsl:with-param name="pDate" select="/ns1:ЭДПФР/ns1:СлужебнаяИнформация/АФ5:ДатаВремя"/>                                        
                            </xsl:call-template>&#160;г.
                        </div>
                    </div>
                    <div class="afCol-1-3">
                        <div class="afCenter">М.П. (при наличии)</div>
                    </div>
                </div>
                <p class="afInterval"/>
                <p class="afInterval"/>
                <p class="afInterval"/>
                <p class="afInterval"/>
                <p class="afInterval"/>
                <p class="afInterval"/>

                <div class="afStickToBottom">
                    <div class="afRow">
                        <div class="afCol-1-3 afUnderlinedBlock"/>
                    </div>
                    <div class="afRow">
                        <p class="afSmallSize afJustify"><span class="afSup">2</span>&#160;В случае, если физическое лицо является сотрудником юридического лица, заполняются блоки «Физическое лицо» и «Юридическое лицо».</p>
                        <p class="afSmallSize afJustify">В случае, если физическое лицо является сотрудником индивидуального предприятия, заполняются блоки «Физическое лицо» и «Индивидуальный предприниматель».</p>
                        <p class="afSmallSize afJustify">В случае, если физическое лицо является уполномоченным представителем страхователя вне зависимости от принадлежности к юридическому лицу или индивидуальному предпринимателю, заполняется только блок «Физическое лицо».</p>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
