<?xml version='1.0' encoding="UTF-8"?>
<!--Базовые (атомарные) шаблоны для форматирования вывода значений элементов, не зависящие от пространства имен-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- =================================================== ТИПЫ СВЯЗАННЫЕ С ДАТОЙ =================================================== -->
	<!-- Дата в формате 17 декабря 2018-->
	<xsl:template name="Date2Text">
		<xsl:param name="pDate"/>
		<!-- Если равно 1 и дата пустая, то "пустое" значение принимает вид "  "           -->
		<!-- Если равно 0 и дата пустая, то "пустое" значение принимает вид "  "    20     -->
		<xsl:param name="pNo2000YearWhenEmpty" select="0"/>
        <xsl:param name="style" select="''"/>
		<xsl:choose>
			<!--Если дата пустая, то выводим "пустое" значение-->
			<xsl:when test="translate($pDate, ' ', '') = ''">
				<xsl:choose>
					<xsl:when test="$pNo2000YearWhenEmpty = '1'">
                        <span class="{$style}">&quot;&#160;&#160;&#160;&#160;&#160;&quot;</span>
                        <span class="{$style}">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>
                        <span class="{$style}">&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>	
					</xsl:when>
					<xsl:otherwise>
                        <span class="{$style}">&quot;&#160;&#160;&#160;&#160;&#160;&quot;</span>
                        <span class="{$style}">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</span>
                        <span class="{$style}">20&#160;&#160;&#160;&#160;&#160;</span>	
					</xsl:otherwise>
				</xsl:choose>				
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="dateText" select="string($pDate)"/>
				<xsl:variable name="month" select="substring($dateText, 6, 2)"/>
                <span class="{$style}"><xsl:value-of select="concat('&quot;', substring($dateText, 9, 2), '&quot;')"/></span>
                <span class="{$style}">
                    <xsl:choose>
                        <xsl:when test="$month = '01'"> января </xsl:when>
                        <xsl:when test="$month = '02'"> февраля </xsl:when>
                        <xsl:when test="$month = '03'"> марта </xsl:when>
                        <xsl:when test="$month = '04'"> апреля </xsl:when>
                        <xsl:when test="$month = '05'"> мая </xsl:when>
                        <xsl:when test="$month = '06'"> июня </xsl:when>
                        <xsl:when test="$month = '07'"> июля </xsl:when>
                        <xsl:when test="$month = '08'"> августа </xsl:when>
                        <xsl:when test="$month = '09'"> сентября </xsl:when>
                        <xsl:when test="$month = '10'"> октября </xsl:when>
                        <xsl:when test="$month = '11'"> ноября </xsl:when>
                        <xsl:when test="$month = '12'"> декабря </xsl:when>
                    </xsl:choose>
                </span>
                <span class="{$style}">
                    <xsl:value-of select="substring($dateText, 1, 4)"/>
                </span>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Дата в формате 17.12.2018 по ГОСТ Р 6.30-2003 -->
	<xsl:template name="Date2GOST">
		<xsl:param name="pDate"/>
		<!-- Если равно 1, то значение выводится без подчеркивания, включая до и после -->
		<xsl:param name="pNoUnderline" select="0"/>
		<!-- Если равно 1, то значение (в случае присутствия) выводится без неразрывных пробелов, включая до и после -->
		<xsl:param name="pNoUnbreakSpaces" select="0"/>
		<xsl:choose>
			<xsl:when test="$pDate = '' or not($pDate)"> &#160; </xsl:when>
			<xsl:otherwise>
				<xsl:variable name="dateText" select="string($pDate)"/>
				<xsl:choose>
					<xsl:when test="$pNoUnderline = '1'">
						<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$pNoUnbreakSpaces">
								<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('&#160;&#160;', substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4), '&#160;&#160;')"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Название месяца по его номеру -->
	<xsl:template name="Month2Text">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="$pMonth = '01'">январь</xsl:when>
			<xsl:when test="$pMonth = '02'">февраль</xsl:when>
			<xsl:when test="$pMonth = '03'">март</xsl:when>
			<xsl:when test="$pMonth = '04'">апрель</xsl:when>
			<xsl:when test="$pMonth = '05'">май</xsl:when>
			<xsl:when test="$pMonth = '06'">июнь</xsl:when>
			<xsl:when test="$pMonth = '07'">июль</xsl:when>
			<xsl:when test="$pMonth = '08'">август</xsl:when>
			<xsl:when test="$pMonth = '09'">сентябрь</xsl:when>
			<xsl:when test="$pMonth = '10'">октябрь</xsl:when>
			<xsl:when test="$pMonth = '11'">ноябрь</xsl:when>
			<xsl:when test="$pMonth = '12'">декабрь</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- Название месяца по его номеру вариант2 -->
	<xsl:template name="Month2TextNumbers">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="$pMonth = 1">январь</xsl:when>
			<xsl:when test="$pMonth = 2">февраль</xsl:when>
			<xsl:when test="$pMonth = 3">март</xsl:when>
			<xsl:when test="$pMonth = 4">апрель</xsl:when>
			<xsl:when test="$pMonth = 5">май</xsl:when>
			<xsl:when test="$pMonth = 6">июнь</xsl:when>
			<xsl:when test="$pMonth = 7">июль</xsl:when>
			<xsl:when test="$pMonth = 8">август</xsl:when>
			<xsl:when test="$pMonth = 9">сентябрь</xsl:when>
			<xsl:when test="$pMonth = 10">октябрь</xsl:when>
			<xsl:when test="$pMonth = 11">ноябрь</xsl:when>
			<xsl:when test="$pMonth = 12">декабрь</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!--Дата время в строку по формату 2018-11-30 14:00:00-05:00-->
	<xsl:template name="DateTime2Text">
		<xsl:param name="pDTime"/>
		<xsl:value-of select="translate($pDTime, 'T', ' ')"/>
	</xsl:template>
	<!-- ======================================================== ТИП - ДЕНЬГИ =======================================================  -->
	<!-- Сумма в формате  100 руб. 05 коп. -->
	<xsl:template name="Sum2RubKop">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ руб. ___коп -->
		<xsl:param name="pNoBlank" select="0"/>

		<xsl:choose>
			<!-- значения нет и пустые поля выводить не надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank = '1'"/>
			<!-- значения нет, но пустые поля выводить надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank != '1'">
				<span class="afValue afUnderline"> &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; </span> руб. <span class="afValue afUnderline"> &#160;&#160;&#160;&#160;&#160;
				</span> коп. </xsl:when>
			<xsl:when test="not(contains($pSum, '.'))">
				<span class="afValue afUnderline"> &#160;&#160;&#160;<xsl:value-of select="translate(format-number($pSum, '###,###,###,##0'), ',', ' ')"/>&#160;&#160; </span> руб. <span
					class="afValue afUnderline"> &#160;&#160;&#160;00&#160;&#160; </span> коп.
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="integerPart">
					<xsl:value-of select="substring-before($pSum, '.')"/>
				</xsl:variable>
				<xsl:variable name="fraction">
					<xsl:value-of select="substring-after($pSum, '.')"/>
				</xsl:variable>
				
				<span class="afValue afUnderline"> &#160;&#160;&#160;<xsl:value-of select="translate(format-number($integerPart, '###,###,###,##0'), ',', ' ')"/>&#160;&#160; </span> руб. <span
					class="afValue afUnderline"> &#160;&#160;&#160;<xsl:value-of select="format-number($fraction, '00')"/>&#160;&#160; </span> коп.</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
	<!-- Сумма в формате  100 руб. 05 коп. безжирного шрифта-->
	<xsl:template name="Sum2RubKopNoBold">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ руб. ___коп -->
		<xsl:param name="pNoBlank" select="0"/>
		
		<xsl:choose>
			<!-- значения нет и пустые поля выводить не надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank = '1'"/>
			<!-- значения нет, но пустые поля выводить надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank != '1'">
				<span class=" afUnderline"> &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160; </span> руб. <span class=" afUnderline"> &#160;&#160;&#160;&#160;&#160;
				</span> коп. </xsl:when>
			<xsl:when test="not(contains($pSum, '.'))">
				<span class=" afUnderline"> &#160;&#160;&#160;<xsl:value-of select="translate(format-number($pSum, '###,###,###,##0'), ',', ' ')"/>&#160;&#160; </span> руб. <span
					class=" afUnderline"> &#160;&#160;&#160;00&#160;&#160; </span> коп.
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="integerPart">
					<xsl:value-of select="substring-before($pSum, '.')"/>
				</xsl:variable>
				<xsl:variable name="fraction">
					<xsl:value-of select="substring-after($pSum, '.')"/>
				</xsl:variable>
				
				<span class=" afUnderline"> &#160;&#160;&#160;<xsl:value-of select="translate(format-number($integerPart, '###,###,###,##0'), ',', ' ')"/>&#160;&#160; </span> руб. <span
					class=" afUnderline"> &#160;&#160;&#160;<xsl:value-of select="format-number($fraction, '00')"/>&#160;&#160; </span> коп.</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
	<!-- Сумма в формате  100 руб. 05 коп. без подчеркивания -->
	<xsl:template name="Sum2RubKopNoUnderline">
		<xsl:param name="pSum"/>
		<!-- Если равно 1, то при отсутствии значения не выводить пустое ___ руб. ___коп -->
		<xsl:param name="pNoBlank" select="0"/>
		
		<xsl:choose>
			<!-- значения нет и пустые поля выводить не надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank = '1'"/>
			<!-- значения нет, но пустые поля выводить надо -->
			<xsl:when test="(not($pSum) or $pSum = '') and $pNoBlank != '1'">
				<span class="afValue"> </span>руб.<span class="afValue"> </span>коп.</xsl:when>
			<xsl:when test="not(contains($pSum, '.'))">
				<span class="afValue"> <xsl:value-of select="translate(format-number($pSum, '###,###,###,##0'), ',', ' ')"/> </span>руб.<span 
					class="afValue">00</span>коп.
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="integerPart">
					<xsl:value-of select="substring-before($pSum, '.')"/>
				</xsl:variable>
				<xsl:variable name="fraction">
					<xsl:value-of select="substring-after($pSum, '.')"/>
				</xsl:variable>
				
				<span class="afValue"> <xsl:value-of select="translate(format-number($integerPart, '###,###,###,##0'), ',', ' ')"/> </span>руб.<span
					class="afValue"> <xsl:value-of select="format-number($fraction, '00')"/> </span>коп.</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	<!-- ======================================================== ТИП - СТРОКА =======================================================  -->
	<!-- Номер телефона из числового представления без пробелов в строку с разделителями -->
	<xsl:template name="Phone2Text">
		<xsl:param name="pNumber"/>
		<xsl:if test="$pNumber">
			<xsl:choose>
				<xsl:when test="string-length($pNumber) = 5">
					<xsl:value-of select="concat(substring($pNumber, 1, 1), '-', substring($pNumber, 2, 2), '-', substring($pNumber, 4, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 6">
					<xsl:value-of select="concat(substring($pNumber, 1, 2), '-', substring($pNumber, 3, 2), '-', substring($pNumber, 5, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 7">
					<xsl:value-of select="concat(substring($pNumber, 1, 3), '-', substring($pNumber, 4, 2), '-', substring($pNumber, 6, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 10">
					<xsl:value-of select="concat('(', substring($pNumber, 1, 3), ') ', substring($pNumber, 4, 3), '-', substring($pNumber, 7, 2), '-', substring($pNumber, 9, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 11">
					<xsl:value-of
						select="concat(substring($pNumber, 1, 1), ' (', substring($pNumber, 2, 3), ') ', substring($pNumber, 5, 3), '-', substring($pNumber, 8, 2), '-', substring($pNumber, 10, 2))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pNumber"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
