<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="1.0">
    <xsl:template name="PensStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
            <xsl:when test="$pPensType = '1'"> страховая пенсия по старости </xsl:when>
            <xsl:when test="$pPensType = '2'"> страховая пенсия по инвалидности </xsl:when>
            <xsl:when test="$pPensType = '3'"> страховая пенсия по случаю потери кормильца </xsl:when>
            <xsl:when test="$pPensType = '4'"> доля страховой пенсии по старости </xsl:when>
            <xsl:when test="$pPensType = '5'"> накопительная пенсия </xsl:when>
            <xsl:when test="$pPensType = '6'"> пенсия за выслугу лет по государственному пенсионному обеспечению </xsl:when>
            <xsl:when test="$pPensType = '7'"> пенсия по старости по государственному пенсионному обеспечению </xsl:when>
            <xsl:when test="$pPensType = '8'"> пенсия по инвалидности по государственному пенсионному обеспечению </xsl:when>
            <xsl:when test="$pPensType = '9'"> пенсия по случаю потери кормильца по государственному пенсионному обеспечению </xsl:when>
            <xsl:when test="$pPensType = '10'"> социальная пенсия по старости </xsl:when>
            <xsl:when test="$pPensType = '11'"> социальная пенсия по инвалидности </xsl:when>
            <xsl:when test="$pPensType = '12'"> социальная пенсия по случаю потери кормильца </xsl:when>
            <xsl:when test="$pPensType = '13'"> пенсия, предусмотренная Законом Российской Федерации от 19 апреля 1991 г. N 1032-1 "О занятости населения в Российской Федерации" </xsl:when>
            <xsl:when test="$pPensType = '14'"> пенсия по старости, предусмотренная Законом Российской Федерации от 15 мая 1991 г. N 1244-1 "О социальной защите граждан, подвергшихся воздействию
                радиации вследствие катастрофы на Чернобыльской АЭС" </xsl:when>
            <xsl:when test="$pPensType = '15'"> федеральная социальная доплата к пенсии (если общая сумма моего материального обеспечения не достигнет величины прожиточного минимума пенсионера в
                субъекте Российской Федерации) </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="WithPensionStr">
        <xsl:param name="pPensType"/>
        <xsl:choose>
            <xsl:when test="$pPensType = '1'"> страховая пенсия по старости </xsl:when>
            <xsl:when test="$pPensType = '2'"> страховая пенсия по инвалидности </xsl:when>
            <xsl:when test="$pPensType = '3'"> страховая пенсия по случаю потери кормильца </xsl:when>
            <xsl:when test="$pPensType = '4'"> Страховая пенсия по старости досрочно </xsl:when>
            <xsl:when test="$pPensType = '5'"> Доля страховой пенсии </xsl:when>
            <xsl:when test="$pPensType = '6'"> Пенсия по государственному пенсионному обеспечению по старости </xsl:when>
            <xsl:when test="$pPensType = '7'"> Пенсия по государственному пенсионному обеспечению по инвалидности </xsl:when>
            <xsl:when test="$pPensType = '8'"> Пенсия по государственному пенсионному обеспечению по потере кормильца </xsl:when>
            <xsl:when test="$pPensType = '9'"> Пенсия по государственному пенсионному обеспечению космонавтам и летчикам-испытателям </xsl:when>
            <xsl:when test="$pPensType = '10'"> Социальная пенсия по старости </xsl:when>
            <xsl:when test="$pPensType = '11'"> Социальная пенсия по инвалидности </xsl:when>
            <xsl:when test="$pPensType = '12'"> Социальная пенсия по потере кормильца </xsl:when>
            <xsl:when test="$pPensType = '13'"> Накопительная пенсия </xsl:when>
            <xsl:when test="$pPensType = '14'"> Пенсия по старости, предусмотренная Законом Российской Федерации от 15 мая 1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС» </xsl:when>
            <xsl:when test="$pPensType = '15'"> Пенсия, предусмотренная Законом Российской Федерации от 19 апреля 1991 г. № 1032-1 «О занятости населения в Российской Федерации» </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="IncreaseKindStr">
        <xsl:param name="pIncreaseKind"/>
        <xsl:choose>
            <xsl:when test="$pIncreaseKind = '1'"> повышения(ий) фиксированной выплаты к страховой пенсии </xsl:when>
            <xsl:when test="$pIncreaseKind = '2'"> повышения(ий) фиксированной выплаты к страховой пенсии, дополнительного увеличения повышения(ий) фиксированной выплаты к страховой пенсии </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Вид пенсионного действия -->
    <xsl:template name="PensActStr">
        <xsl:param name="pPensActType"/>
        <xsl:choose>
            <xsl:when test="$pPensActType = 'ПЕНС'"> новое назначение пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ПРСЧ'"> перерасчет пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ОТКЗ'"> отказ от страховой пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ОТКН'"> конец периода отказа от СЧ пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ВОСТ'"> восстановление (новое назначение) страховой пенсии (переход с ИНВЛ на СТАР) </xsl:when>
            <xsl:when test="$pPensActType = 'ДПВЛ'"> назначение доли пенсии по выслуги лет </xsl:when>
            <xsl:when test="$pPensActType = 'КРСЧ'"> корректировка 1 августа </xsl:when>
            <xsl:when test="$pPensActType = 'КР09'"> корректировка на 01.08.2009 </xsl:when>
            <xsl:when test="$pPensActType = 'КРПК'"> расчет РПК на 31.12.2014 (конец РПК) </xsl:when>
            <xsl:when test="$pPensActType = 'СТОП'"> прекращение пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ПРБЗ'"> перерасчет 1 августа </xsl:when>
            <xsl:when test="$pPensActType = 'НПРА'"> дата наступления права на установление выплаты за счет СПН </xsl:when>
            <xsl:when test="$pPensActType = 'НОБР'"> дата обращения за установлением выплаты за счет СПН </xsl:when>
            <xsl:when test="$pPensActType = 'КСПН'"> корректировка установленной выплаты за счет СПН на основании всех видов СПН </xsl:when>
            <xsl:when test="$pPensActType = 'КОПС'"> корректировка установленной выплаты за счет ранее не учтенных ОПС-взносов для вида выплаты ОПС </xsl:when>
            <xsl:when test="$pPensActType = 'КСПВ'"> корректировка установленной выплаты за счет ранее не учтенных взносов ДСВ и МСК для вида выплаты СПВ </xsl:when>
            <xsl:when test="$pPensActType = 'ЕВДП'"> ката доплаты к установленной в прошлом году выплате вида ЕВ или ЕВО или ЕВДМ </xsl:when>
            <xsl:when test="$pPensActType = 'НАЗН'"> пенсионное действие при установлении выплаты ранее даты обращения, но не более чем на месяц </xsl:when>
            <xsl:when test="$pPensActType = 'ВОСП'"> восстановление пенсии после отказа </xsl:when>
            <xsl:when test="$pPensActType = 'ПРБЗ'"> беззаявительный перерасчет с 1 августа, начиная с 01.08.2016 </xsl:when>
            <xsl:when test="$pPensActType = 'ПРЕК'"> прекращение выплаты другой пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ПНДР'"> назначение другого вида пенсии </xsl:when>
            <xsl:when test="$pPensActType = 'ПСОХ'"> перевод на другой вид пенсии с сохранением старого размера </xsl:when>
            <xsl:when test="$pPensActType = 'ЕАЭС'"> Подсчет ИПК на 31-12-2020 дату вступления в силу соглашения ЕАЭС </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Форма пенсионного действия -->
    <xsl:template name="PensFormStr">
        <xsl:param name="pPensFormType"/>
        <xsl:choose>
            <xsl:when test="$pPensFormType = 'НОВ'"> новое пенсионное действие </xsl:when>
            <xsl:when test="$pPensFormType = 'ОТМН'"> отменяющее пенсионное действие </xsl:when>
        </xsl:choose>
    </xsl:template>


    <!-- Тип запроса выписки -->
    <xsl:template name="InquiryStr">
        <xsl:param name="pInquiryType"/>
        <xsl:choose>
            <xsl:when test="$pInquiryType = 'ПЕНС'"> для назначения трудовой пенсии </xsl:when>
            <xsl:when test="$pInquiryType = 'ПРСЧ'"> для перерасчета трудовой пенсии на 1 августа, для уточнения страховых пенсий с 01.01.2015 </xsl:when>
            <xsl:when test="$pInquiryType = 'ПЕНК'"> случай необходимости проведения корректировки назначенной ранее трудовой пенсии </xsl:when>
            <xsl:when test="$pInquiryType = 'КРСЧ'"> для беззаявительного перерасчета трудовой пенсии на 1 августа, для уточнения страховых пенсий с 01.01.2015 </xsl:when>
            <xsl:when test="$pInquiryType = 'КОНВ'"> для получения выписки по конвертации (выписка со сведениями до 2002 года) </xsl:when>
            <xsl:when test="$pInquiryType = 'РАСЧ'"> случай необходимости расчета размера трудовой пенсии на дату пенсионного действия с целью определения права на установление выплаты за счет средств
                пенсионных накоплений </xsl:when>
            <xsl:when test="$pInquiryType = 'СОЦД'"> случай необходимости получения выписки для определения периодов работы пенсионера </xsl:when>
            <xsl:when test="$pInquiryType = 'СДПР'"> для получения выписки по запросам судебных приставов </xsl:when>
            <xsl:when test="$pInquiryType = 'ПРБЧ'"> для перерасчета базовой части трудовой пенсии пенсионерам, имеющим северный стаж </xsl:when>
            <xsl:when test="$pInquiryType = 'НПЕН'"> Запрос на установление первой выплаты за счет СПН (НЧ, СПВ, ЕВ СПН) </xsl:when>
            <xsl:when test="$pInquiryType = 'НКОР'"> Запрос на корректировку выплаты за счет СПН (за счет ранее не учтенных СПН по ранее учтенным источникам ОПС и/или ДСВ и МСК) </xsl:when>
            <xsl:when test="$pInquiryType = 'НДОП'"> Запрос на доплату к ЕВ за счёт СПН </xsl:when>
            <xsl:when test="$pInquiryType = 'НВТР'"> Запрос на установление второй/повторной выплаты СПН (за счет СПН по ранее не учтенным источникам ОПС и/или ДСВ и МСК) </xsl:when>
            <xsl:when test="$pInquiryType = 'НПРД'"> Запрос на продолжение выплаты за счет СПН, прекращенной в НПФ в связи с ликвидацией </xsl:when>
            <xsl:when test="$pInquiryType = 'НИНФ'"> Запрос информации о действиях СФР по осуществлению выплаты за счет СПН </xsl:when>
            <xsl:when test="$pInquiryType = 'ПРБЗ'"> Беззаявительный перерасчет с 1 августа, начиная с 01.08.2016 </xsl:when>
            <xsl:when test="$pInquiryType = 'ВОСП'"> Восстановление пенсии после отказа </xsl:when>
            <xsl:when test="$pInquiryType = 'ДПВЛ'"> Назначение доли </xsl:when>
            <xsl:when test="$pInquiryType = 'НПРВ'"> Запрос на получение Выписки из специальной части индивидуального лицевого счета застрахованного лица для назначения правопреемникам умершего застрахованного лица выплаты за счет средств пенсионных накоплений </xsl:when>
            <xsl:when test="$pInquiryType = 'УВЕД'"> Уведомление о действиях, не требующих формирования выписки </xsl:when>

        </xsl:choose>
    </xsl:template>

    <!-- Вид пенсии -->
    <xsl:template name="PensionStr">
        <xsl:param name="pPensionType"/>
        <xsl:choose>
            <xsl:when test="$pPensionType = 'СТАР'"> по старости </xsl:when>
            <xsl:when test="$pPensionType = 'ИНВЛ'"> по инвалидности </xsl:when>
        </xsl:choose>
    </xsl:template>


	<!-- Виды выплат -->
	<xsl:template name="PaymentType">
		<xsl:param name="pPayType"/>
		<xsl:choose>
			<xsl:when test="$pPayType = '01.101'">Страховая пенсия по старости</xsl:when>
			<xsl:when test="$pPayType = '01.102'">Страховая пенсия по инвалидности</xsl:when>
			<xsl:when test="$pPayType = '01.103'">Страховая пенсия по потере кормильца</xsl:when>
			<xsl:when test="$pPayType = '01.201'">Пенсия по государственному пенсионному обеспечению по старости</xsl:when>
			<xsl:when test="$pPayType = '01.202'">Пенсия по государственному пенсионному обеспечению по инвалидности</xsl:when>
			<xsl:when test="$pPayType = '01.203'">Пенсия по государственному пенсионному обеспечению по потере кормильца</xsl:when>
			<xsl:when test="$pPayType = '01.204'">Пенсия по государственному пенсионному обеспечению за выслугу лет</xsl:when>
			<xsl:when test="$pPayType = '01.301'">Социальная пенсия по старости</xsl:when>
			<xsl:when test="$pPayType = '01.302'">Социальная пенсия по инвалидности</xsl:when>
			<xsl:when test="$pPayType = '01.303'">Социальная пенсия по потере кормильца</xsl:when>
			<xsl:when test="$pPayType = '01.304'">Социальная пенсия детям, оба родителя которых неизвестны</xsl:when>
			<xsl:when test="$pPayType = '01.401'">Пенсия по старости, предусмотренная Законом Российской Федерации от 15 мая 1991 г. № 1244-1 «О социальной защите граждан, подвергшихся воздействию радиации вследствие катастрофы на Чернобыльской АЭС»</xsl:when>
			<xsl:when test="$pPayType = '01.402'">Пенсия, предусмотренная Законом Российской Федерации от 19 апреля 1991 г. № 1032-1 «О занятости населения в Российской Федерации»</xsl:when>
			<xsl:when test="$pPayType = '01.403'">Пенсии депутатам последнего ВС РСФСР и их помощникам</xsl:when>
			<xsl:when test="$pPayType = '02.001'">Компенсация трудоспособным лицам, осуществляющим уход за нетрудоспособными лицами (В соответствии с Указом № 175)</xsl:when>
			<xsl:when test="$pPayType = '02.002'">Компенсация трудоспособным лицам, осуществляющим уход за нетрудоспособными лицами (В соответствии с Указом № 1455)</xsl:when>
			<xsl:when test="$pPayType = '03.001'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 5-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '03.002'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 122-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '03.003'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 181-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '03.004'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 1244-1-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '03.005'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 175-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '03.006'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 2123-1-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '03.007'">Ежемесячная денежная выплата (в соответствии с нормами Закона № 2-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '04.001'">Дополнительное ежемесячное материальное обеспечение (в соответствии с Указом № 363)</xsl:when>
			<xsl:when test="$pPayType = '04.002'">Дополнительное ежемесячное материальное обеспечение (в соответствии с Указом № 887)</xsl:when>
			<xsl:when test="$pPayType = '05.001'">Федеральная социальная доплата</xsl:when>
			<xsl:when test="$pPayType = '06.001'">Дополнительное материальное обеспечение атомщикам</xsl:when>
			<xsl:when test="$pPayType = '06.002'">Дополнительное материальное обеспечение сотрудникам ООН</xsl:when>
			<xsl:when test="$pPayType = '06.003'">Дополнительное материальное обеспечение героям ВОВ и кавалерам ордена Славы (Указ № 1708)</xsl:when>
			<xsl:when test="$pPayType = '06.004'">Дополнительное материальное обеспечение за выдающиеся достижения 21-ФЗ</xsl:when>
			<xsl:when test="$pPayType = '06.005'">Ежемесячная доплата к пенсии гражданам РФ, проживающим в республике Абхазия</xsl:when>
			<xsl:when test="$pPayType = '06.006'">Ежемесячная доплата к пенсии гражданам РФ, проживающим в республике Ю. Осетия</xsl:when>
			<xsl:when test="$pPayType = '06.007'">Дополнительное материальное обеспечение Указ № 995 от 28.08.2003 года</xsl:when>
			<xsl:when test="$pPayType = '06.008'">Дополнительное материальное обеспечение по персональным распоряжениям (указам) Президента РФ </xsl:when>
			<xsl:when test="$pPayType = '07.001'">Дополнительное социальное обеспечение (в соответствии с Законом № 84-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '07.002'">Дополнительное социальное обеспечение (в соответствии с Законом № 155-ФЗ)</xsl:when>
			<xsl:when test="$pPayType = '08.001'">Единовременная выплата к 65-летию Победы ВОВ (Указ № 247 от 24.02.2010) </xsl:when>
			<xsl:when test="$pPayType = '08.002'">Единовременная выплата к 67-летию Победы ВОВ (Указ № 595 от 07.05.2012) </xsl:when>
			<xsl:when test="$pPayType = '08.003'">Единовременная выплата к 70-летию Победы ВОВ (Указ № 100 от 26.02.2015) </xsl:when>
			<xsl:when test="$pPayType = '08.004'">Единовременная выплата к 73-летию Победы ВОВ (Указ № 195 от 06.05.2018) </xsl:when>
			<xsl:when test="$pPayType = '08.005'">Ежегодная выплата к годовщине Победы ВОВ (Указ № 186 от 24.04.2019) </xsl:when>
			<xsl:when test="$pPayType = '08.100'">Единовременная выплата гражданам, получающим пенсию (5000)</xsl:when>
			<xsl:when test="$pPayType = '08.006'">Единовременная выплата к 75-летию Победы ВОВ</xsl:when>
			<xsl:when test="$pPayType = '09.001'">Накопительная пенсия</xsl:when>
			<xsl:when test="$pPayType = '09.002'">Срочная пенсионная выплата</xsl:when>
			<xsl:when test="$pPayType = '09.003'">Единовременная выплата</xsl:when>
			<xsl:when test="$pPayType = '10.001'">Средства пенсионных накоплений, выплачиваемые правопреемникам</xsl:when>
			<xsl:when test="$pPayType = '11.001'">Ежемесячные денежные выплаты, в повышенном размере пенсий (п.4 ч.1 ст.18, п.3 ч.2 ст.19 и п.4 ч.1 ст.20 Закона РФ № 1244-1) (Экологическая выплата)</xsl:when>
			<xsl:when test="$pPayType = '12.001'">Доля страховой пенсии по старости</xsl:when>
			<xsl:when test="$pPayType = '13.001'">Компенсация проезда к месту отдыха (п.1 Постановления от 01.04.2005 № 176)</xsl:when>
			<xsl:when test="$pPayType = '13.002'">Компенсация северного переезда (ст.35 Закон РФ от 19.02.1993 № 4520-1)</xsl:when>
			<xsl:when test="$pPayType = '14.001'">Ежемесячная денежная выплата Героям и членам их семей (в соответствии с нормами Закона №4301-1 "О статусе Героев Советского Союза, Героев Российской Федерации и полных кавалеров ордена Славы")</xsl:when>
			<xsl:when test="$pPayType = '14.002'">Ежемесячная денежная выплата Героям и членам их семей (в соответствии с нормами Закона №5-ФЗ "О предоставлении социальных гарантий Героям Социалистического Труда, Героям Труда Российской Федерации и полным кавалерам ордена Трудовой Славы"")</xsl:when>
			<xsl:when test="$pPayType = '15.001'">Пособие на погребение, умершим пенсионерам, получавшим страховую или накопительную пенсию</xsl:when>
			<xsl:when test="$pPayType = '15.002'">Пособие на погребение, умершим пенсионерам, получавшим пенсию по государственному обеспечению</xsl:when>
			<xsl:when test="$pPayType = '15.003'">Пособие на погребение, умершим пенсионерам, оформившим пенсию досрочно, по предложению органов службы занятости</xsl:when>
			<xsl:when test="$pPayType = '16.001'">Пенсия, назначенная иностранным государством</xsl:when>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
