<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:УТ="http://пф.рф/унифицированныеТипы/2014-01-01" exclude-result-prefixes="xs УТ"
    version="1.0">


    <!-- Дата (развернуто)-->
    <xsl:template name="DateStr">
        <xsl:param name="pDate"/>
        <xsl:variable name="dateText" select="string($pDate)"/>
        <xsl:variable name="month" select="substring($dateText, 6, 2)"/>
        <xsl:value-of select="concat('&quot;', substring($dateText, 9, 2), '&quot;')"/>
        <xsl:choose>
            <xsl:when test="$month = '01'"> января </xsl:when>
            <xsl:when test="$month = '02'"> февраля </xsl:when>
            <xsl:when test="$month = '03'"> марта </xsl:when>
            <xsl:when test="$month = '04'"> апреля </xsl:when>
            <xsl:when test="$month = '05'"> мая </xsl:when>
            <xsl:when test="$month = '06'"> июня </xsl:when>
            <xsl:when test="$month = '07'"> июля </xsl:when>
            <xsl:when test="$month = '08'"> августа </xsl:when>
            <xsl:when test="$month = '09'"> сентября </xsl:when>
            <xsl:when test="$month = '10'"> октября </xsl:when>
            <xsl:when test="$month = '11'"> ноября </xsl:when>
            <xsl:when test="$month = '12'"> декабря </xsl:when>
        </xsl:choose>
        <xsl:value-of select="substring($dateText, 1, 4)"/>
    </xsl:template>

    <!-- ФИО -->
    <xsl:template name="УТ:NameStr">
        <xsl:param name="pName"/>
        <xsl:if test="$pName">
            <xsl:if test="$pName/УТ:Фамилия">
                <xsl:value-of select="$pName/УТ:Фамилия"/>&#160;</xsl:if>
            <xsl:if test="$pName/УТ:Имя">
                <xsl:value-of select="$pName/УТ:Имя"/>&#160;</xsl:if>
            <xsl:if test="$pName/УТ:Отчество">
                <xsl:value-of select="$pName/УТ:Отчество"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- Документ, удостоверяющий личность -->
    <xsl:template name="УТ:DocumentStr">
        <xsl:param name="pDocument"/>
        <xsl:param name="pData"/>
        <xsl:param name="pDataSpecial"/>
        <xsl:param name="pBirthplace"/>
        <xsl:param name="pPeriod"/>
        <xsl:if test="$pDocument">
            <table class="afTable">
                <tr>
                    <td>Наименование документа, удостоверяющего личность</td>
                    <td colspan="3" class="afValue">
                        <xsl:value-of select="$pDocument/УТ:ТипДокумента"/>
                    </td>
                </tr>
                <tr>
                    <td>Серия, номер</td>
                    <td class="afValue">
                        <xsl:value-of select="concat($pDocument/УТ:Серия, ' ', $pDocument/УТ:Номер)"/>
                    </td>
                    <td>Дата выдачи</td>
                    <td class="afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate">
                                <xsl:value-of select="$pDocument/УТ:ДатаВыдачи"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>Кем выдан</td>
                    <td colspan="3" class="afValue">
                        <xsl:value-of select="$pDocument/УТ:КемВыдан"/>
                    </td>
                </tr>
                <tr>
                    <td>Дата рождения</td>
                    <td colspan="3" class="afValue">
                        <xsl:if test="$pData">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="$pData"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="$pDataSpecial">
                            <xsl:call-template name="DateSpecialStr">
                                <xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
                            </xsl:call-template>
                        </xsl:if>
                    </td>
                </tr>
                <xsl:if test="$pBirthplace">
                    <tr>
                        <td>Место рождения</td>
                        <td colspan="3" class="afValue">
                            <xsl:call-template name="УТ:BirthplaceStr">
                                <xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="$pPeriod = '1'">
                    <tr>
                        <td>Срок действия документа</td>
                        <td colspan="3" class="afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="$pDocument/УТ:СрокДействия"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>

            </table>
        </xsl:if>
    </xsl:template>






    <!-- Дата (кратко)-->
    <xsl:template name="DateShortStr">
        <xsl:param name="pDate"/>
        <xsl:choose>
            <xsl:when test="$pDate = ''"/>
            <xsl:otherwise>
                <xsl:variable name="dateText" select="string($pDate)"/>
                <xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Дата (особая)-->
    <xsl:template name="DateSpecialStr">
        <xsl:param name="pDate"/>
        <xsl:if test="$pDate">
            <xsl:if test="$pDate/УТ:День">
                <xsl:value-of select="$pDate/УТ:День"/>. </xsl:if>
            <xsl:if test="$pDate/УТ:Месяц">
                <xsl:value-of select="$pDate/УТ:Месяц"/>. </xsl:if>
            <xsl:if test="$pDate/УТ:Год">
                <xsl:value-of select="$pDate/УТ:Год"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- Гражданство-->
    <xsl:template name="NationalityStr">
        <xsl:param name="pNationalityType"/>
        <xsl:choose>
            <xsl:when test="$pNationalityType = '1'"> гражданин(-ка) РФ </xsl:when>
            <xsl:when test="$pNationalityType = '2'"> иностранный гражданин </xsl:when>
            <xsl:when test="$pNationalityType = '3'"> лицо без гражданства </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="УТ:AddressStr">
        <xsl:param name="pAddress"/>
        <xsl:if test="$pAddress/УТ:Индекс">
            <xsl:value-of select="$pAddress/УТ:Индекс"/>, </xsl:if>
        <xsl:choose>
            <xsl:when test="$pAddress/УТ:РоссийскийАдрес">
                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Регион">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Регион/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Регион/УТ:Название, ' ', $pAddress/УТ:РоссийскийАдрес/УТ:Регион/УТ:Сокращение)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$pAddress/УТ:РоссийскийАдрес/УТ:Регион/УТ:Название"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Район">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Район/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Район/УТ:Сокращение, ' ', $pAddress/УТ:РоссийскийАдрес/УТ:Район/УТ:Название)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat(' р-он.', $pAddress/УТ:РоссийскийАдрес/УТ:Район/УТ:Название)"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Город">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Город/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Город/УТ:Сокращение, '. ', $pAddress/УТ:РоссийскийАдрес/УТ:Город/УТ:Название)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat(' г.', $pAddress/УТ:РоссийскийАдрес/УТ:Город/УТ:Название)"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:НаселенныйПункт">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:НаселенныйПункт/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:НаселенныйПункт/УТ:Сокращение, '. ', $pAddress/УТ:РоссийскийАдрес/УТ:НаселенныйПункт/УТ:Название)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$pAddress/УТ:РоссийскийАдрес/УТ:НаселенныйПункт/УТ:Название"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Улица">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Улица/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Улица/УТ:Сокращение, '. ', $pAddress/УТ:РоссийскийАдрес/УТ:Улица/УТ:Название)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$pAddress/УТ:РоссийскийАдрес/УТ:Улица/УТ:Название"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Дом">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Дом/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Дом/УТ:Сокращение, '. ', $pAddress/УТ:РоссийскийАдрес/УТ:Дом/УТ:Номер)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat(' д.', $pAddress/УТ:РоссийскийАдрес/УТ:Дом/УТ:Номер)"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>

                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Строение">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Строение/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Строение/УТ:Сокращение, '. ', $pAddress/УТ:РоссийскийАдрес/УТ:Строение/УТ:Номер)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat(' стр.', $pAddress/УТ:РоссийскийАдрес/УТ:Строение/УТ:Номер)"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>

                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Корпус">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Корпус/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Корпус/УТ:Сокращение, ' ', $pAddress/УТ:РоссийскийАдрес/УТ:Корпус/УТ:Номер)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat(' корпус ', $pAddress/УТ:РоссийскийАдрес/УТ:Корпус/УТ:Номер)"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>

                <xsl:if test="$pAddress/УТ:РоссийскийАдрес/УТ:Квартира">
                    <xsl:choose>
                        <xsl:when test="$pAddress/УТ:РоссийскийАдрес/УТ:Квартира/УТ:Сокращение">
                            <xsl:value-of select="concat($pAddress/УТ:РоссийскийАдрес/УТ:Квартира/УТ:Сокращение, '. ', $pAddress/УТ:РоссийскийАдрес/УТ:Квартира/УТ:Номер)"/>, </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat(' кв. ', $pAddress/УТ:РоссийскийАдрес/УТ:Квартира/УТ:Номер)"/>, </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$pAddress/УТ:ИностранныйАдрес">
                <xsl:call-template name="УТ:AddressForeignStr">
                    <xsl:with-param name="pAddress" select="$pAddress"/>
                </xsl:call-template>                
            </xsl:when>
            <xsl:when test="$pAddress/УТ:НеструктурированныйАдрес">
                <xsl:if test="$pAddress/УТ:НеструктурированныйАдрес">
                    <xsl:value-of select="$pAddress/УТ:НеструктурированныйАдрес"/>, </xsl:if>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="УТ:AddressForeignStr">
        <xsl:param name="pAddress"/>
        <xsl:if test="$pAddress/УТ:ИностранныйАдрес">
            <xsl:if test="$pAddress/УТ:ИностранныйАдрес/УТ:КодСтраны and ($pAddress/УТ:ИностранныйАдрес/УТ:КодСтраны != '')">
                <xsl:value-of select="$pAddress/УТ:ИностранныйАдрес/УТ:КодСтраны"/>, </xsl:if>
            <xsl:if test="$pAddress/УТ:ИностранныйАдрес/УТ:НазваниеСтраны and ($pAddress/УТ:ИностранныйАдрес/УТ:НазваниеСтраны != '')">
                <xsl:value-of select="$pAddress/УТ:ИностранныйАдрес/УТ:НазваниеСтраны"/>, </xsl:if>
            <xsl:if test="$pAddress/УТ:ИностранныйАдрес/УТ:АдресКириллицей and ($pAddress/УТ:ИностранныйАдрес/УТ:АдресКириллицей != '')">
                <xsl:value-of select="$pAddress/УТ:ИностранныйАдрес/УТ:АдресКириллицей"/>, </xsl:if>
            <xsl:if test="$pAddress/УТ:ИностранныйАдрес/УТ:АдресЛатиницей">
                <xsl:value-of select="$pAddress/УТ:ИностранныйАдрес/УТ:АдресЛатиницей"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- Место рождения -->
    <xsl:template name="УТ:BirthplaceStr">
        <xsl:param name="pBirthplace"/>
        <xsl:if test="$pBirthplace/УТ:ГородРождения">
            <xsl:value-of select="$pBirthplace/УТ:ГородРождения"/>
        </xsl:if>
        <xsl:if test="$pBirthplace/УТ:РайонРождения">
            <xsl:value-of select="concat(' ', $pBirthplace/УТ:РайонРождения)"/>
        </xsl:if>
        <xsl:if test="$pBirthplace/УТ:РегионРождения">
            <xsl:value-of select="concat(' ', $pBirthplace/УТ:РегионРождения)"/>
        </xsl:if>
        <xsl:if test="$pBirthplace/УТ:СтранаРождения">
            <xsl:value-of select="concat(' ', $pBirthplace/УТ:СтранаРождения)"/>
        </xsl:if>
    </xsl:template>

    <!-- Представитель -->
    <xsl:template name="УТ:RepresentativeStr">
        <xsl:param name="pRepresent"/>
        <xsl:if test="$pRepresent">
            <p class="afParagraph">2. Представитель <xsl:call-template name="УТ:RepresentativeType">
                    <xsl:with-param name="pRepresent" select="$pRepresent"/>
                </xsl:call-template>
            </p>
            <p class="afValue afCenter afUnderlinedBlock">
                <xsl:call-template name="УТ:NameStr">
                    <xsl:with-param name="pName" select="$pRepresent/УТ:АнкетныеДанные/УТ:ФИО"> </xsl:with-param>
                </xsl:call-template>
                <xsl:if test="$pRepresent/УТ:ЮридическоеЛицо"> ,&#160; <xsl:value-of select="$pRepresent/УТ:ЮридическоеЛицо/УТ:Наименование"/>
                </xsl:if>
            </p>
            <p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и
                фамилия, имя, отчество (при наличии) ее представителя)</p>
            <p class="afInterval"/>

            <xsl:if test="$pRepresent/УТ:АнкетныеДанные/УТ:АдресРегистрации">
                <div class="afRow">
                    <div class="afC">адрес места жительства</div>
                    <div class="afValue afBlankUnderlinedBlock afMarginLeft200"/>
                </div>
                <p class="afValue afUnderlinedLeftBlock">
                    <xsl:call-template name="УТ:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ:АнкетныеДанные/УТ:АдресРегистрации"/>
                    </xsl:call-template>
                </p>
            </xsl:if>
            <xsl:if test="$pRepresent/УТ:АнкетныеДанные/УТ:АдресПребывания">
                <div class="afRow">
                    <div class="afC">адрес места пребывания</div>
                    <div class="afValue afBlankUnderlinedBlock afMarginLeft200"/>
                </div>
                <p class="afValue afUnderlinedLeftBlock">
                    <xsl:call-template name="УТ:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ:АнкетныеДанные/УТ:АдресПребывания"/>
                    </xsl:call-template>
                </p>
            </xsl:if>
            <xsl:if test="$pRepresent/УТ:АнкетныеДанные/УТ:АдресФактический">
                <div class="afRow">
                    <div class="afC">адрес места фактического проживания</div>
                    <div class="afValue afBlankUnderlinedBlock afMarginLeft300"/>
                </div>
                <p class="afValue afUnderlinedLeftBlock">
                    <xsl:call-template name="УТ:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ:АнкетныеДанные/УТ:АдресФактический"/>
                    </xsl:call-template>
                </p>
            </xsl:if>

            <xsl:if test="$pRepresent/УТ:ЮридическоеЛицо/УТ:ЮрАдрес">
                <div class="afRow">
                    <div class="afC">адрес места нахождения организации</div>
                    <div class="afValue afBlankUnderlinedBlock afMarginLeft300"/>
                </div>
                <p class="afValue afUnderlinedLeftBlock">
                    <xsl:call-template name="УТ:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ:ЮридическоеЛицо/УТ:ЮрАдрес"/>
                    </xsl:call-template>
                </p>
            </xsl:if>
            <xsl:if test="$pRepresent/УТ:ЮридическоеЛицо/УТ:Адрес">
                <div class="afRow">
                    <div class="afC">адрес места нахождения организации</div>
                    <div class="afValue afBlankUnderlinedBlock afMarginLeft300"/>
                </div>
                <p class="afValue afUnderlinedLeftBlock">
                    <xsl:call-template name="УТ:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ:ЮридическоеЛицо/УТ:Адрес"/>
                    </xsl:call-template>
                </p>
            </xsl:if>

            <xsl:if test="$pRepresent/УТ:АнкетныеДанные/УТ:Телефоны">
                <div class="afRow">
                    <div class="afC">номер телефона</div>
                    <div class="afCol-1-3 afValue afUnderlinedLeftBlock">
                        <xsl:value-of select="$pRepresent/УТ:АнкетныеДанные/УТ:Телефоны"/>
                    </div>
                </div>
            </xsl:if>

            <xsl:if test="$pRepresent/УТ:АнкетныеДанные/УТ:УдостоверяющийДокумент">
                <table class="afTable">
                    <tr>
                        <td>Наименование документа, удостоверяющего личность представителя</td>
                        <td colspan="3" class="afValue">
                            <xsl:value-of select="$pRepresent/УТ:АнкетныеДанные/УТ:УдостоверяющийДокумент/УТ:ТипДокумента"/>
                        </td>
                    </tr>
                    <tr>
                        <td>Серия, номер</td>
                        <td class="afValue">
                            <xsl:value-of select="concat($pRepresent/УТ:АнкетныеДанные/УТ:УдостоверяющийДокумент/УТ:Серия, ' ', $pRepresent/УТ:АнкетныеДанные/УТ:УдостоверяющийДокумент/УТ:Номер)"/>
                        </td>
                        <td>Дата выдачи</td>
                        <td class="afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="$pRepresent/УТ:АнкетныеДанные/УТ:УдостоверяющийДокумент/УТ:ДатаВыдачи"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </tr>
                    <tr>
                        <td>Кем выдан</td>
                        <td colspan="3" class="afValue">
                            <xsl:value-of select="$pRepresent/УТ:АнкетныеДанные/УТ:УдостоверяющийДокумент/УТ:КемВыдан"/>
                        </td>
                    </tr>
                </table>
            </xsl:if>
            <p class="afInterval"/>
            <table class="afTable">
                <tr>
                    <td>Наименование документа, подтверждающего полномочия представителя</td>
                    <td colspan="3" class="afValue">
                        <xsl:value-of select="$pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:Наименование"/>
                    </td>
                </tr>
                <tr>
                    <td>Серия, номер</td>
                    <td class="afValue">
                        <xsl:value-of select="concat($pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:Серия, ' ', $pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:Номер)"/>
                    </td>
                    <td>Дата выдачи</td>
                    <td class="afValue">
                        <xsl:call-template name="DateShortStr">
                            <xsl:with-param name="pDate">
                                <xsl:value-of select="$pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:ДатаВыдачи"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <td>Кем выдан</td>
                    <td colspan="3" class="afValue">
                        <xsl:value-of select="$pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:КемВыдан"/>
                    </td>
                </tr>
                <xsl:if test="$pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:СрокДействия">
                    <tr>
                        <td>Срок действия полномочий</td>
                        <td colspan="3" class="afValue">
                            <xsl:call-template name="DateShortStr">
                                <xsl:with-param name="pDate">
                                    <xsl:value-of select="$pRepresent/УТ:ДокументПодтверждающийПолномочия/УТ:СрокДействия"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- Тип представителя -->
    <xsl:template name="УТ:RepresentativeType">
        <xsl:param name="pRepresent"/>
        <xsl:if test="$pRepresent">
            <span> ( <xsl:choose>
                    <xsl:when test="$pRepresent/УТ:Тип[text() = '1'] and not($pRepresent/УТ:НаимОрг) and not($pRepresent/УТ:ЮридическоеЛицо)"><span class="afUnderline">законный представитель
                            недееспособного лица</span></xsl:when>
                    <xsl:otherwise>законный представитель недееспособного лица</xsl:otherwise>
                </xsl:choose>,&#160; <xsl:choose>
                    <xsl:when test="($pRepresent/УТ:Статус[text() = '2'] and $pRepresent/УТ:НаимОрг) or ($pRepresent/УТ:ЮридическоеЛицо)"><span class="afUnderline">организация, на которую возложено
                            исполнение обязанностей опекуна или попечителя</span></xsl:when>
                    <xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise>
                </xsl:choose>,&#160; <xsl:choose>
                    <xsl:when test="$pRepresent/УТ:Тип[text() = '2'] and not($pRepresent/УТ:НаимОрг) and not($pRepresent/УТ:ЮридическоеЛицо)"><span class="afUnderline">доверенное
                        лицо</span></xsl:when>
                    <xsl:otherwise>доверенное лицо</xsl:otherwise>
                </xsl:choose> ) </span>
            <span class="afItalic">(нужное подчеркнуть):</span>
        </xsl:if>
    </xsl:template>
    
    <!-- Номер телефона-->
    <xsl:template name="УТ:PhoneNumberStr">
        <xsl:param name="pNumber"/>        
        <xsl:if test="$pNumber">
            <xsl:choose>
                <xsl:when test="string-length($pNumber)=5">
                    <xsl:value-of select="concat(substring($pNumber, 1, 1), '-', substring($pNumber, 2, 2), '-', substring($pNumber, 4, 2))"/>   
                </xsl:when>
                <xsl:when test="string-length($pNumber)=6">
                    <xsl:value-of select="concat(substring($pNumber, 1, 2), '-', substring($pNumber, 3, 2), '-', substring($pNumber, 5, 2))"/>   
                </xsl:when>
                <xsl:when test="string-length($pNumber)=7">
                    <xsl:value-of select="concat(substring($pNumber, 1, 3), '-', substring($pNumber, 4, 2), '-', substring($pNumber, 6, 2))"/>   
                </xsl:when>                
                <xsl:when test="string-length($pNumber)=10">
                    <xsl:value-of select="concat('(',substring($pNumber, 1, 3), ') ', substring($pNumber, 4, 3), '-', substring($pNumber, 7, 2), '-', substring($pNumber, 9, 2))"/>   
                </xsl:when>
                <xsl:when test="string-length($pNumber)=11">
                    <xsl:value-of select="concat(substring($pNumber, 1, 1),' (',substring($pNumber, 2, 3), ') ', substring($pNumber, 5, 3), '-', substring($pNumber, 8, 2), '-', substring($pNumber, 10, 2))"/>   
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="$pNumber"/></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <!-- Пункт нормативного документа-->
    <xsl:template name="УТ:NormativeDocumentStr">
        <xsl:param name="pNormativeDocument"/>
        <xsl:choose>
            <xsl:when test="$pNormativeDocument">
                <xsl:if test="$pNormativeDocument/УТ:Подпункт"> подпункт <xsl:value-of select="$pNormativeDocument/УТ:Подпункт"/>
                </xsl:if>
                <xsl:if test="$pNormativeDocument/УТ:Пункт">
                    <xsl:value-of select="concat(' п.', $pNormativeDocument/УТ:Пункт)"/>
                </xsl:if>
                <xsl:if test="$pNormativeDocument/УТ:Часть">
                    <xsl:value-of select="concat(' ч.', $pNormativeDocument/УТ:Часть)"/>
                </xsl:if>
                <xsl:if test="$pNormativeDocument/УТ:Статья">
                    <xsl:value-of select="concat(' ст.', $pNormativeDocument/УТ:Статья)"/>
                </xsl:if>
                <xsl:if test="$pNormativeDocument/УТ:НормативныйДокумент">
                    <xsl:value-of select="concat(' ', $pNormativeDocument/УТ:НормативныйДокумент)"/>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>		
    </xsl:template>
</xsl:stylesheet>
