<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:УТ2="http://пф.рф/УТ/2017-08-21" exclude-result-prefixes="xs УТ2" version="1.0">

	<!--Данный шаблон В БУДУЩЕМ БУДЕТ УДАЛЕН!!!! Вместо него необходимо использовать шаблон Date2Text из Преобразования\Общие\Базовые.xsl-->
	<!-- Дата (развернуто)-->
	<xsl:template name="DateStr">
		<xsl:param name="pDate"/>
		<xsl:variable name="dateText" select="string($pDate)"/>
		<xsl:variable name="month" select="substring($dateText, 6, 2)"/>
		<xsl:value-of select="concat('&quot;', substring($dateText, 9, 2), '&quot;')"/>
		<xsl:choose>
			<xsl:when test="$month = '01'"> января </xsl:when>
			<xsl:when test="$month = '02'"> февраля </xsl:when>
			<xsl:when test="$month = '03'"> марта </xsl:when>
			<xsl:when test="$month = '04'"> апреля </xsl:when>
			<xsl:when test="$month = '05'"> мая </xsl:when>
			<xsl:when test="$month = '06'"> июня </xsl:when>
			<xsl:when test="$month = '07'"> июля </xsl:when>
			<xsl:when test="$month = '08'"> августа </xsl:when>
			<xsl:when test="$month = '09'"> сентября </xsl:when>
			<xsl:when test="$month = '10'"> октября </xsl:when>
			<xsl:when test="$month = '11'"> ноября </xsl:when>
			<xsl:when test="$month = '12'"> декабря </xsl:when>
		</xsl:choose>
		<xsl:value-of select="substring($dateText, 1, 4)"/>
	</xsl:template>
	<!--Данный шаблон В БУДУЩЕМ БУДЕТ УДАЛЕН!!!! Вместо него необходимо использовать шаблон Month2Text из Преобразования\Общие\Базовые.xsl-->
	<xsl:template name="MonthStr">
		<xsl:param name="pMonth"/>
		<xsl:choose>
			<xsl:when test="$pMonth = '01'">январь</xsl:when>
			<xsl:when test="$pMonth = '02'">февраль</xsl:when>
			<xsl:when test="$pMonth = '03'">март</xsl:when>
			<xsl:when test="$pMonth = '04'">апрель</xsl:when>
			<xsl:when test="$pMonth = '05'">май</xsl:when>
			<xsl:when test="$pMonth = '06'">июнь</xsl:when>
			<xsl:when test="$pMonth = '07'">июль</xsl:when>
			<xsl:when test="$pMonth = '08'">август</xsl:when>
			<xsl:when test="$pMonth = '09'">сентябрь</xsl:when>
			<xsl:when test="$pMonth = '10'">октябрь</xsl:when>
			<xsl:when test="$pMonth = '11'">ноябрь</xsl:when>
			<xsl:when test="$pMonth = '12'">декабрь</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!--Данный шаблон В БУДУЩЕМ БУДЕТ УДАЛЕН!!!! Вместо него необходимо использовать шаблон Date2GOST из Преобразования\Общие\Базовые.xsl-->
	<!-- Дата (кратко)-->
	<xsl:template name="DateShortStr">
		<xsl:param name="pDate"/>		
		<xsl:if test="$pDate and $pDate!=''">
			<xsl:variable name="dateText" select="string($pDate)"/>
			<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
		</xsl:if>
	</xsl:template>

	<!-- Дата (особая) УТ2 -->
	<xsl:template name="УТ2:DateSpecialStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:if test="$pDate/УТ2:День">
				<xsl:value-of select="$pDate/УТ2:День"/>.</xsl:if>
			<xsl:choose>
				<xsl:when test="$pDate/УТ2:Месяц">
					<xsl:value-of select="$pDate/УТ2:Месяц"/>.</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pDate/УТ2:День">&#160;.</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$pDate/УТ2:Год">
				<xsl:value-of select="$pDate/УТ2:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Дата (особая) (развернуто) УТ2 -->
	<xsl:template name="УТ2:DateSpecialLongStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:choose>
				<xsl:when test="$pDate/УТ2:День">
					<xsl:value-of select="concat('&quot;', format-number($pDate/УТ2:День, '00'), '&quot;')"/>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$pDate/УТ2:Месяц">
					<xsl:choose>
						<xsl:when test="$pDate/УТ2:День">
							<xsl:choose>
								<xsl:when test="$pDate/УТ2:Месяц = 1"> января </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 2"> февраля </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 3"> марта </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 4"> апреля </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 5"> мая </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 6"> июня </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 7"> июля </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 8"> августа </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 9"> сентября </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 10"> октября </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 11"> ноября </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 12"> декабря </xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$pDate/УТ2:Месяц = 1">январь </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 2">февраль </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 3">март </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 4">апрель </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 5">май </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 6">июнь </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 7">июль </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 8">август </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 9">сентябрь </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 10">октябрь </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 11">ноябрь </xsl:when>
								<xsl:when test="$pDate/УТ2:Месяц = 12">декабрь </xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$pDate/УТ2:Год">
				<xsl:value-of select="$pDate/УТ2:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Фамилия И.О. -->
	<xsl:template name="УТ2:NameStrShort">
		<xsl:param name="pName"/>
		<xsl:param name="pIOFirst"/>
		<xsl:if test="$pName">
			<xsl:choose>
				<xsl:when test="$pIOFirst">
					<xsl:if test="$pName/УТ2:Имя">
						<xsl:value-of select="substring($pName/УТ2:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ2:Отчество">
						<xsl:value-of select="substring($pName/УТ2:Отчество, 1, 1)"/>. </xsl:if>
					<xsl:if test="$pName/УТ2:Фамилия">
						<xsl:value-of select="$pName/УТ2:Фамилия"/>&#160;</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pName/УТ2:Фамилия">
						<xsl:value-of select="$pName/УТ2:Фамилия"/>&#160;</xsl:if>
					<xsl:if test="$pName/УТ2:Имя">
						<xsl:value-of select="substring($pName/УТ2:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ2:Отчество">
						<xsl:value-of select="substring($pName/УТ2:Отчество, 1, 1)"/>. </xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!-- ФИО -->
	<xsl:template name="УТ2:NameStr">
		<xsl:param name="pName"/>
		<!--pNoBreakWhitespace - устанавливает, следует ли использовать неразрывные пробелы или разрывные
				1 - неразрывные
				0 - разрывные (3-per-em space)-->
		<xsl:param name="pNoBreakWhitespace" select="1"/>
		<xsl:if test="$pName">
			<xsl:if test="$pName/УТ2:Фамилия">
				<xsl:value-of select="$pName/УТ2:Фамилия"/><xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose></xsl:if>
			<xsl:if test="$pName/УТ2:Имя">
				<xsl:value-of select="$pName/УТ2:Имя"/><xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose></xsl:if>
			<xsl:if test="$pName/УТ2:Отчество">
				<xsl:value-of select="$pName/УТ2:Отчество"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Документ, удостоверяющий личность -->
	<xsl:template name="УТ2:DocumentStr">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable">
				<tr>
					<td>Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ2:Тип"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ2:Серия, ' ', $pDocument/УТ2:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ2:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ2:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ2:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>Место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ2:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if></td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ2:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>

	<!-- Гражданство-->
	<xsl:template name="NationalityStr">
		<xsl:param name="pNationalityType"/>
		<xsl:choose>
			<xsl:when test="$pNationalityType = '1'"> гражданин(-ка) РФ </xsl:when>
			<xsl:when test="$pNationalityType = '2'"> иностранный гражданин </xsl:when>
			<xsl:when test="$pNationalityType = '3'"> лицо без гражданства </xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Пункт нормативного документа-->
	<xsl:template name="УТ2:NormativeDocumentStr">
		<xsl:param name="pNormativeDocument"/>
		<xsl:choose>
			<xsl:when test="$pNormativeDocument">
				<xsl:if test="$pNormativeDocument/УТ2:Подпункт"> подпункт <xsl:value-of select="$pNormativeDocument/УТ2:Подпункт"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ2:Пункт">
					<xsl:value-of select="concat(' п.', $pNormativeDocument/УТ2:Пункт)"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ2:Часть">
					<xsl:value-of select="concat(' ч.', $pNormativeDocument/УТ2:Часть)"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ2:Статья">
					<xsl:value-of select="concat(' ст.', $pNormativeDocument/УТ2:Статья)"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ2:НормативныйДокумент">
					<xsl:value-of select="concat(' ', $pNormativeDocument/УТ2:НормативныйДокумент)"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>


	<xsl:template name="УТ2:AddressStr">
		<xsl:param name="pAddress"/>
		<xsl:param name="needIndex" select="1"/>
		<xsl:param name="needRegion" select="1"/>
		<xsl:if test="$needIndex and $pAddress/УТ2:Индекс and $pAddress/УТ2:Индекс!=''">
			<xsl:value-of select="$pAddress/УТ2:Индекс"/>, </xsl:if>
		<xsl:if test="$needRegion and $pAddress/УТ2:Регион">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ2:Регион/УТ2:Сокращение">	
					<xsl:choose>
						<xsl:when test="$pAddress/УТ2:Регион/УТ2:Сокращение='край' or $pAddress/УТ2:Регион/УТ2:Сокращение='Республика'">
							<xsl:value-of select="concat($pAddress/УТ2:Регион/УТ2:Название, ' ', $pAddress/УТ2:Регион/УТ2:Сокращение)"/>,
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($pAddress/УТ2:Регион/УТ2:Название, ' ', $pAddress/УТ2:Регион/УТ2:Сокращение, '.')"/>,</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ2:Регион/УТ2:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:Округ">
			<xsl:value-of select="$pAddress/УТ2:Округ"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ2:Район">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ2:Район/УТ2:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ2:Район/УТ2:Название, ' ', $pAddress/УТ2:Район/УТ2:Сокращение)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($pAddress/УТ2:Район/УТ2:Название, ' р-н')"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:Город">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ2:Город/УТ2:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ2:Город/УТ2:Сокращение, '. ', $pAddress/УТ2:Город/УТ2:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('г. ', $pAddress/УТ2:Город/УТ2:Название)"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:ВнутригородскойРайон">
			<xsl:value-of select="$pAddress/УТ2:ВнутригородскойРайон"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ2:НаселенныйПункт">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ2:НаселенныйПункт/УТ2:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ2:НаселенныйПункт/УТ2:Сокращение, '. ', $pAddress/УТ2:НаселенныйПункт/УТ2:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ2:НаселенныйПункт/УТ2:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:Улица">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ2:Улица/УТ2:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ2:Улица/УТ2:Сокращение, '. ', $pAddress/УТ2:Улица/УТ2:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ2:Улица/УТ2:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:Дом">
			<xsl:value-of select="concat(' д. ', $pAddress/УТ2:Дом)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:Строение or $pAddress/УТ2:Владение or $pAddress/УТ2:Корпус or $pAddress/УТ2:Квартира">, </xsl:if>
		<xsl:if test="$pAddress/УТ2:Строение">
			<xsl:value-of select="concat(' стр. ', $pAddress/УТ2:Строение)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ2:Владение">
			<xsl:value-of select="$pAddress/УТ2:Владение"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ2:Корпус">
			<xsl:value-of select="concat(' корпус ', $pAddress/УТ2:Корпус)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ2:Квартира">
			<xsl:value-of select="concat(' кв. ', $pAddress/УТ2:Квартира)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ2:Неструктурированный">
			<xsl:value-of select="$pAddress/УТ2:Неструктурированный"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="УТ2:AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress/УТ2:Иностранный">
			<xsl:if test="$pAddress/УТ2:Иностранный/УТ2:КодСтраны">
				<xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ2:Иностранный/УТ2:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ2:Иностранный/УТ2:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ2:Иностранный/УТ2:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ2:Иностранный/УТ2:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Место рождения -->
	<xsl:template name="УТ2:BirthplaceStr">
		<xsl:param name="pBirthplace"/>
		<xsl:if test="$pBirthplace/УТ2:Город">
			<xsl:value-of select="$pBirthplace/УТ2:Город"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ2:Район">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ2:Район)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ2:Регион">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ2:Регион)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ2:Страна">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ2:Страна)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="УТ2:NumberedDocName">
		<xsl:param name="pDoc"/>
		<xsl:value-of select="$pDoc/УТ2:Наименование"/>
		<xsl:for-each select="$pDoc/УТ2:Реквизиты/УТ2:Реквизит">
			<xsl:if test="position() > 1">,</xsl:if> &#160;<xsl:value-of select="./УТ2:Наименование"/>&#160;<xsl:value-of select="./УТ2:Значение"/>
		</xsl:for-each>
		<xsl:if test="$pDoc/УТ2:ПредставленностьДокумента"> &#160;<xsl:value-of select="$pDoc/УТ2:ПредставленностьДокумента"/> экз. </xsl:if>
	</xsl:template>

	<!-- Представитель УТ2 -->
	<xsl:template name="УТ2:RepresentativeStr">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:if test="$pRepresent">
			<p class="afParagraph">2. Представитель <xsl:call-template name="УТ2:RepresentativeType">
					<xsl:with-param name="pRepresent" select="$pRepresent"/>
				</xsl:call-template>
			</p>
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:call-template name="УТ2:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:ФИО"/>
				</xsl:call-template>
				<xsl:if test="$pRepresent/УТ2:ЮридическоеЛицо"> ,&#160; <xsl:value-of select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Наименование"/>
				</xsl:if>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
			<p class="afInterval"/>

			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресРегистрации">
				<div class="afRow">
					<div class="afC">адрес места жительства</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ2:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресРегистрации"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресПребывания">
				<div class="afRow">
					<div class="afC">адрес места пребывания</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ2:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресПребывания"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресФактический">
				<div class="afRow">
					<div class="afC">адрес места фактического проживания</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ2:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресФактический"/>
					</xsl:call-template>
				</p>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:ЮрАдрес">
				<div class="afRow">
					<div class="afC">юридический адрес организации</div>
					<div class="afBlankUnderlinedBlock afMarginLeft300"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ2:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:ЮрАдрес"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Адрес">
				<div class="afRow">
					<div class="afC">адрес места нахождения организации</div>
					<div class="afBlankUnderlinedBlock afMarginLeft300"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ2:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Адрес"/>
					</xsl:call-template>
				</p>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:Телефоны">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:Телефоны"/>
					</div>
				</div>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент">
				<table class="afTable">
					<tr>
						<td>Наименование документа, удостоверяющего личность представителя</td>
						<td colspan="3" class="afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:ТипДокумента">
									<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:ТипДокумента"/>
								</xsl:when>
								<xsl:when test="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Тип">
									<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Тип"/>
								</xsl:when>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td>Серия, номер</td>
						<td class="afValue">
							<xsl:value-of select="concat($pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Серия, ' ', $pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Номер)"/>
						</td>
						<td>Дата выдачи</td>
						<td class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:ДатаВыдачи"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>Кем выдан</td>
						<td colspan="3" class="afValue">
							<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:КемВыдан"/>
						</td>
					</tr>
					<xsl:if test="$pIDPeriod = '1'">
						<tr>
							<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
									<span class="afSubscript"> (при наличии)</span>
								</xsl:if></td>
							<td colspan="3" class="afValue">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:СрокДействия"/>
									</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:if>
				</table>
			</xsl:if>
			<p class="afInterval"/>
			<table class="afTable">
				<tr>
					<td>Наименование документа, подтверждающего полномочия представителя</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:Наименование"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:Серия, ' ', $pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:КемВыдан"/>
					</td>
				</tr>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия полномочий</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>

			</table>
		</xsl:if>
	</xsl:template>
	
		<!-- Представитель v2 УТ2 -->
	<xsl:template name="УТ2:RepresentativeStrV2">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:if test="$pRepresent">
			<p class="afParagraph">2. Представитель <xsl:call-template name="УТ2:RepresentativeType">
					<xsl:with-param name="pRepresent" select="$pRepresent"/>
				</xsl:call-template>
			</p>
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:call-template name="УТ2:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:ФИО"/>
				</xsl:call-template>
				<xsl:if test="$pRepresent/УТ2:ЮридическоеЛицо"> ,&#160; <xsl:value-of select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Наименование"/>
				</xsl:if>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
			<p class="afInterval"/>

            <xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресРегистрации">
                <div class="afRow">
					<div class="afFloatLeft">адрес места жительства</div>
					<div class="afColLeft-3-4 afValue afBlankUnderlinedBlockAuto">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресРегистрации"/>
                    </xsl:call-template>
					</div>
                </div>
            </xsl:if>
            <xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресПребывания">
                <div class="afRow">
                    <div class="afFloatLeft">адрес места пребывания</div>
					<div class="afColLeft-3-4 afValue afBlankUnderlinedBlockAuto">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресПребывания"/>
                    </xsl:call-template>
					</div>
                </div>
            </xsl:if>
            <xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресФактический">
                <div class="afRow">
                    <div class="afFloatLeft">адрес места фактического проживания</div>
					<div class="afCol-13-20 afValue afBlankUnderlinedBlockAuto">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ2:АнкетныеДанные/УТ2:АдресФактический"/>
                    </xsl:call-template>
					</div>
                </div>
            </xsl:if>

            <!-- <xsl:if test="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:ЮрАдрес">
                <div class="afRow">
                    <div class="afFloatLeft">юридический адрес организации</div>
					<div class="afColLeft-3-4 afValue afBlankUnderlinedBlockAuto">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:ЮрАдрес"/>
                    </xsl:call-template>
					</div>
                </div>
            </xsl:if> -->
            <xsl:if test="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Адрес">
                <div class="afRow">
                    <div class="afFloatLeft">адрес места нахождения организации</div>
					<div class="afCol-5-8 afValue afBlankUnderlinedBlockAuto">
                    <xsl:call-template name="УТ2:AddressStr">
                        <xsl:with-param name="pAddress" select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Адрес"/>
                    </xsl:call-template>
					</div>
                </div>
            </xsl:if>

			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:Телефоны">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:Телефоны"/>
					</div>
				</div>
			</xsl:if>
			<xsl:choose>
			<xsl:when test="$pRepresent/УТ2:АнкетныеДанные/УТ2:Телефоны">
                <div class="afRow">
                    <div class="afC">номер телефона</div>
                    <div class="afCol-1-3 afValue afUnderlinedBlock">
                        <xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:Телефоны"/>
                    </div>
                </div>
			</xsl:when>
			<xsl:otherwise>
                <div class="afRow">
                    <div class="afC">номер телефона</div>
                    <div class="afCol-1-3 afValue afUnderlinedBlock">
                        <xsl:value-of select="$pRepresent/УТ2:ЮридическоеЛицо/УТ2:Телефоны"/>
                    </div>
                </div>
			</xsl:otherwise>
            </xsl:choose>

			<xsl:if test="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент">
				<table class="afTable afTable100">
					<tr>
						<td>Наименование документа, удостоверяющего личность представителя</td>
						<td colspan="3" class="afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:ТипДокумента">
									<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:ТипДокумента"/>
								</xsl:when>
								<xsl:when test="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Тип">
									<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Тип"/>
								</xsl:when>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td>Серия, номер</td>
						<td class="afValue">
							<xsl:value-of select="concat($pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Серия, ' ', $pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:Номер)"/>
						</td>
						<td>Дата выдачи</td>
						<td class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:ДатаВыдачи"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>Кем выдан</td>
						<td colspan="3" class="afValue">
							<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:КемВыдан"/>
						</td>
					</tr>
					<xsl:if test="$pIDPeriod = '1'">
						<tr>
							<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
									<span class="afSubscript"> (при наличии)</span>
								</xsl:if></td>
							<td colspan="3" class="afValue">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$pRepresent/УТ2:АнкетныеДанные/УТ2:УдостоверяющийДокумент/УТ2:СрокДействия"/>
									</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:if>
				</table>
			</xsl:if>
			<p class="afInterval"/>
			<table class="afTable afTable100">
				<tr>
					<td>Наименование документа, подтверждающего полномочия представителя</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:Наименование"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:Серия, ' ', $pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:КемВыдан"/>
					</td>
				</tr>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия полномочий</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ2:ДокументПодтверждающийПолномочия/УТ2:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>

			</table>
		</xsl:if>
	</xsl:template>

	<!-- Тип представителя УТ2 -->
	<xsl:template name="УТ2:RepresentativeType">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pType1Text" select="'законный представитель недееспособного лица'"/>
		<xsl:param name="pNoteStyle" select="'afItalic'"/>
		<xsl:if test="$pRepresent">
			<span> (<xsl:choose>
				<xsl:when test="$pRepresent/УТ2:Тип[text() = '1'] and count($pRepresent/УТ2:ЮридическоеЛицо) = 0"><span class="afUnderline"><xsl:value-of select="$pType1Text"/></span></xsl:when>
				<xsl:otherwise><xsl:value-of select="$pType1Text"/></xsl:otherwise>
				</xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="count($pRepresent/УТ2:ЮридическоеЛицо) > 0"><span class="afUnderline">организация, на которую возложено исполнение обязанностей опекуна или попечителя</span></xsl:when>
					<xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise></xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="$pRepresent/УТ2:Тип[text() = '2'] and count($pRepresent/УТ2:ЮридическоеЛицо) = 0"><span class="afUnderline">доверенное лицо</span></xsl:when>
					<xsl:otherwise>доверенное лицо</xsl:otherwise>
					</xsl:choose>) <span class="{$pNoteStyle}">(нужное подчеркнуть):</span></span>
		</xsl:if>
	</xsl:template>

	<!--Данный шаблон В БУДУЩЕМ БУДЕТ УДАЛЕН!!!! Вместо него необходимо использовать шаблон Phone2Text из Преобразования\Общие\Базовые.xsl-->
	<!-- Номер телефона-->
	<xsl:template name="УТ2:PhoneNumberStr">
		<xsl:param name="pNumber"/>
		<xsl:if test="$pNumber">
			<xsl:choose>
				<xsl:when test="string-length($pNumber) = 5">
					<xsl:value-of select="concat(substring($pNumber, 1, 1), '-', substring($pNumber, 2, 2), '-', substring($pNumber, 4, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 6">
					<xsl:value-of select="concat(substring($pNumber, 1, 2), '-', substring($pNumber, 3, 2), '-', substring($pNumber, 5, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 7">
					<xsl:value-of select="concat(substring($pNumber, 1, 3), '-', substring($pNumber, 4, 2), '-', substring($pNumber, 6, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 10">
					<xsl:value-of select="concat('(', substring($pNumber, 1, 3), ') ', substring($pNumber, 4, 3), '-', substring($pNumber, 7, 2), '-', substring($pNumber, 9, 2))"/>
				</xsl:when>
				<xsl:when test="string-length($pNumber) = 11">
					<xsl:value-of
						select="concat(substring($pNumber, 1, 1), ' (', substring($pNumber, 2, 3), ') ', substring($pNumber, 5, 3), '-', substring($pNumber, 8, 2), '-', substring($pNumber, 10, 2))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pNumber"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
