<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:УТ3="http://пф.рф/УТ/2022-07-14" exclude-result-prefixes="xs УТ3" version="1.0">
	


<!-- Дата (кратко)-->
	<xsl:template name="DateShortStr">
		<xsl:param name="pDate"/>		
		<xsl:if test="$pDate and $pDate!=''">
			<xsl:variable name="dateText" select="string($pDate)"/>
			<xsl:value-of select="concat(substring($dateText, 9, 2), '.', substring($dateText, 6, 2), '.', substring($dateText, 1, 4))"/>
		</xsl:if>
	</xsl:template>

<!-- Дата (особая) УТ3 -->
	<xsl:template name="УТ3:DateSpecialStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:if test="$pDate/УТ3:День">
				<xsl:value-of select="$pDate/УТ3:День"/>.</xsl:if>
			<xsl:choose>
				<xsl:when test="$pDate/УТ3:Месяц">
					<xsl:value-of select="$pDate/УТ3:Месяц"/>.</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pDate/УТ3:День">&#160;.</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$pDate/УТ3:Год">
				<xsl:value-of select="$pDate/УТ3:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Дата (особая) (развернуто) УТ3 -->
	<xsl:template name="УТ3:DateSpecialLongStr">
		<xsl:param name="pDate"/>
		<xsl:if test="$pDate">
			<xsl:choose>
				<xsl:when test="$pDate/УТ3:День">
					<xsl:value-of select="concat('&quot;', format-number($pDate/УТ3:День, '00'), '&quot;')"/>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$pDate/УТ3:Месяц">
					<xsl:choose>
						<xsl:when test="$pDate/УТ3:День">
							<xsl:choose>
								<xsl:when test="$pDate/УТ3:Месяц = 1"> января </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 2"> февраля </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 3"> марта </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 4"> апреля </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 5"> мая </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 6"> июня </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 7"> июля </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 8"> августа </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 9"> сентября </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 10"> октября </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 11"> ноября </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 12"> декабря </xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$pDate/УТ3:Месяц = 1">январь </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 2">февраль </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 3">март </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 4">апрель </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 5">май </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 6">июнь </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 7">июль </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 8">август </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 9">сентябрь </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 10">октябрь </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 11">ноябрь </xsl:when>
								<xsl:when test="$pDate/УТ3:Месяц = 12">декабрь </xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$pDate/УТ3:Год">
				<xsl:value-of select="$pDate/УТ3:Год"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Фамилия И.О. -->
	<xsl:template name="УТ3:NameStrShort">
		<xsl:param name="pName"/>
		<xsl:param name="pIOFirst"/>
		<xsl:if test="$pName">
			<xsl:choose>
				<xsl:when test="$pIOFirst">
					<xsl:if test="$pName/УТ3:Имя">
						<xsl:value-of select="substring($pName/УТ3:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ3:Отчество">
						<xsl:value-of select="substring($pName/УТ3:Отчество, 1, 1)"/>. </xsl:if>
					<xsl:if test="$pName/УТ3:Фамилия">
						<xsl:value-of select="$pName/УТ3:Фамилия"/>&#160;</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$pName/УТ3:Фамилия">
						<xsl:value-of select="$pName/УТ3:Фамилия"/>&#160;</xsl:if>
					<xsl:if test="$pName/УТ3:Имя">
						<xsl:value-of select="substring($pName/УТ3:Имя, 1, 1)"/>.&#160;</xsl:if>
					<xsl:if test="$pName/УТ3:Отчество">
						<xsl:value-of select="substring($pName/УТ3:Отчество, 1, 1)"/>. </xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!-- ФИО -->
	<xsl:template name="УТ3:NameStr">
		<xsl:param name="pName"/>
		<!--pNoBreakWhitespace - устанавливает, следует ли использовать неразрывные пробелы или разрывные
				1 - неразрывные
				0 - разрывные (3-per-em space)-->
		<xsl:param name="pNoBreakWhitespace" select="1"/>
		<xsl:if test="$pName">
			<xsl:if test="$pName/УТ3:Фамилия">
				<xsl:value-of select="$pName/УТ3:Фамилия"/><xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose></xsl:if>
			<xsl:if test="$pName/УТ3:Имя">
				<xsl:value-of select="$pName/УТ3:Имя"/><xsl:choose>
					<xsl:when test="$pNoBreakWhitespace">&#160;</xsl:when>
					<xsl:otherwise>&#8196;</xsl:otherwise>
				</xsl:choose></xsl:if>
			<xsl:if test="$pName/УТ3:Отчество">
				<xsl:value-of select="$pName/УТ3:Отчество"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Документ, удостоверяющий личность -->
	<xsl:template name="УТ3:DocumentStr">
		<xsl:param name="pDocument"/>
		<xsl:param name="pData"/>
		<xsl:param name="pDataSpecial"/>
		<xsl:param name="pBirthplace"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pPeriodNote"/>
		<xsl:if test="$pDocument">
			<table class="afTable">
				<tr>
					<td>Наименование документа, удостоверяющего личность</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ3:Тип"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pDocument/УТ3:Серия, ' ', $pDocument/УТ3:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pDocument/УТ3:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pDocument/УТ3:КемВыдан"/>
					</td>
				</tr>
				<tr>
					<td>Дата рождения</td>
					<td colspan="3" class="afValue">
						<xsl:if test="$pData">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pData"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$pDataSpecial">
							<xsl:call-template name="УТ3:DateSpecialStr">
								<xsl:with-param name="pDate" select="$pDataSpecial"> </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<xsl:if test="$pBirthplace">
					<tr>
						<td>Место рождения</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="УТ3:BirthplaceStr">
								<xsl:with-param name="pBirthplace" select="$pBirthplace"> </xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия документа
							<xsl:if test="$pPeriodNote = '1'">
								<span class="afSubscript"> (при наличии)</span>
							</xsl:if></td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pDocument/УТ3:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>

	<!-- Гражданство-->
	<xsl:template name="NationalityStr">
		<xsl:param name="pNationalityType"/>
		<xsl:choose>
			<xsl:when test="$pNationalityType = '1'"> гражданин(-ка) РФ </xsl:when>
			<xsl:when test="$pNationalityType = '2'"> иностранный гражданин </xsl:when>
			<xsl:when test="$pNationalityType = '3'"> лицо без гражданства </xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Пункт нормативного документа-->
	<xsl:template name="УТ3:NormativeDocumentStr">
		<xsl:param name="pNormativeDocument"/>
		<xsl:choose>
			<xsl:when test="$pNormativeDocument">
				<xsl:if test="$pNormativeDocument/УТ3:Подпункт"> подпункт <xsl:value-of select="$pNormativeDocument/УТ3:Подпункт"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ3:Пункт">
					<xsl:value-of select="concat(' п.', $pNormativeDocument/УТ3:Пункт)"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ3:Часть">
					<xsl:value-of select="concat(' ч.', $pNormativeDocument/УТ3:Часть)"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ3:Статья">
					<xsl:value-of select="concat(' ст.', $pNormativeDocument/УТ3:Статья)"/>
				</xsl:if>
				<xsl:if test="$pNormativeDocument/УТ3:НормативныйДокумент">
					<xsl:value-of select="concat(' ', $pNormativeDocument/УТ3:НормативныйДокумент)"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>


	<xsl:template name="УТ3:AddressStr">
		<xsl:param name="pAddress"/>
		<xsl:param name="needIndex" select="1"/>
		<xsl:param name="needRegion" select="1"/>
		<xsl:if test="$needIndex and $pAddress/УТ3:Индекс  and $pAddress/УТ3:Индекс!=''">
			<xsl:value-of select="$pAddress/УТ3:Индекс"/>, </xsl:if>
		<xsl:if test="$needRegion and $pAddress/УТ3:Регион">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ3:Регион/УТ3:Сокращение">	
					<xsl:choose>
						<xsl:when test="$pAddress/УТ3:Регион/УТ3:Сокращение='край' or $pAddress/УТ3:Регион/УТ3:Сокращение='Республика'">
							<xsl:value-of select="concat($pAddress/УТ3:Регион/УТ3:Название, ' ', $pAddress/УТ3:Регион/УТ3:Сокращение)"/>,
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($pAddress/УТ3:Регион/УТ3:Название, ' ', $pAddress/УТ3:Регион/УТ3:Сокращение, '.')"/>,</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ3:Регион/УТ3:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:Округ">
			<xsl:value-of select="$pAddress/УТ3:Округ"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ3:Район">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ3:Район/УТ3:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ3:Район/УТ3:Название, ' ', $pAddress/УТ3:Район/УТ3:Сокращение)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($pAddress/УТ3:Район/УТ3:Название, ' р-н')"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:Город">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ3:Город/УТ3:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ3:Город/УТ3:Сокращение, '. ', $pAddress/УТ3:Город/УТ3:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('г. ', $pAddress/УТ3:Город/УТ3:Название)"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:ВнутригородскойРайон">
			<xsl:value-of select="$pAddress/УТ3:ВнутригородскойРайон"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ3:НаселенныйПункт">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ3:НаселенныйПункт/УТ3:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ3:НаселенныйПункт/УТ3:Сокращение, '. ', $pAddress/УТ3:НаселенныйПункт/УТ3:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ3:НаселенныйПункт/УТ3:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:Улица">
			<xsl:choose>
				<xsl:when test="$pAddress/УТ3:Улица/УТ3:Сокращение">
					<xsl:value-of select="concat($pAddress/УТ3:Улица/УТ3:Сокращение, '. ', $pAddress/УТ3:Улица/УТ3:Название)"/>, </xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pAddress/УТ3:Улица/УТ3:Название"/>, </xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:Дом">
			<xsl:value-of select="concat(' д. ', $pAddress/УТ3:Дом)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:Строение or $pAddress/УТ3:Владение or $pAddress/УТ3:Корпус or $pAddress/УТ3:Квартира">, </xsl:if>
		<xsl:if test="$pAddress/УТ3:Строение">
			<xsl:value-of select="concat(' стр. ', $pAddress/УТ3:Строение)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ3:Владение">
			<xsl:value-of select="$pAddress/УТ3:Владение"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ3:Корпус">
			<xsl:value-of select="concat(' корпус ', $pAddress/УТ3:Корпус)"/>, </xsl:if>
		<xsl:if test="$pAddress/УТ3:Квартира">
			<xsl:value-of select="concat(' кв. ', $pAddress/УТ3:Квартира)"/>
		</xsl:if>
		<xsl:if test="$pAddress/УТ3:Неструктурированный">
			<xsl:value-of select="$pAddress/УТ3:Неструктурированный"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="УТ3:AddressForeignStr">
		<xsl:param name="pAddress"/>
		<xsl:if test="$pAddress/УТ3:Иностранный">
			<xsl:if test="$pAddress/УТ3:Иностранный/УТ3:КодСтраны">
				<xsl:value-of select="$pAddress/УТ3:Иностранный/УТ3:КодСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ3:Иностранный/УТ3:НазваниеСтраны">
				<xsl:value-of select="$pAddress/УТ3:Иностранный/УТ3:НазваниеСтраны"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ3:Иностранный/УТ3:АдресКириллицей">
				<xsl:value-of select="$pAddress/УТ3:Иностранный/УТ3:АдресКириллицей"/>, </xsl:if>
			<xsl:if test="$pAddress/УТ3:Иностранный/УТ3:АдресЛатиницей">
				<xsl:value-of select="$pAddress/УТ3:Иностранный/УТ3:АдресЛатиницей"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!-- Место рождения -->
	<xsl:template name="УТ3:BirthplaceStr">
		<xsl:param name="pBirthplace"/>
		<xsl:if test="$pBirthplace/УТ3:Город">
			<xsl:value-of select="$pBirthplace/УТ3:Город"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ3:Район">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ3:Район)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ3:Регион">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ3:Регион)"/>
		</xsl:if>
		<xsl:if test="$pBirthplace/УТ3:Страна">
			<xsl:value-of select="concat(' ', $pBirthplace/УТ3:Страна)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="УТ3:NumberedDocName">
		<xsl:param name="pDoc"/>
		<xsl:value-of select="$pDoc/УТ3:Наименование"/>
		<xsl:for-each select="$pDoc/УТ3:Реквизиты/УТ3:Реквизит">
			<xsl:if test="position() > 1">,</xsl:if> &#160;<xsl:value-of select="./УТ3:Наименование"/>&#160;<xsl:value-of select="./УТ3:Значение"/>
		</xsl:for-each>
		<xsl:if test="$pDoc/УТ3:ПредставленностьДокумента"> &#160;<xsl:value-of select="$pDoc/УТ3:ПредставленностьДокумента"/> экз. </xsl:if>
	</xsl:template>

	<!-- Представитель УТ2 -->
	<xsl:template name="УТ3:RepresentativeStr">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pPeriod"/>
		<xsl:param name="pIDPeriod"/>
		<xsl:param name="pIDPeriodNote"/>
		<xsl:if test="$pRepresent">
			<p class="afParagraph">2. Представитель <xsl:call-template name="УТ3:RepresentativeType">
					<xsl:with-param name="pRepresent" select="$pRepresent"/>
				</xsl:call-template>
			</p>
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:call-template name="УТ3:NameStr">
					<xsl:with-param name="pName" select="$pRepresent/УТ3:АнкетныеДанные/УТ3:ФИО"/>
				</xsl:call-template>
				<xsl:if test="$pRepresent/УТ3:ЮридическоеЛицо"> ,&#160; <xsl:value-of select="$pRepresent/УТ3:ЮридическоеЛицо/УТ3:Наименование"/>
				</xsl:if>
			</p>
			<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии) представителя; наименование организации, на которую возложено исполнение обязанностей опекуна или попечителя и фамилия,
				имя, отчество (при наличии) ее представителя)</p>
			<p class="afInterval"/>

			<xsl:if test="$pRepresent/УТ3:АнкетныеДанные/УТ3:АдресРегистрации">
				<div class="afRow">
					<div class="afC">адрес места жительства</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ3:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ3:АнкетныеДанные/УТ3:АдресРегистрации"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ3:АнкетныеДанные/УТ3:АдресПребывания">
				<div class="afRow">
					<div class="afC">адрес места пребывания</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ3:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ3:АнкетныеДанные/УТ3:АдресПребывания"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ3:АнкетныеДанные/УТ3:АдресФактический">
				<div class="afRow">
					<div class="afC">адрес места фактического проживания</div>
					<div class="afBlankUnderlinedBlock afMarginLeft200"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ3:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ3:АнкетныеДанные/УТ3:АдресФактический"/>
					</xsl:call-template>
				</p>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ3:ЮридическоеЛицо/УТ3:ЮрАдрес">
				<div class="afRow">
					<div class="afC">юридический адрес организации</div>
					<div class="afBlankUnderlinedBlock afMarginLeft300"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ3:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ3:ЮридическоеЛицо/УТ3:ЮрАдрес"/>
					</xsl:call-template>
				</p>
			</xsl:if>
			<xsl:if test="$pRepresent/УТ3:ЮридическоеЛицо/УТ3:Адрес">
				<div class="afRow">
					<div class="afC">адрес места нахождения организации</div>
					<div class="afBlankUnderlinedBlock afMarginLeft300"/>
				</div>
				<p class="afValue afUnderlinedLeftBlock">
					<xsl:call-template name="УТ3:AddressStr">
						<xsl:with-param name="pAddress" select="$pRepresent/УТ3:ЮридическоеЛицо/УТ3:Адрес"/>
					</xsl:call-template>
				</p>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ3:АнкетныеДанные/УТ3:Телефоны">
				<div class="afRow">
					<div class="afC">номер телефона</div>
					<div class="afCol-1-3 afValue afUnderlinedBlock">
						<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:Телефоны"/>
					</div>
				</div>
			</xsl:if>

			<xsl:if test="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент">
				<table class="afTable">
					<tr>
						<td>Наименование документа, удостоверяющего личность представителя</td>
						<td colspan="3" class="afValue">
							<xsl:choose>
								<xsl:when test="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:ТипДокумента">
									<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:ТипДокумента"/>
								</xsl:when>
								<xsl:when test="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:Тип">
									<xsl:choose>
										<xsl:when test="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:Тип = 'ПРОЧЕЕ'">
											<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:Наименование"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:Тип"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td>Серия, номер</td>
						<td class="afValue">
							<xsl:value-of select="concat($pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:Серия, ' ', $pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:Номер)"/>
						</td>
						<td>Дата выдачи</td>
						<td class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:ДатаВыдачи"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>Кем выдан</td>
						<td colspan="3" class="afValue">
							<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:КемВыдан"/>
						</td>
					</tr>
					<xsl:if test="$pIDPeriod = '1'">
						<tr>
							<td>Срок действия документа
								<xsl:if test="$pIDPeriodNote = '1'">
									<span class="afSubscript"> (при наличии)</span>
								</xsl:if></td>
							<td colspan="3" class="afValue">
								<xsl:call-template name="DateShortStr">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$pRepresent/УТ3:АнкетныеДанные/УТ3:УдостоверяющийДокумент/УТ3:СрокДействия"/>
									</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:if>
				</table>
			</xsl:if>
			<p class="afInterval"/>
			<table class="afTable">
				<tr>
					<td>Наименование документа, подтверждающего полномочия представителя</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ3:ДокументПодтверждающийПолномочия/УТ3:Наименование"/>
					</td>
				</tr>
				<tr>
					<td>Серия, номер</td>
					<td class="afValue">
						<xsl:value-of select="concat($pRepresent/УТ3:ДокументПодтверждающийПолномочия/УТ3:Серия, ' ', $pRepresent/УТ3:ДокументПодтверждающийПолномочия/УТ3:Номер)"/>
					</td>
					<td>Дата выдачи</td>
					<td class="afValue">
						<xsl:call-template name="DateShortStr">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$pRepresent/УТ3:ДокументПодтверждающийПолномочия/УТ3:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Кем выдан</td>
					<td colspan="3" class="afValue">
						<xsl:value-of select="$pRepresent/УТ3:ДокументПодтверждающийПолномочия/УТ3:КемВыдан"/>
					</td>
				</tr>
				<xsl:if test="$pPeriod = '1'">
					<tr>
						<td>Срок действия полномочий</td>
						<td colspan="3" class="afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$pRepresent/УТ3:ДокументПодтверждающийПолномочия/УТ3:СрокДействия"/>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:if>

			</table>
		</xsl:if>
	</xsl:template>

	<!-- Тип представителя УТ2 -->
	<xsl:template name="УТ3:RepresentativeType">
		<xsl:param name="pRepresent"/>
		<xsl:param name="pType1Text" select="'законный представитель недееспособного лица'"/>
		<xsl:param name="pNoteStyle" select="'afItalic'"/>
		<xsl:if test="$pRepresent">
			<span> (<xsl:choose>
				<xsl:when test="$pRepresent/УТ3:Тип[text() = '1'] and count($pRepresent/УТ3:ЮридическоеЛицо) = 0"><span class="afUnderline"><xsl:value-of select="$pType1Text"/></span></xsl:when>
				<xsl:otherwise><xsl:value-of select="$pType1Text"/></xsl:otherwise>
				</xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="count($pRepresent/УТ3:ЮридическоеЛицо) > 0"><span class="afUnderline">организация, на которую возложено исполнение обязанностей опекуна или попечителя</span></xsl:when>
					<xsl:otherwise>организация, на которую возложено исполнение обязанностей опекуна или попечителя</xsl:otherwise></xsl:choose>,&#160;<xsl:choose>
					<xsl:when test="$pRepresent/УТ3:Тип[text() = '2'] and count($pRepresent/УТ3:ЮридическоеЛицо) = 0"><span class="afUnderline">доверенное лицо</span></xsl:when>
					<xsl:otherwise>доверенное лицо</xsl:otherwise>
					</xsl:choose>) <span class="{$pNoteStyle}">(нужное подчеркнуть):</span></span>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
