<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:УТ2="http://пф.рф/УТ/2017-08-21" xmlns:АФ4="http://пф.рф/АФ/2017-08-21" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ2 АФ4" version="1.0">
           
    <xsl:template name="PrintSignature">
        <xsl:param name="pSignature"/>            
        <xsl:choose>
            <xsl:when test="$pSignature">
                <xsl:variable name="dateStartText" select="$pSignature/АФ4:СрокДействия/АФ4:С"/>
                <xsl:variable name="dateEndText" select="$pSignature/АФ4:СрокДействия/АФ4:По"/> 
                <div class="afSignature">
                    <p>Документ подписан <br/>
                        усиленной квалифицированной электронной <br/>
                        подписью. </p>
                    
                    <xsl:if test="$pSignature/АФ4:ОсновноеНазвание">
                        Организация: <xsl:value-of select="$pSignature/АФ4:ОсновноеНазвание"/> <br/>    
                    </xsl:if>
                    Сертификат: <xsl:value-of select="$pSignature/АФ4:Идентификатор"/> <br/>
                    Кому выдан: <xsl:if test="$pSignature/АФ4:Владелец/УТ2:Фамилия">
                        <xsl:value-of select="$pSignature/АФ4:Владелец/УТ2:Фамилия"/>&#160;</xsl:if>
                    <xsl:if test="$pSignature/АФ4:Владелец/УТ2:Имя">
                        <xsl:value-of select="$pSignature/АФ4:Владелец/УТ2:Имя"/>&#160;</xsl:if>
                    <xsl:if test="$pSignature/АФ4:Владелец/УТ2:Отчество">
                        <xsl:value-of select="$pSignature/АФ4:Владелец/УТ2:Отчество"/>
                    </xsl:if> <br/>
                    Издатель: <xsl:value-of select="$pSignature/АФ4:Издатель"/> <br/>
                    Действителен: c <xsl:value-of select="concat(substring($dateStartText, 9, 2), '.', substring($dateStartText, 6, 2), '.', substring($dateStartText, 1, 4))"/> по <xsl:value-of select="concat(substring($dateEndText, 9, 2), '.', substring($dateEndText, 6, 2), '.', substring($dateEndText, 1, 4))"/>                
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="afSignature">
                    <p>Документ подписан <br/>
                        усиленной квалифицированной электронной <br/>
                        подписью. </p>
                    Организация: СФР <br/>
                    Сертификат: 7328312D678C14F6909FC6850DBCBC27<br/>
                    Издатель: Федеральное Казначейство<br/>
                    Действителен: с 14.02.2025 по 10.05.2026
                </div>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
</xsl:stylesheet>