<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 sig ns1" version="1.0" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ВЗЛ/АДИ-8/2023-04-03">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:АДИ-8"/>
		<xsl:variable name="vFormD" select="$vForm/ns1:АнкетныеДанные"/>
        <div class="afWrap pfrAfADI8">
			<table class="afTable100">
				<tbody>
					<tr>
						<td class="afTable15 afCenter"><span class="afUnderline">Форма АДИ-8</span></td>
						<td>&#160;</td>
						<td class="afTable15 afCenter">Код по ОКУД </td>
						<td class="afTable15 afTable">&#160;</td>
					</tr>
				</tbody>
			</table>

        	<h1 class="afHeader">Решение об отказе в регистрации зарегистрированного лица</h1>
            <p class="afInterval"/><p class="afInterval"/>
            
			<div class="afRow afCol-4-5">
				<div class="afRow">
					<div class="afC">Страховой номер<br/>индивидуального<br/>лицевого счета </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ7:СНИЛС"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Фамилия </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ7:ФИО/УТ7:Фамилия"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ7:ФИО/УТ7:Имя"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии) </div>
					<div class="afMarginLeft200 afValue afUnderline">
						&#160;<xsl:value-of select="$vFormD/УТ7:ФИО/УТ7:Отчество"/>
					</div>
				</div>
				
				<div class="afRow">
					<div class="afC ">Дата рождения </div>
					<div class="afMarginLeft200 afUnderline">
						<span class="afValue">
							<xsl:choose>
								<xsl:when test="$vFormD/УТ7:ДатаРождения">
									<xsl:call-template name="Date2Text">
										<xsl:with-param name="pDate" select="$vFormD/УТ7:ДатаРождения"/>
									</xsl:call-template> 
								</xsl:when>
								<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая">
									<xsl:choose>
										<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:День">
											"<xsl:value-of select="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:День"/>"&#160;&#160;</xsl:when>
										<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц">
											<xsl:choose>
												<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:День">
													<xsl:choose>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '01' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '1'">января</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '02' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '2'">февраля</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '03' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '3'">марта</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '04' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '4'">апреля</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '05' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '5'">мая</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '06' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '6'">июня</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '07' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '7'">июля</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '08' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '8'">августа</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '09' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '9'">сентября</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '10'">октября</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '11'">ноября</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '12'">декабря</xsl:when>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '01' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '1'">январь</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '02' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '2'">февраль</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '03' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '3'">март</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '04' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '4'">апрель</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '05' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '5'">май</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '06' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '6'">июнь</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '07' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '7'">июль</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '08' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '8'">август</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '09' or $vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '9'">сентябрь</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '10'">октябрь</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '11'">ноябрь</xsl:when>
														<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Месяц = '12'">декабрь</xsl:when>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>	
										<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Год">
											&#160;&#160;<xsl:value-of select="$vFormD/УТ7:ДатаРожденияОсобая/УТ7:Год"/>
										</xsl:when>
										<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
								<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
							</xsl:choose> 
						</span>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Место рождения </div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:call-template name="УТ7:BirthplaceStr">
							<xsl:with-param name="pBirthplace" select="$vFormD/УТ7:МестоРождения"/>
						</xsl:call-template>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Пол </div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:if test="$vFormD/УТ7:Пол[text() = '1']">М</xsl:if>
						<xsl:if test="$vFormD/УТ7:Пол[text() = '2']">Ж</xsl:if>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Причина отказа</div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:value-of select="$vForm/ns1:ПричинаОтказа"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Дата заполнения</div>
					<div class="afMarginLeft200 afUnderline afValue">
						&#160;<xsl:call-template name="Date2Text">
							<xsl:with-param name="pDate" select="$vForm/ns1:ДатаФормирования"/>
						</xsl:call-template>
					</div>
				</div>
			</div>
            <p class="afInterval"/><p class="afInterval"/>
			<p class="afInterval"/><p class="afInterval"/>
			
			<div class="afRow afCol-95">
				<div class="afCol-4-10">Специалист</div>
			</div>
			<div class="afRow afCol-95">
				<div class="afCol-4-10">территориального органа СФР</div>
				<div class="afCol-1-5 afUnderline">&#160;</div>
				<div class="afCol-2">&#160;</div>
				<div class="afCol-1-3 afUnderline">&#160;</div>
			</div>
			<div class="afRow afCol-95">
				<div class="afCol-4-10">&#160;</div>
				<div class="afCol-1-5 afSubscript afItalic afCenterBlock">(подпись)</div>
				<div class="afCol-2">&#160;</div>
				<div class="afCol-1-3 afSubscript afItalic afCenterBlock">(расшифровка подписи)</div>
			</div>
        <p class="afInterval"/><p class="afInterval"/>
		<div class="afNoBreakInside">
			<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
				<xsl:call-template name="PrintSignInfo">
					<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
				</xsl:call-template>
			</xsl:if>
		</div>
		</div>
    </xsl:template>
</xsl:stylesheet>
