<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1 АФ6" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ns1="http://пф.рф/АДИ-РЕГ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:АФ6="http://пф.рф/АФ/2023-01-10">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/ШтампЭП-2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:АДИ-РЕГ"/>
        <div class="afWrap pfrAfADI-REG">
			<p class="afInterval"/><p class="afInterval"/>

			<h1 class="afHeader">Документ,<br/>
подтверждающий регистрацию в системе индивидуального<br/>(персонифицированного) учета «Уведомление о регистрации в системе<br/>индивидуального (персонифицированного) учета (АДИ-РЕГ)»
</h1>
            <p class="afInterval"/><p class="afInterval"/>
            
			<div class="afRow afCol-9-10">
				<div class="afRow">
					<div class="afC">Страховой номер индивидуального<br/>лицевого счета (СНИЛС) </div>
					<div class="afMarginLeft250 afValue afUnderline">
						<br/>&#160;<xsl:value-of select="$vForm/УТ6:СНИЛС"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Фамилия </div>
					<div class="afMarginLeft250 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ6:ФИО/УТ6:Фамилия"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Имя</div>
					<div class="afMarginLeft250 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ6:ФИО/УТ6:Имя"/>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Отчество (при наличии) </div>
					<div class="afMarginLeft250 afValue afUnderline">
						&#160;<xsl:value-of select="$vForm/УТ6:ФИО/УТ6:Отчество"/>
					</div>
				</div>
				
				<div class="afRow">
					<div class="afC ">Дата рождения </div>
					<div class="afMarginLeft250 afUnderline">
						<span class="afValue">
							<xsl:choose>
								<xsl:when test="$vForm/УТ6:ДатаРождения">
									<xsl:call-template name="Date2Text">
										<xsl:with-param name="pDate" select="$vForm/УТ6:ДатаРождения"/>
									</xsl:call-template> 
								</xsl:when>
								<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая">
									<xsl:choose>
										<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:День">
											"<xsl:value-of select="$vForm/УТ6:ДатаРожденияОсобая/УТ6:День"/>"&#160;&#160;</xsl:when>
										<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц">
											<xsl:choose>
												<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:День">
													<xsl:choose>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '01' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '1'">января</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '02' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '2'">февраля</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '03' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '3'">марта</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '04' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '4'">апреля</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '05' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '5'">мая</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '06' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '6'">июня</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '07' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '7'">июля</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '08' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '8'">августа</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '09' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '9'">сентября</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '10'">октября</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '11'">ноября</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '12'">декабря</xsl:when>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '01' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '1'">январь</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '02' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '2'">февраль</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '03' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '3'">март</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '04' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '4'">апрель</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '05' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '5'">май</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '06' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '6'">июнь</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '07' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '7'">июль</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '08' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '8'">август</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '09' or $vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '9'">сентябрь</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '10'">октябрь</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '11'">ноябрь</xsl:when>
														<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Месяц = '12'">декабрь</xsl:when>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>	
										<xsl:otherwise>&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>
									<xsl:choose>
										<xsl:when test="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Год">
											&#160;&#160;<xsl:value-of select="$vForm/УТ6:ДатаРожденияОсобая/УТ6:Год"/>
										</xsl:when>
										<xsl:otherwise>&#160;&#160;&#160;&#160;</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
								<xsl:otherwise>"&#160;&#160;&#160;"&#160;&#160;&#160;&#160;&#160;&#160;</xsl:otherwise>
							</xsl:choose> 
						</span>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Место рождения </div>
					<div class="afMarginLeft250 afUnderline afValue">
						&#160;<xsl:call-template name="УТ6:BirthplaceStr">
							<xsl:with-param name="pBirthplace" select="$vForm/УТ6:МестоРождения"/>
						</xsl:call-template>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Пол </div>
					<div class="afMarginLeft250 afUnderline afValue">
						&#160;<xsl:choose>
								<xsl:when test="$vForm/УТ6:Пол = '1'"> МУЖСКОЙ</xsl:when>
								<xsl:otherwise>ЖЕНСКИЙ</xsl:otherwise>
							</xsl:choose>
					</div>
				</div>
				
				
				<div class="afRow">
					<div class="afC">Дата регистрации в системе<br/>индивидуального <br/>(персонифицированного) учета</div>
					<div class="afMarginLeft250 afUnderline afValue">
						<br/><br/>&#160;<xsl:call-template name="Date2Text">
							<xsl:with-param name="pDate" select="$vForm/ns1:ДатаРегистрации"/>
						</xsl:call-template>
					</div>
				</div>
			</div>
            <p class="afInterval"/><p class="afInterval"/>
			<p class="afInterval"/><p class="afInterval"/>
			<p class="afInterval"/><p class="afInterval"/>
        	<div class="afRow afCol-95">
        		Работник территориального органа СФР*
        	</div>
			<p class="afInterval"/><p class="afInterval"/>
			<xsl:choose>
				<xsl:when test="$vForm/ns1:ДолжностноеЛицо">
					<div class="afRow afCol-95">
						<div class="afCol-2-5 afValue afUnderline afCenterBlock"><xsl:value-of select="$vForm/ns1:ДолжностноеЛицо/УТ6:Должность"/></div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-5 afUnderline">&#160;</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afUnderline afValue afCenterBlock">
							<xsl:call-template name="УТ6:NameStr">
                                <xsl:with-param name="pName" select="$vForm/ns1:ДолжностноеЛицо/УТ6:ФИО"/>
                            </xsl:call-template>
                        </div>
					</div>
					<div class="afRow afCol-95">
						<div class="afCol-2-5 afSubscript afCenterBlock">(должность)</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-5 afSubscript afCenterBlock">(подпись)</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afSubscript afCenterBlock">(расшифровка подписи)</div>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="afRow afCol-95">
						<div class="afCol-4-10">Работник</div>
					</div>
					<div class="afRow afCol-95">
						<div class="afCol-4-10 afUnderline">территориального органа СФР</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-5 afUnderline">&#160;</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afUnderline">&#160;</div>
					</div>
					<div class="afRow afCol-95">
						<div class="afCol-4-10 afSubscript afCenterBlock">(должность)</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-5 afSubscript afCenterBlock">(подпись)</div>
						<div class="afCol-2">&#160;</div>
						<div class="afCol-1-3 afSubscript afCenterBlock">(расшифровка подписи)</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
			<p class="afInterval"/><p class="afInterval"/>
			<div class="afRow afCol-95">
				М.П.*
			</div>
        	<div class="afRow afCol-95">
        		(при наличии)
        	</div>
			<p class="afInterval"/>
        	<div class="afRow afCol-95">
        		--------------------------------
        	</div>
        	<div class="afRow afCol-95">
        		* Заполняется при обращении в территориальный орган СФР 
        	</div>
			<p class="afInterval"/>
			<xsl:choose>
				<xsl:when test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="PrintSignature"/>
				</xsl:otherwise>
			</xsl:choose>

        </div>
    </xsl:template>
</xsl:stylesheet>
