<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ7 ns1" version="1.0" xmlns:УТ7="http://пф.рф/УТ/2023-04-03" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/В-ОГРН-ОП/2023-04-03">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-04-03.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:В-ОГРН-ОП"/>
		<div class="afWrap pfrAfVOGRNOP">
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">ВЫПИСКА<br/>из Единого государственного реестра налогоплательщиков ОП</h1>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afRight-1-3">
					<div class="afC">№</div>
					<p class="afValue afUnderlinedBlock afMarginLeft20">
						<xsl:value-of select="$vForm/ns1:Номер"/>
					</p>
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			
			<div class="afRow">Настоящая выписка содержит сведения об обособленном подразделении</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afValue afUnderlinedBlock afMarginLeft">
					<xsl:value-of select="$vForm/ns1:ОП/УТ7:Наименование"/>
				</div>
				<p class="afSubscript afCenter">(наименование обособленного подразделения российской организации)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<xsl:variable name="OGRN" select="$vForm/ns1:ОГРН"/>
			<div class="afRow afHeader">
				<div class="afC afValue afMarginLeft220">ОГРН</div>
				<p class="afValue  afMarginLeft270">
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 13, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 14, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($OGRN, 15, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">включенные в Единый государственный реестр налогоплательщиков по следующим показателям:</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<table class="afTable afTable100">
				<tr class="afCenter afValue">
					<td class="afTable5">№ п/п</td>
					<td>Наименование показателя</td>
					<td>Значение показателя</td>
				</tr>
				<tr>
					<td>1</td>
					<td class="afValue afLeft" colspan="2">Регистрационные данные</td>
				</tr>
				<tr>
					<td rowspan="9">&#160;</td>
				</tr>
				<tr>
					<td>ОГРН</td>
					<td><xsl:value-of select="$vForm/ns1:ОГРН"/></td>
				</tr>
				<tr>
					<td>ИНН российской организации</td>
					<td><xsl:value-of select="$vForm/УТ7:ИНН"/></td>
				</tr>
				<tr>
					<td>КПП российской организации по месту ее<br/> нахождения</td>
					<td><xsl:value-of select="$vForm/УТ7:КПП"/></td>
				</tr>
				<tr>
					<td>КПП российской организации по месту<br/> нахождения обособленного подразделенияя</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/УТ7:КПП"/></td>
				</tr>
				<tr>
					<td>Наименование обособленного подразделения<br/>российской организации</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/УТ7:Наименование"/></td>
				</tr>
				<tr>
					<td>Вид обособленного подразделения</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:СтатусОП"/></td>
				</tr>
				<tr>
					<td>Дата наделения полномочиями</td>
					<td>
						<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$vForm/ns1:ОП/ns1:ДатаНаделения"/>
					</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Дата утраты полномочий</td>
					<td>
						<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$vForm/ns1:ОП/ns1:ДатаУтраты"/>
					</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>2</td>
					<td class="afValue afLeft" colspan="2">Адрес (место нахождения) обособленного подразделения российской организации</td>
				</tr>
				<tr>
					<td rowspan="10">&#160;</td>
				</tr>
				<tr>
					<td>Почтовый индекс</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Индекс"/></td>
				</tr>
				<tr>
					<td>Код субъекта Российской Федерации</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/ns1:КодРегиона"/></td>
				</tr>
				<tr>
					<td>Район</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Район"/></td>
				</tr>
				<tr>
					<td>Город</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Город"/></td>
				</tr>
				<tr>
					<td>Населенный пункт</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:НаселенныйПункт"/></td>
				</tr>
				<tr>
					<td>Улица</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Улица"/></td>
				</tr>
				<tr>
					<td>Дом</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Дом"/></td>
				</tr>
				<tr>
					<td>Корпус</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Корпус"/></td>
				</tr>
				<tr>
					<td>Квартира</td>
					<td><xsl:value-of select="$vForm/ns1:ОП/ns1:Адрес/УТ7:Квартира"/></td>
				</tr>
				<tr>
					<td>3</td>
					<td class="afValue afLeft" colspan="2">Сведения о постановке на учет в налоговом органе российской организации</td>
				</tr>
				<tr>
					<td rowspan="6">&#160;</td>
				</tr>
				<tr>
					<td>Код налогового органа постановки на учет<br/> российской организации</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчет/ns1:КодФНС"/></td>
				</tr>
				<tr>
					<td>Дата постановки на учет в налоговом органе</td>
					<td>
						<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$vForm/ns1:НалогУчет/ns1:ДатаПостановки"/>
					</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Дата снятия с учета в налоговом органе</td>
					<td>
						<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$vForm/ns1:НалогУчет/ns1:ДатаСнятия"/>
					</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Код причины снятия с учета</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчет/ns1:КодПричины"/></td>
				</tr>
				<tr>
					<td>Наименование причины снятия с учета</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчет/УТ7:Наименование"/></td>
				</tr>
				<tr>
					<td>4</td>
					<td class="afValue afLeft" colspan="2">Сведения о предыдущей постановке на учет в налоговом органе российской организации</td>
				</tr>
				<tr>
					<td rowspan="7">&#160;</td>
				</tr>
				<tr>
					<td>Код налогового органа предыдущей постановки<br/>на учет российской организации по месту<br/>нахождения ее обособленного подразделения</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчетПред/ns1:КодФНС"/></td>
				</tr>
				<tr>
					<td>КПП</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчетПред/УТ7:КПП"/></td>
				</tr>
				<tr>
					<td>Дата постановки на учет в налоговом органе</td>
					<td>
						<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$vForm/ns1:НалогУчетПред/ns1:ДатаПостановки"/>
					</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Дата снятия с учета в налоговом органе</td>
					<td>
						<xsl:call-template name="DateShortStr">
						<xsl:with-param name="pDate" select="$vForm/ns1:НалогУчетПред/ns1:ДатаСнятия"/>
					</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td>Код причины снятия с учета</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчетПред/ns1:КодПричины"/></td>
				</tr>
				<tr>
					<td>Наименование причины снятия с учета</td>
					<td><xsl:value-of select="$vForm/ns1:НалогУчетПред/УТ7:Наименование"/></td>
				</tr>
			</table>
		</div>
	</xsl:template>
</xsl:stylesheet>
