<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10"
                xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ns1="http://пф.рф/ИЛАУСН/2023-01-10">
    <xsl:output method="html" indent="yes" encoding="utf-8"/>
    <xsl:include href="../../Общие/Базовые.xsl"/>
    <xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
    <xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
    <xsl:template match="/" name="inc">
        <xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ИЛАУСН"/>
        <div class="afWrap pfrAfILAUSN">
            <div class="afRight-1-2 afRight">
                Приложение № 4
                <br/>
                к Порядку регистрации и снятия с учета
                <br/>
                страхователей в Фонде пенсионного и социального
                <br/>
                страхования Российской Федерации,
                <br/>
                утвержденному приказом Министерства
                <br/>
                труда и социальной защиты
                <br/>
                Российской Федерации
                <br/>
                от 7 декабря 2022 г. № 768н
            </div>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <h1 class="afHeader">ИНФОРМАЦИОННЫЙ ЛИСТОК</h1>
            <p class="afInterval"/>
            <p class="afInterval"/>
            <div class="afRow">
                <div class="afC afParagraph">На основании сведений ФНС России</div>
                <p class="afValue afUnderlinedBlock afMarginLeft300">
                    <xsl:if test="$vForm/ns1:ЮЛ"></xsl:if>
                    <xsl:if test="$vForm/ns1:ЮЛ">
                        <xsl:value-of select="$vForm/ns1:ЮЛ"/>&#160;
                    </xsl:if>
                </p>

                <p class="afSubscript afMarginLeft300">(наименование юридического лица/</p>
            </div>
            <div class="afRow">
                <p class="afValue afBlankUnderlinedBlock">
                    <xsl:if test="$vForm/ns1:ИП">
                        <xsl:call-template name="УТ6:NameStr">
                            <xsl:with-param name="pName" select="$vForm/ns1:ИП"/>
                        </xsl:call-template>&#160;
                    </xsl:if>
                </p>
                <p class="afSubscript afCenter">фамилия, имя, отчество (при наличии) индивидуального предпринимателя)
                </p>
            </div>
            <p class="afInterval"/>
            <xsl:variable name="OGRN" select="$vForm/ns1:ОГРН"/>
            <div class="afRow">
                <div class="afC">ОГРН (ОГРНИП)</div>
                <div class="afValue  afMarginLeft450">
                    <div class="afCol-3-10">
                        <table class="afTableCollapse">
                            <tr>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 1, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 2, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 3, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 4, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 5, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 6, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 7, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 8, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 9, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 10, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 11, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 12, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 13, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 14, 1)"/>
                                </td>
                                <td class="afCheckSmall">
                                    <xsl:value-of select="substring($OGRN, 15, 1)"/>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <xsl:variable name="NumINN" select="$vForm/УТ6:ИНН"/>
            <xsl:variable name="NumKPP" select="$vForm/УТ6:КПП"/>
            <div class="afRow">
                <div class="afCol-1-5 afCenterBlock">ИНН</div>
                <div class="afValue afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 1, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 2, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 3, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 4, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 5, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 6, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 7, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 8, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 9, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 10, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 11, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumINN, 12, 1)"/>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="afCol-1-5 afCenterBlock">КПП</div>
                <div class="afValue afCol-3-10">
                    <table class="afTableCollapse">
                        <tr>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 1, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 2, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 3, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 4, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 5, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 6, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 7, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 8, 1)"/>
                            </td>
                            <td class="afCheckSmall">
                                <xsl:value-of select="substring($NumKPP, 9, 1)"/>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div class="afRow">
                <div class="afC">Регистрационный номер</div>
                <div class="afValue afUnderlinedBlock afMarginLeft450">
                    <xsl:value-of select="$vForm/УТ6:РегНомер"/>
                </div>
            </div>
            <div class="afRow afJustify">
                применяет специальный налоговый режим «Автоматизированная упрощенная система<br/>налогообложения» с
                <span class="afValue afUnderline">
                    <xsl:call-template name="DateShortStr">
                        <xsl:with-param name="pDate" select="$vForm/ns1:ДатаНачала"/>
                    </xsl:call-template>
                    .
                </span>
            </div>
            <div class="afC afParagraph">На основании пунктов 2<sup>2</sup>, 4 и 4<sup>1</sup> статьи 22, пункта 1<sup>
                6
            </sup> статьи 24 Федерального закона от 24.07.1998 № 125-ФЗ «Об обязательном социальном страховании от
                несчастных случаев на производстве и профессиональных заболеваний» страхователи, применяющие специальный
                налоговый режим «Автоматизированная упрощенная система налогообложения»:
            </div>
            <div class="afC afParagraph">- уплачивают страховые взносы на обязательное социальное страхование от
                несчастных случаев на производстве и профессиональных заболеваний в фиксированном размере
                <span class="afValue afUnderline">
                    <xsl:value-of select="$vForm/ns1:РазмерСтрахВзноса"/>
                </span>
                рублей в год.
            </div>
            <div class="afC afParagraph">- уплачивают страховые взносы на обязательное социальное страхование от
                несчастных случаев на производстве и профессиональных заболеваний ежемесячно в размере 1/12
                фиксированного страхового взноса в срок не позднее 15-го числа календарного месяца, следующего за
                календарным месяцем, за который начисляются страховые взносы;
            </div>
            <div class="afC afParagraph">- освобождаются от обязанности по представлению сведений о начисленных
                страховых взносах на обязательное социальное страхование от несчастных случаев на производстве и
                профессиональных заболеваний.
            </div>
            <div class="afC afParagraph">Уплата страховых взносов осуществляется ежемесячно на счет:</div>
            <div class="afRow">
                <p class="afValue afCenter afUnderlinedBlock">
                    <xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
                </p>
                <p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального
                    страхования Российской Федерации)
                </p>
            </div>
            <div class="afRow">
                <p class="afValue afUnderlinedBlock afMarginLeft5">
                    Наименование получателя:
                    <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:НаименованиеПолучателя"/>, ИНН:
                    <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:ИНН"/>, КПП: <xsl:value-of
                        select="$vForm/ns1:РеквизитыПеречисления/УТ6:КПП"/>,
                </p>
                <p class="afValue afCenter afUnderlinedBlock">Казначейский счёт: <xsl:value-of
                        select="$vForm/ns1:РеквизитыПеречисления/ns1:КазначескийСчет"/>, БИК: <xsl:value-of
                        select="$vForm/ns1:РеквизитыПеречисления/УТ6:БИК"/>, ЕКС: <xsl:value-of
                        select="$vForm/ns1:РеквизитыПеречисления/ns1:ЕКС"/>,
                </p>
                <p class="afValue afUnderlinedBlock afMarginLeft5">КБК: <xsl:value-of
                        select="$vForm/ns1:РеквизитыПеречисления/ns1:КБК"/>, ОКТМО: <xsl:value-of
                        select="$vForm/ns1:РеквизитыПеречисления/УТ6:ОКТМО"/>, Наименование банка:
                    <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:НаименованиеБанка"/>
                </p>
                <p class="afSubscript afCenter">(реквизиты для перечисления страховых взносов)</p>
            </div>
            <div class="afRow">
                <div class="afC">Дата формирования Информационного листка</div>
                <div class="afCol-1-3 afValue afUnderlinedBlock">
                    <xsl:call-template name="DateShortStr">
                        <xsl:with-param name="pDate" select="$vForm/ns1:ДатаФормирования"/>
                    </xsl:call-template>
                </div>
            </div>
            <div class="afRow">
                <div class="afC">Дата направления Информационного листка</div>
                <div class="afCol-1-3 afValue afUnderlinedBlock">
                    <xsl:call-template name="DateShortStr">
                        <xsl:with-param name="pDate" select="$vForm/ns1:ДатаНаправления"/>
                    </xsl:call-template>
                </div>
            </div>
            <div class="afNoBreakInside">
                <xsl:if test="ns1:ЭДСФР/sig:SignInfo">
                    <xsl:call-template name="PrintSignInfo">
                        <xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
                    </xsl:call-template>
                </xsl:if>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
