<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ИЛДСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ИЛДСС"/>
		<div class="afWrap pfrAfILDSS">			
			<h1 class="afHeader">ИНФОРМАЦИОННЫЙ ЛИСТОК<br/> для лиц, добровольно вступивших<br/> в правоотношения по обязательному социальному<br/> страхованию на случай временной нетрудоспособности<br/>  и в связи с материнством</h1>
			<p class="afInterval"/>
			<div class="afC afParagraph">	
В целях приобретения права на получение страхового обеспечения по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством в <span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:Год"/></span> 
году необходимо уплатить страховые взносы в размере
  <span class="afValue">
					<xsl:call-template name="Sum2RubKop">
						<xsl:with-param name="pSum" select="$vForm/ns1:Сумма"/>
					</xsl:call-template>,
                </span> до 31 декабря
<span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:ГодПодачи"/></span> года.
  </div>	
		<div class="afC afParagraph">		
			МРОТ <span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:МРОТ"/></span> руб.
		</div>	
			<div class="afC afParagraph">		
			Районный коэффициент <span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:РайонКоэффициент"/></span> 
		</div>		
			<div class="afC afParagraph">		
			Регистрационный номер <span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:РегНомер"/></span> 
		</div>		
			<p class="afInterval"/>
			<div class="afRow">
			Реквизиты для уплаты страховых взносов
			</div>			
			<div class="afRow">
				<div class="afC">Получатель</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:НаименованиеПолучателя"/>
				</p>				
			</div>
				<div class="afRow">
				<div class="afC">ИНН</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:ИНН"/>
				</p>				
			</div>
				<div class="afRow">
				<div class="afC">КПП</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					<xsl:for-each select="$vForm/ns1:РеквизитыПеречисления/УТ6:КПП">
						<xsl:value-of select="."/>&#160;
                       </xsl:for-each>		
				</p>			</div>
				<div class="afRow">
				<div class="afC">Казначейский счет</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:КазначескийСчет"/>
				</p>				
			</div>
				<div class="afRow">
				<div class="afC">ЕКС</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:ЕКС"/>
				</p>				
			</div>				
				<div class="afRow">
				<div class="afC">БИК</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:БИК"/>
				</p>				
			</div>
				<div class="afRow">
				<div class="afC">ОКТМО</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:ОКТМО"/>
				</p>				
			</div>
				<div class="afRow">
				<div class="afC">Банк уплаты страховых взносов </div>
				<p class="afValue afUnderlinedBlock afMarginLeft200">
					<xsl:for-each select="$vForm/ns1:РеквизитыПеречисления/ns1:НаименованиеБанка">
						<xsl:value-of select="."/>&#160;
                       </xsl:for-each>		
				</p>				
			</div>
				<div class="afRow">
				<div class="afC">КБК</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					 <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:КБК"/>
				</p>				
			</div>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>					
	</xsl:template>
</xsl:stylesheet>
