<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ПРТКЛОШ/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ПРТКЛОШ"/>
		<div class="afWrap pfrAfPRTKLOSH">
			<h1 class="afHeader">ПРОТОКОЛ ОШИБКИ</h1>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Тип предоставленных сведений:</div>
				<div class="afC afValue">
					<xsl:value-of select="$vForm/ns1:ТипСведений"/>
				</div>
			</div>
			<div class="afC">Дата приема:</div>
			<div class="afC afValue">
				<xsl:call-template name="Date2GOST">
					<xsl:with-param name="pDate">
						<xsl:value-of select="$vForm/ns1:ДатаПриема"/>
					</xsl:with-param>
				</xsl:call-template>
			</div>
			<div class="afRow">
				<div class="afC">Имя обрабатываемого файла:</div>
				<div class="afC afValue">
					<xsl:value-of select="$vForm/ns1:ИмяФайла"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Идентификатор файла/документа/запроса:</div>
				<div class="afC afValue">
					<xsl:value-of select="$vForm/ns1:ИДФайла"/>
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<xsl:if test="$vForm/ns1:ТипСведений='Выписка'">
				<div class="afCenter afValue">Основные сведения</div>
				<p class="afInterval"/>
				<xsl:choose>
					<xsl:when test="$vForm/ns1:ОсновныеСведения/ns1:ЮЛ">
						<div class="afRow">
							<div class="afC">Полное наименование:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ЮЛ/ns1:ПолноеНаименование"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ИНН:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ЮЛ/УТ6:ИНН"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">КПП:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ЮЛ/УТ6:КПП"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ОГРН:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ЮЛ/ns1:ОГРН"/>
							</div>
						</div>
					</xsl:when>
					<xsl:when test="$vForm/ns1:ОсновныеСведения/ns1:ИП">
						<div class="afRow">
							<div class="afC">ФИО:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ИП/ns1:ФИО"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ИНН:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ИП/ns1:ИНН"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ОГРНИП:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ИП/ns1:ОГРН"/>
							</div>
						</div>
					</xsl:when>
					<xsl:when test="$vForm/ns1:ОсновныеСведения/ns1:ОП">
						<div class="afRow">
							<div class="afC">Наименование:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ОП/ns1:ПолноеНаименование"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ИНН:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ОП/УТ6:ИНН"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">КПП ОП:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ОП/УТ6:КПП"/>
							</div>
						</div>
					</xsl:when>
					<xsl:when test="$vForm/ns1:ОсновныеСведения/ns1:ИО">
						<div class="afRow">
							<div class="afC">Полное наименование:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ИО/ns1:ПолноеНаименование"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ИНН:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ИО/УТ6:ИНН"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">КПП:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ИО/УТ6:КПП"/>
							</div>
						</div>
					</xsl:when>
					<xsl:when test="$vForm/ns1:ОсновныеСведения/ns1:ФЛ">
						<div class="afRow">
							<div class="afC">ФИО:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ФЛ/ns1:ФИО"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">Тип физического лица:</div>
							<div class="afValue afMarginLeft100">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ФЛ/ns1:ТипФЛ/ns1:КодТипаФЛ"/>&#160;
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ФЛ/ns1:ТипФЛ/ns1:НаименованиеТипаФЛ"/>
							</div>
						</div>
						<div class="afRow">
							<div class="afC">ИНН:</div>
							<div class="afC afValue">
								<xsl:value-of select="$vForm/ns1:ОсновныеСведения/ns1:ФЛ/ns1:ИНН"/>
							</div>
						</div>
					</xsl:when>
				</xsl:choose>
				<p class="afInterval"/>
				<p class="afInterval"/></xsl:if>
			<div class="afCenter afValue">Сведения об ошибке</div>
			<xsl:if test="$vForm/ns1:Ошибка">
				<xsl:for-each select="$vForm/ns1:Ошибка">
					<div class="afRow">
						<p class="afMarginLeft5 ">
							<xsl:value-of select="position()"/>.&#160;Тип ошибки: &#160; <b>
							<xsl:value-of select="./ns1:Тип"/>
						</b>
						</p>
						<p class="afMarginLeft5 ">
							Текст ошибки:
							<b>
								<xsl:value-of select="./ns1:Текст"/>
							</b>
						</p>
					</div>
				</xsl:for-each>
			</xsl:if>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>