<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/УСТОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:УСТОСС"/>
		<div class="afWrap pfrAfUSTOSS">
			<p class="afInterval"/>
			<div class="afRight-1-2 afRight">
				Приложение № 1 <br/>
				к Порядку регистрации и снятия<br/>
				с учета страхователей в Фонде<br/>
				пенсионного и социального<br/>
				страхования Российской Федерации,<br/>
				утвержденному приказом<br/>
				Министерства труда и социальной<br/>
				защиты Российской Федерации<br/>
                от 7 декабря 2022 г. № 768н
			</div>
			<p class="afInterval"/>
			<div class="afRight">форма</div>
					
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">УВЕДОМЛЕНИЕ<br/>о страховом тарифе на обязательное социальное страхование<br/>от несчастных случаев на производстве<br/>и профессиональных заболеваний</h1>
			<p class="afInterval"/>
			
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
			</p>
			<p class="afValue afCenter afUnderlinedBlock"/>
			<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			
			<p class="afValue afMarginLeft450 afUnderlinedBlock">
				&#160;
			</p>
			<p class="afSubscript afCenter afMarginLeft450">(код территориального органа Фонда)</p>
			<div class="afC">уведомляет, что страхователю</div>
			
				<p class="afValue afCenter afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ДанныеСтрахователя/ns1:Наименование"/>
			</p>
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ДанныеСтрахователя/УТ6:ФИО"/>
			</p>
			<p class="afSubscript afCenter">(полное наименование юридического лица/фамилия, имя, отчество (при наличии) физического лица)</p>
			<p class="afInterval"/>
				<div class="afC">по месту нахождения обособленного подразделения</div>
			<p class="afValue afCenter afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:Страхователь/ns1:ДанныеСтрахователя/ns1:НаименованиеОП"/>
			</p>
			<p class="afSubscript afCenter">(наименование обособленного подразделения (при наличии))</p>
			<p class="afInterval"/>
			<p class="afInterval"/>
				<div class="afRow">
				<div class="afC">Регистрационный номер</div>
				<div class="afValue afUnderlinedBlock afMarginLeft450">
					<xsl:value-of select="$vForm/ns1:Страхователь/ns1:РегНомер"/>
				</div>
			</div>

				<div class="afC afCenter">
				в соответствии с заявленным основным видом экономической деятельности</div>
				<div class="afRow">
				<p class="afValue afUnderlinedBlock afCenter">
				<xsl:value-of select="$vForm/ns1:ОсновнойВидДеятельности/УТ6:КодПоОКВЭД"/>&#160;-&#160;
				 <xsl:value-of select="$vForm/ns1:ОсновнойВидДеятельности/УТ6:Наименование"/>
								</p>	
				<p class="afValue afCenter afUnderlinedBlock"/>
				
			</div>			
				<div class="afC afParagraph">
				определен   
				<span class="afValue afUnderline">
				 <xsl:value-of select="$vForm/ns1:КлассПрофРиска"/></span> 
				 класс профессионального риска, что соответствует страховому  тарифу  на  обязательное социальное страхование от несчастных случаев  на  производстве и  профессиональных заболеваний в размере <span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:ТарифПроцентаРазмера"/></span> процентов к суммам выплат и иных вознаграждений, которые начислены в пользу застрахованных в рамках трудовых отношений и гражданско-правовых договоров, предметом  которых  являются  выполнение работ и (или) оказание услуг, договора авторского заказа,  если  в соответствии с указанными договорами заказчик обязан уплачивать страховщику  страховые взносы, и включаются в базу для начисления страховых взносов  на  обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний.</div>
				 <div class="afC afParagraph">
Страхователь, являющийся государственным (муниципальным) учреждением, относится к 1 классу профессионального риска в части деятельности, которая финансируется из бюджетов  всех уровней и приравненных к ним источников, что соответствует страховому тарифу на обязательное социальное страхование от несчастных случаев на производстве  и  профессиональных заболеваний в размере 0,2 процента к суммам выплат и иных вознаграждений, которые начислены в пользу застрахованных в рамках трудовых отношений и гражданско-правовых договоров, предметом которых являются выполнение работ и (или) оказание услуг, договора авторского заказа, если в соответствии с указанными договорами заказчик обязан уплачивать страховщику страховые взносы, и включаются в базу для начисления страховых взносов на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний.</div>	
				<div class="afC afParagraph">	
Размер страхового тарифа на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний с
 <span class="afValue afUnderline">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '01' or $vForm/ns1:ДатаНачала/ns1:Месяц = '1'">января</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '02' or $vForm/ns1:ДатаНачала/ns1:Месяц = '2'">февраля</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '03' or $vForm/ns1:ДатаНачала/ns1:Месяц = '3'">марта</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '04' or $vForm/ns1:ДатаНачала/ns1:Месяц = '4'">апреля</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '05' or $vForm/ns1:ДатаНачала/ns1:Месяц = '5'">мая</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '06' or $vForm/ns1:ДатаНачала/ns1:Месяц = '6'">июня</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '07' or $vForm/ns1:ДатаНачала/ns1:Месяц = '7'">июля</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '08' or $vForm/ns1:ДатаНачала/ns1:Месяц = '8'">августа</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '09' or $vForm/ns1:ДатаНачала/ns1:Месяц = '9'">сентября</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '10'">октября</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '11'">ноября</xsl:when>
						<xsl:when test="$vForm/ns1:ДатаНачала/ns1:Месяц = '12'">декабря</xsl:when>						
					</xsl:choose> &#160; 
					<xsl:value-of select="$vForm/ns1:ДатаНачала/ns1:Год"/> </span>
						
					года составляет <span class="afValue afUnderline"> <xsl:value-of select="$vForm/ns1:ПроцентРазмера"/></span> 
					процентов к суммам выплат и иных
			<p class="afSubscript afMarginLeft200">(месяц, год)</p>	
					</div>
				<div class="afRow">	
вознаграждений, которые начислены в пользу застрахованных в рамках трудовых отношений и гражданско-правовых договоров, предметом которых являются выполнение работ и (или) оказание услуг, договора авторского заказа, и включаются в базу для начисления страховых взносов на  обязательное социальное страхование от несчастных случаев  на производстве и профессиональных заболеваний.</div>	
	<div class="afC afParagraph ">Уплата страховых взносов осуществляется ежемесячно на счет </div>	
		<div class="afRow">
				<p class="afValue afCenter afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
			</p>
			<p class="afValue afCenter afUnderlinedBlock"/>
			<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>	
				
				<p class="afInterval"/>				
	<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
				Наименование получателя:
				<xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:НаименованиеПолучателя"/>, ИНН: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:ИНН"/>, КПП: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:КПП"/>, </p>
					<p class="afValue afCenter afUnderlinedBlock">Казначейский счёт: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:КазначескийСчет"/>, БИК: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:БИК"/>,  ЕКС: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:ЕКС"/>, </p>
					<p class="afValue afUnderlinedBlock afMarginLeft5">КБК: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/ns1:КБК"/>, ОКТМО: <xsl:value-of select="$vForm/ns1:РеквизитыПеречисления/УТ6:ОКТМО"/></p>
				<p class="afSubscript afCenter">(реквизиты для перечисления страховых взносов)</p>
			</div>
			<div class="afC afParagraph ">В соответствии со статьей 24 Федерального закона от 24 июля 1998 г. № 125-ФЗ «Об  обязательном социальном страховании от несчастных случаев на производстве и профессиональных заболеваний»<sup>1</sup> страхователь ежеквартально представляет по месту регистрации в</div>	
				<div class="afRow">
				<p class="afValue afCenter afUnderlinedBlock">
				<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
			</p>
			<p class="afValue afCenter afUnderlinedBlock"/>
			<p class="afSubscript afCenter">(наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>	
	        <div class="afRow">
				<p class="afValue afCenter afUnderlinedBlock">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:ТОСФР/ns1:Адрес/УТ6:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:ТОСФР/ns1:Адрес/УТ6:Неструктурированный"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:ТОСФР/ns1:Адрес">
							<xsl:call-template name="УТ6:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:ТОСФР/ns1:Адрес"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
			</p>
			<p class="afValue afCenter afUnderlinedBlock"/>
			<p class="afSubscript afCenter">(адрес территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>		
		<div class="afRow">	
			сведения о начисленных страховых взносах на обязательное социальное страхование от несчастных случаев на производстве и профессиональных заболеваний (раздел 2 формы ЕФС-1).		
			</div>	
			<p class="afInterval"/>
			<p class="afInterval"/>
				<div class="afCol-1-10-1 afMarginLeft5"></div>
					<div class="afNoBreakInside">				
				<p class="afInterval"/>
				
				<div class="afC">Дата выдачи (направления) уведомления </div>
				<div class="afValue afUnderlinedBlock afCol-1-4">
					<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>
				</div>
				<p class="afSubscript afCenter afMarginLeft30">(число, месяц, год)</p>
				<p class="afInterval"/>
				
				<div class="afRow ">
				<div class="afC afMarginLeft">
					<div>
					<br/>Уполномоченное должностное лицо<br/>территориального органа Фонда<br/>пенсионного и социального страхования<br/>Российской Федерации</div>
				</div>
				<div class="afCol-1-4">
					<br/>
					<br/>
					<br/>
					<br/>
					<div class="afValue afUnderlinedBlock">						
					</div>
					<p class="afSubscript afCenter">(подпись)</p>
				</div>
				<div class="afCol-1-10">&#160;</div>
				<div class="afCol-1-3">
					<br/>
					<div class="afValue afUnderlinedBlock afCenter">
						<br/>
						<br/>
						<br/>
						
						<xsl:call-template name="УТ6:NameStrShort">
							<xsl:with-param name="pName" select="$vForm/ns1:ДолжностноеЛицо/УТ6:ФИО"/>
							<xsl:with-param name="pInitialFirst" select="1"/>
						</xsl:call-template>
					</div>
					<p class="afSubscript afCenter">(фамилия, имя, отчество (при наличии)</p>
				</div>
			</div>
				
			</div>			
			   <div class="afRow"><div class="afC"> М.П.</div></div>
			  
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
			
			
			
			
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 <p class="afInterval"/>
			 
			<p>_____________________________________________</p>
			<p class="afFootnote">
                <sup>1</sup> Собрание законодательства Российской Федерации, 1998, № 31, ст. 3803; 2022, № 29, ст. 5204</p>	
		</div>					
	</xsl:template>
</xsl:stylesheet>



