<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ8 sig ns1" version="1.0" xmlns:УТ8="http://пф.рф/УТ/2025-01-01" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ВС/ЗПДОСС/2025-05-01">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2025-01-01.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ЗПДОСС"/>
		<div class="afWrap sfrAfZPDOSS">
			
			<p class="afInterval"/><p class="afInterval"/>
			<div class="afRow">
				<div class="afC">В</div>
				<p class="afValue afUnderlinedBlock afMarginLeft30">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ8:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(Наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<p class="afInterval"/>
			<h1 class="afHeader">ЗАЯВЛЕНИЕ<br/>о прекращении добровольных правоотношений по обязательному социальному<br/>страхованию на случай временной нетрудоспособности</h1>
			<p class="afInterval"/>
			
			
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-3">
					<p class="afUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ8:ФИО/УТ8:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-1-3">
					<p class="afUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ8:ФИО/УТ8:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-1-3">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Заявитель/УТ8:ФИО/УТ8:Отчество">
							<p class="afUnderlinedBlock afValue">
								<xsl:value-of select="$vForm/ns1:Заявитель/УТ8:ФИО/УТ8:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afC">Дата рождения</div>
					<div class="afCol-2-3">
						<div class="afUnderlinedBlock afValue">
							<xsl:choose>
								<xsl:when test="$vForm/ns1:Заявитель/УТ8:ДатаРождения">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="$vForm/ns1:Заявитель/УТ8:ДатаРождения"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="УТ8:DateSpecialStr">
										<xsl:with-param name="pDate" select="$vForm/ns1:Заявитель/УТ8:ДатаРожденияОсобая"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<p class="afSubscript afCenter">(число, месяц, год)</p>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-2">
					<div class="afC">Страховой номер индивидуального лицевого счета застрахованного лица (СНИЛС)</div>
				</div>
				<div class="afCol-1-2">
					<div class="afValue afMarginLeft100">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:Заявитель/УТ8:СНИЛС">
								<xsl:variable name="snils" select="$vForm/ns1:Заявитель/УТ8:СНИЛС"/>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 1, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 2, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 3, 1)"/>&#160;
								</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 5, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 6, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 7, 1)"/>&#160;
								</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 9, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 10, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 11, 1)"/>&#160;
								</div>
								<div class="afFloatLeft">&#160;&#160;&#160;</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 13, 1)"/>&#160;
								</div>
								<div class="afFrame">
									&#160;<xsl:value-of select="substring($snils, 14, 1)"/>&#160;
								</div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;-&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFloatLeft">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
								<div class="afFrame">&#160;&#160;&#160;</div>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Идентификационный номер налогоплательщика (ИНН)</div>
				<p class="afUnderlinedBlock afValue afMarginLeft350">
					<xsl:value-of select="$vForm/ns1:Заявитель/УТ8:ИНН"/>
				</p>
			</div>
			
			<div class="afRow">
				<div class="afC">Адрес</div>
				<div class="afMarginLeft70 afUnderlinedBlock"/>
			</div>
			<div class="afRow">
				<div class="afUnderlinedBlock afValue">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Заявитель/ns1:Адрес/УТ8:Неструктурированный">
							<xsl:value-of select="$vForm/ns1:Заявитель/ns1:Адрес/УТ8:Неструктурированный"/>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Заявитель/ns1:Адрес/УТ8:Иностранный">
							<xsl:call-template name="AddressForeignStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Заявитель/ns1:Адрес/УТ8:Иностранный"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$vForm/ns1:Заявитель/ns1:Адрес">
							<xsl:call-template name="УТ8:AddressStr">
								<xsl:with-param name="pAddress" select="$vForm/ns1:Заявитель/ns1:Адрес"/>
								<xsl:with-param name="pType" select="1"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							&#160;
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>

			<div class="afRow">
				<div class="afC">Регистрационный номер страхователя</div>
				<p class="afValue afUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:Заявитель/УТ8:РегНомер">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ8:РегНомер"/>&#160;</xsl:if>
				</p>
			</div>
			
			
			
			<div class="afRow">
				<div class="afC afParagraph afJustify">Прошу снять меня с учета в качестве страхователя и уведомление о прекращении правоотношений по обязательному социальному страхованию на случай временной нетрудоспособности:</div>
			</div>
			<div class="afRow50">
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '5'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-9-10">
					<p>направить в форме электронного документа (при направлении заявления через Единый портал)</p>
				</div>
			</div>
			<div class="afRow50">
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '6'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-7-10"><p>вручить в территориальном органе Фонда</p></div>
			</div>
			<div class="afRow50">
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '7'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-7-10"><p>направить почтовым отправлением по адресу места жительства</p></div>
			</div>
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afC afParagraph">Достоверность и полноту сведений, указанных в настоящем заявлении, подтверждаю.</div>
			
			</div>
			<p class="afInterval"/>

			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-4-10">
					<div class="afC">Подпись заявителя</div>
					<p class="afBlankUnderlinedBlock afMarginLeft140"/>
				</div>
				
				<div class="afRight-1-3 ">
					<div class="afC">Дата</div>
					<p class="afValue afUnderlinedBlock afMarginLeft50">
						<xsl:call-template name="Date2Text">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ДатаПодачи"/>
							</xsl:with-param>
						</xsl:call-template>
					</p>
					<p class="afCenter afSubscript afMarginLeft50">(число, месяц, год)</p>
				</div>
			</div>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
