<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ВС/ЗРОПОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ЗРОПОСС"/>
		<div class="afWrap pfrAfZROPOSS">
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRight-1-3 ">
				<div class="afValue afUnderlinedBlock">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:ДатаПодачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</div>
				<p class="afCenter afSubscript">(число) (месяц (прописью) (год)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">В</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(Наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">ЗАЯВЛЕНИЕ<br/>о регистрации в качестве страхователя юридического лица по месту нахождения обособленного подразделения</h1>
			<p class="afInterval"/>
			<div class="afRow afCenter">Сведения о юридическом лице</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">1.</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(Полное наименование юридического лица)</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">2.</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:НаименованиеКраткое"/>
				</p>
				<p class="afSubscript afCenter">(Сокращенное наименование юридического лица) (при наличии)</p>
			</div>
			<div class="afInterval"/><div class="afInterval"/>
			
			<div class="afRow">
				<div class="afC">3. Адрес места нахождения:</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable20 afCenter">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:ГоловнаяОрганизация/УТ6:ОКТМО">
								<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:ОКТМО"/>
							</xsl:when>
							<xsl:when test="$vForm/ns1:ГоловнаяОрганизация/УТ6:ОКАТО">
								<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:ОКАТО"/>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
					<td class="afValue afTable20 afCenter">
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Индекс">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Индекс"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable60 afCenter">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Регион">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Регион/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Регион/УТ6:Название"/>&#160;</xsl:if>						
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-1-5">
					<p class="afCenter afSubscript">(Код по ОКТМО (ОКАТО))</p>
				</div>
				<div class="afCol-1-5">
					<p class="afCenter  afSubscript">(Почтовый индекс)</p>
				</div>
				<div class="afCol-6-10">
					<p class="afCenter  afSubscript">(Субъект Российской Федерации)</p>
				</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable30 afCenter">
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Район">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Район/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Район/УТ6:Название"/>&#160;</xsl:if>						
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Город">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Город/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Город/УТ6:Название"/>&#160;</xsl:if>
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:НаселенныйПункт">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Название"/></xsl:if>&#160;	
					</td>
					<td class="afValue afTable40 afCenter">
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Улица">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Улица/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Улица/УТ6:Название"/></xsl:if>&#160;
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Дом">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Дом"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Корпус">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Корпус"/>
							<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Строение or $vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Строение">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Строение"/>
							<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Владение">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Владение"/>&#160;
						</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Квартира">
							<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Адрес/УТ6:Квартира"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afCenter  afSubscript">(Город, поселок, иной населенный пункт)</p>
				</div>
				<div class="afCol-4-10">
					<p class="afCenter  afSubscript">(Улица/переулок/проспект)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Дом)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Корпус)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Квартира)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Адрес электронной почты</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:АдресЭлПочты">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:АдресЭлПочты"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
		
			<p class="afInterval"/>
			
			<div class="afRow">
				<div class="afC">4. Сведения о государственной регистрации:</div>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:СведОГосРегистрации">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:СведОГосРегистрации/ns1:НаименованиеОргана"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afSubscript">(Наименование органа, осуществившего государственную регистрацию)</p>
			</div>
			<div class="afRow">
				<div class="afC">основной государственный регистрационный номер (ОГРН)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft380">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:КодЕГРЮЛ">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:КодЕГРЮЛ"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">дата государственной регистрации</div>
				<p class="afValue afUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:СведОГосРегистрации">
						<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:СведОГосРегистрации/ns1:ДатаРегистрации"/>
							</xsl:with-param>
						</xsl:call-template>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/><p class="afInterval"/>
			<div class="afRow">
				<div class="afC">5. Организационно-правовая форма</div>
				<p class="afValue afUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:Форма">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:Форма"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Код по КОПФ</div>
				<p class="afValue afUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:КодКОПФ">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:КодКОПФ"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft100 afSubscript">(Классификатор организационно-правовых форм)</p>
			</div>
			<div class="afRow">
				<div class="afC">6. Форма собственности</div>
				<p class="afValue afUnderlinedBlock afMarginLeft220">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:ФормаСобственности">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:ФормаСобственности/УТ6:Наименование"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Код по ОКФС</div>
				<p class="afValue afUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:ФормаСобственности/ns1:КодОКФС">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:ФормаСобственности/ns1:КодОКФС"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft100 afSubscript">(Общероссийский классификатор форм собственности)</p>
			</div>
			
			
			<div class="afRow">
				<div class="afC">7. Основной вид деятельности</div>
				<p class="afValue afUnderlinedBlock afMarginLeft200">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:ОсновнойВидДеятельности">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:ОсновнойВидДеятельности/УТ6:Наименование"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Код по ОКВЭД2</div>
				<p class="afValue afUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:ОсновнойВидДеятельности">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:ОсновнойВидДеятельности/УТ6:КодПоОКВЭД"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft100 afSubscript">(Общероссийский классификатор видов экономической деятельности; указывается цифровой код не менее четырех знаков)</p>
			</div>
			<div class="afRow">
				<div class="afC">8. Другие осуществляемые виды деятельности:</div>
			</div>
			<xsl:choose>
				<xsl:when test="$vForm/ns1:ГоловнаяОрганизация/ns1:ДругиеВидыДеятельности">
					<xsl:for-each select="$vForm/ns1:ГоловнаяОрганизация/ns1:ДругиеВидыДеятельности/ns1:ВидДеятельности">
						<div class="afRow">
							<div class="afCol-1-2">
								<p class="afValue afUnderlinedBlock">
									<xsl:value-of select="УТ6:Наименование"/>
								</p>
							</div>
							<div class="afC">Код ОКВЭД2</div>
							<div class="afCol-1-3">
								<p class="afValue afUnderlinedBlock">
									<xsl:value-of select="УТ6:КодПоОКВЭД"/>
								</p>
							</div>
						</div>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<div class="afRow">
						<div class="afCol-1-2">
							<p class="afValue afUnderlinedBlock">
									&#160;
								</p>
						</div>
						<div class="afC">Код ОКВЭД2</div>
						<div class="afCol-1-3">
							<p class="afValue afUnderlinedBlock">
									&#160;
								</p>
						</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
			<p class="afPageBreakAfter"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">9. Код по ОКПО</div>
				<p class="afValue afUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:ОКПО">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:ОКПО"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft110 afSubscript">(Код общероссийского классификатора предприятий и организаций)</p>
			</div>
			<div class="afRow">
				<div class="afCol-1-3">10. Состоит на налоговом учете в</div>
				<div class="afCol-2-3 afValue afUnderlinedBlock">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:СведенияНалоговогоУчета">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:СведенияНалоговогоУчета/ns1:ОрганФНС"/>&#160;</xsl:if>
				</div>
				<p class="afCenter afMarginLeft210 afSubscript">(Наименование налогового органа, поставившего юридическое лицо на учет по месту нахождения)</p>
			</div>
			<div class="afRow">
				<div class="afC">Код налогового органа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:СведенияНалоговогоУчета">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:СведенияНалоговогоУчета/ns1:КодОрганаФНС"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">ИНН</div>
				<div class="afValue afUnderlinedBlock afMarginLeft50">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:ИНН">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:ИНН"/>&#160;</xsl:if>
				</div>
				<p class="afCenter afMarginLeft40 afSubscript">(Идентификационный номер налогоплательщика)</p>
			</div>
			<div class="afRow">
				<div class="afC">КПП</div>
				<p class="afValue afUnderlinedBlock afMarginLeft50">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/УТ6:КПП">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/УТ6:КПП"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft40 afSubscript">(Код причины постановки на учет)</p>
			</div>
			<div class="afRow">
				<div class="afC">11. Расчетный (текущий) счет</div>
				<p class="afValue afUnderlinedBlock afMarginLeft200">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:БанковскиеРеквизиты/УТ6:РСчет"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft210 afSubscript">(Указывается номер счета)</p>
			</div>
			<div class="afRow">
				<div class="afC">в</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:БанковскиеРеквизиты/ns1:НаименованиеБанка"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft20 afSubscript">(Наименование банка)</p>
			</div>
			<div class="afRow">
				<div class="afC">БИК</div>
				<p class="afCol-1-4 afValue afUnderlinedAlignLeftPadding">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:БанковскиеРеквизиты/УТ6:БИК"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC">12. Зарегистрировано в качестве страхователя в:</div>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:РегСтрахователь/ns1:ТОСФР/УТ6:Наименование">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:РегСтрахователь/ns1:ТОСФР/УТ6:Наименование"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft5 afSubscript">(Наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации, в котором юридическое лицо зарегистрировано в качестве страхователя по месту своего нахождения)</p>
			</div>
			<div class="afRow">
				<div class="afC">Регистрационный номер*</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:РегСтрахователь/ns1:ЕдиныйРегНомер">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:РегСтрахователь/ns1:ЕдиныйРегНомер"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Прошу зарегистрировать в качестве страхователя в территориальном органе Фонда пенсионного и социального страхования Российской Федерации по месту нахождения обособленного подразделения и уведомления о регистрации в качестве страхователя юридического лица по месту нахождения обособленного подразделения в территориальном органе Фонда пенсионного и социального страхования Российской Федерации.**</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '6'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">Вручить/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '7'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">Направить по почте/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '5'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-4">Направить в форме электронного документа через Единый портал/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '4'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">Направить по электронной почте</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow afCenter">Сведения об обособленном подразделении</div>
	
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">1.</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(Наименование обособленного подразделения)</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">2. Адрес места нахождения:</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable20 afCenter">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:ОбособленноеПодразделение/УТ6:ОКТМО">
								<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:ОКТМО"/>
							</xsl:when>
							<xsl:when test="$vForm/ns1:ОбособленноеПодразделение/УТ6:ОКАТО">
								<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:ОКАТО"/>
							</xsl:when>
							<xsl:otherwise>&#160;</xsl:otherwise>
						</xsl:choose>
					</td>
					<td class="afValue afTable20 afCenter">
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Индекс">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Индекс"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable60 afCenter">
							<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Регион">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Регион/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Регион/УТ6:Название"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-1-5">
					<p class="afCenter afSubscript">(Код по ОКТМО (ОКАТО))</p>
				</div>
				<div class="afCol-1-5">
					<p class="afCenter  afSubscript">(Почтовый индекс)</p>
				</div>
				<div class="afCol-6-10">
					<p class="afCenter  afSubscript">(Субъект Российской Федерации)</p>
				</div>
			</div>
				<div class="page-break-before:always" />
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable30 afCenter">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Район">
					<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Район/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Район/УТ6:Название"/>&#160;<br/></xsl:if>						
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Город">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Город/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Город/УТ6:Название"/>&#160;</xsl:if>
							<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:НаселенныйПункт">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Название"/>&#160;</xsl:if>	
							
					</td>
					<td class="afValue afTable40 afCenter">
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Улица">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Улица/УТ6:Сокращение"/>.&#160;<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Улица/УТ6:Название"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Дом">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Дом"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Корпус">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Корпус"/>
							<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Строение or $vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Строение">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Строение"/>
							<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Владение">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Владение"/>&#160;
						</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Квартира">
							<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Адрес/УТ6:Квартира"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afCenter  afSubscript">(Город, поселок, иной населенный пункт)</p>
				</div>
				<div class="afCol-4-10">
					<p class="afCenter  afSubscript">(Улица/переулок/проспект)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Дом)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Корпус)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Квартира)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Адрес электронной почты</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/УТ6:АдресЭлПочты">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/УТ6:АдресЭлПочты"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afInterval"/><div class="afInterval"/><div class="afInterval"/><div class="afInterval"/>
			<div class="afRow">
				<div class="afC">3. Основной вид деятельности</div>
				<p class="afValue afUnderlinedBlock afMarginLeft200">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:ОсновнойВидДеятельности">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:ОсновнойВидДеятельности/УТ6:Наименование"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Код по ОКВЭД2</div>
				<p class="afValue afUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:ОсновнойВидДеятельности">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:ОсновнойВидДеятельности/УТ6:КодПоОКВЭД"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft100 afSubscript">(Общероссийский классификатор видов экономической деятельности; указывается цифровой код не менее четырех знаков)</p>
			</div>
			<div class="afRow">
				<div class="afC">4. Код по ОКПО</div>
				<p class="afValue afUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:ОКПО">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:ОКПО"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft100 afSubscript">(Код общероссийского классификатора предприятий и организаций)</p>
			</div>
			<div class="afRow">
				<div class="afC">5. Юридическое лицо состоит на налоговом учете по месту нахождения обособленного подразделения в</div>
			</div>
			<div class="afRow">
				<p class="afValue afUnderlinedBlock afMarginLeft5">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:СведенияНалоговогоУчета">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:СведенияНалоговогоУчета/ns1:ОрганФНС"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft5 afSubscript">(Наименование налогового органа)</p>
			</div>
			<div class="afRow">
				<div class="afC">Код налогового органа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft150">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:СведенияНалоговогоУчета">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:СведенияНалоговогоУчета/ns1:КодОрганаФНС"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">КПП</div>
				<p class="afValue afUnderlinedBlock afMarginLeft50">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:СведенияНалоговогоУчета/УТ6:КПП">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:СведенияНалоговогоУчета/УТ6:КПП"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft50 afSubscript">(Код причины постановки на учет)</p>
			</div>
			<div class="afRow">
				<div class="afC">6. Расчетный (текущий) счет</div>
				<p class="afValue afUnderlinedBlock afMarginLeft200">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:БанковскиеРеквизиты/УТ6:РСчет"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft210 afSubscript">(Указывается номер счета)</p>
			</div>
			<div class="afRow">
				<div class="afC">в</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:БанковскиеРеквизиты/ns1:НаименованиеБанка"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft20 afSubscript">(Наименование банка)</p>
			</div>
			<div class="afRow">
				<div class="afC">БИК</div>
				<p class="afCol-1-4 afValue afUnderlinedAlignLeftPadding">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:БанковскиеРеквизиты/УТ6:БИК"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<!-- подписи -->
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-4">Руководитель</div>
				<div class="afCol-1-4">
					<p class="afUnderlinedBlock"/>
					<p class="afCenter afSubscript">(Подпись)</p>
					<p class="afCenter">М.П. (при наличии)</p>
				</div>
				<div class="afCol-1-2">
					<p class="afValue afUnderlinedBlock">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:ГоловнаяОрганизация/ns1:Руководитель/УТ6:ФИО"/>
						</xsl:call-template>
					</p>
					<p class="afCenter afSubscript">(Фамилия, имя, отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:Руководитель/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:Руководитель/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-4">Главный бухгалтер или иное лицо, на которое возложено ведение бухгалтерского учета</div>
				<div class="afCol-1-4">
					<p class="afUnderlinedBlock"/>
					<p class="afCenter afSubscript">(Подпись)</p>
				</div>
				<div class="afCol-1-2">
					<p class="afValue afUnderlinedBlock">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:ГоловнаяОрганизация/ns1:ГлБухгалтер/УТ6:ФИО"/>
						</xsl:call-template>
					</p>
					<p class="afCenter afSubscript">(Фамилия, имя, отчество, при наличии)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:ГоловнаяОрганизация/ns1:ГлБухгалтер/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:ГоловнаяОрганизация/ns1:ГлБухгалтер/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-4">Руководитель обособленного подразделения</div>
				<div class="afCol-1-4">
					<p class="afUnderlinedBlock"/>
					<p class="afCenter afSubscript">(Подпись)</p>
					<p class="afCenter">М.П. (при наличии)</p>
				</div>
				<div class="afCol-1-2">
					<p class="afValue afUnderlinedBlock">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:ОбособленноеПодразделение/ns1:Руководитель/УТ6:ФИО"/>
						</xsl:call-template>
					</p>
					<p class="afCenter afSubscript">(Фамилия, имя, отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:Руководитель/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:Руководитель/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-4">Главный бухгалтер или иное лицо, на которое возложено ведение бухгалтерского учета</div>
				<div class="afCol-1-4">
					<p class="afUnderlinedBlock"/>
					<p class="afCenter afSubscript">(Подпись)</p>
				</div>
				<div class="afCol-1-2">
					<p class="afValue afUnderlinedBlock">
						<xsl:call-template name="УТ6:NameStr">
							<xsl:with-param name="pName" select="$vForm/ns1:ОбособленноеПодразделение/ns1:ГлБухгалтер/УТ6:ФИО"/>
						</xsl:call-template>
					</p>
					<p class="afCenter afSubscript">(Фамилия, имя, отчество, при наличии)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:ОбособленноеПодразделение/ns1:ГлБухгалтер/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:ОбособленноеПодразделение/ns1:ГлБухгалтер/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			
			<p class="afInterval"/>
			<!-- Сведения о представителе -->
			<div class="afRow">
				<div class="afCenter">Сведения о представителе</div>
			</div>
			<div class="afRow">
				<div class="afC">1.</div>
				<div class="afCol-31">
					<p class="afUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-31">
					<p class="afUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-31">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Отчество">
							<p class="afUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:Телефоны">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:Телефоны/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
		<div class="page-break-before:always" />
			<div class="afRow">
				<div class="afC">Адрес электронной почты</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:АдресЭлПочты">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:АдресЭлПочты"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">2. Документ, удостоверяющий личность:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDocumentStr">
						<xsl:with-param name="pCodDocument" select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент"/>
					</xsl:call-template>
				</p>
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:КемВыдан, '   '), $DULDate)"/>
				</p>
			</div>
			<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
			<div class="afRow">
				<div class="afC">3. Документ, удостоверяющий полномочия:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDUP">
						<xsl:with-param name="pCod" select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код"/>
					</xsl:call-template>
				</p>
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:КемВыдан, '   '), $DULDate)"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">дата окончания срока действия</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft200">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:СрокДействия"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
			<p class="afInterval"/>
			<div class="afStickToBottom">
			<p>_____________________________________________</p>
			<p class="afFootnote">
				<sup>*</sup> При подаче заявления иностранной организацией для ее регистрации в качестве страхователя по месту нахождения обособленного подразделения в случае, если иностранная организация уже зарегистрирована в качестве страхователя по месту нахождения одного из своих обособленных подразделений, в данной строке указываются соответствующие сведения о ее первоначальной регистрации в территориальном органе Фонда пенсионного и социального страхования Российской Федерации.</p>
			<p class="afFootnote">
				<sup>**</sup> Нужное отметить.</p>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
