<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ВС/ЗРФЛТДОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ЗРФЛТДОСС"/>
		<div class="afWrap pfrAfZRFLTDOSS">

			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRight-1-3 ">
				<div class="afValue afUnderlinedBlock">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:ДатаПодачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</div>
				<p class="afCenter afSubscript">(число) (месяц (прописью) (год)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">В</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(Наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">ЗАЯВЛЕНИЕ<br/>о регистрации в качестве страхователя – физического лица</h1>
			<p class="afInterval"/>
			<div class="afRow afCenter">Сведения о заявителе</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">1.</div>
				<div class="afCol-31">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-31">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-31">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Отчество">
							<p class="afValue afBlankUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">2. Адрес места жительства</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable30 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Индекс">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Индекс"/>&#160;</xsl:if>
					</td>
						<td class="afValue afTable70 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Регион">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Регион/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Регион/УТ6:Название"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afCenter  afSubscript">(Индекс)</p>
				</div>
				<div class="afCol-7-10">
					<p class="afCenter  afSubscript">(Субъект Российской Федерации)</p>
				</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable30 afCenter">
					<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Район">
					<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Район/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Район/УТ6:Название"/>&#160;<br/></xsl:if>						
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Город">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Город/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Город/УТ6:Название"/>&#160;<br/></xsl:if>
							<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:НаселенныйПункт">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Название"/>&#160;</xsl:if>	
							
					</td>
					<td class="afValue afTable40 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Улица">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Улица/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Улица/УТ6:Название"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Дом">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Дом"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Корпус">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Корпус"/>
							<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Строение or $vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Строение">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Строение"/>
							<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение"/>&#160;
						</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Квартира">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Квартира"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afCenter  afSubscript">(Город, поселок, иной населенный пункт)</p>
				</div>
				<div class="afCol-4-10">
					<p class="afCenter  afSubscript">(Улица/переулок/проспект)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Дом)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Корпус)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Квартира)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:Заявитель/УТ6:Телефон">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Адрес электронной почты</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:Заявитель/УТ6:АдресЭлПочты">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:АдресЭлПочты"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">СНИЛС</div>
				<p class="afValue afUnderlinedBlock afMarginLeft60">
					<xsl:if test="$vForm/ns1:Заявитель/УТ6:СНИЛС">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:СНИЛС"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC">3. Документ, удостоверяющий личность:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDocumentStr">
						<xsl:with-param name="pCodDocument" select="$vForm/ns1:Заявитель/УТ6:УдостоверяющийДокумент"/>
					</xsl:call-template>
				</p>
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:УдостоверяющийДокумент/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:УдостоверяющийДокумент/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Заявитель/УТ6:УдостоверяющийДокумент/УТ6:КемВыдан, ',   '), $DULDate)"/>
				</p>
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC">дата и место рождения </div>
				<xsl:variable name="BirthDate">
					<xsl:choose>
                        <xsl:when test="$vForm/ns1:Заявитель/УТ6:ДатаРождения">
                            <xsl:call-template name="Date2GOST">
                                <xsl:with-param name="pDate" select="$vForm/ns1:Заявитель/УТ6:ДатаРождения" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="УТ6:DateSpecialStr">
                                <xsl:with-param name="pDate" select="$vForm/ns1:Заявитель/УТ6:ДатаРожденияОсобая" />
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
				</xsl:variable>
				<xsl:variable name="birthPlace">
					<xsl:call-template name="УТ6:BirthplaceStr">
						<xsl:with-param name="pBirthplace" select="$vForm/ns1:Заявитель/УТ6:МестоРождения"> </xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft150">
					<xsl:value-of select="concat(concat($BirthDate, ',    '), $birthPlace)"/>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">4. Сведения о государственной регистрации заявителя:</div>
			</div>
			<div class="afRow">
				<div class="afC">4.1. Наименование органа, осуществившего государственную регистрацию</div>
			</div>
			<div class="afRow">
				<p class="afValue afBlankUnderlinedBlock">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведОГосРегистрации">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведОГосРегистрации/ns1:НаименованиеОргана"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">4.2. Регистрационный номер</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft180">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведОГосРегистрации">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведОГосРегистрации/ns1:ОГРНИП"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">4.3. Дата государственной регистрации</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft250">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведОГосРегистрации">
						<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведОГосРегистрации/ns1:ДатаРегистрации"/>
							</xsl:with-param>
						</xsl:call-template>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft250 afSubscript">(Число, месяц, год)</p>
			</div>
			<p class="afClear"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">5. Сведения о выданных лицензиях (иных документах, дающих право физическому лицу заниматься в установленном законодательством Российской Федерации порядке частной практикой):</div>
			</div>
			<div class="afRow">
				<div class="afC">5.1. Наименование документа</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях/УТ6:Наименование"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">5.2. Наименование органа, выдавшего документ</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft300">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях/ns1:НаименованиеОргана"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">5.3. Номер документа</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft140">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях/УТ6:Номер"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">5.4. Дата выдачи документа</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft180">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях">
						<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях/УТ6:ДатаВыдачи"/>
							</xsl:with-param>
						</xsl:call-template>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft180 afSubscript">(Число, месяц, год)</p>
			</div>
			<div class="afRow">
				<div class="afC">5.5. Дата окончания срока действия документа</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft300">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях/ns1:ДатаОкончанияСрока">
								<xsl:call-template name="Date2GOST">
									<xsl:with-param name="pDate">
										<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияОЛицензиях/ns1:ДатаОкончанияСрока"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>бессрочно</xsl:otherwise>
						</xsl:choose>
					</xsl:if>&#160;	
				</p>
				<p class="afCenter afMarginLeft300  afSubscript">(Число, месяц, год или «бессрочно»)</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">6. Номер и дата заключения трудового договора №</div>
				<div class="afCol-1-4">
				<p class=" afValue afCenter afUnderlinedBlock">
					<xsl:if test="$vForm/ns1:ДанныеТД/ns1:РеквизитыДоговора/УТ6:Номер">
						<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:РеквизитыДоговора/УТ6:Номер"/>
					</xsl:if>&#160;
				</p>
				</div>
				<div class="afC"> от </div>
				<div class="afCol-1-4">
					<p class=" afValue afCenter afUnderlinedBlock">
						<xsl:if test="$vForm/ns1:ДанныеТД/ns1:РеквизитыДоговора/УТ6:Дата">
							<xsl:call-template name="Date2Text">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:РеквизитыДоговора/УТ6:Дата"/>
								</xsl:with-param>
							</xsl:call-template>г.
						</xsl:if>&#160;	
					</p>
					<p class="afCenter afSubscript">(Число и месяц)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">7. Срок действия трудового договора* с</div>
				<div class="afCol-1-4">
					<p class="afValue afCenter afUnderlinedBlock">
						<xsl:if test="$vForm/ns1:ДанныеТД/ns1:СрокДействия/ns1:С">
							<xsl:call-template name="Date2GOST">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СрокДействия/ns1:С"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>&#160;
						<p class="afCenter afSubscript">(Число, месяц, год)</p>	
					</p>	
				</div>
				<div class="afC">по</div>
				<div class="afCol-1-4">
				<p class="afValue afCenter afUnderlinedBlock">
					<xsl:if test="$vForm/ns1:ДанныеТД/ns1:СрокДействия/ns1:По">
						<xsl:call-template name="Date2GOST">
							<xsl:with-param name="pDate">
								<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СрокДействия/ns1:По"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:if>&#160;	
					<p class="afCenter afSubscript">(Число, месяц, год)</p>		
					</p>	
				</div>
			</div>
			<div class="afRow afCenter afMarginLeft300">
				<div class="afCol-1-3">
				<p class="afCenter afUnderlinedBlock">
				<xsl:choose>
							<xsl:when test="$vForm/ns1:ДанныеТД/ns1:СрокДействия/ns1:По">
								&#160;
							</xsl:when>
							<xsl:otherwise>бессрочно
							</xsl:otherwise>
						</xsl:choose>
				</p>
						<p class="afCenter afSubscript">(неопределенный срок)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afС afJustify">7.1. Сведения о наличии трудовых отношений с работником по форме «Сведения о трудовой деятельности зарегистрированного лица (СЗВ-ТД)» направлены в Пенсионный фонд Российской Федерации</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-3">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:if test="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Дата">
							<xsl:call-template name="Date2GOST">
								<xsl:with-param name="pDate">
									<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Дата"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>&#160;		
						
					</p>
					<p class="afCenter afSubscript">(Число, месяц, год)</p>
				</div>
				<div class="afCol-1-3">
					<p class="afCenter">
						в отношении принятого работника
					</p>
				</div>
				<div class="afCol-1-3">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ФИО/УТ6:Фамилия">
							<p class="afValue afBlankUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ФИО/УТ6:Фамилия"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afValue afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-4">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-1-4">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ФИО/УТ6:Отчество">
							<p class="afValue afBlankUnderlinedBlock">
								<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afValue afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
				<div class="afCol-1-4">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:value-of select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:СНИЛС"/>
					</p>
					<p class="afCenter afSubscript">(СНИЛС)</p>
				</div>
				<div class="afCol-1-4">
					<p class="afValue afBlankUnderlinedBlock">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:Заявитель/УТ6:ДатаРождения">
								<xsl:call-template name="Date2GOST">
									<xsl:with-param name="pDate" select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ДатаРождения" />
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="УТ6:DateSpecialStr">
									<xsl:with-param name="pDate" select="$vForm/ns1:ДанныеТД/ns1:СведенияСЗВТД/ns1:Работник/УТ6:ДатаРожденияОсобая" />
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</p>
					<p class="afCenter afSubscript">(Дата рождения)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">7.2. Регистрационный номер страхователя в Пенсионном фонде Российской Федерации</div>
			</div>
			<div class="afRow">
				<p class="afCol-1-2 afValue afBlankUnderlinedBlock afMarginLeft5">
					<xsl:if test="$vForm/ns1:ДанныеТД/УТ6:РегНомер">
						<xsl:value-of select="$vForm/ns1:ДанныеТД/УТ6:РегНомер"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">8. Основной вид деятельности</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft200">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:ОсновнойВидДеятельности">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:ОсновнойВидДеятельности/УТ6:Наименование"/>&#160;</xsl:if>
				</p>
			</div>
			<div class="afRow">
				<div class="afC">Код по ОКВЭД2</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft110">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:ОсновнойВидДеятельности">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:ОсновнойВидДеятельности/ns1:ОКВЭД"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft100 afSubscript">(Общероссийский классификатор видов экономической деятельности; указывается цифровой код не менее четырех знаков)</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">9. Состоит на налоговом учете в</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft210">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияНалоговогоУчета">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияНалоговогоУчета/ns1:ОрганФНС"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft210 afSubscript">(Наименование налогового органа, поставившего физическое лицо на учет)</p>
			</div>
			<div class="afRow">
				<div class="afC">ИНН</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft50">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияНалоговогоУчета">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:СведенияНалоговогоУчета/УТ6:ИНН"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft40 afSubscript">(Идентификационный номер налогоплательщика)</p>
			</div>
			<div class="afRow">
				<div class="afC">10. Счет в кредитной организации</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft210">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:БанковскиеРеквизиты/УТ6:РСчет"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft210 afSubscript">(Указывается номер счета)</p>
			</div>
			<div class="afRow">
				<div class="afC">в</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft20">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:БанковскиеРеквизиты/ns1:НаименованиеБанка"/>&#160;</xsl:if>
				</p>
				<p class="afCenter afMarginLeft20 afSubscript">(Наименование банка)</p>
			</div>
			<div class="afRow">
				<div class="afC">БИК</div>
				<p class="afCol-1-4 afValue afUnderlinedAlignLeftPadding">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:БанковскиеРеквизиты">
						<xsl:value-of select="$vForm/ns1:РегДанныеЗаявителя/ns1:БанковскиеРеквизиты/УТ6:БИК"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afClear"/>
			<p class="afC">11. Категория страхователя
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft180">
					<xsl:if test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '17'">Физические лица, производящие выплаты физическим лицам </xsl:when>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '18'">Адвокаты</xsl:when>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '20'">Нотариусы, занимающиеся частной практикой</xsl:when>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '22'">Арбитражный управляющий</xsl:when>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '24'">Патентный поверенный</xsl:when>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '26'">Оценщик</xsl:when>
							<xsl:when test="$vForm/ns1:РегДанныеЗаявителя/ns1:КатегорияСтрахователя = '28'">Медиатор</xsl:when>
						</xsl:choose>
						&#160;</xsl:if>
				</p>
			</p>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Прошу зарегистрировать в качестве страхователя в территориальном органе Фонда пенсионного и  социального страхования Российской Федерации и уведомление о регистрации в качестве страхователя физического лица в территориальном органе Фонда пенсионного и социального страхования Российской Федерации:</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '6'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">вручить/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '7'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">направить по почте/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '5'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-4">направить в форме электронного документа через Единый портал**/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '4'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">направить по электронной почте/</div>
			</div>
			<div class="afRow">
				<div class="afCenter">Сведения о представителе</div>
			</div>
			<div class="afRow">
				<div class="afC">11.</div>
				<div class="afCol-31">
					<p class="afBlankUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-31">
					<p class="afBlankUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-31">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Отчество">
							<p class="afBlankUnderlinedBlock afValue">
								<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:Телефоны">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:Телефоны/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Адрес электронной почты</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:АдресЭлПочты">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:АдресЭлПочты"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afPageBreakAfter"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">12. Документ, удостоверяющий личность:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDocumentStr">
						<xsl:with-param name="pCodDocument" select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент"/>
					</xsl:call-template>
				</p>
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:КемВыдан, '   '), $DULDate)"/>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">13. Документ, удостоверяющий полномочия:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDUP">
						<xsl:with-param name="pCod" select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код"/>
					</xsl:call-template>
				</p>
			</div>
			<p class="afClear"/>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:КемВыдан, '   '), $DULDate)"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">дата окончания срока действия</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft200">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:СрокДействия"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-5 afMarginLeft5">Подпись заявителя (представителя)</div>
				<div class="afCol-1-4 afUnderlinedAlignLeftPadding"/>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Подпись работника многофункционального центра ***</div>
				<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft350">
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afMarginLeft70">М.П. ***</div>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo" />
					</xsl:call-template>
				</xsl:if>
			</div>
			<p class="afInterval"/>
			<p>_____________________________________________</p>
			<p class="afFootnote">
				<sup>*</sup> Заполняется соответствующая строка в зависимости от вида трудового договора.</p>
			<p class="afFootnote">
				<sup>**</sup> Нужное отметить.</p>
			<p class="afFootnote">
				<sup>***</sup>В случае указания заявителем государственной услуги в комплексном запросе.</p>
		</div>
	</xsl:template>
</xsl:stylesheet>
