<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ns1="http://пф.рф/ВС/ЗСДОСС/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/Базовые.xsl"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template match="/" name="inc">
		<xsl:variable name="vForm" select="/ns1:ЭДСФР/ns1:ЗСДОСС"/>
		<div class="afWrap pfrAfZSDOSS">
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRight-1-3 ">
				<div class="afValue afUnderlinedBlock">
					<xsl:call-template name="Date2Text">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:ДатаПодачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</div>
				<p class="afCenter afSubscript">(число) (месяц (прописью) (год)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">В</div>
				<p class="afValue afUnderlinedBlock afMarginLeft20">
					<xsl:value-of select="$vForm/ns1:ТОСФР/УТ6:Наименование"/>
				</p>
				<p class="afSubscript afCenter">(Наименование территориального органа Фонда пенсионного и социального страхования Российской Федерации)</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<h1 class="afHeader">ЗАЯВЛЕНИЕ<br/>о снятии с регистрационного учета в территориальном органе Фонда пенсионного и социального страхования Российской Федерации лица, добровольно вступившего в правоотношения по обязательному социальному страхованию на случай временной нетрудоспособности и в связи с материнством</h1>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">Прошу снять с регистрационного учета</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-31">
					<p class="afBlankUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-31">
					<p class="afBlankUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-31">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Отчество ">
							<p class="afBlankUnderlinedBlock afValue">
								<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Адрес</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable30 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Индекс">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Индекс"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable70 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Регион">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Регион/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Регион/УТ6:Название"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afCenter  afSubscript">(Индекс)</p>
				</div>
				<div class="afCol-7-10">
					<p class="afCenter  afSubscript">(Субъект Российской Федерации)</p>
				</div>
			</div>
			<table class="afTable afTable100 afNoBreakInside">
				<tr>
					<td class="afValue afTable30 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Район">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Район/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Район/УТ6:Название"/>&#160;<br/>
						</xsl:if>
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Город">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Город/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Город/УТ6:Название"/>&#160;<br/>
						</xsl:if>
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:НаселенныйПункт">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:НаселенныйПункт/УТ6:Название"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable40 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Улица">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Улица/УТ6:Сокращение"/>&#160;<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Улица/УТ6:Название"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Дом">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Дом"/>&#160;</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Корпус">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Корпус"/>
							<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Строение or $vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Строение">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Строение"/>
							<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение">,&#160;</xsl:if>
						</xsl:if>
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Владение"/>&#160;
						</xsl:if>
					</td>
					<td class="afValue afTable10 afCenter">
						<xsl:if test="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Квартира">
							<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:Адрес/УТ6:Квартира"/>&#160;</xsl:if>
					</td>
				</tr>
			</table>
			<div class="afRow">
				<div class="afCol-3-10">
					<p class="afCenter  afSubscript">(Город, поселок, иной населенный пункт)</p>
				</div>
				<div class="afCol-4-10">
					<p class="afCenter  afSubscript">(Улица/переулок/проспект)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Дом)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Корпус)</p>
				</div>
				<div class="afCol-10">
					<p class="afCenter  afSubscript">(Квартира)</p>
				</div>
			</div>
			<div class="afRow">
				<div class="afC">СНИЛС</div>
				<p class="afValue afUnderlinedBlock afMarginLeft60">
					<xsl:if test="$vForm/ns1:Заявитель/УТ6:СНИЛС">
						<xsl:value-of select="$vForm/ns1:Заявитель/УТ6:СНИЛС"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afClear"/>
			<p class="afC">Категория страхователя
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft180">
					<xsl:if test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя">
						<xsl:choose>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '18'">Адвокаты</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '20'">Нотариусы, занимающиеся частной практикой</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '22'">Арбитражный управляющий</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '24'">Патентный поверенный</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '26'">Оценщик</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '28'">Медиатор</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '39'">Члены крестьянских (фермерских) хозяйств</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '41'">Член семейной (родовой) общины коренных малочисленных народов Севера,Сибири и Дальнего Востока РФ</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '14'">Индивидуальные предприниматели</xsl:when>
							<xsl:when test="$vForm/ns1:Заявитель/ns1:КатегорияСтрахователя = '15'">Главы крестьянских (фермерских) хозяйств, зарегистрированные в качестве индивидуального предпринимателя (ЕГРИП)</xsl:when>
						</xsl:choose>
						&#160;</xsl:if>
				</p>
			</p>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Регистрационный номер</div>
				<p class="afValue afBlankUnderlinedBlock afMarginLeft180">
					<xsl:value-of select="$vForm/ns1:Заявитель/ns1:ЕдиныйРегНомер"/>
				</p>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Прошу копию решения о снятии с регистрационного учета</div>
			</div>
			<div class="afRow">
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '6'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">вручить/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '7'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">направить по почте/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '5'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-4">направить в форме электронного документа через Единый портал/</div>
				<div class="afCol-1-10">
					<div class="afC afCheck">
						<xsl:if test="$vForm/ns1:Информирование = '4'">V</xsl:if>
					</div>
				</div>
				<div class="afCol-1-6">направить по электронной почте/</div>
			</div>
			<p class="afInterval"/><p class="afInterval"/><p class="afInterval"/>
			<div class="afRow">
				<div class="afCenter">Сведения о представителе</div>
			</div>
			<div class="afRow">
				<div class="afC"/>
				<div class="afCol-31">
					<p class="afBlankUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Фамилия"/>
					</p>
					<p class="afCenter afSubscript">(Фамилия)</p>
				</div>
				<div class="afCol-31">
					<p class="afBlankUnderlinedBlock afValue">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Имя"/>
					</p>
					<p class="afCenter afSubscript">(Имя)</p>
				</div>
				<div class="afCol-31">
					<xsl:choose>
						<xsl:when test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Отчество">
							<p class="afBlankUnderlinedBlock afValue">
								<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:ФИО/УТ6:Отчество"/>
							</p>
						</xsl:when>
						<xsl:otherwise>
							<p class="afBlankUnderlinedBlock"/>&#160;</xsl:otherwise>
					</xsl:choose>
					<p class="afCenter afSubscript">(Отчество, при наличии)</p>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Телефон (с указанием кода)</div>
				<p class="afValue afUnderlinedBlock afMarginLeft190">
					<xsl:if test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:Телефоны">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:Телефоны/УТ6:Телефон"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Адрес электронной почты</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:if test="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:АдресЭлПочты">
						<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:АдресЭлПочты"/>&#160;</xsl:if>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Документ, удостоверяющий личность:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDocumentStr">
						<xsl:with-param name="pCodDocument" select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент"/>
					</xsl:call-template>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Представитель/УТ6:АнкетныеДанные/УТ6:УдостоверяющийДокумент/УТ6:КемВыдан, '   '), $DULDate)"/>
				</p>
			</div>
			<p class="afInterval"/><p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Документ, удостоверяющий полномочия:</div>
			</div>
			<div class="afRow">
				<div class="afC">наименование документа</div>
				<p class="afValue afUnderlinedBlock afMarginLeft170">
					<xsl:call-template name="УТ6:CodDUP">
						<xsl:with-param name="pCod" select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Код"/>
					</xsl:call-template>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">серия</div>
				<p class="afCol-1-3 afValue afUnderlinedAlignLeftPadding">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Серия"/>
				</p>
				<p class="afC">номер</p>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft330">
					<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:Номер"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">кем и когда выдан</div>
				<xsl:variable name="DULDate">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:ДатаВыдачи"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft120">
					<xsl:value-of select="concat(concat($vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:КемВыдан, '   '), $DULDate)"/>
				</p>
			</div>
			<div class="afRow">
				<div class="afC afMarginLeft5">дата окончания срока действия</div>
				<p class="afValue afUnderlinedAlignLeftPadding afMarginLeft200">
					<xsl:call-template name="Date2GOST">
						<xsl:with-param name="pDate">
							<xsl:value-of select="$vForm/ns1:Представитель/УТ6:ДокументПодтверждающийПолномочия/УТ6:СрокДействия"/>
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afCol-1-5 afMarginLeft5">Подпись заявителя (представителя)</div>
				<div class="afCol-1-4 afUnderlinedAlignLeftPadding"/>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Подпись работника многофункционального центра *</div>
				<div class="afValue afUnderlinedAlignLeftPadding afMarginLeft350">
				</div>
			</div>
			<p class="afInterval"/>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC afMarginLeft70">М.П. *</div>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
			<p class="afInterval"/>
			<div class="afStickToBottom">
				<p>_____________________________________________</p>
				<p class="afFootnote">
					<sup>*</sup> В случае указания заявителем государственной услуги в комплексном запросе. </p>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
