<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs УТ6 ns1 sig ВС2 ИС6" version="1.0" xmlns:УТ6="http://пф.рф/УТ/2023-01-10" xmlns:ВС2="http://пф.рф/ВС/типы/2023-01-10" xmlns:sig="http://iis.ecp.ru/SignInfo/2023-01-10" xmlns:ИС6="http://пф.рф/ВС/ИС/2023-01-10" xmlns:ns1="http://пф.рф/ВС/СЗВ-ИСХ/2023-01-10">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:include href="../../Общие/УнифТипы_2023-01-10.xsl"/>
	<xsl:include href="../../Общие/SignInfo_2023-01-10.xsl"/>
	<xsl:template  name="inc">
		<div class="afWrap sfrAfSZV-ISKH">
			<p class="afRight-3-10">
                УТВЕРЖДЕНА<br/>
                постановлением Правления СФР<br/>
                от 6 декабря 2018 г. № 507п
            </p>
			<p class="afInterval"/>
			<p class="afP">Форма ОДВ-1</p>
			<p class="afInterval"/>
			<p class="afValue afP">Сведения по страхователю, передаваемые в СФР для ведения индивидуального (персонифицированного) учета</p>
			<p class="afInterval"/>
			<p class="afValue afP">1. Реквизиты страхователя, передающего документы:</p>
			<p class="afInterval"/>
			<xsl:variable name="RegNum" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:РегНомер"/>
			<div class="afRow">
				<div class="afC">Регистрационный номер в СФР</div>
				<div class="afCol-1-2">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 3, 1)"/>
							</td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 7, 1)"/>
							</td>
							<td>&#160;-&#160;</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 9, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 10, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 11, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 12, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 13, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($RegNum, 14, 1)"/>
							</td>
						</tr>
					</table>
				</div>
				<div class="afCol-1-10 afCenterBlock">Стр.</div>
				<div class="afCol-1-10">
					<table class="afTable100 afTableCollapse">
						<tr>
							<td class=" afCheckSmall">&#160;&#160;</td>
							<td class=" afCheckSmall">&#160;&#160;</td>
							<td class=" afCheckSmall">&#160;&#160;</td>
						</tr>
					</table>
				</div>
			</div>
			<xsl:variable name="NumINN" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:ИНН"/>
			<xsl:variable name="NumKPP" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/УТ6:КПП"/>
			<div class="afRow">
				<div class="afCol-1-5 afCenterBlock">ИНН</div>
				<div class="afCol-3-10">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 9, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 10, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 11, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumINN, 12, 1)"/>
							</td>
						</tr>
					</table>
				</div>
				<div class="afCol-1-5 afCenterBlock">КПП</div>
				<div class="afCol-3-10">
					<table class="afTableCollapse">
						<tr>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 1, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 2, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 3, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 4, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 5, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 6, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 7, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 8, 1)"/>
							</td>
							<td class="afCheckSmall">
								<xsl:value-of select="substring($NumKPP, 9, 1)"/>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afRow">
				<div class="afC">Наименование (краткое)</div>
				<div class="afCol-2-3 afValue afUnderlinedBlock">
					<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страхователь/ИС6:Наименование"/>
				</div>
			</div>
			<div class="afRow">
				<div class="afCol-3-10">
					<div class="afC afValue">2. Отчетный период (код):</div>
					<div class="afCol-1-10">
						<div class="afC afCheck">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Код"/>
						</div>
					</div>
				</div>
				<div class="afCol-1-5">
					<div class="afC afMarginLeft10">год</div>
					<div class="afValue">
						<div class="afCol-1-4 afCheck">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОтчетныйПериод/ns1:Год"/>
						</div>
					</div>
				</div>
				<div class="afCol-1-2">
					<div class="afP">
						<div class="afCol-1-4 afPadding">Исходная</div>
						<div class="afCol-1-10 ">
							<div class="afC afCheck">
								<xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '0']">V</xsl:if>
							</div>
						</div>
					</div>
					<div class="afP">
						<div class="afCol-1-4 afPadding">Корректирующая</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '1']">V</xsl:if>
							</div>
						</div>
					</div>
					<div class="afP">
						<div class="afCol-1-4 afPadding">Отменяющая</div>
						<div class="afCol-1-10">
							<div class="afC afCheck">
								<xsl:if test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Тип[text() = '2']">V</xsl:if>
							</div>
						</div>
					</div>
				</div>
			</div>
			<p class="afP afValue">3. Перечень входящих документов</p>
			<table class="afTable afSmallSize">
				<tr class="afCenter">
					<td>Наименование входящего документа</td>
					<td>Количество застрахованных лиц, на которых представлены сведения, чел.</td>
				</tr>
				<tr>
					<td>Форма "Сведения о страховом стаже застрахованного лица (СЗВ-СТАЖ)"</td>
					<td> </td>
				</tr>
				<tr>
					<td>Форма "Сведения о заработке (вознаграждении) доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах, о периодах трудовой и иной деятельности,
                        засчитываемых в страховой стаж застрахованного лица (СЗВ-ИСХ)"</td>
					<td class="afValue afCenter">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:КоличествоЗЛ"/>
					</td>
				</tr>
				<tr>
					<td>Форма "Данные о корректировке сведений, учтенных на индивидуальном лицевом счету застрахованного лица (СЗВ-КОРР)"</td>
					<td> </td>
				</tr>
				<tr>
					<td>Иные входящие документы:</td>
					<td/>
				</tr>
			</table>
			<p class="afInterval"/>
			<p class="afP afValue">4. Данные в целом по страхователю:</p>
			<table class="afTable afSmallSize">
				<tr class="afCenter">
					<td/>
					<td>Задолженность на начало отчетного периода, руб. коп.</td>
					<td>Начислено страховых взносов, руб. коп.</td>
					<td>Уплачено страховых взносов, руб. коп.</td>
					<td>Задолженность на конец отчетного периода, руб. коп.</td>
				</tr>
				<tr>
					<td>На страховую пенсию</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:ЗадолженностьНаНачало"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:Начислено"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:Уплачено"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:ЗадолженностьНаКонец"/>
					</td>
				</tr>
				<tr>
					<td>На накопительную пенсию</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:ЗадолженностьНаНачало"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:Начислено"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:Уплачено"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:ЗадолженностьНаКонец"/>
					</td>
				</tr>
				<tr>
					<td>По тарифу страховых взносов</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:ЗадолженностьНаНачало"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:Начислено"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:Уплачено"/>
					</td>
					<td>
						<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:ЗадолженностьНаКонец"/>
					</td>
				</tr>
			</table>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<p class="afP">Расшифровка графы "Уплачено" по периодам, за которые была произведена уплата страховых взносов</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td>Уплачено в календарном году</td>
						<td>На страховую пенсию</td>
						<td>На накопительную пенсию</td>
						<td>По тарифу страховых взносов</td>
					</tr>
					<tr>
						<td>Всего, в том числе:</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Страховая/ИС6:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Накопительная/ИС6:Уплачено"/>
						</td>
						<td>
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ТарифСВ/ИС6:Уплачено"/>
						</td>
					</tr>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Уплата/ИС6:Год">
							<xsl:for-each select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Уплата">
								<tr>
									<td>за <span class="afValue">
											<xsl:value-of select="./ИС6:Год"/>
										</span> год</td>
									<td>
										<xsl:value-of select="./ИС6:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Накопительная"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:ТарифСВ"/>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td>за ________ год</td>
								<td/>
								<td/>
								<td/>
							</tr>
							<tr>
								<td>за ________ год</td>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<p class="afP afValue">5. Основание для отражения данных о периодах работы застрахованного лица в условиях, дающих право на досрочное назначение пенсии в соответствии со статьей 30
                Федерального закона от 28.12.2013 № 400–ФЗ «О страховых пенсиях»</p>
				<table class="afTable afSmallSize">
					<tr class="afCenter">
						<td>№ п/п</td>
						<td>Наименование структурного подразделения по штатному расписанию</td>
						<td>Наименование профессии, должности по штатному расписанию</td>
						<td>Кол-во раб. мест по штат. распи-<br/>санию</td>
						<td>Кол-во раб-ов факт.</td>
						<td>Характер фактически выполняемых работ и дополнительные условия труда</td>
						<td>Наименование первичных документов, подтверждающих занятость в особых условиях труда</td>
						<td>Код особых условий труда/выслуги лет по Классификатору</td>
						<td>Код позиции Списка № 1 и 2, "малого" списка</td>
					</tr>
					<tr class="afHeightRow afCenter afSmallSize">
						<td>1</td>
						<td>2</td>
						<td>3</td>
						<td>4</td>
						<td>5</td>
						<td>6</td>
						<td>7</td>
						<td>8</td>
						<td>9</td>
					</tr>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
							<xsl:for-each select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ns1:Основание">
								<tr class="afCenter">
									<td>
										<xsl:value-of select="position()"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Подразделение"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:ПрофессияДолжность"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:КоличествоШтат"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:КоличествоФакт"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Описание"/>
									</td>
									<td>
										<xsl:value-of select="./ИС6:Документы"/>
									</td>
									<td>
										<xsl:for-each select="ns1:ОУТ">
											<p class="afP">
												<xsl:value-of select="ns1:Код"/>
											</p>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="ns1:ОУТ">
											<p class="afP">
												<xsl:value-of select="ns1:ПозицияСписка"/>
											</p>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<tr class="afHeightBlankRow">
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
								<td/>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</table>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<div class="afRow">
					<div class="afC afValue">Общее количество рабочих мест в особых условиях труда по штату</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС6:ВсегоШтат"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<div class="afRow">
					<div class="afC afValue">Количество фактически работающих в особых условиях труда</div>
					<xsl:choose>
						<xsl:when test="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП">
							<div class="afCol-1-3 afValue afUnderlinedBlock">
								<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ОснованияДНП/ИС6:ВсегоФакт"/>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="afCol-1-3 afBlankUnderlinedBlock"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakBefore afNoBreakInside">
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afCenter afSubscriptNormal">Наименование должности руководителя</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-1-5">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afCenter afSubscriptNormal">Подпись</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-4-10">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afCenter afSubscriptNormal">Ф.И.О.</p>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
								</xsl:with-param>
							</xsl:call-template>
						</p>
						<p class="afP afCenter afSubscriptNormal">Дата (дд.мм.гггг)</p>
					</div>
					<div class="afPadding">М.П. (при наличии)</div>
					<div class="afPadding"/>
				</div>
			</div>
			<!--
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afSubscriptNormal afCenter">Наименование должности руководителя</p>
					</div>
					<div class="afPadding">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afSubscriptNormal afCenter">Подпись</p>
					</div>
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afSubscriptNormal afCenter">Расшифровка подписи</p>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
								</xsl:with-param>
							</xsl:call-template>
						</p>
						<p class="afP afCenter">Дата (дд.мм.гггг)</p>
					</div>
					<div class="afPadding">М.П. (при наличии)</div>
					<div class="afPadding"/>
				</div>
-->			</div>

			<!-- ФОРМА СЗВ-ИСХ -->
			<xsl:for-each select="/ns1:ЭДСФР/ns1:СЗВ-ИСХ">
				<div id="break"/>
				<xsl:variable name="RegNumISH" select="ns1:Страхователь/УТ6:РегНомер"/>
				<div class="afRow">
					<div class="afC">Регистрационный номер в СФР</div>
					<div class="afCol-1-2">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 3, 1)"/>
								</td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 7, 1)"/>
								</td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 13, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 14, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-10 afCenterBlock">Стр.</div>
					<div class="afCol-1-10">
						<table class="afTable100 afTableCollapse">
							<tr>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
								<td class=" afCheckSmall">&#160;&#160;</td>
							</tr>
						</table>
					</div>
				</div>
				<xsl:variable name="NumINNISH" select="ns1:Страхователь/УТ6:ИНН"/>
				<xsl:variable name="NumKPPISH" select="ns1:Страхователь/УТ6:КПП"/>
				<div class="afRow">
					<div class="afCol-1-5 afCenterBlock">ИНН</div>
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 12, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-5 afCenterBlock">КПП</div>
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<xsl:choose>
								<xsl:when test="ns1:Страхователь/УТ6:КПП">
									<tr>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 1, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 2, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 3, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 4, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 5, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 6, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 7, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 8, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 9, 1)"/>
										</td>
									</tr>
								</xsl:when>
								<xsl:otherwise>
									<tr>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
									</tr>
								</xsl:otherwise>
							</xsl:choose>
						</table>
					</div>
				</div>
				<p class="afInterval"/>
				<p class="afRight-3-10">
                УТВЕРЖДЕНА<br/>
                постановлением Правления СФР<br/>
                от 6 декабря 2018 г. № 507п</p>
				<p class="afInterval"/>
				<p class="afP">Форма СЗВ-ИСХ</p>
				<p class="afInterval"/>
				<p class="afCenter afValue afP">Сведения о заработке (вознаграждении) доходе, сумме выплат и иных вознаграждений, начисленных и уплаченных страховых взносах, о периодах трудовой и иной
					деятельности, засчитываемых в страховой стаж застрахованного лица</p>
				<p class="afInterval"/>
				<p class="afP afValue">1. Сведения о страхователе</p>
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afC">Регистрационный номер в СФР</div>
					<div class="afCol-1-2">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 3, 1)"/>
								</td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 7, 1)"/>
								</td>
								<td>&#160;-&#160;</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 12, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 13, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($RegNumISH, 14, 1)"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afCol-1-5 afCenterBlock">ИНН</div>
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<tr>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 1, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 2, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 3, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 4, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 5, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 6, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 7, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 8, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 9, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 10, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 11, 1)"/>
								</td>
								<td class="afCheckSmall">
									<xsl:value-of select="substring($NumINNISH, 12, 1)"/>
								</td>
							</tr>
						</table>
					</div>
					<div class="afCol-1-5 afCenterBlock">КПП</div>
					<div class="afCol-3-10">
						<table class="afTableCollapse">
							<xsl:choose>
								<xsl:when test="ns1:Страхователь/УТ6:КПП">
									<tr>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 1, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 2, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 3, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 4, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 5, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 6, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 7, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 8, 1)"/>
										</td>
										<td class="afCheckSmall">
											<xsl:value-of select="substring($NumKPPISH, 9, 1)"/>
										</td>
									</tr>
								</xsl:when>
								<xsl:otherwise>
									<tr>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
										<td class="afCheckSmall">&#160;</td>
									</tr>
								</xsl:otherwise>
							</xsl:choose>
						</table>
					</div>
				</div>
				<div class="afRow">
					<div class="afC">Наименование (краткое)</div>
					<div class="afCol-2-3 afValue afUnderlinedBlock">
						<xsl:value-of select="/ns1:ЭДСФР/ns1:СЗВ-ИСХ/ns1:Страхователь/ИС6:Наименование"/>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">2. Сведения о застрахованном лице</p>
					<p class="afInterval"/>
					<table class="afTable afTable100 afSmallSize">
						<tr class="afCenter">
							<td>Фамилия</td>
							<td>Имя</td>
							<td>Отчество</td>
							<td>СНИЛС</td>
						</tr>
						<tr class="afHeightRow afSmallSize afCenter">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
						</tr>
						<tr>
							<td>
								<xsl:value-of select="ns1:ФИО/УТ6:Фамилия"/>
							</td>
							<td>
								<xsl:value-of select="ns1:ФИО/УТ6:Имя"/>
							</td>
							<td>
								<xsl:value-of select="ns1:ФИО/УТ6:Отчество"/>
							</td>
							<td>
								<xsl:value-of select="ns1:СНИЛС"/>
							</td>
						</tr>
					</table>
					<p class="afInterval"/>
					<div class="afRow">
						<div class="afC">Сведения об увольнении застрахованного лица</div>
						<div class="afCol-1-4 afValue afUnderlinedBlock">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate" select="//ns1:ДатаУвольнения"/>
							</xsl:call-template>
						</div>
					</div>
					<div class="afRow">
						<div class="afC">Номер договора</div>
						<xsl:choose>
							<xsl:when test="ns1:Договор/ns1:Реквизиты/УТ6:Номер">
								<div class="afCol-1-4 afValue afUnderlinedBlock">
									<xsl:value-of select="ns1:Договор/ns1:Реквизиты/УТ6:Номер"/>
								</div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afCol-1-4 afBlankUnderlinedBlock"/>
							</xsl:otherwise>
						</xsl:choose>
					</div>
					<div class="afRow">
						<div class="afC">Дата заключения договора</div>
						<xsl:choose>
							<xsl:when test="ns1:Договор/ns1:Реквизиты/УТ6:Дата">
								<div class="afCol-1-4 afValue afUnderlinedBlock">
									<xsl:call-template name="DateShortStr">
										<xsl:with-param name="pDate" select="ns1:Договор/ns1:Реквизиты/УТ6:Дата"/>
									</xsl:call-template>
								</div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afCol-1-4 afBlankUnderlinedBlock"/>
							</xsl:otherwise>
						</xsl:choose>
					</div>
					<div class="afRow">
						<div class="afC">Тип договора</div>
						<xsl:choose>
							<xsl:when test="ns1:Договор/ns1:Тип">
								<div class="afCol-1-4 afValue afUnderlinedBlock">
									<xsl:call-template name="TypeContract">
										<xsl:with-param name="pTypeContract" select="ns1:Договор/ns1:Тип"/>
									</xsl:call-template>
								</div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afCol-1-4 afBlankUnderlinedBlock"/>
							</xsl:otherwise>
						</xsl:choose>
					</div>
					<div class="afRow">
						<div class="afC">Код дополнительного тарифа</div>
						<xsl:choose>
							<xsl:when test="ns1:КодДТ">
								<div class="afCol-1-4 afValue afUnderlinedBlock">
									<xsl:value-of select="ns1:КодДТ"/>
								</div>
							</xsl:when>
							<xsl:otherwise>
								<div class="afCol-1-4 afBlankUnderlinedBlock"/>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">3. Отчетный период</p>
					<div class="afRow50">
						<div class="afC">Отчетный период (код)</div>
						<div class="afCol-1-10 afFrame afPadding">
							<xsl:value-of select="ns1:ОтчетныйПериод/ns1:Код"/>
						</div>
						<div class="afC">Календарный год</div>
						<div class="afCol-1-10 afFrame afPadding">
							<xsl:value-of select="ns1:ОтчетныйПериод/ns1:Год"/>
						</div>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">4. Сведения о сумме выплат и иных вознаграждений, начисленных в пользу физического лица</p>
					<p class="afInterval"/>
					<table class="afTable afSmallSize">
						<tr class="afCenter">
							<td rowspan="3">Месяц</td>
							<td rowspan="3">Код категории застрахованного лица</td>
							<td rowspan="3">Сумма заработка (вознаграждения), дохода, выплат и иных вознаграждений, начисленных в пользу застрахованного лица</td>
							<td colspan="4">в том числе, на которую начислены страховые взносы на обязательное пенсионное страхование:</td>
						</tr>
						<tr class="afCenter">
							<td colspan="2">входящих в базу для начисления страховых взносов, не превышающую предельную</td>
							<td colspan="2">входящих в базу для начисления страховых взносов, превышающую предельную</td>
						</tr>
						<tr class="afCenter">
							<td>всего:</td>
							<td>в том числе по гражданско-правовым договорам</td>
							<td>всего:</td>
							<td>в том числе по гражданско-правовым договорам</td>
						</tr>
						<tr class="afHeightRow afCenter afSmallSize">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
							<td>6</td>
							<td>7</td>
						</tr>
						<xsl:choose>
							<xsl:when test="ns1:Выплаты">
								<xsl:for-each select="ns1:Выплаты/ns1:Период">
									<tr class="afAlignRight">
										<td class="afCenter">
											<xsl:value-of select="./ns1:Месяц"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:Категория"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:СуммаВыплат"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:НеПревышающие/ns1:Всего"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:НеПревышающие/ns1:ПоГПД"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:Превышающие/ns1:Всего"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:Превышающие/ns1:ПоГПД"/>
										</td>
									</tr>
								</xsl:for-each>
								<tr class="afAlignRight">
									<td>Итого:</td>
									<td>
										<xsl:value-of select="ns1:Выплаты/ns1:Всего/ns1:Категория"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Выплаты/ns1:Всего/ns1:СуммаВыплат"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Выплаты/ns1:Всего/ns1:НеПревышающие/ns1:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Выплаты/ns1:Всего/ns1:НеПревышающие/ns1:ПоГПД"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Выплаты/ns1:Всего/ns1:Превышающие/ns1:Всего"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Выплаты/ns1:Всего/ns1:Превышающие/ns1:ПоГПД"/>
									</td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<tr class="afHeightBlankRow">
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
								</tr>
								<tr class="afAlignRight">
									<td>Итого:</td>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">5. Сведения о начисленных страховых взносах за отчетный период</p>
					<p class="afInterval"/>
					<table class="afTable afSmallSize">
						<tr class="afCenter">
							<td>Уплачиваемые страхователем</td>
							<td>Уплачиваемые из заработка застрахованного лица</td>
							<td>По тарифу</td>
							<td>По дополнительному тарифу</td>
							<td>На страховую пенсию</td>
							<td>На накопительную пенсию</td>
							<td>По тарифу страховых взносов на сумму выплат и иных вознаграждений, входящих в базу, не превышающую предельную</td>
						</tr>
						<tr class="afHeightRow afCenter afSmallSize">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
							<td>6</td>
							<td>7</td>
						</tr>
						<xsl:choose>
							<xsl:when test="ns1:Начисления">
								<tr>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:СВстрахователя"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:СВизЗаработка"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:СВпоТарифу"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:СВпоДопТарифу"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:Накопительная"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Начисления/ns1:СВпоТарифуНеПревышающие"/>
									</td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<tr class="afHeightBlankRow">
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">6. Сведения об уплаченных страховых взносах (для отчетных периодов 2010-2013 гг.)</p>
					<p class="afInterval"/>
					<table class="afTable afTable100 afSmallSize">
						<tr class="afCenter">
							<td>На страховую пенсию</td>
							<td>На накопительную пенсию</td>
						</tr>
						<xsl:choose>
							<xsl:when test="ns1:Уплата">
								<tr>
									<td>
										<xsl:value-of select="ns1:Уплата/ns1:Страховая"/>
									</td>
									<td>
										<xsl:value-of select="ns1:Уплата/ns1:Накопительная"/>
									</td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<tr class="afHeightBlankRow">
									<td/>
									<td/>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">7. Сведения о сумме выплат и иных вознаграждений в пользу физического лица, занятого на соответствующих видах работ, с которых начислены страховые взносы по
					дополнительному тарифу</p>
					<p class="afInterval"/>
					<table class="afTable afSmallSize">
						<tr class="afCenter">
							<td>Месяц</td>
							<td>Код специальной оценки условий труда</td>
							<td>Сумма выплат и иных вознаграждений, начисленных в пользу физического лица, занятого на видах работ, указанных в пункте 1 части 1 статьи 30 Федерального закона от 28 декабря
							2013 года № 400-ФЗ "О страховых пенсиях"</td>
							<td>Сумма выплат и иных вознаграждений, начисленных в пользу физического лица, занятого на видах работ, указанных в пунктах 2-18 части 1 статьи 30 Федерального закона от 28 декабря
							2013 года № 400-ФЗ "О страховых пенсиях"</td>
						</tr>
						<tr class="afHeightRow afCenter afSmallSize">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
						</tr>
						<xsl:choose>
							<xsl:when test="ns1:ВыплатыДТ">
								<tr>
									<td class="afCenter">всего за последние три месяца отчетного периода, в том числе:</td>
									<td/>
									<td>
										<xsl:value-of select="ns1:ВыплатыДТ/ns1:Всего/ИС6:ДопТарифП1"/>
									</td>
									<td>
										<xsl:value-of select="ns1:ВыплатыДТ/ns1:Всего/ИС6:ДопТарифП2_18"/>
									</td>
								</tr>
								<xsl:for-each select="ns1:ВыплатыДТ/ns1:Период">
									<tr>
										<td>
											<xsl:value-of select="./ns1:Месяц"/>
										</td>
										<td>
											<xsl:value-of select="./ns1:КодСОУТ"/>
										</td>
										<td>
											<xsl:value-of select="./ИС6:ДопТарифП1"/>
										</td>
										<td>
											<xsl:value-of select="./ИС6:ДопТарифП2_18"/>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td class="afCenter">всего за последние три месяца отчетного периода, в том числе:</td>
									<td/>
									<td/>
									<td/>
								</tr>
								<tr class="afHeightBlankRow">
									<td/>
									<td/>
									<td/>
									<td/>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
				<p class="afInterval"/>
				<div class="afNoBreakInside">
					<p class="afP afValue">8. Периоды работы застрахованного лица</p>
					<p class="afInterval"/>
					<table class="afTable afSmallSize">
						<tr class="afCenter">
							<td rowspan="2">№ п/п</td>
							<td rowspan="2">Начало периода с (дд.мм.гггг.)</td>
							<td rowspan="2">Конец периода по (дд.мм.гггг)</td>
							<td rowspan="2">Территориальные условия (код)</td>
							<td rowspan="2">Особые условия труда (код)</td>
							<td colspan="2">Исчисление страхового стажа</td>
							<td colspan="2">Условия досрочного назначения страховой пенсии</td>
						</tr>
						<tr class="afCenter">
							<td>Основание (код)</td>
							<td>Дополнительные сведения</td>
							<td>Основание (код)</td>
							<td>Дополнительные сведения</td>
						</tr>
						<tr class="afCenter afHeightRow afSmallSize">
							<td>1</td>
							<td>2</td>
							<td>3</td>
							<td>4</td>
							<td>5</td>
							<td>6</td>
							<td>7</td>
							<td>8</td>
							<td>9</td>
						</tr>
						<xsl:choose>
							<xsl:when test="ns1:СтажевыйПериод">
								<xsl:for-each select="ns1:СтажевыйПериод">
									<xsl:variable name="vLines">
										<xsl:choose>
											<xsl:when test="count(ИС6:ЛьготныйСтаж) > 1">
												<xsl:value-of select="count(ИС6:ЛьготныйСтаж)"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="1"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									
									<xsl:variable name="vPos" select="position()"/>
									<xsl:choose>
										<xsl:when test="$vLines > 1">
											<xsl:for-each select="ИС6:ЛьготныйСтаж">
												<tr>
													<xsl:if test="position() = 1">
														<td rowspan="{$vLines}">
															<xsl:value-of select="$vPos"/>
														</td>
														
														<td rowspan="{$vLines}">
															<xsl:call-template name="DateShortStr">
																<xsl:with-param name="pDate" select="../ИС6:Период/УТ6:С"/>
															</xsl:call-template>
														</td>
														<td rowspan="{$vLines}">
															<xsl:call-template name="DateShortStr">
																<xsl:with-param name="pDate" select="../ИС6:Период/УТ6:По"/>
															</xsl:call-template>
														</td>
													</xsl:if>
													
													<td>
														<p class="afP">
															<xsl:value-of select="concat(./ИС6:ТУ/ИС6:Основание, ' ', ./ИС6:ТУ/ИС6:Коэффициент)"/>
														</p>
													</td>
													<td>
														<p class="afP">
															<xsl:value-of select="./ИС6:ОУТ"/>
														</p>
													</td>
													<td>
														<p class="afP">
															<xsl:value-of select="./ИС6:ИС/ИС6:Основание"/>
														</p>
													</td>
													<td>
														<p class="afP">
															<xsl:call-template name="УТ6:ProductionStr">
																<xsl:with-param name="pProduction" select="./ИС6:ИС"/>
															</xsl:call-template>
															<xsl:value-of select="./ИС6:ДопСведенияИС"/>
														</p>
													</td>
													<td>
														<p class="afP">
															<xsl:value-of select="./ИС6:ВЛ/ИС6:Основание"/>
														</p>
													</td>
													<td>
														<p class="afP">
															<xsl:call-template name="УТ6:ProductionStr">
																<xsl:with-param name="pProduction" select="./ИС6:ВЛ"/>
															</xsl:call-template>
															<xsl:value-of select="./ИС6:ВЛ/ИС6:ДоляСтавки"/>
														</p>
													</td>
												</tr>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<tr>
												<td>
													<xsl:value-of select="$vPos"/>
												</td>
												<td>
													<xsl:call-template name="DateShortStr">
														<xsl:with-param name="pDate" select="ИС6:Период/УТ6:С"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:call-template name="DateShortStr">
														<xsl:with-param name="pDate" select="ИС6:Период/УТ6:По"/>
													</xsl:call-template>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="concat(ИС6:ЛьготныйСтаж/ИС6:ТУ/ИС6:Основание, ' ', ИС6:ЛьготныйСтаж/ИС6:ТУ/ИС6:Коэффициент)"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ОУТ"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ИС/ИС6:Основание"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:call-template name="УТ6:ProductionStr">
															<xsl:with-param name="pProduction" select="ИС6:ЛьготныйСтаж/ИС6:ИС"/>
														</xsl:call-template>
														<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ДопСведенияИС"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ВЛ/ИС6:Основание"/>
													</p>
												</td>
												<td>
													<p class="afP">
														<xsl:call-template name="УТ6:ProductionStr">
															<xsl:with-param name="pProduction" select="ИС6:ЛьготныйСтаж/ИС6:ВЛ"/>
														</xsl:call-template>
														<xsl:value-of select="ИС6:ЛьготныйСтаж/ИС6:ВЛ/ИС6:ДоляСтавки"/>
													</p>
												</td>
											</tr>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<tr class="afHeightBlankRow">
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
									<td/>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
			</xsl:for-each>
			<div class="afNoBreakBefore afNoBreakInside">
				<p class="afInterval"/>
				<div class="afRow">
					<div class="afCol-1-3">
						<p class="afValue afUnderlinedBlock">
							<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:Должность"/>
						</p>
						<p class="afCenter afSubscriptNormal">Наименование должности руководителя</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-1-5">
						<p class="afBlankUnderlinedBlock"/>
						<p class="afCenter afSubscriptNormal">Подпись</p>
					</div>
					<div class="afCol-2">&#160;</div>
					<div class="afCol-4-10">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="УТ6:NameStr">
								<xsl:with-param name="pName" select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:Руководитель/ns1:ФИО"/>
							</xsl:call-template>
						</p>
						<p class="afCenter afSubscriptNormal">Ф.И.О.</p>
					</div>
				</div>
				<p class="afInterval"/>
				<div class="afSign">
					<div class="afPadding">
						<p class="afUnderlinedBlock afValue">
							<xsl:call-template name="DateShortStr">
								<xsl:with-param name="pDate">
									<xsl:value-of select="/ns1:ЭДСФР/ns1:ОДВ-1/ns1:ДатаЗаполнения"/>
								</xsl:with-param>
							</xsl:call-template>
						</p>
						<p class="afP afCenter afSubscriptNormal">Дата (дд.мм.гггг)</p>
					</div>
					<div class="afPadding">М.П. (при наличии)</div>
					<div class="afPadding"/>
				</div>
			</div>
			<p class="afInterval"/>
			<div class="afNoBreakInside">
				<xsl:if test="/ns1:ЭДСФР/sig:SignInfo">
					<xsl:call-template name="PrintSignInfo">
						<xsl:with-param name="pSignature" select="/ns1:ЭДСФР/sig:SignInfo"/>
					</xsl:call-template>
				</xsl:if>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="TypeContract">
		<xsl:param name="pTypeContract"/>
		<xsl:choose>
			<xsl:when test="$pTypeContract = '1'">трудовой</xsl:when>
			<xsl:when test="$pTypeContract = '2'">гражданско-правовой</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Выработка -->
	<xsl:template name="УТ6:ProductionStr">
		<xsl:param name="pProduction"/>
		<xsl:if test="$pProduction">
			<xsl:if test="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы">
				<xsl:value-of select="$pProduction//ВС2:ВыработкаВчасах/ВС2:Часы"/> ч.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты">
				<xsl:value-of select="$pProduction/ВС2:ВыработкаВчасах/ВС2:Минуты"/> мин.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы">
				<xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеМесяцы"/> мес.&#160;</xsl:if>
			<xsl:if test="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни">
				<xsl:value-of select="$pProduction/ВС2:ВыработкаКалендарная/ВС2:ВсеДни"/> д.&#160; </xsl:if>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
